/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.desktop;

import com.install4j.api.ApplicationRegistry;
import com.install4j.api.Util;
import com.install4j.api.context.Context;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.LauncherSetup;
import com.install4j.api.context.LauncherType;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.beans.actions.SystemInstallAction;
import com.install4j.runtime.beans.screens.components.ProgramGroupEntryConfig;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.InstallerVariables;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.frontend.components.ProgramGroupSelector;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.MenuHelper;
import com.install4j.runtime.installer.helper.fileinst.FileInstaller;
import com.install4j.runtime.installer.platform.unix.UnixFileSystem;
import com.install4j.runtime.installer.platform.win32.FolderInfo;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class CreateProgramGroupAction
extends SystemInstallAction {
    public static final String VARIABLE_NAME = "sys.programGroup.name";
    public static final String VARIABLE_ENABLED = "sys.programGroup.enabled";
    public static final String VARIABLE_LINK_DIR = "sys.programGroup.linkDir";
    public static final String VARIABLE_ALL_USERS = "sys.programGroup.allUsers";
    private boolean enabled = true;
    private String programGroupName = "";
    private boolean allUsers = true;
    private boolean addUninstaller = true;
    private boolean addDefaultLauncherLinks = true;
    private String linkDirectory = "/usr/local/bin";
    private String categories = "Application";
    private boolean unixSymlinks = true;
    private boolean failForSymlinksNotCreated = false;
    private boolean unixMenuEntries = true;
    private List programGroupEntryConfigs = new ArrayList();
    private boolean usedDefaultValue = true;
    private boolean nameEdited = false;

    public void init(Context context) {
        Object object = InstallerVariables.getVariable(VARIABLE_NAME);
        if (object != null && object instanceof String) {
            this.setProgramGroupName((String)object);
            this.usedDefaultValue = false;
        }
        this.nameEdited = false;
        InstallerVariables.registerVariableProvider(VARIABLE_NAME, new InstallerVariables.VariableProvider(){

            public Object getVariable() {
                return CreateProgramGroupAction.this.getProgramGroupName();
            }

            public void setVariable(Object object) {
                if (object != null && object instanceof String) {
                    CreateProgramGroupAction.this.setProgramGroupName((String)object);
                    CreateProgramGroupAction.this.usedDefaultValue = false;
                    ProgramGroupSelector.resetSelectors();
                }
            }
        });
        object = InstallerVariables.getVariable(VARIABLE_ENABLED);
        if (object != null && object instanceof Boolean) {
            this.setEnabled((Boolean)object);
        }
        InstallerVariables.registerVariableProvider(VARIABLE_ENABLED, new InstallerVariables.VariableProvider(){

            public Object getVariable() {
                return CreateProgramGroupAction.this.isEnabled() ? Boolean.TRUE : Boolean.FALSE;
            }

            public void setVariable(Object object) {
                if (object != null && object instanceof Boolean) {
                    CreateProgramGroupAction.this.setEnabled((Boolean)object);
                }
            }
        });
        object = InstallerVariables.getVariable(VARIABLE_LINK_DIR);
        if (object != null && object instanceof String) {
            this.setLinkDirectory((String)object);
        }
        InstallerVariables.registerVariableProvider(VARIABLE_LINK_DIR, new InstallerVariables.VariableProvider(){

            public Object getVariable() {
                return CreateProgramGroupAction.this.getLinkDirectory();
            }

            public void setVariable(Object object) {
                if (object != null && object instanceof String) {
                    CreateProgramGroupAction.this.setLinkDirectory((String)object);
                }
            }
        });
        object = InstallerVariables.getVariable(VARIABLE_ALL_USERS);
        if (object != null && object instanceof Boolean) {
            this.setAllUsers((Boolean)object);
        }
        InstallerVariables.registerVariableProvider(VARIABLE_ALL_USERS, new InstallerVariables.VariableProvider(){

            public Object getVariable() {
                return CreateProgramGroupAction.this.isAllUsers() ? Boolean.TRUE : Boolean.FALSE;
            }

            public void setVariable(Object object) {
                if (object != null && object instanceof Boolean) {
                    CreateProgramGroupAction.this.setAllUsers((Boolean)object);
                }
            }
        });
        InstallerVariables.registerVariableProvider("sys.programGroupDir", new InstallerVariables.VariableProvider(){

            public Object getVariable() {
                if (CreateProgramGroupAction.this.isEnabled()) {
                    if (Util.isWindowsInstaller()) {
                        return new File(FolderInfo.getSpecialFolder(3, CreateProgramGroupAction.this.isAllUsers()), CreateProgramGroupAction.this.getProgramGroupName()).getAbsolutePath();
                    }
                    if (Util.isUnixInstaller()) {
                        return CreateProgramGroupAction.this.getLinkDirectory();
                    }
                }
                return null;
            }

            public void setVariable(Object object) {
            }
        });
    }

    public boolean install(InstallerContext installerContext) throws UserCanceledException {
        if (!this.nameEdited) {
            this.updateProgramGroupName(installerContext);
        }
        boolean bl = true;
        try {
            if (this.isEnabled()) {
                ((ContextImpl)((Object)installerContext)).getInstallationProperties().setProgramGroup(this.getProgramGroupName());
                if (InstallerUtil.isWindows()) {
                    this.installWindows(installerContext);
                } else if (!InstallerUtil.isMacOS()) {
                    bl = this.installUnix(installerContext);
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
        return bl;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public boolean isAddUninstaller() {
        return this.addUninstaller;
    }

    public void setAddUninstaller(boolean bl) {
        this.addUninstaller = bl;
    }

    public boolean isAddDefaultLauncherLinks() {
        return this.addDefaultLauncherLinks;
    }

    public void setAddDefaultLauncherLinks(boolean bl) {
        this.addDefaultLauncherLinks = bl;
    }

    public String getCategories() {
        return CreateProgramGroupAction.replaceVariables(this.categories);
    }

    public void setCategories(String string) {
        this.categories = string;
    }

    public String getProgramGroupName() {
        return CreateProgramGroupAction.replaceVariables(this.programGroupName);
    }

    public void setProgramGroupName(String string) {
        this.programGroupName = string;
        this.nameEdited = true;
    }

    public boolean isAllUsers() {
        return this.allUsers;
    }

    public void setAllUsers(boolean bl) {
        this.allUsers = bl;
    }

    public String getLinkDirectory() {
        return CreateProgramGroupAction.replaceVariables(this.linkDirectory);
    }

    public void setLinkDirectory(String string) {
        this.linkDirectory = string;
    }

    public List getProgramGroupEntryConfigs() {
        return this.programGroupEntryConfigs;
    }

    public void setProgramGroupEntryConfigs(List list) {
        this.programGroupEntryConfigs = list;
    }

    public boolean isUnixSymlinks() {
        return this.unixSymlinks;
    }

    public void setUnixSymlinks(boolean bl) {
        this.unixSymlinks = bl;
    }

    public boolean isFailForSymlinksNotCreated() {
        return this.failForSymlinksNotCreated;
    }

    public void setFailForSymlinksNotCreated(boolean bl) {
        this.failForSymlinksNotCreated = bl;
    }

    public boolean isUnixMenuEntries() {
        return this.unixMenuEntries;
    }

    public void setUnixMenuEntries(boolean bl) {
        this.unixMenuEntries = bl;
    }

    private boolean installUnix(InstallerContext installerContext) throws IOException, UserCanceledException {
        FileInstaller fileInstaller = FileInstaller.getInstance();
        boolean bl = true;
        Iterator iterator = installerContext.getLaunchers().iterator();
        while (iterator.hasNext()) {
            File file;
            File file2;
            LauncherSetup launcherSetup = (LauncherSetup)iterator.next();
            if (launcherSetup.isUninstaller() || !(file2 = installerContext.getDestinationFile(launcherSetup.getRelativeFileName())).exists()) continue;
            boolean bl2 = launcherSetup.isExcludeFromMenu();
            if (this.unixMenuEntries && !bl2 && (launcherSetup.getType() == LauncherType.GUI || launcherSetup.getType() == LauncherType.EXTERNAL)) {
                MenuHelper.installUnixMenu(installerContext.getInstallationDirectory(), file2, launcherSetup.getName(), this.getCategories(), null);
            }
            if (!this.unixSymlinks || bl2 || this.getLinkDirectory() == null || this.getLinkDirectory().trim().length() <= 0 || (file = new File(this.getLinkDirectory()).getCanonicalFile()).equals(file2.getParentFile().getCanonicalFile())) continue;
            fileInstaller.createDirectory(file);
            File file3 = new File(file, file2.getName());
            boolean bl3 = UnixFileSystem.createLink(file2.getAbsolutePath(), file3);
            if (this.failForSymlinksNotCreated && !bl3) {
                bl = false;
            }
            fileInstaller.registerUninstallFile(file3);
        }
        try {
            Runtime.getRuntime().exec("kbuildsycoca");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bl;
    }

    private void installWindows(InstallerContext installerContext) throws UserCanceledException, IOException {
        Object object;
        File file;
        Object object2;
        File file2 = FolderInfo.getSpecialFolder(3, this.isAllUsers());
        if (this.getProgramGroupName().trim().length() > 0) {
            file2 = new File(file2, this.getProgramGroupName());
        }
        Iterator iterator = installerContext.getLaunchers().iterator();
        while (iterator.hasNext()) {
            object2 = (LauncherSetup)iterator.next();
            if (object2.isExcludeFromMenu() || object2.isUninstaller() && !this.isAddUninstaller() || !(file = installerContext.getDestinationFile(CreateProgramGroupAction.replaceVariables(object2.getRelativeFileName()))).exists()) continue;
            object = object2.isUninstaller() ? MessageFormat.format(Messages.getMessages().getString("UninstallerMenuEntry"), InstallerConfig.getCurrentInstance().getApplicationName()) : object2.getName();
            MenuHelper.installWindowsMenu(new File(file2, (String)object), file, null);
        }
        iterator = this.getProgramGroupEntryConfigs().iterator();
        while (iterator.hasNext()) {
            object2 = (ProgramGroupEntryConfig)iterator.next();
            if (((ProgramGroupEntryConfig)object2).isFolder()) continue;
            file = installerContext.getExternalFile(((ProgramGroupEntryConfig)object2).getIconFile(), true);
            object = installerContext.getDestinationFile(CreateProgramGroupAction.replaceVariables(((ProgramGroupEntryConfig)object2).getTarget()));
            if (!((File)object).exists()) continue;
            MenuHelper.installWindowsMenu(new File(file2, ((ProgramGroupEntryConfig)object2).getName()), (File)object, file, CreateProgramGroupAction.replaceVariables(((ProgramGroupEntryConfig)object2).getArguments()), null);
        }
    }

    public void updateProgramGroupName(Context context) {
        this.nameEdited = true;
        if (this.usedDefaultValue) {
            String string;
            ApplicationRegistry.ApplicationInfo applicationInfo;
            InstallerConfig installerConfig = InstallerConfig.getCurrentInstance();
            if (InstallerUtil.isWindows() && installerConfig.isSuggestPreviousProgramGroup() && context.getVariable("sys.responseFile") == null && (applicationInfo = ApplicationRegistry.getApplicationInfoByDir(context.getInstallationDirectory())) != null && installerConfig.getTargetApplicationId().equals(applicationInfo.getId()) && (string = applicationInfo.getProgramGroup()) != null && string.trim().length() > 0) {
                this.setProgramGroupName(string);
            }
        }
    }
}

