/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.files;

import com.install4j.api.context.Context;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.beans.actions.SystemInstallOrUninstallAction;
import com.install4j.runtime.beans.actions.files.BackupFileForRollbackAction;
import com.install4j.runtime.installer.helper.Logger;
import java.io.File;
import java.io.IOException;

public abstract class AbstractModifyFileAction
extends SystemInstallOrUninstallAction {
    private File file = null;

    protected abstract boolean modifyFile(File var1, Context var2) throws IOException;

    public File getFile() {
        return AbstractModifyFileAction.replaceVariables(this.file);
    }

    public void setFile(File file) {
        this.file = file;
    }

    public boolean execute(Context context) throws UserCanceledException {
        File file = context.getDestinationFile(this.getFile());
        try {
            if (this.fileMustExist() && !file.exists()) {
                Logger.getInstance().error(this, "The file " + file.getAbsolutePath() + " does not exist.");
                return false;
            }
            if (context instanceof InstallerContext) {
                BackupFileForRollbackAction backupFileForRollbackAction = new BackupFileForRollbackAction(file, false);
                backupFileForRollbackAction.install((InstallerContext)context);
                this.addRollbackAction(backupFileForRollbackAction);
            }
            return this.modifyFile(file, context);
        }
        catch (IOException iOException) {
            Logger.getInstance().log(iOException);
            return false;
        }
    }

    protected boolean fileMustExist() {
        return true;
    }

    protected Object maybeFilterLogReplacement(String string, String string2, Object object, boolean bl) {
        if (string.equals(string2) && !bl) {
            return "[logging of replacement text is disabled]";
        }
        return object;
    }
}

