/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.files;

import com.install4j.api.context.FileOptions;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.OverwriteMode;
import com.install4j.api.context.ProgressInterface;
import com.install4j.api.context.UninstallMode;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.events.InstallerEventListener;
import com.install4j.runtime.beans.actions.InstallFilesAction;
import com.install4j.runtime.beans.actions.SystemInstallAction;
import com.install4j.runtime.installer.frontend.ProgressAdapter;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.fileinst.FileInstaller;
import com.install4j.runtime.installer.platform.unix.UnixFileSystem;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;

public class InstallExternalZipFileAction
extends SystemInstallAction {
    private File zipFile;
    private File destinationDirectory;
    private OverwriteMode overwriteMode = OverwriteMode.ALWAYS_ASK_EXCEPT_FOR_UPDATE;
    private String mode = "644";
    private String dirMode = "755";
    private boolean shared = false;
    private UninstallMode uninstallMode = UninstallMode.IF_CREATED;
    private boolean showProgress = true;
    private static final String DEFAULT_DIR_MODE = "755";
    private boolean delay = false;
    private boolean triggerReboot = true;

    public boolean isDelay() {
        return this.delay;
    }

    public void setDelay(boolean bl) {
        this.delay = bl;
    }

    public boolean isTriggerReboot() {
        return this.triggerReboot;
    }

    public void setTriggerReboot(boolean bl) {
        this.triggerReboot = bl;
    }

    public boolean isShowProgress() {
        return this.showProgress;
    }

    public void setShowProgress(boolean bl) {
        this.showProgress = bl;
    }

    public File getZipFile() {
        return InstallExternalZipFileAction.replaceVariables(this.zipFile);
    }

    public void setZipFile(File file) {
        this.zipFile = file;
    }

    public File getDestinationDirectory() {
        return InstallExternalZipFileAction.replaceVariables(this.destinationDirectory);
    }

    public void setDestinationDirectory(File file) {
        this.destinationDirectory = file;
    }

    public OverwriteMode getOverwriteMode() {
        return this.overwriteMode;
    }

    public void setOverwriteMode(OverwriteMode overwriteMode) {
        this.overwriteMode = overwriteMode;
    }

    public String getMode() {
        return InstallExternalZipFileAction.replaceVariables(this.mode);
    }

    public void setMode(String string) {
        this.mode = string;
    }

    public String getDirMode() {
        return InstallExternalZipFileAction.replaceVariables(this.dirMode);
    }

    public void setDirMode(String string) {
        this.dirMode = string;
    }

    public boolean isShared() {
        return this.shared;
    }

    public void setShared(boolean bl) {
        this.shared = bl;
    }

    public UninstallMode getUninstallMode() {
        return this.uninstallMode;
    }

    public void setUninstallMode(UninstallMode uninstallMode) {
        this.uninstallMode = uninstallMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean install(InstallerContext installerContext) throws UserCanceledException {
        File file = installerContext.getDestinationFile(this.getZipFile());
        if (!file.exists()) {
            Logger.getInstance().error(this, file + " does not exist");
            return false;
        }
        File file2 = installerContext.getDestinationFile(this.getDestinationDirectory());
        InstallerEventListener installerEventListener = null;
        if (this.isTriggerReboot() && this.isDelay()) {
            installerEventListener = InstallFilesAction.addRebootTriggerListener(installerContext);
        }
        try {
            this.installZip(installerContext, file, file2);
            boolean bl = true;
            return bl;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            Logger.getInstance().error(this, "exception " + iOException);
            Logger.getInstance().log(iOException);
            boolean bl = false;
            return bl;
        }
        finally {
            if (installerEventListener != null) {
                installerContext.removeInstallerEventListener(installerEventListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void installZip(InstallerContext installerContext, File file, File file2) throws IOException, UserCanceledException {
        ProgressInterface progressInterface = installerContext.getProgressInterface();
        ArrayList arrayList = new ArrayList();
        long l = Long.MAX_VALUE;
        if (this.showProgress) {
            progressInterface.setPercentCompleted(0);
            progressInterface.setDetailMessage("");
            l = InstallExternalZipFileAction.getMaxProgress(file, arrayList);
        }
        FileInstaller fileInstaller = FileInstaller.getInstance();
        ZipInputStream zipInputStream = new ZipInputStream(new BufferedInputStream(new FileInputStream(file)));
        try {
            long l2 = 0L;
            int n = 0;
            ZipEntry zipEntry = zipInputStream.getNextEntry();
            while (zipEntry != null) {
                if (installerContext.isCancelling()) {
                    throw new UserCanceledException();
                }
                String string = InstallExternalZipFileAction.getEntryName(zipEntry);
                if (this.showProgress) {
                    progressInterface.setDetailMessage(InstallerUtil.cleanupName(string));
                }
                long l3 = l2 + 153600L;
                long l4 = arrayList.isEmpty() ? 0L : (Long)arrayList.get(n++);
                File file3 = new File(file2, string);
                if (zipEntry.isDirectory()) {
                    fileInstaller.createDirectory(file3, this.getUninstallMode());
                    file3.setLastModified(zipEntry.getTime());
                    if (!InstallerUtil.isWindows()) {
                        UnixFileSystem.setMode(this.getDirMode(), file3);
                    }
                } else {
                    l3 += l4;
                    ProgressAdapter progressAdapter = null;
                    if (this.showProgress) {
                        progressAdapter = new ProgressAdapter(progressInterface, (int)(l2 * 100L / l), (int)(l3 * 100L / l));
                    }
                    FileOptions fileOptions = new FileOptions(zipEntry.getTime(), this.getMode(), this.getOverwriteMode(), this.isShared(), this.isDelay(), this.getUninstallMode());
                    fileInstaller.install(zipInputStream, file3, fileOptions, progressAdapter, l4, false);
                }
                if (installerContext.isCancelling()) {
                    throw new UserCanceledException();
                }
                l2 = l3;
                if (this.showProgress) {
                    progressInterface.setPercentCompleted((int)(l2 * 100L / l));
                }
                zipEntry = zipInputStream.getNextEntry();
            }
        }
        finally {
            zipInputStream.close();
            if (this.showProgress) {
                progressInterface.setPercentCompleted(100);
                progressInterface.setDetailMessage("");
            }
        }
    }

    private static String getEntryName(ZipEntry zipEntry) {
        String string = zipEntry.getName();
        string = InstallerUtil.isWindows() ? string.replace('/', '\\') : string.replace('\\', '/');
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long getMaxProgress(File file, List list) throws IOException {
        long l = 0L;
        ZipFile zipFile = new ZipFile(file);
        try {
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                long l2 = zipEntry.isDirectory() ? 0L : zipEntry.getSize();
                list.add(new Long(l2));
                l += l2 + 153600L;
            }
            long l3 = l;
            return l3;
        }
        finally {
            zipFile.close();
        }
    }
}

