/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper;

import com.install4j.api.Util;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.screens.Console;
import com.install4j.runtime.beans.applications.Application;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.Logger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

public class ConsoleImpl
implements Console {
    private static final String EXE4J_PROP_CONSOLE_CODEPAGE = "exe4j.consoleCodepage";
    private static final String INSTALL4J_PROP_CONSOLE_ENCODING = "install4j.consoleEncoding";
    private static ConsoleImpl instance;
    private BufferedReader stdin;
    private PrintWriter stdout;
    private static final int HORIZONTAL_SIZE = 75;
    private static final int VERTICAL_SIZE = 25;
    private String lastStatusMessage;
    private Thread ioThread;
    static /* synthetic */ Class class$java$lang$System;

    public static ConsoleImpl getInstance() {
        if (instance == null) {
            instance = new ConsoleImpl();
        }
        return instance;
    }

    public ConsoleImpl() {
        String string = System.getProperty(INSTALL4J_PROP_CONSOLE_ENCODING);
        if (string == null) {
            string = System.getProperty(EXE4J_PROP_CONSOLE_CODEPAGE);
        }
        if (string == null) {
            this.stdout = new PrintWriter(new OutputStreamWriter(new FileOutputStream(FileDescriptor.out)));
            this.stdin = new BufferedReader(new InputStreamReader(new FileInputStream(FileDescriptor.in)));
        } else {
            try {
                this.stdout = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(FileDescriptor.out), string));
                this.stdin = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(FileDescriptor.in), string));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                this.stdout = new PrintWriter(new OutputStreamWriter(new FileOutputStream(FileDescriptor.out)));
                this.stdin = new BufferedReader(new InputStreamReader(new FileInputStream(FileDescriptor.in)));
            }
        }
    }

    public void waitForEnter() throws UserCanceledException {
        this.println("[" + this.getMessages().getString("ConsoleEnter") + "]");
        this.readLine();
    }

    public void printHeader(String string) {
        Application application = InstallerConfig.getCurrentApplication();
        try {
            ContextImpl.getSingleContextImpl().runScript(application.getConsoleScreenChangeHandler(), application, new Object[]{this, string});
        }
        catch (Exception exception) {
            Util.printAnnotatedStackTrace(exception);
            Logger.getInstance().log(exception);
        }
    }

    public void println() {
        this.println("");
    }

    public void more(String string) throws UserCanceledException {
        if (string == null) {
            this.stdout.println("null");
            this.stdout.flush();
            return;
        }
        int n = 0;
        boolean bl = false;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n\r", true);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.length() == 1 && string2.charAt(0) == '\n') {
                this.stdout.println();
                bl = true;
                if (++n % 23 != 0) continue;
                this.waitForEnter();
                continue;
            }
            if (string2.length() <= 1 && string2.charAt(0) == '\r') continue;
            bl = false;
            StringTokenizer stringTokenizer2 = new StringTokenizer(string2, " ");
            int n2 = 0;
            while (stringTokenizer2.hasMoreTokens()) {
                String string3 = stringTokenizer2.nextToken();
                if (n2 == 0 || n2 + string3.length() <= 75) {
                    if (n2 > 0) {
                        this.stdout.print(' ');
                        ++n2;
                    }
                } else {
                    this.stdout.print('\n');
                    n2 = 0;
                    if (++n % 23 == 0) {
                        this.waitForEnter();
                    }
                }
                this.stdout.print(string3);
                n2 += string3.length();
            }
        }
        if (!bl) {
            this.stdout.println();
        }
    }

    public void print(Object object) {
        if (object == null) {
            this.stdout.print("null");
        } else {
            this.stdout.print(object.toString());
        }
        this.stdout.flush();
    }

    public void println(Object object) {
        if (object == null) {
            this.stdout.println("null");
        } else {
            this.stdout.println(object.toString());
        }
        this.stdout.flush();
    }

    public String askWithDefault(String string, String string2) throws UserCanceledException {
        this.println(string);
        this.println("[" + string2 + "]");
        String string3 = this.readLine();
        if (string3.trim().length() == 0) {
            return string2;
        }
        return string3;
    }

    public boolean askYesNo(String string) throws UserCanceledException {
        return this.askOption(string, new String[]{this.getMessages().getString("ButtonYes"), this.getMessages().getString("ButtonNo")}, new String[]{"y", "n"}) == 0;
    }

    public boolean askYesNo(String string, boolean bl) throws UserCanceledException {
        return this.askOption(string, new String[]{this.getMessages().getString("ButtonYes"), this.getMessages().getString("ButtonNo")}, new String[]{"y", "n"}, bl ? 0 : 1) == 0;
    }

    public boolean askOkCancel(String string) throws UserCanceledException {
        return this.askOption(string, new String[]{this.getMessages().getString("ButtonOK"), this.getMessages().getString("ButtonCancel")}, new String[]{"o", "c"}) == 0;
    }

    public boolean askOkCancel(String string, boolean bl) throws UserCanceledException {
        return this.askOption(string, new String[]{this.getMessages().getString("ButtonOK"), this.getMessages().getString("ButtonCancel")}, new String[]{"o", "c"}, bl ? 0 : 1) == 0;
    }

    public String askString(String string, String string2) throws UserCanceledException {
        String string3;
        if (string != null && string.length() != 0) {
            this.println(string);
        }
        if (string2 != null) {
            this.println("[" + string2 + "]");
        }
        if ((string3 = this.readLine()).trim().length() == 0 && string2 != null) {
            return string2;
        }
        return string3;
    }

    public String askPassword(String string, String string2) throws UserCanceledException {
        String string3;
        if (string != null && string.length() != 0) {
            this.println(string);
        }
        if ((string3 = this.readLine(true)).trim().length() == 0 && string2 != null) {
            return string2;
        }
        return string3;
    }

    public int askOption(String string, String[] stringArray, String[] stringArray2) throws UserCanceledException {
        return this.askOption(string, stringArray, stringArray2, -1);
    }

    public int askOption(String string, String[] stringArray, String[] stringArray2, int n) throws UserCanceledException {
        return this.askOption(string, stringArray, stringArray2, n, false, false);
    }

    public int askOption(String string, String[] stringArray, String[] stringArray2, int n, boolean bl, boolean bl2) throws UserCanceledException {
        if (stringArray2 == null) {
            stringArray2 = this.getDefaultKeys(stringArray.length);
        }
        String string2 = this.getQuestion(stringArray, stringArray2, n, bl2);
        while (true) {
            if (string != null && string.length() != 0) {
                this.println(string);
            }
            this.println(string2);
            String string3 = this.readLine();
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray2[i].equals(string3)) continue;
                return i;
            }
            if (string3.trim().length() != 0) continue;
            if (n > -1) {
                return n;
            }
            if (bl) break;
        }
        return -1;
    }

    private String getQuestion(String[] stringArray, String[] stringArray2, int n, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i]);
            stringBuffer.append(" [");
            if (stringArray2[i].equals("")) {
                stringBuffer.append(this.getMessages().getString("ConsoleEnter"));
            } else {
                stringBuffer.append(stringArray2[i]);
                if (n == i) {
                    stringBuffer.append(", ");
                    stringBuffer.append(this.getMessages().getString("ConsoleEnter"));
                }
            }
            stringBuffer.append("]");
            if (i >= stringArray.length - 1) continue;
            if (bl) {
                stringBuffer.append("\n");
                continue;
            }
            stringBuffer.append(", ");
        }
        return stringBuffer.toString();
    }

    public int[] askMultipleSelection(String string, String[] stringArray, String[] stringArray2, int[] nArray, boolean bl) throws UserCanceledException {
        Object object;
        HashSet<Integer> hashSet;
        boolean bl2;
        if (stringArray2 == null) {
            stringArray2 = this.getDefaultKeys(stringArray.length);
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < nArray.length; ++i) {
            stringBuffer.append(stringArray2[nArray[i]]);
            if (i >= nArray.length - 1) continue;
            stringBuffer.append(",");
        }
        String string2 = this.getQuestion(stringArray, stringArray2, -1, bl);
        string2 = string2 + "\n" + this.getMessages().getString("ConsoleMultipleSelectionLabel");
        block1: do {
            if (string != null && string.length() != 0) {
                this.println(string);
            }
            String string3 = this.askString(string2, stringBuffer.toString());
            bl2 = true;
            hashSet = new HashSet<Integer>();
            object = new StringTokenizer(string3, ",");
            while (((StringTokenizer)object).hasMoreTokens()) {
                String string4 = ((StringTokenizer)object).nextToken().trim();
                boolean bl3 = false;
                for (int i = 0; i < stringArray2.length; ++i) {
                    if (!stringArray2[i].equals(string4)) continue;
                    hashSet.add(new Integer(i));
                    bl3 = true;
                    break;
                }
                if (bl3) continue;
                bl2 = false;
                continue block1;
            }
        } while (!bl2);
        object = new int[hashSet.size()];
        int n = 0;
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            object[n++] = (Integer)iterator.next();
        }
        return object;
    }

    private String[] getDefaultKeys(int n) {
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = String.valueOf(i + 1);
        }
        return stringArray;
    }

    public void setStatusMessage(String string) {
        if (string != null && !string.trim().equals("") && !string.equals(this.lastStatusMessage)) {
            this.println(string);
            this.lastStatusMessage = string;
        }
    }

    public void setDetailMessage(String string) {
        if (string != null && !string.trim().equals("")) {
            this.println("   " + string);
        }
    }

    public void setPercentCompleted(int n) {
    }

    public int getPercentCompleted() {
        return 0;
    }

    public void setIndeterminateProgress(boolean bl) {
    }

    public void showFailure(String string) {
        this.println("ERROR: " + string);
    }

    public int askOverwrite(File file) throws UserCanceledException {
        String string = file.getPath() + "\n" + this.getMessages().getString("FileExists");
        int n = this.askOption(string, new String[]{this.getMessages().getString("ButtonYes"), this.getMessages().getString("ButtonYesToAll"), this.getMessages().getString("ButtonNo"), this.getMessages().getString("ButtonNoToAll")}, new String[]{"y", "ya", "n", "na"});
        switch (n) {
            case 0: {
                return 2;
            }
            case 1: {
                return 3;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 4;
            }
        }
        return 1;
    }

    public int askRetry(File file) throws UserCanceledException {
        int n = this.askOption(MessageFormat.format(this.getMessages().getString("AskRetryInstallFile"), file.getPath()), new String[]{this.getMessages().getString("ButtonYes"), this.getMessages().getString("ButtonNo"), this.getMessages().getString("ButtonCancel")}, new String[]{"y", "n", "c"});
        switch (n) {
            case 0: {
                return 2;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 3;
            }
        }
        return 3;
    }

    public boolean askContinue(File file) throws UserCanceledException {
        int n = this.askOption(MessageFormat.format(this.getMessages().getString("AskContinue"), file.getPath()), new String[]{this.getMessages().getString("ButtonOK"), this.getMessages().getString("ButtonCancel")}, new String[]{"", "c"});
        return n == 0;
    }

    protected ResourceBundle getMessages() {
        return Messages.getMessages();
    }

    public void printStackTrace(Throwable throwable) {
        throwable.printStackTrace(this.stdout);
        this.stdout.flush();
    }

    public synchronized void cancel() {
        if (this.ioThread != null) {
            this.ioThread.interrupt();
        }
    }

    public String readLine() throws UserCanceledException {
        return this.readLine(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readLine(boolean bl) throws UserCanceledException {
        this.ioThread = Thread.currentThread();
        try {
            InputReaderThread inputReaderThread = new InputReaderThread(bl);
            inputReaderThread.start();
            try {
                inputReaderThread.join();
                String string = inputReaderThread.getResult();
                if (string == null) {
                    throw new UserCanceledException();
                }
                String string2 = string;
                return string2;
            }
            catch (InterruptedException interruptedException) {
                throw new UserCanceledException();
            }
        }
        finally {
            ConsoleImpl consoleImpl = this;
            synchronized (consoleImpl) {
                Thread.interrupted();
                this.ioThread = null;
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class InputReaderThread
    extends Thread {
        private String result;
        private boolean password;

        public InputReaderThread(boolean bl) {
            super("console input reader thread");
            this.password = bl;
        }

        public String getResult() {
            return this.result;
        }

        public void run() {
            try {
                if (this.password && !InstallerUtil.isUpToJava15()) {
                    if (!this.passwordRead()) {
                        this.defaultRead();
                    }
                } else {
                    this.defaultRead();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                this.result = "";
            }
            catch (Exception exception) {
                this.result = null;
            }
        }

        private boolean passwordRead() {
            try {
                Method method = (class$java$lang$System == null ? (class$java$lang$System = ConsoleImpl.class$("java.lang.System")) : class$java$lang$System).getMethod("console", null);
                Object object = method.invoke(null, null);
                if (object == null) {
                    return false;
                }
                Method method2 = object.getClass().getMethod("readPassword", null);
                this.result = new String((char[])method2.invoke(object, null));
                return true;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return false;
            }
        }

        private void defaultRead() throws IOException {
            int n;
            String string = ConsoleImpl.this.stdin.readLine();
            for (n = 0; n < string.length() && Character.isISOControl(string.charAt(n)); ++n) {
            }
            if (n > 0) {
                string = string.substring(n);
            } else if (n == string.length()) {
                string = "";
            }
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '\u007f') {
                    if (stringBuffer.length() <= 0) continue;
                    stringBuffer.setLength(stringBuffer.length() - 1);
                    continue;
                }
                stringBuffer.append(string.charAt(i));
            }
            this.result = stringBuffer.toString();
        }
    }
}

