/*
 * Decompiled with CFR 0.152.
 */
package gui;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class LZWCompression {
    private static final int BITS = 12;
    private static final int HASHING_SHIFT = 4;
    private static final int MAX_VALUE = 4095;
    private static final int MAX_CODE = 4094;
    private static final int TABLE_SIZE = 5021;
    private static final int EOF = -1;
    private BufferedInputStream input = null;
    private BufferedOutputStream output = null;
    private int output_bit_count = 0;
    private int output_bit_buffer = 0;
    private short[] code_value = new short[5021];
    private short[] prefix_code = new short[5021];
    private short[] append_character = new short[5021];

    LZWCompression(FileInputStream input, FileOutputStream output) {
        this.input = new BufferedInputStream(input);
        this.output = new BufferedOutputStream(output);
    }

    public void compress() {
        int next_code = 0;
        short character = 0;
        short string_code = 0;
        short index = 0;
        next_code = 256;
        for (int i = 0; i < 5021; i = (int)((short)(i + 1))) {
            this.code_value[i] = -1;
        }
        try {
            string_code = (short)this.input.read();
            while ((character = (short)this.input.read()) != -1) {
                index = this.find_match(string_code, character);
                if (this.code_value[index] != -1) {
                    string_code = this.code_value[index];
                    continue;
                }
                if (next_code <= 4094) {
                    int n = next_code;
                    next_code = (short)(next_code + 1);
                    this.code_value[index] = n;
                    this.prefix_code[index] = string_code;
                    this.append_character[index] = character;
                }
                this.output_code(string_code);
                string_code = character;
            }
            this.output_code(string_code);
            this.output_code((short)4095);
            this.output_code((short)0);
            this.output.close();
            this.input.close();
        }
        catch (IOException ioe) {
            System.out.println("IOException in compress()");
            System.exit(1);
        }
    }

    private short find_match(short hash_prefix, short hash_character) {
        int index = 0;
        int offset = 0;
        index = hash_character << 4 ^ hash_prefix;
        offset = index == 0 ? 1 : 5021 - index;
        while (this.code_value[index] != -1) {
            if (this.prefix_code[index] == hash_prefix && this.append_character[index] == hash_character) {
                return (short)index;
            }
            if ((index -= offset) >= 0) continue;
            index += 5021;
        }
        return (short)index;
    }

    private void output_code(short code) {
        this.output_bit_buffer |= code << 20 - this.output_bit_count;
        this.output_bit_count += 12;
        while (this.output_bit_count >= 8) {
            try {
                this.output.write(this.output_bit_buffer >> 24);
            }
            catch (IOException ioe) {
                System.out.println("IOException in output_code()");
                System.exit(1);
            }
            this.output_bit_buffer <<= 8;
            this.output_bit_count -= 8;
        }
    }
}

