/*
 * Decompiled with CFR 0.152.
 */
package gui.ibs;

import gui.Tools;
import gui.ibs.Component;
import gui.ibs.ComponentEnum;
import gui.ibs.EditDialog;
import gui.ibs.PreviewPanel;
import gui.ibs.ShapeEnum;
import gui.ibs.Verifier;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.LinkedList;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;

public class BracketDialog
extends EditDialog {
    private Component component;
    private String DELIMIT = "#&%";
    public ShapeEnum shapeType = ShapeEnum.SquareBracket;
    public String strNum = "";
    private ButtonGroup buttonGroup1;
    private JButton cancelButton;
    private JTextField centerTextFieldX;
    private JTextField centerTextFieldY;
    private JLabel colorLabel;
    private JPanel colorPanel;
    private JLabel endLabel;
    private JComboBox jComboBoxShape;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JLabel jLabelTip;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JRadioButton jRadioButton3;
    private JSpinner jSpinnerRotationAngle;
    private JSpinner jSpinnerStrokeSize;
    private JTextField jTextFieldID;
    private JPanel mainPanel;
    private JButton okButton;
    private JPanel previewPanel;
    private JLabel startLabel;
    private JLabel startLabel1;
    private JTextField wideTextField;

    public ShapeEnum getShapeType() {
        return this.shapeType;
    }

    public void setShapeType(ShapeEnum shapeType) {
        this.shapeType = shapeType;
    }

    public BracketDialog(Frame parent, String title, boolean modal, int proteinlenth, String fstrNum) {
        super(parent, title, modal);
        this.strNum = fstrNum;
        this.setPreferredSize(new Dimension(900, 380));
        this.initComponents();
        this.setTitle(title);
        String st = "Users can drag the element for absolute positioning, resize it and rotate it through the mouse.";
        this.jLabelTip.setText(st);
        int wh = (int)Math.round((double)proteinlenth * 10.0 / 100.0);
        this.wideTextField.setText(String.valueOf(wh));
        this.jTextFieldID.setText(this.strNum);
        Color bc = new Color(204, 204, 204);
        this.jTextFieldID.setForeground(bc);
        this.previewDraw();
        this.wideTextField.requestFocus();
        this.enableEvents(8L);
        InputMap inputMap = this.rootPane.getInputMap(2);
        inputMap.put(KeyStroke.getKeyStroke("ESCAPE"), "ESCAPE");
        this.rootPane.getActionMap().put("ESCAPE", new AbstractAction("ESCAPE"){

            @Override
            public void actionPerformed(ActionEvent e) {
                BracketDialog.this.cancelButton.doClick();
            }
        });
        inputMap.put(KeyStroke.getKeyStroke("ENTER"), "ENTER");
        this.rootPane.getActionMap().put("ENTER", new AbstractAction("ENTER"){

            @Override
            public void actionPerformed(ActionEvent e) {
                BracketDialog.this.okButton.doClick();
            }
        });
    }

    @Override
    public Component getComponent() {
        return this.component;
    }

    @Override
    public void setComponent(Component component) {
        this.colorPanel.setBackground(component.getColor());
        String[] arr = component.getParameter().split(this.DELIMIT);
        this.centerTextFieldX.setText(String.valueOf((int)component.getCenterx()));
        this.centerTextFieldY.setText(String.valueOf((int)component.getCentery()));
        this.wideTextField.setText(String.valueOf((int)component.getWide()));
        this.jSpinnerRotationAngle.setValue((int)component.getRotationAngle());
        this.shapeType = component.getShapeType();
        this.jSpinnerStrokeSize.setValue(Integer.valueOf(arr[0]));
        if (this.shapeType == ShapeEnum.Brace) {
            this.jComboBoxShape.setSelectedIndex(0);
        } else if (this.shapeType == ShapeEnum.SquareBracket) {
            this.jComboBoxShape.setSelectedIndex(1);
        }
        if (component.fid != null && !component.fid.trim().equals("") && component.fid.trim() != null) {
            this.jTextFieldID.setText(component.fid);
            this.jTextFieldID.setForeground(Color.BLACK);
        }
        this.previewDraw();
    }

    public void previewDraw() {
        LinkedList<Component> componentList = new LinkedList<Component>();
        int iCenterx = 0;
        int iCentery = 0;
        int iWide = 0;
        iCenterx = (int)Double.parseDouble(this.centerTextFieldX.getText().trim());
        iCentery = (int)Double.parseDouble(this.centerTextFieldY.getText().trim());
        iWide = (int)Double.parseDouble(this.wideTextField.getText().trim());
        int iRotationAngle = (Integer)this.jSpinnerRotationAngle.getValue();
        String parameter = this.jSpinnerStrokeSize.getValue().toString();
        Component component1 = new Component(ComponentEnum.Bracket, this.colorPanel.getBackground(), iCenterx, iCentery, iWide, iRotationAngle, parameter, this.shapeType, "id");
        componentList.add(component1);
        PreviewPanel.protein.setComponentList(componentList);
        this.previewPanel.repaint();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jLabel6 = new JLabel();
        this.jRadioButton3 = new JRadioButton();
        this.jLabel7 = new JLabel();
        this.jLabel9 = new JLabel();
        this.jLabel11 = new JLabel();
        this.mainPanel = new JPanel();
        this.jLabel8 = new JLabel();
        this.jLabel10 = new JLabel();
        this.jLabel4 = new JLabel();
        this.cancelButton = new JButton();
        this.jLabel3 = new JLabel();
        this.okButton = new JButton();
        this.jPanel2 = new JPanel();
        this.startLabel = new JLabel();
        this.centerTextFieldX = new JTextField();
        this.startLabel1 = new JLabel();
        this.centerTextFieldY = new JTextField();
        this.endLabel = new JLabel();
        this.wideTextField = new JTextField();
        this.jLabel12 = new JLabel();
        this.jLabel13 = new JLabel();
        this.jPanel3 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jSpinnerRotationAngle = new JSpinner();
        this.jLabel5 = new JLabel();
        this.jComboBoxShape = new JComboBox();
        this.colorLabel = new JLabel();
        this.colorPanel = new JPanel();
        this.jLabel2 = new JLabel();
        this.jSpinnerStrokeSize = new JSpinner();
        this.jPanel4 = new JPanel();
        this.jLabel14 = new JLabel();
        this.jTextFieldID = new JTextField();
        this.previewPanel = new PreviewPanel();
        this.jPanel1 = new JPanel();
        this.jLabelTip = new JLabel();
        this.jLabel6.setText("jLabel6");
        this.jRadioButton3.setText("Ellipse");
        this.jRadioButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BracketDialog.this.jRadioButton3ActionPerformed(evt);
            }
        });
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(700, 360));
        this.mainPanel.setBorder(BorderFactory.createTitledBorder(null, "Option", 0, 0, new Font("Arial", 1, 14)));
        this.mainPanel.setMinimumSize(new Dimension(450, 200));
        this.mainPanel.setPreferredSize(new Dimension(620, 440));
        this.cancelButton.setFont(new Font("Arial", 1, 12));
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BracketDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.okButton.setFont(new Font("Arial", 1, 12));
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BracketDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(null, "Location", 0, 0, new Font("Arial", 1, 12)));
        this.jPanel2.setLayout(new GridLayout(2, 4, 10, 10));
        this.startLabel.setFont(new Font("Arial", 1, 12));
        this.startLabel.setHorizontalAlignment(4);
        this.startLabel.setText("Central X");
        this.jPanel2.add(this.startLabel);
        this.centerTextFieldX.setHorizontalAlignment(0);
        this.centerTextFieldX.setText("50");
        this.centerTextFieldX.setToolTipText("");
        this.jPanel2.add(this.centerTextFieldX);
        this.startLabel1.setFont(new Font("Arial", 1, 12));
        this.startLabel1.setHorizontalAlignment(4);
        this.startLabel1.setText("Central Y");
        this.jPanel2.add(this.startLabel1);
        this.centerTextFieldY.setHorizontalAlignment(0);
        this.centerTextFieldY.setText("50");
        this.jPanel2.add(this.centerTextFieldY);
        this.endLabel.setFont(new Font("Arial", 1, 12));
        this.endLabel.setHorizontalAlignment(4);
        this.endLabel.setText("Width");
        this.endLabel.setToolTipText("");
        this.jPanel2.add(this.endLabel);
        this.wideTextField.setHorizontalAlignment(0);
        this.wideTextField.setText("10");
        this.wideTextField.setToolTipText("");
        this.jPanel2.add(this.wideTextField);
        this.jPanel2.add(this.jLabel12);
        this.jPanel2.add(this.jLabel13);
        this.jPanel3.setBorder(BorderFactory.createTitledBorder(null, "Style", 0, 0, new Font("Arial", 1, 12)));
        this.jPanel3.setLayout(new GridLayout(2, 4, 10, 10));
        this.jLabel1.setFont(new Font("Arial", 1, 12));
        this.jLabel1.setHorizontalAlignment(4);
        this.jLabel1.setText("Rotation Angle");
        this.jPanel3.add(this.jLabel1);
        this.jSpinnerRotationAngle.setToolTipText("rotation angle");
        this.jSpinnerRotationAngle.setMinimumSize(new Dimension(41, 10));
        this.jSpinnerRotationAngle.setPreferredSize(new Dimension(41, 10));
        this.jPanel3.add(this.jSpinnerRotationAngle);
        this.jLabel5.setFont(new Font("Arial", 1, 12));
        this.jLabel5.setHorizontalAlignment(4);
        this.jLabel5.setText("Type");
        this.jLabel5.setHorizontalTextPosition(0);
        this.jPanel3.add(this.jLabel5);
        this.jComboBoxShape.setModel(new DefaultComboBoxModel<String>(new String[]{"Brace", "SquareBracket"}));
        this.jComboBoxShape.setSelectedIndex(1);
        this.jComboBoxShape.setToolTipText("");
        this.jComboBoxShape.setPreferredSize(new Dimension(140, 28));
        this.jComboBoxShape.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                BracketDialog.this.jComboBoxShapeItemStateChanged(evt);
            }
        });
        this.jPanel3.add(this.jComboBoxShape);
        this.colorLabel.setFont(new Font("Arial", 1, 12));
        this.colorLabel.setHorizontalAlignment(4);
        this.colorLabel.setText("Color");
        this.jPanel3.add(this.colorLabel);
        this.colorPanel.setBackground(Color.black);
        this.colorPanel.setBorder(BorderFactory.createBevelBorder(0));
        this.colorPanel.setToolTipText("");
        this.colorPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                BracketDialog.this.colorPanelMousePressed(evt);
            }
        });
        this.jPanel3.add(this.colorPanel);
        this.jLabel2.setFont(new Font("Arial", 1, 12));
        this.jLabel2.setHorizontalAlignment(4);
        this.jLabel2.setText("Line Size");
        this.jPanel3.add(this.jLabel2);
        this.jSpinnerStrokeSize.setModel(new SpinnerNumberModel(1, 1, 5, 1));
        this.jPanel3.add(this.jSpinnerStrokeSize);
        this.jPanel4.setBorder(BorderFactory.createTitledBorder(null, "", 0, 0, new Font("Arial", 1, 12)));
        this.jLabel14.setFont(new Font("\u5b8b\u4f53", 1, 12));
        this.jLabel14.setHorizontalAlignment(4);
        this.jLabel14.setText("ID");
        this.jLabel14.setPreferredSize(new Dimension(50, 15));
        this.jPanel4.add(this.jLabel14);
        this.jTextFieldID.setForeground(new Color(255, 255, 255));
        this.jTextFieldID.setPreferredSize(new Dimension(250, 25));
        this.jTextFieldID.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                BracketDialog.this.jTextFieldIDFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                BracketDialog.this.jTextFieldIDFocusLost(evt);
            }
        });
        this.jTextFieldID.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                BracketDialog.this.jTextFieldIDKeyPressed(evt);
            }
        });
        this.jPanel4.add(this.jTextFieldID);
        GroupLayout mainPanelLayout = new GroupLayout(this.mainPanel);
        this.mainPanel.setLayout(mainPanelLayout);
        mainPanelLayout.setHorizontalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, mainPanelLayout.createSequentialGroup().addContainerGap().addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(mainPanelLayout.createSequentialGroup().addGap(205, 205, 205).addComponent(this.cancelButton, -2, 122, -2).addGap(18, 18, 18).addComponent(this.okButton, -2, 122, -2)).addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel4, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel10, -2, 122, -2).addComponent(this.jLabel4, -2, 122, -2).addComponent(this.jLabel3, -2, 122, -2).addComponent(this.jLabel8, -2, 122, -2)).addContainerGap()));
        mainPanelLayout.setVerticalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.jPanel4, -2, -1, -2).addGap(23, 23, 23).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addGap(28, 28, 28).addComponent(this.jLabel8, -2, 26, -2).addGap(10, 10, 10).addComponent(this.jLabel10, -2, 26, -2).addGap(10, 10, 10).addComponent(this.jLabel4, -2, 26, -2).addGap(10, 10, 10).addComponent(this.jLabel3, -2, 26, -2).addContainerGap(45, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, mainPanelLayout.createSequentialGroup().addGap(74, 74, 74).addComponent(this.jPanel3, -2, 100, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.okButton, -2, 26, -2).addComponent(this.cancelButton, -2, 26, -2)).addContainerGap()))).addGroup(mainPanelLayout.createSequentialGroup().addGap(60, 60, 60).addComponent(this.jPanel2, -2, 81, -2).addContainerGap(139, Short.MAX_VALUE)));
        this.getContentPane().add((java.awt.Component)this.mainPanel, "East");
        this.previewPanel.setBorder(BorderFactory.createTitledBorder(null, "Preview", 0, 0, new Font("Arial", 1, 14)));
        this.previewPanel.setMinimumSize(new Dimension(280, 200));
        this.previewPanel.setPreferredSize(new Dimension(600, 440));
        this.previewPanel.setLayout(new BorderLayout());
        this.getContentPane().add((java.awt.Component)this.previewPanel, "Center");
        this.jPanel1.setPreferredSize(new Dimension(700, 30));
        this.jLabelTip.setHorizontalAlignment(0);
        this.jLabelTip.setPreferredSize(new Dimension(700, 20));
        this.jPanel1.add(this.jLabelTip);
        this.getContentPane().add((java.awt.Component)this.jPanel1, "Last");
        this.pack();
    }

    private void jRadioButton3ActionPerformed(ActionEvent evt) {
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.bModify = true;
        boolean isCenterXValiable = new Verifier().verifyFull(this.centerTextFieldX);
        boolean isWideValiable = new Verifier().verify(this.wideTextField);
        boolean isCenterYValiable = new Verifier().verifyFull(this.centerTextFieldY);
        boolean isStrokeSizeValiable = true;
        StringBuffer errorSb = new StringBuffer();
        if (!isCenterXValiable) {
            errorSb.append("Central X Position : should be a positive integer \n");
        }
        if (!isCenterYValiable) {
            errorSb.append("Central Y Position : should be a positive integer \n");
        }
        if (!isStrokeSizeValiable) {
            errorSb.append("Stroke Size : should be a positive integer \n");
        }
        if (!isWideValiable) {
            errorSb.append("End Position : should be a positive integer \n");
        }
        if (isCenterXValiable && isCenterYValiable && isWideValiable) {
            int iCenterx = 0;
            int iCentery = 0;
            int iWide = 0;
            iCenterx = (int)Double.parseDouble(this.centerTextFieldX.getText().trim());
            iCentery = (int)Double.parseDouble(this.centerTextFieldY.getText().trim());
            iWide = (int)Double.parseDouble(this.wideTextField.getText().trim());
            int iRotationAngle = (Integer)this.jSpinnerRotationAngle.getValue();
            String parameter = this.jSpinnerStrokeSize.getValue().toString();
            String fid = "";
            fid = this.jTextFieldID.getText();
            this.component = new Component(ComponentEnum.Bracket, this.colorPanel.getBackground(), iCenterx, iCentery, iWide, iRotationAngle, parameter, this.shapeType, fid);
            this.component.setIsActive(true);
            this.component.setbSelected(true);
            this.dispose();
        } else {
            JOptionPane.showConfirmDialog(this, errorSb.toString(), "Properties Error", -1, 0, null);
        }
    }

    private void jComboBoxShapeItemStateChanged(ItemEvent evt) {
        if (this.jComboBoxShape.getSelectedIndex() == 0) {
            this.shapeType = ShapeEnum.Brace;
        } else if (this.jComboBoxShape.getSelectedIndex() == 1) {
            this.shapeType = ShapeEnum.SquareBracket;
        }
        this.previewDraw();
    }

    private void colorPanelMousePressed(MouseEvent evt) {
        final JColorChooser jColorChooser = new JColorChooser();
        jColorChooser.setColor(this.colorPanel.getBackground());
        Tools.WindowCenter(JColorChooser.createDialog(this, "Color Choose", true, jColorChooser, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color color = jColorChooser.getColor();
                BracketDialog.this.colorPanel.setBackground(color);
                BracketDialog.this.previewDraw();
            }
        }, null));
    }

    private void jTextFieldIDKeyPressed(KeyEvent evt) {
    }

    private void jTextFieldIDFocusGained(FocusEvent evt) {
    }

    private void jTextFieldIDFocusLost(FocusEvent evt) {
    }
}

