/*
 * Decompiled with CFR 0.152.
 */
package gui.ibs;

import gui.ibs.CanvasPanel;
import gui.ibs.Verifier;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.DecimalFormat;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class CanvasSizeDialog
extends JDialog {
    private double dscale = 1.0;
    private CanvasPanel canvasPanel;
    private int width;
    private int height;
    private double ratio;
    private DecimalFormat df = new DecimalFormat("##.##");
    private JButton cancelButton;
    private JPanel consolePanel;
    private JLabel heightLabel;
    private JTextField heightTextField;
    public JComboBox jComboBoxScale;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel mainPanel;
    private JButton okButton;
    private JCheckBox ratioCheckBox;
    private JLabel widthLabel;
    private JTextField widthTextField;

    public CanvasSizeDialog(CanvasPanel canvasPanel, Frame parent, boolean modal) {
        super(parent, modal);
        this.canvasPanel = canvasPanel;
        this.setPreferredSize(new Dimension(560, 180));
        this.initComponents();
        this.width = Math.round(canvasPanel.getWidth());
        this.height = Math.round(canvasPanel.getHeight());
        this.widthTextField.setText(String.valueOf(this.width));
        this.heightTextField.setText(String.valueOf(this.height));
        this.ratio = 1.3333333333333333;
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.widthLabel = new JLabel();
        this.widthTextField = new JTextField();
        this.jComboBoxScale = new JComboBox();
        this.heightLabel = new JLabel();
        this.heightTextField = new JTextField();
        this.ratioCheckBox = new JCheckBox();
        this.consolePanel = new JPanel();
        this.cancelButton = new JButton();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.okButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Canvas Size");
        this.mainPanel.setBorder(BorderFactory.createTitledBorder(null, "Canvas Size", 0, 0, new Font("Arial", 1, 14)));
        this.mainPanel.setPreferredSize(new Dimension(300, 120));
        this.mainPanel.setLayout(new GridLayout(2, 3, 10, 10));
        this.widthLabel.setFont(new Font("Arial", 1, 12));
        this.widthLabel.setHorizontalAlignment(4);
        this.widthLabel.setText("Width (pix)");
        this.mainPanel.add(this.widthLabel);
        this.widthTextField.setHorizontalAlignment(0);
        this.widthTextField.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.widthTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                CanvasSizeDialog.this.widthTextFieldKeyReleased(evt);
            }
        });
        this.mainPanel.add(this.widthTextField);
        this.jComboBoxScale.setModel(new DefaultComboBoxModel<String>(new String[]{"70%", "80%", "90%", "100%", "150%", "200%", "250%", "300%", "350%", "400%", "450%", "500%", "550%", "600%", "650%", "700%", "750%", "800%"}));
        this.jComboBoxScale.setSelectedIndex(3);
        this.jComboBoxScale.setPreferredSize(new Dimension(100, 20));
        this.jComboBoxScale.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CanvasSizeDialog.this.jComboBoxScaleActionPerformed(evt);
            }
        });
        this.mainPanel.add(this.jComboBoxScale);
        this.heightLabel.setFont(new Font("Arial", 1, 12));
        this.heightLabel.setHorizontalAlignment(4);
        this.heightLabel.setText("Height (pix)");
        this.mainPanel.add(this.heightLabel);
        this.heightTextField.setHorizontalAlignment(0);
        this.heightTextField.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.heightTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                CanvasSizeDialog.this.heightTextFieldKeyReleased(evt);
            }
        });
        this.mainPanel.add(this.heightTextField);
        this.ratioCheckBox.setFont(new Font("Arial", 1, 12));
        this.ratioCheckBox.setSelected(true);
        this.ratioCheckBox.setText("Keep width-height ratio");
        this.mainPanel.add(this.ratioCheckBox);
        this.getContentPane().add((Component)this.mainPanel, "Center");
        this.consolePanel.setPreferredSize(new Dimension(399, 30));
        this.consolePanel.setLayout(new GridLayout(1, 0));
        this.cancelButton.setFont(new Font("Arial", 1, 12));
        this.cancelButton.setText("Cancel");
        this.cancelButton.setMaximumSize(new Dimension(120, 23));
        this.cancelButton.setPreferredSize(new Dimension(90, 23));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CanvasSizeDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.consolePanel.add(this.cancelButton);
        this.consolePanel.add(this.jLabel1);
        this.consolePanel.add(this.jLabel2);
        this.okButton.setFont(new Font("Arial", 1, 12));
        this.okButton.setText("OK");
        this.okButton.setMaximumSize(new Dimension(120, 23));
        this.okButton.setPreferredSize(new Dimension(90, 23));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CanvasSizeDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.consolePanel.add(this.okButton);
        this.getContentPane().add((Component)this.consolePanel, "South");
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        boolean isWidthTextValiable = new Verifier().isPositive(this.widthTextField);
        boolean isHeightTextValiable = new Verifier().isPositive(this.heightTextField);
        StringBuffer errorSb = new StringBuffer();
        if (!isWidthTextValiable) {
            errorSb.append("Width : should be a positive number \n");
        }
        if (!isHeightTextValiable) {
            errorSb.append("Height : should be a positive number \n");
        }
        if (isWidthTextValiable && isHeightTextValiable) {
            boolean confirm = false;
            if (!confirm) {
                int h = (int)Double.parseDouble(this.heightTextField.getText());
                int w = (int)Double.parseDouble(this.widthTextField.getText());
                h = 100 * Math.round(h / 100);
                w = 100 * Math.round(w / 100);
                this.canvasPanel.setSize(w, h);
                this.canvasPanel.setPreferredSize(new Dimension(w, h));
                this.canvasPanel.setWHRatio();
                this.canvasPanel.rate = (float)this.dscale;
                if (this.canvasPanel.df != null) {
                    this.canvasPanel.df.jComboBoxScale.setSelectedIndex(this.jComboBoxScale.getSelectedIndex());
                }
                if (this.canvasPanel.def != null) {
                    this.canvasPanel.def.jComboBoxScale.setSelectedIndex(this.jComboBoxScale.getSelectedIndex());
                }
                this.dispose();
            }
        } else {
            JOptionPane.showConfirmDialog(this, errorSb.toString(), "Parameter Error", -1, 0, null);
        }
    }

    private void widthTextFieldKeyReleased(KeyEvent evt) {
        double w = Double.parseDouble(this.widthTextField.getText());
        double h = Double.parseDouble(this.heightTextField.getText());
        if (this.ratioCheckBox.isSelected()) {
            h = w / this.ratio;
            this.heightTextField.setText(this.df.format(h));
        }
        this.ratio = (double)((float)w) / h;
    }

    private void heightTextFieldKeyReleased(KeyEvent evt) {
        double h = Double.parseDouble(this.heightTextField.getText());
        double w = Double.parseDouble(this.widthTextField.getText());
        if (this.ratioCheckBox.isSelected()) {
            w = h * this.ratio;
            this.widthTextField.setText(this.df.format(w));
        }
        this.ratio = (double)((float)w) / h;
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jComboBoxScaleActionPerformed(ActionEvent evt) {
        int index = this.jComboBoxScale.getSelectedIndex();
        if (index == 0) {
            this.dscale = 0.7;
        } else if (index == 1) {
            this.dscale = 0.8;
        } else if (index == 2) {
            this.dscale = 0.9;
        } else if (index == 3) {
            this.dscale = 1.0;
        } else if (index == 4) {
            this.dscale = 1.5;
        } else if (index == 5) {
            this.dscale = 2.0;
        } else if (index == 6) {
            this.dscale = 2.5;
        } else if (index == 7) {
            this.dscale = 3.0;
        } else if (index == 8) {
            this.dscale = 3.5;
        } else if (index == 9) {
            this.dscale = 4.0;
        } else if (index == 10) {
            this.dscale = 4.5;
        } else if (index == 11) {
            this.dscale = 5.0;
        } else if (index == 12) {
            this.dscale = 5.5;
        } else if (index == 13) {
            this.dscale = 6.0;
        } else if (index == 14) {
            this.dscale = 6.5;
        } else if (index == 15) {
            this.dscale = 7.0;
        } else if (index == 16) {
            this.dscale = 7.5;
        } else if (index == 17) {
            this.dscale = 8.0;
        }
    }
}

