/*
 * Decompiled with CFR 0.152.
 */
package gui.ibs;

import gui.Tools;
import gui.ibs.Area;
import gui.ibs.BracketDialog;
import gui.ibs.CanvasPanel;
import gui.ibs.CanvasSizeDialog;
import gui.ibs.Component;
import gui.ibs.ComponentEnum;
import gui.ibs.CutLineDialog;
import gui.ibs.EditDialog;
import gui.ibs.IBSFrame;
import gui.ibs.LineDialog;
import gui.ibs.NoteDialog;
import gui.ibs.NucleotideDomainDialog;
import gui.ibs.OutputJDialog;
import gui.ibs.PolygonDialog;
import gui.ibs.PreviewPanel;
import gui.ibs.Project;
import gui.ibs.Project2XML;
import gui.ibs.Protein;
import gui.ibs.ProteinDialog;
import gui.ibs.ProteinDomainDialog;
import gui.ibs.ResourceBundleUtil;
import gui.ibs.ShapeEnum;
import gui.ibs.SiteDialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.io.File;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class DemoFrame
extends JFrame {
    public String[] arrayString;
    public ImageIcon[] images;
    public static ImageIcon[] imagesShape;
    public static ImageIcon[] imagesShapeSite;
    public static ImageIcon[] imagesShapeMarker;
    public static ImageIcon[] imagesGradient;
    public static ImageIcon[] imagesShapeCutLine;
    public static final String DELIMIT = "#&%";
    private CanvasPanel canvasPanel = new CanvasPanel();
    private DefaultListModel listModel = new DefaultListModel();
    private String TITLE = " IBS Demo";
    private int demoNum = 1;
    private int DEMO_SUM = 1;
    public static String mode;
    ResourceBundleUtil config = ResourceBundleUtil.getBundle("gui.ibs.config");
    public boolean isOpening = false;
    private JMenuItem addDomainMenuItem;
    private JMenu addMenu;
    private JMenuItem addNoteMenuItem;
    private JMenuItem addProteinMenuItem;
    private JMenuItem addSiteMenuItem;
    private JScrollPane canvasScrollPane;
    private JMenuItem canvasSizeMenuItem;
    private JScrollPane componentScrollPane;
    private JPanel consolePanel;
    private JMenuItem deleteCanvasMenuItem;
    private JMenuItem deleteMenuItem;
    private JMenuItem duplicateCanvasMenuItem;
    private JMenuItem duplicateMenuItem;
    private JMenuItem editComponentMenuItem;
    private JMenuItem editMenuItem;
    private JMenuItem exportImageMenuItem;
    private JMenuItem fitWidthMenuItem;
    private JCheckBox jCheckBoxGray;
    public JComboBox jComboBoxScale;
    private JLabel jLabel1;
    private JSeparator jSeparator1;
    private JPopupMenu.Separator jSeparator2;
    private JList list;
    private JPanel mainPanel;
    private JMenuItem moveDownMenuItem;
    private JMenuItem moveEndMenuItem;
    private JMenu moveMenu;
    private JMenuItem moveTopMenuItem;
    private JMenuItem moveUpMenuItem;
    private JButton nextButton;
    private JPopupMenu panelMenu;
    private JPopupMenu popupMenu;
    private JButton previousButton;
    private JMenuItem zoomInMenuItem;
    private JMenuItem zoomOutMenuItem;

    public String getMode() {
        return mode;
    }

    public void setMode(String mode) {
        DemoFrame.mode = mode;
    }

    public ImageIcon[] getImages() {
        return this.images;
    }

    public void setImages(ImageIcon[] images) {
        this.images = images;
    }

    public ImageIcon[] getImagesGradient() {
        return imagesGradient;
    }

    public void setImagesGradient(ImageIcon[] imagesGradient) {
        DemoFrame.imagesGradient = imagesGradient;
    }

    public ImageIcon[] getImagesShape() {
        return imagesShape;
    }

    public void setImagesShape(ImageIcon[] imagesShape) {
        DemoFrame.imagesShape = imagesShape;
    }

    public DemoFrame() {
        this.initComponents();
        this.canvasPanel.setSize(800, 600);
        this.canvasPanel.def = this;
        this.setCanvasSize();
        this.setExtendedState(6);
        String absolutePath = "";
        Class<?> c = this.getClass();
        absolutePath = Tools.getAppPath(c) + "/";
        if (absolutePath.indexOf("build/classes") >= 0) {
            absolutePath = "";
        }
        String strRealPath = absolutePath + "demo/";
        this.DEMO_SUM = new File(strRealPath).listFiles().length;
        String fileName = strRealPath + this.demoNum + ".xml";
        this.openProject(fileName);
    }

    public DemoFrame(String mode, ImageIcon[] images, ImageIcon[] imagesShape, ImageIcon[] imagesShapeSite, ImageIcon[] imagesShapeMarker, ImageIcon[] imagesGradient, ImageIcon[] imagesShapeCutLine) {
        File objFile;
        int ilen;
        DemoFrame.mode = mode;
        this.images = images;
        DemoFrame.imagesShape = imagesShape;
        DemoFrame.imagesShapeSite = imagesShapeSite;
        DemoFrame.imagesShapeMarker = imagesShapeMarker;
        DemoFrame.imagesGradient = imagesGradient;
        DemoFrame.imagesShapeCutLine = imagesShapeCutLine;
        this.initComponents();
        this.canvasPanel.setSize(800, 600);
        this.canvasPanel.def = this;
        this.setCanvasSize();
        this.setExtendedState(6);
        String strRealPath = "demo/protein";
        strRealPath = mode.equals("P") ? "demo/protein" : "demo/nucleotide";
        String absolutePath = "";
        Class<?> c = this.getClass();
        absolutePath = Tools.getAppPath(c) + "/";
        if (absolutePath.indexOf("build/classes") >= 0) {
            absolutePath = "";
        }
        if ((ilen = (objFile = new File(strRealPath = absolutePath + strRealPath)).listFiles().length) <= 0) {
            return;
        }
        this.DEMO_SUM = ilen;
        File[] array = new File[ilen];
        array = objFile.listFiles();
        this.arrayString = new String[ilen];
        for (int i = 0; i < ilen; ++i) {
            this.arrayString[i] = array[i].getAbsolutePath();
        }
        Arrays.sort(this.arrayString);
        String fileName = this.arrayString[0];
        this.demoNum = 0;
        this.openProject(fileName);
    }

    public void openProject(String filePath) {
        this.isOpening = true;
        Project project = new Project2XML(filePath).open(mode);
        mode = project.mode;
        double rateProject = Math.floor(project.rate * 10.0f) / 10.0;
        project.rate = (float)rateProject;
        this.canvasPanel.rate = (float)rateProject;
        this.canvasPanel.setIsLengthRatio(true);
        this.drawPanel(project, filePath);
        this.setCanvasSize();
        this.canvasPanel.setCurrentProteinNum(0);
        double q = this.getRelaRate(rateProject);
        this.setCanvasSize();
        this.isOpening = false;
    }

    public void drawPanel(Project project, String filePath) {
        LinkedList<Protein> proteinList;
        if (project != null && (proteinList = project.getProteinList()).size() != 0) {
            this.setTitle(this.TITLE + " - " + filePath);
            this.canvasPanel.setPanelSize(project.getWidth(), project.getHeight(), project.getRate());
            this.canvasPanel.setProteinList(project.getProteinList());
            this.canvasPanel.repaint();
            if (this.canvasPanel.getWidth() > this.canvasScrollPane.getWidth()) {
                this.canvasScrollPane.getViewport().setViewPosition(new Point(this.canvasPanel.getWidth() / 4, this.canvasPanel.getHeight() / 4));
            }
            this.repaintList();
        }
    }

    private void repaintList() {
        this.listModel.clear();
        LinkedList<Protein> proteinList = this.canvasPanel.getProteinList();
        int k = 1;
        for (Protein protein : proteinList) {
            this.listModel.addElement(DemoFrame.getListElement(protein, k));
            LinkedList<Component> componentList = protein.getComponentList();
            int p = 1;
            for (Component component : componentList) {
                this.listModel.addElement(DemoFrame.getListElement(component, p));
                ++p;
            }
            ++k;
        }
    }

    public static String getListElement(Protein protein, int k) {
        Color color = protein.getColor();
        String RGB = "rgb(" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + ")";
        String parameter = "";
        StringTokenizer st = new StringTokenizer(protein.getParameter(), DELIMIT);
        parameter = st.nextToken();
        st.nextToken();
        parameter = parameter + ";" + st.nextToken();
        st.nextToken();
        st.nextToken();
        st.nextToken();
        st.nextToken();
        st.nextToken();
        st.nextToken();
        st.nextToken();
        st.nextToken();
        String sid = st.nextToken().trim();
        if (sid == null) {
            sid = "";
        }
        String element = !sid.equals("") ? (mode.equals("P") ? "<html><font color=rgb(" + RGB + ")>" + (Object)((Object)ComponentEnum.Protein) + "-" + k + ":" + sid + "<font></html>" : "<html><font color=rgb(" + RGB + ")>" + "Nucleotide-" + k + ":" + sid + "<font></html>") : (mode.equals("P") ? "<html><font color=rgb(" + RGB + ")>" + (Object)((Object)ComponentEnum.Protein) + "-" + k + "<font></html>" : "<html><font color=rgb(" + RGB + ")>" + "Nucleotide-" + k + "<font></html>");
        return element;
    }

    public static String getListElement(Component component, int k) {
        ShapeEnum shapeType;
        String name;
        Color color = component.getColor();
        String RGB = "rgb(" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + ")";
        if (component.getColor() == Color.WHITE) {
            RGB = "rgb(0,0,0)";
        }
        String parameter = "";
        String[] arr = component.getParameter().split(DELIMIT);
        String stype = "";
        if (component.getType() == ComponentEnum.Protein) {
            String start = arr[0];
            String end = arr[1];
            parameter = start + ";" + end;
            stype = mode.equals("P") ? "Protein" : "Nucleotide";
        } else if (component.getType() == ComponentEnum.Domain) {
            name = arr[2];
            parameter = component.getX() + ";" + component.getX2() + ";" + name;
            shapeType = component.getShapeType();
            stype = component.getType().toString();
        } else if (component.getType() == ComponentEnum.CutLine) {
            name = arr[2];
            parameter = component.getX() + ";" + component.getX2() + ";" + name;
            shapeType = component.getShapeType();
            stype = "CutLine";
            RGB = "rgb(0,0,0)";
        } else if (component.getType() == ComponentEnum.Site) {
            String site = arr[0];
            String text = arr[1];
            parameter = site + ";" + text;
            stype = component.getType().toString();
        } else if (component.getType() == ComponentEnum.Note) {
            parameter = arr[0];
            stype = component.getType().toString();
        } else if (component.getType() == ComponentEnum.Line) {
            parameter = (int)component.getX() + "," + component.getY() + ") - (" + (int)component.getX2() + "," + component.getY2();
            stype = component.getType().toString();
        } else if (component.getType() == ComponentEnum.Polygon) {
            name = arr[2];
            parameter = (int)component.getCenterx() + ";" + (int)component.getCentery() + ";" + name;
            stype = "Marker";
        } else if (component.getType() == ComponentEnum.Bracket) {
            parameter = (int)component.getCenterx() + ";" + (int)component.getCentery() + ";" + (int)component.getWide();
            stype = component.getType().toString();
        }
        String sid = component.fid;
        if (sid == null) {
            sid = "";
        }
        String element = !sid.equals("") ? "<html><font color=rgb(" + RGB + ")>>>" + stype.trim() + "-" + k + ": " + sid + " <font></html>" : "<html><font color=rgb(" + RGB + ")>>>" + stype.trim() + "-" + k + " <font></html>";
        return element;
    }

    private void addComponent(EditDialog dialog) {
        for (int i = 0; i < this.canvasPanel.getProteinList().size(); ++i) {
            Protein protein = this.canvasPanel.getProteinList().get(i);
            protein.setIsActive(false);
        }
        Protein protein = this.canvasPanel.getCurrentProtein();
        Tools.WindowCenter(dialog);
        if (dialog.getComponent() != null) {
            Component component;
            this.canvasPanel.ComponentSelect = component = dialog.getComponent();
            if (component.getType() == ComponentEnum.Site) {
                String parameter = component.getParameter();
                StringTokenizer ster = new StringTokenizer(parameter, DELIMIT);
                String positions = ster.nextToken();
                StringTokenizer st = new StringTokenizer(positions, ";");
                int siteCount = st.countTokens();
                int deltaX = 0;
                if (siteCount == 1) {
                    int site;
                    deltaX = site = Integer.parseInt(st.nextToken());
                } else if (siteCount == 2) {
                    int centralSite;
                    LinkedList<Integer> siteList = new LinkedList<Integer>();
                    for (int i = 0; i < siteCount; ++i) {
                        siteList.add(Integer.parseInt(st.nextToken()));
                    }
                    Collections.sort(siteList);
                    int firstSite = Integer.parseInt(String.valueOf(siteList.getFirst()));
                    int lastSite = Integer.parseInt(String.valueOf(siteList.getLast()));
                    deltaX = centralSite = (firstSite + lastSite) / 2;
                } else {
                    int centralSite;
                    LinkedList<Integer> siteList = new LinkedList<Integer>();
                    for (int i = 0; i < siteCount; ++i) {
                        siteList.add(Integer.parseInt(st.nextToken()));
                    }
                    Collections.sort(siteList);
                    deltaX = centralSite = (Integer.parseInt(String.valueOf(siteList.getFirst())) + Integer.parseInt(String.valueOf(siteList.getLast()))) / 2;
                }
                component.setX(deltaX);
            } else if (component.getType() == ComponentEnum.Note) {
                component.setX(protein.getEnd() / 2);
            } else if (component.getType() == ComponentEnum.Domain) {
                this.canvasPanel.ddc.initDialog = false;
                this.canvasPanel.ddc.iheight = (int)component.getHigh();
                this.canvasPanel.ddc.iwidth = (int)(component.getX2() - component.getX());
            }
            protein.getComponentList().add(component);
            this.canvasPanel.repaint();
            this.repaintList();
            try {
                this.canvasPanel.saveCurrentState();
            }
            catch (CloneNotSupportedException ex) {
                ex.printStackTrace();
            }
        }
    }

    private Protein getIndexProtein(int index) {
        int count = 0;
        LinkedList<Protein> proteinList = this.canvasPanel.getProteinList();
        Protein selectedProtein = proteinList.getFirst();
        for (int i = 0; i < proteinList.size(); ++i) {
            Protein protein = proteinList.get(i);
            if (index == count) {
                protein.setSelectNum(-1);
                selectedProtein = protein;
                break;
            }
            ++count;
            boolean isContained = false;
            LinkedList<Component> componentList = protein.getComponentList();
            for (int j = 0; j < componentList.size(); ++j) {
                if (index == count) {
                    protein.setSelectNum(j);
                    isContained = true;
                    selectedProtein = protein;
                    break;
                }
                ++count;
            }
            if (isContained) break;
        }
        return selectedProtein;
    }

    private void callEditDialog(int x, int y) {
        LinkedList<Protein> proteinList = this.canvasPanel.getProteinList();
        for (Protein protein : proteinList) {
            boolean isContained = false;
            LinkedList<Component> componentList = protein.getComponentList();
            for (int i = componentList.size() - 1; i >= 0; --i) {
                String strNum;
                int proteinlenth;
                Component component = componentList.get(i);
                Area area = component.getArea();
                java.awt.geom.Area GeomArea = component.getGeomArea();
                if (area == null && GeomArea == null) continue;
                boolean inside = false;
                if (GeomArea != null) {
                    if (GeomArea.contains(x, y)) {
                        inside = true;
                    }
                } else if (area.isInside(x, y)) {
                    inside = true;
                }
                if (!inside) continue;
                isContained = true;
                EditDialog dialog = null;
                EditDialog dialogN = null;
                if (component.getType() == ComponentEnum.Domain) {
                    proteinlenth = this.canvasPanel.getCurrentProtein().getEnd();
                    strNum = this.getDefaultID(ComponentEnum.Domain.name());
                    if (mode.equals("P")) {
                        dialog = new ProteinDomainDialog(this, " Edit Domain", true, this.images, imagesGradient, proteinlenth, strNum);
                    } else {
                        dialogN = new NucleotideDomainDialog(this, " Edit Domain", true, this.images, imagesShape, imagesGradient, strNum);
                    }
                }
                if (component.getType() == ComponentEnum.CutLine) {
                    String strNum2 = this.getDefaultID(ComponentEnum.CutLine.name());
                    dialog = new CutLineDialog(this, " Edit CutLine", imagesShapeCutLine, true, mode, strNum2);
                } else if (component.getType() == ComponentEnum.Site) {
                    String strNum3 = this.getDefaultID(ComponentEnum.Site.name());
                    dialog = new SiteDialog(this, " Edit Site", true, this.images, imagesShapeSite, imagesGradient, strNum3);
                } else if (component.getType() == ComponentEnum.Note) {
                    String strNum4 = this.getDefaultID(ComponentEnum.Note.name());
                    dialog = new NoteDialog((Frame)this, " Edit Note", true, strNum4);
                } else if (component.getType() == ComponentEnum.Line) {
                    proteinlenth = this.canvasPanel.getCurrentProtein().getEnd();
                    strNum = this.getDefaultID(ComponentEnum.Line.name());
                    dialog = new LineDialog(this, " Edit Line :" + component.getShapeType().name(), true, component.getShapeType(), component.getControlx1(), component.getControly1(), component.getControlx2(), component.getControly2(), proteinlenth, strNum);
                } else if (component.getType() == ComponentEnum.Polygon) {
                    String strNum5 = this.getDefaultID(ComponentEnum.Polygon.name());
                    dialog = new PolygonDialog(this, " Marker", true, this.images, imagesShapeMarker, imagesGradient, strNum5);
                } else if (component.getType() == ComponentEnum.Bracket) {
                    proteinlenth = this.canvasPanel.getCurrentProtein().getEnd();
                    strNum = this.getDefaultID(ComponentEnum.Bracket.name());
                    dialog = new BracketDialog(this, " Bracket", true, proteinlenth, strNum);
                }
                if (dialog != null) {
                    dialog.setComponent(component);
                    Tools.WindowCenter(dialog);
                    if (dialog.getComponent() == null) break;
                    component = dialog.getComponent();
                    protein.getComponentList().set(i, component);
                    this.canvasPanel.ddc.initDialog = false;
                    this.canvasPanel.ddc.iheight = (int)component.getHigh();
                    this.canvasPanel.ddc.iwidth = (int)(component.getX2() - component.getX());
                    this.canvasPanel.repaint();
                    this.repaintList();
                    try {
                        this.canvasPanel.saveCurrentState();
                    }
                    catch (CloneNotSupportedException ex) {
                        ex.printStackTrace();
                    }
                    break;
                }
                dialogN.setComponent(component);
                Tools.WindowCenter(dialogN);
                if (dialogN.getComponent() == null) break;
                component = dialogN.getComponent();
                protein.getComponentList().set(i, component);
                this.canvasPanel.ddc.initDialog = false;
                this.canvasPanel.ddc.iheight = (int)component.getHigh();
                this.canvasPanel.ddc.iwidth = (int)(component.getX2() - component.getX());
                this.canvasPanel.repaint();
                this.repaintList();
                try {
                    this.canvasPanel.saveCurrentState();
                }
                catch (CloneNotSupportedException ex) {
                    ex.printStackTrace();
                }
                break;
            }
            if (!isContained && protein.getArea().isInside(x, y)) {
                ProteinDialog pd;
                String strNum;
                if (mode.equals("P")) {
                    strNum = this.getDefaultID("Protein");
                    pd = new ProteinDialog(this, "Edit Protein", true, this.images, imagesGradient, mode, strNum);
                } else {
                    strNum = this.getDefaultID("Nucleotide");
                    pd = new ProteinDialog(this, "Edit Nucleotide", true, this.images, imagesGradient, mode, strNum);
                }
                pd.setProtein(protein);
                Tools.WindowCenter(pd);
                if (pd.getProtein() != null) {
                    protein.setVertical(pd.getProtein().getVertical());
                    protein.setHorizontal(pd.getProtein().getHorizontal());
                    protein.setLocked(pd.getProtein().isLocked());
                    protein.setParameter(pd.getProtein().getParameter());
                    protein.setColor(pd.getProtein().getColor());
                    protein.setArea(pd.getProtein().getArea());
                    protein.setEnd(pd.getProtein().getEnd());
                    this.repaintList();
                    this.canvasPanel.repaint();
                    try {
                        this.canvasPanel.saveCurrentState();
                    }
                    catch (CloneNotSupportedException ex) {
                        ex.printStackTrace();
                    }
                }
                isContained = true;
            }
            if (!isContained) continue;
            break;
        }
        this.canvasPanel.repaint();
    }

    private void callEditDialog() {
        int selectedIndex = this.list.getSelectedIndex();
        LinkedList<Protein> proteinList = this.canvasPanel.getProteinList();
        int count = 0;
        block6: for (Protein protein : proteinList) {
            if (count > selectedIndex) break;
            if (selectedIndex == count) {
                ProteinDialog pd;
                String strNum;
                if (mode.equals("P")) {
                    strNum = this.getDefaultID("Protein");
                    pd = new ProteinDialog(this, "Edit Protein", true, this.images, imagesGradient, mode, strNum);
                } else {
                    strNum = this.getDefaultID("Nucleotide");
                    pd = new ProteinDialog(this, "Edit Nucleotide", true, this.images, imagesGradient, mode, strNum);
                }
                pd.setProtein(protein);
                Tools.WindowCenter(pd);
                if (pd.getProtein() == null) break;
                protein.setVertical(pd.getProtein().getVertical());
                protein.setHorizontal(pd.getProtein().getHorizontal());
                protein.setLocked(pd.getProtein().isLocked());
                protein.setParameter(pd.getProtein().getParameter());
                protein.setColor(pd.getProtein().getColor());
                protein.setEnd(pd.getProtein().getEnd());
                protein.setArea(pd.getProtein().getArea());
                this.canvasPanel.repaint();
                this.repaintList();
                try {
                    this.canvasPanel.saveCurrentState();
                }
                catch (CloneNotSupportedException ex) {
                    ex.printStackTrace();
                }
                break;
            }
            ++count;
            LinkedList<Component> componentList = protein.getComponentList();
            String[] arrPro = protein.getParameter().split(DELIMIT);
            int proteinStart = Integer.parseInt(arrPro[0]);
            int proteinEnd = Integer.parseInt(arrPro[2]);
            double proteinlen = proteinEnd - proteinStart;
            for (int i = 0; i < componentList.size(); ++i) {
                Component component = componentList.get(i);
                if (selectedIndex == count) {
                    String strNum;
                    int proteinlenth;
                    EditDialog dialog = null;
                    EditDialog dialogN = null;
                    if (component.getType() == ComponentEnum.Domain) {
                        proteinlenth = this.canvasPanel.getCurrentProtein().getEnd();
                        strNum = this.getDefaultID(ComponentEnum.Domain.name());
                        if (mode.equals("P")) {
                            dialog = new ProteinDomainDialog(this, " Edit Domain", true, this.images, imagesGradient, proteinlenth, strNum);
                        } else {
                            dialogN = new NucleotideDomainDialog(this, " Edit Domain", true, this.images, imagesShape, imagesGradient, strNum);
                        }
                    }
                    if (component.getType() == ComponentEnum.CutLine) {
                        String strNum2 = this.getDefaultID(ComponentEnum.CutLine.name());
                        dialog = new CutLineDialog(this, " Edit CutLine", imagesShapeCutLine, true, mode, strNum2);
                    } else if (component.getType() == ComponentEnum.Site) {
                        String strNum3 = this.getDefaultID(ComponentEnum.Site.name());
                        dialog = new SiteDialog(this, " Edit Site", true, this.images, imagesShapeSite, imagesGradient, strNum3);
                    } else if (component.getType() == ComponentEnum.Note) {
                        String strNum4 = this.getDefaultID(ComponentEnum.Note.name());
                        dialog = new NoteDialog((Frame)this, " Edit Note", true, strNum4);
                    } else if (component.getType() == ComponentEnum.Line) {
                        proteinlenth = this.canvasPanel.getCurrentProtein().getEnd();
                        strNum = this.getDefaultID(ComponentEnum.Line.name());
                        dialog = new LineDialog(this, " Edit Line :" + component.getShapeType().name(), true, component.getShapeType(), component.getControlx1(), component.getControly1(), component.getControlx2(), component.getControly2(), proteinlenth, strNum);
                    } else if (component.getType() == ComponentEnum.Polygon) {
                        String strNum5 = this.getDefaultID(ComponentEnum.Polygon.name());
                        dialog = new PolygonDialog(this, "Edit Marker", true, this.images, imagesShapeMarker, imagesGradient, strNum5);
                    } else if (component.getType() == ComponentEnum.Bracket) {
                        proteinlenth = this.canvasPanel.getCurrentProtein().getEnd();
                        strNum = this.getDefaultID(ComponentEnum.Bracket.name());
                        dialog = new BracketDialog(this, "Edit Bracket", true, proteinlenth, strNum);
                    }
                    if (dialog != null) {
                        dialog.setComponent(component);
                        Tools.WindowCenter(dialog);
                        if (dialog.getComponent() != null) {
                            component = dialog.getComponent();
                            protein.getComponentList().set(i, component);
                            this.canvasPanel.repaint();
                            this.repaintList();
                            try {
                                this.canvasPanel.saveCurrentState();
                            }
                            catch (CloneNotSupportedException ex) {
                                ex.printStackTrace();
                            }
                        }
                    } else {
                        dialogN.setComponent(component);
                        Tools.WindowCenter(dialogN);
                        if (dialogN.getComponent() != null) {
                            component = dialogN.getComponent();
                            protein.getComponentList().set(i, component);
                            this.canvasPanel.repaint();
                            this.repaintList();
                            try {
                                this.canvasPanel.saveCurrentState();
                            }
                            catch (CloneNotSupportedException ex) {
                                ex.printStackTrace();
                            }
                        }
                    }
                } else if (count > selectedIndex) continue block6;
                ++count;
            }
        }
    }

    private void activeProtein(int selectedNum) {
        int listNum = 0;
        LinkedList<Protein> proteinList = this.canvasPanel.getProteinList();
        for (int i = 0; i < proteinList.size(); ++i) {
            Protein protein = proteinList.get(i);
            if ((listNum = listNum + 1 + protein.getComponentList().size()) < selectedNum) continue;
            this.canvasPanel.setCurrentProteinNum(i);
            this.canvasPanel.setCurrentVertical(protein.getVertical());
        }
    }

    private void activeProtein(int x, int y) {
        int listNum = 0;
        LinkedList<Protein> proteinList = this.canvasPanel.getProteinList();
        try {
            for (int i = 0; i < proteinList.size(); ++i) {
                Rectangle viewRect;
                Rectangle rect;
                Protein protein = proteinList.get(i);
                boolean isContained = false;
                boolean isInsideComponent = false;
                if (protein.getArea().isInside(x, y)) {
                    isContained = true;
                }
                int componentNum = 0;
                LinkedList<Component> componentList = protein.getComponentList();
                for (int j = 0; j < componentList.size(); ++j) {
                    Component component = componentList.get(j);
                    Area area = component.getArea();
                    if (area == null) continue;
                    if (component.getType() == ComponentEnum.Line) {
                        area = this.getLineArea(component);
                        this.repaintList();
                    }
                    if (!area.isInside(x, y)) continue;
                    componentNum = j;
                    isInsideComponent = true;
                    isContained = true;
                    break;
                }
                if (isInsideComponent) {
                    listNum = listNum + 1 + componentNum;
                    this.canvasPanel.setCurrentProteinNum(i);
                    this.canvasPanel.setCurrentVertical(protein.getVertical());
                    PreviewPanel.protein = (Protein)protein.clone();
                    this.list.setSelectedIndex(listNum);
                    JViewport viewport = this.componentScrollPane.getViewport();
                    rect = this.list.getCellBounds(listNum, listNum);
                    viewRect = viewport.getViewRect();
                    rect.setLocation(rect.x - viewRect.x, rect.y - viewRect.y);
                    viewport.scrollRectToVisible(rect);
                    break;
                }
                if (isContained) {
                    this.canvasPanel.setCurrentProteinNum(i);
                    this.canvasPanel.setCurrentVertical(protein.getVertical());
                    PreviewPanel.protein = (Protein)protein.clone();
                    this.list.setSelectedIndex(listNum);
                    JViewport viewport = this.componentScrollPane.getViewport();
                    rect = this.list.getCellBounds(listNum, listNum);
                    viewRect = viewport.getViewRect();
                    rect.setLocation(rect.x - viewRect.x, rect.y - viewRect.y);
                    viewport.scrollRectToVisible(rect);
                    break;
                }
                listNum = listNum + 1 + componentList.size();
            }
        }
        catch (CloneNotSupportedException ex) {
            Logger.getLogger(IBSFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private Area getLineArea(Component component) {
        Area area = component.getArea();
        Area tempArea = new Area(area.getX1(), area.getY1(), area.getX2(), area.getY2());
        if (Math.abs(area.getY1() - area.getY2()) < 30.0) {
            tempArea = area.getY1() > area.getY2() ? new Area(area.getX1(), area.getY1() + 15.0, area.getX2(), area.getY2() - 15.0) : new Area(area.getX1(), area.getY1() - 15.0, area.getX2(), area.getY2() + 15.0);
        } else if (Math.abs(area.getX1() - area.getX2()) < 30.0) {
            tempArea = area.getX1() > area.getX2() ? new Area(area.getX1() + 15.0, area.getY1(), area.getX2() - 15.0, area.getY2()) : new Area(area.getX1() - 15.0, area.getY1(), area.getX2() + 15.0, area.getY2());
        }
        return tempArea;
    }

    public void setCanvasSize() {
        String size = "Canvas : " + this.canvasPanel.getWidth() + "\u00d7" + this.canvasPanel.getHeight();
        String strfont = "";
        strfont = System.getProperty("os.name").equals("Linux") ? "Serif" : "Arial";
    }

    private void initComponents() {
        this.panelMenu = new JPopupMenu();
        this.editComponentMenuItem = new JMenuItem();
        this.addMenu = new JMenu();
        this.addProteinMenuItem = new JMenuItem();
        this.addDomainMenuItem = new JMenuItem();
        this.addSiteMenuItem = new JMenuItem();
        this.addNoteMenuItem = new JMenuItem();
        this.duplicateCanvasMenuItem = new JMenuItem();
        this.deleteCanvasMenuItem = new JMenuItem();
        this.jSeparator2 = new JPopupMenu.Separator();
        this.canvasSizeMenuItem = new JMenuItem();
        this.zoomInMenuItem = new JMenuItem();
        this.zoomOutMenuItem = new JMenuItem();
        this.fitWidthMenuItem = new JMenuItem();
        this.jSeparator1 = new JSeparator();
        this.exportImageMenuItem = new JMenuItem();
        this.popupMenu = new JPopupMenu();
        this.editMenuItem = new JMenuItem();
        this.duplicateMenuItem = new JMenuItem();
        this.moveMenu = new JMenu();
        this.moveTopMenuItem = new JMenuItem();
        this.moveUpMenuItem = new JMenuItem();
        this.moveDownMenuItem = new JMenuItem();
        this.moveEndMenuItem = new JMenuItem();
        this.deleteMenuItem = new JMenuItem();
        this.mainPanel = new JPanel();
        this.canvasScrollPane = new JScrollPane();
        this.consolePanel = new JPanel();
        this.previousButton = new JButton();
        this.nextButton = new JButton();
        this.jLabel1 = new JLabel();
        this.jComboBoxScale = new JComboBox();
        this.jCheckBoxGray = new JCheckBox();
        this.componentScrollPane = new JScrollPane();
        this.list = new JList();
        this.editComponentMenuItem.setText("Edit");
        this.editComponentMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DemoFrame.this.editComponentMenuItemActionPerformed(evt);
            }
        });
        this.panelMenu.add(this.editComponentMenuItem);
        this.addMenu.setText("Add");
        this.addProteinMenuItem.setText("Protein");
        this.addProteinMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DemoFrame.this.proteinButtonActionPerformed(evt);
            }
        });
        this.addMenu.add(this.addProteinMenuItem);
        this.addDomainMenuItem.setText("Domain");
        this.addDomainMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DemoFrame.this.domainButtonActionPerformed(evt);
            }
        });
        this.addMenu.add(this.addDomainMenuItem);
        this.addSiteMenuItem.setText("Site");
        this.addSiteMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DemoFrame.this.siteButtonActionPerformed(evt);
            }
        });
        this.addMenu.add(this.addSiteMenuItem);
        this.addNoteMenuItem.setText("Note");
        this.addNoteMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DemoFrame.this.nextButtonActionPerformed(evt);
            }
        });
        this.addMenu.add(this.addNoteMenuItem);
        this.panelMenu.add(this.addMenu);
        this.duplicateCanvasMenuItem.setText("Duplicate");
        this.duplicateCanvasMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DemoFrame.this.duplicateMenuItemActionPerformed(evt);
            }
        });
        this.panelMenu.add(this.duplicateCanvasMenuItem);
        this.deleteCanvasMenuItem.setText("Delete");
        this.deleteCanvasMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DemoFrame.this.deleteMenuItemActionPerformed(evt);
            }
        });
        this.panelMenu.add(this.deleteCanvasMenuItem);
        this.panelMenu.add(this.jSeparator2);
        this.canvasSizeMenuItem.setText("Canvas Size");
        this.canvasSizeMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DemoFrame.this.canvasMenuItemActionPerformed(evt);
            }
        });
        this.panelMenu.add(this.canvasSizeMenuItem);
        this.zoomInMenuItem.setAccelerator(KeyStroke.getKeyStroke(38, 0));
        this.zoomInMenuItem.setText("Zoom In");
        this.zoomInMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DemoFrame.this.zoomInMenuItemActionPerformed(evt);
            }
        });
        this.panelMenu.add(this.zoomInMenuItem);
        this.zoomOutMenuItem.setAccelerator(KeyStroke.getKeyStroke(40, 0));
        this.zoomOutMenuItem.setText("Zoom Out");
        this.zoomOutMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DemoFrame.this.zoomOutMenuItemActionPerformed(evt);
            }
        });
        this.panelMenu.add(this.zoomOutMenuItem);
        this.fitWidthMenuItem.setText("Fit Width");
        this.fitWidthMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DemoFrame.this.fitWidthMenuItemActionPerformed(evt);
            }
        });
        this.panelMenu.add(this.fitWidthMenuItem);
        this.panelMenu.add(this.jSeparator1);
        this.exportImageMenuItem.setText("Export Image");
        this.exportImageMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DemoFrame.this.exportMenuItemActionPerformed(evt);
            }
        });
        this.panelMenu.add(this.exportImageMenuItem);
        this.editMenuItem.setText("Edit");
        this.editMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DemoFrame.this.editMenuItemActionPerformed(evt);
            }
        });
        this.popupMenu.add(this.editMenuItem);
        this.duplicateMenuItem.setText("Duplicate");
        this.duplicateMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DemoFrame.this.duplicateMenuItemActionPerformed(evt);
            }
        });
        this.popupMenu.add(this.duplicateMenuItem);
        this.moveMenu.setText("Move");
        this.moveTopMenuItem.setText("Top");
        this.moveTopMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DemoFrame.this.moveTopMenuItemActionPerformed(evt);
            }
        });
        this.moveMenu.add(this.moveTopMenuItem);
        this.moveUpMenuItem.setText("Up");
        this.moveUpMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DemoFrame.this.moveUpMenuItemActionPerformed(evt);
            }
        });
        this.moveMenu.add(this.moveUpMenuItem);
        this.moveDownMenuItem.setText("Down");
        this.moveDownMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DemoFrame.this.moveDownMenuItemActionPerformed(evt);
            }
        });
        this.moveMenu.add(this.moveDownMenuItem);
        this.moveEndMenuItem.setText("Bottom");
        this.moveEndMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DemoFrame.this.moveEndMenuItemActionPerformed(evt);
            }
        });
        this.moveMenu.add(this.moveEndMenuItem);
        this.popupMenu.add(this.moveMenu);
        this.deleteMenuItem.setText("Delete");
        this.deleteMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DemoFrame.this.deleteMenuItemActionPerformed(evt);
            }
        });
        this.popupMenu.add(this.deleteMenuItem);
        this.setDefaultCloseOperation(2);
        this.setTitle(" Demo");
        this.setIconImage(Tools.GPS_ICON);
        this.setMinimumSize(new Dimension(800, 600));
        this.mainPanel.setLayout(new BorderLayout());
        this.canvasScrollPane.getViewport().add(this.canvasPanel);
        this.canvasScrollPane.setBackground(new Color(255, 255, 255));
        this.canvasScrollPane.setBorder(BorderFactory.createTitledBorder(null, "Canvas", 0, 0, new Font("Arial", 1, 14)));
        this.canvasPanel.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent evt) {
                DemoFrame.this.drawPanelMouseWheelMoved(evt);
            }
        });
        this.canvasPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DemoFrame.this.drawPanelMouseClicked(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                DemoFrame.this.drawPanelMousePressed(evt);
            }
        });
        this.mainPanel.add((java.awt.Component)this.canvasScrollPane, "Center");
        this.consolePanel.setBorder(BorderFactory.createTitledBorder(null, "Console", 0, 0, new Font("Arial", 1, 14)));
        this.consolePanel.setPreferredSize(new Dimension(100, 69));
        this.previousButton.setFont(new Font("Arial", 1, 12));
        this.previousButton.setText("Previous");
        this.previousButton.setMaximumSize(new Dimension(200, 23));
        this.previousButton.setPreferredSize(new Dimension(150, 23));
        this.previousButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DemoFrame.this.previousButtonActionPerformed(evt);
            }
        });
        this.consolePanel.add(this.previousButton);
        this.nextButton.setFont(new Font("Arial", 1, 12));
        this.nextButton.setText("Next");
        this.nextButton.setMaximumSize(new Dimension(200, 23));
        this.nextButton.setPreferredSize(new Dimension(150, 23));
        this.nextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DemoFrame.this.nextButtonActionPerformed(evt);
            }
        });
        this.consolePanel.add(this.nextButton);
        this.jLabel1.setFont(new Font("Arial", 1, 12));
        this.jLabel1.setText("Zoom");
        this.consolePanel.add(this.jLabel1);
        this.jComboBoxScale.setModel(new DefaultComboBoxModel<String>(new String[]{"70%", "80%", "90%", "100%", "150%", "200%", "250%", "300%", "350%", "400%", "450%", "500%", "550%", "600%", "650%", "700%", "750%", "800%"}));
        this.jComboBoxScale.setSelectedIndex(3);
        this.jComboBoxScale.setPreferredSize(new Dimension(80, 20));
        this.jComboBoxScale.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DemoFrame.this.jComboBoxScaleActionPerformed(evt);
            }
        });
        this.consolePanel.add(this.jComboBoxScale);
        this.jCheckBoxGray.setFont(new Font("Arial", 1, 12));
        this.jCheckBoxGray.setText("Grayscale");
        this.jCheckBoxGray.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                DemoFrame.this.jCheckBoxGrayItemStateChanged(evt);
            }
        });
        this.consolePanel.add(this.jCheckBoxGray);
        this.mainPanel.add((java.awt.Component)this.consolePanel, "South");
        this.getContentPane().add((java.awt.Component)this.mainPanel, "Center");
        this.componentScrollPane.setBorder(BorderFactory.createTitledBorder(null, "Component List", 0, 0, new Font("Arial", 1, 14)));
        this.componentScrollPane.setPreferredSize(new Dimension(192, 100));
        this.list.setBackground(new Color(255, 255, 224));
        this.list.setModel(this.listModel);
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DemoFrame.this.listMouseClicked(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                DemoFrame.this.listMousePressed(evt);
            }
        });
        this.componentScrollPane.setViewportView(this.list);
        this.getContentPane().add((java.awt.Component)this.componentScrollPane, "East");
        this.pack();
    }

    private void proteinButtonActionPerformed(ActionEvent evt) {
        if (this.canvasPanel.getProteinList().size() > 0) {
            ProteinDialog dialog;
            String strNum;
            if (mode.equals("P")) {
                strNum = this.getDefaultID("Protein");
                dialog = new ProteinDialog(this, "New Protein", true, this.images, imagesGradient, mode, strNum);
            } else {
                strNum = this.getDefaultID("Nucleotide");
                dialog = new ProteinDialog(this, "New Nucleotide", true, this.images, imagesGradient, mode, strNum);
            }
            dialog.setVertical(this.canvasPanel.getCurrentVertical() - 100);
            Tools.WindowCenter(dialog);
            if (dialog.getProtein() != null) {
                Protein protein = dialog.getProtein();
                this.canvasPanel.getProteinList().add(protein);
                this.canvasPanel.setCurrentProteinNum(this.canvasPanel.getProteinList().size() - 1);
                this.canvasPanel.setCurrentVertical(protein.getVertical());
                this.canvasPanel.repaint();
                this.repaintList();
            }
        }
    }

    private void domainButtonActionPerformed(ActionEvent evt) {
        int proteinlenth = this.canvasPanel.getCurrentProtein().getEnd();
        String strNum = this.getDefaultID(ComponentEnum.Domain.name());
        if (mode.equals("P")) {
            this.addComponent(new ProteinDomainDialog(this, " Add Domain", true, this.images, imagesGradient, proteinlenth, strNum));
        } else {
            this.addComponent(new NucleotideDomainDialog(this, " Add Domain", true, this.images, imagesShape, imagesGradient, proteinlenth, this.canvasPanel.ddc, strNum));
        }
    }

    private void siteButtonActionPerformed(ActionEvent evt) {
        String strNum = this.getDefaultID(ComponentEnum.Site.name());
        this.addComponent(new SiteDialog(this, " Add Site", true, this.images, imagesShape, imagesGradient, strNum));
    }

    private void nextButtonActionPerformed(ActionEvent evt) {
        ++this.demoNum;
        if (this.demoNum > this.DEMO_SUM - 1) {
            this.demoNum = 0;
        }
        String fileName = this.arrayString[this.demoNum];
        this.openProject(fileName);
    }

    private void exportMenuItemActionPerformed(ActionEvent evt) {
        Tools.WindowCenter(new OutputJDialog(this.canvasPanel, this, true));
    }

    private void demoMenuItemActionPerformed(ActionEvent evt) {
    }

    private void zoomInMenuItemActionPerformed(ActionEvent evt) {
        if (this.isOpening) {
            return;
        }
        int index = this.jComboBoxScale.getSelectedIndex();
        if (index == 17) {
            return;
        }
        this.jComboBoxScale.setSelectedIndex(index + 1);
    }

    private void zoomOutMenuItemActionPerformed(ActionEvent evt) {
        if (this.isOpening) {
            return;
        }
        int index = this.jComboBoxScale.getSelectedIndex();
        if (index == 0) {
            return;
        }
        this.jComboBoxScale.setSelectedIndex(index - 1);
    }

    private void fitWidthMenuItemActionPerformed(ActionEvent evt) {
        int length = 700;
        if ((float)length * this.canvasPanel.getRATE() > (float)this.canvasScrollPane.getWidth()) {
            while ((float)length * this.canvasPanel.getRATE() > (float)this.canvasScrollPane.getWidth()) {
                this.canvasPanel.decreaseRATE();
            }
        } else {
            while ((float)length * this.canvasPanel.getRATE() < (float)this.canvasScrollPane.getWidth()) {
                this.canvasPanel.increaseRATE();
            }
        }
        Dimension dimension = new Dimension(this.canvasScrollPane.getWidth() - 50, this.canvasScrollPane.getHeight() - 50);
        this.canvasPanel.setSize(dimension);
        this.canvasPanel.setPreferredSize(dimension);
        this.canvasPanel.repaint();
    }

    private void editMenuItemActionPerformed(ActionEvent evt) {
        if (!this.list.isSelectionEmpty()) {
            this.callEditDialog();
        }
    }

    private void moveUpMenuItemActionPerformed(ActionEvent evt) {
        Protein protein;
        int selectNum;
        if (!this.list.isSelectionEmpty() && (selectNum = (protein = this.getIndexProtein(this.list.getSelectedIndex())).getSelectNum()) > 0) {
            LinkedList<Component> componentList = protein.getComponentList();
            Component temp = componentList.get(selectNum - 1);
            componentList.set(selectNum - 1, componentList.get(selectNum));
            componentList.set(selectNum, temp);
            this.canvasPanel.repaint();
            this.repaintList();
        }
    }

    private void moveDownMenuItemActionPerformed(ActionEvent evt) {
        if (!this.list.isSelectionEmpty()) {
            Protein protein = this.getIndexProtein(this.list.getSelectedIndex());
            int selectNum = protein.getSelectNum();
            LinkedList<Component> componentList = protein.getComponentList();
            if (selectNum >= 0 && selectNum < componentList.size() - 1) {
                Component temp = componentList.get(selectNum + 1);
                componentList.set(selectNum + 1, componentList.get(selectNum));
                componentList.set(selectNum, temp);
                this.canvasPanel.repaint();
                this.repaintList();
            }
        }
    }

    private void deleteMenuItemActionPerformed(ActionEvent evt) {
        if (!this.list.isSelectionEmpty()) {
            int listNum = this.list.getSelectedIndex();
            int count = 0;
            LinkedList<Protein> proteinList = this.canvasPanel.getProteinList();
            for (int i = 0; i < proteinList.size(); ++i) {
                Protein protein = proteinList.get(i);
                if (listNum == count) {
                    proteinList.remove(i);
                    this.canvasPanel.repaint();
                    this.repaintList();
                    break;
                }
                ++count;
                boolean isContained = false;
                LinkedList<Component> componentList = protein.getComponentList();
                for (int j = 0; j < componentList.size(); ++j) {
                    if (listNum == count) {
                        componentList.remove(j);
                        this.canvasPanel.repaint();
                        this.repaintList();
                        isContained = true;
                        break;
                    }
                    ++count;
                }
                if (isContained) break;
            }
        }
    }

    private void listMouseClicked(MouseEvent evt) {
        if (SwingUtilities.isLeftMouseButton(evt) && evt.getClickCount() == 2 && !this.list.isSelectionEmpty()) {
            this.callEditDialog();
        }
    }

    private void listMousePressed(MouseEvent evt) {
        if (!this.list.isSelectionEmpty()) {
            try {
                PreviewPanel.protein = (Protein)this.getIndexProtein(this.list.getSelectedIndex()).clone();
                if (SwingUtilities.isRightMouseButton(evt)) {
                    this.popupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
                    if (String.valueOf(this.list.getSelectedValue()).contains(">>")) {
                        this.moveMenu.setEnabled(true);
                    } else {
                        this.moveMenu.setEnabled(false);
                    }
                }
            }
            catch (CloneNotSupportedException ex) {
                Logger.getLogger(DemoFrame.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void duplicateMenuItemActionPerformed(ActionEvent evt) {
        String strNum = "";
        if (!this.list.isSelectionEmpty()) {
            try {
                Protein protein = this.getIndexProtein(this.list.getSelectedIndex());
                int selectNum = protein.getSelectNum();
                if (selectNum == -1) {
                    strNum = mode.equals("P") ? this.getDefaultID("Protein") : this.getDefaultID("Nucleotide");
                    Protein clonedProtein = (Protein)protein.clone();
                    String[] arrPro = clonedProtein.getParameter().split(DELIMIT);
                    arrPro[arrPro.length - 1] = strNum;
                    String arrFULL = "";
                    for (int i = 0; i < arrPro.length; ++i) {
                        String arr = arrPro[i];
                        arrFULL = i < arrPro.length - 1 ? arrFULL + arr + DELIMIT : arrFULL + arr;
                    }
                    clonedProtein.setParameter(arrFULL);
                    clonedProtein.setVertical(protein.getVertical() - 100);
                    this.canvasPanel.getProteinList().add(clonedProtein);
                    protein.setIsActive(false);
                } else {
                    int iwide;
                    Component clonedDomain;
                    LinkedList<Component> componentList = protein.getComponentList();
                    Component selectedComponent = componentList.get(selectNum);
                    if (selectedComponent.getType() == ComponentEnum.Domain) {
                        strNum = this.getDefaultID(ComponentEnum.Domain.name());
                        clonedDomain = (Component)selectedComponent.clone();
                        clonedDomain.fid = strNum;
                        iwide = (int)(selectedComponent.getX2() - selectedComponent.getX());
                        clonedDomain.setX((int)selectedComponent.getX() + 20 + iwide);
                        clonedDomain.setX2((int)(selectedComponent.getX2() + 20.0 + (double)iwide));
                        clonedDomain.bSelected = true;
                        clonedDomain.setIsActive(true);
                        this.canvasPanel.ComponentSelect = clonedDomain;
                        clonedDomain.GeomArea = selectedComponent.GeomArea;
                        clonedDomain.setArea(selectedComponent.getArea());
                        componentList.add(clonedDomain);
                    }
                    if (selectedComponent.getType() == ComponentEnum.CutLine) {
                        strNum = this.getDefaultID(ComponentEnum.CutLine.name());
                        clonedDomain = (Component)selectedComponent.clone();
                        clonedDomain.fid = strNum;
                        iwide = (int)(selectedComponent.getX2() - selectedComponent.getX());
                        clonedDomain.setX((int)selectedComponent.getX() + 20 + iwide);
                        clonedDomain.setX2((int)(selectedComponent.getX2() + 20.0 + (double)iwide));
                        clonedDomain.bSelected = true;
                        clonedDomain.setIsActive(true);
                        this.canvasPanel.ComponentSelect = clonedDomain;
                        clonedDomain.GeomArea = selectedComponent.GeomArea;
                        clonedDomain.setArea(selectedComponent.getArea());
                        componentList.add(clonedDomain);
                    } else if (selectedComponent.getType() == ComponentEnum.Site) {
                        strNum = this.getDefaultID(ComponentEnum.Site.name());
                        Component clonedSite = (Component)selectedComponent.clone();
                        clonedSite.fid = strNum;
                        int deltacenterx = 0;
                        int deltacentery = 0;
                        int deltaposition = 0;
                        int proteinlen = 0;
                        String sdeltacenterx = "";
                        String sdeltacentery = "";
                        String sdeltaposition = "";
                        sdeltacenterx = this.config.getString("SiteClone.deltaCenterxRate");
                        sdeltacentery = this.config.getString("SiteClone.deltaCenteryRate");
                        sdeltaposition = this.config.getString("SiteClone.deltaPositionRate");
                        proteinlen = protein.getEnd();
                        deltacenterx = (int)((double)proteinlen * Double.parseDouble(sdeltacenterx));
                        deltacentery = (int)((double)proteinlen * Double.parseDouble(sdeltacentery));
                        deltaposition = (int)((double)proteinlen * Double.parseDouble(sdeltaposition));
                        clonedSite.setX(selectedComponent.getX() + (double)deltacenterx);
                        clonedSite.setY(selectedComponent.getY() + deltacentery);
                        clonedSite.setCenterx(selectedComponent.getCenterx() + (double)deltacenterx);
                        clonedSite.setCentery(selectedComponent.getCentery() + (double)deltacentery);
                        String[] arr = selectedComponent.getParameter().split(DELIMIT);
                        String fsite = arr[0];
                        StringTokenizer st = new StringTokenizer(fsite, ";");
                        int siteCount = st.countTokens();
                        String nsite = " ";
                        while (st.hasMoreTokens()) {
                            int tsite = Integer.parseInt(st.nextToken());
                            tsite += deltaposition;
                            if (nsite.equals(" ")) {
                                nsite = String.valueOf(tsite);
                                continue;
                            }
                            nsite = nsite + ";" + String.valueOf(tsite);
                        }
                        String nParameter = "";
                        arr[0] = nsite;
                        for (int l = 0; l < arr.length; ++l) {
                            nParameter = l == 0 ? arr[l] : nParameter + DELIMIT + arr[l];
                        }
                        clonedSite.parameter = nParameter;
                        clonedSite.bSelected = true;
                        clonedSite.setIsActive(true);
                        this.canvasPanel.ComponentSelect = clonedSite;
                        clonedSite.GeomArea = selectedComponent.GeomArea;
                        clonedSite.setArea(selectedComponent.getArea());
                        componentList.add(clonedSite);
                    } else if (selectedComponent.getType() == ComponentEnum.Note) {
                        strNum = this.getDefaultID(ComponentEnum.Note.name());
                        Component clonedNote = (Component)selectedComponent.clone();
                        clonedNote.fid = strNum;
                        clonedNote.setX(selectedComponent.getX() + 30.0);
                        clonedNote.setY(selectedComponent.getY() + 30);
                        clonedNote.bSelected = true;
                        clonedNote.setIsActive(true);
                        this.canvasPanel.ComponentSelect = clonedNote;
                        clonedNote.GeomArea = selectedComponent.GeomArea;
                        clonedNote.setArea(selectedComponent.getArea());
                        componentList.add(clonedNote);
                    } else if (selectedComponent.getType() == ComponentEnum.Line) {
                        strNum = this.getDefaultID(ComponentEnum.Line.name());
                        Component clonedLine = (Component)selectedComponent.clone();
                        clonedLine.fid = strNum;
                        clonedLine.setX(selectedComponent.getX() + 30.0);
                        clonedLine.setY(selectedComponent.getY() + 30);
                        clonedLine.setControlx1(selectedComponent.getControlx1() + 30);
                        clonedLine.setControly1(selectedComponent.getControly1() + 30);
                        clonedLine.setControlx2(selectedComponent.getControlx2() + 30);
                        clonedLine.setControly2(selectedComponent.getControly2() + 30);
                        clonedLine.setX2(selectedComponent.getX2() + 30.0);
                        clonedLine.setY2(selectedComponent.getY2() + 30);
                        clonedLine.bSelected = true;
                        clonedLine.setIsActive(true);
                        this.canvasPanel.ComponentSelect = clonedLine;
                        clonedLine.GeomArea = selectedComponent.GeomArea;
                        clonedLine.setArea(selectedComponent.getArea());
                        componentList.add(clonedLine);
                    } else if (selectedComponent.getType() == ComponentEnum.Polygon) {
                        strNum = this.getDefaultID(ComponentEnum.Polygon.name());
                        Component clonedPolygon = (Component)selectedComponent.clone();
                        clonedPolygon.fid = strNum;
                        clonedPolygon.setCenterx(selectedComponent.getCenterx() + 30.0);
                        clonedPolygon.setCentery(selectedComponent.getCentery() + 30.0);
                        clonedPolygon.bSelected = true;
                        clonedPolygon.setIsActive(true);
                        this.canvasPanel.ComponentSelect = clonedPolygon;
                        clonedPolygon.GeomArea = selectedComponent.GeomArea;
                        clonedPolygon.setArea(selectedComponent.getArea());
                        componentList.add(clonedPolygon);
                    } else if (selectedComponent.getType() == ComponentEnum.Bracket) {
                        strNum = this.getDefaultID(ComponentEnum.Bracket.name());
                        Component clonedBracket = (Component)selectedComponent.clone();
                        clonedBracket.fid = strNum;
                        clonedBracket.setCenterx(selectedComponent.getCenterx() + 30.0);
                        clonedBracket.setCentery(selectedComponent.getCentery() + 30.0);
                        clonedBracket.bSelected = true;
                        clonedBracket.setIsActive(true);
                        this.canvasPanel.ComponentSelect = clonedBracket;
                        clonedBracket.GeomArea = selectedComponent.GeomArea;
                        clonedBracket.setArea(selectedComponent.getArea());
                        componentList.add(clonedBracket);
                    }
                    selectedComponent.setIsActive(false);
                    selectedComponent.setbSelected(false);
                }
                this.canvasPanel.repaint();
                this.repaintList();
                try {
                    this.canvasPanel.saveCurrentState();
                }
                catch (CloneNotSupportedException ex) {
                    ex.printStackTrace();
                }
            }
            catch (CloneNotSupportedException ex) {
                Logger.getLogger(IBSFrame.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void editComponentMenuItemActionPerformed(ActionEvent evt) {
        if (!this.list.isSelectionEmpty()) {
            this.callEditDialog();
        }
    }

    private void canvasMenuItemActionPerformed(ActionEvent evt) {
        Tools.WindowCenter(new CanvasSizeDialog(this.canvasPanel, this, true));
        this.setCanvasSize();
    }

    private void previousButtonActionPerformed(ActionEvent evt) {
        --this.demoNum;
        if (this.demoNum < 0) {
            this.demoNum = this.DEMO_SUM - 1;
        }
        String fileName = this.arrayString[this.demoNum];
        this.setTitle(" Demo - " + fileName);
        this.openProject(fileName);
    }

    private void jComboBoxScaleActionPerformed(ActionEvent evt) {
        if (this.isOpening) {
            return;
        }
        int index = this.jComboBoxScale.getSelectedIndex();
        double dscale = 1.0;
        if (index == 0) {
            dscale = 0.7;
        } else if (index == 1) {
            dscale = 0.8;
        } else if (index == 2) {
            dscale = 0.9;
        } else if (index == 3) {
            dscale = 1.0;
        } else if (index == 4) {
            dscale = 1.5;
        } else if (index == 5) {
            dscale = 2.0;
        } else if (index == 6) {
            dscale = 2.5;
        } else if (index == 7) {
            dscale = 3.0;
        } else if (index == 8) {
            dscale = 3.5;
        } else if (index == 9) {
            dscale = 4.0;
        } else if (index == 10) {
            dscale = 4.5;
        } else if (index == 11) {
            dscale = 5.0;
        } else if (index == 12) {
            dscale = 5.5;
        } else if (index == 13) {
            dscale = 6.0;
        } else if (index == 14) {
            dscale = 6.5;
        } else if (index == 15) {
            dscale = 7.0;
        } else if (index == 16) {
            dscale = 7.5;
        } else if (index == 17) {
            dscale = 8.0;
        }
        this.canvasPanel.zoomOutScale(dscale);
        if (this.canvasPanel.getWidth() > this.canvasScrollPane.getWidth()) {
            this.canvasScrollPane.getViewport().setViewPosition(new Point(this.canvasPanel.getWidth() / 4, this.canvasPanel.getHeight() / 4));
        }
        this.setCanvasSize();
    }

    private void jCheckBoxGrayItemStateChanged(ItemEvent evt) {
        if (this.jCheckBoxGray.isSelected()) {
            this.canvasPanel.setbGray(true);
        } else {
            this.canvasPanel.setbGray(false);
        }
        this.canvasPanel.repaint();
    }

    private void moveEndMenuItemActionPerformed(ActionEvent evt) {
        if (!this.list.isSelectionEmpty()) {
            Protein protein = this.getIndexProtein(this.list.getSelectedIndex());
            int selectNum = protein.getSelectNum();
            LinkedList<Component> componentList = protein.getComponentList();
            if (selectNum >= 0 && selectNum < componentList.size() - 1) {
                Component temp = componentList.get(componentList.size() - 1);
                componentList.set(componentList.size() - 1, componentList.get(selectNum));
                componentList.set(selectNum, temp);
                this.canvasPanel.repaint();
                this.repaintList();
                try {
                    this.canvasPanel.saveCurrentState();
                }
                catch (CloneNotSupportedException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    private void moveTopMenuItemActionPerformed(ActionEvent evt) {
        Protein protein;
        int selectNum;
        if (!this.list.isSelectionEmpty() && (selectNum = (protein = this.getIndexProtein(this.list.getSelectedIndex())).getSelectNum()) > 0) {
            LinkedList<Component> componentList = protein.getComponentList();
            Component temp = componentList.get(0);
            componentList.set(0, componentList.get(selectNum));
            componentList.set(selectNum, temp);
            this.canvasPanel.repaint();
            this.repaintList();
            try {
                this.canvasPanel.saveCurrentState();
            }
            catch (CloneNotSupportedException ex) {
                ex.printStackTrace();
            }
        }
    }

    private void drawPanelMouseClicked(MouseEvent evt) {
        if (SwingUtilities.isLeftMouseButton(evt) && evt.getClickCount() == 2) {
            this.callEditDialog(evt.getX() - this.canvasPanel.getWidth() / 2, evt.getY() - this.canvasPanel.getHeight() / 2);
        }
    }

    private void drawPanelMousePressed(MouseEvent evt) {
        if (SwingUtilities.isLeftMouseButton(evt)) {
            this.activeProtein(evt.getX() - this.canvasPanel.getWidth() / 2, evt.getY() - this.canvasPanel.getHeight() / 2);
        }
        if (SwingUtilities.isRightMouseButton(evt)) {
            this.activeProtein(evt.getX() - this.canvasPanel.getWidth() / 2, evt.getY() - this.canvasPanel.getHeight() / 2);
            if (this.canvasPanel.getProteinList().size() > 0) {
                this.panelMenu.show(evt.getComponent(), evt.getX(), evt.getY());
            }
        }
    }

    private void drawPanelMouseWheelMoved(MouseWheelEvent evt) {
        int index;
        int icount = this.jComboBoxScale.getItemCount() - 1;
        index = evt.getWheelRotation() < 0 ? ((index = this.jComboBoxScale.getSelectedIndex()) >= icount ? icount : ++index) : ((index = this.jComboBoxScale.getSelectedIndex()) <= 0 ? 0 : --index);
        this.jComboBoxScale.setSelectedIndex(index);
        if (this.canvasPanel.getWidth() > this.canvasScrollPane.getWidth()) {
            this.canvasScrollPane.getViewport().setViewPosition(new Point(this.canvasPanel.getWidth() / 4, this.canvasPanel.getHeight() / 4));
        }
        this.setCanvasSize();
        int po = (int)(this.canvasPanel.rate * 100.0f);
        if (po > 500) {
            po = 500;
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                Tools.WindowCenter(new DemoFrame());
            }
        });
    }

    public String getDefaultID(String strType) {
        String strMaxId = "";
        if (strType.equals("Protein") || strType.equals("Nucleotide")) {
            int iMaxNum = 0;
            for (Protein protein : this.canvasPanel.getProteinList()) {
                int iNum;
                String strNum;
                String[] arrPro = protein.getParameter().split(DELIMIT);
                String strId = arrPro[11].trim();
                if (strId.equals("") || strId == null || strId.indexOf(strType) != 0 || strId.length() != strType.length() + 3 || !Tools.isNumber(strNum = strId.substring(strType.length(), strType.length() + 3)) || iMaxNum >= (iNum = Integer.valueOf(strNum).intValue())) continue;
                iMaxNum = iNum;
            }
            DecimalFormat df = new DecimalFormat();
            String pattern = "000";
            df.applyPattern(pattern);
            strMaxId = strType + df.format(++iMaxNum);
            return strMaxId;
        }
        int iMaxNum = 0;
        Protein pr = this.canvasPanel.getCurrentProtein();
        if (pr == null) {
            return "";
        }
        LinkedList<Component> componentList = pr.getComponentList();
        for (Component component : componentList) {
            int iNum;
            String strNum;
            String strId;
            if (!component.getType().name().equals(strType)) continue;
            if (strType.trim().equals("Polygon")) {
                strType = "Marker";
            }
            if (component.fid == null || (strId = component.fid.trim()).equals("") || strId == null || strId.indexOf(strType) != 0 || strId.length() != strType.length() + 3 || !Tools.isNumber(strNum = strId.substring(strType.length(), strType.length() + 3)) || iMaxNum >= (iNum = Integer.valueOf(strNum).intValue())) continue;
            iMaxNum = iNum;
        }
        if (strType.trim().equals("Polygon")) {
            strType = "Marker";
        }
        DecimalFormat df = new DecimalFormat();
        String pattern = "000";
        df.applyPattern(pattern);
        strMaxId = strType + df.format(++iMaxNum);
        return strMaxId;
    }

    public double getRelaRate(double rateIn) {
        int i;
        int itemCount = this.jComboBoxScale.getItemCount();
        double[] rateL = new double[itemCount];
        for (i = 0; i < itemCount; ++i) {
            String strRate = this.jComboBoxScale.getItemAt(i).toString();
            strRate = strRate.substring(0, strRate.length() - 1);
            rateL[i] = (double)Float.valueOf(strRate).floatValue() / 100.0;
        }
        for (i = 0; i < itemCount; ++i) {
            if (rateL[i] == rateIn) {
                this.jComboBoxScale.setSelectedIndex(i);
                return rateL[i];
            }
            if (i == 0) continue;
            if (rateL[i] >= rateIn && rateL[i - 1] < rateIn) {
                this.jComboBoxScale.setSelectedIndex(i - 1);
                return rateL[i - 1];
            }
            if (!(rateL[i] > rateIn) || i != itemCount - 1) continue;
            this.jComboBoxScale.setSelectedIndex(i);
            return rateL[i];
        }
        return 1.0;
    }

    static {
        mode = "";
    }
}

