/*
 * Decompiled with CFR 0.152.
 */
package gui.ibs;

import gui.Filter;
import gui.MultiFilter;
import gui.TiffOutput;
import gui.Tools;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ImageFormatDialog
extends JDialog {
    private JButton closeButton;
    private JPanel consolePanel;
    private JButton convertButton;
    private JTextField imageTextField;
    private JButton loadButton;
    private JPanel mainPanel;

    public ImageFormatDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    private void exprotImage() {
        block15: {
            String inputPath = this.imageTextField.getText().trim();
            if (!inputPath.equals("")) {
                try {
                    BufferedImage image = ImageIO.read(new File(inputPath));
                    JFileChooser fc = new JFileChooser(Tools.CURRENT_FILE_PATH);
                    fc.setAcceptAllFileFilterUsed(false);
                    fc.addChoosableFileFilter(new Filter("TIFF", "TIFF (*.TIFF 1200dpi)"));
                    fc.addChoosableFileFilter(new Filter("TIFF", "TIFF (*.TIFF 900dpi)"));
                    fc.addChoosableFileFilter(new Filter("TIFF", "TIFF (*.TIFF 600dpi)"));
                    fc.addChoosableFileFilter(new Filter("TIFF", "TIFF (*.TIFF 300dpi)"));
                    int returnVal = fc.showSaveDialog(this);
                    if (returnVal != 0) break block15;
                    String outputPath = fc.getSelectedFile().getPath();
                    if (fc.getFileFilter().getDescription().startsWith("TIFF") && !outputPath.toUpperCase().endsWith(".TIFF")) {
                        outputPath = outputPath + ".TIFF";
                    }
                    File exportfile = new File(outputPath);
                    int confirm = 0;
                    if (!exportfile.exists()) {
                        exportfile.createNewFile();
                    } else {
                        confirm = JOptionPane.showConfirmDialog(null, "Image file already exists.Would you like to overwrite it?", "Warning", 0, 2, null);
                    }
                    if (confirm == 0) {
                        if (fc.getFileFilter().getDescription().equals("TIFF (*.TIFF 1200dpi)")) {
                            new TiffOutput(image, outputPath, 1200);
                        } else if (fc.getFileFilter().getDescription().equals("TIFF (*.TIFF 900dpi)")) {
                            new TiffOutput(image, outputPath, 900);
                        } else if (fc.getFileFilter().getDescription().equals("TIFF (*.TIFF 600dpi)")) {
                            new TiffOutput(image, outputPath, 600);
                        } else if (fc.getFileFilter().getDescription().equals("TIFF (*.TIFF 300dpi)")) {
                            new TiffOutput(image, outputPath, 300);
                        }
                        Tools.CURRENT_FILE_PATH = outputPath;
                        JOptionPane.showMessageDialog(this, "Image export to  " + outputPath + "  successfully !");
                    }
                }
                catch (IOException ex) {
                    JOptionPane.showMessageDialog(this, "Image file not exist or currupted.", "Error", 0);
                }
            } else {
                JOptionPane.showMessageDialog(this, "Please load a image.", "Warning", 2);
            }
        }
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.imageTextField = new JTextField();
        this.loadButton = new JButton();
        this.consolePanel = new JPanel();
        this.convertButton = new JButton();
        this.closeButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Image Format Converter");
        this.mainPanel.setBorder(BorderFactory.createTitledBorder(null, "Load Image", 0, 0, new Font("Arial", 1, 14)));
        this.mainPanel.setPreferredSize(new Dimension(320, 60));
        this.mainPanel.setLayout(new GridBagLayout());
        this.imageTextField.setPreferredSize(new Dimension(250, 23));
        this.mainPanel.add((Component)this.imageTextField, new GridBagConstraints());
        this.loadButton.setFont(new Font("Arial", 0, 12));
        this.loadButton.setText(">>");
        this.loadButton.setToolTipText("Load image in JPG/GIF/PNG/TIFF format");
        this.loadButton.setMaximumSize(new Dimension(147, 23));
        this.loadButton.setPreferredSize(new Dimension(50, 23));
        this.loadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageFormatDialog.this.loadButtonActionPerformed(evt);
            }
        });
        this.mainPanel.add((Component)this.loadButton, new GridBagConstraints());
        this.getContentPane().add((Component)this.mainPanel, "Center");
        this.consolePanel.setPreferredSize(new Dimension(320, 50));
        this.consolePanel.setLayout(null);
        this.convertButton.setFont(new Font("Arial", 1, 12));
        this.convertButton.setText("Convert to TIFF");
        this.convertButton.setMaximumSize(new Dimension(170, 23));
        this.convertButton.setMinimumSize(new Dimension(100, 23));
        this.convertButton.setPreferredSize(new Dimension(150, 23));
        this.convertButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageFormatDialog.this.convertButtonActionPerformed(evt);
            }
        });
        this.consolePanel.add(this.convertButton);
        this.convertButton.setBounds(160, 10, 150, 23);
        this.closeButton.setFont(new Font("Arial", 1, 12));
        this.closeButton.setText("Close");
        this.closeButton.setMaximumSize(new Dimension(165, 23));
        this.closeButton.setPreferredSize(new Dimension(100, 23));
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageFormatDialog.this.closeButtonActionPerformed(evt);
            }
        });
        this.consolePanel.add(this.closeButton);
        this.closeButton.setBounds(10, 10, 100, 23);
        this.getContentPane().add((Component)this.consolePanel, "South");
        this.pack();
    }

    private void loadButtonActionPerformed(ActionEvent evt) {
        JFileChooser fc = new JFileChooser(Tools.CURRENT_FILE_PATH);
        fc.setAcceptAllFileFilterUsed(false);
        fc.addChoosableFileFilter(new MultiFilter("JPG/JPEG/PNG/GIF/TIF/TIFF", "JPG/PNG/GIF/TIFF (*.JPG;*.JPEG;*.PNG;*.GIF;*.TIF;*.TIFF)"));
        int returnVal = fc.showOpenDialog(this);
        if (returnVal == 0) {
            this.imageTextField.setText(fc.getSelectedFile().getPath());
            Tools.CURRENT_FILE_PATH = fc.getSelectedFile().getAbsolutePath();
        }
    }

    private void convertButtonActionPerformed(ActionEvent evt) {
        this.exprotImage();
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }
}

