/*
 * Decompiled with CFR 0.152.
 */
package gui.ibs;

import gui.Filter;
import gui.Tools;
import gui.ibs.CanvasPanel;
import gui.ibs.ToolOutPut;
import gui.ibs.Verifier;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class OutputJDialog
extends JDialog {
    private CanvasPanel canvasPanel;
    private int width;
    private int height;
    private double ratio;
    private DecimalFormat df = new DecimalFormat("##");
    private JButton cancelButton;
    private JTextField exportFileTextField;
    private JPanel exportPanel;
    private JLabel heightLabel;
    private JTextField heightTextField;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JButton okButton;
    private JPanel parameterPanel;
    private JCheckBox ratioCheckBox;
    private JComboBox resolutionComboBox;
    private JLabel resolutionLabel;
    private JButton selectButton;
    private JComboBox unitComboBox;
    private JLabel unitLabel;
    private JLabel widthLabel;
    private JTextField widthTextField;

    public OutputJDialog(CanvasPanel canvasPanel, Frame parent, boolean modal) {
        super(parent, modal);
        this.canvasPanel = canvasPanel;
        this.setPreferredSize(new Dimension(560, 260));
        this.initComponents();
        this.width = Math.round(canvasPanel.getWidth());
        this.height = Math.round(canvasPanel.getHeight());
        this.widthTextField.setText(String.valueOf(this.width));
        this.heightTextField.setText(String.valueOf(this.height));
        this.ratio = (float)this.width / (float)this.height;
    }

    private void selectImage() {
        if (this.canvasPanel.getProteinList().size() > 0) {
            JFileChooser fc = new JFileChooser(Tools.CURRENT_FILE_PATH);
            fc.setAcceptAllFileFilterUsed(false);
            if (this.resolutionComboBox.getSelectedItem().equals("72 dpi")) {
                fc.addChoosableFileFilter(new Filter("JPG", "JPG (*.JPG 72dpi)"));
                fc.addChoosableFileFilter(new Filter("PNG", "PNG (*.PNG 72dpi)"));
            } else if (this.resolutionComboBox.getSelectedItem().equals("300 dpi")) {
                fc.addChoosableFileFilter(new Filter("TIFF", "TIFF (*.TIFF 300dpi)"));
            } else if (this.resolutionComboBox.getSelectedItem().equals("600 dpi")) {
                fc.addChoosableFileFilter(new Filter("TIFF", "TIFF (*.TIFF 600dpi)"));
            } else if (this.resolutionComboBox.getSelectedItem().equals("vector image")) {
                fc.addChoosableFileFilter(new Filter("SVG", "SVG (*.SVG)"));
            }
            int returnVal = fc.showSaveDialog(this);
            if (returnVal == 0) {
                String selectedFilePath = fc.getSelectedFile().getPath();
                if (fc.getFileFilter().getDescription().startsWith("PNG")) {
                    if (!selectedFilePath.toUpperCase().endsWith(".PNG")) {
                        selectedFilePath = selectedFilePath + ".png";
                    }
                } else if (fc.getFileFilter().getDescription().startsWith("JPG")) {
                    if (!selectedFilePath.toUpperCase().endsWith(".JPG")) {
                        selectedFilePath = selectedFilePath + ".jpg";
                    }
                } else if (fc.getFileFilter().getDescription().startsWith("TIFF")) {
                    if (!selectedFilePath.toUpperCase().endsWith(".TIFF")) {
                        selectedFilePath = selectedFilePath + ".tiff";
                    }
                } else if (fc.getFileFilter().getDescription().startsWith("SVG") && !selectedFilePath.toUpperCase().endsWith(".SVG")) {
                    selectedFilePath = selectedFilePath + ".svg";
                }
                Tools.CURRENT_FILE_PATH = selectedFilePath;
                this.exportFileTextField.setText(selectedFilePath);
            }
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.exportPanel = new JPanel();
        this.exportFileTextField = new JTextField();
        this.selectButton = new JButton();
        this.parameterPanel = new JPanel();
        this.widthLabel = new JLabel();
        this.widthTextField = new JTextField();
        this.unitComboBox = new JComboBox();
        this.heightLabel = new JLabel();
        this.heightTextField = new JTextField();
        this.unitLabel = new JLabel();
        this.resolutionLabel = new JLabel();
        this.resolutionComboBox = new JComboBox();
        this.ratioCheckBox = new JCheckBox();
        this.jPanel2 = new JPanel();
        this.cancelButton = new JButton();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.okButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Export Image");
        this.jPanel1.setPreferredSize(new Dimension(367, 200));
        this.jPanel1.setLayout(new BorderLayout());
        this.exportPanel.setBorder(BorderFactory.createTitledBorder(null, "Export File", 0, 0, new Font("Arial", 1, 14)));
        this.exportPanel.setPreferredSize(new Dimension(367, 60));
        this.exportPanel.setLayout(new BoxLayout(this.exportPanel, 2));
        this.exportFileTextField.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.exportFileTextField.setEnabled(false);
        this.exportFileTextField.setMaximumSize(new Dimension(1500, 25));
        this.exportFileTextField.setPreferredSize(new Dimension(300, 25));
        this.exportPanel.add(this.exportFileTextField);
        this.selectButton.setFont(new Font("Arial", 1, 14));
        this.selectButton.setText(">>");
        this.selectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OutputJDialog.this.selectButtonActionPerformed(evt);
            }
        });
        this.exportPanel.add(this.selectButton);
        this.jPanel1.add((Component)this.exportPanel, "South");
        this.parameterPanel.setBorder(BorderFactory.createTitledBorder(null, "Image Parameter", 0, 0, new Font("Arial", 1, 14)));
        this.parameterPanel.setPreferredSize(new Dimension(360, 130));
        this.parameterPanel.setLayout(new GridLayout(3, 3, 10, 10));
        this.widthLabel.setFont(new Font("Arial", 1, 12));
        this.widthLabel.setHorizontalAlignment(4);
        this.widthLabel.setText("Width");
        this.parameterPanel.add(this.widthLabel);
        this.widthTextField.setFont(new Font("Arial", 0, 12));
        this.widthTextField.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.widthTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                OutputJDialog.this.widthTextFieldKeyReleased(evt);
            }
        });
        this.parameterPanel.add(this.widthTextField);
        this.unitComboBox.setFont(new Font("Arial", 1, 12));
        this.unitComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"cm", "mm", "pix", "inch"}));
        this.unitComboBox.setSelectedIndex(2);
        this.unitComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                OutputJDialog.this.unitComboBoxItemStateChanged(evt);
            }
        });
        this.parameterPanel.add(this.unitComboBox);
        this.heightLabel.setFont(new Font("Arial", 1, 12));
        this.heightLabel.setHorizontalAlignment(4);
        this.heightLabel.setText("Height");
        this.parameterPanel.add(this.heightLabel);
        this.heightTextField.setFont(new Font("Arial", 0, 12));
        this.heightTextField.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.heightTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                OutputJDialog.this.heightTextFieldKeyReleased(evt);
            }
        });
        this.parameterPanel.add(this.heightTextField);
        this.unitLabel.setFont(new Font("Arial", 1, 12));
        this.unitLabel.setText(" pix");
        this.parameterPanel.add(this.unitLabel);
        this.resolutionLabel.setFont(new Font("Arial", 1, 12));
        this.resolutionLabel.setHorizontalAlignment(4);
        this.resolutionLabel.setText("Resolution");
        this.parameterPanel.add(this.resolutionLabel);
        this.resolutionComboBox.setFont(new Font("Arial", 1, 12));
        this.resolutionComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"72 dpi", "300 dpi", "600 dpi", "vector image"}));
        this.resolutionComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                OutputJDialog.this.resolutionComboBoxItemStateChanged(evt);
            }
        });
        this.parameterPanel.add(this.resolutionComboBox);
        this.ratioCheckBox.setFont(new Font("Arial", 1, 12));
        this.ratioCheckBox.setSelected(true);
        this.ratioCheckBox.setText("Keep width-height ratio");
        this.parameterPanel.add(this.ratioCheckBox);
        this.jPanel1.add((Component)this.parameterPanel, "Center");
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.jPanel2.setPreferredSize(new Dimension(399, 30));
        this.jPanel2.setLayout(new GridLayout(1, 0));
        this.cancelButton.setFont(new Font("Arial", 1, 12));
        this.cancelButton.setText("Cancel");
        this.cancelButton.setMaximumSize(new Dimension(120, 23));
        this.cancelButton.setPreferredSize(new Dimension(90, 23));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OutputJDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.cancelButton);
        this.jPanel2.add(this.jLabel1);
        this.jPanel2.add(this.jLabel2);
        this.okButton.setFont(new Font("Arial", 1, 12));
        this.okButton.setText("Export");
        this.okButton.setMaximumSize(new Dimension(120, 23));
        this.okButton.setPreferredSize(new Dimension(90, 23));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OutputJDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.okButton);
        this.getContentPane().add((Component)this.jPanel2, "South");
        this.pack();
    }

    private void selectButtonActionPerformed(ActionEvent evt) {
        this.selectImage();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        boolean isWidthTextValiable = new Verifier().isPositive(this.widthTextField);
        boolean isHeightTextValiable = new Verifier().isPositive(this.heightTextField);
        boolean isExportFileEmpty = new Verifier().isEmpty(this.exportFileTextField);
        StringBuffer errorSb = new StringBuffer();
        if (isExportFileEmpty) {
            errorSb.append("Export File : Please choose an export file\n");
        }
        if (!isWidthTextValiable) {
            errorSb.append("Width : should be a positive number \n");
        }
        if (!isHeightTextValiable) {
            errorSb.append("Height : should be a positive number \n");
        }
        if (!isExportFileEmpty && isWidthTextValiable && isHeightTextValiable) {
            String exportFilePath = this.exportFileTextField.getText();
            File exportfile = new File(exportFilePath);
            int confirm = 0;
            if (!exportfile.exists()) {
                try {
                    exportfile.createNewFile();
                }
                catch (IOException ex) {
                    Logger.getLogger(OutputJDialog.class.getName()).log(Level.SEVERE, null, ex);
                }
            } else {
                confirm = JOptionPane.showConfirmDialog(this, "Image file already exists.Would you like to overwrite it?", "Warning", 0, 2, null);
            }
            if (confirm == 0) {
                this.canvasPanel.batchOutrate = 0.0f;
                this.width = (int)Double.parseDouble(this.widthTextField.getText());
                this.height = (int)Double.parseDouble(this.heightTextField.getText());
                String strFormat = "";
                if (this.resolutionComboBox.getSelectedItem().equals("72 dpi")) {
                    strFormat = exportFilePath.toUpperCase().endsWith(".PNG") ? "A" : "B";
                } else if (this.resolutionComboBox.getSelectedItem().equals("300 dpi")) {
                    strFormat = "C";
                } else if (this.resolutionComboBox.getSelectedItem().equals("600 dpi")) {
                    strFormat = "D";
                } else if (this.resolutionComboBox.getSelectedItem().equals("vector image")) {
                    strFormat = "E";
                }
                String strUnit = this.unitComboBox.getSelectedItem().toString();
                boolean bwhratio = this.ratioCheckBox.isSelected();
                ToolOutPut op = new ToolOutPut();
                this.width = (int)Double.parseDouble(this.widthTextField.getText());
                this.height = (int)Double.parseDouble(this.heightTextField.getText());
                Tools.CURRENT_FILE_PATH = exportFilePath;
                ToolOutPut.currentOneoutput(this, this.canvasPanel, exportFilePath, strFormat, strUnit, this.width, this.height, bwhratio);
            }
        } else {
            JOptionPane.showConfirmDialog(this, errorSb.toString(), "Parameter Error", -1, 0, null);
        }
    }

    private void widthTextFieldKeyReleased(KeyEvent evt) {
        try {
            double w = Double.parseDouble(this.widthTextField.getText());
            double h = Double.parseDouble(this.heightTextField.getText());
            if (this.ratioCheckBox.isSelected()) {
                h = w / this.ratio;
                this.heightTextField.setText(this.df.format(h));
            }
            this.ratio = (double)((float)w) / h;
            if (this.unitComboBox.getSelectedItem().equals("pix")) {
                this.width = (int)w;
                this.height = (int)h;
            } else if (this.unitComboBox.getSelectedItem().equals("cm")) {
                this.width = (int)(w * 72.0 / 2.54);
                this.height = (int)(h * 72.0 / 2.54);
            } else if (this.unitComboBox.getSelectedItem().equals("mm")) {
                this.width = (int)(w * 72.0 / 25.4);
                this.height = (int)(h * 72.0 / 25.4);
            } else if (this.unitComboBox.getSelectedItem().equals("inch")) {
                this.width = (int)(w * 72.0);
                this.height = (int)(h * 72.0);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void heightTextFieldKeyReleased(KeyEvent evt) {
        try {
            double h = Double.parseDouble(this.heightTextField.getText());
            double w = Double.parseDouble(this.widthTextField.getText());
            if (this.ratioCheckBox.isSelected()) {
                w = h * this.ratio;
                this.widthTextField.setText(this.df.format(w));
            }
            this.ratio = (double)((float)w) / h;
            if (this.unitComboBox.getSelectedItem().equals("pix")) {
                this.width = (int)w;
                this.height = (int)h;
            } else if (this.unitComboBox.getSelectedItem().equals("cm")) {
                this.width = (int)(w * 72.0 / 2.54);
                this.height = (int)(h * 72.0 / 2.54);
            } else if (this.unitComboBox.getSelectedItem().equals("mm")) {
                this.width = (int)(w * 72.0 / 25.4);
                this.height = (int)(h * 72.0 / 25.4);
            } else if (this.unitComboBox.getSelectedItem().equals("inch")) {
                this.width = (int)(w * 72.0);
                this.height = (int)(h * 72.0);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void unitComboBoxItemStateChanged(ItemEvent evt) {
        if (this.unitComboBox.getSelectedItem().equals("pix")) {
            if (this.resolutionComboBox.getSelectedItem().equals("72 dpi") || this.resolutionComboBox.getSelectedItem().equals("vector image")) {
                this.widthTextField.setText(String.valueOf(this.width));
                this.heightTextField.setText(String.valueOf(this.height));
            } else if (this.resolutionComboBox.getSelectedItem().equals("300 dpi")) {
                if (2125.984251968504 < (double)(this.width * 300 / 72)) {
                    this.widthTextField.setText(String.valueOf(this.df.format(2125.984251968504)));
                    this.heightTextField.setText(String.valueOf(this.df.format(1535.4330708661416)));
                } else {
                    this.widthTextField.setText(String.valueOf(this.width * 300 / 72));
                    this.heightTextField.setText(String.valueOf(this.height * 300 / 72));
                }
            } else if (this.resolutionComboBox.getSelectedItem().equals("600 dpi")) {
                if (4251.968503937008 < (double)(this.width * 600 / 72)) {
                    this.widthTextField.setText(String.valueOf(this.df.format(4251.968503937008)));
                    this.heightTextField.setText(String.valueOf(this.df.format(3070.8661417322833)));
                } else {
                    this.widthTextField.setText(String.valueOf(this.width * 600 / 72));
                    this.heightTextField.setText(String.valueOf(this.height * 600 / 72));
                }
            }
            this.unitLabel.setText(" pix");
        } else if (this.unitComboBox.getSelectedItem().equals("cm")) {
            this.unitLabel.setText(" cm");
            if (this.resolutionComboBox.getSelectedIndex() == 0) {
                this.widthTextField.setText(this.df.format((double)this.width / 72.0 * 2.54));
                this.heightTextField.setText(this.df.format((double)this.height / 72.0 * 2.54));
            } else if (18.0 < (double)this.width / 72.0 * 2.54) {
                double wt = 13.5;
                DecimalFormat df = new DecimalFormat("#.00");
                df.format(wt);
                this.heightTextField.setText(String.format("%.2f", wt));
                this.widthTextField.setText("18.00");
            } else {
                this.widthTextField.setText(this.df.format((double)this.width / 72.0 * 2.54));
                this.heightTextField.setText(this.df.format((double)this.height / 72.0 * 2.54));
            }
        } else if (this.unitComboBox.getSelectedItem().equals("mm")) {
            if (this.resolutionComboBox.getSelectedItem().equals("300 dpi") || this.resolutionComboBox.getSelectedItem().equals("600 dpi")) {
                if (18.0 < (double)this.width / 72.0 * 25.4 / 10.0) {
                    this.widthTextField.setText("180.00");
                    this.heightTextField.setText("130.00");
                } else {
                    this.widthTextField.setText(this.df.format((double)this.width / 72.0 * 25.4));
                    this.heightTextField.setText(this.df.format((double)this.height / 72.0 * 25.4));
                }
            } else {
                this.widthTextField.setText(this.df.format((double)this.width / 72.0 * 25.4));
                this.heightTextField.setText(this.df.format((double)this.height / 72.0 * 25.4));
            }
            this.unitLabel.setText(" mm");
        } else if (this.unitComboBox.getSelectedItem().equals("inch")) {
            if (this.resolutionComboBox.getSelectedItem().equals("300 dpi") || this.resolutionComboBox.getSelectedItem().equals("600 dpi")) {
                if (7.086614173228346 < (double)this.width / 72.0 * 25.4) {
                    this.widthTextField.setText(this.df.format(7.086614173228346));
                    this.heightTextField.setText(this.df.format(5.118110236220472));
                } else {
                    this.widthTextField.setText(this.df.format((double)this.width / 72.0 * 25.4));
                    this.heightTextField.setText(this.df.format((double)this.height / 72.0 * 25.4));
                }
            } else {
                this.widthTextField.setText(this.df.format((double)this.width / 72.0));
                this.heightTextField.setText(this.df.format((double)this.height / 72.0));
                this.unitLabel.setText(" inch");
            }
        }
    }

    private void resolutionComboBoxItemStateChanged(ItemEvent evt) {
        if (this.unitComboBox.getSelectedItem().equals("pix") && (this.resolutionComboBox.getSelectedItem().equals("72 dpi") || this.resolutionComboBox.getSelectedItem().equals("vector image"))) {
            this.widthTextField.setText(String.valueOf(this.width));
            this.heightTextField.setText(String.valueOf(this.height));
            this.unitComboBox.setSelectedIndex(2);
            this.unitLabel.setText("pix");
        }
        if (this.resolutionComboBox.getSelectedItem().equals("300 dpi")) {
            this.unitComboBox.setSelectedIndex(0);
            this.unitLabel.setText("cm");
            double wt = 13.5;
            DecimalFormat df = new DecimalFormat("#.00");
            df.format(wt);
            this.heightTextField.setText(String.format("%.2f", wt));
            this.widthTextField.setText("18.00");
        } else if (this.resolutionComboBox.getSelectedItem().equals("600 dpi")) {
            this.unitComboBox.setSelectedIndex(0);
            this.unitLabel.setText("cm");
            double wt = 13.5;
            DecimalFormat df = new DecimalFormat("#.00");
            df.format(wt);
            this.heightTextField.setText(String.format("%.2f", wt));
            this.widthTextField.setText("18.00");
        }
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }
}

