/*
 * Decompiled with CFR 0.152.
 */
package gui.ibs;

import gui.ProgressBarCommand;
import gui.ProgressDialog;
import gui.Tools;
import gui.ibs.CanvasPanel;
import gui.ibs.IBS;
import gui.ibs.OutputJDialog;
import gui.ibs.Project;
import gui.ibs.Project2XML;
import java.awt.Component;
import java.awt.HeadlessException;
import java.awt.geom.Point2D;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;

public class ToolOutPut {
    public static void currentOneoutput(OutputJDialog oj, CanvasPanel canvasPanelold, String strPicFileName, String strFormat, String strUnit, double outwidth, double outheight, boolean bwhratio) {
        if (canvasPanelold != null && canvasPanelold.getProteinList().size() > 0) {
            new OneCurrentPredictionThread(oj, canvasPanelold, strPicFileName, strFormat, strUnit, outwidth, outheight, bwhratio).run();
        }
    }

    public static void batchoutput(String[] args, Component guiCom) {
        HashMap<String, String> argsMap = new HashMap<String, String>();
        for (int i = 0; i < args.length; ++i) {
            String strValpos;
            args[i] = args[i].trim();
            if (!(args[i].indexOf("-") != 0 || args[i].equals("-x") || args[i].equals("-p") || args[i].equals("-f") || args[i].equals("-w") || args[i].equals("-h") || args[i].equals("-r") || args[i].equals("-u"))) {
                System.out.println(" Invalid " + args[i]);
                return;
            }
            if (args[i].toString().toLowerCase().equals("-x")) {
                if (++i >= args.length) {
                    System.out.println("-x have not already set!");
                    return;
                }
                strValpos = args[i].trim();
                if (strValpos.indexOf("-") == 0) {
                    System.out.println("-x have not already set!");
                    return;
                }
                if (!ToolOutPut.isExist(strValpos)) {
                    System.out.println("XML folder does not exist!");
                    return;
                }
                argsMap.put("x", strValpos);
                continue;
            }
            if (args[i].toString().toLowerCase().equals("-p")) {
                if (++i >= args.length) {
                    System.out.println("-p have not already set!");
                    return;
                }
                strValpos = args[i].trim();
                if (strValpos.indexOf("-") == 0) {
                    System.out.println("-p have not already set!");
                    return;
                }
                if (ToolOutPut.isExist(strValpos)) {
                    System.out.println("Output folder already exists!");
                    return;
                }
                argsMap.put("p", strValpos);
                continue;
            }
            if (args[i].toString().toLowerCase().equals("-f")) {
                if (++i >= args.length) {
                    System.out.println("-f have not already set!");
                    return;
                }
                strValpos = args[i].toUpperCase().trim();
                if (strValpos.indexOf("-") == 0) {
                    System.out.println("-f have not already set!");
                    return;
                }
                if (strValpos.equals("A") || strValpos.equals("B") || strValpos.equals("C") || strValpos.equals("D") || strValpos.equals("E")) {
                    argsMap.put("f", strValpos);
                    continue;
                }
                System.out.println("Invalid image format!");
                return;
            }
            if (args[i].toString().toLowerCase().equals("-u")) {
                if (++i >= args.length) {
                    System.out.println("-u have not already set!");
                    return;
                }
                strValpos = args[i].trim();
                if (strValpos.indexOf("-") == 0) {
                    System.out.println("-u have not already set!");
                    return;
                }
                if (strValpos.equals("pix") || strValpos.equals("cm") || strValpos.equals("mm") || strValpos.equals("inch")) {
                    argsMap.put("u", strValpos);
                    continue;
                }
                System.out.println("Unrecognized unit of " + strValpos + " !");
                return;
            }
            if (args[i].toString().toLowerCase().equals("-w")) {
                if (++i >= args.length) {
                    System.out.println("-w have not already set!");
                    return;
                }
                strValpos = args[i].trim();
                if (strValpos.indexOf("-") == 0) {
                    System.out.println("-w have not already set!");
                    return;
                }
                if (!ToolOutPut.isNumeric2(strValpos)) {
                    System.out.println("Invalid image width!");
                    return;
                }
                argsMap.put("w", strValpos);
                continue;
            }
            if (args[i].toString().toLowerCase().equals("-h")) {
                if (++i >= args.length) {
                    System.out.println("-h have not already set!");
                    return;
                }
                strValpos = args[i].trim();
                if (strValpos.indexOf("-") == 0) {
                    System.out.println("-h have not already set!");
                    return;
                }
                if (!ToolOutPut.isNumeric2(strValpos)) {
                    System.out.println("Invalid image height!");
                    return;
                }
                argsMap.put("h", strValpos);
                continue;
            }
            if (!args[i].toString().toLowerCase().equals("-r")) continue;
            if (++i >= args.length) {
                System.out.println("-r have not already set!");
                return;
            }
            strValpos = args[i].trim();
            if (strValpos.indexOf("-") == 0) {
                System.out.println("-r have not already set!");
                return;
            }
            if (strValpos.equals("true") || strValpos.equals("false")) {
                argsMap.put("r", strValpos);
                continue;
            }
            System.out.println("Keep W/H ratio is not a boolean value!");
            return;
        }
        if (!ToolOutPut.isArgSet(args, "-x")) {
            System.out.println("Parameter -x   have not already set!");
            return;
        }
        if (!ToolOutPut.isArgSet(args, "-p")) {
            System.out.println("Parameter -p   have not already set!");
            return;
        }
        if (!ToolOutPut.isArgSet(args, "-f")) {
            System.out.println("Parameter -f   have not already set!");
            return;
        }
        if (!ToolOutPut.isArgSet(args, "-u")) {
            System.out.println("Parameter -u   have not already set!");
            return;
        }
        if (!ToolOutPut.isArgSet(args, "-w")) {
            System.out.println("Parameter -w  have not already set!");
            return;
        }
        if (!ToolOutPut.isArgSet(args, "-h")) {
            System.out.println("Parameter -h  have not already set!");
            return;
        }
        if (!ToolOutPut.isArgSet(args, "-r")) {
            System.out.println("Parameter -r  have not already set!");
            return;
        }
        String strXmlpath = (String)argsMap.get("x");
        String strPicpath = (String)argsMap.get("p");
        if (!ToolOutPut.isExist(strPicpath) && !ToolOutPut.mkNewDir(strPicpath)) {
            System.out.println("Cannot create folder:" + strPicpath + " !");
            return;
        }
        String strFormat = ((String)argsMap.get("f")).toUpperCase();
        String strUnit = (String)argsMap.get("u");
        String strWidth = (String)argsMap.get("w");
        String strHeight = (String)argsMap.get("h");
        double outwidth = Double.parseDouble(strWidth);
        double outheight = Double.parseDouble(strHeight);
        String strWhratio = (String)argsMap.get("r");
        boolean bwhratio = true;
        bwhratio = strWhratio.equals("true");
        List<Object> xmlFileList = new ArrayList();
        try {
            xmlFileList = ToolOutPut.readfile(strXmlpath);
        }
        catch (IOException ex) {
            Logger.getLogger(IBS.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (xmlFileList.size() > 0) {
            new BatchPredictionThread(xmlFileList, strPicpath, strFormat, strUnit, outwidth, outheight, bwhratio, guiCom).start();
        }
    }

    public static boolean isArgSet(String[] args, String argName) {
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].toString().toLowerCase().equals(argName)) continue;
            return true;
        }
        return false;
    }

    public static boolean isArgSet(List<String> argsLis, String argName) {
        for (int i = 0; i < argsLis.size(); ++i) {
            String v = argsLis.get(i).trim();
            if (!v.toString().toLowerCase().equals(argName)) continue;
            return true;
        }
        return false;
    }

    public void batchOutbyDialog(List xmlFileList, String strPicpath, String strFormat, String strUnit, double outwidth, double outheight, boolean bwhratio, Component guiCom) {
        if (xmlFileList.size() > 0) {
            new BatchPredictionThread(xmlFileList, strPicpath, strFormat, strUnit, outwidth, outheight, bwhratio, guiCom).start();
        }
    }

    public static Point2D.Double getSizeToPixel(String strUnit, String typepic, int w, int h) {
        Point2D.Double pd = new Point2D.Double();
        int iwidth = w;
        int iheight = h;
        if (strUnit.equals("pix")) {
            iwidth = w;
            iheight = h;
        } else if (strUnit.equals("cm")) {
            if (typepic.equals("A") || typepic.equals("B")) {
                iwidth = (int)((double)w * 72.0 / 2.54);
                iheight = (int)((double)h * 72.0 / 2.54);
            } else if (typepic.equals("C")) {
                iwidth = (int)((double)(w * 300) / 2.54);
                iheight = (int)((double)(h * 300) / 2.54);
            } else if (typepic.equals("D")) {
                iwidth = (int)((double)(w * 600) / 2.54);
                iheight = (int)((double)(h * 600) / 2.54);
            } else if (typepic.equals("E")) {
                iwidth = (int)((double)w * 72.0 / 2.54);
                iheight = (int)((double)h * 72.0 / 2.54);
            }
        } else if (strUnit.equals("mm")) {
            if (typepic.equals("A") || typepic.equals("B")) {
                iwidth = (int)((double)w * 72.0 / 25.4);
                iheight = (int)((double)h * 72.0 / 25.4);
            } else if (typepic.equals("C")) {
                iwidth = (int)((double)(w * 300) / 25.4);
                iheight = (int)((double)(h * 300) / 25.4);
            } else if (typepic.equals("D")) {
                iwidth = (int)((double)(w * 600) / 25.4);
                iheight = (int)((double)(h * 600) / 25.4);
            } else if (typepic.equals("E")) {
                iwidth = (int)((double)w * 72.0 / 25.4);
                iheight = (int)((double)h * 72.0 / 25.4);
            }
        } else if (strUnit.equals("inch")) {
            if (typepic.equals("A") || typepic.equals("B")) {
                iwidth = (int)((double)w * 72.0);
                iheight = (int)((double)h * 72.0);
            } else if (typepic.equals("C")) {
                iwidth = w * 300;
                iheight = h * 300;
            } else if (typepic.equals("D")) {
                iwidth = w * 600;
                iheight = h * 600;
            } else if (typepic.equals("E")) {
                iwidth = (int)((double)w * 72.0);
                iheight = (int)((double)h * 72.0);
            }
        }
        pd.x = iwidth;
        pd.y = iheight;
        return pd;
    }

    public static boolean isNumeric2(String str) {
        int i = str.length();
        while (--i >= 0) {
            if (Character.isDigit(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isExist(String path) {
        File file = new File(path);
        return file.exists();
    }

    public static boolean mkNewDir(String path) {
        File file = new File(path);
        if (!file.exists()) {
            return file.mkdir();
        }
        return true;
    }

    public static String getExtensionName(String filename) {
        int dot;
        if (filename != null && filename.length() > 0 && (dot = filename.lastIndexOf(46)) > -1 && dot < filename.length() - 1) {
            return filename.substring(dot + 1);
        }
        return filename;
    }

    public static List<File> readfile(String filepath) throws FileNotFoundException, IOException {
        ArrayList<File> xmlFileList = new ArrayList<File>();
        try {
            File file = new File(filepath);
            if (!file.isDirectory()) {
                if (!ToolOutPut.getExtensionName(file.getAbsolutePath()).equals("xml")) {
                    System.out.println(file.getAbsolutePath() + ": not xml file! ");
                } else {
                    xmlFileList.add(file);
                }
            } else if (file.isDirectory()) {
                String[] filelist = file.list();
                for (int i = 0; i < filelist.length; ++i) {
                    File readfile = new File(filepath + "/" + filelist[i]);
                    if (!readfile.isDirectory()) {
                        if (!ToolOutPut.getExtensionName(readfile.getAbsolutePath()).equals("xml")) {
                            System.out.println(readfile.getAbsolutePath() + ": not xml file! ");
                            continue;
                        }
                        xmlFileList.add(readfile);
                        continue;
                    }
                    if (!readfile.isDirectory()) continue;
                    ToolOutPut.readfile(filepath + "/" + filelist[i]);
                }
            }
        }
        catch (FileNotFoundException e) {
            System.out.println("read file    Exception:" + e.getMessage());
        }
        return xmlFileList;
    }

    public static double getOptimumRate(double iwidthCanvas, double iheightCanvas, double widthMaxLenPic, double heightMaxLenPic) {
        double rate = 1.0;
        if (iwidthCanvas == widthMaxLenPic && iheightCanvas == heightMaxLenPic) {
            return 1.0;
        }
        if (iwidthCanvas <= widthMaxLenPic && iheightCanvas <= heightMaxLenPic) {
            rate = widthMaxLenPic >= heightMaxLenPic ? iwidthCanvas / widthMaxLenPic : iheightCanvas / heightMaxLenPic;
        } else if (iwidthCanvas <= widthMaxLenPic && iheightCanvas >= heightMaxLenPic) {
            rate = iwidthCanvas / widthMaxLenPic;
        } else if (iwidthCanvas >= widthMaxLenPic && iheightCanvas <= heightMaxLenPic) {
            rate = iheightCanvas / heightMaxLenPic;
        } else if (iwidthCanvas >= widthMaxLenPic && iheightCanvas >= heightMaxLenPic) {
            rate = widthMaxLenPic >= heightMaxLenPic ? iwidthCanvas / widthMaxLenPic : iheightCanvas / heightMaxLenPic;
        }
        return rate;
    }

    public String[] readConfig(String strConfigFile) {
        String[] arg = null;
        ArrayList<String> argList = new ArrayList<String>();
        try {
            String encoding = "UTF-8";
            File file = new File(strConfigFile);
            boolean k = false;
            if (file.isFile() && file.exists()) {
                InputStreamReader read = new InputStreamReader((InputStream)new FileInputStream(file), encoding);
                BufferedReader bufferedReader = new BufferedReader(read);
                String lineTxt = null;
                while ((lineTxt = bufferedReader.readLine()) != null) {
                    String fvalue;
                    String fname;
                    StringTokenizer st;
                    if ((lineTxt = lineTxt.trim()).indexOf("=") < 0 || (st = new StringTokenizer(lineTxt, "=")).countTokens() < 2 || !(fname = st.nextToken()).trim().toLowerCase().equals("xmlpath") && !fname.trim().toLowerCase().equals("picpath") && !fname.trim().toLowerCase().equals("format") && !fname.trim().toLowerCase().equals("unit") && !fname.trim().toLowerCase().equals("width") && !fname.trim().toLowerCase().equals("height") && !fname.trim().toLowerCase().equals("ratio")) continue;
                    if (fname.trim().toLowerCase().equals("xmlpath")) {
                        fname = "-x";
                    } else if (fname.trim().toLowerCase().equals("picpath")) {
                        fname = "-p";
                    } else if (fname.trim().toLowerCase().equals("format")) {
                        fname = "-f";
                    } else if (fname.trim().toLowerCase().equals("unit")) {
                        fname = "-u";
                    } else if (fname.trim().toLowerCase().equals("width")) {
                        fname = "-w";
                    } else if (fname.trim().toLowerCase().equals("height")) {
                        fname = "-h";
                    } else if (fname.trim().toLowerCase().equals("ratio")) {
                        fname = "-r";
                    }
                    if ((fvalue = st.nextToken()).equals("")) continue;
                    argList.add(fname);
                    argList.add(fvalue);
                }
                read.close();
                if (!ToolOutPut.isArgSet(argList, "-x")) {
                    System.out.println("Parameter xmlpath   have not already set!");
                    return null;
                }
                if (!ToolOutPut.isArgSet(argList, "-p")) {
                    System.out.println("Parameter picpath   have not already set!");
                    return null;
                }
                if (!ToolOutPut.isArgSet(argList, "-f")) {
                    System.out.println("Parameter format   have not already set!");
                    return null;
                }
                if (!ToolOutPut.isArgSet(argList, "-u")) {
                    System.out.println("Parameter unit   have not already set!");
                    return null;
                }
                if (!ToolOutPut.isArgSet(argList, "-w")) {
                    System.out.println("Parameter width  have not already set!");
                    return null;
                }
                if (!ToolOutPut.isArgSet(argList, "-h")) {
                    System.out.println("Parameter height have not already set!");
                    return null;
                }
                if (!ToolOutPut.isArgSet(argList, "-r")) {
                    System.out.println("Parameter ratio  have not already set!");
                    return null;
                }
                String[] s = new String[argList.size()];
                for (int u = 0; u < argList.size(); ++u) {
                    s[u] = ((String)argList.get(u)).trim();
                }
                return s;
            }
            System.out.println("file not found!");
        }
        catch (Exception e) {
            System.out.println("An error occurred while reading the file!");
            e.printStackTrace();
        }
        return arg;
    }

    public static class OneCurrentPredictionThread
    extends Thread
    implements Runnable {
        private String strXmlpath;
        private List<File> xmlFileList;
        private String strPicpath;
        private String strPicFileName;
        private String strFormat;
        private String strUnit;
        private double outwidth;
        private double outheight;
        private boolean bwhratio;
        private CanvasPanel canvasPanel;
        private CanvasPanel canvasPanelold;
        private double whratio;
        private OutputJDialog oj;

        public OneCurrentPredictionThread(OutputJDialog oj, CanvasPanel canvasPanelold, String strPicFileName, String strFormat, String strUnit, double outwidth, double outheight, boolean bwhratio) {
            this.strXmlpath = this.strXmlpath;
            this.xmlFileList = this.xmlFileList;
            this.strPicFileName = strPicFileName;
            this.strFormat = strFormat;
            this.strUnit = strUnit;
            this.outwidth = outwidth;
            this.outheight = outheight;
            this.bwhratio = bwhratio;
            this.whratio = 1.3333333333333333;
            this.canvasPanel = new CanvasPanel();
            this.canvasPanelold = canvasPanelold;
            this.oj = oj;
        }

        @Override
        public void run() {
            try {
                int iwidth = 800;
                int iheight = 600;
                double w = this.outwidth;
                double h = this.outheight;
                String exportFilePath = this.strPicFileName;
                String selectedItem = this.strFormat;
                String typepic = "JPG";
                if (selectedItem.equals("A")) {
                    typepic = "JPG";
                } else if (selectedItem.equals("B")) {
                    typepic = "PNG";
                } else if (selectedItem.equals("C")) {
                    typepic = "TIFF300dpi";
                } else if (selectedItem.equals("D")) {
                    typepic = "TIFF600dpi";
                } else if (selectedItem.equals("E")) {
                    typepic = "SVG";
                }
                if (typepic.equals("SVG")) {
                    this.outwidth = this.canvasPanelold.getWidth();
                    this.outheight = this.canvasPanelold.getHeight();
                    this.canvasPanelold.outputImage((int)this.outwidth, (int)this.outheight, exportFilePath, typepic);
                    System.out.println("Generate images successfully!");
                    JOptionPane.showMessageDialog(this.oj, "Image export to  " + exportFilePath + "  successfully !");
                    return;
                }
                this.canvasPanelold.adjustToCenter();
                this.canvasPanelold.findPicMaxWH();
                int widthMaxLenPic = this.canvasPanelold.widthMaxLenPic + this.canvasPanelold.borderLenPic * 2;
                int heightMaxLenPic = this.canvasPanelold.heightMaxLenPic + this.canvasPanelold.borderLenPic * 2;
                this.canvasPanel.setProteinList(this.canvasPanelold.getProteinList());
                double iwidthCanvas = iwidth;
                double iheightCanvas = iheight;
                Point2D.Double pd = ToolOutPut.getSizeToPixel(this.strUnit, selectedItem, (int)w, (int)h);
                iwidthCanvas = pd.x;
                iheightCanvas = pd.y;
                this.canvasPanel.batchOutrate = (float)ToolOutPut.getOptimumRate(iwidthCanvas, iheightCanvas, widthMaxLenPic, heightMaxLenPic);
                this.canvasPanel.outputImage((int)iwidthCanvas, (int)iheightCanvas, exportFilePath, typepic);
                System.out.println("Generate images successfully!");
                JOptionPane.showMessageDialog(this.oj, "Image export to  " + exportFilePath + "  successfully !");
            }
            catch (Exception e) {
                if (e.toString().equals("java.lang.NegativeArraySizeException")) {
                    System.out.println("Out Of Memory!");
                    JOptionPane.showMessageDialog(null, "Out Of Memory!");
                    return;
                }
                JOptionPane.showMessageDialog(this.oj, e.toString());
                System.out.println(e.toString());
                return;
            }
            catch (OutOfMemoryError e) {
                System.out.println("Out Of Memory!");
                JOptionPane.showMessageDialog(this.oj, e.toString());
                return;
            }
        }
    }

    public static class BatchPredictionThread
    extends Thread {
        private List<File> xmlFileList;
        private String strPicpath;
        private String strFormat;
        private String strUnit;
        private double outwidth;
        private double outheight;
        private boolean bwhratio;
        private CanvasPanel canvasPanel;
        private double whratio;
        private boolean bGuiMode = false;
        private Component guiCom;
        private ProgressDialog progressDialog;
        private ProgressBarCommand pbc;

        public ProgressBarCommand getPbc() {
            return this.pbc;
        }

        public void setPbc(ProgressBarCommand pbc) {
            this.pbc = pbc;
        }

        public ProgressDialog getProgressDialog() {
            return this.progressDialog;
        }

        public void setProgressDialog(ProgressDialog progressDialog) {
            this.progressDialog = progressDialog;
        }

        public List<File> getXmlFileList() {
            return this.xmlFileList;
        }

        public void setXmlFileList(List<File> xmlFileList) {
            this.xmlFileList = xmlFileList;
        }

        public String getStrPicpath() {
            return this.strPicpath;
        }

        public void setStrPicpath(String strPicpath) {
            this.strPicpath = strPicpath;
        }

        public String getStrFormat() {
            return this.strFormat;
        }

        public void setStrFormat(String strFormat) {
            this.strFormat = strFormat;
        }

        public String getStrUnit() {
            return this.strUnit;
        }

        public void setStrUnit(String strUnit) {
            this.strUnit = strUnit;
        }

        public double getOutwidth() {
            return this.outwidth;
        }

        public void setOutwidth(double outwidth) {
            this.outwidth = outwidth;
        }

        public double getOutheight() {
            return this.outheight;
        }

        public void setOutheight(double outheight) {
            this.outheight = outheight;
        }

        public boolean isBwhratio() {
            return this.bwhratio;
        }

        public void setBwhratio(boolean bwhratio) {
            this.bwhratio = bwhratio;
        }

        public CanvasPanel getCanvasPanel() {
            return this.canvasPanel;
        }

        public void setCanvasPanel(CanvasPanel canvasPanel) {
            this.canvasPanel = canvasPanel;
        }

        public double getWhratio() {
            return this.whratio;
        }

        public void setWhratio(double whratio) {
            this.whratio = whratio;
        }

        public boolean isbGuiMode() {
            return this.bGuiMode;
        }

        public void setbGuiMode(boolean bGuiMode) {
            this.bGuiMode = bGuiMode;
        }

        public Component getGuiCom() {
            return this.guiCom;
        }

        public void setGuiCom(Component guiCom) {
            this.guiCom = guiCom;
        }

        public BatchPredictionThread(List<File> xmlFileList, String strPicpath, String strFormat, String strUnit, double outwidth, double outheight, boolean bwhratio, Component guiCom) {
            this.xmlFileList = xmlFileList;
            this.strPicpath = strPicpath;
            this.strFormat = strFormat;
            this.strUnit = strUnit;
            this.outwidth = outwidth;
            this.outheight = outheight;
            this.bwhratio = bwhratio;
            this.whratio = 1.3333333333333333;
            this.guiCom = guiCom;
            if (guiCom != null) {
                this.bGuiMode = true;
            }
        }

        @Override
        public void run() {
            try {
                this.canvasPanel = new CanvasPanel();
                File FilePath = new File(this.strPicpath);
                if (!FilePath.exists() && !FilePath.isDirectory()) {
                    FilePath.mkdir();
                }
                double progressPercent = 0.0;
                LinkedList<String> errorFileList = new LinkedList<String>();
                double progressLargeStep = 100.0 / (double)this.xmlFileList.size();
                if (this.bGuiMode) {
                    this.progressDialog = new ProgressDialog();
                    Tools.WindowCenter(this.progressDialog);
                } else {
                    this.pbc = new ProgressBarCommand();
                }
                double accStep = 0.0;
                for (File file : this.xmlFileList) {
                    try {
                        String strMode;
                        Project2XML pj = new Project2XML(file.getAbsolutePath());
                        this.canvasPanel.Mode = strMode = pj.getXMLMode(file.getAbsolutePath());
                        Project project = new Project2XML(file.getAbsolutePath()).open(strMode);
                        int iwidth = 800;
                        int iheight = 600;
                        double w = this.outwidth;
                        double h = this.outheight;
                        if (this.bwhratio) {
                            w = h * this.whratio;
                        }
                        this.canvasPanel.setProteinList(project.getProteinList());
                        this.canvasPanel.findPicMaxWH();
                        int widthMaxLenPic = this.canvasPanel.widthMaxLenPic + this.canvasPanel.borderLenPic * 3;
                        int heightMaxLenPic = this.canvasPanel.heightMaxLenPic + this.canvasPanel.borderLenPic * 3;
                        double iwidthCanvas = iwidth;
                        double iheightCanvas = iheight;
                        String exportFilePath = "";
                        String selectedItem = this.strFormat;
                        String typepic = "JPG";
                        progressPercent += progressLargeStep;
                        if (this.bGuiMode) {
                            this.progressDialog.setProcessValue(progressPercent);
                        } else {
                            this.pbc.showBarByPoint(progressPercent);
                        }
                        if (selectedItem.equals("A")) {
                            exportFilePath = this.strPicpath + File.separatorChar + Tools.FileExtentionChange(file.getName(), "jpg");
                            typepic = "JPG";
                        } else if (selectedItem.equals("B")) {
                            exportFilePath = this.strPicpath + File.separatorChar + Tools.FileExtentionChange(file.getName(), "png");
                            typepic = "PNG";
                        } else if (selectedItem.equals("C")) {
                            exportFilePath = this.strPicpath + File.separatorChar + Tools.FileExtentionChange(file.getName(), "tiff");
                            typepic = "TIFF300dpi";
                        } else if (selectedItem.equals("D")) {
                            exportFilePath = this.strPicpath + File.separatorChar + Tools.FileExtentionChange(file.getName(), "tiff");
                            typepic = "TIFF600dpi";
                        } else if (selectedItem.equals("E")) {
                            exportFilePath = this.strPicpath + File.separatorChar + Tools.FileExtentionChange(file.getName(), "svg");
                            typepic = "SVG";
                        }
                        Point2D.Double pd = ToolOutPut.getSizeToPixel(this.strUnit, selectedItem, (int)w, (int)h);
                        iwidthCanvas = pd.x;
                        iheightCanvas = pd.y;
                        this.canvasPanel.batchOutrate = (float)ToolOutPut.getOptimumRate(iwidthCanvas, iheightCanvas, widthMaxLenPic, heightMaxLenPic);
                        this.canvasPanel.outputImage((int)iwidthCanvas, (int)iheightCanvas, exportFilePath, typepic);
                    }
                    catch (Exception e) {
                        if (e.toString().equals("java.lang.NegativeArraySizeException")) {
                            System.out.println("Out Of Memory!");
                            if (this.bGuiMode) {
                                this.progressDialog.setProcessValue(100.0);
                                this.progressDialog.dispose();
                                JOptionPane.showMessageDialog(this.guiCom, "Out Of Memory!");
                            } else {
                                System.out.print("\n");
                            }
                            return;
                        }
                        if (this.bGuiMode) {
                            errorFileList.add(file.getName() + " " + e.toString());
                            continue;
                        }
                        System.out.println(file.getName() + " " + e.toString());
                    }
                    catch (OutOfMemoryError e) {
                        System.out.println("Out Of Memory!");
                        if (this.bGuiMode) {
                            this.progressDialog.setProcessValue(100.0);
                            this.progressDialog.dispose();
                            JOptionPane.showMessageDialog(this.guiCom, e.toString());
                        } else {
                            System.out.print("\n");
                        }
                        return;
                    }
                }
                if (this.bGuiMode) {
                    this.progressDialog.setProcessValue(100.0);
                } else {
                    System.out.print("\n");
                }
                this.canvasPanel.getProteinList().clear();
                this.canvasPanel.Mode = "P";
                if (errorFileList.size() == 0) {
                    if (this.bGuiMode) {
                        this.progressDialog.dispose();
                        JOptionPane.showMessageDialog(this.guiCom, "Batch Export Completed. ");
                    }
                } else {
                    if (this.bGuiMode) {
                        this.progressDialog.dispose();
                        StringBuffer sb = new StringBuffer("");
                        for (String errorFile : errorFileList) {
                            sb.append(errorFile + "\n");
                        }
                        errorFileList.clear();
                        JOptionPane.showMessageDialog(this.guiCom, sb.toString(), "Error", 0);
                    }
                    return;
                }
                errorFileList.clear();
                System.out.println("Generate images successfully!");
            }
            catch (HeadlessException headlessException) {
                // empty catch block
            }
        }
    }
}

