/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.misc;

import com.install4j.api.Util;
import com.install4j.api.beans.PropertyLoggingInterceptor;
import com.install4j.api.context.Context;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.beans.actions.SystemInstallOrUninstallAction;
import com.install4j.runtime.installer.helper.LaunchDescriptor;
import com.install4j.runtime.installer.helper.LaunchHelper;
import com.install4j.runtime.installer.helper.Logger;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;

public class RunExecutableAction
extends SystemInstallOrUninstallAction
implements PropertyLoggingInterceptor {
    public static final String PROPERTY_ARGUMENTS = "arguments";
    private File executable;
    private File workingDirectory;
    private String[] arguments;
    private boolean wait = false;
    private boolean logArguments = false;
    private File stdoutFile;
    private File stderrFile;
    private File stdinFile;
    private boolean failOnRedirectionError;
    private boolean includeParentEnvironmentVariables = true;
    private Map environmentVariables = RunExecutableAction.createLinkedHashMap();
    private boolean showWindowsConsole = false;
    private boolean keepConsoleWindow = false;

    public File getExecutable() {
        return RunExecutableAction.replaceVariables(this.executable);
    }

    public void setExecutable(File file) {
        this.executable = file;
    }

    public File getWorkingDirectory() {
        return RunExecutableAction.replaceVariables(this.workingDirectory);
    }

    public void setWorkingDirectory(File file) {
        this.workingDirectory = file;
    }

    public String[] getArguments() {
        return RunExecutableAction.replaceVariables(this.arguments);
    }

    public void setArguments(String[] stringArray) {
        this.arguments = stringArray;
    }

    public boolean isWait() {
        return this.wait;
    }

    public void setWait(boolean bl) {
        this.wait = bl;
    }

    public boolean isLogArguments() {
        return this.logArguments;
    }

    public void setLogArguments(boolean bl) {
        this.logArguments = bl;
    }

    public File getStdoutFile() {
        return this.stdoutFile;
    }

    public void setStdoutFile(File file) {
        this.stdoutFile = file;
    }

    public File getStderrFile() {
        return this.stderrFile;
    }

    public void setStderrFile(File file) {
        this.stderrFile = file;
    }

    public File getStdinFile() {
        return this.stdinFile;
    }

    public void setStdinFile(File file) {
        this.stdinFile = file;
    }

    public boolean isFailOnRedirectionError() {
        return this.failOnRedirectionError;
    }

    public void setFailOnRedirectionError(boolean bl) {
        this.failOnRedirectionError = bl;
    }

    public boolean isIncludeParentEnvironmentVariables() {
        return this.includeParentEnvironmentVariables;
    }

    public void setIncludeParentEnvironmentVariables(boolean bl) {
        this.includeParentEnvironmentVariables = bl;
    }

    public Map getEnvironmentVariables() {
        return this.environmentVariables;
    }

    public void setEnvironmentVariables(Map map) {
        this.environmentVariables = map;
    }

    public boolean isShowWindowsConsole() {
        return this.showWindowsConsole;
    }

    public void setShowWindowsConsole(boolean bl) {
        this.showWindowsConsole = bl;
    }

    public boolean isKeepConsoleWindow() {
        return this.keepConsoleWindow;
    }

    public void setKeepConsoleWindow(boolean bl) {
        this.keepConsoleWindow = bl;
    }

    public Object getLogValueForProperty(String string, Object object) {
        if (string.equals(PROPERTY_ARGUMENTS) && !this.logArguments) {
            return "[logging of arguments is disabled]";
        }
        return object;
    }

    public boolean execute(Context context) throws UserCanceledException {
        File file;
        for (file = context.getDestinationFile(this.getWorkingDirectory()); file != null && !file.exists(); file = file.getParentFile()) {
        }
        Logger.getInstance().info(this, "used working dir: " + file);
        File file2 = this.getUsedExecutable(file, context);
        OutputStream outputStream = this.createOutputStream(RunExecutableAction.replaceVariables(this.stdoutFile));
        OutputStream outputStream2 = this.createOutputStream(RunExecutableAction.replaceVariables(this.stderrFile));
        InputStream inputStream = this.createInputStream(RunExecutableAction.replaceVariables(this.stdinFile));
        if (this.failOnRedirectionError && (outputStream == null && this.stdoutFile != null || outputStream2 == null && this.stderrFile != null || inputStream == null && this.stdinFile != null)) {
            this.closeStreams(inputStream, outputStream, outputStream2);
            return false;
        }
        LaunchDescriptor launchDescriptor = new LaunchDescriptor(file2).workingDirectory(file).arguments(this.getArguments()).consumeOutput(false).specificEnvironmentVariables(this.environmentVariables).includeParentEnvironmentVariables(this.includeParentEnvironmentVariables).showWindowsConsole(this.showWindowsConsole).keepConsoleWindow(this.keepConsoleWindow).useNohup(!this.wait && !Util.isWindows() && !Util.isMacOS() && outputStream == null && outputStream2 == null && inputStream == null);
        Process process = LaunchHelper.launchApplication(launchDescriptor);
        if (process == null) {
            Logger.getInstance().error(this, "process could not be created");
            this.closeStreams(inputStream, outputStream, outputStream2);
            return false;
        }
        new ConsumerThread(process.getInputStream(), outputStream).start();
        new ConsumerThread(process.getErrorStream(), outputStream2).start();
        if (inputStream != null) {
            new WriterThread(process.getOutputStream(), inputStream).start();
        }
        if (!this.wait) {
            return true;
        }
        try {
            int n = process.waitFor();
            if (n != 0) {
                Logger.getInstance().error(this, "return value is " + n);
            }
            return n == 0;
        }
        catch (InterruptedException interruptedException) {
            Logger.getInstance().info(this, interruptedException.toString());
            interruptedException.printStackTrace();
            return false;
        }
    }

    public boolean isRollbackSupported() {
        return false;
    }

    private File getUsedExecutable(File file, Context context) {
        File file2;
        File file3 = context.getDestinationFile(this.getExecutable());
        if (!file3.exists() && !this.getExecutable().isAbsolute() && (file2 = new File(file, this.getExecutable().getPath())).exists()) {
            file3 = file2;
        }
        if (!file3.exists()) {
            Logger.getInstance().info(this, "executable does not exist: " + file3.getAbsolutePath());
        }
        return file3;
    }

    private void closeStreams(InputStream inputStream, OutputStream outputStream, OutputStream outputStream2) {
        try {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (outputStream != null) {
                outputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (outputStream2 != null) {
                outputStream2.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private OutputStream createOutputStream(File file) {
        if (file != null) {
            try {
                return new BufferedOutputStream(new FileOutputStream(file));
            }
            catch (IOException iOException) {
                Logger.getInstance().error(this, "output file " + file.getPath() + " could not be created");
            }
        }
        return null;
    }

    private InputStream createInputStream(File file) {
        if (file != null) {
            try {
                return new FileInputStream(file);
            }
            catch (IOException iOException) {
                Logger.getInstance().error(this, "input file " + file.getPath() + " could not be opened");
            }
        }
        return null;
    }

    private class ConsumerThread
    extends Thread {
        private boolean canceled;
        private InputStream stream;
        private OutputStream outputStream;

        public ConsumerThread(InputStream inputStream, OutputStream outputStream) {
            this.stream = inputStream;
            this.outputStream = outputStream;
        }

        public void run() {
            byte[] byArray = new byte[512];
            while (!this.canceled) {
                try {
                    int n = this.stream.read(byArray);
                    if (n == -1) {
                        this.cancel();
                        continue;
                    }
                    if (this.outputStream == null) continue;
                    this.outputStream.write(byArray, 0, n);
                }
                catch (IOException iOException) {
                    this.cancel();
                }
            }
        }

        public synchronized void cancel() {
            this.canceled = true;
            try {
                if (this.outputStream != null) {
                    this.outputStream.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private class WriterThread
    extends Thread {
        private boolean canceled;
        private OutputStream processOutput;
        private InputStream inputStream;

        public WriterThread(OutputStream outputStream, InputStream inputStream) {
            this.processOutput = outputStream;
            this.inputStream = inputStream;
        }

        public void run() {
            byte[] byArray = new byte[512];
            while (!this.canceled) {
                try {
                    int n = this.inputStream.read(byArray);
                    if (n == -1) {
                        this.cancel();
                        continue;
                    }
                    this.processOutput.write(byArray, 0, n);
                }
                catch (IOException iOException) {
                    this.cancel();
                }
            }
        }

        public synchronized void cancel() {
            this.canceled = true;
            try {
                this.inputStream.close();
                this.processOutput.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

