/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.update;

import com.install4j.api.Util;
import com.install4j.api.context.Context;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.ProgressInterface;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.beans.actions.files.BackupFileForRollbackAction;
import com.install4j.runtime.beans.actions.update.DownloadAction;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.frontend.NoPercentageProgressDelegate;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.content.Downloader;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;

public class DownloadFileAction
extends DownloadAction {
    private String url;
    private String targetFile;
    private boolean showProgress = true;
    private boolean showFileName = true;
    private boolean deleteOnExit = false;

    public String getUrl() {
        return DownloadFileAction.replaceVariables(this.url);
    }

    public void setUrl(String string) {
        this.url = string;
    }

    public String getTargetFile() {
        return DownloadFileAction.replaceVariables(this.targetFile);
    }

    public void setTargetFile(String string) {
        this.targetFile = string;
    }

    public boolean isShowProgress() {
        return this.showProgress;
    }

    public void setShowProgress(boolean bl) {
        this.showProgress = bl;
    }

    public boolean isShowFileName() {
        return this.showFileName;
    }

    public void setShowFileName(boolean bl) {
        this.showFileName = bl;
    }

    public boolean isDeleteOnExit() {
        return this.deleteOnExit;
    }

    public void setDeleteOnExit(boolean bl) {
        this.deleteOnExit = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean execute(Context context) throws UserCanceledException {
        Object object;
        ProgressInterface progressInterface = context.getProgressInterface();
        File file = context.getDestinationFile(this.getTargetFile());
        if (this.showProgress) {
            if (this.showFileName) {
                object = file.getName();
                progressInterface.setStatusMessage("<html><nobr>" + MessageFormat.format(Messages.getMessages().getString("DownloadingWithFileName"), "<b>" + (String)object + "</b>") + "</nobr>");
            } else {
                progressInterface.setStatusMessage(Messages.getMessages().getString("Downloading"));
            }
        } else {
            progressInterface = new NoPercentageProgressDelegate(progressInterface);
        }
        object = new Downloader(context, progressInterface, this.isAskForProxy());
        BackupFileForRollbackAction backupFileForRollbackAction = null;
        if (context instanceof InstallerContext && file.exists()) {
            backupFileForRollbackAction = new BackupFileForRollbackAction(file, true);
            backupFileForRollbackAction.install((InstallerContext)context);
            this.addRollbackAction(backupFileForRollbackAction);
        }
        try {
            Logger.getInstance().info(this, "downloading " + this.getUrl() + " to " + file);
            ((Downloader)object).download(file, this.getUrl(), -1L, this.deleteOnExit);
            if (backupFileForRollbackAction == null) return true;
        }
        catch (IOException iOException) {
            boolean bl;
            try {
                if (this.isShowError()) {
                    Util.showErrorMessage(MessageFormat.format(Messages.getMessages().getString("updater.DownloadError"), this.getUrl()));
                }
                Logger.getInstance().error(this, "could not download file");
                Logger.getInstance().log(iOException);
                if (backupFileForRollbackAction != null) {
                    backupFileForRollbackAction.rollback((InstallerContext)context);
                    return false;
                }
                bl = false;
                if (backupFileForRollbackAction == null) return bl;
            }
            catch (Throwable throwable) {
                if (backupFileForRollbackAction == null) throw throwable;
                this.addRollbackAction(backupFileForRollbackAction);
                throw throwable;
            }
            this.addRollbackAction(backupFileForRollbackAction);
            return bl;
        }
        this.addRollbackAction(backupFileForRollbackAction);
        return true;
    }
}

