/*
 * Decompiled with CFR 0.152.
 */
package gui;

public class ProgressBarCommand {
    private double finishPoint;
    private double barLength;

    public ProgressBarCommand() {
        this.finishPoint = 100.0;
        this.barLength = 30.0;
    }

    public ProgressBarCommand(double finishPoint, int barLength) {
        this.finishPoint = finishPoint;
        this.barLength = barLength;
    }

    public void showBarByPoint(double currentPoint) {
        double rate = currentPoint / this.finishPoint;
        int barSign = (int)(rate * this.barLength);
        System.out.print("\r");
        System.out.print(this.makeBarBySignAndLength(barSign) + String.format(" %.2f%%", rate * 100.0));
    }

    private String makeBarBySignAndLength(int barSign) {
        StringBuilder bar = new StringBuilder();
        bar.append("[");
        int i = 1;
        while ((double)i <= this.barLength) {
            if (i < barSign) {
                bar.append("*");
            } else if (i == barSign) {
                bar.append("*");
            } else {
                bar.append(" ");
            }
            ++i;
        }
        bar.append("]");
        return bar.toString();
    }
}

