/*
 * Decompiled with CFR 0.152.
 */
package gui;

import com.sun.java.swing.plaf.windows.WindowsComboBoxUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Date;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.plaf.ComboBoxUI;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;

public class Tools {
    public static final Image GPS_ICON = Toolkit.getDefaultToolkit().getImage(Tools.class.getResource("/gui/ibs/image/GPS.png"));
    public static final String AA = "ARNDCQEGHILKMFPSTWYVBZX*";
    public static HashMap<Character, Integer> aaMap = Tools.getAAMap();
    public static String CURRENT_FILE_PATH = Tools.getCurrentFilePath();

    public static HashMap<Character, Integer> getAAMap() {
        HashMap<Character, Integer> map = new HashMap<Character, Integer>();
        map.put(Character.valueOf('A'), 0);
        map.put(Character.valueOf('R'), 1);
        map.put(Character.valueOf('N'), 2);
        map.put(Character.valueOf('D'), 3);
        map.put(Character.valueOf('C'), 4);
        map.put(Character.valueOf('Q'), 5);
        map.put(Character.valueOf('E'), 6);
        map.put(Character.valueOf('G'), 7);
        map.put(Character.valueOf('H'), 8);
        map.put(Character.valueOf('I'), 9);
        map.put(Character.valueOf('L'), 10);
        map.put(Character.valueOf('K'), 11);
        map.put(Character.valueOf('M'), 12);
        map.put(Character.valueOf('F'), 13);
        map.put(Character.valueOf('P'), 14);
        map.put(Character.valueOf('S'), 15);
        map.put(Character.valueOf('T'), 16);
        map.put(Character.valueOf('W'), 17);
        map.put(Character.valueOf('Y'), 18);
        map.put(Character.valueOf('V'), 19);
        map.put(Character.valueOf('B'), 20);
        map.put(Character.valueOf('Z'), 21);
        map.put(Character.valueOf('X'), 22);
        map.put(Character.valueOf('U'), 22);
        map.put(Character.valueOf('*'), 23);
        return map;
    }

    public static void setComboBoxUI(final JComboBox combobox, String[] dispInfo) {
        combobox.setUI((ComboBoxUI)new WindowsComboBoxUI(){

            protected ComboPopup createPopup() {
                return new BasicComboPopup(combobox){

                    protected JList createList() {
                        return new JList(this.comboBox.getModel()){

                            @Override
                            public void processMouseEvent(MouseEvent e) {
                                if (e.isControlDown()) {
                                    e = new MouseEvent((Component)e.getSource(), e.getID(), e.getWhen(), e.getModifiers() ^ 2, e.getX(), e.getY(), e.getClickCount(), e.isPopupTrigger());
                                }
                                super.processMouseEvent(e);
                            }

                            @Override
                            public String getToolTipText(MouseEvent event) {
                                int index = this.locationToIndex(event.getPoint());
                                if (index != -1) {
                                    Object value = this.getModel().getElementAt(index);
                                    ListCellRenderer renderer = this.getCellRenderer();
                                    Component rendererComp = renderer.getListCellRendererComponent(this, value, index, true, false);
                                    if (rendererComp.getPreferredSize().width > this.getVisibleRect().width) {
                                        return value == null ? null : value.toString();
                                    }
                                    return null;
                                }
                                return null;
                            }

                            @Override
                            public Point getToolTipLocation(MouseEvent event) {
                                int index = this.locationToIndex(event.getPoint());
                                if (index != -1) {
                                    Rectangle cellBounds = this.getCellBounds(index, index);
                                    return new Point(cellBounds.x, cellBounds.y);
                                }
                                return null;
                            }
                        };
                    }
                };
            }
        });
    }

    static String getCurrentFilePath() {
        String filePath = "";
        try {
            BufferedReader in = new BufferedReader(new FileReader("CurrentFilePath.txt"));
            filePath = in.readLine();
            in.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return filePath;
    }

    public static void setCurrentFilePath() {
        try {
            if (!CURRENT_FILE_PATH.equals("")) {
                FileWriter fw = new FileWriter("CurrentFilePath.txt");
                fw.append(CURRENT_FILE_PATH);
                fw.flush();
                fw.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void WindowCenter(JFrame frame) {
        frame.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = frame.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        frame.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2 - 10);
        frame.setVisible(true);
    }

    public static void WindowCenter(JDialog dialog) {
        dialog.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = dialog.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        dialog.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
        dialog.setVisible(true);
    }

    public static void WindowLeft(JFrame frame) {
        frame.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = frame.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        frame.setLocation((screenSize.width - frameSize.width) / 4, (screenSize.height - frameSize.height) / 2);
        frame.setVisible(true);
    }

    public static void WindowRight(JFrame frame) {
        frame.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = frame.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        frame.setLocation((screenSize.width - frameSize.width) * 3 / 4, (screenSize.height - frameSize.height) / 2);
        frame.setVisible(true);
    }

    public static String FileNameFormat(String fileName, String suffix) {
        String name = fileName.substring(0, fileName.lastIndexOf("."));
        return name + "." + suffix + ".txt";
    }

    public static String FileExtentionChange(String fileName, String extention) {
        String name = fileName.substring(0, fileName.lastIndexOf("."));
        return name + "." + extention;
    }

    public static boolean copyFile(String filefrom, String fileto) {
        try {
            int c;
            FileInputStream fosfrom = new FileInputStream(filefrom);
            FileOutputStream fosto = new FileOutputStream(fileto);
            byte[] bt = new byte[1024];
            while ((c = fosfrom.read(bt)) > 0) {
                fosto.write(bt, 0, c);
            }
            fosfrom.close();
            fosto.close();
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public static int[][] getMatrix(String filePath) {
        int[][] matrix = new int[24][24];
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(Tools.class.getResourceAsStream(filePath)));
            in.readLine();
            for (int i = 0; i < 24; ++i) {
                String row = in.readLine();
                StringTokenizer rowSt = new StringTokenizer(row, " ");
                for (int j = 0; j < 24; ++j) {
                    matrix[i][j] = Integer.parseInt(rowSt.nextToken());
                }
            }
            in.close();
        }
        catch (Exception ex) {
            System.out.println("gui.Tools.getMatrix Matrix miss");
            return null;
        }
        return matrix;
    }

    public static int[][] getMatrix(File file) {
        int[][] matrix = new int[24][24];
        try {
            BufferedReader in = new BufferedReader(new FileReader(file));
            in.readLine();
            for (int i = 0; i < 24; ++i) {
                String row = in.readLine();
                StringTokenizer rowSt = new StringTokenizer(row, " ");
                for (int j = 0; j < 24; ++j) {
                    matrix[i][j] = Integer.parseInt(rowSt.nextToken());
                }
            }
            in.close();
        }
        catch (Exception ex) {
            System.out.println("gui.Tools.getMatrix Matrix miss");
            return null;
        }
        return matrix;
    }

    public static int[][] MatrixReader(String filePath) {
        int[][] matrix = new int[24][24];
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(Tools.class.getResourceAsStream(filePath)));
            while (in.ready()) {
                String lineStr = in.readLine();
                if (lineStr.equals("") || lineStr.startsWith("#") || lineStr.startsWith(" ") || lineStr.startsWith("@")) continue;
                StringTokenizer st = new StringTokenizer(lineStr, " ");
                char code = st.nextToken().charAt(0);
                int row = AA.indexOf(code);
                for (int column = 0; column < 24; ++column) {
                    matrix[row][column] = Integer.parseInt(st.nextToken());
                }
            }
            in.close();
        }
        catch (Exception ex) {
            System.out.println("gui.Tools.MatrixReader Matrix miss");
            return null;
        }
        return matrix;
    }

    public static int[][] MatrixReader(File file) {
        int[][] matrix = new int[24][24];
        try {
            BufferedReader in = new BufferedReader(new FileReader(file));
            while (in.ready()) {
                String lineStr = in.readLine();
                if (lineStr.equals("") || lineStr.startsWith("#") || lineStr.startsWith(" ") || lineStr.startsWith("@")) continue;
                StringTokenizer st = new StringTokenizer(lineStr, " ");
                char code = st.nextToken().charAt(0);
                int row = AA.indexOf(code);
                for (int column = 0; column < 24; ++column) {
                    matrix[row][column] = Integer.parseInt(st.nextToken());
                }
            }
            in.close();
        }
        catch (Exception ex) {
            System.out.println("gui.Tools.MatrixReader Matrix miss");
            return null;
        }
        return matrix;
    }

    public static String ColorToHex(Color color) {
        StringBuffer sb = new StringBuffer();
        String R = Integer.toHexString(color.getRed());
        String G = Integer.toHexString(color.getGreen());
        String B = Integer.toHexString(color.getBlue());
        R = R.length() == 1 ? "0" + R : R;
        G = G.length() == 1 ? "0" + G : G;
        B = B.length() == 1 ? "0" + B : B;
        sb.append(R);
        sb.append(G);
        sb.append(B);
        return "#" + sb.toString().toUpperCase();
    }

    public static Color HexToColor(String hex) {
        return new Color(Integer.parseInt(hex, 16));
    }

    public static String nowTime() {
        Date now = new Date();
        String nowString = now.toString();
        StringTokenizer st = new StringTokenizer(nowString, " ");
        String monTag = st.nextToken();
        String mon = st.nextToken();
        String day = st.nextToken();
        String timeString = st.nextToken();
        String timezone = st.nextToken();
        String year = st.nextToken();
        String month = "";
        if (mon.equals("Jan")) {
            month = "01";
        } else if (mon.equals("Feb")) {
            month = "02";
        } else if (mon.equals("Mar")) {
            month = "03";
        } else if (mon.equals("Apr")) {
            month = "04";
        } else if (mon.equals("May")) {
            month = "05";
        } else if (mon.equals("Jun")) {
            month = "06";
        } else if (mon.equals("Jul")) {
            month = "07";
        } else if (mon.equals("Aug")) {
            month = "08";
        } else if (mon.equals("Sep")) {
            month = "09";
        } else if (mon.equals("Oct")) {
            month = "10";
        } else if (mon.equals("Nov")) {
            month = "11";
        } else if (mon.equals("Dec")) {
            month = "12";
        }
        return year + "-" + month + "-" + day;
    }

    public static String nowDate() {
        Date now = new Date();
        String nowString = now.toString();
        StringTokenizer st = new StringTokenizer(nowString, " ");
        String monTag = st.nextToken();
        String month = st.nextToken();
        String day = st.nextToken();
        String timeString = st.nextToken();
        String timezone = st.nextToken();
        String year = st.nextToken();
        return day + "-" + month + "-" + year;
    }

    public static int[][] InitialMatrix(String fileName) {
        String filePath = "/pub/" + fileName + ".matrix";
        return Tools.MatrixReader(filePath);
    }

    public static boolean isNumber(String str) {
        int i;
        int start;
        char[] chars = str.toCharArray();
        int sz = chars.length;
        boolean hasExp = false;
        boolean hasDecPoint = false;
        boolean allowSigns = false;
        boolean foundDigit = false;
        int n = start = chars[0] == '-' ? 1 : 0;
        if (sz > start + 1 && chars[start] == '0' && chars[start + 1] == 'x') {
            int i2 = start + 2;
            if (i2 == sz) {
                return false;
            }
            while (i2 < chars.length) {
                if (!(chars[i2] >= '0' && chars[i2] <= '9' || chars[i2] >= 'a' && chars[i2] <= 'f' || chars[i2] >= 'A' && chars[i2] <= 'F')) {
                    return false;
                }
                ++i2;
            }
            return true;
        }
        --sz;
        for (i = start; i < sz || i < sz + 1 && allowSigns && !foundDigit; ++i) {
            if (chars[i] >= '0' && chars[i] <= '9') {
                foundDigit = true;
                allowSigns = false;
                continue;
            }
            if (chars[i] == '.') {
                if (hasDecPoint || hasExp) {
                    return false;
                }
                hasDecPoint = true;
                continue;
            }
            if (chars[i] == 'e' || chars[i] == 'E') {
                if (hasExp) {
                    return false;
                }
                if (!foundDigit) {
                    return false;
                }
                hasExp = true;
                allowSigns = true;
                continue;
            }
            if (chars[i] == '+' || chars[i] == '-') {
                if (!allowSigns) {
                    return false;
                }
                allowSigns = false;
                foundDigit = false;
                continue;
            }
            return false;
        }
        if (i < chars.length) {
            if (chars[i] >= '0' && chars[i] <= '9') {
                return true;
            }
            if (chars[i] == 'e' || chars[i] == 'E') {
                return false;
            }
            if (chars[i] == '.') {
                if (hasDecPoint || hasExp) {
                    return false;
                }
                return foundDigit;
            }
            if (!(allowSigns || chars[i] != 'd' && chars[i] != 'D' && chars[i] != 'f' && chars[i] != 'F')) {
                return foundDigit;
            }
            if (chars[i] == 'l' || chars[i] == 'L') {
                return foundDigit && !hasExp;
            }
            return false;
        }
        return !allowSigns && foundDigit;
    }

    public static String getAppPath(Class cls) {
        URL url;
        String realPath;
        int pos;
        if (cls == null) {
            throw new IllegalArgumentException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        ClassLoader loader = cls.getClassLoader();
        String clsName = cls.getName() + ".class";
        Package pack = cls.getPackage();
        String path = "";
        if (pack != null) {
            String packName = pack.getName();
            if (packName.startsWith("java.") || packName.startsWith("javax.")) {
                throw new IllegalArgumentException("\u4e0d\u8981\u4f20\u9001\u7cfb\u7edf\u7c7b\uff01");
            }
            clsName = clsName.substring(packName.length() + 1);
            if (packName.indexOf(".") < 0) {
                path = packName + "/";
            } else {
                int start = 0;
                int end = 0;
                end = packName.indexOf(".");
                while (end != -1) {
                    path = path + packName.substring(start, end) + "/";
                    start = end + 1;
                    end = packName.indexOf(".", start);
                }
                path = path + packName.substring(start) + "/";
            }
        }
        if ((pos = (realPath = (url = loader.getResource(path + clsName)).getPath()).indexOf("file:")) > -1) {
            realPath = realPath.substring(pos + 5);
        }
        if ((realPath = realPath.substring(0, (pos = realPath.indexOf(path + clsName)) - 1)).endsWith("!")) {
            realPath = realPath.substring(0, realPath.lastIndexOf("/"));
        }
        try {
            realPath = URLDecoder.decode(realPath, "utf-8");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return realPath;
    }
}

