/*
 * Decompiled with CFR 0.152.
 */
package gui.ibs;

import gui.Filter;
import gui.ProgressDialog;
import gui.Tools;
import gui.ibs.CanvasPanel;
import gui.ibs.IBSFrame;
import gui.ibs.Project;
import gui.ibs.Project2XML;
import gui.ibs.ToolOutPut;
import gui.ibs.Verifier;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.text.DecimalFormat;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class BatchOutputJDialog
extends JDialog {
    public CanvasPanel canvasPanel;
    private int width;
    private int height;
    private double ratio;
    private DecimalFormat df = new DecimalFormat("##");
    private DefaultListModel sampleListModel;
    private LinkedList seqFileList = new LinkedList();
    public static String mode = "";
    private JButton addButton;
    private JButton cancelButton;
    private JLabel exportLabel;
    private JPanel exportPanel;
    private JTextField exportTextField;
    private JButton folderChooseButton;
    private JLabel heightLabel;
    private JTextField heightTextField;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JButton okButton;
    private JPanel parameterPanel;
    private JCheckBox ratioCheckBox;
    private JButton removeAllButton;
    private JButton removeButton;
    private JComboBox resolutionComboBox;
    private JLabel resolutionLabel;
    private JPanel sampleChosePanel;
    private JList sampleFileList;
    private JPanel samplePanel;
    private JScrollPane sampleScrollPane;
    private JComboBox unitComboBox;
    private JLabel unitLabel;
    private JLabel widthLabel;
    private JTextField widthTextField;

    public String getMode() {
        return mode;
    }

    public void setMode(String mode) {
        BatchOutputJDialog.mode = mode;
    }

    public BatchOutputJDialog(IBSFrame parent, boolean modal, String fmode) {
        super((Frame)parent, modal);
        this.initComponents();
        mode = fmode;
        this.canvasPanel = parent.canvasPanel;
        this.width = Math.round(this.canvasPanel.getWidth());
        this.height = Math.round(this.canvasPanel.getHeight());
        this.widthTextField.setText(String.valueOf(this.width));
        this.heightTextField.setText(String.valueOf(this.height));
        this.ratio = (float)this.width / (float)this.height;
    }

    private void initComponents() {
        this.samplePanel = new JPanel();
        this.sampleScrollPane = new JScrollPane();
        this.sampleFileList = new JList();
        this.sampleChosePanel = new JPanel();
        this.removeAllButton = new JButton();
        this.removeButton = new JButton();
        this.addButton = new JButton();
        this.jPanel3 = new JPanel();
        this.jPanel2 = new JPanel();
        this.cancelButton = new JButton();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.okButton = new JButton();
        this.jPanel1 = new JPanel();
        this.parameterPanel = new JPanel();
        this.widthLabel = new JLabel();
        this.widthTextField = new JTextField();
        this.unitComboBox = new JComboBox();
        this.heightLabel = new JLabel();
        this.heightTextField = new JTextField();
        this.unitLabel = new JLabel();
        this.resolutionLabel = new JLabel();
        this.resolutionComboBox = new JComboBox();
        this.ratioCheckBox = new JCheckBox();
        this.exportPanel = new JPanel();
        this.exportLabel = new JLabel();
        this.exportTextField = new JTextField();
        this.folderChooseButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Batch Export Images");
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 2));
        this.samplePanel.setBorder(BorderFactory.createTitledBorder(null, "IBS Project List", 0, 0, new Font("Arial", 1, 14)));
        this.samplePanel.setMinimumSize(new Dimension(250, 82));
        this.samplePanel.setPreferredSize(new Dimension(350, 250));
        this.samplePanel.setLayout(new BorderLayout());
        this.sampleFileList.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.sampleFileList.setModel(new DefaultListModel());
        this.sampleListModel = (DefaultListModel)this.sampleFileList.getModel();
        this.sampleScrollPane.setViewportView(this.sampleFileList);
        this.samplePanel.add((Component)this.sampleScrollPane, "Center");
        this.sampleChosePanel.setLayout(new GridBagLayout());
        this.removeAllButton.setFont(new Font("Arial", 1, 12));
        this.removeAllButton.setText("Remove All");
        this.removeAllButton.setMaximumSize(new Dimension(200, 23));
        this.removeAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BatchOutputJDialog.this.removeAllButtonActionPerformed(evt);
            }
        });
        this.sampleChosePanel.add((Component)this.removeAllButton, new GridBagConstraints());
        this.removeButton.setFont(new Font("Arial", 1, 12));
        this.removeButton.setText("Remove");
        this.removeButton.setMaximumSize(new Dimension(200, 23));
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BatchOutputJDialog.this.removeButtonActionPerformed(evt);
            }
        });
        this.sampleChosePanel.add((Component)this.removeButton, new GridBagConstraints());
        this.addButton.setFont(new Font("Arial", 1, 12));
        this.addButton.setText("Add File");
        this.addButton.setMaximumSize(new Dimension(200, 23));
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BatchOutputJDialog.this.addButtonActionPerformed(evt);
            }
        });
        this.sampleChosePanel.add((Component)this.addButton, new GridBagConstraints());
        this.samplePanel.add((Component)this.sampleChosePanel, "South");
        this.getContentPane().add(this.samplePanel);
        this.samplePanel.getAccessibleContext().setAccessibleName("IBS Project List");
        this.jPanel3.setPreferredSize(new Dimension(400, 230));
        this.jPanel3.setLayout(new BorderLayout());
        this.jPanel2.setPreferredSize(new Dimension(399, 30));
        this.jPanel2.setLayout(new GridLayout(1, 0));
        this.cancelButton.setFont(new Font("Arial", 1, 12));
        this.cancelButton.setText("Cancel");
        this.cancelButton.setMaximumSize(new Dimension(120, 23));
        this.cancelButton.setPreferredSize(new Dimension(90, 23));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BatchOutputJDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.cancelButton);
        this.jPanel2.add(this.jLabel1);
        this.jPanel2.add(this.jLabel2);
        this.okButton.setFont(new Font("Arial", 1, 12));
        this.okButton.setText("Export");
        this.okButton.setMaximumSize(new Dimension(120, 23));
        this.okButton.setPreferredSize(new Dimension(90, 23));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BatchOutputJDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.okButton);
        this.jPanel3.add((Component)this.jPanel2, "South");
        this.jPanel1.setPreferredSize(new Dimension(367, 200));
        this.jPanel1.setLayout(new BorderLayout());
        this.parameterPanel.setBorder(BorderFactory.createTitledBorder(null, "Image Parameter", 0, 0, new Font("Arial", 1, 14)));
        this.parameterPanel.setPreferredSize(new Dimension(360, 130));
        this.parameterPanel.setLayout(new GridLayout(3, 3, 10, 10));
        this.widthLabel.setFont(new Font("Arial", 1, 12));
        this.widthLabel.setHorizontalAlignment(4);
        this.widthLabel.setText("Width");
        this.parameterPanel.add(this.widthLabel);
        this.widthTextField.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.widthTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                BatchOutputJDialog.this.widthTextFieldKeyReleased(evt);
            }
        });
        this.parameterPanel.add(this.widthTextField);
        this.unitComboBox.setFont(new Font("Arial", 1, 12));
        this.unitComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"cm", "mm", "pix", "inch"}));
        this.unitComboBox.setSelectedIndex(2);
        this.unitComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                BatchOutputJDialog.this.unitComboBoxItemStateChanged(evt);
            }
        });
        this.parameterPanel.add(this.unitComboBox);
        this.heightLabel.setFont(new Font("Arial", 1, 12));
        this.heightLabel.setHorizontalAlignment(4);
        this.heightLabel.setText("Height");
        this.parameterPanel.add(this.heightLabel);
        this.heightTextField.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.heightTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                BatchOutputJDialog.this.heightTextFieldKeyReleased(evt);
            }
        });
        this.parameterPanel.add(this.heightTextField);
        this.unitLabel.setFont(new Font("Arial", 1, 12));
        this.unitLabel.setText(" pix");
        this.parameterPanel.add(this.unitLabel);
        this.resolutionLabel.setFont(new Font("Arial", 1, 12));
        this.resolutionLabel.setHorizontalAlignment(4);
        this.resolutionLabel.setText("Image Format");
        this.parameterPanel.add(this.resolutionLabel);
        this.resolutionComboBox.setFont(new Font("Arial", 1, 12));
        this.resolutionComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"JPG (72dpi)", "PNG (72dpi)", "TIFF (300dpi)", "TIFF (600dpi)", "SVG (vector image)"}));
        this.resolutionComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                BatchOutputJDialog.this.resolutionComboBoxItemStateChanged(evt);
            }
        });
        this.parameterPanel.add(this.resolutionComboBox);
        this.ratioCheckBox.setFont(new Font("Arial", 1, 12));
        this.ratioCheckBox.setSelected(true);
        this.ratioCheckBox.setText("Keep W/H ratio");
        this.parameterPanel.add(this.ratioCheckBox);
        this.jPanel1.add((Component)this.parameterPanel, "Center");
        this.exportPanel.setBorder(BorderFactory.createTitledBorder(""));
        this.exportPanel.setPreferredSize(new Dimension(150, 50));
        this.exportPanel.setLayout(new GridBagLayout());
        this.exportLabel.setFont(new Font("Arial", 1, 12));
        this.exportLabel.setText("Export Folder ");
        this.exportPanel.add((Component)this.exportLabel, new GridBagConstraints());
        this.exportTextField.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.exportTextField.setMaximumSize(new Dimension(1000, 25));
        this.exportTextField.setMinimumSize(new Dimension(250, 25));
        this.exportTextField.setPreferredSize(new Dimension(500, 25));
        this.exportPanel.add((Component)this.exportTextField, new GridBagConstraints());
        this.folderChooseButton.setText(">>");
        this.folderChooseButton.setMaximumSize(new Dimension(60, 23));
        this.folderChooseButton.setPreferredSize(new Dimension(50, 23));
        this.folderChooseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BatchOutputJDialog.this.folderChooseButtonActionPerformed(evt);
            }
        });
        this.exportPanel.add((Component)this.folderChooseButton, new GridBagConstraints());
        this.jPanel1.add((Component)this.exportPanel, "Last");
        this.jPanel3.add((Component)this.jPanel1, "Center");
        this.getContentPane().add(this.jPanel3);
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        boolean isWidthTextValiable = new Verifier().isPositive(this.widthTextField);
        boolean isHeightTextValiable = new Verifier().isPositive(this.heightTextField);
        boolean isExportFileEmpty = new Verifier().isEmpty(this.exportTextField);
        StringBuffer errorSb = new StringBuffer();
        if (isExportFileEmpty) {
            errorSb.append("Export Folder : Please choose an export folder\n");
        }
        if (!isWidthTextValiable) {
            errorSb.append("Width : should be a positive number \n");
        }
        if (!isHeightTextValiable) {
            errorSb.append("Height : should be a positive number \n");
        }
        if (!isExportFileEmpty && isWidthTextValiable && isHeightTextValiable) {
            String strPicpath = this.exportTextField.getText();
            String strFormat = "";
            if (this.resolutionComboBox.getSelectedIndex() == 0) {
                strFormat = "A";
            } else if (this.resolutionComboBox.getSelectedIndex() == 1) {
                strFormat = "B";
            } else if (this.resolutionComboBox.getSelectedIndex() == 2) {
                strFormat = "C";
            } else if (this.resolutionComboBox.getSelectedIndex() == 3) {
                strFormat = "D";
            } else if (this.resolutionComboBox.getSelectedIndex() == 4) {
                strFormat = "E";
            }
            double iwidth = Double.parseDouble(this.widthTextField.getText());
            double iheight = Double.parseDouble(this.heightTextField.getText());
            String strUnit = this.unitComboBox.getSelectedItem().toString();
            boolean bwhratio = this.ratioCheckBox.isSelected();
            ToolOutPut op = new ToolOutPut();
            op.batchOutbyDialog(this.seqFileList, strPicpath, strFormat, strUnit, iwidth, iheight, bwhratio, this);
        } else {
            JOptionPane.showConfirmDialog(this, errorSb.toString(), "Parameter Error", -1, 0, null);
        }
    }

    private void widthTextFieldKeyReleased(KeyEvent evt) {
        try {
            double w = Double.parseDouble(this.widthTextField.getText());
            double h = Double.parseDouble(this.heightTextField.getText());
            if (this.ratioCheckBox.isSelected()) {
                h = w / this.ratio;
                this.heightTextField.setText(this.df.format(h));
            }
            if (this.unitComboBox.getSelectedItem().equals("pix")) {
                this.width = (int)w;
                this.height = (int)h;
            } else if (this.unitComboBox.getSelectedItem().equals("cm")) {
                this.width = (int)(w * 72.0 / 2.54);
                this.height = (int)(h * 72.0 / 2.54);
            } else if (this.unitComboBox.getSelectedItem().equals("mm")) {
                this.width = (int)(w * 72.0 / 25.4);
                this.height = (int)(h * 72.0 / 25.4);
            } else if (this.unitComboBox.getSelectedItem().equals("inch")) {
                this.width = (int)(w * 72.0);
                this.height = (int)(h * 72.0);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void heightTextFieldKeyReleased(KeyEvent evt) {
        try {
            double h = Double.parseDouble(this.heightTextField.getText());
            double w = Double.parseDouble(this.widthTextField.getText());
            if (this.ratioCheckBox.isSelected()) {
                w = h * this.ratio;
                this.widthTextField.setText(this.df.format(w));
            }
            this.ratio = (double)((float)w) / h;
            if (this.unitComboBox.getSelectedItem().equals("pix")) {
                this.width = (int)w;
                this.height = (int)h;
            } else if (this.unitComboBox.getSelectedItem().equals("cm")) {
                this.width = (int)(w * 72.0 / 2.54);
                this.height = (int)(h * 72.0 / 2.54);
            } else if (this.unitComboBox.getSelectedItem().equals("mm")) {
                this.width = (int)(w * 72.0 / 25.4);
                this.height = (int)(h * 72.0 / 25.4);
            } else if (this.unitComboBox.getSelectedItem().equals("inch")) {
                this.width = (int)(w * 72.0);
                this.height = (int)(h * 72.0);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void unitComboBoxItemStateChanged(ItemEvent evt) {
        if (this.unitComboBox.getSelectedItem().equals("pix")) {
            if (this.resolutionComboBox.getSelectedItem().equals("JPG (72dpi)") || this.resolutionComboBox.getSelectedItem().equals("PNG (72dpi)") || this.resolutionComboBox.getSelectedItem().equals("vector image")) {
                this.widthTextField.setText(String.valueOf(this.width));
                this.heightTextField.setText(String.valueOf(this.height));
            } else if (this.resolutionComboBox.getSelectedItem().equals("TIFF (300dpi)")) {
                if (2125.984251968504 < (double)(this.width * 300 / 72)) {
                    this.widthTextField.setText(String.valueOf(this.df.format(2125.984251968504)));
                    this.heightTextField.setText(String.valueOf(this.df.format(1535.4330708661416)));
                } else {
                    this.widthTextField.setText(String.valueOf(this.width * 300 / 72));
                    this.heightTextField.setText(String.valueOf(this.height * 300 / 72));
                }
            } else if (this.resolutionComboBox.getSelectedItem().equals("TIFF (600dpi)")) {
                if (4251.968503937008 < (double)(this.width * 600 / 72)) {
                    this.widthTextField.setText(String.valueOf(this.df.format(4251.968503937008)));
                    this.heightTextField.setText(String.valueOf(this.df.format(3070.8661417322833)));
                } else {
                    this.widthTextField.setText(String.valueOf(this.width * 600 / 72));
                    this.heightTextField.setText(String.valueOf(this.height * 600 / 72));
                }
            }
            this.unitLabel.setText(" pix");
        } else if (this.unitComboBox.getSelectedItem().equals("cm")) {
            this.unitLabel.setText(" cm");
            if (this.resolutionComboBox.getSelectedItem().equals("JPG (72dpi)") || this.resolutionComboBox.getSelectedItem().equals("PNG (72dpi)")) {
                this.widthTextField.setText(this.df.format((double)this.width / 72.0 * 2.54));
                this.heightTextField.setText(this.df.format((double)this.height / 72.0 * 2.54));
            } else if (18.0 < (double)this.width / 72.0 * 2.54) {
                double wt = 13.5;
                DecimalFormat df = new DecimalFormat("#.00");
                df.format(wt);
                this.heightTextField.setText(String.format("%.2f", wt));
                this.widthTextField.setText("18.00");
            } else {
                this.widthTextField.setText(this.df.format((double)this.width / 72.0 * 2.54));
                this.heightTextField.setText(this.df.format((double)this.height / 72.0 * 2.54));
            }
        } else if (this.unitComboBox.getSelectedItem().equals("mm")) {
            if (this.resolutionComboBox.getSelectedItem().equals("TIFF (300dpi)") || this.resolutionComboBox.getSelectedItem().equals("TIFF (600dpi)")) {
                if (18.0 < (double)this.width / 72.0 * 25.4 / 10.0) {
                    this.widthTextField.setText("180.00");
                    this.heightTextField.setText("130.00");
                } else {
                    this.widthTextField.setText(this.df.format((double)this.width / 72.0 * 25.4));
                    this.heightTextField.setText(this.df.format((double)this.height / 72.0 * 25.4));
                }
            } else {
                this.widthTextField.setText(this.df.format((double)this.width / 72.0 * 25.4));
                this.heightTextField.setText(this.df.format((double)this.height / 72.0 * 25.4));
            }
            this.unitLabel.setText(" mm");
        } else if (this.unitComboBox.getSelectedItem().equals("inch")) {
            if (this.resolutionComboBox.getSelectedItem().equals("TIFF (300dpi)") || this.resolutionComboBox.getSelectedItem().equals("TIFF (600dpi)")) {
                if (7.086614173228346 < (double)this.width / 72.0 * 25.4) {
                    this.widthTextField.setText(this.df.format(7.086614173228346));
                    this.heightTextField.setText(this.df.format(5.118110236220472));
                } else {
                    this.widthTextField.setText(this.df.format((double)this.width / 72.0 * 25.4));
                    this.heightTextField.setText(this.df.format((double)this.height / 72.0 * 25.4));
                }
            } else {
                this.widthTextField.setText(this.df.format((double)this.width / 72.0));
                this.heightTextField.setText(this.df.format((double)this.height / 72.0));
                this.unitLabel.setText(" inch");
            }
        }
    }

    private void resolutionComboBoxItemStateChanged(ItemEvent evt) {
        String selectedItem = String.valueOf(this.resolutionComboBox.getSelectedItem());
        if (this.unitComboBox.getSelectedItem().equals("pix") && (selectedItem.equals("JPG (72dpi)") || selectedItem.equals("PNG (72dpi)") || selectedItem.equals("SVG (vector image)"))) {
            this.widthTextField.setText(String.valueOf(this.width));
            this.heightTextField.setText(String.valueOf(this.height));
            this.unitComboBox.setSelectedIndex(2);
            this.unitLabel.setText("pix");
        }
        if (selectedItem.equals("TIFF (300dpi)")) {
            this.unitComboBox.setSelectedIndex(0);
            this.unitLabel.setText("cm");
            double wt = 13.5;
            DecimalFormat df = new DecimalFormat("#.00");
            df.format(wt);
            this.heightTextField.setText(String.format("%.2f", wt));
            this.widthTextField.setText("18.00");
        } else if (selectedItem.equals("TIFF (600dpi)")) {
            this.unitComboBox.setSelectedIndex(0);
            this.unitLabel.setText("cm");
            double wt = 13.5;
            DecimalFormat df = new DecimalFormat("#.00");
            df.format(wt);
            this.heightTextField.setText(String.format("%.2f", wt));
            this.widthTextField.setText("18.00");
        }
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void removeAllButtonActionPerformed(ActionEvent evt) {
        this.sampleFileList.removeAll();
        this.sampleListModel.removeAllElements();
        this.seqFileList = new LinkedList();
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        if (this.sampleFileList.isSelectionEmpty()) {
            JOptionPane.showMessageDialog(null, "Please select a sequence file .", "Warning", 2);
        } else {
            int selectedIndex = this.sampleFileList.getSelectedIndex();
            this.sampleListModel.removeElementAt(selectedIndex);
            this.seqFileList.remove(selectedIndex);
        }
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        JFileChooser fc = new JFileChooser(Tools.CURRENT_FILE_PATH);
        fc.setMultiSelectionEnabled(true);
        fc.setAcceptAllFileFilterUsed(false);
        fc.addChoosableFileFilter(new Filter("XML", "IBS Project (*.XML)"));
        int returnVal = fc.showOpenDialog(this);
        if (returnVal == 0) {
            File[] fileList = fc.getSelectedFiles();
            for (int i = 0; i < fileList.length; ++i) {
                File file = fileList[i];
                if (this.seqFileList.contains(file)) {
                    JOptionPane.showMessageDialog(null, file.getName() + " already exists.", "Warning", 2);
                    continue;
                }
                this.seqFileList.add(file);
                this.sampleListModel.addElement(file.getAbsolutePath());
                Tools.CURRENT_FILE_PATH = file.getAbsolutePath();
                this.exportTextField.setText(file.getParent());
            }
        }
    }

    private void folderChooseButtonActionPerformed(ActionEvent evt) {
        JFileChooser fc = new JFileChooser(Tools.CURRENT_FILE_PATH);
        fc.setFileSelectionMode(1);
        fc.setAcceptAllFileFilterUsed(false);
        fc.addChoosableFileFilter(new Filter("", "Folder"));
        int returnVal = fc.showSaveDialog(this);
        if (returnVal == 0) {
            this.exportTextField.setText(fc.getSelectedFile().getPath());
        }
    }

    public static void main(String[] args) {
        IBSFrame df = new IBSFrame(mode);
        Tools.WindowCenter(new BatchOutputJDialog(df, true, mode));
    }

    public class BatchPredictionThread
    extends Thread {
        private String foldPath;

        public BatchPredictionThread() {
            this.foldPath = BatchOutputJDialog.this.exportTextField.getText().trim();
        }

        @Override
        public void run() {
            try {
                ProgressDialog progressDialog = new ProgressDialog();
                Tools.WindowCenter(progressDialog);
                double progressPercent = 0.0;
                LinkedList<String> errorFileList = new LinkedList<String>();
                double progressLargeStep = 100.0 / (double)BatchOutputJDialog.this.seqFileList.size();
                String origMode = mode;
                for (File file : BatchOutputJDialog.this.seqFileList) {
                    try {
                        String exportFilePath;
                        String strMode;
                        Project2XML pj = new Project2XML();
                        BatchOutputJDialog.this.canvasPanel.Mode = strMode = pj.getXMLMode(file.getAbsolutePath());
                        Project project = new Project2XML(file.getAbsolutePath()).open(strMode);
                        int iwidth = 800;
                        int iheight = 600;
                        double drate = 1.0;
                        iwidth = project.getWidth();
                        iheight = project.getHeight();
                        drate = project.rate;
                        BatchOutputJDialog.this.canvasPanel.batchOutrate = (float)drate;
                        BatchOutputJDialog.this.canvasPanel.rate = project.rate;
                        BatchOutputJDialog.this.canvasPanel.setProteinList(project.getProteinList());
                        progressDialog.setProcessValue(progressPercent + progressLargeStep);
                        String selectedItem = String.valueOf(BatchOutputJDialog.this.resolutionComboBox.getSelectedItem());
                        if (selectedItem.equals("JPG (72dpi)")) {
                            exportFilePath = this.foldPath + File.separatorChar + Tools.FileExtentionChange(file.getName(), "jpg");
                            BatchOutputJDialog.this.canvasPanel.outputImage(iwidth, iheight, exportFilePath, "JPG");
                            continue;
                        }
                        if (selectedItem.equals("PNG (72dpi)")) {
                            exportFilePath = this.foldPath + File.separatorChar + Tools.FileExtentionChange(file.getName(), "png");
                            BatchOutputJDialog.this.canvasPanel.outputImage(iwidth, iheight, exportFilePath, "PNG");
                            continue;
                        }
                        if (selectedItem.equals("TIFF (300dpi)")) {
                            exportFilePath = this.foldPath + File.separatorChar + Tools.FileExtentionChange(file.getName(), "tiff");
                            BatchOutputJDialog.this.canvasPanel.outputImage(iwidth, iheight, exportFilePath, "TIFF300dpi");
                            continue;
                        }
                        if (selectedItem.equals("TIFF (600dpi)")) {
                            exportFilePath = this.foldPath + File.separatorChar + Tools.FileExtentionChange(file.getName(), "tiff");
                            BatchOutputJDialog.this.canvasPanel.outputImage(iwidth, iheight, exportFilePath, "TIFF600dpi");
                            continue;
                        }
                        if (!selectedItem.equals("SVG (vector image)")) continue;
                        exportFilePath = this.foldPath + File.separatorChar + Tools.FileExtentionChange(file.getName(), "svg");
                        BatchOutputJDialog.this.canvasPanel.outputImage(iwidth, iheight, exportFilePath, "SVG");
                    }
                    catch (Exception e) {
                        errorFileList.add(file.getName());
                    }
                }
                progressDialog.setProcessValue(100.0);
                BatchOutputJDialog.this.canvasPanel.getProteinList().clear();
                BatchOutputJDialog.this.canvasPanel.Mode = origMode;
                if (errorFileList.size() == 0) {
                    progressDialog.dispose();
                    JOptionPane.showMessageDialog(null, "Batch Export Completed. ");
                } else {
                    progressDialog.dispose();
                    StringBuffer sb = new StringBuffer("");
                    for (String errorFile : errorFileList) {
                        sb.append(errorFile + "\n");
                    }
                    JOptionPane.showMessageDialog(new JDialog(), "The files :\n" + sb.toString() + "might not be ibs 2.0 Project! ", "Error", 0);
                }
            }
            catch (HeadlessException headlessException) {
                // empty catch block
            }
        }
    }
}

