/*
 * Decompiled with CFR 0.152.
 */
package gui.ibs;

import gui.Tools;
import gui.ibs.Component;
import gui.ibs.ComponentEnum;
import gui.ibs.CustomComboBoxDemo;
import gui.ibs.DomainDialogConfig;
import gui.ibs.EditDialog;
import gui.ibs.GradientEnum;
import gui.ibs.PreviewPanel;
import gui.ibs.ResourceBundleUtil;
import gui.ibs.ShapeEnum;
import gui.ibs.Verifier;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.LinkedList;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;

public class NucleotideDomainDialog
extends EditDialog {
    private Component component;
    private String DELIMIT = "#&%";
    public ShapeEnum shapeType = ShapeEnum.RoundRectangle;
    public GradientEnum gradientType;
    public String strNum = "";
    ResourceBundleUtil config;
    private ButtonGroup buttonGroup1;
    private JButton cancelButton;
    private JPanel colorLine;
    private JPanel colorPanel;
    private JPanel colorText;
    private CustomComboBoxDemo comBoxGradient;
    private CustomComboBoxDemo comboBoxShape;
    private JComboBox endComboBox;
    private JLabel endLabel;
    private JTextField endTextField;
    private JLabel fontLabel;
    private JTextField fontTextField;
    private JCheckBox jCheckBoxBorderDash;
    private JCheckBox jCheckBoxDC;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel16;
    private JLabel jLabel17;
    private JLabel jLabel18;
    private JLabel jLabel19;
    private JLabel jLabel2;
    private JLabel jLabel20;
    private JLabel jLabel21;
    private JLabel jLabel22;
    private JLabel jLabel23;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JLabel jLabelTip;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JRadioButton jRadioButton3;
    private JSpinner jSpinnerRotationAngle;
    private JSpinner jSpinnerStrokeSize;
    private JTextField jTextFieldID;
    private JTextField jTextFieldradius;
    private JPanel mainPanel;
    private JComboBox nameComboBox;
    private JLabel nameLabel;
    private JTextField nameTextField;
    private JButton okButton;
    private JPanel previewPanel;
    private JComboBox startComboBox;
    private JLabel startLabel;
    private JTextField startTextField;
    private CustomComboBoxDemo texturechoose;

    public ShapeEnum getShapeType() {
        return this.shapeType;
    }

    public void setShapeType(ShapeEnum shapeType) {
        this.shapeType = shapeType;
    }

    public NucleotideDomainDialog(Frame parent, String title, boolean modal, ImageIcon[] images, ImageIcon[] imagesShape, ImageIcon[] imagesGradient, String fstrNum) {
        super(parent, title, modal);
        this.strNum = fstrNum;
        this.setPreferredSize(new Dimension(780, 650));
        this.config = ResourceBundleUtil.getBundle("gui.ibs.config");
        this.initComponents();
        this.setTitle(title);
        this.texturechoose.DomainDialog = this;
        this.texturechoose.setComImages(images, "Text");
        this.comboBoxShape.DomainDialog = this;
        this.comboBoxShape.setComImages(imagesShape, "Shape");
        this.comBoxGradient.DomainDialog = this;
        this.comBoxGradient.setComImages(imagesGradient, "Gradient");
        String st = "Users can drag the element for absolute positioning, resize it and rotate it through the mouse. ";
        this.jLabelTip.setText(st);
        this.previewDraw();
        this.endTextField.requestFocus();
        this.enableEvents(8L);
        InputMap inputMap = this.rootPane.getInputMap(2);
        inputMap.put(KeyStroke.getKeyStroke("ESCAPE"), "ESCAPE");
        this.rootPane.getActionMap().put("ESCAPE", new AbstractAction("ESCAPE"){

            @Override
            public void actionPerformed(ActionEvent e) {
                NucleotideDomainDialog.this.cancelButton.doClick();
            }
        });
        inputMap.put(KeyStroke.getKeyStroke("ENTER"), "ENTER");
        this.rootPane.getActionMap().put("ENTER", new AbstractAction("ENTER"){

            @Override
            public void actionPerformed(ActionEvent e) {
                NucleotideDomainDialog.this.okButton.doClick();
            }
        });
    }

    public NucleotideDomainDialog(Frame parent, String title, boolean modal, ImageIcon[] images, ImageIcon[] imagesShape, ImageIcon[] imagesGradient, int proteinlenth, DomainDialogConfig ddc, String fstrNum) {
        super(parent, title, modal);
        this.strNum = fstrNum;
        this.setPreferredSize(new Dimension(780, 650));
        this.config = ResourceBundleUtil.getBundle("gui.ibs.config");
        this.initComponents();
        this.setTitle(title);
        this.texturechoose.DomainDialog = this;
        this.texturechoose.setComImages(images, "Text");
        this.comboBoxShape.DomainDialog = this;
        this.comboBoxShape.setComImages(imagesShape, "Shape");
        this.comBoxGradient.DomainDialog = this;
        this.comBoxGradient.setComImages(imagesGradient, "Gradient");
        if (!ddc.initDialog) {
            this.endTextField.setText(String.valueOf(10 + ddc.iwidth));
            this.jTextFieldradius.setText(String.valueOf(ddc.iheight));
            this.comboBoxShape.SelectTextureFile = this.config.getString("DomainDialog.shape");
            this.comboBoxShape.setComboBoxIndex();
        } else {
            String whrate = this.config.getString("DomainDialog.whrate");
            int wh = (int)Math.round((double)proteinlenth * Double.valueOf(whrate));
            this.endTextField.setText(String.valueOf(10 + wh));
            this.jTextFieldradius.setText(String.valueOf(wh));
            this.comboBoxShape.SelectTextureFile = this.config.getString("DomainDialog.shape");
            this.comboBoxShape.setComboBoxIndex();
        }
        String st = "Users can drag the element for absolute positioning, resize it and rotate it through the mouse.";
        this.jLabelTip.setText(st);
        this.jTextFieldID.setText(this.strNum);
        Color bc = new Color(204, 204, 204);
        this.jTextFieldID.setForeground(bc);
        this.previewDraw();
        this.endTextField.requestFocus();
        this.enableEvents(8L);
        InputMap inputMap = this.rootPane.getInputMap(2);
        inputMap.put(KeyStroke.getKeyStroke("ESCAPE"), "ESCAPE");
        this.rootPane.getActionMap().put("ESCAPE", new AbstractAction("ESCAPE"){

            @Override
            public void actionPerformed(ActionEvent e) {
                NucleotideDomainDialog.this.cancelButton.doClick();
            }
        });
        inputMap.put(KeyStroke.getKeyStroke("ENTER"), "ENTER");
        this.rootPane.getActionMap().put("ENTER", new AbstractAction("ENTER"){

            @Override
            public void actionPerformed(ActionEvent e) {
                NucleotideDomainDialog.this.okButton.doClick();
            }
        });
    }

    @Override
    public Component getComponent() {
        return this.component;
    }

    @Override
    public void setComponent(Component component) {
        this.jCheckBoxDC.setSelected(false);
        this.colorPanel.setBackground(component.getColor());
        this.colorText.setBackground(component.getColorText());
        this.colorLine.setBackground(component.getColorline());
        String[] arr = component.getParameter().split(this.DELIMIT);
        this.startTextField.setText(String.valueOf((int)component.getX()));
        this.startComboBox.setSelectedItem(arr[0]);
        this.endComboBox.setSelectedItem(arr[1]);
        this.nameTextField.setText(arr[2]);
        this.nameComboBox.setSelectedItem(arr[3]);
        this.fontTextField.setText(arr[4]);
        this.endTextField.setText(String.valueOf((int)component.getX2()));
        this.jSpinnerRotationAngle.setValue((int)component.getRotationAngle());
        this.shapeType = component.getShapeType();
        this.jSpinnerStrokeSize.setValue(Integer.valueOf(arr[5]));
        this.jCheckBoxBorderDash.setSelected(component.bDash);
        this.gradientType = GradientEnum.valueOf(arr[6]);
        this.comboBoxShape.SelectTextureFile = component.getShapeType().name().toString();
        this.comboBoxShape.setComboBoxIndex();
        this.comBoxGradient.SelectTextureFile = arr[6];
        this.comBoxGradient.setComboBoxIndex();
        this.jTextFieldradius.setText(String.valueOf((int)component.getHigh()));
        this.texturechoose.SelectTextureFile = arr[7] == null ? "00000_0.jpg" : arr[7];
        this.texturechoose.setComboBoxIndex();
        if (component.fid != null && !component.fid.trim().equals("") && component.fid.trim() != null) {
            this.jTextFieldID.setText(component.fid);
            this.jTextFieldID.setForeground(Color.BLACK);
        }
        this.previewDraw();
    }

    public void changeGradient() {
        if (this.texturechoose.SelectTextureFile.equals("00000_0.jpg") || this.texturechoose.SelectTextureFile.equals("00001.jpg") || this.texturechoose.SelectTextureFile.equals("00001_d.jpg") || this.texturechoose.SelectTextureFile.equals("00002.jpg") || this.texturechoose.SelectTextureFile.equals("00002_d.jpg") || this.texturechoose.SelectTextureFile.equals("00003.jpg") || this.texturechoose.SelectTextureFile.equals("00003_d.jpg") || this.texturechoose.SelectTextureFile.equals("00004.jpg") || this.texturechoose.SelectTextureFile.equals("00004_d.jpg") || this.texturechoose.SelectTextureFile.equals("00005.jpg") || this.texturechoose.SelectTextureFile.equals("00005_d.jpg") || this.texturechoose.SelectTextureFile.equals("00006.jpg") || !this.texturechoose.SelectTextureFile.equals("00006_d.jpg")) {
            // empty if block
        }
    }

    public void previewDraw() {
        LinkedList<Component> componentList = new LinkedList<Component>();
        String name = "";
        boolean isNameEmpty = new Verifier().isEmpty(this.nameTextField);
        name = isNameEmpty ? " " : this.nameTextField.getText();
        int iStart = 0;
        int iEnd = 0;
        int iHigh = 0;
        iStart = Integer.parseInt(this.startTextField.getText().trim());
        iEnd = (int)Double.parseDouble(this.endTextField.getText().trim());
        iHigh = (int)Double.parseDouble(this.jTextFieldradius.getText().trim());
        int strokesize = (Integer)this.jSpinnerStrokeSize.getValue();
        int iRotationAngle = (Integer)this.jSpinnerRotationAngle.getValue();
        if (this.comboBoxShape.SelectTextureFile.equals("00000_1.jpg")) {
            this.shapeType = ShapeEnum.Rectangle;
        } else {
            String strShape = this.comboBoxShape.SelectTextureFile;
            if (strShape.indexOf(".") > 0) {
                strShape = strShape.substring(0, strShape.indexOf("."));
            }
            this.shapeType = ShapeEnum.valueOf(strShape);
        }
        if (this.comBoxGradient.SelectTextureFile.equals("00000_1.jpg")) {
            this.gradientType = GradientEnum.Null;
        } else {
            String strGradient = this.comBoxGradient.SelectTextureFile;
            if (strGradient.indexOf(".") > 0) {
                strGradient = strGradient.substring(0, strGradient.indexOf("."));
            }
            this.gradientType = GradientEnum.valueOf(strGradient);
        }
        String parameter = this.startComboBox.getSelectedItem() + this.DELIMIT + this.endComboBox.getSelectedItem() + this.DELIMIT + name + this.DELIMIT + this.nameComboBox.getSelectedItem() + this.DELIMIT + this.fontTextField.getText().trim() + this.DELIMIT + strokesize + this.DELIMIT + this.gradientType.name().toString() + this.DELIMIT + this.texturechoose.SelectTextureFile;
        Component domain = new Component(ComponentEnum.Domain, iStart, iEnd, parameter, this.colorPanel.getBackground(), this.shapeType, iHigh, iRotationAngle);
        componentList.add(domain);
        PreviewPanel.protein.setComponentList(componentList);
        PreviewPanel.Mode = "N";
        this.previewPanel.repaint();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jLabel6 = new JLabel();
        this.jRadioButton3 = new JRadioButton();
        this.jLabel7 = new JLabel();
        this.jLabel9 = new JLabel();
        this.jLabel11 = new JLabel();
        this.previewPanel = new PreviewPanel();
        this.mainPanel = new JPanel();
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        this.jPanel2 = new JPanel();
        this.startLabel = new JLabel();
        this.startTextField = new JTextField();
        this.startComboBox = new JComboBox();
        this.jLabel4 = new JLabel();
        this.endLabel = new JLabel();
        this.endTextField = new JTextField();
        this.endComboBox = new JComboBox();
        this.jLabel14 = new JLabel();
        this.jLabel1 = new JLabel();
        this.jTextFieldradius = new JTextField();
        this.jLabel8 = new JLabel();
        this.jLabel12 = new JLabel();
        this.jPanel3 = new JPanel();
        this.jLabel10 = new JLabel();
        this.comboBoxShape = new CustomComboBoxDemo();
        this.jLabel5 = new JLabel();
        this.jSpinnerRotationAngle = new JSpinner();
        this.jLabel17 = new JLabel();
        this.colorPanel = new JPanel();
        this.jCheckBoxDC = new JCheckBox();
        this.jLabel16 = new JLabel();
        this.jLabel18 = new JLabel();
        this.texturechoose = new CustomComboBoxDemo();
        this.jLabel13 = new JLabel();
        this.comBoxGradient = new CustomComboBoxDemo();
        this.jPanel4 = new JPanel();
        this.nameLabel = new JLabel();
        this.nameTextField = new JTextField();
        this.jLabel19 = new JLabel();
        this.nameComboBox = new JComboBox();
        this.fontLabel = new JLabel();
        this.fontTextField = new JTextField();
        this.jLabel20 = new JLabel();
        this.colorText = new JPanel();
        this.jPanel5 = new JPanel();
        this.jLabel2 = new JLabel();
        this.jSpinnerStrokeSize = new JSpinner();
        this.jCheckBoxBorderDash = new JCheckBox();
        this.jLabel15 = new JLabel();
        this.jLabel21 = new JLabel();
        this.colorLine = new JPanel();
        this.jLabel23 = new JLabel();
        this.jPanel6 = new JPanel();
        this.jLabel22 = new JLabel();
        this.jTextFieldID = new JTextField();
        this.jPanel1 = new JPanel();
        this.jLabelTip = new JLabel();
        this.jLabel6.setText("jLabel6");
        this.jRadioButton3.setText("Ellipse");
        this.jRadioButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NucleotideDomainDialog.this.jRadioButton3ActionPerformed(evt);
            }
        });
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(753, 548));
        this.setResizable(false);
        this.getContentPane().setLayout(new BorderLayout());
        this.previewPanel.setBorder(BorderFactory.createTitledBorder(null, "Preview", 0, 0, new Font("Arial", 1, 14)));
        this.previewPanel.setMinimumSize(new Dimension(280, 240));
        this.previewPanel.setPreferredSize(new Dimension(280, 500));
        this.previewPanel.setLayout(new BorderLayout());
        this.getContentPane().add((java.awt.Component)this.previewPanel, "Center");
        this.mainPanel.setBorder(BorderFactory.createTitledBorder(null, "Option", 0, 0, new Font("Arial", 1, 14)));
        this.mainPanel.setMinimumSize(new Dimension(450, 440));
        this.mainPanel.setPreferredSize(new Dimension(450, 500));
        this.cancelButton.setFont(new Font("Arial", 1, 12));
        this.cancelButton.setText("Cancel");
        this.cancelButton.setPreferredSize(new Dimension(75, 27));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NucleotideDomainDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.okButton.setFont(new Font("Arial", 1, 12));
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NucleotideDomainDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(null, "Position", 0, 0, new Font("Arial", 1, 12)));
        this.jPanel2.setLayout(new GridLayout(3, 4, 10, 10));
        this.startLabel.setFont(new Font("Arial", 1, 12));
        this.startLabel.setHorizontalAlignment(4);
        this.startLabel.setText("Start");
        this.jPanel2.add(this.startLabel);
        this.startTextField.setHorizontalAlignment(0);
        this.startTextField.setText("10");
        this.jPanel2.add(this.startTextField);
        this.startComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Down", "Up", "Hide"}));
        this.startComboBox.setSelectedIndex(2);
        this.startComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                NucleotideDomainDialog.this.startComboBoxItemStateChanged(evt);
            }
        });
        this.jPanel2.add(this.startComboBox);
        this.jLabel4.setFont(new Font("Arial", 1, 12));
        this.jLabel4.setHorizontalAlignment(0);
        this.jPanel2.add(this.jLabel4);
        this.endLabel.setFont(new Font("Arial", 1, 12));
        this.endLabel.setHorizontalAlignment(4);
        this.endLabel.setText("End");
        this.endLabel.setToolTipText("");
        this.jPanel2.add(this.endLabel);
        this.endTextField.setHorizontalAlignment(0);
        this.endTextField.setText("50");
        this.endTextField.addInputMethodListener(new InputMethodListener(){

            @Override
            public void caretPositionChanged(InputMethodEvent evt) {
            }

            @Override
            public void inputMethodTextChanged(InputMethodEvent evt) {
                NucleotideDomainDialog.this.endTextFieldInputMethodTextChanged(evt);
            }
        });
        this.jPanel2.add(this.endTextField);
        this.endComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Down", "Up", "Hide"}));
        this.endComboBox.setSelectedIndex(2);
        this.endComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                NucleotideDomainDialog.this.endComboBoxItemStateChanged(evt);
            }
        });
        this.jPanel2.add(this.endComboBox);
        this.jLabel14.setFont(new Font("Arial", 1, 12));
        this.jLabel14.setHorizontalAlignment(0);
        this.jPanel2.add(this.jLabel14);
        this.jLabel1.setFont(new Font("Arial", 1, 12));
        this.jLabel1.setHorizontalAlignment(4);
        this.jLabel1.setText("Height");
        this.jLabel1.setToolTipText("");
        this.jPanel2.add(this.jLabel1);
        this.jTextFieldradius.setHorizontalAlignment(0);
        this.jTextFieldradius.setText("40");
        this.jTextFieldradius.setToolTipText("");
        this.jTextFieldradius.addInputMethodListener(new InputMethodListener(){

            @Override
            public void caretPositionChanged(InputMethodEvent evt) {
            }

            @Override
            public void inputMethodTextChanged(InputMethodEvent evt) {
                NucleotideDomainDialog.this.jTextFieldradiusInputMethodTextChanged(evt);
            }
        });
        this.jPanel2.add(this.jTextFieldradius);
        this.jPanel2.add(this.jLabel8);
        this.jPanel2.add(this.jLabel12);
        this.jPanel3.setBorder(BorderFactory.createTitledBorder(null, "Style", 0, 0, new Font("Arial", 1, 12)));
        this.jPanel3.setLayout(new GridLayout(3, 4, 10, 10));
        this.jLabel10.setFont(new Font("Arial", 1, 12));
        this.jLabel10.setHorizontalAlignment(4);
        this.jLabel10.setText("Shape");
        this.jPanel3.add(this.jLabel10);
        this.jPanel3.add(this.comboBoxShape);
        this.jLabel5.setFont(new Font("Arial", 1, 12));
        this.jLabel5.setHorizontalAlignment(4);
        this.jLabel5.setText("Rotation Angle");
        this.jPanel3.add(this.jLabel5);
        this.jSpinnerRotationAngle.setModel(new SpinnerNumberModel(0, -360, 360, 1));
        this.jSpinnerRotationAngle.setToolTipText("rotation angle");
        this.jSpinnerRotationAngle.setMinimumSize(new Dimension(41, 10));
        this.jSpinnerRotationAngle.setPreferredSize(new Dimension(41, 10));
        this.jSpinnerRotationAngle.addInputMethodListener(new InputMethodListener(){

            @Override
            public void caretPositionChanged(InputMethodEvent evt) {
            }

            @Override
            public void inputMethodTextChanged(InputMethodEvent evt) {
                NucleotideDomainDialog.this.jSpinnerRotationAngleInputMethodTextChanged(evt);
            }
        });
        this.jPanel3.add(this.jSpinnerRotationAngle);
        this.jLabel17.setFont(new Font("Arial", 1, 12));
        this.jLabel17.setHorizontalAlignment(4);
        this.jLabel17.setText("Shape Color");
        this.jPanel3.add(this.jLabel17);
        this.colorPanel.setBackground(Color.blue);
        this.colorPanel.setBorder(BorderFactory.createBevelBorder(0));
        this.colorPanel.setToolTipText("");
        this.colorPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                NucleotideDomainDialog.this.colorPanelMousePressed(evt);
            }
        });
        this.jPanel3.add(this.colorPanel);
        this.jCheckBoxDC.setFont(new Font("Arial", 1, 12));
        this.jCheckBoxDC.setSelected(true);
        this.jCheckBoxDC.setText("Default");
        this.jCheckBoxDC.setHorizontalAlignment(2);
        this.jCheckBoxDC.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NucleotideDomainDialog.this.jCheckBoxDCActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.jCheckBoxDC);
        this.jLabel16.setFont(new Font("Arial", 1, 12));
        this.jLabel16.setHorizontalTextPosition(2);
        this.jPanel3.add(this.jLabel16);
        this.jLabel18.setFont(new Font("Arial", 1, 12));
        this.jLabel18.setHorizontalAlignment(4);
        this.jLabel18.setText("Texture");
        this.jPanel3.add(this.jLabel18);
        this.jPanel3.add(this.texturechoose);
        this.jLabel13.setFont(new Font("Arial", 1, 12));
        this.jLabel13.setHorizontalAlignment(4);
        this.jLabel13.setText("Gradient");
        this.jPanel3.add(this.jLabel13);
        this.jPanel3.add(this.comBoxGradient);
        this.jPanel4.setBorder(BorderFactory.createTitledBorder(null, "Text", 0, 0, new Font("Arial", 1, 12)));
        this.jPanel4.setLayout(new GridLayout(2, 4, 10, 10));
        this.nameLabel.setFont(new Font("Arial", 1, 12));
        this.nameLabel.setHorizontalAlignment(4);
        this.nameLabel.setText("Name");
        this.jPanel4.add(this.nameLabel);
        this.nameTextField.setHorizontalAlignment(0);
        this.jPanel4.add(this.nameTextField);
        this.jLabel19.setFont(new Font("Arial", 1, 12));
        this.jLabel19.setHorizontalAlignment(4);
        this.jLabel19.setText("Location");
        this.jPanel4.add(this.jLabel19);
        this.nameComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Center", "Down", "Up", "Hide"}));
        this.nameComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                NucleotideDomainDialog.this.nameComboBoxItemStateChanged(evt);
            }
        });
        this.jPanel4.add(this.nameComboBox);
        this.fontLabel.setFont(new Font("Arial", 1, 12));
        this.fontLabel.setHorizontalAlignment(4);
        this.fontLabel.setText("Font Size");
        this.jPanel4.add(this.fontLabel);
        this.fontTextField.setHorizontalAlignment(0);
        this.fontTextField.setText("20");
        this.jPanel4.add(this.fontTextField);
        this.jLabel20.setFont(new Font("Arial", 1, 12));
        this.jLabel20.setHorizontalAlignment(4);
        this.jLabel20.setText("Text Color");
        this.jPanel4.add(this.jLabel20);
        this.colorText.setBackground(Color.black);
        this.colorText.setBorder(BorderFactory.createBevelBorder(0));
        this.colorText.setToolTipText("");
        this.colorText.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                NucleotideDomainDialog.this.colorTextMousePressed(evt);
            }
        });
        this.jPanel4.add(this.colorText);
        this.jPanel5.setBorder(BorderFactory.createTitledBorder(null, "Border", 0, 0, new Font("Arial", 1, 12)));
        this.jPanel5.setLayout(new GridLayout(2, 4, 10, 10));
        this.jLabel2.setFont(new Font("Arial", 1, 12));
        this.jLabel2.setHorizontalAlignment(4);
        this.jLabel2.setText("Line Size");
        this.jPanel5.add(this.jLabel2);
        this.jSpinnerStrokeSize.setModel(new SpinnerNumberModel(1, 1, 5, 1));
        this.jPanel5.add(this.jSpinnerStrokeSize);
        this.jCheckBoxBorderDash.setFont(new Font("Arial", 1, 12));
        this.jCheckBoxBorderDash.setText("Dash");
        this.jPanel5.add(this.jCheckBoxBorderDash);
        this.jLabel15.setFont(new Font("Arial", 1, 12));
        this.jLabel15.setHorizontalAlignment(0);
        this.jPanel5.add(this.jLabel15);
        this.jLabel21.setFont(new Font("Arial", 1, 12));
        this.jLabel21.setHorizontalAlignment(4);
        this.jLabel21.setText("Line Color");
        this.jPanel5.add(this.jLabel21);
        this.colorLine.setBackground(Color.black);
        this.colorLine.setBorder(BorderFactory.createBevelBorder(0));
        this.colorLine.setToolTipText("");
        this.colorLine.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                NucleotideDomainDialog.this.colorLineMousePressed(evt);
            }
        });
        this.jPanel5.add(this.colorLine);
        this.jPanel5.add(this.jLabel23);
        this.jPanel6.setBorder(BorderFactory.createTitledBorder(null, "", 0, 0, new Font("Arial", 1, 12)));
        this.jLabel22.setFont(new Font("\u5b8b\u4f53", 1, 12));
        this.jLabel22.setHorizontalAlignment(4);
        this.jLabel22.setText("ID");
        this.jLabel22.setPreferredSize(new Dimension(50, 15));
        this.jPanel6.add(this.jLabel22);
        this.jTextFieldID.setForeground(new Color(255, 255, 255));
        this.jTextFieldID.setPreferredSize(new Dimension(250, 25));
        this.jTextFieldID.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                NucleotideDomainDialog.this.jTextFieldIDFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                NucleotideDomainDialog.this.jTextFieldIDFocusLost(evt);
            }
        });
        this.jTextFieldID.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                NucleotideDomainDialog.this.jTextFieldIDKeyPressed(evt);
            }
        });
        this.jPanel6.add(this.jTextFieldID);
        GroupLayout mainPanelLayout = new GroupLayout(this.mainPanel);
        this.mainPanel.setLayout(mainPanelLayout);
        mainPanelLayout.setHorizontalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addContainerGap().addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel6, -1, 418, Short.MAX_VALUE).addComponent(this.jPanel2, -1, 418, Short.MAX_VALUE).addComponent(this.jPanel3, -2, 418, Short.MAX_VALUE).addComponent(this.jPanel4, -1, 418, Short.MAX_VALUE).addComponent(this.jPanel5, -1, 418, Short.MAX_VALUE)).addContainerGap()).addGroup(GroupLayout.Alignment.TRAILING, mainPanelLayout.createSequentialGroup().addComponent(this.cancelButton, -2, 89, -2).addGap(31, 31, 31).addComponent(this.okButton, -2, 89, -2).addGap(109, 109, 109)))));
        mainPanelLayout.setVerticalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, mainPanelLayout.createSequentialGroup().addComponent(this.jPanel6, -2, 36, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addGap(5, 5, 5).addComponent(this.jPanel3, -2, 151, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel4, -2, 85, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel5, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton, -2, 25, -2).addComponent(this.okButton, -2, 25, -2)).addGap(16, 16, 16)));
        this.getContentPane().add((java.awt.Component)this.mainPanel, "East");
        this.jPanel1.setPreferredSize(new Dimension(700, 30));
        this.jLabelTip.setHorizontalAlignment(0);
        this.jLabelTip.setPreferredSize(new Dimension(700, 20));
        this.jPanel1.add(this.jLabelTip);
        this.getContentPane().add((java.awt.Component)this.jPanel1, "Last");
        this.pack();
    }

    public void shapeChange() {
        if (this.shapeType == ShapeEnum.RoundRectangle) {
            if (this.jCheckBoxDC.isSelected()) {
                Color colorbk = new Color(106, 156, 77);
                this.colorPanel.setBackground(colorbk);
            }
            this.texturechoose.setEnabled(true);
            this.texturechoose.petList.setEnabled(true);
            this.jSpinnerRotationAngle.setEnabled(true);
            this.colorPanel.setEnabled(true);
        } else if (this.shapeType == ShapeEnum.Rectangle) {
            if (this.jCheckBoxDC.isSelected()) {
                Color colorbk = new Color(0, 107, 0);
                this.colorPanel.setBackground(colorbk);
            }
            this.texturechoose.setEnabled(true);
            this.texturechoose.petList.setEnabled(true);
            this.jSpinnerRotationAngle.setEnabled(true);
            this.colorPanel.setEnabled(true);
        } else if (this.shapeType == ShapeEnum.Circle) {
            if (this.jCheckBoxDC.isSelected()) {
                Color colorbk = new Color(239, 195, 38);
                this.colorPanel.setBackground(colorbk);
            }
            this.texturechoose.setEnabled(true);
            this.texturechoose.petList.setEnabled(true);
            this.jSpinnerRotationAngle.setEnabled(true);
            this.colorPanel.setEnabled(true);
        } else if (this.shapeType == ShapeEnum.Triangle) {
            if (this.jCheckBoxDC.isSelected()) {
                Color colorbk = new Color(46, 61, 208);
                this.colorPanel.setBackground(colorbk);
            }
            this.texturechoose.setEnabled(true);
            this.texturechoose.petList.setEnabled(true);
            this.jSpinnerRotationAngle.setEnabled(true);
            this.colorPanel.setEnabled(true);
        } else if (this.shapeType == ShapeEnum.Rhomboid) {
            if (this.jCheckBoxDC.isSelected()) {
                Color colorbk = new Color(188, 35, 157);
                this.colorPanel.setBackground(colorbk);
            }
            this.texturechoose.setEnabled(true);
            this.texturechoose.petList.setEnabled(true);
            this.jSpinnerRotationAngle.setEnabled(true);
            this.colorPanel.setEnabled(true);
        } else if (this.shapeType == ShapeEnum.Rhombus) {
            if (this.jCheckBoxDC.isSelected()) {
                Color colorbk = new Color(178, 141, 229);
                this.colorPanel.setBackground(colorbk);
            }
            this.texturechoose.setEnabled(true);
            this.texturechoose.petList.setEnabled(true);
            this.jSpinnerRotationAngle.setEnabled(true);
            this.colorPanel.setEnabled(true);
        } else if (this.shapeType == ShapeEnum.Pentagon) {
            if (this.jCheckBoxDC.isSelected()) {
                Color colorbk = new Color(188, 0, 0);
                this.colorPanel.setBackground(colorbk);
            }
            this.texturechoose.setEnabled(true);
            this.texturechoose.petList.setEnabled(true);
            this.jSpinnerRotationAngle.setEnabled(true);
            this.colorPanel.setEnabled(true);
        } else if (this.shapeType == ShapeEnum.Hexagon) {
            if (this.jCheckBoxDC.isSelected()) {
                Color colorbk = new Color(67, 137, 180);
                this.colorPanel.setBackground(colorbk);
            }
            this.texturechoose.setEnabled(true);
            this.texturechoose.petList.setEnabled(true);
            this.jSpinnerRotationAngle.setEnabled(true);
            this.colorPanel.setEnabled(true);
        } else if (this.shapeType == ShapeEnum.Octagon) {
            if (this.jCheckBoxDC.isSelected()) {
                Color colorbk = new Color(224, 64, 50);
                this.colorPanel.setBackground(colorbk);
            }
            this.texturechoose.setEnabled(true);
            this.texturechoose.petList.setEnabled(true);
            this.jSpinnerRotationAngle.setEnabled(true);
            this.colorPanel.setEnabled(true);
        } else if (this.shapeType == ShapeEnum.Trapezoid) {
            if (this.jCheckBoxDC.isSelected()) {
                Color colorbk = new Color(255, 51, 255);
                this.colorPanel.setBackground(colorbk);
            }
            this.texturechoose.setEnabled(true);
            this.texturechoose.petList.setEnabled(true);
            this.jSpinnerRotationAngle.setEnabled(true);
            this.colorPanel.setEnabled(true);
        } else if (this.shapeType == ShapeEnum.Arrow) {
            if (this.jCheckBoxDC.isSelected()) {
                Color colorbk = new Color(55, 80, 161);
                this.colorPanel.setBackground(colorbk);
            }
            this.texturechoose.setEnabled(true);
            this.texturechoose.petList.setEnabled(true);
            this.jSpinnerRotationAngle.setEnabled(true);
            this.colorPanel.setEnabled(true);
        } else if (this.shapeType == ShapeEnum.DovetailArrow) {
            if (this.jCheckBoxDC.isSelected()) {
                Color colorbk = new Color(138, 131, 191);
                this.colorPanel.setBackground(colorbk);
            }
        } else if (this.shapeType == ShapeEnum.Cylinder) {
            if (this.jCheckBoxDC.isSelected()) {
                Color colorbk = new Color(255, 51, 255);
                this.colorPanel.setBackground(colorbk);
            }
            this.texturechoose.setEnabled(true);
            this.texturechoose.petList.setEnabled(true);
            this.jSpinnerRotationAngle.setValue(0);
            this.jSpinnerRotationAngle.setEnabled(false);
            this.colorPanel.setEnabled(true);
        }
        this.previewDraw();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.bModify = true;
        boolean ibRadiusValiable = new Verifier().verify(this.jTextFieldradius);
        boolean isStartValiable = new Verifier().verify(this.startTextField);
        boolean isEndValiable = new Verifier().verify(this.endTextField);
        boolean isNameEmpty = new Verifier().isEmpty(this.nameTextField);
        boolean isGreat = new Verifier().isGreat(this.startTextField, this.endTextField);
        boolean isFontSizeValiable = new Verifier().verify(this.fontTextField);
        boolean isStrokeSizeValiable = true;
        String name = "";
        name = isNameEmpty ? " " : this.nameTextField.getText();
        StringBuffer errorSb = new StringBuffer();
        if (!isStartValiable) {
            errorSb.append("Start Position : should be a positive integer \n");
        }
        if (!isStrokeSizeValiable) {
            errorSb.append("Stroke Size : should be a positive integer \n");
        }
        if (!isEndValiable) {
            errorSb.append("End Position : should be a positive integer \n");
        }
        if (isStartValiable && isEndValiable && !isGreat) {
            errorSb.append("End Position should be greater than Start Position \n");
        }
        if (!isFontSizeValiable) {
            errorSb.append("Font Size : should be a positive integer \n");
        }
        if (!ibRadiusValiable) {
            errorSb.append("High : should be a positive integer \n");
        }
        if (isStartValiable && ibRadiusValiable && isEndValiable && isGreat && isFontSizeValiable) {
            int iStart = 0;
            int iEnd = 0;
            int iHigh = 0;
            iStart = Integer.parseInt(this.startTextField.getText().trim());
            iEnd = (int)Double.parseDouble(this.endTextField.getText().trim());
            iHigh = (int)Double.parseDouble(this.jTextFieldradius.getText().trim());
            if (this.comboBoxShape.SelectTextureFile.equals("00000_1.jpg")) {
                this.shapeType = ShapeEnum.Rectangle;
            } else {
                String strShape = this.comboBoxShape.SelectTextureFile;
                if (strShape.indexOf(".") > 0) {
                    strShape = strShape.substring(0, strShape.indexOf("."));
                }
                this.shapeType = ShapeEnum.valueOf(strShape);
            }
            if (this.comBoxGradient.SelectTextureFile.equals("00000_1.jpg")) {
                this.gradientType = GradientEnum.Null;
            } else {
                String strGradient = this.comBoxGradient.SelectTextureFile;
                if (strGradient.indexOf(".") > 0) {
                    strGradient = strGradient.substring(0, strGradient.indexOf("."));
                }
                this.gradientType = GradientEnum.valueOf(strGradient);
            }
            int strokesize = (Integer)this.jSpinnerStrokeSize.getValue();
            int iRotationAngle = (Integer)this.jSpinnerRotationAngle.getValue();
            String parameter = this.startComboBox.getSelectedItem() + this.DELIMIT + this.endComboBox.getSelectedItem() + this.DELIMIT + name + this.DELIMIT + this.nameComboBox.getSelectedItem() + this.DELIMIT + this.fontTextField.getText().trim() + this.DELIMIT + strokesize + this.DELIMIT + this.gradientType.name().toString() + this.DELIMIT + this.texturechoose.SelectTextureFile;
            String fid = "";
            fid = this.jTextFieldID.getText();
            this.component = new Component(ComponentEnum.Domain, (double)iStart, (double)iEnd, parameter, this.colorPanel.getBackground(), this.colorText.getBackground(), this.colorLine.getBackground(), this.shapeType, (double)iHigh, (double)iRotationAngle, false, false, this.jCheckBoxBorderDash.isSelected(), fid);
            this.component.setIsActive(true);
            this.component.setbSelected(true);
            this.dispose();
        } else {
            JOptionPane.showConfirmDialog(this, errorSb.toString(), "Properties Error", -1, 0, null);
        }
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void startComboBoxItemStateChanged(ItemEvent evt) {
        this.previewDraw();
    }

    private void endComboBoxItemStateChanged(ItemEvent evt) {
        this.previewDraw();
    }

    private void nameComboBoxItemStateChanged(ItemEvent evt) {
        this.previewDraw();
    }

    private void colorPanelMousePressed(MouseEvent evt) {
        if (!this.colorPanel.isEnabled()) {
            return;
        }
        final JColorChooser jColorChooser = new JColorChooser();
        jColorChooser.setColor(this.colorPanel.getBackground());
        Tools.WindowCenter(JColorChooser.createDialog(this, "Color Choose", true, jColorChooser, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color color = jColorChooser.getColor();
                NucleotideDomainDialog.this.colorPanel.setBackground(color);
                NucleotideDomainDialog.this.jCheckBoxDC.setSelected(false);
                NucleotideDomainDialog.this.previewDraw();
            }
        }, null));
    }

    private void jRadioButton3ActionPerformed(ActionEvent evt) {
    }

    private void endTextFieldInputMethodTextChanged(InputMethodEvent evt) {
        this.previewDraw();
    }

    private void jSpinnerRotationAngleInputMethodTextChanged(InputMethodEvent evt) {
        this.previewDraw();
    }

    private void jTextFieldradiusInputMethodTextChanged(InputMethodEvent evt) {
        this.previewDraw();
    }

    private void colorTextMousePressed(MouseEvent evt) {
        final JColorChooser jColorChooser = new JColorChooser();
        jColorChooser.setColor(this.colorText.getBackground());
        Tools.WindowCenter(JColorChooser.createDialog(this, "Color Choose", true, jColorChooser, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color color = jColorChooser.getColor();
                NucleotideDomainDialog.this.colorText.setBackground(color);
                NucleotideDomainDialog.this.previewDraw();
            }
        }, null));
    }

    private void colorLineMousePressed(MouseEvent evt) {
        final JColorChooser jColorChooser = new JColorChooser();
        jColorChooser.setColor(this.colorLine.getBackground());
        Tools.WindowCenter(JColorChooser.createDialog(this, "Color Choose", true, jColorChooser, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color color = jColorChooser.getColor();
                NucleotideDomainDialog.this.colorLine.setBackground(color);
                NucleotideDomainDialog.this.previewDraw();
            }
        }, null));
    }

    private void jCheckBoxDCActionPerformed(ActionEvent evt) {
        this.shapeChange();
    }

    private void jTextFieldIDKeyPressed(KeyEvent evt) {
    }

    private void jTextFieldIDFocusGained(FocusEvent evt) {
    }

    private void jTextFieldIDFocusLost(FocusEvent evt) {
    }
}

