/*
 * Decompiled with CFR 0.152.
 */
package gui.ibs;

import gui.ibs.Area;
import gui.ibs.Component;
import gui.ibs.ComponentEnum;
import gui.ibs.DomainDashConf;
import gui.ibs.DrawTypeEnum;
import gui.ibs.GradientEnum;
import gui.ibs.PolygonXY;
import gui.ibs.Protein;
import gui.ibs.ShapeEnum;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.MultipleGradientPaint;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.RadialGradientPaint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.QuadCurve2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.StringTokenizer;
import javax.imageio.ImageIO;
import javax.swing.JPanel;

public class PreviewPanel
extends JPanel {
    private int positionFontSize = 12;
    private float rate = 1.0f;
    private double DOMAIN_X = -100.0;
    private double DOMAIN_HEIGHT = 10.0;
    private double RATE = 1.0;
    private int fontsize = 10;
    private FontMetrics fontMetrics;
    private int lineHeight = 10;
    private String DELIMIT = "#&%";
    public static Protein protein;
    public int lineInterval = 5;
    public boolean bGray = false;
    private double HALF_HEIGHT;
    private double LENGTH_RATE = 1.0;
    public static String Mode;
    private FontMetrics positionFontMetrics;
    private int LINE_HEIGHT = 10;
    private final double HALF_LENGTH = 100.0;
    public Color proteincolor;

    public String getMode() {
        return Mode;
    }

    public void setMode(String Mode) {
        PreviewPanel.Mode = Mode;
    }

    public PreviewPanel() {
        this.initComponents();
    }

    public Color getGrayColor(Color origColor) {
        int iNewGray = 0;
        int iNewColor = 0;
        if (this.bGray) {
            iNewGray = (int)((double)origColor.getRed() * 0.3 + (double)origColor.getGreen() * 0.59 + (double)origColor.getBlue() * 0.11);
            iNewColor = (origColor.getAlpha() << 24) + (iNewGray << 16) + (iNewGray << 8) + iNewGray;
            Color newColor = new Color(iNewColor);
            return newColor;
        }
        return origColor;
    }

    private void drawProteinBorderDash(int vertical, int horizontal, int height, int[] pos, Map<Integer, DomainDashConf> ddcMap, Color colorline, int strokesize, boolean proteinbdash, String SelectTextureFile, Graphics2D g2d) {
        Stroke stroke = g2d.getStroke();
        Color colororig = g2d.getColor();
        g2d.setColor(colorline);
        vertical = -vertical;
        this.HALF_HEIGHT = (double)height / 2.0;
        this.positionFontMetrics = g2d.getFontMetrics();
        this.LINE_HEIGHT = this.positionFontMetrics.getHeight();
        if (ddcMap.size() > 0) {
            for (int i = 0; i < pos.length && i != pos.length - 1; ++i) {
                float[] dash1;
                double endXd;
                double endXu;
                double startXd;
                double startXu;
                DomainDashConf ddci = ddcMap.get(pos[i]);
                DomainDashConf ddcj = ddcMap.get(pos[i + 1]);
                if (ddci == null || ddcj == null) continue;
                if (ddci.dheight == 0.0 && ddci.dheight == 0.0) {
                    startXu = (this.DOMAIN_X + ddci.xCenterPosition) * (double)this.rate;
                    startXd = (this.DOMAIN_X + ddci.xCenterPosition) * (double)this.rate;
                } else {
                    startXu = ddci.Shape.equals("L_ParallelLine") || ddci.Shape.equals("L_ParallelCurve") ? (this.DOMAIN_X + (ddci.xCenterPosition - ddci.dwidth / 2.0)) * (double)this.rate : (this.DOMAIN_X + (ddci.xCenterPosition + ddci.dwidth / 2.0)) * (double)this.rate;
                    startXd = ddci.Shape.equals("L_ParallelLine") || ddci.Shape.equals("L_ParallelCurve") ? (this.DOMAIN_X + (ddci.xCenterPosition + ddci.dwidth / 2.0)) * (double)this.rate : (this.DOMAIN_X + (ddci.xCenterPosition - ddci.dwidth / 2.0)) * (double)this.rate;
                }
                if (ddcj.dheight == 0.0 && ddcj.dheight == 0.0) {
                    endXu = (this.DOMAIN_X + ddcj.xCenterPosition) * (double)this.rate;
                    endXd = (this.DOMAIN_X + ddcj.xCenterPosition) * (double)this.rate;
                } else {
                    endXu = ddcj.Shape.equals("L_ParallelLine") || ddcj.Shape.equals("L_ParallelCurve") ? (this.DOMAIN_X + (ddcj.xCenterPosition - ddcj.dwidth / 2.0)) * (double)this.rate : (this.DOMAIN_X + (ddcj.xCenterPosition + ddcj.dwidth / 2.0)) * (double)this.rate;
                    endXd = ddcj.Shape.equals("L_ParallelLine") || ddcj.Shape.equals("L_ParallelCurve") ? (this.DOMAIN_X + (ddcj.xCenterPosition + ddcj.dwidth / 2.0)) * (double)this.rate : (this.DOMAIN_X + (ddcj.xCenterPosition - ddcj.dwidth / 2.0)) * (double)this.rate;
                }
                double startY = 0.0;
                double endY = 0.0;
                if (Mode.equals("N")) {
                    startY = -1.0 * this.RATE;
                    endY = -1.0 * this.RATE + 3.0 * this.RATE;
                } else {
                    startY = -this.DOMAIN_HEIGHT / 2.0 * this.RATE;
                    endY = -this.DOMAIN_HEIGHT / 2.0 * this.RATE + this.DOMAIN_HEIGHT * this.RATE;
                }
                Line2D.Double upline = new Line2D.Double((int)Math.round(startXu), (int)Math.round(startY), (int)Math.round(endXu), (int)Math.round(startY));
                Line2D.Double downline = new Line2D.Double((int)Math.round(startXd), (int)Math.round(endY), (int)Math.round(endXd), (int)Math.round(endY));
                boolean isDash = false;
                isDash = ddci.bRDash || ddcj.bLDash;
                float thick = strokesize;
                if (SelectTextureFile.equals("00000_1.jpg")) {
                    if (ddcMap.size() > 2) {
                        if (isDash) {
                            dash1 = new float[]{5.0f};
                            g2d.setStroke(new BasicStroke(1.0f, 1, 1, 20.0f, dash1, 0.0f));
                        } else {
                            g2d.setStroke(new BasicStroke(1.0f, 1, 1));
                        }
                    } else if (proteinbdash) {
                        dash1 = new float[]{5.0f};
                        g2d.setStroke(new BasicStroke(1.0f, 1, 1, 20.0f, dash1, 0.0f));
                    } else {
                        g2d.setStroke(new BasicStroke(1.0f, 1, 1));
                    }
                } else if (ddcMap.size() > 2) {
                    if (isDash) {
                        dash1 = new float[]{5.0f};
                        g2d.setStroke(new BasicStroke(thick * this.rate, 1, 1, 20.0f, dash1, 0.0f));
                    } else {
                        g2d.setStroke(new BasicStroke(thick * this.rate, 1, 1));
                    }
                } else if (proteinbdash) {
                    dash1 = new float[]{5.0f};
                    g2d.setStroke(new BasicStroke(thick * this.rate, 1, 1, 20.0f, dash1, 0.0f));
                } else {
                    g2d.setStroke(new BasicStroke(thick * this.rate, 1, 1));
                }
                g2d.draw(upline);
                g2d.draw(downline);
                Line2D.Double leftline1 = new Line2D.Double((int)Math.round(startXu), (int)Math.round(startY), (int)Math.round(startXd), (int)Math.round(endY));
                Line2D.Double rightline1 = new Line2D.Double((int)Math.round(endXu), (int)Math.round(startY), (int)Math.round(endXd), (int)Math.round(endY));
                Line2D.Double rightline2 = new Line2D.Double((int)Math.round(endXu), (int)Math.round(startY), (int)Math.round(endXd), (int)Math.round(endY));
                if (i == 0) {
                    g2d.draw(leftline1);
                    if (pos.length != 2) continue;
                    g2d.draw(rightline1);
                    continue;
                }
                if (i != pos.length - 2) continue;
                g2d.draw(rightline2);
            }
        }
        g2d.setColor(colororig);
        g2d.setStroke(stroke);
    }

    private void drawComponent(Graphics2D g2d) {
        String SelectTextureFile;
        GradientEnum GradientType;
        StringTokenizer ster = new StringTokenizer(protein.getParameter(), this.DELIMIT);
        int proteinStart = Integer.parseInt(ster.nextToken());
        DrawTypeEnum proteinStartDrawType = DrawTypeEnum.valueOf(ster.nextToken());
        int proteinEnd = Integer.parseInt(ster.nextToken());
        DrawTypeEnum proteinEndDrawType = DrawTypeEnum.valueOf(ster.nextToken());
        int proteinHeight = Integer.parseInt(ster.nextToken());
        int fontSize = Integer.parseInt(ster.nextToken());
        int vertical = protein.getVertical();
        this.proteincolor = protein.getColor();
        int horizontal = protein.getHorizontal();
        if (ster.hasMoreTokens()) {
            GradientType = GradientEnum.valueOf(ster.nextToken());
            SelectTextureFile = ster.nextToken();
        } else {
            GradientType = GradientEnum.Horizontal;
            SelectTextureFile = "00000.jpg";
        }
        if (Mode.equals("P")) {
            this.drawProtein(vertical, horizontal, proteinStart, proteinStartDrawType, proteinEnd, proteinEndDrawType, proteinHeight, fontSize, this.getGrayColor(protein.getColor()), g2d, GradientType, SelectTextureFile);
        } else {
            proteinHeight = 12;
            this.drawProteinN(vertical, horizontal, proteinStart, proteinStartDrawType, proteinEnd, proteinEndDrawType, proteinHeight, fontSize, this.getGrayColor(protein.getColor()), g2d, GradientType, SelectTextureFile);
        }
        LinkedList<Component> componentList = protein.getComponentList();
        if (componentList.size() > 0) {
            for (Component component : componentList) {
                String[] arr;
                boolean rb;
                boolean lb;
                String SelectTextureFile1;
                GradientEnum GradientType1;
                int strokesize;
                int iRotationAngle;
                int iHigh;
                int size;
                DrawTypeEnum nameDrawType;
                String name;
                DrawTypeEnum endDrawType;
                DrawTypeEnum startDrawType;
                StringTokenizer st;
                if (component.getType() == ComponentEnum.Domain) {
                    if (Mode.equals("P")) {
                        st = new StringTokenizer(component.getParameter(), this.DELIMIT);
                        startDrawType = DrawTypeEnum.valueOf(st.nextToken());
                        endDrawType = DrawTypeEnum.valueOf(st.nextToken());
                        name = st.nextToken();
                        nameDrawType = DrawTypeEnum.valueOf(st.nextToken());
                        size = Integer.parseInt(st.nextToken());
                        iHigh = (int)component.getHigh();
                        iRotationAngle = (int)component.getRotationAngle();
                        strokesize = Integer.valueOf(st.nextToken());
                        if (st.hasMoreTokens()) {
                            GradientType1 = GradientEnum.valueOf(st.nextToken());
                            SelectTextureFile1 = st.nextToken();
                        } else {
                            GradientType1 = GradientEnum.Horizontal;
                            SelectTextureFile1 = "00000.jpg";
                        }
                        lb = false;
                        rb = false;
                        lb = component.bProteinLDash;
                        rb = component.bProteinRDash;
                        this.drawDomain(vertical, horizontal, (int)component.getX(), startDrawType, (int)component.getX2(), endDrawType, name, nameDrawType, size, this.getGrayColor(component.getColor()), g2d, component.shapeType, component.isActive(), iRotationAngle, iHigh, strokesize, GradientType1, SelectTextureFile1, proteinHeight, lb, rb);
                    } else {
                        st = new StringTokenizer(component.getParameter(), this.DELIMIT);
                        DrawTypeEnum startDrawType2 = DrawTypeEnum.valueOf(st.nextToken());
                        DrawTypeEnum endDrawType2 = DrawTypeEnum.valueOf(st.nextToken());
                        String name2 = st.nextToken();
                        DrawTypeEnum nameDrawType2 = DrawTypeEnum.valueOf(st.nextToken());
                        int size2 = Integer.parseInt(st.nextToken());
                        int iHigh2 = (int)component.getHigh();
                        iRotationAngle = (int)component.getRotationAngle();
                        int strokesize2 = Integer.valueOf(st.nextToken());
                        if (st.hasMoreTokens()) {
                            GradientType1 = GradientEnum.valueOf(st.nextToken());
                            SelectTextureFile1 = st.nextToken();
                        } else {
                            GradientType1 = GradientEnum.Horizontal;
                            SelectTextureFile1 = "00000.jpg";
                        }
                        this.drawDomainN(vertical, horizontal, (int)component.getX(), startDrawType2, (int)component.getX2(), endDrawType2, name2, nameDrawType2, size2, this.getGrayColor(component.getColor()), g2d, component.shapeType, component.isActive(), iRotationAngle, iHigh2, strokesize2, GradientType1, SelectTextureFile1);
                    }
                }
                if (component.getType() == ComponentEnum.CutLine) {
                    if (Mode.equals("P")) {
                        st = new StringTokenizer(component.getParameter(), this.DELIMIT);
                        startDrawType = DrawTypeEnum.valueOf(st.nextToken());
                        endDrawType = DrawTypeEnum.valueOf(st.nextToken());
                        name = st.nextToken();
                        nameDrawType = DrawTypeEnum.valueOf(st.nextToken());
                        size = Integer.parseInt(st.nextToken());
                        iHigh = (int)component.getHigh();
                        iRotationAngle = (int)component.getRotationAngle();
                        strokesize = Integer.valueOf(st.nextToken());
                        if (st.hasMoreTokens()) {
                            GradientType1 = GradientEnum.valueOf(st.nextToken());
                            SelectTextureFile1 = st.nextToken();
                        } else {
                            GradientType1 = GradientEnum.Horizontal;
                            SelectTextureFile1 = "00000.jpg";
                        }
                        lb = false;
                        rb = false;
                        lb = component.bProteinLDash;
                        rb = component.bProteinRDash;
                        this.drawCutLine(vertical, horizontal, (int)component.getX(), startDrawType, (int)component.getX2(), endDrawType, name, nameDrawType, size, this.getGrayColor(component.getColor()), g2d, component.shapeType, component.isActive(), iRotationAngle, iHigh, strokesize, GradientType1, SelectTextureFile1, proteinHeight, lb, rb);
                        continue;
                    }
                    st = new StringTokenizer(component.getParameter(), this.DELIMIT);
                    startDrawType = DrawTypeEnum.valueOf(st.nextToken());
                    endDrawType = DrawTypeEnum.valueOf(st.nextToken());
                    name = st.nextToken();
                    nameDrawType = DrawTypeEnum.valueOf(st.nextToken());
                    size = Integer.parseInt(st.nextToken());
                    iHigh = (int)component.getHigh();
                    iRotationAngle = (int)component.getRotationAngle();
                    strokesize = Integer.valueOf(st.nextToken());
                    if (st.hasMoreTokens()) {
                        GradientType1 = GradientEnum.valueOf(st.nextToken());
                        SelectTextureFile1 = st.nextToken();
                    } else {
                        GradientType1 = GradientEnum.Horizontal;
                        SelectTextureFile1 = "00000.jpg";
                    }
                    this.drawCutLineN(vertical, horizontal, (int)component.getX(), startDrawType, (int)component.getX2(), endDrawType, name, nameDrawType, size, this.getGrayColor(component.getColor()), g2d, component.shapeType, component.isActive(), iRotationAngle, iHigh, strokesize, GradientType1, SelectTextureFile1);
                    continue;
                }
                if (component.getType() == ComponentEnum.Site) {
                    st = new StringTokenizer(component.getParameter(), this.DELIMIT);
                    String site = st.nextToken();
                    String text = st.nextToken();
                    int deltaX = (int)component.getX();
                    int deltaY = component.getY();
                    size = Integer.parseInt(st.nextToken());
                    boolean isShowPosition = Boolean.valueOf(st.nextToken());
                    int strokesize3 = Integer.valueOf(st.nextToken());
                    GradientEnum gradient = GradientEnum.valueOf(st.nextToken());
                    String SelectTextureFile12 = st.nextToken();
                    this.drawSite(site, isShowPosition, component.getColor(), SelectTextureFile12, gradient, component.shapeType, component.getColorText(), component.getColorline(), g2d);
                    continue;
                }
                if (component.getType() == ComponentEnum.Note) {
                    st = new StringTokenizer(component.getParameter(), this.DELIMIT);
                    String title = st.nextToken();
                    int size3 = Integer.parseInt(st.nextToken());
                    DrawTypeEnum style = DrawTypeEnum.valueOf(st.nextToken());
                    String angle = st.nextToken();
                    this.drawNote(style, angle, component.getColor(), g2d);
                    continue;
                }
                if (component.getType() == ComponentEnum.Line) {
                    DrawTypeEnum style = DrawTypeEnum.valueOf(component.getParameter());
                    this.drawLine(style, component.getColor(), g2d, component.shapeType);
                    continue;
                }
                if (component.getType() == ComponentEnum.Bracket) {
                    arr = component.getParameter().split(this.DELIMIT);
                    int strokesize4 = Integer.valueOf(arr[0]);
                    this.drawBracket(vertical, horizontal, (int)component.getCenterx(), (int)component.getCentery(), (int)component.getWide(), (int)component.getRotationAngle(), this.getGrayColor(component.getColor()), g2d, component.shapeType, component.isActive(), strokesize4);
                    continue;
                }
                if (component.getType() != ComponentEnum.Polygon) continue;
                arr = component.getParameter().split(this.DELIMIT);
                String name3 = arr[0];
                int size4 = Integer.parseInt(arr[2]);
                DrawTypeEnum nameDrawType3 = DrawTypeEnum.valueOf(arr[1]);
                int strokesize5 = Integer.valueOf(arr[3]);
                GradientEnum GradientType12 = GradientEnum.valueOf(arr[4]);
                String SelectTextureFile13 = arr[5];
                this.drawPolygon(vertical, horizontal, (int)component.getCenterx(), (int)component.getCentery(), (int)component.wide, (int)component.high, (int)component.getRotationAngle(), name3, nameDrawType3, size4, this.getGrayColor(component.getColor()), g2d, component.shapeType, component.isActive(), strokesize5, GradientType12, SelectTextureFile13);
            }
        }
    }

    private Area drawProteinN(int vertical, int horizontal, int start, DrawTypeEnum startDrawType, int end, DrawTypeEnum endDrawType, int height, int size, Color color, Graphics2D g2d, GradientEnum GradientType, String SelectTextureFile) {
        Line2D.Double endline;
        Line2D.Double startline;
        start = 1;
        end = 200;
        g2d.setFont(new Font("Arial", 1, this.fontsize));
        this.fontMetrics = g2d.getFontMetrics();
        double startX = (this.DOMAIN_X + (double)start) * this.RATE;
        double startY = -6.0 * this.RATE;
        double endX = (this.DOMAIN_X + (double)start) * this.RATE + (double)(end - start) * this.RATE;
        double endY = 6.0 * this.RATE;
        this.HALF_HEIGHT = 6.0;
        Stroke stroke = g2d.getStroke();
        PolygonXY pgxy = new PolygonXY();
        pgxy.getPolygonXY(startX, startY, endX, endY, "Rectangle", 0.0, this.rate);
        pgxy.CacuMinMaxXY();
        color = Color.GRAY;
        Color colorbk = new Color(0, 0, 0);
        this.drawPolygonTextureRect(g2d, startX, startY, endX, endY, pgxy, SelectTextureFile, stroke, color, colorbk, GradientType, ShapeEnum.Rectangle, 1, false, 20.0);
        if (startDrawType == DrawTypeEnum.Down) {
            startline = new Line2D.Double((this.DOMAIN_X + (double)start) * this.RATE, 1.0 * this.RATE, (this.DOMAIN_X + (double)start) * this.RATE, (double)(1 + this.lineHeight) * this.RATE);
            g2d.draw(startline);
            g2d.drawString(String.valueOf(start), (float)((this.DOMAIN_X + (double)start) * this.RATE - (double)this.fontMetrics.stringWidth(String.valueOf(start)) / 2.0), (float)((double)(1 + this.lineHeight) * this.RATE + 4.0 + (double)this.fontMetrics.getHeight() / 2.0));
        } else if (startDrawType == DrawTypeEnum.Up) {
            startline = new Line2D.Double((this.DOMAIN_X + (double)start) * this.RATE, -1.0 * this.RATE, (this.DOMAIN_X + (double)start) * this.RATE, (double)(-(1 + this.lineHeight)) * this.RATE);
            g2d.draw(startline);
            g2d.drawString(String.valueOf(start), (float)((this.DOMAIN_X + (double)start) * this.RATE - (double)this.fontMetrics.stringWidth(String.valueOf(start)) / 2.0), (float)((double)(-1 - this.lineHeight) * this.RATE - 2.0));
        } else if (startDrawType == DrawTypeEnum.Hide) {
            // empty if block
        }
        if (endDrawType == DrawTypeEnum.Down) {
            endline = new Line2D.Double((this.DOMAIN_X + (double)end) * this.RATE, 1.0 * this.RATE, (this.DOMAIN_X + (double)end) * this.RATE, (double)(1 + this.lineHeight) * this.RATE);
            g2d.draw(endline);
            g2d.drawString(String.valueOf(end), (float)((this.DOMAIN_X + (double)end) * this.RATE - (double)this.fontMetrics.stringWidth(String.valueOf(end)) / 2.0), (float)((double)(1 + this.lineHeight) * this.RATE + 4.0 + (double)this.fontMetrics.getHeight() / 2.0));
        } else if (endDrawType == DrawTypeEnum.Up) {
            endline = new Line2D.Double((this.DOMAIN_X + (double)end) * this.RATE, -1.0 * this.RATE, (this.DOMAIN_X + (double)end) * this.RATE, (double)(-(1 + this.lineHeight)) * this.RATE);
            g2d.draw(endline);
            g2d.drawString(String.valueOf(end), (float)((this.DOMAIN_X + (double)end) * this.RATE - (double)this.fontMetrics.stringWidth(String.valueOf(end)) / 2.0), (float)((double)(-1 - this.lineHeight) * this.RATE - 2.0));
        } else if (endDrawType == DrawTypeEnum.Hide) {
            // empty if block
        }
        return new Area(startX * (double)this.rate, ((double)vertical - this.HALF_HEIGHT) * (double)this.rate - 10.0, endX * (double)this.rate, ((double)vertical + this.HALF_HEIGHT) * (double)this.rate + 10.0);
    }

    private Area drawProtein(int vertical, int horizontal, int start, DrawTypeEnum startDrawType, int end, DrawTypeEnum endDrawType, int height, int size, Color color, Graphics2D g2d, GradientEnum GradientType, String SelectTextureFile) {
        Line2D.Double endline;
        Line2D.Double startline;
        color = Color.BLACK;
        this.HALF_HEIGHT = height / 2;
        start = 1;
        end = 200;
        double lineHeight = 4.0;
        g2d.setFont(new Font("Arial", 1, this.fontsize));
        this.fontMetrics = g2d.getFontMetrics();
        double startX = (this.DOMAIN_X + (double)start) * this.RATE;
        double startY = -this.DOMAIN_HEIGHT / 2.0 * this.RATE;
        double endX = (this.DOMAIN_X + (double)start) * this.RATE + (double)(end - start) * this.RATE;
        double endY = -this.DOMAIN_HEIGHT / 2.0 * this.RATE + this.DOMAIN_HEIGHT * this.RATE;
        Stroke stroke = g2d.getStroke();
        PolygonXY pgxy = new PolygonXY();
        pgxy.getPolygonXY(startX, startY, endX, endY, "Rectangle", 0.0, this.rate);
        pgxy.CacuMinMaxXY();
        color = Color.GRAY;
        Color colorbk = new Color(0, 0, 0);
        this.drawPolygonTextureRect(g2d, startX, startY, endX, endY, pgxy, SelectTextureFile, stroke, color, colorbk, GradientType, ShapeEnum.Rectangle, 1, false, 20.0);
        if (startDrawType == DrawTypeEnum.Down) {
            startline = new Line2D.Double((this.DOMAIN_X + (double)start) * this.RATE, this.DOMAIN_HEIGHT / 2.0 * this.RATE, (this.DOMAIN_X + (double)start) * this.RATE, (this.DOMAIN_HEIGHT / 2.0 + lineHeight) * this.RATE);
            g2d.draw(startline);
            g2d.drawString(String.valueOf(start), (float)((this.DOMAIN_X + (double)start) * this.RATE - (double)this.fontMetrics.stringWidth(String.valueOf(start)) / 2.0), (float)((this.DOMAIN_HEIGHT / 2.0 + lineHeight) * this.RATE + 4.0 + (double)this.fontMetrics.getHeight() / 2.0));
        } else if (startDrawType == DrawTypeEnum.Up) {
            startline = new Line2D.Double((this.DOMAIN_X + (double)start) * this.RATE, -this.DOMAIN_HEIGHT / 2.0 * this.RATE, (this.DOMAIN_X + (double)start) * this.RATE, -(this.DOMAIN_HEIGHT / 2.0 + lineHeight) * this.RATE);
            g2d.draw(startline);
            g2d.drawString(String.valueOf(start), (float)((this.DOMAIN_X + (double)start) * this.RATE - (double)this.fontMetrics.stringWidth(String.valueOf(start)) / 2.0), (float)((-this.DOMAIN_HEIGHT / 2.0 - lineHeight) * this.RATE - 2.0));
        } else if (startDrawType == DrawTypeEnum.Hide) {
            // empty if block
        }
        if (endDrawType == DrawTypeEnum.Down) {
            endline = new Line2D.Double((this.DOMAIN_X + (double)end) * this.RATE, this.DOMAIN_HEIGHT / 2.0 * this.RATE, (this.DOMAIN_X + (double)end) * this.RATE, (this.DOMAIN_HEIGHT / 2.0 + lineHeight) * this.RATE);
            g2d.draw(endline);
            g2d.drawString(String.valueOf(end), (float)((this.DOMAIN_X + (double)end) * this.RATE - (double)this.fontMetrics.stringWidth(String.valueOf(end)) / 2.0), (float)((this.DOMAIN_HEIGHT / 2.0 + lineHeight) * this.RATE + 4.0 + (double)this.fontMetrics.getHeight() / 2.0));
        } else if (endDrawType == DrawTypeEnum.Up) {
            endline = new Line2D.Double((this.DOMAIN_X + (double)end) * this.RATE, -this.DOMAIN_HEIGHT / 2.0 * this.RATE, (this.DOMAIN_X + (double)end) * this.RATE, -(this.DOMAIN_HEIGHT / 2.0 + lineHeight) * this.RATE);
            g2d.draw(endline);
            g2d.drawString(String.valueOf(end), (float)((this.DOMAIN_X + (double)end) * this.RATE - (double)this.fontMetrics.stringWidth(String.valueOf(end)) / 2.0), (float)((-this.DOMAIN_HEIGHT / 2.0 - lineHeight) * this.RATE - 2.0));
        } else if (endDrawType == DrawTypeEnum.Hide) {
            // empty if block
        }
        return new Area(startX * (double)this.rate, ((double)vertical - this.HALF_HEIGHT) * (double)this.rate - 10.0, endX * (double)this.rate, ((double)vertical + this.HALF_HEIGHT) * (double)this.rate + 10.0);
    }

    private Area drawDomain(int vertical, int horizontal, int start, DrawTypeEnum startDrawType, int end, DrawTypeEnum endDrawType, String name, DrawTypeEnum nameDrawType, int size, Color color, Graphics2D g2d, ShapeEnum shapeType, boolean isActive, int iRotationAngle, int iHigh, int strokesize, GradientEnum GradientType, String SelectTextureFile, int proteinHeight, boolean lb, boolean rb) {
        Line2D.Double endline;
        Line2D.Double startline;
        double endY;
        double startY;
        int iVhigh;
        start = 0;
        if (shapeType == ShapeEnum.L_ParallelCurve || shapeType == ShapeEnum.R_ParallelCurve || shapeType == ShapeEnum.L_ParallelLine || shapeType == ShapeEnum.R_ParallelLine) {
            iHigh = 5;
            end = 5;
        } else {
            iHigh = 0;
            end = 10;
        }
        Stroke stroke = g2d.getStroke();
        vertical = 0;
        double startX = 0.0;
        double endX = 0.0;
        double centerX = 0.0;
        startX = (float)start * this.rate;
        endX = (float)start * this.rate + (float)(end - start) * this.rate * 4.0f;
        centerX = startX + (endX - startX) / 2.0;
        if (iHigh == 0) {
            iVhigh = (int)((double)(this.lineHeight * 2) * this.LENGTH_RATE);
            startY = (double)(-iVhigh) * this.RATE / 4.0;
            endY = (double)iVhigh * this.RATE / 4.0;
        } else {
            iVhigh = (int)((double)(iHigh * 2) * this.LENGTH_RATE) * 4;
            startY = (double)(-iVhigh) * this.RATE / 4.0;
            endY = (double)iVhigh * this.RATE / 4.0;
        }
        PolygonXY pgxy = new PolygonXY();
        pgxy.getPolygonXY(startX, startY, endX, endY, shapeType.name().toString(), iRotationAngle, this.rate);
        pgxy.CacuMinMaxXY();
        Color colorbk = new Color(0, 0, 0);
        this.drawPolygonTextureRect(g2d, startX, startY, endX, endY, pgxy, SelectTextureFile, stroke, color, colorbk, GradientType, shapeType, strokesize, isActive, iHigh);
        if (startDrawType == DrawTypeEnum.Down) {
            startline = new Line2D.Double(Math.round(pgxy.minx), (float)vertical * this.rate, Math.round(pgxy.minx), (float)vertical * this.rate + (float)this.lineHeight);
            g2d.draw(startline);
            g2d.drawString(String.valueOf(100), (float)((double)pgxy.minx - (double)g2d.getFontMetrics().stringWidth(String.valueOf(60)) / 2.0), (float)vertical * this.rate + (float)this.lineHeight + (float)g2d.getFontMetrics().getAscent());
        } else if (startDrawType == DrawTypeEnum.Up) {
            startline = new Line2D.Double(Math.round(pgxy.minx), (float)vertical * this.rate, Math.round(pgxy.minx), (float)vertical * this.rate - (float)this.lineHeight);
            g2d.draw(startline);
            g2d.drawString(String.valueOf(100), (float)((double)pgxy.minx - (double)g2d.getFontMetrics().stringWidth(String.valueOf(60)) / 2.0), (float)vertical * this.rate - (float)this.lineHeight - (float)g2d.getFontMetrics().getDescent());
        } else if (startDrawType == DrawTypeEnum.Hide) {
            // empty if block
        }
        if (endDrawType == DrawTypeEnum.Down) {
            endline = new Line2D.Double(Math.round(pgxy.maxx), (float)vertical * this.rate, Math.round(pgxy.maxx), (float)vertical * this.rate + (float)this.lineHeight);
            g2d.draw(endline);
            g2d.drawString(String.valueOf(140), (float)((double)pgxy.maxx - (double)g2d.getFontMetrics().stringWidth(String.valueOf(80)) / 2.0), (float)vertical * this.rate + (float)this.lineHeight + (float)g2d.getFontMetrics().getAscent());
        } else if (endDrawType == DrawTypeEnum.Up) {
            endline = new Line2D.Double(Math.round(pgxy.maxx), (float)vertical * this.rate, Math.round(pgxy.maxx), (float)vertical * this.rate - (float)this.lineHeight);
            g2d.draw(endline);
            g2d.drawString(String.valueOf(140), (float)((double)pgxy.maxx - (double)g2d.getFontMetrics().stringWidth(String.valueOf(80)) / 2.0), (float)vertical * this.rate - (float)this.lineHeight - (float)g2d.getFontMetrics().getDescent());
        } else if (endDrawType == DrawTypeEnum.Hide) {
            // empty if block
        }
        if (nameDrawType == DrawTypeEnum.Up) {
            g2d.drawString(name, (float)(centerX * (double)this.rate - (double)g2d.getFontMetrics().stringWidth(name) / 2.0), (float)(((double)vertical - this.HALF_HEIGHT) * (double)this.rate - (double)g2d.getFontMetrics().getLeading() - (double)g2d.getFontMetrics().getDescent()));
        } else if (nameDrawType == DrawTypeEnum.Center) {
            g2d.drawString(name, (float)(centerX * (double)this.rate - (double)g2d.getFontMetrics().stringWidth(name) / 2.0), (float)((double)((float)vertical * this.rate) + (double)g2d.getFontMetrics().getHeight() / 3.0));
        } else if (nameDrawType == DrawTypeEnum.Down) {
            g2d.drawString(name, (float)(centerX * (double)this.rate - (double)g2d.getFontMetrics().stringWidth(name) / 2.0), (float)(((double)vertical + this.HALF_HEIGHT) * (double)this.rate) + (float)g2d.getFontMetrics().getLeading() + (float)g2d.getFontMetrics().getAscent());
        } else if (nameDrawType == DrawTypeEnum.Hide) {
            // empty if block
        }
        g2d.setFont(new Font("Arial", 1, this.positionFontSize));
        float[] dash1 = new float[]{5.0f};
        g2d.setStroke(new BasicStroke(2.0f, 1, 1, 20.0f, dash1, 0.0f));
        double startxu = 0.0;
        double startyu = 0.0;
        double endxd = 0.0;
        double endyd = 0.0;
        double startxd = 0.0;
        double startyd = 0.0;
        double endxu = 0.0;
        double endyu = 0.0;
        proteinHeight = (int)this.DOMAIN_HEIGHT;
        g2d.setColor(Color.RED);
        start = 0;
        if (lb) {
            if (shapeType == ShapeEnum.L_ParallelCurve || shapeType == ShapeEnum.L_ParallelLine) {
                startxu = (this.DOMAIN_X + (double)start) * this.RATE;
                startxd = (this.DOMAIN_X + (double)start) * this.RATE;
                startyu = -this.DOMAIN_HEIGHT / 2.0 * this.RATE;
                startyd = -this.DOMAIN_HEIGHT / 2.0 * this.RATE + this.DOMAIN_HEIGHT * this.RATE;
                endxu = pgxy.x[3];
                endxd = pgxy.x[1];
                endyu = -this.DOMAIN_HEIGHT / 2.0 * this.RATE;
                endyd = -this.DOMAIN_HEIGHT / 2.0 * this.RATE + this.DOMAIN_HEIGHT * this.RATE;
            } else {
                startxu = (this.DOMAIN_X + (double)start) * this.RATE;
                startxd = (this.DOMAIN_X + (double)start) * this.RATE;
                startyu = -this.DOMAIN_HEIGHT / 2.0 * this.RATE;
                startyd = -this.DOMAIN_HEIGHT / 2.0 * this.RATE + this.DOMAIN_HEIGHT * this.RATE;
                endxu = pgxy.x[2];
                endxd = pgxy.x[0];
                endyu = -this.DOMAIN_HEIGHT / 2.0 * this.RATE;
                endyd = -this.DOMAIN_HEIGHT / 2.0 * this.RATE + this.DOMAIN_HEIGHT * this.RATE;
            }
            Line2D.Double leftline1 = new Line2D.Double((int)Math.round(startxu), (int)Math.round(startyu), (int)Math.round(startxd), (int)Math.round(endyd));
            g2d.draw(leftline1);
        } else if (rb) {
            if (shapeType == ShapeEnum.L_ParallelCurve || shapeType == ShapeEnum.L_ParallelLine) {
                startxu = pgxy.x[2];
                startxd = pgxy.x[0];
                startyu = -this.DOMAIN_HEIGHT / 2.0 * this.RATE;
                startyd = -this.DOMAIN_HEIGHT / 2.0 * this.RATE + this.DOMAIN_HEIGHT * this.RATE;
                endxu = 100.0;
                endxd = 100.0;
                endyu = -this.DOMAIN_HEIGHT / 2.0 * this.RATE;
                endyd = -this.DOMAIN_HEIGHT / 2.0 * this.RATE + this.DOMAIN_HEIGHT * this.RATE;
            } else {
                startxu = pgxy.x[3];
                startxd = pgxy.x[1];
                startyu = -this.DOMAIN_HEIGHT / 2.0 * this.RATE;
                startyd = -this.DOMAIN_HEIGHT / 2.0 * this.RATE + this.DOMAIN_HEIGHT * this.RATE;
                endxu = 100.0;
                endxd = 100.0;
                endyu = -this.DOMAIN_HEIGHT / 2.0 * this.RATE;
                endyd = -this.DOMAIN_HEIGHT / 2.0 * this.RATE + this.DOMAIN_HEIGHT * this.RATE;
            }
            Line2D.Double rightline1 = new Line2D.Double(100.0, (int)Math.round(startyu), 100.0, (int)Math.round(endyd));
            g2d.draw(rightline1);
        }
        Line2D.Double upline = new Line2D.Double((int)Math.round(startxu), (int)Math.round(startyu), (int)Math.round(endxu), (int)Math.round(endyu));
        Line2D.Double downline = new Line2D.Double((int)Math.round(startxd), (int)Math.round(startyd), (int)Math.round(endxd), (int)Math.round(endyd));
        g2d.draw(upline);
        g2d.draw(downline);
        return new Area(startX * (double)this.rate, ((double)vertical - this.HALF_HEIGHT) * (double)this.rate - 10.0, endX * (double)this.rate, ((double)vertical + this.HALF_HEIGHT) * (double)this.rate + 10.0);
    }

    private Area drawDomainN(int vertical, int horizontal, int start, DrawTypeEnum startDrawType, int end, DrawTypeEnum endDrawType, String name, DrawTypeEnum nameDrawType, int size, Color color, Graphics2D g2d, ShapeEnum shapeType, boolean isActive, int iRotationAngle, int iHigh, int strokesize, GradientEnum GradientType, String SelectTextureFile) {
        Line2D.Double endline;
        Line2D.Double startline;
        start = 0;
        if (shapeType == ShapeEnum.L_ParallelCurve || shapeType == ShapeEnum.R_ParallelCurve || shapeType == ShapeEnum.L_ParallelLine || shapeType == ShapeEnum.R_ParallelLine) {
            iHigh = 5;
            end = 5;
        } else {
            iHigh = 10;
            end = 10;
        }
        Stroke stroke = g2d.getStroke();
        vertical = 0;
        double startX = 0.0;
        double endX = 0.0;
        double centerX = 0.0;
        startX = (float)start * this.rate;
        endX = (float)start * this.rate + (float)(end - start) * this.rate * 4.0f;
        centerX = startX + (endX - startX) / 2.0;
        int iVhigh = (int)((double)(iHigh * 2) * this.LENGTH_RATE) * 4;
        double startY = (double)(-iVhigh) * this.RATE / 4.0;
        double endY = (double)iVhigh * this.RATE / 4.0;
        PolygonXY pgxy = new PolygonXY();
        pgxy.getPolygonXY(startX, startY, endX, endY, shapeType.name().toString(), iRotationAngle, this.rate);
        pgxy.CacuMinMaxXY();
        Color colorbk = new Color(0, 0, 0);
        this.drawPolygonTextureRect(g2d, startX, startY, endX, endY, pgxy, SelectTextureFile, stroke, color, colorbk, GradientType, shapeType, strokesize, isActive, iHigh);
        g2d.setFont(new Font("Arial", 1, 12));
        if (startDrawType == DrawTypeEnum.Down) {
            startline = new Line2D.Double(Math.round(pgxy.minx), (float)vertical * this.rate, Math.round(pgxy.minx), (float)vertical * this.rate + (float)this.lineHeight);
            g2d.draw(startline);
            g2d.drawString(String.valueOf(60), (float)((double)pgxy.minx - (double)g2d.getFontMetrics().stringWidth(String.valueOf(60)) / 2.0), (float)vertical * this.rate + (float)this.lineHeight + (float)g2d.getFontMetrics().getAscent());
        } else if (startDrawType == DrawTypeEnum.Up) {
            startline = new Line2D.Double(Math.round(pgxy.minx), (float)vertical * this.rate, Math.round(pgxy.minx), (float)vertical * this.rate - (float)this.lineHeight);
            g2d.draw(startline);
            g2d.drawString(String.valueOf(60), (float)((double)pgxy.minx - (double)g2d.getFontMetrics().stringWidth(String.valueOf(60)) / 2.0), (float)vertical * this.rate - (float)this.lineHeight - (float)g2d.getFontMetrics().getDescent());
        } else if (startDrawType == DrawTypeEnum.Hide) {
            // empty if block
        }
        if (endDrawType == DrawTypeEnum.Down) {
            endline = new Line2D.Double(Math.round(pgxy.maxx), (float)vertical * this.rate, Math.round(pgxy.maxx), (float)vertical * this.rate + (float)this.lineHeight);
            g2d.draw(endline);
            g2d.drawString(String.valueOf(80), (float)((double)pgxy.maxx - (double)g2d.getFontMetrics().stringWidth(String.valueOf(80)) / 2.0), (float)vertical * this.rate + (float)this.lineHeight + (float)g2d.getFontMetrics().getAscent());
        } else if (endDrawType == DrawTypeEnum.Up) {
            endline = new Line2D.Double(Math.round(pgxy.maxx), (float)vertical * this.rate, Math.round(pgxy.maxx), (float)vertical * this.rate - (float)this.lineHeight);
            g2d.draw(endline);
            g2d.drawString(String.valueOf(80), (float)((double)pgxy.maxx - (double)g2d.getFontMetrics().stringWidth(String.valueOf(80)) / 2.0), (float)vertical * this.rate - (float)this.lineHeight - (float)g2d.getFontMetrics().getDescent());
        } else if (endDrawType == DrawTypeEnum.Hide) {
            // empty if block
        }
        if (nameDrawType == DrawTypeEnum.Up) {
            g2d.drawString(name, (float)(centerX * (double)this.rate - (double)g2d.getFontMetrics().stringWidth(name) / 2.0), (float)(((double)vertical - this.HALF_HEIGHT) * (double)this.rate - 20.0 - (double)g2d.getFontMetrics().getLeading() - (double)g2d.getFontMetrics().getDescent()));
        } else if (nameDrawType == DrawTypeEnum.Center) {
            g2d.drawString(name, (float)(centerX * (double)this.rate - (double)g2d.getFontMetrics().stringWidth(name) / 2.0), (float)((double)((float)vertical * this.rate) + (double)g2d.getFontMetrics().getHeight() / 3.0));
        } else if (nameDrawType == DrawTypeEnum.Down) {
            g2d.drawString(name, (float)(centerX * (double)this.rate - (double)g2d.getFontMetrics().stringWidth(name) / 2.0), (float)(((double)vertical + this.HALF_HEIGHT) * (double)this.rate) + 20.0f + (float)g2d.getFontMetrics().getLeading() + (float)g2d.getFontMetrics().getAscent());
        } else if (nameDrawType == DrawTypeEnum.Hide) {
            // empty if block
        }
        g2d.setFont(new Font("Arial", 1, this.positionFontSize));
        return new Area(startX * (double)this.rate, ((double)vertical - this.HALF_HEIGHT) * (double)this.rate - 10.0, endX * (double)this.rate, ((double)vertical + this.HALF_HEIGHT) * (double)this.rate + 10.0);
    }

    private Area drawCutLine(int vertical, int horizontal, int start, DrawTypeEnum startDrawType, int end, DrawTypeEnum endDrawType, String name, DrawTypeEnum nameDrawType, int size, Color color, Graphics2D g2d, ShapeEnum shapeType, boolean isActive, int iRotationAngle, int iHigh, int strokesize, GradientEnum GradientType, String SelectTextureFile, int proteinHeight, boolean lb, boolean rb) {
        Line2D.Double endline;
        Line2D.Double startline;
        double endY;
        double startY;
        int iVhigh;
        start = 0;
        if (shapeType == ShapeEnum.L_ParallelCurve || shapeType == ShapeEnum.R_ParallelCurve || shapeType == ShapeEnum.L_ParallelLine || shapeType == ShapeEnum.R_ParallelLine) {
            iHigh = 5;
            end = 5;
        } else {
            iHigh = 0;
            end = 10;
        }
        Stroke stroke = g2d.getStroke();
        vertical = -vertical;
        double startX = 0.0;
        double endX = 0.0;
        double centerX = 0.0;
        startX = (float)start * this.rate;
        endX = (float)start * this.rate + (float)(end - start) * this.rate * 4.0f;
        centerX = startX + (endX - startX) / 2.0;
        if (iHigh == 0) {
            iVhigh = (int)((double)(this.lineHeight * 2) * this.LENGTH_RATE);
            startY = (double)(-iVhigh) * this.RATE / 4.0;
            endY = (double)iVhigh * this.RATE / 4.0;
        } else {
            iVhigh = (int)((double)(iHigh * 2) * this.LENGTH_RATE) * 4;
            startY = (double)(-iVhigh) * this.RATE / 4.0;
            endY = (double)iVhigh * this.RATE / 4.0;
        }
        PolygonXY pgxy = new PolygonXY();
        pgxy.getPolygonXY(startX, startY, endX, endY, shapeType.name().toString(), iRotationAngle, this.rate);
        pgxy.CacuMinMaxXY();
        Color colorbk = new Color(0, 0, 0);
        this.drawPolygonTextureRect(g2d, startX, startY, endX, endY, pgxy, SelectTextureFile, stroke, color, colorbk, GradientType, shapeType, strokesize, isActive, iHigh);
        if (startDrawType == DrawTypeEnum.Down) {
            startline = new Line2D.Double(Math.round(pgxy.minx), (float)vertical * this.rate, Math.round(pgxy.minx), (float)vertical * this.rate + (float)this.lineHeight);
            g2d.draw(startline);
            g2d.drawString(String.valueOf(100), (float)((double)pgxy.minx - (double)g2d.getFontMetrics().stringWidth(String.valueOf(60)) / 2.0), (float)vertical * this.rate + (float)this.lineHeight + (float)g2d.getFontMetrics().getAscent());
        } else if (startDrawType == DrawTypeEnum.Up) {
            startline = new Line2D.Double(Math.round(pgxy.minx), (float)vertical * this.rate, Math.round(pgxy.minx), (float)vertical * this.rate - (float)this.lineHeight);
            g2d.draw(startline);
            g2d.drawString(String.valueOf(100), (float)((double)pgxy.minx - (double)g2d.getFontMetrics().stringWidth(String.valueOf(60)) / 2.0), (float)vertical * this.rate - (float)this.lineHeight - (float)g2d.getFontMetrics().getDescent());
        } else if (startDrawType == DrawTypeEnum.Hide) {
            // empty if block
        }
        if (endDrawType == DrawTypeEnum.Down) {
            endline = new Line2D.Double(Math.round(pgxy.maxx), (float)vertical * this.rate, Math.round(pgxy.maxx), (float)vertical * this.rate + (float)this.lineHeight);
            g2d.draw(endline);
            g2d.drawString(String.valueOf(140), (float)((double)pgxy.maxx - (double)g2d.getFontMetrics().stringWidth(String.valueOf(80)) / 2.0), (float)vertical * this.rate + (float)this.lineHeight + (float)g2d.getFontMetrics().getAscent());
        } else if (endDrawType == DrawTypeEnum.Up) {
            endline = new Line2D.Double(Math.round(pgxy.maxx), (float)vertical * this.rate, Math.round(pgxy.maxx), (float)vertical * this.rate - (float)this.lineHeight);
            g2d.draw(endline);
            g2d.drawString(String.valueOf(140), (float)((double)pgxy.maxx - (double)g2d.getFontMetrics().stringWidth(String.valueOf(80)) / 2.0), (float)vertical * this.rate - (float)this.lineHeight - (float)g2d.getFontMetrics().getDescent());
        } else if (endDrawType == DrawTypeEnum.Hide) {
            // empty if block
        }
        if (nameDrawType == DrawTypeEnum.Up) {
            g2d.drawString(name, (float)(centerX * (double)this.rate - (double)g2d.getFontMetrics().stringWidth(name) / 2.0), (float)(((double)vertical - this.HALF_HEIGHT) * (double)this.rate - (double)g2d.getFontMetrics().getLeading() - (double)g2d.getFontMetrics().getDescent()));
        } else if (nameDrawType == DrawTypeEnum.Center) {
            g2d.drawString(name, (float)(centerX * (double)this.rate - (double)g2d.getFontMetrics().stringWidth(name) / 2.0), (float)((double)((float)vertical * this.rate) + (double)g2d.getFontMetrics().getHeight() / 3.0));
        } else if (nameDrawType == DrawTypeEnum.Down) {
            g2d.drawString(name, (float)(centerX * (double)this.rate - (double)g2d.getFontMetrics().stringWidth(name) / 2.0), (float)(((double)vertical + this.HALF_HEIGHT) * (double)this.rate) + (float)g2d.getFontMetrics().getLeading() + (float)g2d.getFontMetrics().getAscent());
        } else if (nameDrawType == DrawTypeEnum.Hide) {
            // empty if block
        }
        g2d.setFont(new Font("Arial", 1, this.positionFontSize));
        float[] dash1 = new float[]{5.0f};
        g2d.setStroke(new BasicStroke(2.0f, 1, 1, 20.0f, dash1, 0.0f));
        double startxu = 0.0;
        double startyu = 0.0;
        double endxd = 0.0;
        double endyd = 0.0;
        double startxd = 0.0;
        double startyd = 0.0;
        double endxu = 0.0;
        double endyu = 0.0;
        proteinHeight = (int)this.DOMAIN_HEIGHT;
        g2d.setColor(Color.RED);
        start = 0;
        if (lb) {
            if (shapeType == ShapeEnum.L_ParallelCurve || shapeType == ShapeEnum.L_ParallelLine) {
                startxu = (this.DOMAIN_X + (double)start) * this.RATE;
                startxd = (this.DOMAIN_X + (double)start) * this.RATE;
                startyu = -this.DOMAIN_HEIGHT / 2.0 * this.RATE;
                startyd = -this.DOMAIN_HEIGHT / 2.0 * this.RATE + this.DOMAIN_HEIGHT * this.RATE;
                endxu = pgxy.x[3];
                endxd = pgxy.x[1];
                endyu = -this.DOMAIN_HEIGHT / 2.0 * this.RATE;
                endyd = -this.DOMAIN_HEIGHT / 2.0 * this.RATE + this.DOMAIN_HEIGHT * this.RATE;
            } else {
                startxu = (this.DOMAIN_X + (double)start) * this.RATE;
                startxd = (this.DOMAIN_X + (double)start) * this.RATE;
                startyu = -this.DOMAIN_HEIGHT / 2.0 * this.RATE;
                startyd = -this.DOMAIN_HEIGHT / 2.0 * this.RATE + this.DOMAIN_HEIGHT * this.RATE;
                endxu = pgxy.x[2];
                endxd = pgxy.x[0];
                endyu = -this.DOMAIN_HEIGHT / 2.0 * this.RATE;
                endyd = -this.DOMAIN_HEIGHT / 2.0 * this.RATE + this.DOMAIN_HEIGHT * this.RATE;
            }
            Line2D.Double leftline1 = new Line2D.Double((int)Math.round(startxu), (int)Math.round(startyu), (int)Math.round(startxd), (int)Math.round(endyd));
            g2d.draw(leftline1);
        } else if (rb) {
            if (shapeType == ShapeEnum.L_ParallelCurve || shapeType == ShapeEnum.L_ParallelLine) {
                startxu = pgxy.x[2];
                startxd = pgxy.x[0];
                startyu = -this.DOMAIN_HEIGHT / 2.0 * this.RATE;
                startyd = -this.DOMAIN_HEIGHT / 2.0 * this.RATE + this.DOMAIN_HEIGHT * this.RATE;
                endxu = 100.0;
                endxd = 100.0;
                endyu = -this.DOMAIN_HEIGHT / 2.0 * this.RATE;
                endyd = -this.DOMAIN_HEIGHT / 2.0 * this.RATE + this.DOMAIN_HEIGHT * this.RATE;
            } else {
                startxu = pgxy.x[3];
                startxd = pgxy.x[1];
                startyu = -this.DOMAIN_HEIGHT / 2.0 * this.RATE;
                startyd = -this.DOMAIN_HEIGHT / 2.0 * this.RATE + this.DOMAIN_HEIGHT * this.RATE;
                endxu = 100.0;
                endxd = 100.0;
                endyu = -this.DOMAIN_HEIGHT / 2.0 * this.RATE;
                endyd = -this.DOMAIN_HEIGHT / 2.0 * this.RATE + this.DOMAIN_HEIGHT * this.RATE;
            }
            Line2D.Double rightline1 = new Line2D.Double(100.0, (int)Math.round(startyu), 100.0, (int)Math.round(endyd));
            g2d.draw(rightline1);
        }
        Line2D.Double upline = new Line2D.Double((int)Math.round(startxu), (int)Math.round(startyu), (int)Math.round(endxu), (int)Math.round(endyu));
        Line2D.Double downline = new Line2D.Double((int)Math.round(startxd), (int)Math.round(startyd), (int)Math.round(endxd), (int)Math.round(endyd));
        g2d.draw(upline);
        g2d.draw(downline);
        return new Area(startX * (double)this.rate, ((double)vertical - this.HALF_HEIGHT) * (double)this.rate - 10.0, endX * (double)this.rate, ((double)vertical + this.HALF_HEIGHT) * (double)this.rate + 10.0);
    }

    private Area drawCutLineN(int vertical, int horizontal, int start, DrawTypeEnum startDrawType, int end, DrawTypeEnum endDrawType, String name, DrawTypeEnum nameDrawType, int size, Color color, Graphics2D g2d, ShapeEnum shapeType, boolean isActive, int iRotationAngle, int iHigh, int strokesize, GradientEnum GradientType, String SelectTextureFile) {
        Line2D.Double endline;
        Line2D.Double startline;
        start = 0;
        if (shapeType == ShapeEnum.L_ParallelCurve || shapeType == ShapeEnum.R_ParallelCurve || shapeType == ShapeEnum.L_ParallelLine || shapeType == ShapeEnum.R_ParallelLine) {
            iHigh = 5;
            end = 5;
        } else {
            iHigh = 10;
            end = 10;
        }
        Stroke stroke = g2d.getStroke();
        vertical = -vertical;
        double startX = 0.0;
        double endX = 0.0;
        double centerX = 0.0;
        startX = (float)start * this.rate;
        endX = (float)start * this.rate + (float)(end - start) * this.rate * 4.0f;
        centerX = startX + (endX - startX) / 2.0;
        int iVhigh = (int)((double)(iHigh * 2) * this.LENGTH_RATE) * 4;
        double startY = (double)(-iVhigh) * this.RATE / 4.0;
        double endY = (double)iVhigh * this.RATE / 4.0;
        PolygonXY pgxy = new PolygonXY();
        pgxy.getPolygonXY(startX, startY, endX, endY, shapeType.name().toString(), iRotationAngle, this.rate);
        pgxy.CacuMinMaxXY();
        Color colorbk = new Color(0, 0, 0);
        this.drawPolygonTextureRect(g2d, startX, startY, endX, endY, pgxy, SelectTextureFile, stroke, color, colorbk, GradientType, shapeType, strokesize, isActive, iHigh);
        g2d.setFont(new Font("Arial", 1, 12));
        if (startDrawType == DrawTypeEnum.Down) {
            startline = new Line2D.Double(Math.round(pgxy.minx), (float)vertical * this.rate, Math.round(pgxy.minx), (float)vertical * this.rate + (float)this.lineHeight);
            g2d.draw(startline);
            g2d.drawString(String.valueOf(60), (float)((double)pgxy.minx - (double)g2d.getFontMetrics().stringWidth(String.valueOf(60)) / 2.0), (float)vertical * this.rate + (float)this.lineHeight + (float)g2d.getFontMetrics().getAscent());
        } else if (startDrawType == DrawTypeEnum.Up) {
            startline = new Line2D.Double(Math.round(pgxy.minx), (float)vertical * this.rate, Math.round(pgxy.minx), (float)vertical * this.rate - (float)this.lineHeight);
            g2d.draw(startline);
            g2d.drawString(String.valueOf(60), (float)((double)pgxy.minx - (double)g2d.getFontMetrics().stringWidth(String.valueOf(60)) / 2.0), (float)vertical * this.rate - (float)this.lineHeight - (float)g2d.getFontMetrics().getDescent());
        } else if (startDrawType == DrawTypeEnum.Hide) {
            // empty if block
        }
        if (endDrawType == DrawTypeEnum.Down) {
            endline = new Line2D.Double(Math.round(pgxy.maxx), (float)vertical * this.rate, Math.round(pgxy.maxx), (float)vertical * this.rate + (float)this.lineHeight);
            g2d.draw(endline);
            g2d.drawString(String.valueOf(80), (float)((double)pgxy.maxx - (double)g2d.getFontMetrics().stringWidth(String.valueOf(80)) / 2.0), (float)vertical * this.rate + (float)this.lineHeight + (float)g2d.getFontMetrics().getAscent());
        } else if (endDrawType == DrawTypeEnum.Up) {
            endline = new Line2D.Double(Math.round(pgxy.maxx), (float)vertical * this.rate, Math.round(pgxy.maxx), (float)vertical * this.rate - (float)this.lineHeight);
            g2d.draw(endline);
            g2d.drawString(String.valueOf(80), (float)((double)pgxy.maxx - (double)g2d.getFontMetrics().stringWidth(String.valueOf(80)) / 2.0), (float)vertical * this.rate - (float)this.lineHeight - (float)g2d.getFontMetrics().getDescent());
        } else if (endDrawType == DrawTypeEnum.Hide) {
            // empty if block
        }
        if (nameDrawType == DrawTypeEnum.Up) {
            g2d.drawString(name, (float)(centerX * (double)this.rate - (double)g2d.getFontMetrics().stringWidth(name) / 2.0), (float)(((double)vertical - this.HALF_HEIGHT) * (double)this.rate - (double)g2d.getFontMetrics().getLeading() - (double)g2d.getFontMetrics().getDescent()));
        } else if (nameDrawType == DrawTypeEnum.Center) {
            g2d.drawString(name, (float)(centerX * (double)this.rate - (double)g2d.getFontMetrics().stringWidth(name) / 2.0), (float)((double)((float)vertical * this.rate) + (double)g2d.getFontMetrics().getHeight() / 3.0));
        } else if (nameDrawType == DrawTypeEnum.Down) {
            g2d.drawString(name, (float)(centerX * (double)this.rate - (double)g2d.getFontMetrics().stringWidth(name) / 2.0), (float)(((double)vertical + this.HALF_HEIGHT) * (double)this.rate) + (float)g2d.getFontMetrics().getLeading() + (float)g2d.getFontMetrics().getAscent());
        } else if (nameDrawType == DrawTypeEnum.Hide) {
            // empty if block
        }
        g2d.setFont(new Font("Arial", 1, this.positionFontSize));
        return new Area(startX * (double)this.rate, ((double)vertical - this.HALF_HEIGHT) * (double)this.rate - 10.0, endX * (double)this.rate, ((double)vertical + this.HALF_HEIGHT) * (double)this.rate + 10.0);
    }

    public void drawPolygonTextureRect(Graphics2D g2d, double startX, double startY, double endX, double endY, PolygonXY pgxy, String LineFile, Stroke stroke, Color color, Color colorbk, GradientEnum GradientType, ShapeEnum shapeType, int strokesize, boolean isActive, double circleShortDiameter) {
        int endx;
        double pgangle;
        Shape shape;
        int centery = (int)(startY + (endY - startY) / 2.0);
        int centerx = (int)(startX + (endX - startX) / 2.0);
        double comhalf_heigh = (endY - startY) / 2.0;
        Shape oldclip = g2d.getClip();
        GeneralPath clipShape = new GeneralPath();
        GeneralPath pt = new GeneralPath();
        if (shapeType == ShapeEnum.Circle) {
            shape = new Ellipse2D.Double(startX, startY, endX - startX, endY - startY);
            clipShape.append(shape, false);
        } else if (shapeType == ShapeEnum.RoundRectangle) {
            pgangle = Math.PI * pgxy.angle / 180.0;
            shape = new RoundRectangle2D.Double(startX, startY, endX - startX, endY - startY, 10.0, 10.0);
            clipShape.append(shape, false);
            AffineTransform rectTransform = AffineTransform.getRotateInstance(0.0, centerx, centery);
            rectTransform.setToRotation(pgangle, centerx, centery);
            shape = clipShape.createTransformedShape(rectTransform);
            clipShape.reset();
            clipShape.append(shape, false);
            startX = pgxy.minx;
            startY = pgxy.miny;
            endX = pgxy.maxx;
            endY = pgxy.maxy;
        } else if (shapeType == ShapeEnum.Cylinder) {
            pgangle = Math.PI * pgxy.angle / 180.0;
            Ellipse2D.Double shape1 = new Ellipse2D.Double(startX, startY, circleShortDiameter, endY - startY);
            pt.append(shape1, true);
            Rectangle2D.Double shape2 = new Rectangle2D.Double(startX + circleShortDiameter / 2.0, startY, endX - startX - circleShortDiameter, endY - startY);
            pt.append(shape2, true);
            Ellipse2D.Double shape3 = new Ellipse2D.Double(endX - circleShortDiameter, startY, circleShortDiameter, endY - startY);
            pt.append(shape3, true);
            shape = pt;
            clipShape.append(shape, false);
            AffineTransform rectTransform = AffineTransform.getRotateInstance(0.0, centerx, centery);
            rectTransform.setToRotation(pgangle, centerx, centery);
            shape = clipShape.createTransformedShape(rectTransform);
            clipShape.reset();
            clipShape.append(shape, false);
            startX = pgxy.minx;
            startY = pgxy.miny;
            endX = pgxy.maxx;
            endY = pgxy.maxy;
        } else if (shapeType == ShapeEnum.L_ParallelCurve || shapeType == ShapeEnum.R_ParallelCurve) {
            pt.moveTo(pgxy.x[0], pgxy.y[0]);
            pt.curveTo(pgxy.x[4], pgxy.y[4], pgxy.x[5], pgxy.y[5], pgxy.x[3], pgxy.y[3]);
            pt.lineTo(pgxy.x[2], pgxy.y[2]);
            pt.curveTo(pgxy.x[7], pgxy.y[7], pgxy.x[6], pgxy.y[6], pgxy.x[1], pgxy.y[1]);
            pt.lineTo(pgxy.x[0], pgxy.y[0]);
            shape = pt;
            clipShape.append(shape, false);
            startX = pgxy.minx;
            startY = pgxy.miny;
            endX = pgxy.maxx;
            endY = pgxy.maxy;
        } else {
            shape = new Polygon(pgxy.x, pgxy.y, pgxy.pointcount);
            startX = pgxy.minx;
            startY = pgxy.miny;
            endX = pgxy.maxx;
            endY = pgxy.maxy;
            clipShape.append(shape, false);
        }
        g2d.setClip(clipShape);
        int xstart = 0;
        int xend = 0;
        int ystart = 0;
        int yend = 0;
        int iVhigh = (int)(endY - startY);
        int iType = 1;
        if ((int)(endX - startX) == iVhigh) {
            xstart = (int)startX;
            xend = (int)startX + (int)((endX - startX) * 2.0);
            ystart = centery - iVhigh;
            yend = centery + iVhigh;
            iType = 1;
        } else if ((int)(endX - startX) > iVhigh) {
            xstart = (int)startX;
            xend = (int)startX + (int)((endX - startX) * 2.0);
            ystart = (int)((double)centery - (endX - startX));
            yend = (int)((double)centery + (endX - startX));
            iType = 2;
        } else if ((int)(endX - startX) < iVhigh) {
            xstart = centerx - iVhigh * 3;
            xend = centerx + iVhigh * 3;
            ystart = centery - iVhigh / 2;
            yend = centery + iVhigh * 3 / 2;
            iType = 3;
        }
        if (LineFile.equals("00001.jpg")) {
            g2d.setColor(color);
            this.drawPolygonGradientPaintRect(g2d, startX, startY, endX, endY, color, GradientType);
            g2d.fill(shape);
            g2d.setColor(colorbk);
            int p = 0;
            while (startX + (double)p < endX) {
                int startx = (int)(startX + (double)p);
                int endx2 = (int)(startX + (double)p);
                int starty = (int)startY;
                int endy = (int)endY;
                Line2D.Double line = new Line2D.Double(startx, starty, endx2, endy);
                g2d.draw(line);
                p += this.lineInterval;
            }
            int q = 0;
            while (startY + (double)q < endY) {
                int starty = (int)(startY + (double)q);
                int endy = (int)(startY + (double)q);
                int startx = (int)startX;
                int endx3 = (int)endX;
                Line2D.Double line = new Line2D.Double(startx, starty, endx3, endy);
                g2d.draw(line);
                q += this.lineInterval;
            }
            g2d.setClip(oldclip);
        } else if (LineFile.equals("00001_d.jpg")) {
            g2d.setColor(color);
            this.drawPolygonGradientPaintRect(g2d, startX, startY, endX, endY, color, GradientType);
            g2d.fill(shape);
            g2d.setColor(colorbk);
            float[] dash1 = new float[]{5.0f};
            g2d.setStroke(new BasicStroke(1.0f, 0, 0, 20.0f, dash1, 0.0f));
            int p = 0;
            while (startX + (double)p < endX) {
                int startx = (int)(startX + (double)p);
                int endx4 = (int)(startX + (double)p);
                int starty = (int)startY;
                int endy = (int)endY;
                Line2D.Double line = new Line2D.Double(startx, starty, endx4, endy);
                g2d.draw(line);
                p += this.lineInterval;
            }
            int q = 0;
            while (startY + (double)q < endY) {
                int starty = (int)(startY + (double)q);
                int endy = (int)(startY + (double)q);
                int startx = (int)startX;
                int endx5 = (int)endX;
                Line2D.Double line = new Line2D.Double(startx, starty, endx5, endy);
                g2d.draw(line);
                q += this.lineInterval;
            }
            g2d.setStroke(stroke);
            g2d.setClip(oldclip);
        } else if (LineFile.equals("00003.jpg")) {
            g2d.setColor(color);
            this.drawPolygonGradientPaintRect(g2d, startX, startY, endX, endY, color, GradientType);
            g2d.fill(shape);
            g2d.setColor(colorbk);
            int p = 0;
            while (startX + (double)p < endX) {
                int startx = (int)(startX + (double)p);
                int endx6 = (int)(startX + (double)p);
                int starty = (int)startY;
                int endy = (int)endY;
                Line2D.Double line = new Line2D.Double(startx, starty, endx6, endy);
                g2d.draw(line);
                p += this.lineInterval;
            }
            g2d.setClip(oldclip);
        } else if (LineFile.equals("00003_d.jpg")) {
            g2d.setColor(color);
            this.drawPolygonGradientPaintRect(g2d, startX, startY, endX, endY, color, GradientType);
            g2d.fill(shape);
            g2d.setColor(colorbk);
            float[] dash1 = new float[]{5.0f};
            g2d.setStroke(new BasicStroke(1.0f, 0, 0, 20.0f, dash1, 0.0f));
            int p = 0;
            while (startX + (double)p < endX) {
                int startx = (int)(startX + (double)p);
                int endx7 = (int)(startX + (double)p);
                int starty = (int)startY;
                int endy = (int)endY;
                Line2D.Double line = new Line2D.Double(startx, starty, endx7, endy);
                g2d.draw(line);
                p += this.lineInterval;
            }
            g2d.setStroke(stroke);
            g2d.setClip(oldclip);
        } else if (LineFile.equals("00002.jpg")) {
            g2d.setColor(color);
            this.drawPolygonGradientPaintRect(g2d, startX, startY, endX, endY, color, GradientType);
            g2d.fill(shape);
            g2d.setColor(colorbk);
            int q = 0;
            while (startY + (double)q < endY) {
                int starty = (int)(startY + (double)q);
                int endy = (int)(startY + (double)q);
                int startx = (int)startX;
                int endx8 = (int)endX;
                Line2D.Double line = new Line2D.Double(startx, starty, endx8, endy);
                g2d.draw(line);
                q += this.lineInterval;
            }
            g2d.setClip(oldclip);
        } else if (LineFile.equals("00002_d.jpg")) {
            g2d.setColor(color);
            this.drawPolygonGradientPaintRect(g2d, startX, startY, endX, endY, color, GradientType);
            g2d.fill(shape);
            g2d.setColor(colorbk);
            float[] dash1 = new float[]{5.0f};
            g2d.setStroke(new BasicStroke(1.0f, 0, 0, 20.0f, dash1, 0.0f));
            int q = 0;
            while (startY + (double)q < endY) {
                int starty = (int)(startY + (double)q);
                int endy = (int)(startY + (double)q);
                int startx = (int)startX;
                int endx9 = (int)endX;
                Line2D.Double line = new Line2D.Double(startx, starty, endx9, endy);
                g2d.draw(line);
                q += this.lineInterval;
            }
            g2d.setStroke(stroke);
            g2d.setClip(oldclip);
        } else if (LineFile.equals("00004.jpg")) {
            g2d.setColor(color);
            this.drawPolygonGradientPaintRect(g2d, startX, startY, endX, endY, color, GradientType);
            g2d.fill(shape);
            g2d.setColor(colorbk);
            int r = xend - xstart;
            int xendorig = xend;
            int xstartorig = xstart;
            xstart -= r;
            xend += r;
            int p = 0;
            while (xstart + p < xendorig) {
                int startx = xstart + p;
                int starty = ystart;
                int endx10 = xstartorig + p;
                int endy = yend;
                Line2D.Double line1 = new Line2D.Double(startx, starty, endx10, endy);
                g2d.draw(line1);
                p += this.lineInterval;
            }
            g2d.setClip(oldclip);
        } else if (LineFile.equals("00004_d.jpg")) {
            g2d.setColor(color);
            this.drawPolygonGradientPaintRect(g2d, startX, startY, endX, endY, color, GradientType);
            g2d.fill(shape);
            g2d.setColor(colorbk);
            int p = 0;
            float[] dash1 = new float[]{5.0f};
            g2d.setStroke(new BasicStroke(1.0f, 0, 0, 20.0f, dash1, 0.0f));
            int r = xend - xstart;
            int xendorig = xend;
            int xstartorig = xstart;
            xstart -= r;
            xend += r;
            while (xstart + p < xendorig) {
                int startx = xstart + p;
                int starty = ystart;
                endx = xstartorig + p;
                int endy = yend;
                Line2D.Double line1 = new Line2D.Double(startx, starty, endx, endy);
                g2d.draw(line1);
                p += this.lineInterval;
            }
            g2d.setStroke(stroke);
            g2d.setClip(oldclip);
        } else if (LineFile.equals("00005.jpg")) {
            g2d.setColor(color);
            this.drawPolygonGradientPaintRect(g2d, startX, startY, endX, endY, color, GradientType);
            g2d.fill(shape);
            g2d.setColor(colorbk);
            int r = xend - xstart;
            int xendorig = xend;
            int xstartorig = xstart;
            xstart -= r;
            xend += r;
            int p = 0;
            while (xstart + p < xendorig) {
                int startx = xstart + p;
                int starty = yend;
                int endx11 = xstartorig + p;
                int endy = ystart;
                Line2D.Double line1 = new Line2D.Double(startx, starty, endx11, endy);
                g2d.draw(line1);
                p += this.lineInterval;
            }
            g2d.setClip(oldclip);
        } else if (LineFile.equals("00005_d.jpg")) {
            g2d.setColor(color);
            this.drawPolygonGradientPaintRect(g2d, startX, startY, endX, endY, color, GradientType);
            g2d.fill(shape);
            g2d.setColor(colorbk);
            float[] dash1 = new float[]{5.0f};
            g2d.setStroke(new BasicStroke(1.0f, 0, 0, 20.0f, dash1, 0.0f));
            int r = xend - xstart;
            int xendorig = xend;
            int xstartorig = xstart;
            xstart -= r;
            xend += r;
            int p = 0;
            while (xstart + p < xendorig) {
                int startx = xstart + p;
                int starty = yend;
                endx = xstartorig + p;
                int endy = ystart;
                Line2D.Double line1 = new Line2D.Double(startx, starty, endx, endy);
                g2d.draw(line1);
                p += this.lineInterval;
            }
            g2d.setStroke(stroke);
            g2d.setClip(oldclip);
        } else if (LineFile.equals("00006.jpg")) {
            Line2D.Double line1;
            int endy;
            int endx12;
            int starty;
            int startx;
            g2d.setColor(color);
            this.drawPolygonGradientPaintRect(g2d, startX, startY, endX, endY, color, GradientType);
            g2d.fill(shape);
            g2d.setColor(colorbk);
            int r = xend - xstart;
            int xendorig = xend;
            int xstartorig = xstart;
            xstart -= r;
            xend += r;
            int p = 0;
            while (xstart + p < xendorig) {
                startx = xstart + p;
                starty = yend;
                endx12 = xstartorig + p;
                endy = ystart;
                line1 = new Line2D.Double(startx, starty, endx12, endy);
                g2d.draw(line1);
                p += this.lineInterval;
            }
            p = 0;
            r = xend - xstart;
            xendorig = xend;
            xstartorig = xstart;
            xstart -= r;
            xend += r;
            while (xstart + p < xendorig) {
                startx = xstart + p;
                starty = ystart;
                endx12 = xstartorig + p;
                endy = yend;
                line1 = new Line2D.Double(startx, starty, endx12, endy);
                g2d.draw(line1);
                p += this.lineInterval;
            }
            g2d.setClip(oldclip);
        } else if (LineFile.equals("00006_d.jpg")) {
            Line2D.Double line1;
            int endy;
            int starty;
            int startx;
            g2d.setColor(color);
            this.drawPolygonGradientPaintRect(g2d, startX, startY, endX, endY, color, GradientType);
            g2d.fill(shape);
            g2d.setColor(colorbk);
            int p = 0;
            float[] dash1 = new float[]{5.0f};
            g2d.setStroke(new BasicStroke(1.0f, 0, 0, 20.0f, dash1, 0.0f));
            int r = xend - xstart;
            int xendorig = xend;
            int xstartorig = xstart;
            xstart -= r;
            xend += r;
            while (xstart + p < xendorig) {
                startx = xstart + p;
                starty = yend;
                endx = xstartorig + p;
                endy = ystart;
                line1 = new Line2D.Double(startx, starty, endx, endy);
                g2d.draw(line1);
                p += this.lineInterval;
            }
            p = 0;
            r = xend - xstart;
            xendorig = xend;
            xstartorig = xstart;
            xstart -= r;
            xend += r;
            while (xstart + p < xendorig) {
                startx = xstart + p;
                starty = ystart;
                endx = xstartorig + p;
                endy = yend;
                line1 = new Line2D.Double(startx, starty, endx, endy);
                g2d.draw(line1);
                p += this.lineInterval;
            }
            g2d.setStroke(stroke);
            g2d.setClip(oldclip);
        } else if (LineFile.equals("00000_1.jpg")) {
            g2d.setColor(color);
            g2d.fill(shape);
            this.drawCrystal(g2d, startX, startY, endX, endY, color);
            g2d.setColor(colorbk);
            g2d.setClip(oldclip);
        } else if (LineFile.equals("00000_0.jpg")) {
            g2d.setColor(color);
            this.drawPolygonGradientPaintRect(g2d, startX, startY, endX, endY, color, GradientType);
            g2d.fill(shape);
            g2d.setColor(colorbk);
            g2d.setClip(oldclip);
        } else {
            try {
                File objFile = new File("texture/" + LineFile);
                BufferedImage bgImg = ImageIO.read(objFile);
                if (this.bGray) {
                    WritableRaster raster = bgImg.getRaster();
                    int[] sample = new int[4];
                    for (int k = 0; k < bgImg.getWidth(); ++k) {
                        for (int m = 0; m < bgImg.getHeight(); ++m) {
                            raster.getPixel(k, m, sample);
                            Color corig = new Color(sample[0], sample[1], sample[2], sample[3]);
                            Color cl = this.getGrayColor(corig);
                            sample[0] = cl.getRed();
                            sample[1] = cl.getGreen();
                            sample[2] = cl.getBlue();
                            sample[3] = cl.getAlpha();
                            raster.setPixel(k, m, sample);
                        }
                    }
                }
                Rectangle rect = new Rectangle((int)startX, (int)startY, (int)(endX - startX), (int)(endY - startY));
                TexturePaint texture = new TexturePaint(bgImg, rect);
                Paint pp = g2d.getPaint();
                g2d.setPaint(texture);
                g2d.fill(shape);
                g2d.setClip(oldclip);
                g2d.setPaint(pp);
            }
            catch (IOException bgImg) {
                // empty catch block
            }
        }
        float thick = strokesize;
        if (isActive) {
            float[] dash1 = new float[]{5.0f};
            g2d.setStroke(new BasicStroke(1.0f, 1, 1, 20.0f, dash1, 0.0f));
        } else {
            g2d.setStroke(new BasicStroke(thick, 1, 1));
        }
        if (shapeType == ShapeEnum.L_ParallelCurve || shapeType == ShapeEnum.R_ParallelCurve) {
            CubicCurve2D.Double q = new CubicCurve2D.Double(pgxy.x[0], pgxy.y[0], pgxy.x[4], pgxy.y[4], pgxy.x[5], pgxy.y[5], pgxy.x[3], pgxy.y[3]);
            g2d.draw(q);
            CubicCurve2D.Double q2 = new CubicCurve2D.Double(pgxy.x[1], pgxy.y[1], pgxy.x[6], pgxy.y[6], pgxy.x[7], pgxy.y[7], pgxy.x[2], pgxy.y[2]);
            g2d.draw(q2);
        } else if (shapeType == ShapeEnum.L_ParallelLine || shapeType == ShapeEnum.R_ParallelLine) {
            g2d.drawLine(pgxy.x[0], pgxy.y[0], pgxy.x[3], pgxy.y[3]);
            g2d.drawLine(pgxy.x[1], pgxy.y[1], pgxy.x[2], pgxy.y[2]);
        } else if (shapeType == ShapeEnum.Cylinder) {
            float thick2 = strokesize;
            g2d.setStroke(new BasicStroke(thick2 * this.rate, 1, 1));
            Ellipse2D.Double shape11 = new Ellipse2D.Double(startX, startY, circleShortDiameter, endY - startY);
            g2d.draw(shape11);
            g2d.drawLine((int)(startX + circleShortDiameter / 2.0), (int)startY, (int)(endX - circleShortDiameter / 2.0), (int)startY);
            g2d.drawLine((int)(endX - circleShortDiameter / 2.0), (int)endY, (int)(startX + circleShortDiameter / 2.0), (int)endY);
            double cx = endX - circleShortDiameter;
            double cy = startY;
            double cw = circleShortDiameter;
            double ch = endY - startY;
            double startang = 0.0;
            double endang = 90.0;
            Arc2D.Double arc4 = new Arc2D.Double(cx, cy, cw, ch, startang, endang, 0);
            g2d.draw(arc4);
            startang = 270.0;
            endang = 90.0;
            Arc2D.Double arc5 = new Arc2D.Double(cx, cy, cw, ch, startang, endang, 0);
            g2d.draw(arc5);
            int proteinStart = 1;
            int proteinEnd = 200;
            int proteinHeight = 12;
            GradientEnum pGradientType = GradientEnum.Horizontal;
            String pSelectTextureFile = "00000_1.jpg";
            double startpX = (this.DOMAIN_X + (double)proteinStart) * this.RATE;
            double endpX = (this.DOMAIN_X + (double)proteinStart) * this.RATE + (double)(proteinEnd - proteinStart) * this.RATE;
            double centerpX = (endX - startX) / 2.0;
            double startpY = -6.0 * this.RATE;
            double endpY = 6.0 * this.RATE;
            double pcomhalf_heigh = 6.0;
            int pstrokesize = 1;
            String proteinColorLineStr = "0,0,0";
            StringTokenizer ster = new StringTokenizer(proteinColorLineStr, ",");
            Color proteinLineColor = new Color(Integer.parseInt(ster.nextToken()), Integer.parseInt(ster.nextToken()), Integer.parseInt(ster.nextToken()));
            g2d.setStroke(stroke);
            PolygonXY pgxypro = new PolygonXY();
            pgxypro.getPolygonXY(startpX, (int)Math.round(startpY), endpX, (int)Math.round(endpY), "Rectangle", 0.0, this.rate);
            pgxypro.CacuMinMaxXY();
            float thick1 = pstrokesize;
            if (LineFile.equals("00000_1.jpg")) {
                g2d.setStroke(new BasicStroke(Math.round(1.0f), 1, 1));
                double perCentDiam = 0.5;
                double litllerDiameter = circleShortDiameter * perCentDiam;
                double littlerCenterX = startX + circleShortDiameter / 2.0;
                double littlerCenterY = startY + (endY - startY) / 2.0;
                double cx1 = littlerCenterX - litllerDiameter / 2.0;
                double cy1 = pgxypro.miny;
                double cw1 = litllerDiameter / 2.0;
                double ch1 = pgxypro.maxy - pgxypro.miny;
                double startang1 = 0.0;
                double endang1 = 90.0;
                Arc2D.Double arc6 = new Arc2D.Double((int)Math.round(cx1 - (double)((float)strokesize * this.rate / 10.0f)), (int)Math.round(cy1), (int)Math.round(cw1), (int)Math.round(ch1), startang1, endang1, 0);
                g2d.draw(arc6);
                startang1 = 270.0;
                endang1 = 90.0;
                Arc2D.Double arc7 = new Arc2D.Double((int)Math.round(cx1 - (double)((float)strokesize * this.rate / 10.0f)), (int)Math.round(cy1), (int)Math.round(cw1), (int)Math.round(ch1), startang1, endang1, 0);
                g2d.draw(arc7);
                Line2D.Double line1 = new Line2D.Double((int)Math.round(startX - (double)(thick1 * this.rate)), Math.round(pgxypro.miny), (int)Math.round(littlerCenterX - litllerDiameter / 2.0 + (double)(thick1 * this.rate / 2.0f)), Math.round(pgxypro.miny));
                Line2D.Double line2 = new Line2D.Double((int)Math.round(startX - (double)(thick1 * this.rate)), Math.round(pgxypro.maxy), (int)Math.round(littlerCenterX - litllerDiameter / 2.0 + (double)(thick1 * this.rate / 2.0f)), Math.round(pgxypro.maxy));
                g2d.draw(line1);
                g2d.draw(line2);
            }
            this.drawPreCylinderProtein(g2d, (int)Math.round(startpX), (int)Math.round(startpY), (int)Math.round(endpX), (int)Math.round(endpY), pgxypro, pSelectTextureFile, stroke, this.getGrayColor(Color.GRAY), this.getGrayColor(proteinLineColor), pGradientType, ShapeEnum.Rectangle, pstrokesize, false, 0.0, comhalf_heigh, false, startX, circleShortDiameter);
        } else {
            g2d.draw(shape);
        }
        g2d.setColor(colorbk);
        g2d.setStroke(stroke);
    }

    public void drawPreCylinderProtein(Graphics2D g2d, double startX, double startY, double endX, double endY, PolygonXY pgxy, String LineFile, Stroke stroke, Color color, Color colorbk, GradientEnum GradientType, ShapeEnum shapeType, int strokesize, boolean isActive, double vertical, double comhalf_heigh, boolean isDash, double comStartX, double circleShortDiameter) {
        Stroke origstroke = g2d.getStroke();
        double llen = 10.0;
        int proteinStart = 0;
        int proteinEnd = 200;
        llen = (proteinEnd - proteinStart) / 20;
        Shape oldclip = g2d.getClip();
        GeneralPath clipShape = new GeneralPath();
        double startx0 = startX;
        double starty0 = startY;
        double endx0 = endX;
        double endy0 = endY;
        GeneralPath pt = new GeneralPath();
        double perCentDiam = 0.5;
        double litllerDiameter = circleShortDiameter * perCentDiam;
        double littlerCenterX = comStartX + circleShortDiameter / 2.0;
        double littlerCenterY = startY + (endY - startY) / 2.0;
        double cx1 = littlerCenterX - litllerDiameter / 2.0;
        double cy1 = littlerCenterY - this.HALF_HEIGHT * (double)this.rate;
        double cw1 = litllerDiameter / 2.0;
        double ch1 = this.HALF_HEIGHT * (double)this.rate * 2.0;
        Rectangle2D.Double shape2 = new Rectangle2D.Double((int)Math.round(comStartX - 1.0), (int)Math.round(cy1), (int)Math.round(littlerCenterX - comStartX - litllerDiameter / 2.0 + 1.0), (int)Math.round(ch1));
        pt.append(shape2, true);
        Ellipse2D.Double shape3 = new Ellipse2D.Double((int)Math.round(littlerCenterX - litllerDiameter / 2.0 - 1.0), (int)Math.round(cy1), (int)Math.round(cw1), (int)Math.round(ch1));
        pt.append(shape3, true);
        GeneralPath shape = pt;
        clipShape.append(shape, true);
        double centerY = startY + (endY - startY) / 2.0;
        double centerX = startX + (endX - startX) / 2.0;
        g2d.clip(clipShape);
        double xstart = 0.0;
        double xend = 0.0;
        double ystart = 0.0;
        double yend = 0.0;
        double iVhigh = endY - startY;
        int iType = 1;
        if (endX - startX == iVhigh) {
            xstart = startX;
            xend = startX + (endX - startX) * 2.0;
            ystart = centerY - iVhigh;
            yend = centerY + iVhigh;
            iType = 1;
        } else if (endX - startX > iVhigh) {
            xstart = startX;
            xend = startX + (endX - startX) * 2.0;
            ystart = centerY - (endX - startX);
            yend = centerY + (endX - startX);
            iType = 2;
        } else if (endX - startX < iVhigh) {
            xstart = centerX - iVhigh * 3.0;
            xend = centerX + iVhigh * 3.0;
            ystart = centerY - iVhigh / 2.0;
            yend = centerY + iVhigh * 3.0 / 2.0;
            iType = 3;
        }
        if (LineFile.equals("00001.jpg")) {
            g2d.setColor(color);
            this.drawPolygonGradientPaintRect(g2d, startx0, starty0, endx0, endy0, color, GradientType, vertical, comhalf_heigh);
            g2d.fill(shape);
            g2d.setColor(colorbk);
            int p = 0;
            while (startX + (double)p < endX) {
                double startx = startX + (double)p;
                double endx = startX + (double)p;
                double starty = startY;
                double endy = endY;
                Line2D.Double line = new Line2D.Double(startx, starty, endx, endy);
                g2d.draw(line);
                p += this.lineInterval;
            }
            int q = 0;
            while (startY + (double)q < endY) {
                double starty = startY + (double)q;
                double endy = startY + (double)q;
                double startx = startX;
                double endx = endX;
                Line2D.Double line = new Line2D.Double(startx, starty, endx, endy);
                g2d.draw(line);
                q += this.lineInterval;
            }
            g2d.setClip(oldclip);
        } else if (LineFile.equals("00001_d.jpg")) {
            g2d.setColor(color);
            this.drawPolygonGradientPaintRect(g2d, pgxy.minx, pgxy.miny, pgxy.maxx, pgxy.maxy, color, GradientType, vertical, comhalf_heigh);
            g2d.fill(shape);
            g2d.setColor(colorbk);
            float[] dash1 = new float[]{5.0f};
            g2d.setStroke(new BasicStroke(1.0f, 0, 0, 20.0f, dash1, 0.0f));
            int p = 0;
            while (startX + (double)p < endX) {
                double startx = startX + (double)p;
                double endx = startX + (double)p;
                double starty = startY;
                double endy = endY;
                Line2D.Double line = new Line2D.Double(startx, starty, endx, endy);
                g2d.draw(line);
                p += this.lineInterval;
            }
            int q = 0;
            while (startY + (double)q < endY) {
                double starty = startY + (double)q;
                double endy = startY + (double)q;
                double startx = startX;
                double endx = endX;
                Line2D.Double line = new Line2D.Double(startx, starty, endx, endy);
                g2d.draw(line);
                q += this.lineInterval;
            }
            g2d.setStroke(stroke);
            g2d.setClip(oldclip);
        } else if (LineFile.equals("00003.jpg")) {
            g2d.setColor(color);
            this.drawPolygonGradientPaintRect(g2d, pgxy.minx, pgxy.miny, pgxy.maxx, pgxy.maxy, color, GradientType, vertical, comhalf_heigh);
            g2d.fill(shape);
            g2d.setColor(colorbk);
            int p = 0;
            while (startX + (double)p < endX) {
                double startx = startX + (double)p;
                double endx = startX + (double)p;
                double starty = startY;
                double endy = endY;
                Line2D.Double line = new Line2D.Double(startx, starty, endx, endy);
                g2d.draw(line);
                p += this.lineInterval;
            }
            g2d.setClip(oldclip);
        } else if (LineFile.equals("00003_d.jpg")) {
            g2d.setColor(color);
            this.drawPolygonGradientPaintRect(g2d, pgxy.minx, pgxy.miny, pgxy.maxx, pgxy.maxy, color, GradientType, vertical, comhalf_heigh);
            g2d.fill(shape);
            g2d.setColor(colorbk);
            float[] dash1 = new float[]{5.0f};
            g2d.setStroke(new BasicStroke(1.0f, 0, 0, 20.0f, dash1, 0.0f));
            int p = 0;
            while (startX + (double)p < endX) {
                double startx = startX + (double)p;
                double endx = startX + (double)p;
                double starty = startY;
                double endy = endY;
                Line2D.Double line = new Line2D.Double(startx, starty, endx, endy);
                g2d.draw(line);
                p += this.lineInterval;
            }
            g2d.setStroke(stroke);
            g2d.setClip(oldclip);
        } else if (LineFile.equals("00002.jpg")) {
            g2d.setColor(color);
            this.drawPolygonGradientPaintRect(g2d, pgxy.minx, pgxy.miny, pgxy.maxx, pgxy.maxy, color, GradientType, vertical, comhalf_heigh);
            g2d.fill(shape);
            g2d.setColor(colorbk);
            int q = 0;
            while (startY + (double)q < endY) {
                double starty = startY + (double)q;
                double endy = startY + (double)q;
                double startx = startX;
                double endx = endX;
                Line2D.Double line = new Line2D.Double(startx, starty, endx, endy);
                g2d.draw(line);
                q += this.lineInterval;
            }
            g2d.setClip(oldclip);
        } else if (LineFile.equals("00002_d.jpg")) {
            g2d.setColor(color);
            this.drawPolygonGradientPaintRect(g2d, pgxy.minx, pgxy.miny, pgxy.maxx, pgxy.maxy, color, GradientType, vertical, comhalf_heigh);
            g2d.fill(shape);
            g2d.setColor(colorbk);
            float[] dash1 = new float[]{5.0f};
            g2d.setStroke(new BasicStroke(1.0f, 0, 0, 20.0f, dash1, 0.0f));
            int q = 0;
            while (startY + (double)q < endY) {
                double starty = startY + (double)q;
                double endy = startY + (double)q;
                double startx = startX;
                double endx = endX;
                Line2D.Double line = new Line2D.Double(startx, starty, endx, endy);
                g2d.draw(line);
                q += this.lineInterval;
            }
            g2d.setStroke(stroke);
            g2d.setClip(oldclip);
        } else if (LineFile.equals("00004.jpg")) {
            g2d.setColor(color);
            this.drawPolygonGradientPaintRect(g2d, pgxy.minx, pgxy.miny, pgxy.maxx, pgxy.maxy, color, GradientType, vertical, comhalf_heigh);
            g2d.fill(shape);
            g2d.setColor(colorbk);
            double r = xend - xstart;
            double xendorig = xend;
            double xstartorig = xstart;
            xstart -= r;
            xend += r;
            int p = 0;
            while (xstart + (double)p < xendorig) {
                double startx = xstart + (double)p;
                double starty = ystart;
                double endx = xstartorig + (double)p;
                double endy = yend;
                Line2D.Double line1 = new Line2D.Double(startx, starty, endx, endy);
                g2d.draw(line1);
                p += this.lineInterval;
            }
            g2d.setClip(oldclip);
        } else if (LineFile.equals("00004_d.jpg")) {
            g2d.setColor(color);
            this.drawPolygonGradientPaintRect(g2d, pgxy.minx, pgxy.miny, pgxy.maxx, pgxy.maxy, color, GradientType, vertical, comhalf_heigh);
            g2d.fill(shape);
            g2d.setColor(colorbk);
            int p = 0;
            float[] dash1 = new float[]{5.0f};
            g2d.setStroke(new BasicStroke(1.0f, 0, 0, 20.0f, dash1, 0.0f));
            double r = xend - xstart;
            double xendorig = xend;
            double xstartorig = xstart;
            xstart -= r;
            xend += r;
            while (xstart + (double)p < xendorig) {
                double startx = xstart + (double)p;
                double starty = ystart;
                double endx = xstartorig + (double)p;
                double endy = yend;
                Line2D.Double line1 = new Line2D.Double(startx, starty, endx, endy);
                g2d.draw(line1);
                p += this.lineInterval;
            }
            g2d.setStroke(stroke);
            g2d.setClip(oldclip);
        } else if (LineFile.equals("00005.jpg")) {
            g2d.setColor(color);
            this.drawPolygonGradientPaintRect(g2d, pgxy.minx, pgxy.miny, pgxy.maxx, pgxy.maxy, color, GradientType, vertical, comhalf_heigh);
            g2d.fill(shape);
            g2d.setColor(colorbk);
            double r = xend - xstart;
            double xendorig = xend;
            double xstartorig = xstart;
            xstart -= r;
            xend += r;
            int p = 0;
            while (xstart + (double)p < xendorig) {
                double startx = xstart + (double)p;
                double starty = yend;
                double endx = xstartorig + (double)p;
                double endy = ystart;
                Line2D.Double line1 = new Line2D.Double(startx, starty, endx, endy);
                g2d.draw(line1);
                p += this.lineInterval;
            }
            g2d.setClip(oldclip);
        } else if (LineFile.equals("00005_d.jpg")) {
            g2d.setColor(color);
            this.drawPolygonGradientPaintRect(g2d, pgxy.minx, pgxy.miny, pgxy.maxx, pgxy.maxy, color, GradientType, vertical, comhalf_heigh);
            g2d.fill(shape);
            g2d.setColor(colorbk);
            float[] dash1 = new float[]{5.0f};
            g2d.setStroke(new BasicStroke(1.0f, 0, 0, 20.0f, dash1, 0.0f));
            double r = xend - xstart;
            double xendorig = xend;
            double xstartorig = xstart;
            xstart -= r;
            xend += r;
            int p = 0;
            while (xstart + (double)p < xendorig) {
                double startx = xstart + (double)p;
                double starty = yend;
                double endx = xstartorig + (double)p;
                double endy = ystart;
                Line2D.Double line1 = new Line2D.Double(startx, starty, endx, endy);
                g2d.draw(line1);
                p += this.lineInterval;
            }
            g2d.setStroke(stroke);
            g2d.setClip(oldclip);
        } else if (LineFile.equals("00006.jpg")) {
            Line2D.Double line1;
            double endy;
            double endx;
            double starty;
            double startx;
            g2d.setColor(color);
            this.drawPolygonGradientPaintRect(g2d, pgxy.minx, pgxy.miny, pgxy.maxx, pgxy.maxy, color, GradientType, vertical, comhalf_heigh);
            g2d.fill(shape);
            g2d.setColor(colorbk);
            double r = xend - xstart;
            double xendorig = xend;
            double xstartorig = xstart;
            xstart -= r;
            xend += r;
            int p = 0;
            while (xstart + (double)p < xendorig) {
                startx = xstart + (double)p;
                starty = yend;
                endx = xstartorig + (double)p;
                endy = ystart;
                line1 = new Line2D.Double(startx, starty, endx, endy);
                g2d.draw(line1);
                p += this.lineInterval;
            }
            p = 0;
            r = xend - xstart;
            xendorig = xend;
            xstartorig = xstart;
            xstart -= r;
            xend += r;
            while (xstart + (double)p < xendorig) {
                startx = xstart + (double)p;
                starty = ystart;
                endx = xstartorig + (double)p;
                endy = yend;
                line1 = new Line2D.Double(startx, starty, endx, endy);
                g2d.draw(line1);
                p += this.lineInterval;
            }
            g2d.setClip(oldclip);
        } else if (LineFile.equals("00006_d.jpg")) {
            Line2D.Double line1;
            double endy;
            double endx;
            double starty;
            double startx;
            g2d.setColor(color);
            this.drawPolygonGradientPaintRect(g2d, pgxy.minx, pgxy.miny, pgxy.maxx, pgxy.maxy, color, GradientType, vertical, comhalf_heigh);
            g2d.fill(shape);
            g2d.setColor(colorbk);
            int p = 0;
            float[] dash1 = new float[]{5.0f};
            g2d.setStroke(new BasicStroke(1.0f, 0, 0, 20.0f, dash1, 0.0f));
            double r = xend - xstart;
            double xendorig = xend;
            double xstartorig = xstart;
            xstart -= r;
            xend += r;
            while (xstart + (double)p < xendorig) {
                startx = xstart + (double)p;
                starty = yend;
                endx = xstartorig + (double)p;
                endy = ystart;
                line1 = new Line2D.Double(startx, starty, endx, endy);
                g2d.draw(line1);
                p += this.lineInterval;
            }
            p = 0;
            r = xend - xstart;
            xendorig = xend;
            xstartorig = xstart;
            xstart -= r;
            xend += r;
            while (xstart + (double)p < xendorig) {
                startx = xstart + (double)p;
                starty = ystart;
                endx = xstartorig + (double)p;
                endy = yend;
                line1 = new Line2D.Double(startx, starty, endx, endy);
                g2d.draw(line1);
                p += this.lineInterval;
            }
            g2d.setStroke(stroke);
            g2d.setClip(oldclip);
        } else if (LineFile.equals("00000_1.jpg")) {
            g2d.setColor(color);
            if (this.rate < 1.0f) {
                g2d.setStroke(new BasicStroke(1.0f));
            } else {
                g2d.setStroke(new BasicStroke((int)this.rate));
            }
            this.drawCrystal(g2d, Math.round(pgxy.minx), Math.round(pgxy.miny), Math.round(pgxy.maxx), Math.round(pgxy.maxy), color);
            g2d.setColor(colorbk);
            g2d.setClip(oldclip);
        } else if (LineFile.equals("00000_0.jpg")) {
            g2d.setColor(color);
            this.drawPolygonGradientPaintRect(g2d, pgxy.minx, pgxy.miny, pgxy.maxx, pgxy.maxy, color, GradientType, vertical, comhalf_heigh);
            g2d.fill(shape);
            g2d.setColor(colorbk);
            g2d.setClip(oldclip);
        } else {
            try {
                File objFile = new File("texture/" + LineFile);
                BufferedImage bgImg = ImageIO.read(objFile);
                if (this.bGray) {
                    WritableRaster raster = bgImg.getRaster();
                    int[] sample = new int[4];
                    for (int k = 0; k < bgImg.getWidth(); ++k) {
                        for (int m = 0; m < bgImg.getHeight(); ++m) {
                            raster.getPixel(k, m, sample);
                            Color corig = new Color(sample[0], sample[1], sample[2], sample[3]);
                            Color cl = this.getGrayColor(corig);
                            sample[0] = cl.getRed();
                            sample[1] = cl.getGreen();
                            sample[2] = cl.getBlue();
                            sample[3] = cl.getAlpha();
                            raster.setPixel(k, m, sample);
                        }
                    }
                }
                Rectangle rect = new Rectangle(pgxy.minx, pgxy.miny, pgxy.maxx - pgxy.minx, pgxy.maxy - pgxy.miny);
                TexturePaint texture = new TexturePaint(bgImg, rect);
                Paint pp = g2d.getPaint();
                g2d.setPaint(texture);
                g2d.fill(shape);
                g2d.setClip(oldclip);
                g2d.setPaint(pp);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        g2d.setStroke(origstroke);
    }

    public void drawPolygonGradientPaintRect(Graphics2D g2d, double startX, double startY, double endX, double endY, Color color, GradientEnum GradientType, double vertical, double comhalf_heigh) {
        g2d.setColor(this.getGrayColor(color));
        if (GradientType == GradientEnum.Null) {
            g2d.setColor(this.getGrayColor(color));
        } else if (GradientType == GradientEnum.Default) {
            g2d.setPaint(new GradientPaint(0.0f, (float)(startY + (endY - startY) / 2.0), Color.white, 0.0f, (float)endY, this.getGrayColor(color), true));
        } else if (GradientType == GradientEnum.Top_left_to_bottom_right) {
            g2d.setPaint(new GradientPaint((float)startX, (float)startY, Color.white, (float)endX, (float)endY, color, true));
        } else if (GradientType == GradientEnum.Right) {
            g2d.setPaint(new GradientPaint((float)startX, (float)(startY + (endY - startY) / 2.0), Color.white, (float)endX, (float)(startY + (endY - startY) / 2.0), color, true));
        } else if (GradientType == GradientEnum.Bottom_left_to_top_right) {
            g2d.setPaint(new GradientPaint((float)startX, (float)endY, Color.white, (float)endX, (float)startY, color, true));
        } else if (GradientType == GradientEnum.Up) {
            g2d.setPaint(new GradientPaint((float)(startX + (endX - startX) / 2.0), (float)endY, Color.white, (float)(startX + (endX - startX) / 2.0), (float)startY, color, true));
        } else if (GradientType == GradientEnum.Bottom_right_to_top_left) {
            g2d.setPaint(new GradientPaint((float)endX, (float)endY, Color.white, (float)startX, (float)startY, color, true));
        } else if (GradientType == GradientEnum.Left) {
            g2d.setPaint(new GradientPaint((float)endX, (float)(startY + (endY - startY) / 2.0), Color.white, (float)startX, (float)(startY + (endY - startY) / 2.0), color, true));
        } else if (GradientType == GradientEnum.Top_right_to_bottom_left) {
            g2d.setPaint(new GradientPaint((float)endX, (float)startY, Color.white, (float)startX, (float)endY, color, true));
        } else if (GradientType == GradientEnum.Down) {
            g2d.setPaint(new GradientPaint((float)(startX + (endX - startX) / 2.0), (float)startY, Color.white, (float)(startX + (endX - startX) / 2.0), (float)endY, color, true));
        } else if (GradientType == GradientEnum.Center_to_Border) {
            float[] dist = new float[]{0.0f, 0.2f, 1.0f};
            Color[] colors = new Color[]{color, color, Color.WHITE};
            Point2D.Float center = new Point2D.Float((float)(startX + (endX - startX) / 2.0), (float)(startY + (endY - startY) / 2.0));
            double r = 0.0;
            if (endX - startX == endY - startY) {
                r = (endY - startY) / 2.0;
            } else if (endX - startX < endY - startY) {
                r = (endY - startY) / 2.0;
            } else if (endX - startX > endY - startY) {
                r = (endX - startX) / 2.0;
            }
            g2d.setPaint(new RadialGradientPaint(center, (float)((int)r), dist, colors, MultipleGradientPaint.CycleMethod.NO_CYCLE));
        } else if (GradientType == GradientEnum.Center) {
            float[] dist = new float[]{0.0f, 0.2f, 1.0f};
            Color[] colors = new Color[]{Color.WHITE, Color.WHITE, color};
            Point2D.Float center = new Point2D.Float((float)(startX + (endX - startX) / 2.0), (float)(startY + (endY - startY) / 2.0));
            double r = 0.0;
            if (endX - startX == endY - startY) {
                r = (endY - startY) / 2.0;
            } else if (endX - startX < endY - startY) {
                r = (endY - startY) / 2.0;
            } else if (endX - startX > endY - startY) {
                r = (endX - startX) / 2.0;
            }
            g2d.setPaint(new RadialGradientPaint(center, (float)((int)r), dist, colors, MultipleGradientPaint.CycleMethod.NO_CYCLE));
        } else if (GradientType == GradientEnum.Vertical) {
            g2d.setPaint(new GradientPaint((float)(startX + (endX - startX) / 2.0), 0.0f, Color.white, (float)endX, 0.0f, this.getGrayColor(color), true));
        } else if (GradientType == GradientEnum.Horizontal) {
            g2d.setPaint(new GradientPaint(0.0f, (float)(startY + (endY - startY) / 2.0), Color.white, 0.0f, (float)endY, this.getGrayColor(color), true));
        }
    }

    public void drawPolygonGradientPaintRect(Graphics2D g2d, double startX, double startY, double endX, double endY, Color color, GradientEnum GradientType) {
        g2d.setColor(this.getGrayColor(color));
        if (GradientType == GradientEnum.Null) {
            g2d.setColor(this.getGrayColor(color));
        } else if (GradientType == GradientEnum.Default) {
            double vertical = startY + (endY - startY) / 2.0;
            g2d.setPaint(new GradientPaint(0.0f, (float)vertical, Color.white, 0.0f, (float)endY, color, true));
        } else if (GradientType == GradientEnum.Top_left_to_bottom_right) {
            g2d.setPaint(new GradientPaint((float)startX, (float)startY, Color.white, (float)endX, (float)endY, color, true));
        } else if (GradientType == GradientEnum.Right) {
            g2d.setPaint(new GradientPaint((float)startX, (float)(startY + (endY - startY) / 2.0), Color.white, (float)endX, (float)(startY + (endY - startY) / 2.0), color, true));
        } else if (GradientType == GradientEnum.Bottom_left_to_top_right) {
            g2d.setPaint(new GradientPaint((float)startX, (float)endY, Color.white, (float)endX, (float)startY, color, true));
        } else if (GradientType == GradientEnum.Up) {
            g2d.setPaint(new GradientPaint((float)(startX + (endX - startX) / 2.0), (float)endY, Color.white, (float)(startX + (endX - startX) / 2.0), (float)startY, color, true));
        } else if (GradientType == GradientEnum.Bottom_right_to_top_left) {
            g2d.setPaint(new GradientPaint((float)endX, (float)endY, Color.white, (float)startX, (float)startY, color, true));
        } else if (GradientType == GradientEnum.Left) {
            g2d.setPaint(new GradientPaint((float)endX, (float)(startY + (endY - startY) / 2.0), Color.white, (float)startX, (float)(startY + (endY - startY) / 2.0), color, true));
        } else if (GradientType == GradientEnum.Top_right_to_bottom_left) {
            g2d.setPaint(new GradientPaint((float)endX, (float)startY, Color.white, (float)startX, (float)endY, color, true));
        } else if (GradientType == GradientEnum.Down) {
            g2d.setPaint(new GradientPaint((float)(startX + (endX - startX) / 2.0), (float)startY, Color.white, (float)(startX + (endX - startX) / 2.0), (float)endY, color, true));
        } else if (GradientType == GradientEnum.Center_to_Border) {
            float[] dist = new float[]{0.0f, 0.2f, 1.0f};
            Color[] colors = new Color[]{color, color, Color.WHITE};
            Point2D.Float center = new Point2D.Float((float)(startX + (endX - startX) / 2.0), (float)(startY + (endY - startY) / 2.0));
            double r = 0.0;
            if (endX - startX == endY - startY) {
                r = (endY - startY) / 2.0;
            } else if (endX - startX < endY - startY) {
                r = (endY - startY) / 2.0;
            } else if (endX - startX > endY - startY) {
                r = (endX - startX) / 2.0;
            }
            g2d.setPaint(new RadialGradientPaint(center, (float)((int)r), dist, colors, MultipleGradientPaint.CycleMethod.NO_CYCLE));
        } else if (GradientType == GradientEnum.Center) {
            float[] dist = new float[]{0.0f, 0.2f, 1.0f};
            Color[] colors = new Color[]{Color.WHITE, Color.WHITE, color};
            Point2D.Float center = new Point2D.Float((float)(startX + (endX - startX) / 2.0), (float)(startY + (endY - startY) / 2.0));
            double r = 0.0;
            if (endX - startX == endY - startY) {
                r = (endY - startY) / 2.0;
            } else if (endX - startX < endY - startY) {
                r = (endY - startY) / 2.0;
            } else if (endX - startX > endY - startY) {
                r = (endX - startX) / 2.0;
            }
            g2d.setPaint(new RadialGradientPaint(center, (float)((int)r), dist, colors, MultipleGradientPaint.CycleMethod.NO_CYCLE));
        } else if (GradientType == GradientEnum.Vertical) {
            g2d.setPaint(new GradientPaint((float)(startX + (endX - startX) / 2.0), 0.0f, Color.white, (float)endX, 0.0f, this.getGrayColor(color), true));
        } else if (GradientType == GradientEnum.Horizontal) {
            g2d.setPaint(new GradientPaint(0.0f, (float)(startY + (endY - startY) / 2.0), Color.white, 0.0f, (float)endY, this.getGrayColor(color), true));
        }
    }

    public PolygonXY getBracketXY(double startX, double startY, double endX, double endY, ShapeEnum shapeType, int angle) {
        PolygonXY pgxyscale = new PolygonXY();
        pgxyscale.angle = angle;
        double radius = 0.0;
        double centerX = startX + (endX - startX) / 2.0;
        double centerY = startY + (endY - startY) / 2.0;
        double zeroAngleX = 0.0;
        double zeroAngleY = 0.0;
        double scaleX = 1.0;
        double scaleY = 1.0;
        int itype = 1;
        if (endX - startX == endY - startY) {
            radius = (endX - startX) / 2.0;
            zeroAngleX = endX;
            zeroAngleY = centerY;
            itype = 1;
            scaleX = 1.0;
            scaleY = 1.0;
        } else if (endX - startX <= endY - startY) {
            radius = (endX - startX) / 2.0;
            zeroAngleX = centerX + radius;
            zeroAngleY = centerY;
            itype = 2;
            scaleX = 1.0;
            scaleY = (endY - startY) / (endX - startX);
        } else if (endX - startX >= endY - startY) {
            radius = (endY - startY) / 2.0;
            zeroAngleX = centerX + radius;
            zeroAngleY = centerY;
            itype = 3;
            scaleX = (endX - startX) / (endY - startY);
            scaleY = 1.0;
        }
        double arcx = 0.0;
        double arcy = 0.0;
        double initangle = 0.0;
        double inputangle = -Math.PI * (double)angle / 180.0;
        double arcangle = 0.0;
        if (shapeType == ShapeEnum.SquareBracket || shapeType == ShapeEnum.Brace) {
            initangle = 0.0;
            pgxyscale.x = new int[4];
            pgxyscale.y = new int[4];
            for (int i = 0; i <= 3; ++i) {
                double r;
                if (i == 3) {
                    r = Math.sqrt(Math.pow(centerX - endX, 2.0) + Math.pow(centerY - startY, 2.0));
                    initangle = Math.atan((endY - startY) / 2.0 / ((endX - startX) / 2.0));
                    arcangle = initangle + inputangle;
                    zeroAngleX = centerX + r;
                    zeroAngleY = centerY;
                    arcx = (zeroAngleX - centerX) * Math.cos(arcangle) - (zeroAngleY - centerY) * Math.sin(arcangle) + centerX;
                    arcy = -1.0 * (zeroAngleX - centerX) * Math.sin(arcangle) + (zeroAngleY - centerY) * Math.cos(arcangle) + centerY;
                } else if (i == 0) {
                    r = Math.sqrt(Math.pow(centerX - startX, 2.0) + Math.pow(centerY - startY, 2.0));
                    initangle = 1.5707963267948966 + Math.atan((endX - startX) / 2.0 / ((endY - startY) / 2.0));
                    arcangle = initangle + inputangle;
                    zeroAngleX = centerX + r;
                    zeroAngleY = centerY;
                    arcx = (zeroAngleX - centerX) * Math.cos(arcangle) - (zeroAngleY - centerY) * Math.sin(arcangle) + centerX;
                    arcy = -1.0 * (zeroAngleX - centerX) * Math.sin(arcangle) + (zeroAngleY - centerY) * Math.cos(arcangle) + centerY;
                } else if (i == 1) {
                    r = Math.sqrt(Math.pow(centerX - startX, 2.0) + Math.pow(centerY - endY, 2.0));
                    initangle = Math.PI + Math.atan((endY - startY) / 2.0 / ((endX - startX) / 2.0));
                    arcangle = initangle + inputangle;
                    zeroAngleX = centerX + r;
                    zeroAngleY = centerY;
                    arcx = (zeroAngleX - centerX) * Math.cos(arcangle) - (zeroAngleY - centerY) * Math.sin(arcangle) + centerX;
                    arcy = -1.0 * (zeroAngleX - centerX) * Math.sin(arcangle) + (zeroAngleY - centerY) * Math.cos(arcangle) + centerY;
                } else if (i == 2) {
                    r = Math.sqrt(Math.pow(centerX - endX, 2.0) + Math.pow(centerY - endY, 2.0));
                    initangle = 4.71238898038469 + Math.atan((endX - startX) / 2.0 / ((endY - startY) / 2.0));
                    arcangle = initangle + inputangle;
                    zeroAngleX = centerX + r;
                    zeroAngleY = centerY;
                    arcx = (zeroAngleX - centerX) * Math.cos(arcangle) - (zeroAngleY - centerY) * Math.sin(arcangle) + centerX;
                    arcy = -1.0 * (zeroAngleX - centerX) * Math.sin(arcangle) + (zeroAngleY - centerY) * Math.cos(arcangle) + centerY;
                }
                pgxyscale.x[i] = (int)arcx;
                pgxyscale.y[i] = (int)arcy;
                pgxyscale.pointcount = 4;
            }
        }
        return pgxyscale;
    }

    private Area drawBracket(int vertical, int horizontal, int centerx, int centery, int wide, int angle, Color color, Graphics2D g2d, ShapeEnum shapeType, boolean isActive, int strokesize) {
        int high = 3;
        if (shapeType == ShapeEnum.SquareBracket) {
            high = 3;
        } else if (shapeType == ShapeEnum.Brace) {
            high = 5;
        }
        wide = 10;
        centerx = 50;
        centery = 50;
        Stroke stroke = g2d.getStroke();
        vertical = -vertical;
        int startx = 0;
        boolean starty = false;
        int endx = 0;
        boolean endy = false;
        int startX = 0;
        int startY = 0;
        int endX = 0;
        int endY = 0;
        int centerX = 0;
        int centerY = 0;
        startx = centerx - wide;
        endx = centerx + wide;
        startX = (int)((double)(15 - wide * 8 / 2) * this.RATE);
        endX = (int)((double)(15 + wide * 8 / 2) * this.RATE);
        startY = (int)((-this.DOMAIN_HEIGHT - 50.0 - (double)(high * 8 / 2)) * (double)this.rate);
        endY = (int)((-this.DOMAIN_HEIGHT - 50.0 + (double)(high * 8 / 2)) * (double)this.rate);
        Color colorbk = this.getGrayColor(color);
        float thick = strokesize;
        if (isActive) {
            float[] dash1 = new float[]{5.0f};
            g2d.setStroke(new BasicStroke(1.0f, 1, 1, 20.0f, dash1, 0.0f));
        } else {
            g2d.setStroke(new BasicStroke(thick, 1, 1));
        }
        PolygonXY pgxy = null;
        startY = (int)((float)(vertical - centery) * this.rate) - high;
        endY = (int)((float)(vertical - centery) * this.rate) + high;
        centerX = startX + (endX - startX) / 2;
        centerY = startY + (endY - startY) / 2;
        g2d.setColor(colorbk);
        if (shapeType == ShapeEnum.SquareBracket) {
            pgxy = this.getBracketXY(startX, startY, endX, endY, shapeType, angle);
            pgxy.CacuMinMaxXY();
            g2d.drawPolyline(pgxy.x, pgxy.y, pgxy.pointcount);
        } else if (shapeType == ShapeEnum.Brace) {
            pgxy = this.getBracketXY(startX, startY - 2 * high, endX, endY + 2 * high, shapeType, angle);
            pgxy.CacuMinMaxXY();
            int cx = 0;
            int cy = 0;
            int cw = 0;
            int ch = 0;
            int startang = 0;
            int endang = 0;
            GeneralPath clipShape = new GeneralPath();
            cx = startX;
            cy = startY;
            cw = 2 * high;
            ch = 2 * high;
            startang = 180;
            endang = 90;
            Arc2D.Double arc1 = new Arc2D.Double(cx, cy, cw, ch, startang, endang, 0);
            clipShape.append(arc1, false);
            int cstartx = 0;
            int cstarty = 0;
            int cendx = 0;
            int cendy = 0;
            cstartx = startX + high;
            cstarty = endY;
            cendx = startX + (endX - startX) / 2 - high;
            cendy = endY;
            Line2D.Double ld1 = new Line2D.Double(cstartx, cstarty, cendx, cendy);
            clipShape.append(ld1, false);
            cx = startX + (endX - startX) / 2 - 2 * high;
            cy = endY;
            cw = 2 * high;
            ch = 2 * high;
            startang = 0;
            endang = 90;
            Arc2D.Double arc2 = new Arc2D.Double(cx, cy, cw, ch, startang, endang, 0);
            clipShape.append(arc2, false);
            cx = startX + (endX - startX) / 2;
            cy = endY;
            cw = 2 * high;
            ch = 2 * high;
            startang = 90;
            endang = 90;
            Arc2D.Double arc3 = new Arc2D.Double(cx, cy, cw, ch, startang, endang, 0);
            clipShape.append(arc3, false);
            cstartx = startX + (endX - startX) / 2 + high;
            cstarty = endY;
            cendx = endX - high;
            cendy = endY;
            Line2D.Double ld2 = new Line2D.Double(cstartx, cstarty, cendx, cendy);
            clipShape.append(ld2, false);
            cx = endX - 2 * high;
            cy = startY;
            cw = 2 * high;
            ch = 2 * high;
            startang = 270;
            endang = 90;
            Arc2D.Double arc4 = new Arc2D.Double(cx, cy, cw, ch, startang, endang, 0);
            clipShape.append(arc4, false);
            double angle1 = Math.PI * 2 * (double)angle / 360.0;
            AffineTransform rectTransform = AffineTransform.getRotateInstance(0.0, centerX, centerY);
            rectTransform.setToRotation(angle1, centerX, centerY);
            Shape shape = clipShape.createTransformedShape(rectTransform);
            clipShape.reset();
            clipShape.append(shape, false);
            g2d.draw(clipShape);
            clipShape.closePath();
        }
        g2d.setStroke(stroke);
        Area sa = null;
        sa = new Area(pgxy.minx, pgxy.miny, pgxy.maxx, pgxy.maxy);
        return sa;
    }

    private Area drawPolygon(int vertical, int horizontal, int centerx, int centery, int wide, int high, int angle, String name, DrawTypeEnum nameDrawType, int size, Color color, Graphics2D g2d, ShapeEnum shapeType, boolean isActive, int strokesize, GradientEnum GradientType, String SelectTextureFile) {
        Stroke stroke = g2d.getStroke();
        int startX = 0;
        int startY = 0;
        int endX = 0;
        int endY = 0;
        wide = 5;
        high = 5;
        startX = (int)((double)(15 - wide * 8 / 2) * this.RATE);
        endX = (int)((double)(15 + wide * 8 / 2) * this.RATE);
        startY = (int)((-this.DOMAIN_HEIGHT - 50.0 - (double)(high * 8 / 2)) * (double)this.rate);
        endY = (int)((-this.DOMAIN_HEIGHT - 50.0 + (double)(high * 8 / 2)) * (double)this.rate);
        PolygonXY pgxy = new PolygonXY();
        pgxy.getPolygonXY(startX, startY, endX, endY, shapeType.name().toString(), angle, this.rate);
        pgxy.CacuMinMaxXY();
        Color colorbk = new Color(0, 0, 0);
        this.drawPolygonTextureRect(g2d, startX, startY, endX, endY, pgxy, SelectTextureFile, stroke, color, colorbk, GradientType, shapeType, strokesize, isActive, high);
        Area sa = null;
        sa = new Area(pgxy.minx, pgxy.miny, pgxy.maxx, pgxy.maxy);
        return sa;
    }

    private int[][] getDelColors(int[] _fromColor, int _height) {
        int li_d1;
        int[][] delColor = new int[_height][3];
        int li_half = _height / 2;
        if (li_half == 0) {
            li_half = 1;
        }
        if ((li_d1 = 100 / li_half) == 0) {
            li_d1 = 1;
        }
        int li_prefix = 57;
        for (int i = li_half - 1; i >= 0; --i) {
            delColor[i][0] = li_prefix + (li_half - 1 - i) * li_d1;
            delColor[i][1] = li_prefix + (li_half - 1 - i) * li_d1;
            delColor[i][2] = li_prefix + (li_half - 1 - i) * li_d1;
        }
        int li_d2 = (int)((double)(100 / li_half) * 0.7);
        if (li_d2 == 0) {
            li_d2 = 1;
        }
        for (int i = li_half; i < _height; ++i) {
            delColor[i][0] = (i - li_half) * li_d2;
            delColor[i][1] = (i - li_half) * li_d2;
            delColor[i][2] = (i - li_half) * li_d2;
        }
        return delColor;
    }

    public void drawCrystal(Graphics2D g2d, double startX, double startY, double endX, double endY, Color color) {
        int li_width = (int)(endX - startX);
        int li_height = (int)(endY - startY);
        Color bgColor = color;
        int[] li_fromcolor = new int[]{bgColor.getRed(), bgColor.getGreen(), bgColor.getBlue()};
        int[][] li_delcolors = this.getDelColors(li_fromcolor, li_height - 1);
        for (int i = 0; i < li_delcolors.length; ++i) {
            int li_r = li_fromcolor[0] + li_delcolors[i][0];
            int li_g = li_fromcolor[1] + li_delcolors[i][1];
            int li_b = li_fromcolor[2] + li_delcolors[i][2];
            if (li_r > 255) {
                li_r = 255;
            }
            if (li_g > 255) {
                li_g = 255;
            }
            if (li_b > 255) {
                li_b = 255;
            }
            g2d.setColor(new Color(li_r, li_g, li_b));
            g2d.fillRect((int)startX + 1, (int)startY + i + 1, li_width - 2, 1);
        }
    }

    private void drawSite(String positionStr, boolean isShowPosition, Color color, String SelectTextureFile, GradientEnum gradient, ShapeEnum shapetype, Color colorbk, Color colorline, Graphics2D g2d) {
        String text = "Site";
        int height = 40;
        if (!Mode.equals("P")) {
            this.DOMAIN_HEIGHT = 0.0;
        }
        int size = 12;
        double centralX = 0.0;
        double centralY = 0.0;
        height += this.lineHeight;
        g2d.setFont(new Font("Arial", 1, this.fontsize + (size - 12)));
        StringTokenizer st = new StringTokenizer(positionStr, ";");
        int siteCount = st.countTokens();
        if (siteCount == 1) {
            int site = 100;
            centralX = (this.DOMAIN_X + (double)site) * this.RATE;
            centralY = (-this.DOMAIN_HEIGHT / 2.0 - (double)height) * this.RATE;
            Line2D.Double positionline = new Line2D.Double(centralX, -this.DOMAIN_HEIGHT / 2.0 * this.RATE, centralX, centralY);
            g2d.setColor(colorline);
            g2d.draw(positionline);
            g2d.setColor(colorbk);
            if (isShowPosition) {
                g2d.drawString(String.valueOf(site), (float)(centralX + 2.0), (float)(-this.DOMAIN_HEIGHT / 2.0 * this.RATE - 2.0));
            }
            g2d.setColor(colorbk);
            if (shapetype == ShapeEnum.Null) {
                g2d.drawString(text, (float)(centralX - (double)g2d.getFontMetrics().stringWidth(text) / 2.0), (float)(centralY - 2.0 * this.RATE));
            }
        } else {
            LinkedList<Integer> siteList = new LinkedList<Integer>();
            if (siteCount > 6) {
                siteCount = 6;
            }
            for (int i = 1; i <= siteCount; ++i) {
                siteList.add(i * 30);
            }
            Collections.sort(siteList);
            int centralSite = (Integer.parseInt(String.valueOf(siteList.getFirst())) + Integer.parseInt(String.valueOf(siteList.getLast()))) / 2;
            g2d.setColor(colorline);
            centralX = (this.DOMAIN_X + (double)centralSite) * this.RATE;
            centralY = (-this.DOMAIN_HEIGHT / 2.0 - (double)height) * this.RATE;
            Iterator iter = siteList.iterator();
            while (iter.hasNext()) {
                int site = Integer.parseInt(String.valueOf(iter.next()));
                Line2D.Double positionline = new Line2D.Double((this.DOMAIN_X + (double)site) * this.RATE, -this.DOMAIN_HEIGHT / 2.0 * this.RATE, (this.DOMAIN_X + (double)site) * this.RATE, (-this.DOMAIN_HEIGHT / 2.0 - (double)this.lineHeight) * this.RATE);
                g2d.draw(positionline);
                Line2D.Double directLine = new Line2D.Double((this.DOMAIN_X + (double)site) * this.RATE, (-this.DOMAIN_HEIGHT / 2.0 - (double)this.lineHeight) * this.RATE, centralX, centralY);
                g2d.draw(directLine);
                g2d.setColor(colorbk);
                if (!isShowPosition) continue;
                g2d.drawString(String.valueOf(site), (float)((this.DOMAIN_X + (double)site) * this.RATE + 2.0), (float)(-this.DOMAIN_HEIGHT / 2.0 * this.RATE - 2.0));
            }
            g2d.setColor(colorbk);
            if (shapetype == ShapeEnum.Null) {
                g2d.drawString(text, (float)(centralX - (double)g2d.getFontMetrics().stringWidth(text) / 2.0), (float)(centralY - 2.0 * this.RATE));
            }
        }
        g2d.setFont(new Font("Arial", 1, this.fontsize));
        if (shapetype != ShapeEnum.Null) {
            int startx = 0;
            int starty = 0;
            int endx = 0;
            int endy = 0;
            int wide = 20;
            int high = 20;
            startx = (int)centralX - wide;
            starty = (int)centralY - high;
            endx = (int)centralX + wide;
            endy = (int)centralY + high;
            PolygonXY pgxy = new PolygonXY();
            pgxy.getPolygonXY(startx, starty, endx, endy, shapetype.name().toString(), 0.0, this.rate);
            pgxy.CacuMinMaxXY();
            this.drawPolygonTextureRect(g2d, startx, starty, endx, endy, pgxy, SelectTextureFile, g2d.getStroke(), color, colorline, gradient, shapetype, 1, false, high);
            g2d.setColor(colorbk);
            g2d.drawString(text, (float)(centralX - (double)g2d.getFontMetrics().stringWidth(text) / 2.0), (float)(centralY + 5.0));
        }
    }

    private void drawNote(DrawTypeEnum style, String angle, Color color, Graphics2D g2d) {
        String note = "Note Text";
        int distance = 30;
        int size = 14;
        g2d.setColor(color);
        if (style == DrawTypeEnum.Bold) {
            g2d.setFont(new Font("Arial", 1, this.fontsize + (size - 12)));
        } else if (style == DrawTypeEnum.Italic) {
            g2d.setFont(new Font("Arial", 2, this.fontsize + (size - 12)));
        } else if (style == DrawTypeEnum.Plain) {
            g2d.setFont(new Font("Arial", 0, this.fontsize + (size - 12)));
        } else if (style == DrawTypeEnum.Bold_Italic) {
            g2d.setFont(new Font("Arial", 3, this.fontsize + (size - 12)));
        }
        FontMetrics noteFontMetrics = g2d.getFontMetrics();
        double centralX = 0.0;
        double centralY = -(this.DOMAIN_HEIGHT / 2.0 + (double)distance) * this.RATE;
        if (angle.equals("90")) {
            g2d.rotate(-1.5707963267948966, centralX, centralY);
            g2d.drawString(note, (float)(centralX - (double)noteFontMetrics.stringWidth(note) / 2.0), (float)(centralY + (double)noteFontMetrics.getHeight() / 4.0));
            g2d.rotate(1.5707963267948966, centralX, centralY);
            g2d.setFont(new Font("Arial", 1, this.fontsize));
        } else if (angle.equals("45")) {
            g2d.rotate(-0.7853981633974483, centralX, centralY);
            g2d.drawString(note, (float)(centralX - (double)noteFontMetrics.stringWidth(note) / 2.0), (float)(centralY + (double)noteFontMetrics.getHeight() / 4.0));
            g2d.rotate(0.7853981633974483, centralX, centralY);
        } else if (angle.equals("135")) {
            g2d.rotate(-2.356194490192345, centralX, centralY);
            g2d.drawString(note, (float)(centralX - (double)noteFontMetrics.stringWidth(note) / 2.0), (float)(centralY + (double)noteFontMetrics.getHeight() / 4.0));
            g2d.rotate(2.356194490192345, centralX, centralY);
        } else if (angle.equals("-135")) {
            g2d.rotate(2.356194490192345, centralX, centralY);
            g2d.drawString(note, (float)(centralX - (double)noteFontMetrics.stringWidth(note) / 2.0), (float)(centralY + (double)noteFontMetrics.getHeight() / 4.0));
            g2d.rotate(-2.356194490192345, centralX, centralY);
        } else if (angle.equals("-90")) {
            g2d.rotate(1.5707963267948966, centralX, centralY);
            g2d.drawString(note, (float)(centralX - (double)noteFontMetrics.stringWidth(note) / 2.0), (float)(centralY + (double)noteFontMetrics.getHeight() / 4.0));
            g2d.rotate(-1.5707963267948966, centralX, centralY);
        } else if (angle.equals("-45")) {
            g2d.rotate(0.7853981633974483, centralX, centralY);
            g2d.drawString(note, (float)(centralX - (double)noteFontMetrics.stringWidth(note) / 2.0), (float)(centralY + (double)noteFontMetrics.getHeight() / 4.0));
            g2d.rotate(-0.7853981633974483, centralX, centralY);
        } else if (angle.equals("0")) {
            g2d.drawString(note, (float)(centralX - (double)noteFontMetrics.stringWidth(note) / 2.0), (float)(centralY + (double)noteFontMetrics.getHeight() / 4.0));
        }
        g2d.setFont(new Font("Arial", 1, this.fontsize));
    }

    private void drawLine(DrawTypeEnum lineType, Color color, Graphics2D g2d, ShapeEnum shapeType) {
        int startX = -100;
        int startY = -30;
        int endX = 20;
        int endY = -30;
        g2d.setColor(color);
        Color ac = Color.BLUE;
        Color pc = new Color(0, 255, 0);
        if (shapeType == ShapeEnum.Straight) {
            Line2D.Double line = new Line2D.Double(startX, startY, endX, endY);
            g2d.draw(line);
            if (lineType == DrawTypeEnum.Arrow) {
                this.drawArrow(g2d, startX, startY, endX, endY);
            } else if (lineType == DrawTypeEnum.DoubleArrow) {
                this.drawArrow(g2d, startX, startY, endX, endY);
                this.drawArrow(g2d, endX, endY, startX, startY);
            } else if (lineType == DrawTypeEnum.Scale) {
                this.drawScale(g2d, startX, startY, endX, endY);
                this.drawScale(g2d, endX, endY, startX, startY);
            } else if (lineType == DrawTypeEnum.ScaleArrow) {
                this.drawArrow(g2d, startX, startY, endX, endY);
                this.drawArrow(g2d, endX, endY, startX, startY);
                this.drawScale(g2d, (int)((float)startX - 4.0f * this.rate), startY, (int)((float)endX + 4.0f * this.rate), endY);
                this.drawScale(g2d, (int)((float)endX + 4.0f * this.rate), endY, (int)((float)startX - 4.0f * this.rate), startY);
            }
        } else if (shapeType == ShapeEnum.PolylineOne) {
            int Control1X = startX + (endX - startX) / 2;
            int Control1Y = -60;
            GeneralPath path = new GeneralPath();
            path.moveTo(startX, startY);
            path.lineTo(Control1X, Control1Y);
            path.lineTo(endX, endY);
            g2d.draw(path);
            if (lineType == DrawTypeEnum.Arrow) {
                this.drawArrow(g2d, startX, startY, Control1X, Control1Y);
            } else if (lineType == DrawTypeEnum.DoubleArrow) {
                this.drawArrow(g2d, startX, startY, Control1X, Control1Y);
                this.drawArrow(g2d, endX, endY, Control1X, Control1Y);
            } else if (lineType == DrawTypeEnum.Scale) {
                this.drawScale(g2d, startX, startY, Control1X, Control1Y);
                this.drawScale(g2d, endX, endY, Control1X, Control1Y);
            } else if (lineType == DrawTypeEnum.ScaleArrow) {
                this.drawArrow(g2d, startX, startY, Control1X, Control1Y);
                this.drawArrow(g2d, endX, endY, Control1X, Control1Y);
                this.drawScale(g2d, (int)((float)startX - 4.0f * this.rate), startY, (int)((float)endX + 4.0f * this.rate), endY);
                this.drawScale(g2d, (int)((float)endX + 4.0f * this.rate), endY, (int)((float)startX - 4.0f * this.rate), startY);
            }
        } else if (shapeType == ShapeEnum.Curve) {
            int Control1X = startX + (endX - startX) / 2;
            int Control1Y = -60;
            QuadCurve2D.Double q = new QuadCurve2D.Double(startX, startY, Control1X, Control1Y, endX, endY);
            g2d.draw(q);
            if (lineType == DrawTypeEnum.Arrow) {
                this.drawArrow(g2d, startX, startY, Control1X, Control1Y);
            } else if (lineType == DrawTypeEnum.DoubleArrow) {
                this.drawArrow(g2d, startX, startY, Control1X, Control1Y);
                this.drawArrow(g2d, endX, endY, Control1X, Control1Y);
            } else if (lineType == DrawTypeEnum.Scale) {
                this.drawScale(g2d, startX, startY, Control1X, Control1Y);
                this.drawScale(g2d, endX, endY, Control1X, Control1Y);
            } else if (lineType == DrawTypeEnum.ScaleArrow) {
                this.drawArrow(g2d, startX, startY, Control1X, Control1Y);
                this.drawArrow(g2d, endX, endY, Control1X, Control1Y);
                this.drawScale(g2d, (int)((float)startX - 4.0f * this.rate), startY, (int)((float)endX + 4.0f * this.rate), endY);
                this.drawScale(g2d, (int)((float)endX + 4.0f * this.rate), endY, (int)((float)startX - 4.0f * this.rate), startY);
            }
        } else if (shapeType == ShapeEnum.PolylineTwo) {
            int Control1X = startX + (endX - startX) / 3;
            int Control1Y = -60;
            int Control2X = startX + (endX - startX) * 2 / 3;
            int Control2Y = 0;
            GeneralPath path = new GeneralPath();
            path.moveTo(startX, startY);
            path.lineTo(Control1X, Control1Y);
            path.lineTo(Control2X, Control2Y);
            path.lineTo(endX, endY);
            g2d.draw(path);
            if (lineType == DrawTypeEnum.Arrow) {
                this.drawArrow(g2d, startX, startY, Control1X, Control1Y);
            } else if (lineType == DrawTypeEnum.DoubleArrow) {
                this.drawArrow(g2d, startX, startY, Control1X, Control1Y);
                this.drawArrow(g2d, endX, endY, Control2X, Control2Y);
            } else if (lineType == DrawTypeEnum.Scale) {
                this.drawScale(g2d, startX, startY, Control1X, Control1Y);
                this.drawScale(g2d, endX, endY, Control2X, Control2Y);
            } else if (lineType == DrawTypeEnum.ScaleArrow) {
                this.drawArrow(g2d, startX, startY, Control1X, Control1Y);
                this.drawArrow(g2d, endX, endY, Control2X, Control2Y);
                this.drawScale(g2d, (int)((float)startX - 4.0f * this.rate), startY, (int)((float)endX + 4.0f * this.rate), endY);
                this.drawScale(g2d, (int)((float)endX + 4.0f * this.rate), endY, (int)((float)startX - 4.0f * this.rate), startY);
            }
        } else if (shapeType == ShapeEnum.Bezier) {
            int Control1X = startX + (endX - startX) / 3;
            int Control1Y = -60;
            int Control2X = startX + (endX - startX) * 2 / 3;
            int Control2Y = 0;
            CubicCurve2D.Double q = new CubicCurve2D.Double(startX, startY, Control1X, Control1Y, Control2X, Control2Y, endX, endY);
            g2d.draw(q);
            if (lineType == DrawTypeEnum.Arrow) {
                this.drawArrow(g2d, startX, startY, Control1X, Control1Y);
            } else if (lineType == DrawTypeEnum.DoubleArrow) {
                this.drawArrow(g2d, startX, startY, Control1X, Control1Y);
                this.drawArrow(g2d, endX, endY, Control2X, Control2Y);
            } else if (lineType == DrawTypeEnum.Scale) {
                this.drawScale(g2d, startX, startY, Control1X, Control1Y);
                this.drawScale(g2d, endX, endY, Control2X, Control2Y);
            } else if (lineType == DrawTypeEnum.ScaleArrow) {
                this.drawArrow(g2d, startX, startY, Control1X, Control1Y);
                this.drawArrow(g2d, endX, endY, Control2X, Control2Y);
                this.drawScale(g2d, (int)((float)startX - 4.0f * this.rate), startY, (int)((float)endX + 4.0f * this.rate), endY);
                this.drawScale(g2d, (int)((float)endX + 4.0f * this.rate), endY, (int)((float)startX - 4.0f * this.rate), startY);
            }
        }
    }

    private void drawScale(Graphics2D g2d, int x1, int y1, int x2, int y2) {
        double D = Math.abs(Point2D.distance(x1, y1, x2, y2));
        int arrowLen = 6;
        double xA = (double)x1 - (double)(arrowLen * (y2 - y1)) / D;
        double yA = (double)y1 + (double)(arrowLen * (x2 - x1)) / D;
        double xB = (double)x1 + (double)(arrowLen * (y2 - y1)) / D;
        double yB = (double)y1 - (double)(arrowLen * (x2 - x1)) / D;
        Line2D.Double line = new Line2D.Double(xA, yA, xB, yB);
        g2d.draw(line);
    }

    private void drawArrow(Graphics2D g2d, int x1, int y1, int x2, int y2) {
        GeneralPath filledTrigon = new GeneralPath();
        double D = Math.abs(Point2D.distance(x1, y1, x2, y2));
        int arrowLen = 10;
        double xA = (double)x1 + (double)arrowLen * ((double)(x2 - x1) + (double)(y2 - y1) / 3.0) / D;
        double yA = (double)y1 + (double)arrowLen * ((double)(y2 - y1) - (double)(x2 - x1) / 3.0) / D;
        double xB = (double)x1 + (double)arrowLen * ((double)(x2 - x1) - (double)(y2 - y1) / 3.0) / D;
        double yB = (double)y1 + (double)arrowLen * ((double)(y2 - y1) + (double)(x2 - x1) / 3.0) / D;
        filledTrigon.moveTo(x1, y1);
        filledTrigon.lineTo((float)xA, (float)yA);
        filledTrigon.moveTo(x1, y1);
        filledTrigon.lineTo((float)xB, (float)yB);
        g2d.draw(filledTrigon);
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        g2d.translate(this.getSize().width / 2, this.getSize().height / 2);
        this.drawComponent(g2d);
    }

    private void initComponents() {
        this.setBackground(new Color(255, 255, 255));
        this.setLayout(new BorderLayout());
    }

    static {
        Mode = "";
    }
}

