/*
 * Decompiled with CFR 0.152.
 */
package gui.ibs;

import gui.Tools;
import gui.ibs.Component;
import gui.ibs.CustomComboBoxDemo;
import gui.ibs.GradientEnum;
import gui.ibs.PreviewPanel;
import gui.ibs.Protein;
import gui.ibs.ResourceBundleUtil;
import gui.ibs.Verifier;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.LinkedList;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;

public class ProteinDialog
extends JDialog {
    public String DELIMIT = "#&%";
    public Protein protein;
    public GradientEnum gradientType;
    public String mode = "";
    ResourceBundleUtil config;
    public boolean bModify = false;
    private JButton cancelButton;
    private JLabel colorLabel;
    private JPanel colorLine;
    private JPanel colorPanel;
    private CustomComboBoxDemo comBoxGradient;
    private JComboBox endComboBox;
    private JLabel endLabel;
    private JTextField endTextField;
    private JLabel fontLabel;
    private JLabel fontLabel1;
    private JLabel fontLabel2;
    private JLabel fontLabel3;
    private JLabel fontLabel4;
    private JTextField fontTextField;
    private JLabel heightLabel;
    private JTextField heightTextField;
    private JLabel horizontalLabel;
    private JTextField horizontalTextField;
    private JCheckBox jCheckBoxBorderDash;
    private JLabel jLabel1;
    private JLabel jLabel11;
    private JLabel jLabel2;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel8;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JSpinner jSpinnerlineSize;
    private JTextField jTextFieldID;
    private JCheckBox lockCheckBox;
    private JPanel mainPanel;
    private JButton okButton;
    private JPanel previewPanel;
    private JComboBox startComboBox;
    private JLabel startLabel;
    private JTextField startTextField;
    private CustomComboBoxDemo texturechoose;
    private JLabel verticalLabel;
    private JTextField verticalTextField;

    public ProteinDialog(Frame parent, String title, boolean modal, ImageIcon[] images, ImageIcon[] imagesGradient, String mode, String strNum) {
        super(parent, title, modal);
        this.mode = mode;
        this.setPreferredSize(new Dimension(780, 590));
        this.config = ResourceBundleUtil.getBundle("gui.ibs.config");
        this.initComponents();
        this.setTitle("");
        this.endTextField.requestFocus();
        this.texturechoose.ProteinDialog20 = this;
        this.texturechoose.setComImages(images, "Text");
        this.comBoxGradient.ProteinDialog20 = this;
        this.comBoxGradient.setComImages(imagesGradient, "Gradient");
        if (mode.equals("P")) {
            this.heightTextField.setText(this.config.getString("ProteinDialog.protein.height"));
            this.texturechoose.SelectTextureFile = this.config.getString("ProteinDialog.protein.texture.SelectTextureFile");
            this.texturechoose.setComboBoxIndex();
            this.comBoxGradient.SelectTextureFile = this.config.getString("ProteinDialog.protein.gradient");
            this.jTextFieldID.setText(strNum);
        } else {
            this.heightTextField.setText(this.config.getString("ProteinDialog.nucleotide.height"));
            this.colorPanel.setBackground(Color.BLACK);
            this.texturechoose.SelectTextureFile = this.config.getString("ProteinDialog.nucleotide.texture.SelectTextureFile");
            this.texturechoose.setComboBoxIndex();
            this.comBoxGradient.SelectTextureFile = this.config.getString("ProteinDialog.nucleotide.gradient");
            this.jTextFieldID.setText(strNum);
        }
        Color bc = new Color(204, 204, 204);
        this.jTextFieldID.setForeground(bc);
        this.previewDraw();
        this.endTextField.requestFocus();
        this.enableEvents(8L);
        InputMap inputMap = this.rootPane.getInputMap(2);
        inputMap.put(KeyStroke.getKeyStroke("ESCAPE"), "ESCAPE");
        this.rootPane.getActionMap().put("ESCAPE", new AbstractAction("ESCAPE"){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProteinDialog.this.cancelButton.doClick();
            }
        });
        inputMap.put(KeyStroke.getKeyStroke("ENTER"), "ENTER");
        this.rootPane.getActionMap().put("ENTER", new AbstractAction("ENTER"){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProteinDialog.this.okButton.doClick();
            }
        });
    }

    public Protein getProtein() {
        return this.protein;
    }

    public void setVertical(int vertical) {
        this.verticalTextField.setText(String.valueOf(vertical));
    }

    public void changeGradient() {
        if (this.texturechoose.SelectTextureFile.equals("00000_0.jpg") || this.texturechoose.SelectTextureFile.equals("00001.jpg") || this.texturechoose.SelectTextureFile.equals("00001_d.jpg") || this.texturechoose.SelectTextureFile.equals("00002.jpg") || this.texturechoose.SelectTextureFile.equals("00002_d.jpg") || this.texturechoose.SelectTextureFile.equals("00003.jpg") || this.texturechoose.SelectTextureFile.equals("00003_d.jpg") || this.texturechoose.SelectTextureFile.equals("00004.jpg") || this.texturechoose.SelectTextureFile.equals("00004_d.jpg") || this.texturechoose.SelectTextureFile.equals("00005.jpg") || this.texturechoose.SelectTextureFile.equals("00005_d.jpg") || this.texturechoose.SelectTextureFile.equals("00006.jpg") || !this.texturechoose.SelectTextureFile.equals("00006_d.jpg")) {
            // empty if block
        }
    }

    public void setProtein(Protein protein) {
        String[] arr = protein.getParameter().split(this.DELIMIT);
        this.startTextField.setText(arr[0]);
        this.startComboBox.setSelectedItem(arr[1]);
        this.endTextField.setText(arr[2]);
        this.endComboBox.setSelectedItem(arr[3]);
        this.heightTextField.setText(arr[4]);
        this.colorPanel.setBackground(protein.getColor());
        String proteinColorLineStr = arr[10];
        StringTokenizer ster = new StringTokenizer(proteinColorLineStr, ",");
        Color proteinLineColor = new Color(Integer.parseInt(ster.nextToken()), Integer.parseInt(ster.nextToken()), Integer.parseInt(ster.nextToken()));
        this.colorLine.setBackground(proteinLineColor);
        this.fontTextField.setText(arr[5]);
        if (arr.length > 6) {
            this.comBoxGradient.SelectTextureFile = arr[6];
            this.comBoxGradient.setComboBoxIndex();
            this.texturechoose.SelectTextureFile = arr[7];
            this.jCheckBoxBorderDash.setSelected(Boolean.valueOf(arr[8]));
        } else {
            this.comBoxGradient.SelectTextureFile = "Default";
            this.comBoxGradient.setComboBoxIndex();
            this.texturechoose.SelectTextureFile = "00000_0.jpg";
            this.jCheckBoxBorderDash.setSelected(false);
        }
        this.texturechoose.setComboBoxIndex();
        this.verticalTextField.setText(String.valueOf(protein.getVertical()));
        this.horizontalTextField.setText(String.valueOf(protein.getHorizontal()));
        this.lockCheckBox.setSelected(protein.isLocked());
        this.jSpinnerlineSize.setValue(Integer.valueOf(arr[9]));
        if (!arr[11].trim().equals("") && arr[11].trim() != null) {
            this.jTextFieldID.setText(arr[11]);
            this.jTextFieldID.setForeground(Color.BLACK);
        }
        this.previewDraw();
    }

    public void previewDraw() {
        if (this.comBoxGradient.SelectTextureFile.equals("00000_1.jpg")) {
            this.gradientType = GradientEnum.Null;
        } else {
            String strGradient = this.comBoxGradient.SelectTextureFile;
            if (strGradient.indexOf(".") > 0) {
                strGradient = strGradient.substring(0, strGradient.indexOf("."));
            }
            this.gradientType = GradientEnum.valueOf(strGradient);
        }
        String parameter = 1 + this.DELIMIT + this.startComboBox.getSelectedItem() + this.DELIMIT + 200 + this.DELIMIT + this.endComboBox.getSelectedItem() + this.DELIMIT + this.heightTextField.getText().trim() + this.DELIMIT + this.fontTextField.getText().trim() + this.DELIMIT + this.gradientType.name().toString() + this.DELIMIT + this.texturechoose.SelectTextureFile + this.DELIMIT + this.jCheckBoxBorderDash.isSelected() + this.DELIMIT + this.jSpinnerlineSize.getValue() + this.DELIMIT + this.colorLine.getBackground().getRed() + "," + this.colorLine.getBackground().getGreen() + "," + this.colorLine.getBackground().getBlue() + this.DELIMIT + "id";
        PreviewPanel.Mode = this.mode;
        PreviewPanel.protein = new Protein(0, 0, this.lockCheckBox.isSelected(), 200, parameter, this.colorPanel.getBackground(), new LinkedList<Component>());
        this.previewPanel.repaint();
    }

    private void initComponents() {
        this.previewPanel = new PreviewPanel();
        this.mainPanel = new JPanel();
        this.jPanel2 = new JPanel();
        this.startLabel = new JLabel();
        this.startTextField = new JTextField();
        this.startComboBox = new JComboBox();
        this.jLabel1 = new JLabel();
        this.endLabel = new JLabel();
        this.endTextField = new JTextField();
        this.endComboBox = new JComboBox();
        this.jLabel2 = new JLabel();
        this.heightLabel = new JLabel();
        this.heightTextField = new JTextField();
        this.verticalLabel = new JLabel();
        this.verticalTextField = new JTextField();
        this.horizontalLabel = new JLabel();
        this.horizontalTextField = new JTextField();
        this.lockCheckBox = new JCheckBox();
        this.jLabel8 = new JLabel();
        this.jPanel1 = new JPanel();
        this.colorLabel = new JLabel();
        this.colorPanel = new JPanel();
        this.fontLabel2 = new JLabel();
        this.comBoxGradient = new CustomComboBoxDemo();
        this.fontLabel3 = new JLabel();
        this.texturechoose = new CustomComboBoxDemo();
        this.fontLabel = new JLabel();
        this.fontTextField = new JTextField();
        this.jPanel3 = new JPanel();
        this.fontLabel4 = new JLabel();
        this.jSpinnerlineSize = new JSpinner();
        this.jCheckBoxBorderDash = new JCheckBox();
        this.jLabel5 = new JLabel();
        this.fontLabel1 = new JLabel();
        this.colorLine = new JPanel();
        this.jLabel6 = new JLabel();
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        this.jPanel4 = new JPanel();
        this.jLabel11 = new JLabel();
        this.jTextFieldID = new JTextField();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(560, 320));
        this.setResizable(false);
        this.previewPanel.setBorder(BorderFactory.createTitledBorder(null, "Preview", 0, 0, new Font("Arial", 1, 14)));
        this.previewPanel.setMinimumSize(new Dimension(280, 300));
        this.previewPanel.setPreferredSize(new Dimension(280, 440));
        this.previewPanel.setLayout(new BorderLayout());
        this.getContentPane().add((java.awt.Component)this.previewPanel, "Center");
        this.mainPanel.setBorder(BorderFactory.createTitledBorder(null, "Option", 0, 0, new Font("Arial", 1, 14)));
        this.mainPanel.setMinimumSize(new Dimension(450, 300));
        this.mainPanel.setPreferredSize(new Dimension(450, 440));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(null, "Position", 0, 0, new Font("Arial", 1, 12)));
        this.jPanel2.setMinimumSize(new Dimension(310, 130));
        this.jPanel2.setPreferredSize(new Dimension(310, 130));
        this.jPanel2.setLayout(new GridLayout(4, 4, 10, 10));
        this.startLabel.setFont(new Font("Arial", 1, 12));
        this.startLabel.setHorizontalAlignment(4);
        this.startLabel.setText("Start");
        this.jPanel2.add(this.startLabel);
        this.startTextField.setHorizontalAlignment(0);
        this.startTextField.setText("1");
        this.jPanel2.add(this.startTextField);
        this.startComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Down", "Up", "Hide"}));
        this.startComboBox.setSelectedIndex(2);
        this.startComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ProteinDialog.this.startComboBoxItemStateChanged(evt);
            }
        });
        this.jPanel2.add(this.startComboBox);
        this.jLabel1.setFont(new Font("Arial", 1, 12));
        this.jLabel1.setHorizontalAlignment(4);
        this.jLabel1.setToolTipText("");
        this.jPanel2.add(this.jLabel1);
        this.endLabel.setFont(new Font("Arial", 1, 12));
        this.endLabel.setHorizontalAlignment(4);
        this.endLabel.setText("End");
        this.jPanel2.add(this.endLabel);
        this.endTextField.setHorizontalAlignment(0);
        this.endTextField.setFocusCycleRoot(true);
        this.jPanel2.add(this.endTextField);
        this.endComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Down", "Up", "Hide"}));
        this.endComboBox.setSelectedIndex(2);
        this.endComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ProteinDialog.this.endComboBoxItemStateChanged(evt);
            }
        });
        this.jPanel2.add(this.endComboBox);
        this.jLabel2.setFont(new Font("Arial", 1, 12));
        this.jLabel2.setHorizontalAlignment(4);
        this.jLabel2.setToolTipText("");
        this.jPanel2.add(this.jLabel2);
        this.heightLabel.setFont(new Font("Arial", 1, 12));
        this.heightLabel.setHorizontalAlignment(4);
        this.heightLabel.setText("Height");
        this.jPanel2.add(this.heightLabel);
        this.heightTextField.setHorizontalAlignment(0);
        this.heightTextField.setText("25");
        this.heightTextField.setToolTipText("");
        this.jPanel2.add(this.heightTextField);
        this.verticalLabel.setFont(new Font("Arial", 1, 12));
        this.verticalLabel.setHorizontalAlignment(4);
        this.verticalLabel.setText("Vertical");
        this.jPanel2.add(this.verticalLabel);
        this.verticalTextField.setHorizontalAlignment(0);
        this.verticalTextField.setText("0");
        this.jPanel2.add(this.verticalTextField);
        this.horizontalLabel.setFont(new Font("Arial", 1, 12));
        this.horizontalLabel.setHorizontalAlignment(4);
        this.horizontalLabel.setText("Horizontal");
        this.jPanel2.add(this.horizontalLabel);
        this.horizontalTextField.setHorizontalAlignment(0);
        this.horizontalTextField.setText("0");
        this.jPanel2.add(this.horizontalTextField);
        this.lockCheckBox.setFont(new Font("Arial", 1, 12));
        this.lockCheckBox.setSelected(true);
        this.lockCheckBox.setText("Locked");
        this.lockCheckBox.setCursor(new Cursor(0));
        this.lockCheckBox.setHorizontalAlignment(2);
        this.jPanel2.add(this.lockCheckBox);
        this.jPanel2.add(this.jLabel8);
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(null, "Style", 0, 0, new Font("Arial", 1, 12)));
        this.jPanel1.setLayout(new GridLayout(2, 4, 10, 10));
        this.colorLabel.setFont(new Font("Arial", 1, 12));
        this.colorLabel.setHorizontalAlignment(4);
        this.colorLabel.setText("Color");
        this.jPanel1.add(this.colorLabel);
        this.colorPanel.setBackground(Color.gray);
        this.colorPanel.setBorder(BorderFactory.createBevelBorder(0));
        this.colorPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                ProteinDialog.this.colorPanelMousePressed(evt);
            }
        });
        this.jPanel1.add(this.colorPanel);
        this.fontLabel2.setFont(new Font("Arial", 1, 12));
        this.fontLabel2.setHorizontalAlignment(4);
        this.fontLabel2.setText("Gradient");
        this.fontLabel2.setToolTipText("");
        this.jPanel1.add(this.fontLabel2);
        this.jPanel1.add(this.comBoxGradient);
        this.fontLabel3.setFont(new Font("Arial", 1, 12));
        this.fontLabel3.setHorizontalAlignment(4);
        this.fontLabel3.setText("Texture");
        this.fontLabel3.setToolTipText("");
        this.jPanel1.add(this.fontLabel3);
        this.jPanel1.add(this.texturechoose);
        this.fontLabel.setFont(new Font("Arial", 1, 12));
        this.fontLabel.setHorizontalAlignment(4);
        this.fontLabel.setText("Font Size");
        this.jPanel1.add(this.fontLabel);
        this.fontTextField.setHorizontalAlignment(0);
        this.fontTextField.setText("12");
        this.jPanel1.add(this.fontTextField);
        this.jPanel3.setBorder(BorderFactory.createTitledBorder(null, "Border", 0, 0, new Font("Arial", 1, 12)));
        this.jPanel3.setLayout(new GridLayout(2, 4, 10, 10));
        this.fontLabel4.setFont(new Font("Arial", 1, 12));
        this.fontLabel4.setHorizontalAlignment(4);
        this.fontLabel4.setText("Line Size");
        this.jPanel3.add(this.fontLabel4);
        this.jSpinnerlineSize.setModel(new SpinnerNumberModel(1, 1, 5, 1));
        this.jPanel3.add(this.jSpinnerlineSize);
        this.jCheckBoxBorderDash.setFont(new Font("Arial", 1, 12));
        this.jCheckBoxBorderDash.setText("Dash");
        this.jCheckBoxBorderDash.setHorizontalAlignment(2);
        this.jPanel3.add(this.jCheckBoxBorderDash);
        this.jLabel5.setFont(new Font("Arial", 1, 12));
        this.jLabel5.setHorizontalAlignment(4);
        this.jPanel3.add(this.jLabel5);
        this.fontLabel1.setFont(new Font("Arial", 1, 12));
        this.fontLabel1.setHorizontalAlignment(4);
        this.fontLabel1.setText("Line Color");
        this.jPanel3.add(this.fontLabel1);
        this.colorLine.setBackground(Color.black);
        this.colorLine.setBorder(BorderFactory.createBevelBorder(0));
        this.colorLine.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                ProteinDialog.this.colorLineMousePressed(evt);
            }
        });
        this.jPanel3.add(this.colorLine);
        this.jPanel3.add(this.jLabel6);
        this.cancelButton.setFont(new Font("Arial", 1, 12));
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProteinDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.okButton.setFont(new Font("Arial", 1, 12));
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProteinDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.jPanel4.setBorder(BorderFactory.createTitledBorder(null, "", 0, 0, new Font("Arial", 1, 12)));
        this.jLabel11.setFont(new Font("\u5b8b\u4f53", 1, 12));
        this.jLabel11.setHorizontalAlignment(2);
        this.jLabel11.setText("ID");
        this.jLabel11.setPreferredSize(new Dimension(40, 15));
        this.jPanel4.add(this.jLabel11);
        this.jTextFieldID.setForeground(new Color(255, 255, 255));
        this.jTextFieldID.setPreferredSize(new Dimension(250, 25));
        this.jTextFieldID.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                ProteinDialog.this.jTextFieldIDFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                ProteinDialog.this.jTextFieldIDFocusLost(evt);
            }
        });
        this.jTextFieldID.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                ProteinDialog.this.jTextFieldIDKeyPressed(evt);
            }
        });
        this.jPanel4.add(this.jTextFieldID);
        GroupLayout mainPanelLayout = new GroupLayout(this.mainPanel);
        this.mainPanel.setLayout(mainPanelLayout);
        mainPanelLayout.setHorizontalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addContainerGap().addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel4, -1, 430, Short.MAX_VALUE).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jPanel3, -1, 430, Short.MAX_VALUE).addComponent(this.jPanel1, -1, 430, Short.MAX_VALUE).addComponent(this.jPanel2, -1, 430, Short.MAX_VALUE))).addContainerGap()).addGroup(GroupLayout.Alignment.TRAILING, mainPanelLayout.createSequentialGroup().addComponent(this.cancelButton, -2, 107, -2).addGap(54, 54, 54).addComponent(this.okButton, -2, 107, -2).addGap(61, 61, 61)))));
        mainPanelLayout.setVerticalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, mainPanelLayout.createSequentialGroup().addComponent(this.jPanel4, -1, 36, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -2, 191, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -2, 121, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel3, -2, 103, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton, -2, 30, -2).addComponent(this.okButton, -2, 30, -2)).addGap(50, 50, 50)));
        this.getContentPane().add((java.awt.Component)this.mainPanel, "East");
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.bModify = true;
        boolean isStartValiable = new Verifier().verify(this.startTextField);
        boolean isEndValiable = new Verifier().verify(this.endTextField);
        boolean isHeightValiable = new Verifier().verify(this.heightTextField);
        boolean isFontSizeValiable = new Verifier().verify(this.fontTextField);
        boolean isVerticalValiable = new Verifier().isInteger(this.verticalTextField);
        boolean isHorizontalValiable = new Verifier().isInteger(this.horizontalTextField);
        StringBuffer errorSb = new StringBuffer();
        if (!isStartValiable) {
            errorSb.append("Start : should be a positive integer \n");
        }
        if (!isEndValiable) {
            errorSb.append("End : should be a positive integer \n");
        }
        if (!isHeightValiable) {
            errorSb.append("Height : should be a positive integer \n");
        }
        if (!isFontSizeValiable) {
            errorSb.append("Font Size : should be a positive integer \n");
        }
        if (!isVerticalValiable) {
            errorSb.append("Vertical Position: should be an integer \n");
        }
        if (!isHorizontalValiable) {
            errorSb.append("Horizontal Position : should be an integer \n");
        }
        if (isStartValiable && isEndValiable && isHeightValiable && isFontSizeValiable && isVerticalValiable && isHorizontalValiable) {
            if (this.comBoxGradient.SelectTextureFile.equals("00000_1.jpg")) {
                this.gradientType = GradientEnum.Null;
            } else {
                String strGradient = this.comBoxGradient.SelectTextureFile;
                if (strGradient.indexOf(".") > 0) {
                    strGradient = strGradient.substring(0, strGradient.indexOf("."));
                }
                this.gradientType = GradientEnum.valueOf(strGradient);
            }
            String fid = " ";
            fid = this.jTextFieldID.getText();
            String parameter = this.startTextField.getText().trim() + this.DELIMIT + this.startComboBox.getSelectedItem() + this.DELIMIT + this.endTextField.getText().trim() + this.DELIMIT + this.endComboBox.getSelectedItem() + this.DELIMIT + this.heightTextField.getText().trim() + this.DELIMIT + this.fontTextField.getText().trim() + this.DELIMIT + this.gradientType.name().toString() + this.DELIMIT + this.texturechoose.SelectTextureFile + this.DELIMIT + this.jCheckBoxBorderDash.isSelected() + this.DELIMIT + this.jSpinnerlineSize.getValue() + this.DELIMIT + this.colorLine.getBackground().getRed() + "," + this.colorLine.getBackground().getGreen() + "," + this.colorLine.getBackground().getBlue() + this.DELIMIT + fid;
            this.protein = new Protein(Integer.parseInt(this.verticalTextField.getText()), Integer.parseInt(this.horizontalTextField.getText()), this.lockCheckBox.isSelected(), Integer.parseInt(this.endTextField.getText()), parameter, this.colorPanel.getBackground(), new LinkedList<Component>());
            this.dispose();
        } else {
            JOptionPane.showConfirmDialog(this, errorSb.toString(), "Properties Error", -1, 0, null);
        }
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void colorLineMousePressed(MouseEvent evt) {
        final JColorChooser jColorChooser = new JColorChooser();
        jColorChooser.setColor(this.colorLine.getBackground());
        Tools.WindowCenter(JColorChooser.createDialog(this, "Color Choose", true, jColorChooser, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color color = jColorChooser.getColor();
                ProteinDialog.this.colorLine.setBackground(color);
                ProteinDialog.this.previewDraw();
            }
        }, null));
    }

    private void colorPanelMousePressed(MouseEvent evt) {
        final JColorChooser jColorChooser = new JColorChooser();
        jColorChooser.setColor(this.colorPanel.getBackground());
        Tools.WindowCenter(JColorChooser.createDialog(this, "Color Choose", true, jColorChooser, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color color = jColorChooser.getColor();
                ProteinDialog.this.colorPanel.setBackground(color);
                ProteinDialog.this.previewDraw();
            }
        }, null));
    }

    private void endComboBoxItemStateChanged(ItemEvent evt) {
        this.previewDraw();
    }

    private void startComboBoxItemStateChanged(ItemEvent evt) {
        this.previewDraw();
    }

    private void jTextFieldIDKeyPressed(KeyEvent evt) {
    }

    private void jTextFieldIDFocusGained(FocusEvent evt) {
    }

    private void jTextFieldIDFocusLost(FocusEvent evt) {
    }
}

