/*
 * Decompiled with CFR 0.152.
 */
package gui.ibs;

import gui.ibs.LocaleUtil;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Formatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

public class ResourceBundleUtil
implements Serializable {
    private static final HashSet<String> acceleratorKeys = new HashSet<String>(Arrays.asList("shift", "control", "ctrl", "meta", "alt", "altGraph"));
    private transient ResourceBundle resource;
    private Locale locale;
    private Class baseClass = this.getClass();
    private String baseName;
    private static boolean isVerbose = false;
    private static HashMap<String, String[]> propertyNameModifiers = new HashMap();

    public ResourceBundleUtil(String baseName, Locale locale) {
        this.locale = locale;
        this.baseName = baseName;
        this.resource = ResourceBundle.getBundle(baseName, locale);
    }

    public ResourceBundle getWrappedBundle() {
        return this.resource;
    }

    public String getString(String key) {
        try {
            String value = this.getStringRecursive(key);
            return value;
        }
        catch (MissingResourceException e) {
            if (isVerbose) {
                System.err.println("Warning ResourceBundleUtil[" + this.baseName + "] \"" + key + "\" not found.");
            }
            return key;
        }
    }

    private String getStringRecursive(String key) throws MissingResourceException {
        int p2;
        String value = this.resource.getString(key);
        int p1 = value.indexOf("${");
        while (p1 != -1 && (p2 = value.indexOf(125, p1 + 2)) != -1) {
            String placeholderFormat;
            String placeholderKey = value.substring(p1 + 2, p2);
            int p3 = placeholderKey.indexOf(44);
            if (p3 != -1) {
                placeholderFormat = placeholderKey.substring(p3 + 1);
                placeholderKey = placeholderKey.substring(0, p3);
            } else {
                placeholderFormat = "string";
            }
            ArrayList<String> fallbackKeys = new ArrayList<String>();
            this.generateFallbackKeys(placeholderKey, fallbackKeys);
            String placeholderValue = null;
            for (String fk : fallbackKeys) {
                try {
                    placeholderValue = this.getStringRecursive(fk);
                    break;
                }
                catch (MissingResourceException missingResourceException) {
                }
            }
            if (placeholderValue == null) {
                throw new MissingResourceException("\"" + key + "\" not found in " + this.baseName, this.baseName, key);
            }
            if (placeholderFormat.equals("accelerator")) {
                StringBuilder b = new StringBuilder();
                for (String s : placeholderValue.split(" ")) {
                    if (acceleratorKeys.contains(s)) {
                        b.append(this.getString("accelerator." + s));
                        continue;
                    }
                    b.append(s);
                }
                placeholderValue = b.toString();
            }
            value = value.substring(0, p1) + placeholderValue + value.substring(p2 + 1);
            p1 = value.indexOf("${");
        }
        return value;
    }

    private void generateFallbackKeys(String key, ArrayList<String> fallbackKeys) {
        int p1 = key.indexOf("[$");
        if (p1 == -1) {
            fallbackKeys.add(key);
        } else {
            int p2 = key.indexOf(93, p1 + 2);
            if (p2 == -1) {
                return;
            }
            String modifierKey = key.substring(p1 + 2, p2);
            String[] modifierValues = propertyNameModifiers.get(modifierKey);
            if (modifierValues == null) {
                modifierValues = new String[]{"default"};
            }
            for (String mv : modifierValues) {
                this.generateFallbackKeys(key.substring(0, p1) + mv + key.substring(p2 + 1), fallbackKeys);
            }
        }
    }

    public String getFormatted(String key, Object ... arguments) {
        return MessageFormat.format(this.getString(key), arguments);
    }

    public String format(String key, Object ... arguments) {
        return new Formatter(this.resource.getLocale()).format(this.getString(key), arguments).toString();
    }

    public Integer getInteger(String key) {
        try {
            return Integer.valueOf(this.getStringRecursive(key));
        }
        catch (MissingResourceException e) {
            if (isVerbose) {
                System.err.println("Warning ResourceBundleUtil[" + this.baseName + "] \"" + key + "\" not found.");
            }
            return -1;
        }
    }

    public ImageIcon getIconProperty(String key, Class baseClass) {
        try {
            String rsrcName = this.getStringRecursive(key + ".icon");
            if (rsrcName.equals("")) {
                return null;
            }
            URL url = baseClass.getResource(rsrcName);
            if (isVerbose && url == null) {
                System.err.println("Warning ResourceBundleUtil[" + this.baseName + "].getIconProperty \"" + key + ".icon\" resource:" + rsrcName + " not found.");
            }
            return url == null ? null : new ImageIcon(url);
        }
        catch (MissingResourceException e) {
            if (isVerbose) {
                System.err.println("Warning ResourceBundleUtil[" + this.baseName + "].getIconProperty \"" + key + ".icon\" not found.");
            }
            return null;
        }
    }

    public char getMnemonic(String key) {
        String s = this.getStringRecursive(key);
        return s == null || s.length() == 0 ? (char)'\u0000' : s.charAt(0);
    }

    public char getMnemonicProperty(String key) {
        String s;
        try {
            s = this.getStringRecursive(key + ".mnemonic");
        }
        catch (MissingResourceException e) {
            if (isVerbose) {
                System.err.println("Warning ResourceBundleUtil[" + this.baseName + "] \"" + key + ".mnemonic\" not found.");
            }
            s = null;
        }
        return s == null || s.length() == 0 ? (char)'\u0000' : s.charAt(0);
    }

    public String getToolTipTextProperty(String key) {
        try {
            String value = this.getStringRecursive(key + ".toolTipText");
            return value;
        }
        catch (MissingResourceException e) {
            if (isVerbose) {
                System.err.println("Warning ResourceBundleUtil[" + this.baseName + "] \"" + key + ".toolTipText\" not found.");
            }
            return null;
        }
    }

    public String getTextProperty(String key) {
        try {
            String value = this.getStringRecursive(key + ".text");
            return value;
        }
        catch (MissingResourceException e) {
            if (isVerbose) {
                System.err.println("Warning ResourceBundleUtil[" + this.baseName + "] \"" + key + ".text\" not found.");
            }
            return null;
        }
    }

    public KeyStroke getKeyStroke(String key) {
        KeyStroke ks = null;
        try {
            String s = this.getStringRecursive(key);
            ks = s == null ? (KeyStroke)null : KeyStroke.getKeyStroke(s);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return ks;
    }

    public KeyStroke getAcceleratorProperty(String key) {
        KeyStroke ks = null;
        try {
            String s = this.getStringRecursive(key + ".accelerator");
            ks = s == null ? (KeyStroke)null : KeyStroke.getKeyStroke(s);
        }
        catch (MissingResourceException e) {
            if (isVerbose) {
                System.err.println("Warning ResourceBundleUtil[" + this.baseName + "] \"" + key + ".accelerator\" not found.");
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return ks;
    }

    public static ResourceBundleUtil getBundle(String baseName) throws MissingResourceException {
        return ResourceBundleUtil.getBundle(baseName, LocaleUtil.getDefault());
    }

    public void setBaseClass(Class baseClass) {
        this.baseClass = baseClass;
    }

    public Class getBaseClass() {
        return this.baseClass;
    }

    public void configureAction(Action action, String argument) {
        this.configureAction(action, argument, this.getBaseClass());
    }

    public void configureAction(Action action, String argument, Class baseClass) {
        action.putValue("Name", this.getTextProperty(argument));
        String shortDescription = this.getToolTipTextProperty(argument);
        if (shortDescription != null && shortDescription.length() > 0) {
            action.putValue("ShortDescription", shortDescription);
        }
        action.putValue("AcceleratorKey", this.getAcceleratorProperty(argument));
        action.putValue("MnemonicKey", this.getMnemonicProperty(argument));
        action.putValue("SmallIcon", this.getIconProperty(argument, baseClass));
    }

    public void configureButton(AbstractButton button, String argument) {
        this.configureButton(button, argument, this.getBaseClass());
    }

    public void configureButton(AbstractButton button, String argument, Class baseClass) {
        button.setText(this.getTextProperty(argument));
        button.setIcon(this.getIconProperty(argument, baseClass));
        button.setToolTipText(this.getToolTipTextProperty(argument));
    }

    public void configureToolBarButton(AbstractButton button, String argument) {
        this.configureToolBarButton(button, argument, this.getBaseClass());
    }

    public void configureToolBarButton(AbstractButton button, String argument, Class baseClass) {
        ImageIcon icon = this.getIconProperty(argument, baseClass);
        if (icon != null) {
            button.setIcon(this.getIconProperty(argument, baseClass));
            button.setText(null);
        } else {
            button.setIcon(null);
            button.setText(this.getTextProperty(argument));
        }
        button.setToolTipText(this.getToolTipTextProperty(argument));
    }

    public void configureMenu(JMenuItem menu, String argument) {
        menu.setText(this.getTextProperty(argument));
        if (!(menu instanceof JMenu)) {
            menu.setAccelerator(this.getAcceleratorProperty(argument));
        }
        menu.setMnemonic(this.getMnemonicProperty(argument));
        menu.setIcon(this.getIconProperty(argument, this.baseClass));
    }

    public JMenuItem createMenuItem(Action a, String baseName) {
        JMenuItem mi = new JMenuItem();
        mi.setAction(a);
        this.configureMenu(mi, baseName);
        return mi;
    }

    public static ResourceBundleUtil getBundle(String baseName, Locale locale) throws MissingResourceException {
        ResourceBundleUtil r = new ResourceBundleUtil(baseName, locale);
        return r;
    }

    public String toString() {
        return super.toString() + "[" + this.baseName + ", " + this.resource + "]";
    }

    public static void setVerbose(boolean newValue) {
        isVerbose = newValue;
    }

    public static boolean isVerbose() {
        return isVerbose;
    }

    public static void putPropertyNameModifier(String name, String ... fallbackChain) {
        propertyNameModifiers.put(name, fallbackChain);
    }

    public static void removePropertyNameModifier(String name) {
        propertyNameModifiers.remove(name);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.resource = ResourceBundle.getBundle(this.baseName, this.locale);
    }

    static {
        String osName = System.getProperty("os.name").toLowerCase();
        String os = osName.startsWith("mac os x") ? "mac" : (osName.startsWith("windows") ? "win" : "other");
        propertyNameModifiers.put("os", new String[]{os, "default"});
    }
}

