/*
 * Decompiled with CFR 0.152.
 */
package gui.ibs;

import gui.Tools;
import gui.ibs.CanvasPanel;
import gui.ibs.CustomComboBoxDemo;
import gui.ibs.DemoFrame;
import gui.ibs.IBSFrame;
import gui.ibs.Project;
import gui.ibs.Project2XML;
import gui.ibs.Protein;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.URL;
import java.util.Arrays;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;

public class WorkingModeDialog
extends JDialog {
    public static ImageIcon[] images;
    public static ImageIcon[] imagesShape;
    public static ImageIcon[] imagesShapeSite;
    public static ImageIcon[] imagesShapeMarker;
    public static ImageIcon[] imagesGradient;
    public static ImageIcon[] imagesShapeCutLine;
    public String[] petStrings;
    public String[] petStringsShape;
    public String[] petStringsGradient;
    public CanvasPanel pcanvasPanel = new CanvasPanel();
    public CanvasPanel ncanvasPanel = new CanvasPanel();
    public static String[] nameShape;
    public static String[] nameShapeMarker;
    public static String[] promptShape;
    public static String[] nameGradient;
    public static String[] promptGradient;
    private ButtonGroup buttonGroup1;
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButton3;
    private JButton jButton4;
    private JButton jButton5;
    private JButton jButton6;
    private JButton jButtonDemo;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JRadioButton jRadioButtonNucleic;
    private JRadioButton jRadioButtonProtein;
    private JScrollPane ncanvasScrollPanel;
    private JScrollPane pcanvasScrollPanel;

    public static ImageIcon[] getImagesShapeCutLine() {
        return imagesShapeCutLine;
    }

    public static void setImagesShapeCutLine(ImageIcon[] imagesShapeCutLine) {
        WorkingModeDialog.imagesShapeCutLine = imagesShapeCutLine;
    }

    public String[] getPetStringsGradient() {
        return this.petStringsGradient;
    }

    public void setPetStringsGradient(String[] petStringsGradient) {
        this.petStringsGradient = petStringsGradient;
    }

    public String[] getPetStringsShape() {
        return this.petStringsShape;
    }

    public void setPetStringsShape(String[] petStringsShape) {
        this.petStringsShape = petStringsShape;
    }

    public WorkingModeDialog(Frame parent, boolean modal) {
        this.initComponents();
        this.setPreferredSize(new Dimension(750, 680));
        this.pcanvasScrollPanel.setPreferredSize(new Dimension(100, 30));
        this.pcanvasPanel.setPreferredSize(new Dimension(100, 30));
        this.pcanvasScrollPanel.setSize(100, 30);
        this.pcanvasPanel.setSize(100, 30);
        this.buttonGroup1.add(this.jRadioButtonProtein);
        this.buttonGroup1.add(this.jRadioButtonNucleic);
        this.loadTextImages();
        this.loadShapeImages();
        this.loadShapeCutLineImages();
        this.loadGradientImages();
        Tools.WindowCenter(this);
        this.jRadioButtonProtein.setSelected(true);
        this.ncanvasPanel.addMouseListener(new NMouseHandle());
        this.pcanvasPanel.addMouseListener(new PMouseHandle());
    }

    public static ImageIcon[] getImages() {
        return images;
    }

    public static void setImages(ImageIcon[] images) {
        WorkingModeDialog.images = images;
    }

    public void loadTextImages() {
        String strRealPath;
        File objFile;
        int ilen;
        String absolutePath = "";
        Class<?> c = this.getClass();
        absolutePath = Tools.getAppPath(c) + "/";
        if (absolutePath.indexOf("build/classes") >= 0) {
            absolutePath = "";
        }
        if ((ilen = (objFile = new File(strRealPath = absolutePath + "texture/")).listFiles().length) <= 0) {
            return;
        }
        File[] array = new File[ilen];
        array = objFile.listFiles();
        this.petStrings = new String[array.length];
        images = new ImageIcon[array.length];
        Integer[] intArray = new Integer[array.length];
        Object[] arrayStr = new String[array.length];
        arrayStr = objFile.list();
        Arrays.sort(arrayStr);
        for (int i = 0; i < arrayStr.length; ++i) {
            this.petStrings[i] = "";
            intArray[i] = new Integer(i);
            WorkingModeDialog.images[i] = WorkingModeDialog.createImageIcon("texture/" + (String)arrayStr[i]);
            if (images[i] == null) continue;
            images[i].setDescription((String)arrayStr[i]);
        }
    }

    public void loadShapeImages() {
        imagesShape = new ImageIcon[nameShape.length - 1];
        imagesShapeSite = new ImageIcon[nameShape.length - 1];
        imagesShapeMarker = new ImageIcon[nameShape.length - 2];
        this.petStringsShape = new String[nameShape.length];
        for (int i = 0; i < nameShape.length - 2; ++i) {
            WorkingModeDialog.imagesShapeSite[i] = WorkingModeDialog.createImageIconFromURL("image/shape/" + nameShape[i] + ".gif");
            if (imagesShapeSite[i] != null) {
                imagesShapeSite[i].setDescription(nameShape[i]);
                this.petStringsShape[i] = promptShape[i];
            }
            WorkingModeDialog.imagesShape[i] = WorkingModeDialog.createImageIconFromURL("image/shape/" + nameShape[i] + ".gif");
            if (imagesShape[i] != null) {
                imagesShape[i].setDescription(nameShape[i]);
                this.petStringsShape[i] = promptShape[i];
            }
            WorkingModeDialog.imagesShapeMarker[i] = WorkingModeDialog.createImageIconFromURL("image/shape/" + nameShape[i] + ".gif");
            if (imagesShapeMarker[i] == null) continue;
            imagesShapeMarker[i].setDescription(nameShape[i]);
            this.petStringsShape[i] = promptShape[i];
        }
        WorkingModeDialog.imagesShapeSite[WorkingModeDialog.nameShape.length - 2] = WorkingModeDialog.createImageIconFromURL("image/shape/Null.gif");
        if (imagesShapeSite[nameShape.length - 2] != null) {
            imagesShapeSite[nameShape.length - 2].setDescription("Null");
            this.petStringsShape[WorkingModeDialog.nameShape.length - 2] = "Null";
        }
        WorkingModeDialog.imagesShape[WorkingModeDialog.nameShape.length - 2] = WorkingModeDialog.createImageIconFromURL("image/shape/Cylinder.gif");
        if (imagesShape[nameShape.length - 2] != null) {
            imagesShape[nameShape.length - 2].setDescription("Cylinder");
            this.petStringsShape[WorkingModeDialog.nameShape.length - 2] = "Cylinder";
        }
    }

    public void loadShapeCutLineImages() {
        imagesShapeCutLine = new ImageIcon[4];
        WorkingModeDialog.imagesShapeCutLine[0] = WorkingModeDialog.createImageIconFromURL("image/shape/L_ParallelLine.gif");
        imagesShapeCutLine[0].setDescription("Line-Left");
        WorkingModeDialog.imagesShapeCutLine[1] = WorkingModeDialog.createImageIconFromURL("image/shape/R_ParallelLine.gif");
        imagesShapeCutLine[1].setDescription("Line-Right");
        WorkingModeDialog.imagesShapeCutLine[2] = WorkingModeDialog.createImageIconFromURL("image/shape/L_ParallelCurve.gif");
        imagesShapeCutLine[2].setDescription("Curve-Left");
        WorkingModeDialog.imagesShapeCutLine[3] = WorkingModeDialog.createImageIconFromURL("image/shape/R_ParallelCurve.gif");
        imagesShapeCutLine[3].setDescription("Curve-Right");
    }

    public void loadGradientImages() {
        imagesGradient = new ImageIcon[nameGradient.length];
        this.petStringsGradient = new String[nameGradient.length];
        for (int i = 0; i < nameGradient.length; ++i) {
            WorkingModeDialog.imagesGradient[i] = WorkingModeDialog.createImageIconFromURL("image/gradient/" + nameGradient[i] + ".jpg");
            if (imagesGradient[i] == null) continue;
            imagesGradient[i].setDescription(nameGradient[i]);
            this.petStringsGradient[i] = promptGradient[i];
        }
    }

    protected static ImageIcon createImageIconFromURL(String path) {
        URL imgURL = CustomComboBoxDemo.class.getResource(path);
        if (imgURL != null) {
            return new ImageIcon(imgURL);
        }
        System.err.println("Couldn't find file: " + path);
        return null;
    }

    protected static ImageIcon createImageIcon(String path) {
        if (path != null) {
            return new ImageIcon(path);
        }
        System.err.println("Couldn't find file: " + path);
        return null;
    }

    private void initComponents() {
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.jButton4 = new JButton();
        this.jButton3 = new JButton();
        this.buttonGroup1 = new ButtonGroup();
        this.jPanel4 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jPanel1 = new JPanel();
        this.jPanel3 = new JPanel();
        this.jRadioButtonProtein = new JRadioButton();
        this.pcanvasScrollPanel = new JScrollPane();
        this.jPanel6 = new JPanel();
        this.jRadioButtonNucleic = new JRadioButton();
        this.ncanvasScrollPanel = new JScrollPane();
        this.jPanel5 = new JPanel();
        this.jButtonDemo = new JButton();
        this.jButton6 = new JButton();
        this.jButton5 = new JButton();
        this.jButton1.setText("jButton1");
        this.jButton2.setText("jButton2");
        this.jButton4.setText("jButton4");
        this.jButton3.setText("jButton3");
        this.setDefaultCloseOperation(2);
        this.setTitle("Working Mode");
        this.setResizable(false);
        this.getContentPane().setLayout(new BorderLayout());
        this.jLabel1.setFont(new Font("Arial", 1, 18));
        this.jLabel1.setText("Please choose a working mode");
        this.jLabel1.setToolTipText("");
        this.jPanel4.add(this.jLabel1);
        this.getContentPane().add((Component)this.jPanel4, "First");
        this.jPanel1.setPreferredSize(new Dimension(600, 400));
        this.jPanel1.setLayout(new GridLayout(2, 2));
        this.jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createTitledBorder(""), "", 0, 0, new Font("Dialog", 0, 12), Color.black));
        this.jPanel3.setPreferredSize(new Dimension(400, 300));
        this.jPanel3.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                WorkingModeDialog.this.jPanel3MouseClicked(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                WorkingModeDialog.this.jPanel3MousePressed(evt);
            }
        });
        this.jRadioButtonProtein.setFont(new Font("Arial", 1, 12));
        this.jRadioButtonProtein.setSelected(true);
        this.jRadioButtonProtein.setToolTipText("");
        this.jRadioButtonProtein.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WorkingModeDialog.this.jRadioButtonProteinActionPerformed(evt);
            }
        });
        this.pcanvasScrollPanel.getViewport().add(this.pcanvasPanel);
        this.pcanvasPanel.bCanClickContrl = false;
        this.pcanvasPanel.boot = true;
        this.pcanvasScrollPanel.setBorder(BorderFactory.createTitledBorder(null, "Protein Mode", 0, 0, new Font("Arial", 1, 18), Color.blue));
        this.pcanvasScrollPanel.setMinimumSize(new Dimension(33, 30));
        this.pcanvasScrollPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                WorkingModeDialog.this.pcanvasScrollPanelMouseClicked(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                WorkingModeDialog.this.pcanvasScrollPanelMousePressed(evt);
            }
        });
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGap(6, 6, 6).addComponent(this.jRadioButtonProtein).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pcanvasScrollPanel, -2, 672, -2).addContainerGap(26, Short.MAX_VALUE)));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGap(108, 108, 108).addComponent(this.jRadioButtonProtein)).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.pcanvasScrollPanel, -2, 251, -2))).addContainerGap(19, Short.MAX_VALUE)));
        this.jPanel1.add(this.jPanel3);
        this.jPanel6.setBorder(BorderFactory.createTitledBorder(BorderFactory.createTitledBorder(""), "", 0, 0, new Font("Dialog", 0, 12), Color.black));
        this.jPanel6.setPreferredSize(new Dimension(400, 300));
        this.jPanel6.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                WorkingModeDialog.this.jPanel6MouseClicked(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                WorkingModeDialog.this.jPanel6MousePressed(evt);
            }
        });
        this.jRadioButtonNucleic.setFont(new Font("Arial", 1, 12));
        this.jRadioButtonNucleic.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WorkingModeDialog.this.jRadioButtonNucleicActionPerformed(evt);
            }
        });
        this.ncanvasScrollPanel.getViewport().add(this.ncanvasPanel);
        this.ncanvasPanel.bCanClickContrl = false;
        this.ncanvasPanel.boot = true;
        this.ncanvasScrollPanel.setBorder(BorderFactory.createTitledBorder(null, "Nucleotide Mode", 0, 0, new Font("Arial", 1, 18), Color.blue));
        this.ncanvasScrollPanel.setMinimumSize(new Dimension(33, 30));
        this.ncanvasScrollPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                WorkingModeDialog.this.ncanvasScrollPanelMouseClicked(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                WorkingModeDialog.this.ncanvasScrollPanelMousePressed(evt);
            }
        });
        GroupLayout jPanel6Layout = new GroupLayout(this.jPanel6);
        this.jPanel6.setLayout(jPanel6Layout);
        jPanel6Layout.setHorizontalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addComponent(this.jRadioButtonNucleic).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.ncanvasScrollPanel, -2, 675, -2).addContainerGap(25, Short.MAX_VALUE)));
        jPanel6Layout.setVerticalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addGap(101, 101, 101).addComponent(this.jRadioButtonNucleic)).addGroup(GroupLayout.Alignment.TRAILING, jPanel6Layout.createSequentialGroup().addContainerGap().addComponent(this.ncanvasScrollPanel, -1, 260, Short.MAX_VALUE))).addContainerGap()));
        this.jPanel1.add(this.jPanel6);
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.jPanel5.setPreferredSize(new Dimension(60, 30));
        this.jPanel5.setLayout(null);
        this.jButtonDemo.setFont(new Font("Arial", 1, 12));
        this.jButtonDemo.setText("Demo");
        this.jButtonDemo.setMaximumSize(new Dimension(70, 23));
        this.jButtonDemo.setMinimumSize(new Dimension(70, 23));
        this.jButtonDemo.setPreferredSize(new Dimension(80, 23));
        this.jButtonDemo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WorkingModeDialog.this.jButtonDemoActionPerformed(evt);
            }
        });
        this.jPanel5.add(this.jButtonDemo);
        this.jButtonDemo.setBounds(40, 0, 80, 23);
        this.jButton6.setFont(new Font("Arial", 1, 12));
        this.jButton6.setText("Exit");
        this.jButton6.setMaximumSize(new Dimension(70, 23));
        this.jButton6.setMinimumSize(new Dimension(70, 23));
        this.jButton6.setPreferredSize(new Dimension(80, 23));
        this.jButton6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WorkingModeDialog.this.jButton6ActionPerformed(evt);
            }
        });
        this.jPanel5.add(this.jButton6);
        this.jButton6.setBounds(320, 0, 80, 23);
        this.jButton5.setFont(new Font("Arial", 1, 12));
        this.jButton5.setText("Enter");
        this.jButton5.setToolTipText("");
        this.jButton5.setMaximumSize(new Dimension(70, 23));
        this.jButton5.setMinimumSize(new Dimension(70, 23));
        this.jButton5.setPreferredSize(new Dimension(80, 23));
        this.jButton5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WorkingModeDialog.this.jButton5ActionPerformed(evt);
            }
        });
        this.jPanel5.add(this.jButton5);
        this.jButton5.setBounds(400, 0, 80, 23);
        this.getContentPane().add((Component)this.jPanel5, "Last");
        this.pack();
    }

    private void jButton6ActionPerformed(ActionEvent evt) {
        Tools.setCurrentFilePath();
        System.exit(0);
        this.dispose();
    }

    private void jButton5ActionPerformed(ActionEvent evt) {
        this.hide();
        this.dispose();
        String mode = "";
        if (this.jRadioButtonProtein.isSelected()) {
            mode = "P";
        } else if (this.jRadioButtonNucleic.isSelected()) {
            mode = "N";
        }
        IBSFrame df = new IBSFrame(mode);
        df.images = images;
        df.imagesShape = imagesShape;
        df.imagesShapeSite = imagesShapeSite;
        df.imagesShapeMarker = imagesShapeMarker;
        df.imagesGradient = imagesGradient;
        df.imagesShapeCutLine = imagesShapeCutLine;
        Tools.WindowCenter(df);
        df.setVisible(true);
    }

    private void jRadioButtonNucleicActionPerformed(ActionEvent evt) {
        this.repaint();
    }

    private void jRadioButtonProteinActionPerformed(ActionEvent evt) {
        this.repaint();
    }

    private void jPanel3MouseClicked(MouseEvent evt) {
    }

    private void jPanel6MouseClicked(MouseEvent evt) {
    }

    private void jPanel6MousePressed(MouseEvent evt) {
        this.jRadioButtonNucleic.setSelected(true);
        this.repaint();
    }

    private void jPanel3MousePressed(MouseEvent evt) {
        this.jRadioButtonProtein.setSelected(true);
        this.repaint();
    }

    private void pcanvasScrollPanelMousePressed(MouseEvent evt) {
        this.jRadioButtonProtein.setSelected(true);
        this.repaint();
    }

    private void ncanvasScrollPanelMousePressed(MouseEvent evt) {
        this.jRadioButtonNucleic.setSelected(true);
        this.repaint();
    }

    private void pcanvasScrollPanelMouseClicked(MouseEvent evt) {
        this.jRadioButtonProtein.setSelected(true);
        this.repaint();
    }

    private void ncanvasScrollPanelMouseClicked(MouseEvent evt) {
        this.jRadioButtonNucleic.setSelected(true);
        this.repaint();
    }

    private void jButtonDemoActionPerformed(ActionEvent evt) {
        String mode = "";
        mode = this.jRadioButtonProtein.isSelected() ? "P" : "N";
        Tools.WindowCenter(new DemoFrame(mode, images, imagesShape, imagesShapeSite, imagesShapeMarker, imagesGradient, imagesShapeCutLine));
    }

    public static void main(String[] args) {
    }

    public void drawMode() {
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.jRadioButtonProtein.isSelected()) {
            Project nproject;
            LinkedList<Protein> proteinList;
            Project project = new Project2XML().openDemo("P");
            if (project == null) {
                return;
            }
            if (project != null && (proteinList = project.getProteinList()).size() != 0) {
                this.pcanvasPanel.setProteinList(project.getProteinList());
                this.pcanvasPanel.bGray = false;
                this.pcanvasPanel.Mode = "P";
                this.pcanvasPanel.repaint();
            }
            if ((nproject = new Project2XML().openDemo("N")) == null) {
                return;
            }
            if (nproject != null) {
                LinkedList<Protein> proteinList2 = nproject.getProteinList();
                if (proteinList2.size() != 0) {
                    this.ncanvasPanel.setProteinList(nproject.getProteinList());
                }
                this.ncanvasPanel.bGray = true;
                this.ncanvasPanel.Mode = "N";
                this.ncanvasPanel.repaint();
            }
        } else {
            Project nproject;
            LinkedList<Protein> proteinList;
            Project project = new Project2XML().openDemo("P");
            if (project == null) {
                return;
            }
            if (project != null && (proteinList = project.getProteinList()).size() != 0) {
                this.pcanvasPanel.setProteinList(project.getProteinList());
                this.pcanvasPanel.bGray = true;
                this.pcanvasPanel.Mode = "P";
                this.pcanvasPanel.repaint();
            }
            if ((nproject = new Project2XML().openDemo("N")) == null) {
                return;
            }
            if (nproject != null) {
                LinkedList<Protein> proteinList3 = nproject.getProteinList();
                if (proteinList3.size() != 0) {
                    this.ncanvasPanel.setProteinList(nproject.getProteinList());
                }
                this.ncanvasPanel.bGray = false;
                this.ncanvasPanel.Mode = "N";
                this.ncanvasPanel.repaint();
            }
        }
    }

    public String[] getPetStrings() {
        return this.petStrings;
    }

    public void setPetStrings(String[] petStrings) {
        this.petStrings = petStrings;
    }

    public static ImageIcon[] getImagesGradient() {
        return imagesGradient;
    }

    public static void setImagesGradient(ImageIcon[] imagesGradient) {
        WorkingModeDialog.imagesGradient = imagesGradient;
    }

    public static ImageIcon[] getImagesShape() {
        return imagesShape;
    }

    public static void setImagesShape(ImageIcon[] imagesShape) {
        WorkingModeDialog.imagesShape = imagesShape;
    }

    public static ImageIcon[] getImagesShapeSite() {
        return imagesShapeSite;
    }

    public static void setImagesShapeSite(ImageIcon[] imagesShapeSite) {
        WorkingModeDialog.imagesShapeSite = imagesShapeSite;
    }

    static {
        nameShape = new String[]{"RoundRectangle", "Rectangle", "Circle", "Triangle", "Rhomboid", "Rhombus", "Pentagon", "Hexagon", "Octagon", "Trapezoid", "Arrow", "DovetailArrow", "Cylinder", "Null"};
        nameShapeMarker = new String[]{"RoundRectangle", "Rectangle", "Circle", "Triangle", "Rhomboid", "Rhombus", "Pentagon", "Hexagon", "Octagon", "Trapezoid", "Arrow", "DovetailArrow"};
        promptShape = new String[]{"Rounded Rectangle", "Rectangle", "Oval", "Triangle", "Parallelogram", "Diamond", "Regular Pentagon", "Hexangon", "Octagon", "Trapezoid", "Arrow", "Notched Arrow", "Cylinder", "Null"};
        nameGradient = new String[]{"Horizontal", "Vertical", "Right", "Bottom_left_to_top_right", "Up", "Bottom_right_to_top_left", "Left", "Top_right_to_bottom_left", "Down", "Top_left_to_bottom_right", "Center_to_Border", "Center", "Null"};
        promptGradient = new String[]{"Horizontal", "Vertical", "Right", "Bottom left to top right", "Up", "Bottom right to top left", "Left", "Top right to bottom left", "Down", "Top_left_to_bottom_right", "Center to Border", "Center", "Null"};
    }

    public class PMouseHandle
    extends MouseAdapter {
        @Override
        public void mousePressed(MouseEvent event) {
            WorkingModeDialog.this.jRadioButtonProtein.setSelected(true);
            WorkingModeDialog.this.repaint();
        }

        @Override
        public void mouseClicked(MouseEvent event) {
            WorkingModeDialog.this.jRadioButtonProtein.setSelected(true);
            WorkingModeDialog.this.repaint();
        }
    }

    public class NMouseHandle
    extends MouseAdapter {
        @Override
        public void mousePressed(MouseEvent event) {
            WorkingModeDialog.this.jRadioButtonNucleic.setSelected(true);
            WorkingModeDialog.this.repaint();
        }

        @Override
        public void mouseClicked(MouseEvent event) {
            WorkingModeDialog.this.jRadioButtonNucleic.setSelected(true);
            WorkingModeDialog.this.repaint();
        }
    }
}

