/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.misc;

import com.install4j.api.Util;
import com.install4j.api.context.Context;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.beans.actions.SystemInstallOrUninstallAction;
import com.install4j.runtime.installer.frontend.GUIHelper;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.frontend.PasswordDialog;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.platform.UserInfo;
import com.install4j.runtime.installer.platform.unix.SudoExecution;
import com.install4j.runtime.installer.platform.unix.UnixUserInfo;
import java.io.File;
import java.io.IOException;
import java.util.ResourceBundle;
import javax.swing.SwingUtilities;

public class RequireAdminAction
extends SystemInstallOrUninstallAction {
    private boolean sudoRestart;

    public boolean isSudoRestart() {
        return this.sudoRestart;
    }

    public void setSudoRestart(boolean bl) {
        this.sudoRestart = bl;
    }

    public boolean execute(Context context) throws UserCanceledException {
        if (!UserInfo.isAdminUser()) {
            String string = context instanceof InstallerContext ? (Util.isWindows() ? "AdminPrivilegesRequired" : "RootPrivilegesRequired") : "OnlyAdminCanUninstall";
            GUIHelper.showMessage(null, Messages.getMessages().getString(string), 0);
            return false;
        }
        if (Util.isMacOS() && !UnixUserInfo.ROOT_USER) {
            boolean bl = RequireAdminAction.checkSudo(context);
            if (bl && this.isSudoRestart()) {
                File file = new File(System.getProperty("exe4j.moduleName", ""), "Contents/MacOS/JavaApplicationStub");
                if (!file.exists()) {
                    return false;
                }
                try {
                    SudoExecution.execute(new String[]{file.getAbsolutePath()});
                    System.exit(0);
                }
                catch (IOException iOException) {
                    Util.fatalError(iOException);
                }
            }
            return bl;
        }
        return true;
    }

    private static boolean checkSudo(Context context) {
        String string = System.getProperty("install4j.mac_origin");
        if (string != null) {
            try {
                if (SudoExecution.checkScrambledPassword(string)) {
                    return true;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (context.isUnattended() || context.isConsole()) {
            GUIHelper.showMessage(null, Messages.getMessages().getString(Util.isWindows() ? "AdminPrivilegesRequired" : "RootPrivilegesRequired"), 0);
            return false;
        }
        try {
            AskRunnable askRunnable = new AskRunnable();
            SwingUtilities.invokeAndWait(askRunnable);
            return !askRunnable.isCanceled();
        }
        catch (Exception exception) {
            InstallerUtil.reportException(exception);
            return false;
        }
    }

    public boolean isRollbackSupported() {
        return false;
    }

    public static class AskRunnable
    implements Runnable {
        private boolean canceled = false;

        public boolean isCanceled() {
            return this.canceled;
        }

        public void run() {
            final ResourceBundle resourceBundle = Messages.getMessages();
            if (PasswordDialog.getPassword(null, resourceBundle.getString("EnterPassword"), resourceBundle.getString("AdminGroupRequired"), resourceBundle.getString("EnterPasswordTitle"), new PasswordDialog.InputTextValidator(){

                public boolean isValidInputText(String string, PasswordDialog passwordDialog) {
                    try {
                        if (!SudoExecution.checkPassword(string)) {
                            GUIHelper.showMessage(passwordDialog, resourceBundle.getString("WrongPassword"), 0);
                            return false;
                        }
                    }
                    catch (IOException iOException) {
                        return false;
                    }
                    return true;
                }
            }) == null) {
                this.canceled = true;
            }
        }
    }
}

