/*
 * Decompiled with CFR 0.152.
 */
package gui;

import com.sun.media.jai.codec.TIFFEncodeParam;
import com.sun.media.jai.codec.TIFFField;
import com.sun.media.jai.codecimpl.TIFFImageEncoder;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.media.jai.JAI;
import javax.media.jai.RenderedOp;

public class TiffOutput {
    public TiffOutput(RenderedImage image, String outputFilePath, int dpi) {
        try {
            if (image != null) {
                TIFFEncodeParam param = new TIFFEncodeParam();
                param.setCompression(1);
                TIFFField[] extras = new TIFFField[]{new TIFFField(282, 5, 1, new long[][]{{dpi, 1L}}), new TIFFField(283, 5, 1, new long[][]{{dpi, 1L}})};
                param.setExtraFields(extras);
                FileOutputStream outputStream = new FileOutputStream(new File(outputFilePath));
                TIFFImageEncoder encoder = new TIFFImageEncoder(outputStream, param);
                encoder.encode(image);
                outputStream.close();
            }
        }
        catch (IOException ex) {
            Logger.getLogger(TiffOutput.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public TiffOutput(RenderedImage image, String outputFilePath) {
        ParameterBlock pb = new ParameterBlock().add(image);
        RenderedOp src = JAI.create("awtimage", pb);
        JAI.create("encode", (RenderedImage)src, (Object)outputFilePath, (Object)"png", null);
    }

    public static void main(String[] args) {
        try {
            BufferedImage image = ImageIO.read(new File("E:/CDC2.png"));
            new TiffOutput(image, "E:/out.tiff", 300);
        }
        catch (IOException ex) {
            Logger.getLogger(TiffOutput.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

