/*
 * Decompiled with CFR 0.152.
 */
package gui.ibs;

import gui.TiffOutput;
import gui.ibs.Area;
import gui.ibs.Component;
import gui.ibs.ComponentEnum;
import gui.ibs.CurrentStateSet;
import gui.ibs.DemoFrame;
import gui.ibs.DomainDashConf;
import gui.ibs.DomainDialogConfig;
import gui.ibs.DrawTypeEnum;
import gui.ibs.GradientEnum;
import gui.ibs.IBSFrame;
import gui.ibs.PolygonXY;
import gui.ibs.Protein;
import gui.ibs.SVGService;
import gui.ibs.ShapeEnum;
import gui.ibs.SitePosition;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.MultipleGradientPaint;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.RadialGradientPaint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.QuadCurve2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.jdom.Document;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class CanvasPanel
extends JPanel {
    public boolean bCanClickContrl = true;
    public LinkedList<CurrentStateSet> hisList = new LinkedList();
    public int currentHisNum = 0;
    public boolean isDrag = false;
    private LinkedList<Protein> proteinList = new LinkedList();
    public LinkedList<Protein> selectProtein = new LinkedList();
    public LinkedList<Point2D.Double> preDragProteinVH = new LinkedList();
    private int currentProteinNum = 0;
    private int currentVertical = 0;
    public float rate = 1.0f;
    public float batchOutrate = 1.0f;
    public float raoteAnchorthick = 1.0f;
    private int positionFontSize = 12;
    private float RATE_STEP = 0.1f;
    private FontMetrics positionFontMetrics;
    private final String DELIMIT = "#&%";
    private int LINE_HEIGHT = 10;
    private final double HALF_LENGTH = 300.0;
    private double HALF_HEIGHT;
    private double LENGTH_RATE = 1.0;
    private int svgID = 0;
    private double whRatio = 1.3333333333333333;
    private boolean isLengthRate = true;
    private int maxLength;
    public int lineInterval = 5;
    public int iComponentRedius = 10;
    public boolean bAtutoArrangeDomain = false;
    public boolean bAdjustMark = false;
    public String strMarkAdjustBranch = "";
    public boolean bGray = false;
    public String version = "IBS 1.0";
    public int borderLenPic = 50;
    public int widthMaxLenPic = 800;
    public int heightMaxLenPic = 600;
    public Component ComponentSelect = null;
    public Protein ProteinSelect = null;
    public Point2D.Double dCurrDomainOrigPoint;
    public int iCurrentDomainLength = 0;
    public boolean bSelected = false;
    public Point2D.Double dStartSelect;
    public Point2D.Double dEndSelect;
    public Point2D.Double dStartPrevDrag;
    public Point2D.Double dEndPrevDrag;
    public int dh = 5;
    public int dw = 5;
    public boolean boot = false;
    public String Mode = "";
    public DomainDialogConfig ddc = new DomainDialogConfig();
    public IBSFrame df;
    public DemoFrame def;
    public Graphics2D g2dcurr;

    public float getBatchOutrate() {
        return this.batchOutrate;
    }

    public void setBatchOutrate(float batchOutrate) {
        this.batchOutrate = batchOutrate;
    }

    public float getRaoteAnchorthick() {
        return this.raoteAnchorthick;
    }

    public void setRaoteAnchorthick(float raoteAnchorthick) {
        this.raoteAnchorthick = raoteAnchorthick;
    }

    public int getWidthMaxLenPic() {
        return this.widthMaxLenPic;
    }

    public void setWidthMaxLenPic(int widthMaxLenPic) {
        this.widthMaxLenPic = widthMaxLenPic;
    }

    public int getHeightMaxLenPic() {
        return this.heightMaxLenPic;
    }

    public void setHeightMaxLenPic(int heightMaxLenPic) {
        this.heightMaxLenPic = heightMaxLenPic;
    }

    public DomainDialogConfig getDdc() {
        return this.ddc;
    }

    public void setDdc(DomainDialogConfig ddc) {
        this.ddc = ddc;
    }

    public Graphics2D getG2dcurr() {
        return this.g2dcurr;
    }

    public void setG2dcurr(Graphics2D g2dcurr) {
        this.g2dcurr = g2dcurr;
    }

    public IBSFrame getDf() {
        return this.df;
    }

    public DemoFrame getDef() {
        return this.def;
    }

    public void setDef(DemoFrame def) {
        this.def = def;
    }

    public void setDf(IBSFrame df) {
        this.df = df;
    }

    public String getMode() {
        return this.Mode;
    }

    public void setMode(String Mode) {
        this.Mode = Mode;
    }

    public boolean isBoot() {
        return this.boot;
    }

    public void setBoot(boolean boot) {
        this.boot = boot;
    }

    public boolean isbCanClickContrl() {
        return this.bCanClickContrl;
    }

    public void setbCanClickContrl(boolean bCanClickContrl) {
        this.bCanClickContrl = bCanClickContrl;
    }

    public void clearHis() {
        this.currentHisNum = -1;
        this.hisList.clear();
        this.df.jButtonSelectUndo.setEnabled(false);
        this.df.jMenuItemUndo.setEnabled(false);
        this.df.jButtonSelectRedo.setEnabled(false);
        this.df.jMenuItemRedo.setEnabled(false);
    }

    public CanvasPanel() {
        this.initComponents();
        this.setSize(800, 600);
        this.setWHRatio();
        this.enableEvents(8L);
        InputMap inputMap = this.getInputMap(2);
        inputMap.put(KeyStroke.getKeyStroke("LEFT"), "LEFT");
        this.getActionMap().put("LEFT", new AbstractAction("LEFT"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CanvasPanel.this.adjustxy("LEFT");
            }
        });
        inputMap.put(KeyStroke.getKeyStroke("DOWN"), "DOWN");
        this.getActionMap().put("DOWN", new AbstractAction("DOWN"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CanvasPanel.this.adjustxy("DOWN");
            }
        });
        inputMap.put(KeyStroke.getKeyStroke("RIGHT"), "RIGHT");
        this.getActionMap().put("RIGHT", new AbstractAction("RIGHT"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CanvasPanel.this.adjustxy("RIGHT");
            }
        });
        inputMap.put(KeyStroke.getKeyStroke("UP"), "UP");
        this.getActionMap().put("UP", new AbstractAction("UP"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CanvasPanel.this.adjustxy("UP");
            }
        });
        inputMap.put(KeyStroke.getKeyStroke("control UP"), "control UP");
        this.getActionMap().put("control UP", new AbstractAction("control UP"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CanvasPanel.this.adjustxy("control UP");
            }
        });
        inputMap.put(KeyStroke.getKeyStroke("control DOWN"), "control DOWN");
        this.getActionMap().put("control DOWN", new AbstractAction("control DOWN"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CanvasPanel.this.adjustxy("control DOWN");
            }
        });
        inputMap.put(KeyStroke.getKeyStroke("control LEFT"), "control LEFT");
        this.getActionMap().put("control LEFT", new AbstractAction("control LEFT"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CanvasPanel.this.adjustxy("control LEFT");
            }
        });
        inputMap.put(KeyStroke.getKeyStroke("control RIGHT"), "control RIGHT");
        this.getActionMap().put("control RIGHT", new AbstractAction("control RIGHT"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CanvasPanel.this.adjustxy("control RIGHT");
            }
        });
        inputMap.put(KeyStroke.getKeyStroke("DELETE"), "DELETE");
        this.getActionMap().put("DELETE", new AbstractAction("DELETE"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CanvasPanel.this.deletecom();
            }
        });
        inputMap.put(KeyStroke.getKeyStroke("control  V"), "control  V");
        this.getActionMap().put("control  V", new AbstractAction("control  V"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    CanvasPanel.this.duplicate();
                }
                catch (CloneNotSupportedException ex) {
                    ex.printStackTrace();
                }
            }
        });
        inputMap.put(KeyStroke.getKeyStroke("control  MINUS"), "control  MINUS");
        this.getActionMap().put("control  MINUS", new AbstractAction("control  MINUS"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CanvasPanel.this.lineHorizontal();
            }
        });
        inputMap.put(KeyStroke.getKeyStroke("control  BACK_SLASH"), "control  BACK_SLASH");
        this.getActionMap().put("control  BACK_SLASH", new AbstractAction("control  BACK_SLASH"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CanvasPanel.this.lineVertical();
            }
        });
        inputMap.put(KeyStroke.getKeyStroke("control  R"), "control  R");
        this.getActionMap().put("control  R", new AbstractAction("control  R"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CanvasPanel.this.lineRightAngle();
            }
        });
        inputMap.put(KeyStroke.getKeyStroke("control  Y"), "control  Y");
        this.getActionMap().put("control  Y", new AbstractAction("control  Y"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    CanvasPanel.this.undo();
                }
                catch (CloneNotSupportedException ex) {
                    Logger.getLogger(CanvasPanel.class.getName()).log(Level.SEVERE, null, ex);
                }
                CanvasPanel.this.repaintList();
            }
        });
        inputMap.put(KeyStroke.getKeyStroke("control  Z"), "control  Z");
        this.getActionMap().put("control  Z", new AbstractAction("control  Z"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    CanvasPanel.this.redo();
                }
                catch (CloneNotSupportedException ex) {
                    Logger.getLogger(CanvasPanel.class.getName()).log(Level.SEVERE, null, ex);
                }
                CanvasPanel.this.repaintList();
            }
        });
        inputMap.put(KeyStroke.getKeyStroke("control G"), "control G");
        this.getActionMap().put("control G", new AbstractAction("control G"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CanvasPanel.this.adjustToCenter();
                CanvasPanel.this.repaint();
            }
        });
    }

    public void lineRightAngle() {
        if (this.ComponentSelect == null) {
            return;
        }
        if (this.ComponentSelect.getType() != ComponentEnum.Line) {
            return;
        }
        boolean centerx = false;
        boolean centery = false;
        if (this.ComponentSelect.shapeType == ShapeEnum.PolylineOne) {
            Point2D.Double pd = this.getRightAngleXY((int)this.ComponentSelect.getX(), this.ComponentSelect.getY(), (int)this.ComponentSelect.getX2(), this.ComponentSelect.getY2(), this.ComponentSelect.getControlx1(), this.ComponentSelect.getControly1());
            this.ComponentSelect.setControlx1((int)pd.x);
            this.ComponentSelect.setControly1((int)pd.y);
        } else if (this.ComponentSelect.shapeType == ShapeEnum.PolylineTwo) {
            if (this.ComponentSelect.bStartArea1Selected || this.ComponentSelect.bControlArea1Selected) {
                Point2D.Double pd = this.getRightAngleXY((int)this.ComponentSelect.getX(), this.ComponentSelect.getY(), this.ComponentSelect.getControlx2(), this.ComponentSelect.getControly2(), this.ComponentSelect.getControlx1(), this.ComponentSelect.getControly1());
                this.ComponentSelect.setControlx1((int)pd.x);
                this.ComponentSelect.setControly1((int)pd.y);
            } else if (this.ComponentSelect.bEndArea2Selected || this.ComponentSelect.bControlArea2Selected) {
                Point2D.Double pd = this.getRightAngleXY((int)this.ComponentSelect.getX2(), this.ComponentSelect.getY2(), this.ComponentSelect.getControlx1(), this.ComponentSelect.getControly1(), this.ComponentSelect.getControlx2(), this.ComponentSelect.getControly2());
                this.ComponentSelect.setControlx2((int)pd.x);
                this.ComponentSelect.setControly2((int)pd.y);
            }
        }
        this.repaint();
    }

    public Point2D.Double getRightAngleXY(int startx, int starty, int endx, int endy, int conx, int cony) {
        Point2D.Double pd = new Point2D.Double();
        int centerx = 0;
        int centery = 0;
        if (starty > endy && startx < endx) {
            centerx = startx + (endx - startx) / 2;
            centery = starty + (endy - starty) / 2;
            double angle1 = 0.0;
            double angle2 = 0.0;
            double angle3 = 0.0;
            angle1 = Math.PI - Math.atan(Math.abs(centery - starty) / Math.abs(centerx - startx));
            angle2 = Math.atan(Math.abs(centery - endy) / Math.abs(centerx - endx));
            double dconx = 0.0;
            double dcony = 0.0;
            dconx = Math.abs(conx - centerx);
            dcony = Math.abs(cony - centery);
            if (conx >= centerx && cony >= centery) {
                angle3 = Math.atan(dcony / dconx);
            } else if (conx <= centerx && cony >= centery) {
                angle3 = 1.5707963267948966 + Math.atan(dconx / dcony);
            } else if (conx <= centerx && cony <= centery) {
                angle3 = Math.PI + Math.atan(dcony / dconx);
            } else if (conx >= centerx && cony <= centery) {
                angle3 = 4.71238898038469 + Math.atan(dconx / dcony);
            }
            if (0.0 <= angle3 && angle3 < angle1 || 4.71238898038469 + angle2 < angle3 && angle3 < Math.PI * 2) {
                pd.x = endx;
                pd.y = starty;
            } else if (angle3 >= angle1 && 4.71238898038469 + angle2 >= angle3) {
                pd.x = startx;
                pd.y = endy;
            }
        } else if (starty >= endy && startx >= endx) {
            centerx = startx + (endx - startx) / 2;
            centery = starty + (endy - starty) / 2;
            double angle1 = 0.0;
            double angle2 = 0.0;
            double angle3 = 0.0;
            angle1 = Math.atan(Math.abs(centery - starty) / Math.abs(centerx - startx));
            angle2 = Math.PI + Math.atan(Math.abs(centery - endy) / Math.abs(centerx - endx));
            double dconx = 0.0;
            double dcony = 0.0;
            dconx = Math.abs(conx - centerx);
            dcony = Math.abs(cony - centery);
            if (conx >= centerx && cony >= centery) {
                angle3 = Math.atan(dcony / dconx);
            } else if (conx <= centerx && cony >= centery) {
                angle3 = 1.5707963267948966 + Math.atan(dconx / dcony);
            } else if (conx <= centerx && cony <= centery) {
                angle3 = Math.PI + Math.atan(dcony / dconx);
            } else if (conx >= centerx && cony <= centery) {
                angle3 = 4.71238898038469 + Math.atan(dconx / dcony);
            }
            if (0.0 <= angle3 && angle3 < angle1 || angle2 < angle3 && angle3 < Math.PI * 2) {
                pd.x = startx;
                pd.y = endy;
            } else if (angle3 >= angle1 && angle2 >= angle3) {
                pd.x = endx;
                pd.y = starty;
            }
        } else if (endy > starty && endx < startx) {
            centerx = endx + (startx - endx) / 2;
            centery = endy + (starty - endy) / 2;
            double angle1 = 0.0;
            double angle2 = 0.0;
            double angle3 = 0.0;
            angle1 = Math.PI - Math.atan(Math.abs(centery - endy) / Math.abs(centerx - endx));
            angle2 = Math.atan(Math.abs(centery - starty) / Math.abs(centerx - startx));
            double dconx = 0.0;
            double dcony = 0.0;
            dconx = Math.abs(conx - centerx);
            dcony = Math.abs(cony - centery);
            if (conx >= centerx && cony >= centery) {
                angle3 = Math.atan(dcony / dconx);
            } else if (conx <= centerx && cony >= centery) {
                angle3 = 1.5707963267948966 + Math.atan(dconx / dcony);
            } else if (conx <= centerx && cony <= centery) {
                angle3 = Math.PI + Math.atan(dcony / dconx);
            } else if (conx >= centerx && cony <= centery) {
                angle3 = 4.71238898038469 + Math.atan(dconx / dcony);
            }
            if (0.0 <= angle3 && angle3 < angle1 || 4.71238898038469 + angle2 < angle3 && angle3 < Math.PI * 2) {
                pd.x = startx;
                pd.y = endy;
            } else if (angle3 >= angle1 && 4.71238898038469 + angle2 >= angle3) {
                pd.x = endx;
                pd.y = starty;
            }
        } else if (endy >= starty && endx >= startx) {
            centerx = endx + (startx - endx) / 2;
            centery = endy + (starty - endy) / 2;
            double angle1 = 0.0;
            double angle2 = 0.0;
            double angle3 = 0.0;
            angle1 = Math.atan(Math.abs(centery - endy) / Math.abs(centerx - endx));
            angle2 = Math.PI + Math.atan(Math.abs(centery - starty) / Math.abs(centerx - startx));
            double dconx = 0.0;
            double dcony = 0.0;
            dconx = Math.abs(conx - centerx);
            dcony = Math.abs(cony - centery);
            if (conx >= centerx && cony >= centery) {
                angle3 = Math.atan(dcony / dconx);
            } else if (conx <= centerx && cony >= centery) {
                angle3 = 1.5707963267948966 + Math.atan(dconx / dcony);
            } else if (conx <= centerx && cony <= centery) {
                angle3 = Math.PI + Math.atan(dcony / dconx);
            } else if (conx >= centerx && cony <= centery) {
                angle3 = 4.71238898038469 + Math.atan(dconx / dcony);
            }
            if (0.0 <= angle3 && angle3 < angle1 || angle2 < angle3 && angle3 < Math.PI * 2) {
                pd.x = endx;
                pd.y = starty;
            } else if (angle3 >= angle1 && angle2 >= angle3) {
                pd.x = startx;
                pd.y = endy;
            }
        }
        return pd;
    }

    public void lineHorizontal() {
        if (this.ComponentSelect == null) {
            return;
        }
        if (this.ComponentSelect.getType() != ComponentEnum.Line) {
            return;
        }
        if (this.ComponentSelect.bStartArea1Selected) {
            this.ComponentSelect.setY2(this.ComponentSelect.getY());
        } else if (this.ComponentSelect.bEndArea2Selected) {
            this.ComponentSelect.setY(this.ComponentSelect.getY2());
        }
        this.repaint();
    }

    public void lineVertical() {
        if (this.ComponentSelect == null) {
            return;
        }
        if (this.ComponentSelect.getType() != ComponentEnum.Line) {
            return;
        }
        if (this.ComponentSelect.bStartArea1Selected) {
            this.ComponentSelect.setX2(this.ComponentSelect.getX());
        } else if (this.ComponentSelect.bEndArea2Selected) {
            this.ComponentSelect.setX(this.ComponentSelect.getX2());
        }
        this.repaint();
    }

    public void duplicate() throws CloneNotSupportedException {
        block2: for (int i = 0; i < this.proteinList.size(); ++i) {
            Protein protein = this.proteinList.get(i);
            if (protein.isActive()) {
                Protein clonedProtein = (Protein)protein.clone();
                clonedProtein.setVertical(protein.getVertical() - 100);
                this.proteinList.add(clonedProtein);
                protein.setIsActive(false);
                break;
            }
            LinkedList<Component> componentList = protein.getComponentList();
            for (int k = 0; k < componentList.size(); ++k) {
                Component clonedDomain;
                Component selectedComponent = componentList.get(k);
                if (!selectedComponent.isActive() || !selectedComponent.isbSelected()) continue;
                if (selectedComponent.getType() == ComponentEnum.Domain) {
                    clonedDomain = (Component)selectedComponent.clone();
                    clonedDomain.setX(selectedComponent.getX() + 20.0);
                    clonedDomain.setX2(selectedComponent.getX2() + 20.0);
                    clonedDomain.setHigh(selectedComponent.getHigh());
                    this.ComponentSelect = clonedDomain;
                    componentList.add(clonedDomain);
                }
                if (selectedComponent.getType() == ComponentEnum.CutLine) {
                    clonedDomain = (Component)selectedComponent.clone();
                    clonedDomain.setX(selectedComponent.getX() + 20.0);
                    clonedDomain.setX2(selectedComponent.getX2() + 20.0);
                    clonedDomain.setHigh(selectedComponent.getHigh());
                    this.ComponentSelect = clonedDomain;
                    componentList.add(clonedDomain);
                } else if (selectedComponent.getType() == ComponentEnum.Site) {
                    Component clonedSite = (Component)selectedComponent.clone();
                    clonedSite.setX(selectedComponent.getX() + 30.0);
                    clonedSite.setY(selectedComponent.getY() + 30);
                    this.ComponentSelect = clonedSite;
                    componentList.add(clonedSite);
                } else if (selectedComponent.getType() == ComponentEnum.Note) {
                    Component clonedNote = (Component)selectedComponent.clone();
                    clonedNote.setX(selectedComponent.getX() + 30.0);
                    clonedNote.setY(selectedComponent.getY() + 30);
                    this.ComponentSelect = clonedNote;
                    componentList.add(clonedNote);
                } else if (selectedComponent.getType() == ComponentEnum.Line) {
                    Component clonedLine = (Component)selectedComponent.clone();
                    clonedLine.setX(selectedComponent.getX() + 30.0);
                    clonedLine.setY(selectedComponent.getY() + 30);
                    clonedLine.setX2(selectedComponent.getX2() + 30.0);
                    clonedLine.setY2(selectedComponent.getY2() + 30);
                    this.ComponentSelect = clonedLine;
                    componentList.add(clonedLine);
                } else if (selectedComponent.getType() == ComponentEnum.Polygon) {
                    Component clonedPolygon = (Component)selectedComponent.clone();
                    clonedPolygon.setCenterx(selectedComponent.getCenterx() + 30.0);
                    clonedPolygon.setCentery(selectedComponent.getCentery() + 30.0);
                    this.ComponentSelect = clonedPolygon;
                    componentList.add(clonedPolygon);
                } else if (selectedComponent.getType() == ComponentEnum.Bracket) {
                    Component clonedBracket = (Component)selectedComponent.clone();
                    clonedBracket.setCenterx(selectedComponent.getCenterx() + 30.0);
                    clonedBracket.setCentery(selectedComponent.getCentery() + 30.0);
                    this.ComponentSelect = clonedBracket;
                    componentList.add(clonedBracket);
                }
                this.ComponentSelect.bSelected = true;
                this.ComponentSelect.setIsActive(true);
                selectedComponent.setIsActive(false);
                selectedComponent.setbSelected(false);
                continue block2;
            }
        }
        this.repaint();
        try {
            this.saveCurrentState();
        }
        catch (CloneNotSupportedException ex) {
            ex.printStackTrace();
        }
        this.repaintList();
    }

    public void deletecom() {
        block4: for (int i = 0; i < this.proteinList.size(); ++i) {
            Protein protein = this.proteinList.get(i);
            if (protein.isActive()) {
                this.proteinList.remove(i);
                if (this.proteinList.size() > 0) {
                    this.setCurrentProteinNum(0);
                    this.proteinList.get(0).setIsActive(true);
                    this.proteinList.get(0).setSelectNum(0);
                }
                this.repaint();
                try {
                    this.saveCurrentState();
                }
                catch (CloneNotSupportedException ex) {
                    ex.printStackTrace();
                }
            }
            LinkedList<Component> componentList = protein.getComponentList();
            for (int j = 0; j < componentList.size(); ++j) {
                if (!componentList.get(j).isActive()) continue;
                componentList.remove(j);
                this.repaint();
                try {
                    this.saveCurrentState();
                }
                catch (CloneNotSupportedException ex) {
                    ex.printStackTrace();
                }
                continue block4;
            }
        }
        this.repaintList();
    }

    public void repaintList() {
        IBSFrame.listModel.clear();
        int k = 0;
        int p = 0;
        for (Protein protein : this.proteinList) {
            IBSFrame.listModel.addElement(IBSFrame.getListElement(protein, k));
            LinkedList<Component> componentList = protein.getComponentList();
            p = 0;
            for (Component component : componentList) {
                IBSFrame.listModel.addElement(IBSFrame.getListElement(component, p));
                ++p;
            }
            ++k;
        }
    }

    public boolean isIsDrag() {
        return this.isDrag;
    }

    public void setIsDrag(boolean isDrag) {
        this.isDrag = isDrag;
    }

    public void undo() throws CloneNotSupportedException {
        if (this.hisList.size() > 0) {
            --this.currentHisNum;
            if (this.currentHisNum <= -1) {
                this.currentHisNum = 0;
            }
            CurrentStateSet ss = this.hisList.get(this.currentHisNum);
            this.proteinList.clear();
            for (Protein protein : ss.proteinList) {
                Protein proteinClone = (Protein)protein.clone();
                proteinClone.componentList.clear();
                LinkedList<Component> componentList = protein.getComponentList();
                for (Component component : componentList) {
                    Component componentclone = (Component)component.clone();
                    proteinClone.componentList.add(componentclone);
                }
                this.proteinList.addLast(proteinClone);
            }
            this.repaintList();
            this.repaint();
            if (this.currentHisNum <= 0) {
                this.df.jButtonSelectUndo.setEnabled(false);
                this.df.jMenuItemUndo.setEnabled(false);
            } else {
                this.df.jButtonSelectUndo.setEnabled(true);
                this.df.jMenuItemUndo.setEnabled(true);
            }
            if (this.currentHisNum == this.hisList.size() - 1) {
                this.df.jButtonSelectRedo.setEnabled(false);
                this.df.jMenuItemRedo.setEnabled(false);
            } else {
                this.df.jButtonSelectRedo.setEnabled(true);
                this.df.jMenuItemRedo.setEnabled(true);
            }
        } else {
            JOptionPane.showConfirmDialog(null, "No operation!");
        }
    }

    public void redo() throws CloneNotSupportedException {
        if (this.hisList.size() > 0) {
            ++this.currentHisNum;
            if (this.currentHisNum >= this.hisList.size() - 1) {
                this.currentHisNum = this.hisList.size() - 1;
            }
            CurrentStateSet ss = this.hisList.get(this.currentHisNum);
            this.proteinList.clear();
            for (Protein protein : ss.proteinList) {
                Protein proteinClone = (Protein)protein.clone();
                proteinClone.componentList.clear();
                LinkedList<Component> componentList = protein.getComponentList();
                for (Component component : componentList) {
                    Component componentclone = (Component)component.clone();
                    proteinClone.componentList.add(componentclone);
                }
                this.proteinList.addLast(proteinClone);
            }
            this.repaintList();
            this.repaint();
            if (this.currentHisNum <= 0) {
                this.df.jButtonSelectUndo.setEnabled(false);
                this.df.jMenuItemUndo.setEnabled(false);
            } else {
                this.df.jButtonSelectUndo.setEnabled(true);
                this.df.jMenuItemUndo.setEnabled(true);
            }
            if (this.currentHisNum == this.hisList.size() - 1) {
                this.df.jButtonSelectRedo.setEnabled(false);
                this.df.jMenuItemRedo.setEnabled(false);
            } else {
                this.df.jButtonSelectRedo.setEnabled(true);
                this.df.jMenuItemRedo.setEnabled(true);
            }
        } else {
            JOptionPane.showConfirmDialog(null, "No operation!");
        }
    }

    public void saveCurrentState() throws CloneNotSupportedException {
        if (this.df == null) {
            return;
        }
        if (this.hisList.size() > 0) {
            for (int u = this.hisList.size() - 1; u > this.currentHisNum; --u) {
                this.hisList.remove(u);
            }
        }
        CurrentStateSet ss = new CurrentStateSet();
        ss.proteinList = new LinkedList();
        ss.proteinList.clear();
        for (Protein protein : this.proteinList) {
            Protein proteinClone = (Protein)protein.clone();
            proteinClone.componentList.clear();
            LinkedList<Component> componentList = protein.getComponentList();
            for (Component component : componentList) {
                Component componentclone = (Component)component.clone();
                proteinClone.componentList.add(componentclone);
            }
            ss.proteinList.addLast(proteinClone);
        }
        if (this.hisList.size() > 0 && this.hisList.getLast() == ss) {
            return;
        }
        this.hisList.addLast(ss);
        ++this.currentHisNum;
        if (this.hisList.size() > 5) {
            this.hisList.removeFirst();
            this.currentHisNum = 4;
        }
        if (this.currentHisNum <= 0) {
            this.df.jButtonSelectUndo.setEnabled(false);
            this.df.jMenuItemUndo.setEnabled(false);
        } else {
            this.df.jButtonSelectUndo.setEnabled(true);
            this.df.jMenuItemUndo.setEnabled(true);
        }
        if (this.currentHisNum == this.hisList.size() - 1) {
            this.df.jButtonSelectRedo.setEnabled(false);
            this.df.jMenuItemRedo.setEnabled(false);
        } else {
            this.df.jButtonSelectRedo.setEnabled(true);
            this.df.jMenuItemRedo.setEnabled(true);
        }
    }

    public Protein getProteinSelect() {
        return this.ProteinSelect;
    }

    public void setProteinSelect(Protein ProteinSelect) {
        this.ProteinSelect = ProteinSelect;
    }

    public int getCurrentHisNum() {
        return this.currentHisNum;
    }

    public void setCurrentHisNum(int currentHisNum) {
        this.currentHisNum = currentHisNum;
    }

    public Component getComponentSelect() {
        return this.ComponentSelect;
    }

    public void setComponentSelect(Component ComponentSelect) {
        this.ComponentSelect = ComponentSelect;
    }

    public LinkedList<CurrentStateSet> getHisList() {
        return this.hisList;
    }

    public void setHisList(LinkedList<CurrentStateSet> hisList) {
        this.hisList = hisList;
    }

    public boolean isIsLengthRate() {
        return this.isLengthRate;
    }

    public void setIsLengthRate(boolean isLengthRate) {
        this.isLengthRate = isLengthRate;
    }

    public int getLineInterval() {
        return this.lineInterval;
    }

    public void setLineInterval(int lineInterval) {
        this.lineInterval = lineInterval;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
    }

    public FontMetrics getPositionFontMetrics() {
        return this.positionFontMetrics;
    }

    public void setPositionFontMetrics(FontMetrics positionFontMetrics) {
        this.positionFontMetrics = positionFontMetrics;
    }

    public int getPositionFontSize() {
        return this.positionFontSize;
    }

    public void setPositionFontSize(int positionFontSize) {
        this.positionFontSize = positionFontSize;
    }

    public String getStrMarkAdjustBranch() {
        return this.strMarkAdjustBranch;
    }

    public void setStrMarkAdjustBranch(String strMarkAdjustBranch) {
        this.strMarkAdjustBranch = strMarkAdjustBranch;
    }

    public int getSvgID() {
        return this.svgID;
    }

    public void setSvgID(int svgID) {
        this.svgID = svgID;
    }

    public double getWhRatio() {
        return this.whRatio;
    }

    public void setWhRatio(double whRatio) {
        this.whRatio = whRatio;
    }

    public float getRate() {
        return this.rate;
    }

    public void setRate(float rate) {
        this.rate = rate;
    }

    public int getDh() {
        return this.dh;
    }

    public void setDh(int dh) {
        this.dh = dh;
    }

    public int getDw() {
        return this.dw;
    }

    public void setDw(int dw) {
        this.dw = dw;
    }

    public void adjustxy(String direction) {
        int x = 0;
        int y = 0;
        if (direction.equals("LEFT")) {
            x = -1;
            y = 0;
        } else if (direction.equals("RIGHT")) {
            x = 1;
            y = 0;
        } else if (direction.equals("UP")) {
            x = 0;
            y = 1;
        } else if (direction.equals("DOWN")) {
            x = 0;
            y = -1;
        } else if (direction.equals("control UP")) {
            x = 0;
            y = 1;
        } else if (direction.equals("control DOWN")) {
            x = 0;
            y = -1;
        } else if (direction.equals("control LEFT")) {
            x = -1;
            y = 0;
        } else if (direction.equals("control RIGHT")) {
            x = 1;
            y = 0;
        }
        block0: for (int i = 0; i < this.proteinList.size(); ++i) {
            Protein protein = this.proteinList.get(i);
            if (protein.isActive()) {
                protein.setIsActive(false);
                break;
            }
            LinkedList<Component> componentList = protein.getComponentList();
            for (Component component : componentList) {
                if (!component.isActive()) continue;
                if (component.getType() == ComponentEnum.Note || component.getType() == ComponentEnum.Site) {
                    component.setX(component.getX() + (double)x);
                    component.setY(component.getY() + y);
                    this.repaint();
                    break block0;
                }
                if (component.getType() == ComponentEnum.Polygon) {
                    if (direction.equals("control UP")) {
                        component.setCenterx(component.getCenterx() + (double)x);
                        component.setHigh(component.getHigh() + (double)y);
                        component.setCentery(component.getCentery() + (double)(y / 2));
                    } else if (direction.equals("control DOWN")) {
                        if (component.getHigh() + (double)y < 1.0) continue block0;
                        component.setCenterx(component.getCenterx() + (double)x);
                        component.setHigh(component.getHigh() + (double)y);
                        component.setCentery(component.getCentery() + (double)(y / 2));
                    } else if (direction.equals("control LEFT")) {
                        if (component.getWide() + (double)x < 1.0) continue block0;
                        component.setCenterx(component.getCenterx() + (double)(x / 2));
                        component.setWide(component.getWide() + (double)x);
                        component.setCentery(component.getCentery() + (double)y);
                    } else if (direction.equals("control RIGHT")) {
                        component.setCenterx(component.getCenterx() + (double)(x / 2));
                        component.setWide(component.getWide() + (double)x);
                        component.setCentery(component.getCentery() + (double)y);
                    } else {
                        component.setCenterx(component.getCenterx() + (double)x);
                        component.setCentery(component.getCentery() + (double)y);
                    }
                    this.repaint();
                    break block0;
                }
                if (component.getType() == ComponentEnum.Bracket) {
                    if (direction.equals("control UP")) {
                        component.setCenterx(component.getCenterx() + (double)x);
                        component.setHigh(component.getHigh() + (double)y);
                        component.setCentery(component.getCentery() + (double)(y / 2));
                    } else if (direction.equals("control DOWN")) {
                        if (component.getHigh() + (double)y < 1.0) continue block0;
                        component.setCenterx(component.getCenterx() + (double)x);
                        component.setHigh(component.getHigh() + (double)y);
                        component.setCentery(component.getCentery() + (double)(y / 2));
                    } else if (direction.equals("control LEFT")) {
                        if (component.getWide() + (double)x < 1.0) continue block0;
                        component.setCenterx(component.getCenterx() + (double)(x / 2));
                        component.setWide(component.getWide() + (double)x);
                        component.setCentery(component.getCentery() + (double)y);
                    } else if (direction.equals("control RIGHT")) {
                        component.setCenterx(component.getCenterx() + (double)(x / 2));
                        component.setWide(component.getWide() + (double)x);
                        component.setCentery(component.getCentery() + (double)y);
                    } else {
                        component.setCenterx(component.getCenterx() + (double)x);
                        component.setCentery(component.getCentery() + (double)y);
                    }
                    this.repaint();
                    break block0;
                }
                if (component.getType() == ComponentEnum.Domain) {
                    if (!(component.getX2() + (double)x <= (double)protein.getEnd()) || !(component.getX() + (double)x >= 0.0)) break block0;
                    if (direction.equals("control UP")) {
                        component.setHigh(component.getHigh() + (double)y);
                    } else if (direction.equals("control DOWN")) {
                        if (component.getHigh() + (double)y < 1.0) continue block0;
                        component.setHigh(component.getHigh() + (double)y);
                    } else if (direction.equals("control LEFT")) {
                        if (component.getX2() + (double)x < component.getX() + 1.0) continue block0;
                        component.setX2(component.getX2() + (double)x);
                    } else if (direction.equals("control RIGHT")) {
                        component.setX2(component.getX2() + (double)x);
                    } else {
                        component.setX(component.getX() + (double)x);
                        component.setX2(component.getX2() + (double)x);
                    }
                    this.repaint();
                    break block0;
                }
                if (component.getType() == ComponentEnum.CutLine) {
                    if (!(component.getX2() + (double)x <= (double)protein.getEnd()) || !(component.getX() + (double)x >= 0.0)) break block0;
                    if (direction.equals("control UP")) {
                        component.setHigh(component.getHigh() + (double)y);
                    } else if (direction.equals("control DOWN")) {
                        if (component.getHigh() + (double)y < 1.0) continue block0;
                        component.setHigh(component.getHigh() + (double)y);
                    } else if (direction.equals("control LEFT")) {
                        if (component.getX2() + (double)x < component.getX() + 1.0) continue block0;
                        component.setX2(component.getX2() + (double)x);
                    } else if (direction.equals("control RIGHT")) {
                        component.setX2(component.getX2() + (double)x);
                    } else {
                        component.setX(component.getX() + (double)x);
                        component.setX2(component.getX2() + (double)x);
                    }
                    this.repaint();
                    break block0;
                }
                if (component.getType() != ComponentEnum.Line) break block0;
                if (direction.equals("control UP")) {
                    if (component.bStartArea1Selected) {
                        component.setY(component.getY() + y);
                    } else if (component.bEndArea2Selected) {
                        component.setY2(component.getY2() + y);
                    } else if (component.bControlArea1Selected) {
                        component.setControly1(component.getControly1() + y);
                    } else if (component.bControlArea2Selected) {
                        component.setControly2(component.getControly2() + y);
                    }
                } else if (direction.equals("control DOWN")) {
                    if (component.bStartArea1Selected) {
                        component.setY(component.getY() + y);
                    } else if (component.bEndArea2Selected) {
                        component.setY2(component.getY2() + y);
                    } else if (component.bControlArea1Selected) {
                        component.setControly1(component.getControly1() + y);
                    } else if (component.bControlArea2Selected) {
                        component.setControly2(component.getControly2() + y);
                    }
                } else if (direction.equals("control LEFT")) {
                    if (component.bStartArea1Selected) {
                        component.setX(component.getX() + (double)x);
                    } else if (component.bEndArea2Selected) {
                        component.setX2(component.getX2() + (double)x);
                    } else if (component.bControlArea1Selected) {
                        component.setControlx1(component.getControlx1() + x);
                    } else if (component.bControlArea2Selected) {
                        component.setControlx2(component.getControlx2() + x);
                    }
                } else if (direction.equals("control RIGHT")) {
                    if (component.bStartArea1Selected) {
                        component.setX(component.getX() + (double)x);
                    } else if (component.bEndArea2Selected) {
                        component.setX2(component.getX2() + (double)x);
                    } else if (component.bControlArea1Selected) {
                        component.setControlx1(component.getControlx1() + x);
                    } else if (component.bControlArea2Selected) {
                        component.setControlx2(component.getControlx2() + x);
                    }
                } else {
                    component.setX(component.getX() + (double)x);
                    component.setY(component.getY() + y);
                    component.setX2(component.getX2() + (double)x);
                    component.setY2(component.getY2() + y);
                    component.setControlx1(component.getControlx1() + x);
                    component.setControly1(component.getControly1() + y);
                    component.setControlx2(component.getControlx2() + x);
                    component.setControly2(component.getControly2() + y);
                }
                this.repaint();
                break block0;
            }
        }
    }

    public Point2D.Double getdEndPrevDrag() {
        return this.dEndPrevDrag;
    }

    public void setdEndPrevDrag(Point2D.Double dEndPrevDrag) {
        this.dEndPrevDrag = dEndPrevDrag;
    }

    public LinkedList<Point2D.Double> getPreDragProteinVH() {
        return this.preDragProteinVH;
    }

    public void setPreDragProteinVH(LinkedList<Point2D.Double> preDragProteinVH) {
        this.preDragProteinVH = preDragProteinVH;
    }

    public Point2D.Double getdStartPrevDrag() {
        return this.dStartPrevDrag;
    }

    public void setdStartPrevDrag(Point2D.Double dStartPrevDrag) {
        this.dStartPrevDrag = dStartPrevDrag;
    }

    public boolean isbSelected() {
        return this.bSelected;
    }

    public void setbSelected(boolean bSelected) {
        this.bSelected = bSelected;
    }

    public Point2D.Double getdEndSelect() {
        return this.dEndSelect;
    }

    public void setdEndSelect(Point2D.Double dEndSelect) {
        this.dEndSelect = dEndSelect;
    }

    public Point2D.Double getdStartSelect() {
        return this.dStartSelect;
    }

    public void setdStartSelect(Point2D.Double dStartSelect) {
        this.dStartSelect = dStartSelect;
    }

    public LinkedList<Protein> getSelectProtein() {
        return this.selectProtein;
    }

    public void setSelectProtein(LinkedList<Protein> selectProtein) {
        this.selectProtein = selectProtein;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public boolean isbGray() {
        return this.bGray;
    }

    public void setbGray(boolean bGray) {
        this.bGray = bGray;
    }

    public Color getGrayColor(Color origColor) {
        int iNewGray = 0;
        int iNewColor = 0;
        if (this.bGray) {
            iNewGray = (int)((double)origColor.getRed() * 0.3 + (double)origColor.getGreen() * 0.59 + (double)origColor.getBlue() * 0.11);
            iNewColor = (origColor.getAlpha() << 24) + (iNewGray << 16) + (iNewGray << 8) + iNewGray;
            Color newColor = new Color(iNewColor);
            return newColor;
        }
        return origColor;
    }

    public String getstrMarkAdjustBranch() {
        return this.strMarkAdjustBranch;
    }

    public void setstrMarkAdjustBranch(String strMarkAdjustBranch) {
        this.strMarkAdjustBranch = strMarkAdjustBranch;
    }

    public boolean isbAdjustMark() {
        return this.bAdjustMark;
    }

    public void setbAdjustMark(boolean bAdjustMark) {
        this.bAdjustMark = bAdjustMark;
    }

    public int getiComponentRedius() {
        return this.iComponentRedius;
    }

    public void setiComponentRedius(int iComponentRedius) {
        this.iComponentRedius = iComponentRedius;
    }

    public int getiCurrentDomainLength() {
        return this.iCurrentDomainLength;
    }

    public void setiCurrentDomainLength(int iCurrentDomainLength) {
        this.iCurrentDomainLength = iCurrentDomainLength;
    }

    public boolean isbAtutoArrangeDomain() {
        return this.bAtutoArrangeDomain;
    }

    public void setbAtutoArrangeDomain(boolean bAtutoArrangeDomain) {
        this.bAtutoArrangeDomain = bAtutoArrangeDomain;
    }

    public Point2D.Double getdCurrDomainOrigPoint() {
        return this.dCurrDomainOrigPoint;
    }

    public void setdCurrDomainOrigPoint(Point2D.Double dCurrDomainOrigPoint) {
        this.dCurrDomainOrigPoint = dCurrDomainOrigPoint;
    }

    private void drawLogo(Graphics2D g2d) {
        ImageIcon image = new ImageIcon(CanvasPanel.class.getResource("/gui/ibs/image/CUCKOO.jpg"));
        g2d.drawImage(image.getImage(), -image.getIconWidth() / 2, -image.getIconHeight() / 2, null, null);
    }

    public void adjustToCenter() {
        double ymin = 0.0;
        double ymax = 0.0;
        double ycenter = 0.0;
        double xmin = 0.0;
        double xmax = 0.0;
        double xcenter = 0.0;
        double pymin = 3.4028234663852886E38;
        double pymax = 1.4E-45f;
        double pycenter = 0.0;
        double pxmin = 3.4028234663852886E38;
        double pxmax = 1.4E-45f;
        double pxcenter = 0.0;
        double maxproteinlen = 0.0;
        if (this.proteinList.size() > 0) {
            if (this.isLengthRate) {
                this.maxLength = 1;
                for (Protein protein : this.proteinList) {
                    int end = protein.getEnd();
                    if (end <= this.maxLength) continue;
                    this.maxLength = end;
                }
                maxproteinlen = this.maxLength;
                this.LENGTH_RATE = 600.0 / (double)this.maxLength;
            }
            for (Protein protein : this.proteinList) {
                String[] arrPro = protein.getParameter().split("#&%");
                int vertical = protein.getVertical();
                int horizontal = protein.getHorizontal();
                if (pymin > (double)vertical) {
                    pymin = vertical;
                }
                if (pxmin > (double)horizontal) {
                    pxmin = horizontal;
                }
                if (pxmax < (double)vertical) {
                    pxmax = vertical;
                }
                if (pxmax < (double)horizontal) {
                    pxmax = horizontal;
                }
                vertical = -vertical;
                int start = Integer.parseInt(arrPro[0]);
                int end = Integer.parseInt(arrPro[2]);
                int proteinHeight = Integer.parseInt(arrPro[4]);
                this.HALF_HEIGHT = (double)proteinHeight / 2.0;
                double startX = -300.0 + (double)horizontal + (double)start * this.LENGTH_RATE;
                double endX = -300.0 + (double)horizontal + (double)end * this.LENGTH_RATE;
                double startY = (double)vertical - this.HALF_HEIGHT;
                double endY = (double)vertical + this.HALF_HEIGHT;
                if (endX > xmax) {
                    xmax = endX;
                }
                if (startX < xmin) {
                    xmin = startX;
                }
                if (endY > ymax) {
                    ymax = endY;
                }
                if (startY < ymin) {
                    ymin = startY;
                }
                LinkedList<Component> componentList = protein.getComponentList();
                for (Component component : componentList) {
                    double startx;
                    double endx;
                    if (component.getType() == ComponentEnum.Domain) {
                        double iHigh = component.getHigh();
                        if (this.Mode.equals("N")) continue;
                        int iVhigh = (int)(iHigh * 2.0 * this.LENGTH_RATE);
                        if ((double)(iVhigh / 4) < this.HALF_HEIGHT) {
                            startY = Math.round((double)vertical - this.HALF_HEIGHT);
                            endY = Math.round((double)vertical + this.HALF_HEIGHT);
                        } else {
                            startY = vertical - iVhigh / 4;
                            endY = vertical + iVhigh / 4;
                        }
                        if (endY > ymax) {
                            ymax = endY;
                        }
                        if (!(startY < ymin)) continue;
                        ymin = startY;
                        continue;
                    }
                    if (component.getType() == ComponentEnum.CutLine) {
                        double iHigh = component.getHigh();
                        if (this.Mode.equals("N")) {
                            if (iHigh == 0.0) {
                                startY = (double)vertical - this.HALF_HEIGHT;
                                endY = (double)vertical + this.HALF_HEIGHT;
                            } else {
                                int iVhigh = (int)(iHigh * 2.0 * this.LENGTH_RATE);
                                startY = (double)vertical - (double)iVhigh / 4.0;
                                endY = (double)vertical + (double)iVhigh / 4.0;
                            }
                        } else {
                            int iVhigh = (int)(iHigh * 2.0 * this.LENGTH_RATE);
                            if ((double)(iVhigh / 4) < this.HALF_HEIGHT) {
                                startY = Math.round((double)vertical - this.HALF_HEIGHT);
                                endY = Math.round((double)vertical + this.HALF_HEIGHT);
                            } else {
                                startY = vertical - iVhigh / 4;
                                endY = vertical + iVhigh / 4;
                            }
                        }
                        if (endY > ymax) {
                            ymax = endY;
                        }
                        if (!(startY < ymin)) continue;
                        ymin = startY;
                        continue;
                    }
                    if (component.getType() == ComponentEnum.Site) {
                        int deltaX = (int)component.getCenterx();
                        int deltaY = (int)component.getCentery();
                        double centerx = deltaX;
                        double centery = deltaY;
                        double wide = component.getWide();
                        double high = component.getHigh();
                        double startx2 = centerx - wide / 2.0;
                        endx = centerx + wide / 2.0;
                        startX = -300.0 + (double)horizontal + startx2 * this.LENGTH_RATE;
                        endX = -300.0 + (double)horizontal + endx * this.LENGTH_RATE;
                        startY = (double)vertical - centery - high / 2.0 * this.LENGTH_RATE;
                        endY = (double)vertical - centery + high / 2.0 * this.LENGTH_RATE;
                        if (endX > xmax) {
                            xmax = endX;
                        }
                        if (startX < xmin) {
                            xmin = startX;
                        }
                        if (endY > ymax) {
                            ymax = endY;
                        }
                        if (!(startY < ymin)) continue;
                        ymin = startY;
                        continue;
                    }
                    if (component.getType() == ComponentEnum.Note) {
                        String[] arr = component.getParameter().split("#&%");
                        String title = arr[0].trim();
                        double deltaX = component.x;
                        double deltaY = component.y;
                        double centralX = deltaX * this.LENGTH_RATE + (double)horizontal - 300.0;
                        double centralY = (double)vertical - deltaY;
                        DrawTypeEnum style = DrawTypeEnum.valueOf(arr[2]);
                        int size = Integer.parseInt(arr[1]);
                        String strFont = arr.length > 5 ? arr[5] : "Arial";
                        BufferedImage image = new BufferedImage(800, 600, 6);
                        Graphics2D g2dbatch = image.createGraphics();
                        if (style == DrawTypeEnum.Bold) {
                            g2dbatch.setFont(new Font(strFont, 1, size));
                        } else if (style == DrawTypeEnum.Italic) {
                            g2dbatch.setFont(new Font(strFont, 2, size));
                        } else if (style == DrawTypeEnum.Plain) {
                            g2dbatch.setFont(new Font(strFont, 0, size));
                        } else if (style == DrawTypeEnum.Bold_Italic) {
                            g2dbatch.setFont(new Font(strFont, 3, size));
                        }
                        FontMetrics noteFontMetrics = g2dbatch.getFontMetrics();
                        startX = centralX - (double)noteFontMetrics.stringWidth(title) / 2.0;
                        endX = centralX + (double)noteFontMetrics.stringWidth(title) / 2.0;
                        startY = centralY - (double)noteFontMetrics.getHeight() / 2.0;
                        endY = centralY + (double)noteFontMetrics.getHeight() / 2.0;
                        if (endX > xmax) {
                            xmax = endX;
                        }
                        if (startX < xmin) {
                            xmin = startX;
                        }
                        if (endY > ymax) {
                            ymax = endY;
                        }
                        if (startY < ymin) {
                            ymin = startY;
                        }
                        g2dbatch.dispose();
                        continue;
                    }
                    if (component.getType() == ComponentEnum.Line) {
                        int x1 = (int)component.getX();
                        int y1 = component.getY();
                        int x2 = (int)component.getX2();
                        int y2 = component.getY2();
                        int x3 = component.getControlx1();
                        int y3 = component.getControly1();
                        int x4 = component.getControlx2();
                        int y4 = component.getControly2();
                        if (component.shapeType == null) {
                            component.shapeType = ShapeEnum.Straight;
                        }
                        startx = 0.0;
                        double endx2 = 0.0;
                        double starty = 0.0;
                        double endy = 0.0;
                        if (component.shapeType == ShapeEnum.Straight) {
                            endx2 = Math.max(x1, x2);
                            startx = Math.min(x1, x2);
                            endy = Math.max(y1, y2);
                            starty = Math.min(y1, y2);
                        } else if (component.shapeType == ShapeEnum.PolylineOne || component.shapeType == ShapeEnum.Curve) {
                            endx2 = Math.max(x1, x2);
                            endx2 = Math.max(endx2, (double)x3);
                            startx = Math.min(x1, x2);
                            startx = Math.min(startx, (double)x3);
                            endy = Math.max(y1, y2);
                            endy = Math.max(endy, (double)y3);
                            starty = Math.min(y1, y2);
                            starty = Math.min(starty, (double)y3);
                        } else if (component.shapeType == ShapeEnum.PolylineTwo || component.shapeType == ShapeEnum.Bezier) {
                            endx2 = Math.max(x1, x2);
                            endx2 = Math.max(endx2, (double)x3);
                            endx2 = Math.max(endx2, (double)x4);
                            startx = Math.min(x1, x2);
                            startx = Math.min(startx, (double)x3);
                            startx = Math.min(startx, (double)x4);
                            endy = Math.max(y1, y2);
                            endy = Math.max(endy, (double)y3);
                            endy = Math.max(endy, (double)y4);
                            starty = Math.min(y1, y2);
                            starty = Math.min(starty, (double)y3);
                            starty = Math.min(starty, (double)y4);
                        }
                        startX = -300.0 + (double)horizontal + startx * this.LENGTH_RATE;
                        startY = (double)vertical - starty;
                        endX = -300.0 + (double)horizontal + endx2 * this.LENGTH_RATE;
                        endY = (double)vertical - endy;
                        if (endX > xmax) {
                            xmax = endX;
                        }
                        if (startX < xmin) {
                            xmin = startX;
                        }
                        if (endY > ymax) {
                            ymax = endY;
                        }
                        if (!(startY < ymin)) continue;
                        ymin = startY;
                        continue;
                    }
                    if (component.getType() == ComponentEnum.Polygon) {
                        double centerx = component.getCenterx();
                        double centery = component.getCentery();
                        double wide = component.getWide();
                        double high = component.getHigh();
                        startx = centerx - wide / 2.0;
                        double starty = centery - high / 2.0;
                        endx = centerx + wide / 2.0;
                        double endy = centery + high / 2.0;
                        startX = -300.0 + (double)horizontal + startx * this.LENGTH_RATE;
                        endX = -300.0 + (double)horizontal + endx * this.LENGTH_RATE;
                        startY = (double)vertical - centery - high / 2.0 * this.LENGTH_RATE;
                        endY = (double)vertical - centery + high / 2.0 * this.LENGTH_RATE;
                        if (endX > xmax) {
                            xmax = endX;
                        }
                        if (startX < xmin) {
                            xmin = startX;
                        }
                        if (endY > ymax) {
                            ymax = endY;
                        }
                        if (!(startY < ymin)) continue;
                        ymin = startY;
                        continue;
                    }
                    if (component.getType() != ComponentEnum.Bracket) continue;
                    double centerx = component.getCenterx();
                    double centery = component.getCentery();
                    double wide = component.getWide();
                    double startx3 = centerx - wide;
                    double endx3 = centerx + wide;
                    startX = (int)(-300.0 + (double)horizontal + startx3 * this.LENGTH_RATE);
                    endX = (int)(-300.0 + (double)horizontal + endx3 * this.LENGTH_RATE);
                    int high = 3;
                    if (component.shapeType == ShapeEnum.SquareBracket) {
                        high = 3;
                    } else if (component.shapeType == ShapeEnum.Brace) {
                        high = 5;
                    }
                    startY = (int)((double)vertical - centery - (double)high);
                    endY = (int)((double)vertical - centery + (double)high);
                    if (endX > xmax) {
                        xmax = endX;
                    }
                    if (startX < xmin) {
                        xmin = startX;
                    }
                    if (endY > ymax) {
                        ymax = endY;
                    }
                    if (!(startY < ymin)) continue;
                    ymin = startY;
                }
            }
            int deltaY = 0;
            int deltaX = 0;
            if (xmin > 0.0 && xmax > xmin) {
                deltaX += -((int)xmin);
            } else if (xmin < 0.0 && xmax > 0.0) {
                deltaX += -((int)xmin) - (int)xmax;
            }
            if (ymin > 0.0 && ymax > ymin) {
                deltaY += -((int)ymin);
            } else if (ymin < 0.0 && ymax > 0.0) {
                deltaY += -((int)ymin) - (int)ymax;
            }
            for (Protein protein : this.proteinList) {
                int vertical = protein.getVertical();
                int horizontal = protein.getHorizontal();
                protein.setVertical(vertical -= deltaY / 2);
                protein.setHorizontal(horizontal += deltaX / 2);
            }
        }
    }

    public void fitToCenter() {
    }

    private void drawComponent(Graphics2D g2d) {
        this.g2dcurr = g2d;
        if (this.proteinList.size() > 0) {
            if (this.bSelected) {
                RoundRectangle2D.Double rec = null;
                if (this.dStartSelect != null && this.dEndSelect != null) {
                    if (this.dStartPrevDrag == null) {
                        rec = new RoundRectangle2D.Double((int)this.dStartSelect.x, (int)this.dStartSelect.y, (double)((int)this.dEndSelect.x) - this.dStartSelect.x, (double)((int)this.dEndSelect.y) - this.dStartSelect.y, (float)this.iComponentRedius * this.rate, (float)this.iComponentRedius * this.rate);
                    } else if (this.dEndPrevDrag != null) {
                        double intervalX = this.dEndPrevDrag.x - this.dStartPrevDrag.x;
                        double intervalY = this.dEndPrevDrag.y - this.dStartPrevDrag.y;
                        rec = new RoundRectangle2D.Double((int)this.dStartSelect.x + (int)intervalX, (int)this.dStartSelect.y + (int)intervalY, (double)((int)this.dEndSelect.x) - this.dStartSelect.x, (double)((int)this.dEndSelect.y) - this.dStartSelect.y, (float)this.iComponentRedius * this.rate, (float)this.iComponentRedius * this.rate);
                    }
                }
                if (rec != null) {
                    Color colorbk = new Color(18, 65, 137);
                    g2d.setColor(this.getGrayColor(colorbk));
                    float thick = 0.5f;
                    Stroke stroke = g2d.getStroke();
                    float[] dash1 = new float[]{5.0f};
                    g2d.setStroke(new BasicStroke(1.0f, 0, 0, 20.0f, dash1, 0.0f));
                    g2d.draw(rec);
                    g2d.setStroke(stroke);
                }
            }
            if (this.isLengthRate) {
                this.maxLength = 1;
                for (Protein protein : this.proteinList) {
                    int end = protein.getEnd();
                    if (end <= this.maxLength) continue;
                    this.maxLength = end;
                }
                this.LENGTH_RATE = 600.0 / (double)this.maxLength;
            }
            for (Protein protein : this.proteinList) {
                if (!this.isLengthRate) {
                    this.LENGTH_RATE = 600.0 / (double)protein.getEnd();
                }
                int vertical = protein.getVertical();
                int horizontal = protein.getHorizontal();
                String[] arrPro = protein.getParameter().split("#&%");
                int proteinStart = Integer.parseInt(arrPro[0]);
                DrawTypeEnum proteinStartDrawType = DrawTypeEnum.valueOf(arrPro[1]);
                int proteinEnd = Integer.parseInt(arrPro[2]);
                DrawTypeEnum proteinEndDrawType = DrawTypeEnum.valueOf(arrPro[3]);
                int proteinHeight = Integer.parseInt(arrPro[4]);
                int fontSize = Integer.parseInt(arrPro[5]);
                String proteinColorLineStr = "0,0,0";
                proteinColorLineStr = arrPro[10];
                GradientEnum GradientType = GradientEnum.valueOf(arrPro[6]);
                String SelectTextureFile = arrPro[7];
                boolean bbdash = Boolean.valueOf(arrPro[8]);
                int proteinstroke = Integer.parseInt(arrPro[9]);
                StringTokenizer ster = new StringTokenizer(proteinColorLineStr, ",");
                Color proteinLineColor = new Color(Integer.parseInt(ster.nextToken()), Integer.parseInt(ster.nextToken()), Integer.parseInt(ster.nextToken()));
                if (this.rate < 1.0f) {
                    g2d.setStroke(new BasicStroke(1.0f));
                } else {
                    g2d.setStroke(new BasicStroke((int)this.rate));
                }
                Area proteinArea = this.drawProtein(protein, null, vertical, horizontal, proteinStart, proteinStartDrawType, proteinEnd, proteinEndDrawType, proteinHeight, fontSize, this.getGrayColor(protein.getColor()), this.getGrayColor(proteinLineColor), proteinstroke, g2d, GradientType, SelectTextureFile, false);
                protein.setArea(proteinArea);
                LinkedList<Component> componentList = protein.getComponentList();
                HashMap<Integer, DomainDashConf> ddcMap = new HashMap<Integer, DomainDashConf>();
                int p = 0;
                if (componentList.size() > 0) {
                    for (int k = 0; k < componentList.size(); ++k) {
                        Component component = componentList.get(k);
                        if (component.getType() != ComponentEnum.CutLine) continue;
                        DomainDashConf ddcdomain = new DomainDashConf();
                        ddcdomain.xCenterPosition = component.getX() + (component.getX2() - component.getX()) / 2.0;
                        ddcdomain.bLDash = component.bProteinLDash;
                        ddcdomain.bRDash = component.bProteinRDash;
                        ddcdomain.dwidth = component.getX2() - component.getX();
                        ddcdomain.dheight = component.getHigh();
                        ddcdomain.Shape = component.getShapeType().name().toString();
                        ddcMap.put((int)ddcdomain.xCenterPosition, ddcdomain);
                        ++p;
                    }
                }
                DomainDashConf ddcfirst = new DomainDashConf();
                ddcfirst.xCenterPosition = proteinStart;
                ddcfirst.dwidth = 0.0;
                ddcfirst.dheight = 0.0;
                ddcfirst.Shape = "Null";
                ddcMap.put(proteinStart, ddcfirst);
                ++p;
                DomainDashConf ddclast = new DomainDashConf();
                ddclast.xCenterPosition = proteinEnd;
                ddclast.dwidth = 0.0;
                ddclast.dheight = 0.0;
                ddclast.Shape = "Null";
                ddcMap.put(proteinEnd, ddclast);
                int[] pos = new int[++p];
                int q = 0;
                Iterator itr = ddcMap.keySet().iterator();
                while (itr.hasNext()) {
                    int pos1;
                    pos[q] = pos1 = ((Integer)itr.next()).intValue();
                    ++q;
                }
                Arrays.sort(pos);
                this.drawProteinBorderDash(vertical, horizontal, proteinHeight, pos, ddcMap, this.getGrayColor(proteinLineColor), proteinstroke, bbdash, SelectTextureFile, g2d);
                for (Component component : componentList) {
                    GradientEnum GradientType2;
                    String SelectTextureFile1;
                    GradientEnum GradientType1;
                    int strokesize;
                    double iRotationAngle;
                    double iHigh;
                    int size;
                    DrawTypeEnum nameDrawType;
                    String name;
                    DrawTypeEnum endDrawType;
                    DrawTypeEnum startDrawType;
                    String[] arr;
                    Area area = new Area();
                    if (component.getType() == ComponentEnum.Domain) {
                        if (this.Mode.equals("N")) {
                            arr = component.getParameter().split("#&%");
                            startDrawType = DrawTypeEnum.valueOf(arr[0]);
                            endDrawType = DrawTypeEnum.valueOf(arr[1]);
                            name = arr[2];
                            nameDrawType = DrawTypeEnum.valueOf(arr[3]);
                            size = Integer.parseInt(arr[4]);
                            iHigh = component.getHigh();
                            iRotationAngle = component.getRotationAngle();
                            strokesize = Integer.valueOf(arr[5]);
                            GradientType1 = GradientEnum.valueOf(arr[6]);
                            SelectTextureFile1 = arr[7];
                            area = this.drawDomainN(protein, component, vertical, horizontal, (int)component.getX(), startDrawType, (int)component.getX2(), endDrawType, name, nameDrawType, size, this.getGrayColor(component.getColor()), this.getGrayColor(component.getColorText()), this.getGrayColor(component.getColorline()), g2d, component.shapeType, component.isActive(), iRotationAngle, iHigh, strokesize, GradientType1, SelectTextureFile1, component.bDash, fontSize);
                        } else {
                            String SelectTextureFile2;
                            arr = component.getParameter().split("#&%");
                            DrawTypeEnum startDrawType2 = DrawTypeEnum.valueOf(arr[0]);
                            DrawTypeEnum endDrawType2 = DrawTypeEnum.valueOf(arr[1]);
                            String name2 = arr[2];
                            DrawTypeEnum nameDrawType2 = DrawTypeEnum.valueOf(arr[3]);
                            int size2 = Integer.parseInt(arr[4]);
                            double iHigh2 = component.getHigh();
                            double iRotationAngle2 = component.getRotationAngle();
                            int strokesize2 = 1;
                            if (arr.length > 5) {
                                strokesize2 = Integer.valueOf(arr[5]);
                                GradientType2 = GradientEnum.valueOf(arr[6]);
                                SelectTextureFile2 = arr[7];
                            } else {
                                strokesize2 = 1;
                                GradientType2 = GradientEnum.valueOf("Null");
                                SelectTextureFile2 = "00000_0.jpg";
                            }
                            area = this.drawDomain(protein, component, vertical, horizontal, (int)component.getX(), startDrawType2, (int)component.getX2(), endDrawType2, name2, nameDrawType2, size2, this.getGrayColor(component.getColor()), this.getGrayColor(component.getColorText()), this.getGrayColor(component.getColorline()), g2d, component.shapeType, component.isActive(), iRotationAngle2, iHigh2, strokesize2, GradientType2, SelectTextureFile2, component.bDash, fontSize);
                        }
                    }
                    if (component.getType() == ComponentEnum.CutLine) {
                        if (this.Mode.equals("N")) {
                            arr = component.getParameter().split("#&%");
                            startDrawType = DrawTypeEnum.valueOf(arr[0]);
                            endDrawType = DrawTypeEnum.valueOf(arr[1]);
                            name = arr[2];
                            nameDrawType = DrawTypeEnum.valueOf(arr[3]);
                            size = Integer.parseInt(arr[4]);
                            iHigh = component.getHigh();
                            iRotationAngle = component.getRotationAngle();
                            strokesize = Integer.valueOf(arr[5]);
                            GradientType1 = GradientEnum.valueOf(arr[6]);
                            SelectTextureFile1 = arr[7];
                            area = this.drawCutLineN(protein, component, vertical, horizontal, (int)component.getX(), startDrawType, (int)component.getX2(), endDrawType, name, nameDrawType, size, this.getGrayColor(component.getColor()), this.getGrayColor(component.getColorText()), this.getGrayColor(component.getColorline()), g2d, component.shapeType, component.isActive(), iRotationAngle, iHigh, strokesize, GradientType1, SelectTextureFile1, component.bDash, fontSize);
                        } else {
                            String SelectTextureFile2;
                            arr = component.getParameter().split("#&%");
                            startDrawType = DrawTypeEnum.valueOf(arr[0]);
                            endDrawType = DrawTypeEnum.valueOf(arr[1]);
                            name = arr[2];
                            nameDrawType = DrawTypeEnum.valueOf(arr[3]);
                            size = Integer.parseInt(arr[4]);
                            iHigh = component.getHigh();
                            iRotationAngle = component.getRotationAngle();
                            int strokesize3 = 1;
                            if (arr.length > 5) {
                                strokesize3 = Integer.valueOf(arr[5]);
                                GradientType2 = GradientEnum.valueOf(arr[6]);
                                SelectTextureFile2 = arr[7];
                            } else {
                                strokesize3 = 1;
                                GradientType2 = GradientEnum.valueOf("Null");
                                SelectTextureFile2 = "00000_0.jpg";
                            }
                            area = this.drawCutLine(protein, component, vertical, horizontal, (int)component.getX(), startDrawType, (int)component.getX2(), endDrawType, name, nameDrawType, size, this.getGrayColor(component.getColor()), this.getGrayColor(component.getColorText()), this.getGrayColor(component.getColorline()), g2d, component.shapeType, component.isActive(), iRotationAngle, iHigh, strokesize3, GradientType2, SelectTextureFile2, component.bDash, fontSize);
                        }
                    } else if (component.getType() == ComponentEnum.Site) {
                        arr = component.getParameter().split("#&%");
                        String site = arr[0];
                        String text = arr[1];
                        int deltaX = (int)component.getCenterx();
                        int deltaY = (int)component.getCentery();
                        size = Integer.parseInt(arr[2]);
                        boolean isShowPosition = Boolean.valueOf(arr[3]);
                        int strokesize4 = Integer.valueOf(arr[4]);
                        GradientEnum GradientType12 = GradientEnum.valueOf(arr[5]);
                        String SelectTextureFile12 = arr[6];
                        area = this.drawSite(protein, component, vertical, horizontal, site, text, deltaX, deltaY, size, isShowPosition, this.getGrayColor(component.getColorText()), this.getGrayColor(component.getColor()), this.getGrayColor(component.getColorline()), component.shapeType, component.isActive(), component.getRotationAngle(), component.getWide(), component.getHigh(), strokesize4, GradientType12, SelectTextureFile12, g2d, component.bDash);
                    } else if (component.getType() == ComponentEnum.Note) {
                        arr = component.getParameter().split("#&%");
                        String title = arr[0].trim();
                        int size3 = Integer.parseInt(arr[1]);
                        DrawTypeEnum style = DrawTypeEnum.valueOf(arr[2]);
                        double angle = component.getRotationAngle();
                        int linesize = Integer.parseInt(arr[4]);
                        Color colorline = component.getColorline();
                        Boolean bdash = component.bDash;
                        String strFont = arr.length > 5 ? arr[5] : "Arial";
                        area = this.drawNote(protein, component, vertical, horizontal, title, (int)component.x, component.y, size3, style, angle, this.getGrayColor(component.getColor()), component.isActive(), linesize, colorline, bdash, strFont, g2d);
                    } else if (component.getType() == ComponentEnum.Line) {
                        arr = component.getParameter().split("#&%");
                        int lineWeight = Integer.parseInt(arr[0]);
                        DrawTypeEnum style = DrawTypeEnum.valueOf(arr[1]);
                        String fname = "";
                        size = 10;
                        if (arr.length > 2) {
                            fname = arr[2];
                            nameDrawType = DrawTypeEnum.valueOf(arr[3]);
                            size = Integer.parseInt(arr[4]);
                            fname.trim();
                        } else {
                            fname = "";
                            nameDrawType = DrawTypeEnum.Center;
                            size = 10;
                        }
                        int x1 = (int)component.getX();
                        int y1 = component.getY();
                        Point point1 = new Point(x1, y1);
                        int x2 = (int)component.getX2();
                        int y2 = component.getY2();
                        Point point2 = new Point(x2, y2);
                        int x3 = component.getControlx1();
                        int y3 = component.getControly1();
                        Point point4 = new Point(x3, y3);
                        int x4 = component.getControlx2();
                        int y4 = component.getControly2();
                        Point point5 = new Point(x4, y4);
                        if (component.shapeType == null) {
                            component.shapeType = ShapeEnum.Straight;
                        }
                        area = this.drawLine(protein, component, vertical, horizontal, point1, point2, point4, point5, style, lineWeight, this.getGrayColor(component.getColor()), g2d, component.isActive(), component.shapeType, fname, nameDrawType, size, this.getGrayColor(component.getColorText()));
                    } else if (component.getType() == ComponentEnum.Polygon) {
                        arr = component.getParameter().split("#&%");
                        String name3 = arr[0];
                        int size4 = Integer.parseInt(arr[2]);
                        DrawTypeEnum nameDrawType3 = DrawTypeEnum.valueOf(arr[1]);
                        int strokesize5 = Integer.valueOf(arr[3]);
                        GradientEnum GradientType13 = GradientEnum.valueOf(arr[4]);
                        String SelectTextureFile13 = arr[5];
                        area = this.drawPolygon(protein, component, vertical, horizontal, (int)component.getCenterx(), (int)component.getCentery(), component.getWide(), component.getHigh(), component.getRotationAngle(), name3, nameDrawType3, size4, this.getGrayColor(component.getColor()), this.getGrayColor(component.getColorText()), this.getGrayColor(component.getColorline()), g2d, component.shapeType, component.isActive(), strokesize5, GradientType13, SelectTextureFile13, component.bDash);
                    } else if (component.getType() == ComponentEnum.Bracket) {
                        arr = component.getParameter().split("#&%");
                        int strokesize6 = Integer.valueOf(arr[0]);
                        area = this.drawBracket(protein, component, vertical, horizontal, (int)component.getCenterx(), (int)component.getCentery(), (int)component.getWide(), (int)component.getRotationAngle(), this.getGrayColor(component.getColor()), g2d, component.shapeType, component.isActive(), strokesize6);
                    }
                    component.setArea(area);
                }
            }
        }
        g2d.dispose();
    }

    private void drawProteinBorderDash(int vertical, int horizontal, int height, int[] pos, Map<Integer, DomainDashConf> ddcMap, Color colorline, int strokesize, boolean proteinbdash, String SelectTextureFile, Graphics2D g2d) {
        Stroke origstroke = g2d.getStroke();
        Color colororig = g2d.getColor();
        g2d.setColor(colorline);
        vertical = -vertical;
        this.HALF_HEIGHT = (double)height / 2.0;
        this.positionFontMetrics = g2d.getFontMetrics();
        this.LINE_HEIGHT = this.positionFontMetrics.getHeight();
        if (ddcMap.size() > 0) {
            for (int i = 0; i < pos.length && i != pos.length - 1; ++i) {
                float[] dash1;
                double endXd;
                double endXu;
                double startXd;
                double startXu;
                DomainDashConf ddci = ddcMap.get(pos[i]);
                DomainDashConf ddcj = ddcMap.get(pos[i + 1]);
                if (ddci == null || ddcj == null) continue;
                if (ddci.dheight == 0.0 && ddci.dheight == 0.0) {
                    startXu = (-300.0 + (double)horizontal + ddci.xCenterPosition * this.LENGTH_RATE) * (double)this.rate;
                    startXd = (-300.0 + (double)horizontal + ddci.xCenterPosition * this.LENGTH_RATE) * (double)this.rate;
                } else {
                    startXu = ddci.Shape.equals("L_ParallelLine") || ddci.Shape.equals("L_ParallelCurve") ? (-300.0 + (double)horizontal + (ddci.xCenterPosition - ddci.dwidth / 2.0) * this.LENGTH_RATE) * (double)this.rate : (-300.0 + (double)horizontal + (ddci.xCenterPosition + ddci.dwidth / 2.0) * this.LENGTH_RATE) * (double)this.rate;
                    startXd = ddci.Shape.equals("L_ParallelLine") || ddci.Shape.equals("L_ParallelCurve") ? (-300.0 + (double)horizontal + (ddci.xCenterPosition + ddci.dwidth / 2.0) * this.LENGTH_RATE) * (double)this.rate : (-300.0 + (double)horizontal + (ddci.xCenterPosition - ddci.dwidth / 2.0) * this.LENGTH_RATE) * (double)this.rate;
                }
                if (ddcj.dheight == 0.0 && ddcj.dheight == 0.0) {
                    endXu = (-300.0 + (double)horizontal + ddcj.xCenterPosition * this.LENGTH_RATE) * (double)this.rate;
                    endXd = (-300.0 + (double)horizontal + ddcj.xCenterPosition * this.LENGTH_RATE) * (double)this.rate;
                } else {
                    endXu = ddcj.Shape.equals("L_ParallelLine") || ddcj.Shape.equals("L_ParallelCurve") ? (-300.0 + (double)horizontal + (ddcj.xCenterPosition - ddcj.dwidth / 2.0) * this.LENGTH_RATE) * (double)this.rate : (-300.0 + (double)horizontal + (ddcj.xCenterPosition + ddcj.dwidth / 2.0) * this.LENGTH_RATE) * (double)this.rate;
                    endXd = ddcj.Shape.equals("L_ParallelLine") || ddcj.Shape.equals("L_ParallelCurve") ? (-300.0 + (double)horizontal + (ddcj.xCenterPosition + ddcj.dwidth / 2.0) * this.LENGTH_RATE) * (double)this.rate : (-300.0 + (double)horizontal + (ddcj.xCenterPosition - ddcj.dwidth / 2.0) * this.LENGTH_RATE) * (double)this.rate;
                }
                double startY = ((double)vertical - this.HALF_HEIGHT) * (double)this.rate;
                double endY = ((double)vertical + this.HALF_HEIGHT) * (double)this.rate;
                Line2D.Double upline = new Line2D.Double((int)Math.round(startXu), (int)Math.round(startY), (int)Math.round(endXu), (int)Math.round(startY));
                Line2D.Double downline = new Line2D.Double((int)Math.round(startXd), (int)Math.round(endY), (int)Math.round(endXd), (int)Math.round(endY));
                boolean isDash = false;
                isDash = ddci.bRDash || ddcj.bLDash;
                float thick = strokesize;
                if (SelectTextureFile.equals("00000_1.jpg")) {
                    if (ddcMap.size() > 2) {
                        if (isDash) {
                            dash1 = new float[]{5.0f};
                            g2d.setStroke(new BasicStroke(thick, 1, 1, 20.0f, dash1, 0.0f));
                        } else {
                            g2d.setStroke(new BasicStroke(thick, 1, 1));
                        }
                    } else if (proteinbdash) {
                        dash1 = new float[]{5.0f};
                        g2d.setStroke(new BasicStroke(thick, 1, 1, 20.0f, dash1, 0.0f));
                    } else {
                        g2d.setStroke(new BasicStroke(thick, 1, 1));
                    }
                } else if (ddcMap.size() > 2) {
                    if (isDash) {
                        dash1 = new float[]{5.0f};
                        g2d.setStroke(new BasicStroke(thick * this.rate, 1, 1, 20.0f, dash1, 0.0f));
                    } else {
                        g2d.setStroke(new BasicStroke(thick * this.rate, 1, 1));
                    }
                } else if (proteinbdash) {
                    dash1 = new float[]{5.0f};
                    g2d.setStroke(new BasicStroke(thick * this.rate, 1, 1, 20.0f, dash1, 0.0f));
                } else {
                    g2d.setStroke(new BasicStroke(thick * this.rate, 1, 1));
                }
                g2d.draw(upline);
                g2d.draw(downline);
                Line2D.Double leftline1 = new Line2D.Double((int)Math.round(startXu), (int)Math.round(startY), (int)Math.round(startXd), (int)Math.round(endY));
                Line2D.Double rightline1 = new Line2D.Double((int)Math.round(endXu), (int)Math.round(startY), (int)Math.round(endXd), (int)Math.round(endY));
                Line2D.Double rightline2 = new Line2D.Double((int)Math.round(endXu), (int)Math.round(startY), (int)Math.round(endXd), (int)Math.round(endY));
                if (i == 0) {
                    g2d.draw(leftline1);
                    if (pos.length != 2) continue;
                    g2d.draw(rightline1);
                    continue;
                }
                if (i != pos.length - 2) continue;
                g2d.draw(rightline2);
            }
        }
        g2d.setColor(colororig);
        g2d.setStroke(origstroke);
    }

    private Area drawProtein(Protein pr, Component com, int vertical, int horizontal, int start, DrawTypeEnum startDrawType, int end, DrawTypeEnum endDrawType, int height, int size, Color color, Color colorline, int proteinstroke, Graphics2D g2d, GradientEnum GradientType, String SelectTextureFile, boolean isborderdahs) {
        Line2D.Double endline;
        Line2D.Double startline;
        Stroke origstroke = g2d.getStroke();
        vertical = -vertical;
        this.HALF_HEIGHT = (double)height / 2.0;
        this.positionFontSize = (int)((float)size * this.rate);
        double startX = -300.0 + (double)horizontal + (double)start * this.LENGTH_RATE;
        double endX = -300.0 + (double)horizontal + (double)end * this.LENGTH_RATE;
        double centerX = (endX - startX) / 2.0;
        g2d.setFont(new Font("Arial", 1, this.positionFontSize));
        this.positionFontMetrics = g2d.getFontMetrics();
        this.LINE_HEIGHT = this.positionFontMetrics.getHeight();
        double lineHeight = this.HALF_HEIGHT * (double)this.rate + (double)this.LINE_HEIGHT;
        double comhalf_heigh = this.HALF_HEIGHT;
        double startY = ((double)vertical - this.HALF_HEIGHT) * (double)this.rate;
        double endY = ((double)vertical + this.HALF_HEIGHT) * (double)this.rate;
        double centerY = startY + (endY - startY) / 2.0;
        startY = Math.round(startY);
        endY = Math.round(endY);
        PolygonXY pgxy = new PolygonXY();
        pgxy.getPolygonXY(startX * (double)this.rate, startY, endX * (double)this.rate, endY, "Rectangle", 0.0, this.rate);
        pgxy.CacuMinMaxXY();
        Color colorbk = colorline;
        this.drawPolygonTextureRect(pr, null, g2d, pgxy.minx, startY, pgxy.maxx, endY, pgxy, SelectTextureFile, origstroke, color, colorbk, GradientType, ShapeEnum.Rectangle, proteinstroke, false, vertical, comhalf_heigh, isborderdahs);
        int iradius = 5;
        int iradius2 = 20;
        if (pr.isActive()) {
            g2d.setColor(Color.ORANGE);
            Ellipse2D.Double shapeAnchor1 = new Ellipse2D.Double((float)((int)endX) * this.rate - (float)iradius, (int)startY - iradius2, 2 * iradius, 2 * iradius);
            Ellipse2D.Double shapeAnchor2 = new Ellipse2D.Double((float)((int)startX) * this.rate - (float)iradius, (int)startY - iradius2, 2 * iradius, 2 * iradius);
            Ellipse2D.Double shapeAnchor3 = new Ellipse2D.Double((float)((int)startX) * this.rate - (float)iradius, (double)((int)endY) + (double)iradius2 / 2.0, 2 * iradius, 2 * iradius);
            Ellipse2D.Double shapeAnchor4 = new Ellipse2D.Double((float)((int)endX) * this.rate - (float)iradius, (double)((int)endY) + (double)iradius2 / 2.0, 2 * iradius, 2 * iradius);
            g2d.fill(shapeAnchor4);
            g2d.fill(shapeAnchor3);
            g2d.fill(shapeAnchor2);
            g2d.fill(shapeAnchor1);
        }
        float thick2 = proteinstroke;
        if (SelectTextureFile.equals("00000_1.jpg")) {
            g2d.setStroke(new BasicStroke(1.0f, 1, 1));
        } else {
            g2d.setStroke(new BasicStroke(Math.round(thick2 * this.rate), 1, 1));
        }
        g2d.setColor(Color.BLACK);
        if (startDrawType == DrawTypeEnum.Down) {
            startline = new Line2D.Double((int)Math.round(startX * (double)this.rate), ((double)vertical + this.HALF_HEIGHT) * (double)this.rate, (int)Math.round(startX * (double)this.rate), (double)((float)vertical * this.rate) + lineHeight);
            g2d.draw(startline);
            g2d.drawString(String.valueOf(start), (int)Math.round(startX * (double)this.rate - (double)this.positionFontMetrics.stringWidth(String.valueOf(start)) / 2.0), (int)Math.round((double)((float)vertical * this.rate) + lineHeight + (double)this.positionFontMetrics.getAscent()));
        } else if (startDrawType == DrawTypeEnum.Up) {
            startline = new Line2D.Double((int)Math.round(startX * (double)this.rate), ((double)vertical - this.HALF_HEIGHT) * (double)this.rate, (int)Math.round(startX * (double)this.rate), (double)((float)vertical * this.rate) - lineHeight);
            g2d.draw(startline);
            g2d.drawString(String.valueOf(start), (int)Math.round(startX * (double)this.rate - (double)this.positionFontMetrics.stringWidth(String.valueOf(start)) / 2.0), (int)Math.round((double)((float)vertical * this.rate) - lineHeight - (double)this.positionFontMetrics.getDescent()));
        } else if (startDrawType == DrawTypeEnum.Hide) {
            // empty if block
        }
        if (endDrawType == DrawTypeEnum.Down) {
            endline = new Line2D.Double(Math.round(pgxy.maxx), ((double)vertical + this.HALF_HEIGHT) * (double)this.rate, Math.round(pgxy.maxx), (double)((float)vertical * this.rate) + lineHeight);
            g2d.draw(endline);
            g2d.drawString(String.valueOf(end), (int)Math.round((double)Math.round(pgxy.maxx) - (double)this.positionFontMetrics.stringWidth(String.valueOf(end)) / 2.0), (int)Math.round((double)((float)vertical * this.rate) + lineHeight + (double)this.positionFontMetrics.getAscent()));
        } else if (endDrawType == DrawTypeEnum.Up) {
            endline = new Line2D.Double(Math.round(pgxy.maxx), ((double)vertical - this.HALF_HEIGHT) * (double)this.rate, Math.round(pgxy.maxx), (double)((float)vertical * this.rate) - lineHeight);
            g2d.draw(endline);
            g2d.drawString(String.valueOf(end), (int)Math.round((double)Math.round(pgxy.maxx) - (double)this.positionFontMetrics.stringWidth(String.valueOf(end)) / 2.0), (int)Math.round((double)((float)vertical * this.rate) - lineHeight - (double)this.positionFontMetrics.getDescent()));
        } else if (endDrawType == DrawTypeEnum.Hide) {
            // empty if block
        }
        g2d.setStroke(origstroke);
        return new Area(startX * (double)this.rate, ((double)vertical - this.HALF_HEIGHT) * (double)this.rate - 10.0, endX * (double)this.rate, ((double)vertical + this.HALF_HEIGHT) * (double)this.rate + 10.0);
    }

    private Area drawDomain(Protein pr, Component com, int vertical, int horizontal, double start, DrawTypeEnum startDrawType, double end, DrawTypeEnum endDrawType, String name, DrawTypeEnum nameDrawType, int size, Color color, Color colortext, Color colorline, Graphics2D g2d, ShapeEnum shapeType, boolean isActive, double iRotationAngle, double iHigh, int strokesize, GradientEnum GradientType, String SelectTextureFile, boolean isborderdahs, int posSize) {
        Line2D.Double endline;
        Line2D.Double startline;
        float[] dash1;
        double endY;
        double startY;
        Color colororig = g2d.getColor();
        Stroke origstroke = g2d.getStroke();
        vertical = -vertical;
        double startX = -300.0 + (double)horizontal + start * this.LENGTH_RATE;
        double endX = 0.0;
        double centerX = 0.0;
        double centerY = 0.0;
        endX = -300.0 + (double)horizontal + (start + (end - start)) * this.LENGTH_RATE;
        centerX = -300.0 + (double)horizontal + (start + (end - start) / 2.0) * this.LENGTH_RATE;
        double lineHeight = this.HALF_HEIGHT * (double)this.rate + (double)this.LINE_HEIGHT;
        startX *= (double)this.rate;
        endX *= (double)this.rate;
        if (iHigh == 0.0) {
            startY = ((double)vertical - this.HALF_HEIGHT) * (double)this.rate;
            endY = ((double)vertical + this.HALF_HEIGHT) * (double)this.rate;
        } else {
            int iVhigh = (int)(iHigh * 2.0 * this.LENGTH_RATE);
            startY = ((double)vertical - (double)iVhigh / 4.0) * (double)this.rate;
            endY = ((double)vertical + (double)iVhigh / 4.0) * (double)this.rate;
        }
        double comhalf_heigh = (endY - startY) / 2.0;
        int iradius = 4;
        Color ac = Color.BLUE;
        Color pc = new Color(0, 255, 0);
        centerX = startX + (endX - startX) / 2.0;
        centerY = startY + (endY - startY) / 2.0;
        Color colorbk = colorline;
        Area sa = new Area();
        sa = this.drawPolygonAndAnchor(g2d, pr, com, isActive, vertical, color, colorline, colororig, colortext, origstroke, strokesize, size, name, nameDrawType, SelectTextureFile, GradientType, shapeType, iradius, comhalf_heigh, centerX, centerY, (int)Math.round(startX), (int)Math.round(startY), (int)Math.round(endX), (int)Math.round(endY), iRotationAngle, isborderdahs);
        float thick = strokesize;
        if (!SelectTextureFile.equals("00000_1.jpg")) {
            if (isborderdahs) {
                dash1 = new float[]{5.0f};
                g2d.setStroke(new BasicStroke(Math.round((float)strokesize * this.rate), 1, 1, 20.0f, dash1, 0.0f));
            } else {
                g2d.setStroke(new BasicStroke(Math.round(thick * this.rate), 1, 1));
            }
        } else if (isborderdahs) {
            dash1 = new float[]{5.0f};
            g2d.setStroke(new BasicStroke(Math.round(strokesize), 1, 1, 20.0f, dash1, 0.0f));
        } else {
            g2d.setStroke(new BasicStroke(Math.round(thick), 1, 1));
        }
        g2d.setFont(new Font("Arial", 1, (int)((float)posSize * this.rate)));
        if (startDrawType == DrawTypeEnum.Down) {
            startline = new Line2D.Double(Math.round(com.pgxy.minx), ((double)vertical + this.HALF_HEIGHT) * (double)this.rate, Math.round(com.pgxy.minx), (double)((float)vertical * this.rate) + lineHeight);
            g2d.setColor(colorline);
            g2d.draw(startline);
            g2d.setColor(colortext);
            g2d.drawString(String.valueOf((int)start), (float)((double)com.pgxy.minx - (double)this.positionFontMetrics.stringWidth(String.valueOf((int)start)) / 2.0), (float)((double)((float)vertical * this.rate) + lineHeight + (double)this.positionFontMetrics.getAscent()));
        } else if (startDrawType == DrawTypeEnum.Up) {
            startline = new Line2D.Double(Math.round(com.pgxy.minx), ((double)vertical - this.HALF_HEIGHT) * (double)this.rate, Math.round(com.pgxy.minx), (double)((float)vertical * this.rate) - lineHeight);
            g2d.setColor(colorline);
            g2d.draw(startline);
            g2d.setColor(colortext);
            g2d.drawString(String.valueOf((int)start), (float)((double)com.pgxy.minx - (double)this.positionFontMetrics.stringWidth(String.valueOf((int)start)) / 2.0), (float)((double)((float)vertical * this.rate) - lineHeight - (double)this.positionFontMetrics.getDescent()));
        } else if (startDrawType == DrawTypeEnum.Hide) {
            // empty if block
        }
        if (endDrawType == DrawTypeEnum.Down) {
            endline = new Line2D.Double(Math.round(com.pgxy.maxx), ((double)vertical + this.HALF_HEIGHT) * (double)this.rate, Math.round(com.pgxy.maxx), (double)((float)vertical * this.rate) + lineHeight);
            g2d.setColor(colorline);
            g2d.draw(endline);
            g2d.setColor(colortext);
            g2d.drawString(String.valueOf((int)end), (float)((double)com.pgxy.maxx - (double)this.positionFontMetrics.stringWidth(String.valueOf((int)end)) / 2.0), (float)((double)((float)vertical * this.rate) + lineHeight + (double)this.positionFontMetrics.getAscent()));
        } else if (endDrawType == DrawTypeEnum.Up) {
            endline = new Line2D.Double(Math.round(com.pgxy.maxx), ((double)vertical - this.HALF_HEIGHT) * (double)this.rate, Math.round(com.pgxy.maxx), (double)((float)vertical * this.rate) - lineHeight);
            g2d.setColor(colorline);
            g2d.draw(endline);
            g2d.setColor(colortext);
            g2d.drawString(String.valueOf((int)end), (float)((double)com.pgxy.maxx - (double)this.positionFontMetrics.stringWidth(String.valueOf((int)end)) / 2.0), (float)((double)((float)vertical * this.rate) - lineHeight - (double)this.positionFontMetrics.getDescent()));
        } else if (endDrawType == DrawTypeEnum.Hide) {
            // empty if block
        }
        g2d.setColor(colororig);
        g2d.setStroke(origstroke);
        return new Area(startX * (double)this.rate, ((double)vertical - this.HALF_HEIGHT) * (double)this.rate - 10.0, endX * (double)this.rate, ((double)vertical + this.HALF_HEIGHT) * (double)this.rate + 10.0);
    }

    private Area drawDomainN(Protein pr, Component com, int vertical, int horizontal, double start, DrawTypeEnum startDrawType, double end, DrawTypeEnum endDrawType, String name, DrawTypeEnum nameDrawType, int size, Color color, Color colortext, Color colorline, Graphics2D g2d, ShapeEnum shapeType, boolean isActive, double iRotationAngle, double iHigh, int strokesize, GradientEnum GradientType, String SelectTextureFile, boolean isborderdahs, int posSize) {
        Line2D.Double endline;
        Line2D.Double startline;
        float[] dash1;
        double endY;
        double startY;
        Color colororig = g2d.getColor();
        Stroke origstroke = g2d.getStroke();
        vertical = -vertical;
        double iVhigh = (int)(iHigh * 2.0 * this.LENGTH_RATE);
        double startX = -300.0 + (double)horizontal + start * this.LENGTH_RATE;
        double endX = 0.0;
        double centerX = 0.0;
        double centerY = 0.0;
        endX = -300.0 + (double)horizontal + (start + (end - start)) * this.LENGTH_RATE;
        centerX = -300.0 + (double)horizontal + (start + (end - start) / 2.0) * this.LENGTH_RATE;
        double lineHeight = this.HALF_HEIGHT * (double)this.rate + (double)this.LINE_HEIGHT;
        startX *= (double)this.rate;
        endX *= (double)this.rate;
        if (iVhigh / 4.0 < this.HALF_HEIGHT) {
            startY = ((double)vertical - this.HALF_HEIGHT) * (double)this.rate;
            endY = ((double)vertical + this.HALF_HEIGHT) * (double)this.rate;
        } else {
            startY = ((double)vertical - iVhigh / 4.0) * (double)this.rate;
            endY = ((double)vertical + iVhigh / 4.0) * (double)this.rate;
        }
        double comhalf_heigh = (endY - startY) / 2.0;
        int iradius = 4;
        Color ac = Color.BLUE;
        Color pc = new Color(0, 255, 0);
        centerX = startX + (endX - startX) / 2.0;
        centerY = startY + (endY - startY) / 2.0;
        Color colorbk = colorline;
        Area sa = new Area();
        sa = this.drawPolygonAndAnchor(g2d, pr, com, isActive, vertical, color, colorline, colororig, colortext, origstroke, strokesize, size, name, nameDrawType, SelectTextureFile, GradientType, shapeType, iradius, comhalf_heigh, centerX, centerY, startX, startY, endX, endY, iRotationAngle, isborderdahs);
        if (!SelectTextureFile.equals("00000_1.jpg")) {
            if (isborderdahs) {
                dash1 = new float[]{5.0f};
                g2d.setStroke(new BasicStroke((float)strokesize * this.rate, 1, 1, 20.0f, dash1, 0.0f));
            } else {
                g2d.setStroke(new BasicStroke((float)strokesize * this.rate, 1, 1));
            }
        } else if (isborderdahs) {
            dash1 = new float[]{5.0f};
            g2d.setStroke(new BasicStroke(strokesize, 1, 1, 20.0f, dash1, 0.0f));
        } else {
            g2d.setStroke(new BasicStroke(strokesize, 1, 1));
        }
        g2d.setColor(colortext);
        g2d.setFont(new Font("Arial", 1, (int)((float)posSize * this.rate)));
        if (startDrawType == DrawTypeEnum.Down) {
            startline = new Line2D.Double(Math.round(com.pgxy.minx), ((double)vertical + this.HALF_HEIGHT) * (double)this.rate, Math.round(com.pgxy.minx), (double)((float)vertical * this.rate) + lineHeight);
            g2d.setColor(colorline);
            g2d.draw(startline);
            g2d.setColor(colortext);
            g2d.drawString(String.valueOf((int)start), (float)((double)com.pgxy.minx - (double)this.positionFontMetrics.stringWidth(String.valueOf((int)start)) / 2.0), (float)((double)((float)vertical * this.rate) + lineHeight + (double)this.positionFontMetrics.getAscent()));
        } else if (startDrawType == DrawTypeEnum.Up) {
            startline = new Line2D.Double(Math.round(com.pgxy.minx), ((double)vertical - this.HALF_HEIGHT) * (double)this.rate, Math.round(com.pgxy.minx), (double)((float)vertical * this.rate) - lineHeight);
            g2d.setColor(colorline);
            g2d.draw(startline);
            g2d.setColor(colortext);
            g2d.drawString(String.valueOf((int)start), (float)((double)com.pgxy.minx - (double)this.positionFontMetrics.stringWidth(String.valueOf((int)start)) / 2.0), (float)((double)((float)vertical * this.rate) - lineHeight - (double)this.positionFontMetrics.getDescent()));
        } else if (startDrawType == DrawTypeEnum.Hide) {
            // empty if block
        }
        if (endDrawType == DrawTypeEnum.Down) {
            endline = new Line2D.Double(Math.round(com.pgxy.maxx), ((double)vertical + this.HALF_HEIGHT) * (double)this.rate, Math.round(com.pgxy.maxx), (double)((float)vertical * this.rate) + lineHeight);
            g2d.setColor(colorline);
            g2d.draw(endline);
            g2d.setColor(colortext);
            g2d.drawString(String.valueOf((int)end), (float)((double)com.pgxy.maxx - (double)this.positionFontMetrics.stringWidth(String.valueOf((int)end)) / 2.0), (float)((double)((float)vertical * this.rate) + lineHeight + (double)this.positionFontMetrics.getAscent()));
        } else if (endDrawType == DrawTypeEnum.Up) {
            endline = new Line2D.Double(Math.round(com.pgxy.maxx), ((double)vertical - this.HALF_HEIGHT) * (double)this.rate, Math.round(com.pgxy.maxx), (double)((float)vertical * this.rate) - lineHeight);
            g2d.setColor(colorline);
            g2d.draw(endline);
            g2d.setColor(colortext);
            g2d.drawString(String.valueOf((int)end), (float)((double)com.pgxy.maxx - (double)this.positionFontMetrics.stringWidth(String.valueOf((int)end)) / 2.0), (float)((double)((float)vertical * this.rate) - lineHeight - (double)this.positionFontMetrics.getDescent()));
        } else if (endDrawType == DrawTypeEnum.Hide) {
            // empty if block
        }
        g2d.setStroke(origstroke);
        return new Area(startX * (double)this.rate, ((double)vertical - this.HALF_HEIGHT) * (double)this.rate - 10.0, endX * (double)this.rate, ((double)vertical + this.HALF_HEIGHT) * (double)this.rate + 10.0);
    }

    private Area drawCutLine(Protein pr, Component com, int vertical, int horizontal, double start, DrawTypeEnum startDrawType, double end, DrawTypeEnum endDrawType, String name, DrawTypeEnum nameDrawType, int size, Color color, Color colortext, Color colorline, Graphics2D g2d, ShapeEnum shapeType, boolean isActive, double iRotationAngle, double iHigh, int strokesize, GradientEnum GradientType, String SelectTextureFile, boolean isborderdahs, int posSize) {
        double endY;
        double startY;
        Color colororig = g2d.getColor();
        Stroke origstroke = g2d.getStroke();
        vertical = -vertical;
        double startX = -300.0 + (double)horizontal + start * this.LENGTH_RATE;
        double endX = 0.0;
        double centerX = 0.0;
        double centerY = 0.0;
        endX = -300.0 + (double)horizontal + (start + (end - start)) * this.LENGTH_RATE;
        centerX = -300.0 + (double)horizontal + (start + (end - start) / 2.0) * this.LENGTH_RATE;
        double lineHeight = this.HALF_HEIGHT * (double)this.rate + (double)this.LINE_HEIGHT;
        startX *= (double)this.rate;
        endX *= (double)this.rate;
        if (iHigh == 0.0) {
            startY = ((double)vertical - this.HALF_HEIGHT) * (double)this.rate;
            endY = ((double)vertical + this.HALF_HEIGHT) * (double)this.rate;
        } else {
            int iVhigh = (int)(iHigh * 2.0 * this.LENGTH_RATE);
            startY = ((double)vertical - (double)iVhigh / 4.0) * (double)this.rate;
            endY = ((double)vertical + (double)iVhigh / 4.0) * (double)this.rate;
        }
        double comhalf_heigh = (endY - startY) / 2.0;
        int iradius = 4;
        Color ac = Color.BLUE;
        Color pc = new Color(0, 255, 0);
        centerX = startX + (endX - startX) / 2.0;
        centerY = startY + (endY - startY) / 2.0;
        Color colorbk = colorline;
        Area sa = new Area();
        sa = this.drawPolygonAndAnchor(g2d, pr, com, isActive, vertical, color, colorline, colororig, colortext, origstroke, strokesize, size, name, nameDrawType, SelectTextureFile, GradientType, shapeType, iradius, comhalf_heigh, centerX, centerY, (int)Math.round(startX), (int)Math.round(startY), (int)Math.round(endX), (int)Math.round(endY), iRotationAngle, isborderdahs);
        g2d.setColor(colororig);
        g2d.setStroke(origstroke);
        return new Area(startX * (double)this.rate, ((double)vertical - this.HALF_HEIGHT) * (double)this.rate - 10.0, endX * (double)this.rate, ((double)vertical + this.HALF_HEIGHT) * (double)this.rate + 10.0);
    }

    private Area drawCutLineN(Protein pr, Component com, int vertical, int horizontal, double start, DrawTypeEnum startDrawType, double end, DrawTypeEnum endDrawType, String name, DrawTypeEnum nameDrawType, int size, Color color, Color colortext, Color colorline, Graphics2D g2d, ShapeEnum shapeType, boolean isActive, double iRotationAngle, double iHigh, int strokesize, GradientEnum GradientType, String SelectTextureFile, boolean isborderdahs, int posSize) {
        double endY;
        double startY;
        Color colororig = g2d.getColor();
        Stroke origstroke = g2d.getStroke();
        vertical = -vertical;
        int iVhigh = (int)(iHigh * 2.0 * this.LENGTH_RATE);
        double startX = -300.0 + (double)horizontal + start * this.LENGTH_RATE;
        double endX = 0.0;
        double centerX = 0.0;
        double centerY = 0.0;
        endX = -300.0 + (double)horizontal + (start + (end - start)) * this.LENGTH_RATE;
        centerX = -300.0 + (double)horizontal + (start + (end - start) / 2.0) * this.LENGTH_RATE;
        double lineHeight = this.HALF_HEIGHT * (double)this.rate + (double)this.LINE_HEIGHT;
        startX *= (double)this.rate;
        endX *= (double)this.rate;
        if ((double)(iVhigh / 4) < this.HALF_HEIGHT) {
            startY = ((double)vertical - this.HALF_HEIGHT) * (double)this.rate;
            endY = ((double)vertical + this.HALF_HEIGHT) * (double)this.rate;
        } else {
            startY = (float)(vertical - iVhigh / 4) * this.rate;
            endY = (float)(vertical + iVhigh / 4) * this.rate;
        }
        double comhalf_heigh = (endY - startY) / 2.0;
        int iradius = 4;
        Color ac = Color.BLUE;
        Color pc = new Color(0, 255, 0);
        centerX = startX + (endX - startX) / 2.0;
        centerY = startY + (endY - startY) / 2.0;
        Color colorbk = colorline;
        Area sa = new Area();
        sa = this.drawPolygonAndAnchor(g2d, pr, com, isActive, vertical, color, colorline, colororig, colortext, origstroke, strokesize, size, name, nameDrawType, SelectTextureFile, GradientType, shapeType, iradius, comhalf_heigh, centerX, centerY, startX, startY, endX, endY, iRotationAngle, isborderdahs);
        g2d.setStroke(origstroke);
        return new Area(startX * (double)this.rate, ((double)vertical - this.HALF_HEIGHT) * (double)this.rate - 10.0, endX * (double)this.rate, ((double)vertical + this.HALF_HEIGHT) * (double)this.rate + 10.0);
    }

    public PolygonXY getBracketXY(double startX, double startY, double endX, double endY, ShapeEnum shapeType, int angle) {
        PolygonXY pgxyscale = new PolygonXY();
        pgxyscale.angle = angle;
        double radius = 0.0;
        double centerX = startX + (endX - startX) / 2.0;
        double centerY = startY + (endY - startY) / 2.0;
        double zeroAngleX = 0.0;
        double zeroAngleY = 0.0;
        double scaleX = 1.0;
        double scaleY = 1.0;
        int itype = 1;
        if (endX - startX == endY - startY) {
            radius = (endX - startX) / 2.0;
            zeroAngleX = endX;
            zeroAngleY = centerY;
            itype = 1;
            scaleX = 1.0;
            scaleY = 1.0;
        } else if (endX - startX <= endY - startY) {
            radius = (endX - startX) / 2.0;
            zeroAngleX = centerX + radius;
            zeroAngleY = centerY;
            itype = 2;
            scaleX = 1.0;
            scaleY = (endY - startY) / (endX - startX);
        } else if (endX - startX >= endY - startY) {
            radius = (endY - startY) / 2.0;
            zeroAngleX = centerX + radius;
            zeroAngleY = centerY;
            itype = 3;
            scaleX = (endX - startX) / (endY - startY);
            scaleY = 1.0;
        }
        double arcx = 0.0;
        double arcy = 0.0;
        double initangle = 0.0;
        double inputangle = Math.PI * -2 * (double)angle / 360.0;
        double arcangle = 0.0;
        if (shapeType == ShapeEnum.SquareBracket || shapeType == ShapeEnum.Brace) {
            initangle = 0.0;
            pgxyscale.x = new int[4];
            pgxyscale.y = new int[4];
            for (int i = 0; i <= 3; ++i) {
                double r;
                if (i == 3) {
                    r = Math.sqrt(Math.pow(centerX - endX, 2.0) + Math.pow(centerY - startY, 2.0));
                    initangle = Math.atan((endY - startY) / 2.0 / ((endX - startX) / 2.0));
                    arcangle = initangle + inputangle;
                    zeroAngleX = centerX + r;
                    zeroAngleY = centerY;
                    arcx = (zeroAngleX - centerX) * Math.cos(arcangle) - (zeroAngleY - centerY) * Math.sin(arcangle) + centerX;
                    arcy = -1.0 * (zeroAngleX - centerX) * Math.sin(arcangle) + (zeroAngleY - centerY) * Math.cos(arcangle) + centerY;
                } else if (i == 0) {
                    r = Math.sqrt(Math.pow(centerX - startX, 2.0) + Math.pow(centerY - startY, 2.0));
                    initangle = 1.5707963267948966 + Math.atan((endX - startX) / 2.0 / ((endY - startY) / 2.0));
                    arcangle = initangle + inputangle;
                    zeroAngleX = centerX + r;
                    zeroAngleY = centerY;
                    arcx = (zeroAngleX - centerX) * Math.cos(arcangle) - (zeroAngleY - centerY) * Math.sin(arcangle) + centerX;
                    arcy = -1.0 * (zeroAngleX - centerX) * Math.sin(arcangle) + (zeroAngleY - centerY) * Math.cos(arcangle) + centerY;
                } else if (i == 1) {
                    r = Math.sqrt(Math.pow(centerX - startX, 2.0) + Math.pow(centerY - endY, 2.0));
                    initangle = Math.PI + Math.atan((endY - startY) / 2.0 / ((endX - startX) / 2.0));
                    arcangle = initangle + inputangle;
                    zeroAngleX = centerX + r;
                    zeroAngleY = centerY;
                    arcx = (zeroAngleX - centerX) * Math.cos(arcangle) - (zeroAngleY - centerY) * Math.sin(arcangle) + centerX;
                    arcy = -1.0 * (zeroAngleX - centerX) * Math.sin(arcangle) + (zeroAngleY - centerY) * Math.cos(arcangle) + centerY;
                } else if (i == 2) {
                    r = Math.sqrt(Math.pow(centerX - endX, 2.0) + Math.pow(centerY - endY, 2.0));
                    initangle = 4.71238898038469 + Math.atan((endX - startX) / 2.0 / ((endY - startY) / 2.0));
                    arcangle = initangle + inputangle;
                    zeroAngleX = centerX + r;
                    zeroAngleY = centerY;
                    arcx = (zeroAngleX - centerX) * Math.cos(arcangle) - (zeroAngleY - centerY) * Math.sin(arcangle) + centerX;
                    arcy = -1.0 * (zeroAngleX - centerX) * Math.sin(arcangle) + (zeroAngleY - centerY) * Math.cos(arcangle) + centerY;
                }
                pgxyscale.x[i] = (int)arcx;
                pgxyscale.y[i] = (int)arcy;
                pgxyscale.pointcount = 4;
            }
        }
        return pgxyscale;
    }

    private Area drawBracket(Protein pr, Component com, int vertical, int horizontal, int centerx, int centery, int wide, int angle, Color color, Graphics2D g2d, ShapeEnum shapeType, boolean isActive, int strokesize) {
        Stroke origstroke = g2d.getStroke();
        Color colororig = g2d.getColor();
        int iradius = 4;
        int high = 3;
        Color ac = Color.BLUE;
        Color pc = new Color(0, 255, 0);
        if (shapeType == ShapeEnum.SquareBracket) {
            high = 3;
        } else if (shapeType == ShapeEnum.Brace) {
            high = 5;
        }
        Stroke stroke = g2d.getStroke();
        vertical = -vertical;
        int startx = 0;
        boolean starty = false;
        int endx = 0;
        boolean endy = false;
        int startX = 0;
        int startY = 0;
        int endX = 0;
        int endY = 0;
        int centerX = 0;
        int centerY = 0;
        startx = centerx - wide;
        endx = centerx + wide;
        startX = (int)((-300.0 + (double)horizontal + (double)startx * this.LENGTH_RATE) * (double)this.rate);
        endX = (int)((-300.0 + (double)horizontal + (double)endx * this.LENGTH_RATE) * (double)this.rate);
        Color colorbk = this.getGrayColor(color);
        float thick = strokesize;
        g2d.setStroke(new BasicStroke(thick * this.rate, 1, 1));
        PolygonXY pgxy = null;
        startY = (int)((float)(vertical - centery) * this.rate - (float)high * this.rate);
        endY = (int)((float)(vertical - centery) * this.rate + (float)high * this.rate);
        centerX = startX + (endX - startX) / 2;
        centerY = startY + (endY - startY) / 2;
        Point2D.Double pd = new Point2D.Double();
        g2d.setColor(colorbk);
        if (shapeType == ShapeEnum.SquareBracket) {
            pgxy = this.getBracketXY(startX, startY, endX, endY, shapeType, angle);
            pgxy.CacuMinMaxXY();
            com.pgxy = pgxy;
            g2d.drawPolyline(pgxy.x, pgxy.y, pgxy.pointcount);
            if (com != null) {
                Polygon shapearea = new Polygon(pgxy.x, pgxy.y, pgxy.pointcount);
                com.GeomArea = new java.awt.geom.Area(shapearea);
            }
            PolygonXY pgxyan = this.getBracketXY(startX - 10, startY, endX + 10, endY, shapeType, angle);
            pgxyan.CacuMinMaxXY();
            if (isActive) {
                g2d.setColor(Color.ORANGE);
                g2d.fillRect(centerX, centerY, 2 * iradius, 2 * iradius);
                g2d.setColor(ac);
                g2d.fillOval(pgxyan.x[0] - iradius, pgxyan.y[0] - iradius, 2 * iradius, 2 * iradius);
                com.startArea = new Area(pgxyan.x[0] - iradius, pgxyan.y[0] - iradius, pgxyan.x[0] + iradius, pgxyan.y[0] + iradius);
                g2d.setColor(Color.RED);
                com.endArea = new Area(pgxyan.x[3] - iradius, pgxyan.y[3] - iradius, pgxyan.x[3] + iradius, pgxyan.y[3] + iradius);
                double rx = 0.0;
                g2d.setStroke(new BasicStroke(Math.round(this.raoteAnchorthick), 1, 1));
                double cx = (double)pgxyan.x[3] + rx - (double)iradius;
                double cy = pgxyan.y[3] - iradius;
                double cw = 2 * iradius;
                double ch = 2 * iradius;
                double startang = 0.0;
                double endang = 270.0;
                Arc2D.Double arc1 = new Arc2D.Double(cx, cy, cw, ch, startang, endang, 0);
                g2d.draw(arc1);
                this.drawAnchorRotateArrow(g2d, pgxyan.x[3] + iradius, pgxyan.y[3] + iradius / 8, pgxyan.x[3] + iradius, pgxyan.y[3] - iradius);
                com.ControlArea1 = new Area(centerX, centerY, centerX + 2 * iradius, centerY + 2 * iradius);
            }
            g2d.setColor(colororig);
        } else if (shapeType == ShapeEnum.Brace) {
            pgxy = this.getBracketXY(startX, startY - 2 * high, endX, endY + 2 * high, shapeType, angle);
            pgxy.CacuMinMaxXY();
            com.pgxy = pgxy;
            int cx = 0;
            int cy = 0;
            int cw = 0;
            int ch = 0;
            int startang = 0;
            int endang = 0;
            GeneralPath clipShape = new GeneralPath();
            cx = startX;
            cy = startY;
            cw = (int)((float)(2 * high) * this.rate);
            ch = (int)((float)(2 * high) * this.rate);
            startang = 180;
            endang = 90;
            Arc2D.Double arc1 = new Arc2D.Double(cx, cy, cw, ch, startang, endang, 0);
            clipShape.append(arc1, false);
            int cstartx = 0;
            int cstarty = 0;
            int cendx = 0;
            int cendy = 0;
            cstartx = startX + (int)((float)high * this.rate);
            cstarty = endY;
            cendx = startX + (endX - startX) / 2 - (int)((float)high * this.rate);
            cendy = endY;
            Line2D.Double ld1 = new Line2D.Double(cstartx, cstarty, cendx, cendy);
            clipShape.append(ld1, false);
            cx = startX + (endX - startX) / 2 - (int)((float)(2 * high) * this.rate);
            cy = endY;
            cw = (int)((float)(2 * high) * this.rate);
            ch = (int)((float)(2 * high) * this.rate);
            startang = 0;
            endang = 90;
            Arc2D.Double arc2 = new Arc2D.Double(cx, cy, cw, ch, startang, endang, 0);
            clipShape.append(arc2, false);
            cx = startX + (endX - startX) / 2;
            cy = endY;
            cw = (int)((float)(2 * high) * this.rate);
            ch = (int)((float)(2 * high) * this.rate);
            startang = 90;
            endang = 90;
            Arc2D.Double arc3 = new Arc2D.Double(cx, cy, cw, ch, startang, endang, 0);
            clipShape.append(arc3, false);
            cstartx = startX + (endX - startX) / 2 + (int)((float)high * this.rate);
            cstarty = endY;
            cendx = endX - (int)((float)high * this.rate);
            cendy = endY;
            Line2D.Double ld2 = new Line2D.Double(cstartx, cstarty, cendx, cendy);
            clipShape.append(ld2, false);
            cx = endX - (int)((float)(2 * high) * this.rate);
            cy = startY;
            cw = (int)((float)(2 * high) * this.rate);
            ch = (int)((float)(2 * high) * this.rate);
            startang = 270;
            endang = 90;
            Arc2D.Double arc4 = new Arc2D.Double(cx, cy, cw, ch, startang, endang, 0);
            clipShape.append(arc4, false);
            double angle1 = Math.PI * 2 * (double)angle / 360.0;
            AffineTransform rectTransform = AffineTransform.getRotateInstance(0.0, centerX, centerY);
            rectTransform.setToRotation(angle1, centerX, centerY);
            Shape shape = clipShape.createTransformedShape(rectTransform);
            if (com != null) {
                Polygon shapearea = new Polygon(pgxy.x, pgxy.y, pgxy.pointcount);
                com.GeomArea = new java.awt.geom.Area(shapearea);
            }
            clipShape.reset();
            clipShape.append(shape, false);
            g2d.draw(clipShape);
            clipShape.closePath();
            if (isActive) {
                g2d.setColor(Color.ORANGE);
                g2d.fillRect(centerX, centerY, 2 * iradius, 2 * iradius);
                g2d.setColor(ac);
                g2d.fillOval(pgxy.x[0] - iradius, pgxy.y[0] + iradius, 2 * iradius, 2 * iradius);
                g2d.setColor(Color.RED);
                com.ControlArea1 = new Area(centerX, centerY, centerX + 2 * iradius, centerY + 2 * iradius);
                double rx = 0.0;
                g2d.setStroke(new BasicStroke(Math.round(this.raoteAnchorthick), 1, 1));
                double cxn = (double)pgxy.x[3] + rx - (double)iradius;
                double cyn = pgxy.y[3] + iradius;
                double cwn = 2 * iradius;
                double chn = 2 * iradius;
                double startangn = 0.0;
                double endangn = 270.0;
                Arc2D.Double arcn = new Arc2D.Double(cxn, cyn, cwn, chn, startangn, endangn, 0);
                g2d.draw(arcn);
                this.drawAnchorRotateArrow(g2d, pgxy.x[3] + iradius, pgxy.y[3] + 2 * iradius, pgxy.x[3] + iradius, pgxy.y[3] - iradius);
            }
            com.startArea = new Area(pgxy.x[0] - iradius, pgxy.y[0] + iradius, pgxy.x[0] + iradius, pgxy.y[0] + 2 * iradius);
            com.endArea = new Area(pgxy.x[3] - iradius, pgxy.y[3] + iradius, pgxy.x[3] + iradius, pgxy.y[3] + 2 * iradius);
            g2d.setColor(colororig);
        }
        g2d.setStroke(origstroke);
        Area sa = null;
        sa = new Area(pgxy.minx, pgxy.miny, pgxy.maxx, pgxy.maxy);
        return sa;
    }

    public double getAngleFromXY(double x1, double y1, double centerx, double centery) {
        double fullangle = 0.0;
        double littleangle = 0.0;
        double disx = 0.0;
        double disy = 0.0;
        disx = Math.abs(x1 - centerx);
        disy = Math.abs(y1 - centery);
        if (x1 > centerx && y1 < centery) {
            fullangle = littleangle = Math.atan(disy / disx);
        } else if (x1 < centerx && y1 < centery) {
            littleangle = Math.atan(disx / disy);
            fullangle = littleangle + 1.5707963267948966;
        } else if (x1 < centerx && y1 > centery) {
            littleangle = Math.atan(disy / disx);
            fullangle = littleangle + Math.PI;
        } else if (x1 > centerx && y1 > centery) {
            littleangle = Math.atan(disx / disy);
            fullangle = littleangle + 4.71238898038469;
        } else if (x1 == centerx && y1 > centery) {
            fullangle = 4.71238898038469;
        } else if (x1 < centerx && y1 == centery) {
            fullangle = Math.PI;
        } else if (x1 == centerx && y1 < centery) {
            fullangle = 1.5707963267948966;
        } else if (x1 > centerx && y1 == centery) {
            fullangle = 0.0;
        }
        return fullangle;
    }

    public void drawPolygonTextureRect(Protein pr, Component com, Graphics2D g2d, double startX, double startY, double endX, double endY, PolygonXY pgxy, String LineFile, Stroke stroke, Color color, Color colorbk, GradientEnum GradientType, ShapeEnum shapeType, int strokesize, boolean isActive, double vertical, double comhalf_heigh, boolean isDash) {
        double endx;
        double startx;
        AffineTransform rectTransform;
        Shape shape;
        Stroke origstroke = g2d.getStroke();
        Color origcolor = g2d.getColor();
        startX = Math.round(startX);
        startY = Math.round(startY);
        endX = Math.round(endX);
        endY = Math.round(endY);
        this.lineInterval = (int)(5.0f * this.rate);
        double centery = startY + (endY - startY) / 2.0;
        double centerx = startX + (endX - startX) / 2.0;
        double llen = 10.0;
        if (com != null) {
            String[] arrPro = pr.getParameter().split("#&%");
            int proteinStart = Integer.parseInt(arrPro[0]);
            int proteinEnd = Integer.parseInt(arrPro[2]);
            llen = (double)(proteinEnd - proteinStart) / 20.0;
        }
        Shape oldclip = g2d.getClip();
        GeneralPath clipShape = new GeneralPath();
        double startx0 = startX;
        double starty0 = startY;
        double endx0 = endX;
        double endy0 = endY;
        double circleShortDiameter = 20.0;
        circleShortDiameter = llen <= 5.0 ? llen : 5.0;
        circleShortDiameter *= (double)this.rate;
        GeneralPath pt = new GeneralPath();
        if (shapeType == ShapeEnum.Circle) {
            double pgangle = Math.PI * pgxy.angle / 180.0;
            shape = new Ellipse2D.Double((int)Math.round(startX), (int)Math.round(startY), (int)Math.round(endX - startX), (int)Math.round(endY - startY));
            clipShape.append(shape, false);
            rectTransform = AffineTransform.getRotateInstance(0.0, (int)Math.round(centerx), (int)Math.round(centery));
            rectTransform.setToRotation(pgangle, (int)Math.round(centerx), (int)Math.round(centery));
            shape = clipShape.createTransformedShape(rectTransform);
            clipShape.reset();
            clipShape.append(shape, false);
            startX = Math.round(pgxy.minx);
            startY = Math.round(pgxy.miny);
            endX = Math.round(pgxy.maxx);
            endY = Math.round(pgxy.maxy);
            if (com != null) {
                com.GeomArea = new java.awt.geom.Area(shape);
            }
        } else if (shapeType == ShapeEnum.RoundRectangle) {
            double pgangle = Math.PI * pgxy.angle / 180.0;
            shape = new RoundRectangle2D.Double(startX, startY, endX - startX, endY - startY, 10.0, 10.0);
            clipShape.append(shape, false);
            rectTransform = AffineTransform.getRotateInstance(0.0, centerx, centery);
            rectTransform.setToRotation(pgangle, centerx, centery);
            shape = clipShape.createTransformedShape(rectTransform);
            clipShape.reset();
            clipShape.append(shape, false);
            startX = pgxy.minx;
            startY = pgxy.miny;
            endX = pgxy.maxx;
            endY = pgxy.maxy;
            if (com != null) {
                com.GeomArea = new java.awt.geom.Area(shape);
            }
        } else if (shapeType == ShapeEnum.Cylinder) {
            double pgangle = Math.PI * pgxy.angle / 180.0;
            Ellipse2D.Double shape1 = new Ellipse2D.Double(startX, startY, circleShortDiameter, endY - startY);
            pt.append(shape1, true);
            Rectangle2D.Double shape2 = new Rectangle2D.Double(startX + circleShortDiameter / 2.0, startY, endX - startX - circleShortDiameter, endY - startY);
            pt.append(shape2, true);
            Ellipse2D.Double shape3 = new Ellipse2D.Double(endX - circleShortDiameter, startY, circleShortDiameter, endY - startY);
            pt.append(shape3, true);
            shape = pt;
            clipShape.append(shape, false);
            AffineTransform rectTransform2 = AffineTransform.getRotateInstance(0.0, centerx, centery);
            rectTransform2.setToRotation(pgangle, centerx, centery);
            shape = clipShape.createTransformedShape(rectTransform2);
            clipShape.reset();
            clipShape.append(shape, false);
            startX = pgxy.minx;
            startY = pgxy.miny;
            endX = pgxy.maxx;
            endY = pgxy.maxy;
            if (com != null) {
                com.GeomArea = new java.awt.geom.Area(shape);
            }
        } else if (shapeType == ShapeEnum.L_ParallelCurve || shapeType == ShapeEnum.R_ParallelCurve) {
            pt.moveTo(pgxy.x[0], pgxy.y[0]);
            pt.curveTo(pgxy.x[4], pgxy.y[4], pgxy.x[5], pgxy.y[5], pgxy.x[3], pgxy.y[3]);
            pt.lineTo(pgxy.x[2], pgxy.y[2]);
            pt.curveTo(pgxy.x[7], pgxy.y[7], pgxy.x[6], pgxy.y[6], pgxy.x[1], pgxy.y[1]);
            pt.lineTo(pgxy.x[0], pgxy.y[0]);
            shape = pt;
            clipShape.append(shape, false);
            startX = pgxy.minx;
            startY = pgxy.miny;
            endX = pgxy.maxx;
            endY = pgxy.maxy;
            if (com != null) {
                int[] x = new int[6];
                int[] y = new int[6];
                x[0] = pgxy.x[0];
                x[1] = pgxy.x[1];
                x[2] = pgxy.x[4];
                x[3] = pgxy.x[2];
                x[4] = pgxy.x[3];
                x[5] = pgxy.x[7];
                y[0] = pgxy.y[0];
                y[1] = pgxy.y[1];
                y[2] = pgxy.y[4];
                y[3] = pgxy.y[2];
                y[4] = pgxy.y[3];
                y[5] = pgxy.y[7];
                Polygon sh = new Polygon(x, y, 6);
                com.GeomArea = new java.awt.geom.Area(sh);
            }
        } else {
            shape = new Polygon(pgxy.x, pgxy.y, pgxy.pointcount);
            startX = pgxy.minx;
            startY = pgxy.miny;
            endX = pgxy.maxx;
            endY = pgxy.maxy;
            clipShape.append(shape, false);
            if (com != null) {
                com.GeomArea = new java.awt.geom.Area(shape);
            }
        }
        double centerY = startY + (endY - startY) / 2.0;
        double centerX = startX + (endX - startX) / 2.0;
        g2d.clip(clipShape);
        double xstart = 0.0;
        double xend = 0.0;
        double ystart = 0.0;
        double yend = 0.0;
        double iVhigh = endY - startY;
        int iType = 1;
        if (endX - startX == iVhigh) {
            xstart = startX;
            xend = startX + (endX - startX) * 2.0;
            ystart = centerY - iVhigh;
            yend = centerY + iVhigh;
            iType = 1;
        } else if (endX - startX > iVhigh) {
            xstart = startX;
            xend = startX + (endX - startX) * 2.0;
            ystart = centerY - (endX - startX);
            yend = centerY + (endX - startX);
            iType = 2;
        } else if (endX - startX < iVhigh) {
            xstart = centerX - iVhigh * 3.0;
            xend = centerX + iVhigh * 3.0;
            ystart = centerY - iVhigh / 2.0;
            yend = centerY + iVhigh * 3.0 / 2.0;
            iType = 3;
        }
        if (LineFile.equals("00001.jpg")) {
            g2d.setColor(color);
            this.drawPolygonGradientPaintRect(g2d, startx0, starty0, endx0, endy0, color, GradientType, vertical, comhalf_heigh);
            g2d.fill(shape);
            g2d.setColor(colorbk);
            int p = 0;
            while (startX + (double)p < endX) {
                double startx2 = startX + (double)p;
                double endx2 = startX + (double)p;
                double starty = startY;
                double endy = endY;
                Line2D.Double line = new Line2D.Double(startx2, starty, endx2, endy);
                g2d.draw(line);
                p += this.lineInterval;
            }
            int q = 0;
            while (startY + (double)q < endY) {
                double starty = startY + (double)q;
                double endy = startY + (double)q;
                double startx3 = startX;
                double endx3 = endX;
                Line2D.Double line = new Line2D.Double(startx3, starty, endx3, endy);
                g2d.draw(line);
                q += this.lineInterval;
            }
            g2d.setClip(oldclip);
        } else if (LineFile.equals("00001_d.jpg")) {
            g2d.setColor(color);
            this.drawPolygonGradientPaintRect(g2d, pgxy.minx, pgxy.miny, pgxy.maxx, pgxy.maxy, color, GradientType, vertical, comhalf_heigh);
            g2d.fill(shape);
            g2d.setColor(colorbk);
            float[] dash1 = new float[]{5.0f};
            g2d.setStroke(new BasicStroke(1.0f, 0, 0, 20.0f, dash1, 0.0f));
            int p = 0;
            while (startX + (double)p < endX) {
                double startx4 = startX + (double)p;
                double endx4 = startX + (double)p;
                double starty = startY;
                double endy = endY;
                Line2D.Double line = new Line2D.Double(startx4, starty, endx4, endy);
                g2d.draw(line);
                p += this.lineInterval;
            }
            int q = 0;
            while (startY + (double)q < endY) {
                double starty = startY + (double)q;
                double endy = startY + (double)q;
                double startx5 = startX;
                double endx5 = endX;
                Line2D.Double line = new Line2D.Double(startx5, starty, endx5, endy);
                g2d.draw(line);
                q += this.lineInterval;
            }
            g2d.setStroke(stroke);
            g2d.setClip(oldclip);
        } else if (LineFile.equals("00003.jpg")) {
            g2d.setColor(color);
            this.drawPolygonGradientPaintRect(g2d, pgxy.minx, pgxy.miny, pgxy.maxx, pgxy.maxy, color, GradientType, vertical, comhalf_heigh);
            g2d.fill(shape);
            g2d.setColor(colorbk);
            int p = 0;
            while (startX + (double)p < endX) {
                double startx6 = startX + (double)p;
                double endx6 = startX + (double)p;
                double starty = startY;
                double endy = endY;
                Line2D.Double line = new Line2D.Double(startx6, starty, endx6, endy);
                g2d.draw(line);
                p += this.lineInterval;
            }
            g2d.setClip(oldclip);
        } else if (LineFile.equals("00003_d.jpg")) {
            g2d.setColor(color);
            this.drawPolygonGradientPaintRect(g2d, pgxy.minx, pgxy.miny, pgxy.maxx, pgxy.maxy, color, GradientType, vertical, comhalf_heigh);
            g2d.fill(shape);
            g2d.setColor(colorbk);
            float[] dash1 = new float[]{5.0f};
            g2d.setStroke(new BasicStroke(1.0f, 0, 0, 20.0f, dash1, 0.0f));
            int p = 0;
            while (startX + (double)p < endX) {
                double startx7 = startX + (double)p;
                double endx7 = startX + (double)p;
                double starty = startY;
                double endy = endY;
                Line2D.Double line = new Line2D.Double(startx7, starty, endx7, endy);
                g2d.draw(line);
                p += this.lineInterval;
            }
            g2d.setStroke(stroke);
            g2d.setClip(oldclip);
        } else if (LineFile.equals("00002.jpg")) {
            g2d.setColor(color);
            this.drawPolygonGradientPaintRect(g2d, pgxy.minx, pgxy.miny, pgxy.maxx, pgxy.maxy, color, GradientType, vertical, comhalf_heigh);
            g2d.fill(shape);
            g2d.setColor(colorbk);
            int q = 0;
            while (startY + (double)q < endY) {
                double starty = startY + (double)q;
                double endy = startY + (double)q;
                double startx8 = startX;
                double endx8 = endX;
                Line2D.Double line = new Line2D.Double(startx8, starty, endx8, endy);
                g2d.draw(line);
                q += this.lineInterval;
            }
            g2d.setClip(oldclip);
        } else if (LineFile.equals("00002_d.jpg")) {
            g2d.setColor(color);
            this.drawPolygonGradientPaintRect(g2d, pgxy.minx, pgxy.miny, pgxy.maxx, pgxy.maxy, color, GradientType, vertical, comhalf_heigh);
            g2d.fill(shape);
            g2d.setColor(colorbk);
            float[] dash1 = new float[]{5.0f};
            g2d.setStroke(new BasicStroke(1.0f, 0, 0, 20.0f, dash1, 0.0f));
            int q = 0;
            while (startY + (double)q < endY) {
                double starty = startY + (double)q;
                double endy = startY + (double)q;
                double startx9 = startX;
                double endx9 = endX;
                Line2D.Double line = new Line2D.Double(startx9, starty, endx9, endy);
                g2d.draw(line);
                q += this.lineInterval;
            }
            g2d.setStroke(stroke);
            g2d.setClip(oldclip);
        } else if (LineFile.equals("00004.jpg")) {
            g2d.setColor(color);
            this.drawPolygonGradientPaintRect(g2d, pgxy.minx, pgxy.miny, pgxy.maxx, pgxy.maxy, color, GradientType, vertical, comhalf_heigh);
            g2d.fill(shape);
            g2d.setColor(colorbk);
            double r = xend - xstart;
            double xendorig = xend;
            double xstartorig = xstart;
            xstart -= r;
            xend += r;
            int p = 0;
            while (xstart + (double)p < xendorig) {
                double startx10 = xstart + (double)p;
                double starty = ystart;
                double endx10 = xstartorig + (double)p;
                double endy = yend;
                Line2D.Double line1 = new Line2D.Double(startx10, starty, endx10, endy);
                g2d.draw(line1);
                p += this.lineInterval;
            }
            g2d.setClip(oldclip);
        } else if (LineFile.equals("00004_d.jpg")) {
            g2d.setColor(color);
            this.drawPolygonGradientPaintRect(g2d, pgxy.minx, pgxy.miny, pgxy.maxx, pgxy.maxy, color, GradientType, vertical, comhalf_heigh);
            g2d.fill(shape);
            g2d.setColor(colorbk);
            int p = 0;
            float[] dash1 = new float[]{5.0f};
            g2d.setStroke(new BasicStroke(1.0f, 0, 0, 20.0f, dash1, 0.0f));
            double r = xend - xstart;
            double xendorig = xend;
            double xstartorig = xstart;
            xstart -= r;
            xend += r;
            while (xstart + (double)p < xendorig) {
                startx = xstart + (double)p;
                double starty = ystart;
                endx = xstartorig + (double)p;
                double endy = yend;
                Line2D.Double line1 = new Line2D.Double(startx, starty, endx, endy);
                g2d.draw(line1);
                p += this.lineInterval;
            }
            g2d.setStroke(stroke);
            g2d.setClip(oldclip);
        } else if (LineFile.equals("00005.jpg")) {
            g2d.setColor(color);
            this.drawPolygonGradientPaintRect(g2d, pgxy.minx, pgxy.miny, pgxy.maxx, pgxy.maxy, color, GradientType, vertical, comhalf_heigh);
            g2d.fill(shape);
            g2d.setColor(colorbk);
            double r = xend - xstart;
            double xendorig = xend;
            double xstartorig = xstart;
            xstart -= r;
            xend += r;
            int p = 0;
            while (xstart + (double)p < xendorig) {
                double startx11 = xstart + (double)p;
                double starty = yend;
                double endx11 = xstartorig + (double)p;
                double endy = ystart;
                Line2D.Double line1 = new Line2D.Double(startx11, starty, endx11, endy);
                g2d.draw(line1);
                p += this.lineInterval;
            }
            g2d.setClip(oldclip);
        } else if (LineFile.equals("00005_d.jpg")) {
            g2d.setColor(color);
            this.drawPolygonGradientPaintRect(g2d, pgxy.minx, pgxy.miny, pgxy.maxx, pgxy.maxy, color, GradientType, vertical, comhalf_heigh);
            g2d.fill(shape);
            g2d.setColor(colorbk);
            float[] dash1 = new float[]{5.0f};
            g2d.setStroke(new BasicStroke(1.0f, 0, 0, 20.0f, dash1, 0.0f));
            double r = xend - xstart;
            double xendorig = xend;
            double xstartorig = xstart;
            xstart -= r;
            xend += r;
            int p = 0;
            while (xstart + (double)p < xendorig) {
                startx = xstart + (double)p;
                double starty = yend;
                endx = xstartorig + (double)p;
                double endy = ystart;
                Line2D.Double line1 = new Line2D.Double(startx, starty, endx, endy);
                g2d.draw(line1);
                p += this.lineInterval;
            }
            g2d.setStroke(stroke);
            g2d.setClip(oldclip);
        } else if (LineFile.equals("00006.jpg")) {
            Line2D.Double line1;
            double endy;
            double endx12;
            double starty;
            double startx12;
            g2d.setColor(color);
            this.drawPolygonGradientPaintRect(g2d, pgxy.minx, pgxy.miny, pgxy.maxx, pgxy.maxy, color, GradientType, vertical, comhalf_heigh);
            g2d.fill(shape);
            g2d.setColor(colorbk);
            double r = xend - xstart;
            double xendorig = xend;
            double xstartorig = xstart;
            xstart -= r;
            xend += r;
            int p = 0;
            while (xstart + (double)p < xendorig) {
                startx12 = xstart + (double)p;
                starty = yend;
                endx12 = xstartorig + (double)p;
                endy = ystart;
                line1 = new Line2D.Double(startx12, starty, endx12, endy);
                g2d.draw(line1);
                p += this.lineInterval;
            }
            p = 0;
            r = xend - xstart;
            xendorig = xend;
            xstartorig = xstart;
            xstart -= r;
            xend += r;
            while (xstart + (double)p < xendorig) {
                startx12 = xstart + (double)p;
                starty = ystart;
                endx12 = xstartorig + (double)p;
                endy = yend;
                line1 = new Line2D.Double(startx12, starty, endx12, endy);
                g2d.draw(line1);
                p += this.lineInterval;
            }
            g2d.setClip(oldclip);
        } else if (LineFile.equals("00006_d.jpg")) {
            Line2D.Double line1;
            double endy;
            double starty;
            g2d.setColor(color);
            this.drawPolygonGradientPaintRect(g2d, pgxy.minx, pgxy.miny, pgxy.maxx, pgxy.maxy, color, GradientType, vertical, comhalf_heigh);
            g2d.fill(shape);
            g2d.setColor(colorbk);
            int p = 0;
            float[] dash1 = new float[]{5.0f};
            g2d.setStroke(new BasicStroke(1.0f, 0, 0, 20.0f, dash1, 0.0f));
            double r = xend - xstart;
            double xendorig = xend;
            double xstartorig = xstart;
            xstart -= r;
            xend += r;
            while (xstart + (double)p < xendorig) {
                startx = xstart + (double)p;
                starty = yend;
                endx = xstartorig + (double)p;
                endy = ystart;
                line1 = new Line2D.Double(startx, starty, endx, endy);
                g2d.draw(line1);
                p += this.lineInterval;
            }
            p = 0;
            r = xend - xstart;
            xendorig = xend;
            xstartorig = xstart;
            xstart -= r;
            xend += r;
            while (xstart + (double)p < xendorig) {
                startx = xstart + (double)p;
                starty = ystart;
                endx = xstartorig + (double)p;
                endy = yend;
                line1 = new Line2D.Double(startx, starty, endx, endy);
                g2d.draw(line1);
                p += this.lineInterval;
            }
            g2d.setStroke(stroke);
            g2d.setClip(oldclip);
        } else if (LineFile.equals("00000_1.jpg")) {
            g2d.setColor(color);
            g2d.fill(shape);
            this.drawCrystal(g2d, Math.round(pgxy.minx), Math.round(pgxy.miny), Math.round(pgxy.maxx), Math.round(pgxy.maxy), color);
            g2d.setColor(colorbk);
            g2d.setClip(oldclip);
        } else if (LineFile.equals("00000_0.jpg")) {
            g2d.setColor(color);
            this.drawPolygonGradientPaintRect(g2d, pgxy.minx, pgxy.miny, pgxy.maxx, pgxy.maxy, color, GradientType, vertical, comhalf_heigh);
            g2d.fill(shape);
            g2d.setColor(colorbk);
            g2d.setClip(oldclip);
        } else {
            try {
                File objFile = new File("texture/" + LineFile);
                BufferedImage bgImg = ImageIO.read(objFile);
                if (this.bGray) {
                    WritableRaster raster = bgImg.getRaster();
                    int[] sample = new int[4];
                    for (int k = 0; k < bgImg.getWidth(); ++k) {
                        for (int m = 0; m < bgImg.getHeight(); ++m) {
                            raster.getPixel(k, m, sample);
                            Color corig = new Color(sample[0], sample[1], sample[2], sample[3]);
                            Color cl = this.getGrayColor(corig);
                            sample[0] = cl.getRed();
                            sample[1] = cl.getGreen();
                            sample[2] = cl.getBlue();
                            sample[3] = cl.getAlpha();
                            raster.setPixel(k, m, sample);
                        }
                    }
                }
                Rectangle rect = new Rectangle(pgxy.minx, pgxy.miny, pgxy.maxx - pgxy.minx, pgxy.maxy - pgxy.miny);
                TexturePaint texture = new TexturePaint(bgImg, rect);
                Paint pp = g2d.getPaint();
                g2d.setPaint(texture);
                g2d.fill(shape);
                g2d.setClip(oldclip);
                g2d.setPaint(pp);
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        float thick = strokesize;
        if (isDash) {
            float[] dash1 = new float[]{5.0f};
            g2d.setStroke(new BasicStroke(Math.round(thick * this.rate), 1, 1, 20.0f, dash1, 0.0f));
        } else {
            g2d.setStroke(new BasicStroke(Math.round(thick * this.rate), 1, 1));
        }
        if (com != null) {
            if (shapeType == ShapeEnum.L_ParallelCurve || shapeType == ShapeEnum.R_ParallelCurve) {
                CubicCurve2D.Double q = new CubicCurve2D.Double(pgxy.x[0], pgxy.y[0], pgxy.x[4], pgxy.y[4], pgxy.x[5], pgxy.y[5], pgxy.x[3], pgxy.y[3]);
                g2d.draw(q);
                CubicCurve2D.Double q2 = new CubicCurve2D.Double(pgxy.x[1], pgxy.y[1], pgxy.x[6], pgxy.y[6], pgxy.x[7], pgxy.y[7], pgxy.x[2], pgxy.y[2]);
                g2d.draw(q2);
            } else if (shapeType == ShapeEnum.L_ParallelLine || shapeType == ShapeEnum.R_ParallelLine) {
                g2d.drawLine(pgxy.x[0], pgxy.y[0], pgxy.x[3], pgxy.y[3]);
                g2d.drawLine(pgxy.x[1], pgxy.y[1], pgxy.x[2], pgxy.y[2]);
            } else if (shapeType == ShapeEnum.Cylinder) {
                float thick2 = strokesize;
                if (LineFile.equals("00000_1.jpg")) {
                    if (isDash) {
                        float[] dash1 = new float[]{5.0f};
                        g2d.setStroke(new BasicStroke(1.0f, 1, 1, 20.0f, dash1, 0.0f));
                    } else {
                        g2d.setStroke(new BasicStroke(1.0f, 1, 1));
                    }
                } else if (isDash) {
                    float[] dash1 = new float[]{5.0f};
                    g2d.setStroke(new BasicStroke(thick2 * this.rate, 1, 1, 20.0f, dash1, 0.0f));
                } else {
                    g2d.setStroke(new BasicStroke(thick2 * this.rate, 1, 1));
                }
                Ellipse2D.Double shape11 = new Ellipse2D.Double(startX, startY, circleShortDiameter, endY - startY);
                g2d.draw(shape11);
                g2d.drawLine((int)(startX + circleShortDiameter / 2.0), (int)startY, (int)(endX - circleShortDiameter / 2.0), (int)startY);
                g2d.drawLine((int)(endX - circleShortDiameter / 2.0), (int)endY, (int)(startX + circleShortDiameter / 2.0), (int)endY);
                double cx = endX - circleShortDiameter;
                double cy = startY;
                double cw = circleShortDiameter;
                double ch = endY - startY;
                double startang = 0.0;
                double endang = 90.0;
                Arc2D.Double arc4 = new Arc2D.Double(cx, cy, cw, ch, startang, endang, 0);
                g2d.draw(arc4);
                startang = 270.0;
                endang = 90.0;
                Arc2D.Double arc5 = new Arc2D.Double(cx, cy, cw, ch, startang, endang, 0);
                g2d.draw(arc5);
                if (com.getType() == ComponentEnum.Domain) {
                    float[] dash1;
                    String[] arrPro = pr.getParameter().split("#&%");
                    int proteinStart = Integer.parseInt(arrPro[0]);
                    int proteinEnd = Integer.parseInt(arrPro[2]);
                    int proteinHeight = Integer.parseInt(arrPro[4]);
                    GradientEnum pGradientType = GradientEnum.valueOf(arrPro[6]);
                    String pSelectTextureFile = arrPro[7];
                    double startpX = (-300.0 + (double)pr.getHorizontal() + (double)proteinStart * this.LENGTH_RATE) * (double)this.rate;
                    double endpX = (-300.0 + (double)pr.getHorizontal() + (double)proteinEnd * this.LENGTH_RATE) * (double)this.rate;
                    double centerpX = (endX - startX) / 2.0;
                    double startpY = (vertical - this.HALF_HEIGHT) * (double)this.rate;
                    double endpY = (vertical + this.HALF_HEIGHT) * (double)this.rate;
                    double pcomhalf_heigh = this.HALF_HEIGHT;
                    int pstrokesize = Integer.parseInt(arrPro[9]);
                    String proteinColorLineStr = "0,0,0";
                    proteinColorLineStr = arrPro[10];
                    StringTokenizer ster = new StringTokenizer(proteinColorLineStr, ",");
                    Color proteinLineColor = new Color(Integer.parseInt(ster.nextToken()), Integer.parseInt(ster.nextToken()), Integer.parseInt(ster.nextToken()));
                    g2d.setStroke(stroke);
                    PolygonXY pgxypro = new PolygonXY();
                    pgxypro.getPolygonXY(startpX, (int)Math.round(startpY), endpX, (int)Math.round(endpY), "Rectangle", 0.0, this.rate);
                    pgxypro.CacuMinMaxXY();
                    this.drawPreCylinderProtein(pr, null, g2d, (int)Math.round(startpX), (int)Math.round(startpY), (int)Math.round(endpX), (int)Math.round(endpY), pgxypro, pSelectTextureFile, stroke, this.getGrayColor(pr.getColor()), this.getGrayColor(proteinLineColor), pGradientType, ShapeEnum.Rectangle, pstrokesize, false, vertical, comhalf_heigh, false, startX);
                    float thick1 = pstrokesize;
                    if (LineFile.equals("00000_1.jpg")) {
                        if (isDash) {
                            dash1 = new float[]{5.0f};
                            g2d.setStroke(new BasicStroke(Math.round(1.0f), 1, 1, 20.0f, dash1, 0.0f));
                        } else {
                            g2d.setStroke(new BasicStroke(Math.round(1.0f), 1, 1));
                        }
                    } else if (isDash) {
                        dash1 = new float[]{5.0f};
                        g2d.setStroke(new BasicStroke(Math.round(thick1 * this.rate), 1, 1, 20.0f, dash1, 0.0f));
                    } else {
                        g2d.setStroke(new BasicStroke(Math.round(thick1 * this.rate), 1, 1));
                    }
                    double perCentDiam = 0.5;
                    double litllerDiameter = circleShortDiameter * perCentDiam;
                    double littlerCenterX = startX + circleShortDiameter / 2.0;
                    double littlerCenterY = startY + (endY - startY) / 2.0;
                    double cx1 = littlerCenterX - litllerDiameter / 2.0;
                    double cy1 = pgxypro.miny;
                    double cw1 = litllerDiameter / 2.0;
                    double ch1 = pgxypro.maxy - pgxypro.miny;
                    double startang1 = 0.0;
                    double endang1 = 90.0;
                    Arc2D.Double arc6 = new Arc2D.Double((int)Math.round(cx1 - (double)((float)strokesize * this.rate / 10.0f)), (int)Math.round(cy1), (int)Math.round(cw1), (int)Math.round(ch1), startang1, endang1, 0);
                    g2d.draw(arc6);
                    startang1 = 270.0;
                    endang1 = 90.0;
                    Arc2D.Double arc7 = new Arc2D.Double((int)Math.round(cx1 - (double)((float)strokesize * this.rate / 10.0f)), (int)Math.round(cy1), (int)Math.round(cw1), (int)Math.round(ch1), startang1, endang1, 0);
                    g2d.draw(arc7);
                    Line2D.Double line1 = new Line2D.Double((int)Math.round(startX - (double)(thick1 * this.rate)), Math.round(pgxypro.miny), (int)Math.round(littlerCenterX - litllerDiameter / 2.0 + (double)(thick1 * this.rate / 2.0f)), Math.round(pgxypro.miny));
                    Line2D.Double line2 = new Line2D.Double((int)Math.round(startX - (double)(thick1 * this.rate)), Math.round(pgxypro.maxy), (int)Math.round(littlerCenterX - litllerDiameter / 2.0 + (double)(thick1 * this.rate / 2.0f)), Math.round(pgxypro.maxy));
                    g2d.draw(line1);
                    g2d.draw(line2);
                }
            } else {
                float thick2 = strokesize;
                if (LineFile.equals("00000_1.jpg")) {
                    if (isDash) {
                        float[] dash1 = new float[]{5.0f};
                        g2d.setStroke(new BasicStroke(thick2, 1, 1, 20.0f, dash1, 0.0f));
                    } else {
                        g2d.setStroke(new BasicStroke(thick2, 1, 1));
                    }
                } else if (isDash) {
                    float[] dash1 = new float[]{5.0f};
                    g2d.setStroke(new BasicStroke(Math.round(thick2 * this.rate), 1, 1, 20.0f, dash1, 0.0f));
                } else {
                    g2d.setStroke(new BasicStroke(Math.round(thick2 * this.rate), 1, 1));
                }
                g2d.draw(shape);
            }
        }
        g2d.setStroke(origstroke);
        g2d.setColor(origcolor);
    }

    public void drawPreCylinderProtein(Protein pr, Component com, Graphics2D g2d, double startX, double startY, double endX, double endY, PolygonXY pgxy, String LineFile, Stroke stroke, Color color, Color colorbk, GradientEnum GradientType, ShapeEnum shapeType, int strokesize, boolean isActive, double vertical, double comhalf_heigh, boolean isDash, double comStartX) {
        Stroke origstroke = g2d.getStroke();
        double llen = 10.0;
        if (com != null) {
            String[] arrPro = pr.getParameter().split("#&%");
            int proteinStart = Integer.parseInt(arrPro[0]);
            int proteinEnd = Integer.parseInt(arrPro[2]);
            llen = (proteinEnd - proteinStart) / 20;
        }
        Shape oldclip = g2d.getClip();
        GeneralPath clipShape = new GeneralPath();
        double startx0 = startX;
        double starty0 = startY;
        double endx0 = endX;
        double endy0 = endY;
        double circleShortDiameter = 20.0;
        circleShortDiameter = llen <= 5.0 ? llen : 5.0;
        GeneralPath pt = new GeneralPath();
        double perCentDiam = 0.5;
        double litllerDiameter = (circleShortDiameter *= (double)this.rate) * perCentDiam;
        double littlerCenterX = comStartX + circleShortDiameter / 2.0;
        double littlerCenterY = startY + (endY - startY) / 2.0;
        double cx1 = littlerCenterX - litllerDiameter / 2.0;
        double cy1 = littlerCenterY - this.HALF_HEIGHT * (double)this.rate;
        double cw1 = litllerDiameter / 2.0;
        double ch1 = this.HALF_HEIGHT * (double)this.rate * 2.0;
        Rectangle2D.Double shape2 = new Rectangle2D.Double((int)Math.round(comStartX - (double)((float)strokesize * this.rate)), (int)Math.round(cy1), (int)Math.round(littlerCenterX - comStartX - litllerDiameter / 2.0 + (double)((float)strokesize * this.rate)), (int)Math.round(ch1));
        pt.append(shape2, true);
        Ellipse2D.Double shape3 = new Ellipse2D.Double((int)Math.round(littlerCenterX - litllerDiameter / 2.0 - (double)((float)strokesize * this.rate / 2.0f)), (int)Math.round(cy1), (int)Math.round(cw1), (int)Math.round(ch1));
        pt.append(shape3, true);
        GeneralPath shape = pt;
        clipShape.append(shape, true);
        double centerY = startY + (endY - startY) / 2.0;
        double centerX = startX + (endX - startX) / 2.0;
        g2d.clip(clipShape);
        double xstart = 0.0;
        double xend = 0.0;
        double ystart = 0.0;
        double yend = 0.0;
        double iVhigh = endY - startY;
        int iType = 1;
        if (endX - startX == iVhigh) {
            xstart = startX;
            xend = startX + (endX - startX) * 2.0;
            ystart = centerY - iVhigh;
            yend = centerY + iVhigh;
            iType = 1;
        } else if (endX - startX > iVhigh) {
            xstart = startX;
            xend = startX + (endX - startX) * 2.0;
            ystart = centerY - (endX - startX);
            yend = centerY + (endX - startX);
            iType = 2;
        } else if (endX - startX < iVhigh) {
            xstart = centerX - iVhigh * 3.0;
            xend = centerX + iVhigh * 3.0;
            ystart = centerY - iVhigh / 2.0;
            yend = centerY + iVhigh * 3.0 / 2.0;
            iType = 3;
        }
        if (LineFile.equals("00001.jpg")) {
            g2d.setColor(color);
            this.drawPolygonGradientPaintRect(g2d, startx0, starty0, endx0, endy0, color, GradientType, vertical, comhalf_heigh);
            g2d.fill(shape);
            g2d.setColor(colorbk);
            int p = 0;
            while (startX + (double)p < endX) {
                double startx = startX + (double)p;
                double endx = startX + (double)p;
                double starty = startY;
                double endy = endY;
                Line2D.Double line = new Line2D.Double(startx, starty, endx, endy);
                g2d.draw(line);
                p += this.lineInterval;
            }
            int q = 0;
            while (startY + (double)q < endY) {
                double starty = startY + (double)q;
                double endy = startY + (double)q;
                double startx = startX;
                double endx = endX;
                Line2D.Double line = new Line2D.Double(startx, starty, endx, endy);
                g2d.draw(line);
                q += this.lineInterval;
            }
            g2d.setClip(oldclip);
        } else if (LineFile.equals("00001_d.jpg")) {
            g2d.setColor(color);
            this.drawPolygonGradientPaintRect(g2d, pgxy.minx, pgxy.miny, pgxy.maxx, pgxy.maxy, color, GradientType, vertical, comhalf_heigh);
            g2d.fill(shape);
            g2d.setColor(colorbk);
            float[] dash1 = new float[]{5.0f};
            g2d.setStroke(new BasicStroke(1.0f, 0, 0, 20.0f, dash1, 0.0f));
            int p = 0;
            while (startX + (double)p < endX) {
                double startx = startX + (double)p;
                double endx = startX + (double)p;
                double starty = startY;
                double endy = endY;
                Line2D.Double line = new Line2D.Double(startx, starty, endx, endy);
                g2d.draw(line);
                p += this.lineInterval;
            }
            int q = 0;
            while (startY + (double)q < endY) {
                double starty = startY + (double)q;
                double endy = startY + (double)q;
                double startx = startX;
                double endx = endX;
                Line2D.Double line = new Line2D.Double(startx, starty, endx, endy);
                g2d.draw(line);
                q += this.lineInterval;
            }
            g2d.setStroke(stroke);
            g2d.setClip(oldclip);
        } else if (LineFile.equals("00003.jpg")) {
            g2d.setColor(color);
            this.drawPolygonGradientPaintRect(g2d, pgxy.minx, pgxy.miny, pgxy.maxx, pgxy.maxy, color, GradientType, vertical, comhalf_heigh);
            g2d.fill(shape);
            g2d.setColor(colorbk);
            int p = 0;
            while (startX + (double)p < endX) {
                double startx = startX + (double)p;
                double endx = startX + (double)p;
                double starty = startY;
                double endy = endY;
                Line2D.Double line = new Line2D.Double(startx, starty, endx, endy);
                g2d.draw(line);
                p += this.lineInterval;
            }
            g2d.setClip(oldclip);
        } else if (LineFile.equals("00003_d.jpg")) {
            g2d.setColor(color);
            this.drawPolygonGradientPaintRect(g2d, pgxy.minx, pgxy.miny, pgxy.maxx, pgxy.maxy, color, GradientType, vertical, comhalf_heigh);
            g2d.fill(shape);
            g2d.setColor(colorbk);
            float[] dash1 = new float[]{5.0f};
            g2d.setStroke(new BasicStroke(1.0f, 0, 0, 20.0f, dash1, 0.0f));
            int p = 0;
            while (startX + (double)p < endX) {
                double startx = startX + (double)p;
                double endx = startX + (double)p;
                double starty = startY;
                double endy = endY;
                Line2D.Double line = new Line2D.Double(startx, starty, endx, endy);
                g2d.draw(line);
                p += this.lineInterval;
            }
            g2d.setStroke(stroke);
            g2d.setClip(oldclip);
        } else if (LineFile.equals("00002.jpg")) {
            g2d.setColor(color);
            this.drawPolygonGradientPaintRect(g2d, pgxy.minx, pgxy.miny, pgxy.maxx, pgxy.maxy, color, GradientType, vertical, comhalf_heigh);
            g2d.fill(shape);
            g2d.setColor(colorbk);
            int q = 0;
            while (startY + (double)q < endY) {
                double starty = startY + (double)q;
                double endy = startY + (double)q;
                double startx = startX;
                double endx = endX;
                Line2D.Double line = new Line2D.Double(startx, starty, endx, endy);
                g2d.draw(line);
                q += this.lineInterval;
            }
            g2d.setClip(oldclip);
        } else if (LineFile.equals("00002_d.jpg")) {
            g2d.setColor(color);
            this.drawPolygonGradientPaintRect(g2d, pgxy.minx, pgxy.miny, pgxy.maxx, pgxy.maxy, color, GradientType, vertical, comhalf_heigh);
            g2d.fill(shape);
            g2d.setColor(colorbk);
            float[] dash1 = new float[]{5.0f};
            g2d.setStroke(new BasicStroke(1.0f, 0, 0, 20.0f, dash1, 0.0f));
            int q = 0;
            while (startY + (double)q < endY) {
                double starty = startY + (double)q;
                double endy = startY + (double)q;
                double startx = startX;
                double endx = endX;
                Line2D.Double line = new Line2D.Double(startx, starty, endx, endy);
                g2d.draw(line);
                q += this.lineInterval;
            }
            g2d.setStroke(stroke);
            g2d.setClip(oldclip);
        } else if (LineFile.equals("00004.jpg")) {
            g2d.setColor(color);
            this.drawPolygonGradientPaintRect(g2d, pgxy.minx, pgxy.miny, pgxy.maxx, pgxy.maxy, color, GradientType, vertical, comhalf_heigh);
            g2d.fill(shape);
            g2d.setColor(colorbk);
            double r = xend - xstart;
            double xendorig = xend;
            double xstartorig = xstart;
            xstart -= r;
            xend += r;
            int p = 0;
            while (xstart + (double)p < xendorig) {
                double startx = xstart + (double)p;
                double starty = ystart;
                double endx = xstartorig + (double)p;
                double endy = yend;
                Line2D.Double line1 = new Line2D.Double(startx, starty, endx, endy);
                g2d.draw(line1);
                p += this.lineInterval;
            }
            g2d.setClip(oldclip);
        } else if (LineFile.equals("00004_d.jpg")) {
            g2d.setColor(color);
            this.drawPolygonGradientPaintRect(g2d, pgxy.minx, pgxy.miny, pgxy.maxx, pgxy.maxy, color, GradientType, vertical, comhalf_heigh);
            g2d.fill(shape);
            g2d.setColor(colorbk);
            int p = 0;
            float[] dash1 = new float[]{5.0f};
            g2d.setStroke(new BasicStroke(1.0f, 0, 0, 20.0f, dash1, 0.0f));
            double r = xend - xstart;
            double xendorig = xend;
            double xstartorig = xstart;
            xstart -= r;
            xend += r;
            while (xstart + (double)p < xendorig) {
                double startx = xstart + (double)p;
                double starty = ystart;
                double endx = xstartorig + (double)p;
                double endy = yend;
                Line2D.Double line1 = new Line2D.Double(startx, starty, endx, endy);
                g2d.draw(line1);
                p += this.lineInterval;
            }
            g2d.setStroke(stroke);
            g2d.setClip(oldclip);
        } else if (LineFile.equals("00005.jpg")) {
            g2d.setColor(color);
            this.drawPolygonGradientPaintRect(g2d, pgxy.minx, pgxy.miny, pgxy.maxx, pgxy.maxy, color, GradientType, vertical, comhalf_heigh);
            g2d.fill(shape);
            g2d.setColor(colorbk);
            double r = xend - xstart;
            double xendorig = xend;
            double xstartorig = xstart;
            xstart -= r;
            xend += r;
            int p = 0;
            while (xstart + (double)p < xendorig) {
                double startx = xstart + (double)p;
                double starty = yend;
                double endx = xstartorig + (double)p;
                double endy = ystart;
                Line2D.Double line1 = new Line2D.Double(startx, starty, endx, endy);
                g2d.draw(line1);
                p += this.lineInterval;
            }
            g2d.setClip(oldclip);
        } else if (LineFile.equals("00005_d.jpg")) {
            g2d.setColor(color);
            this.drawPolygonGradientPaintRect(g2d, pgxy.minx, pgxy.miny, pgxy.maxx, pgxy.maxy, color, GradientType, vertical, comhalf_heigh);
            g2d.fill(shape);
            g2d.setColor(colorbk);
            float[] dash1 = new float[]{5.0f};
            g2d.setStroke(new BasicStroke(1.0f, 0, 0, 20.0f, dash1, 0.0f));
            double r = xend - xstart;
            double xendorig = xend;
            double xstartorig = xstart;
            xstart -= r;
            xend += r;
            int p = 0;
            while (xstart + (double)p < xendorig) {
                double startx = xstart + (double)p;
                double starty = yend;
                double endx = xstartorig + (double)p;
                double endy = ystart;
                Line2D.Double line1 = new Line2D.Double(startx, starty, endx, endy);
                g2d.draw(line1);
                p += this.lineInterval;
            }
            g2d.setStroke(stroke);
            g2d.setClip(oldclip);
        } else if (LineFile.equals("00006.jpg")) {
            Line2D.Double line1;
            double endy;
            double endx;
            double starty;
            double startx;
            g2d.setColor(color);
            this.drawPolygonGradientPaintRect(g2d, pgxy.minx, pgxy.miny, pgxy.maxx, pgxy.maxy, color, GradientType, vertical, comhalf_heigh);
            g2d.fill(shape);
            g2d.setColor(colorbk);
            double r = xend - xstart;
            double xendorig = xend;
            double xstartorig = xstart;
            xstart -= r;
            xend += r;
            int p = 0;
            while (xstart + (double)p < xendorig) {
                startx = xstart + (double)p;
                starty = yend;
                endx = xstartorig + (double)p;
                endy = ystart;
                line1 = new Line2D.Double(startx, starty, endx, endy);
                g2d.draw(line1);
                p += this.lineInterval;
            }
            p = 0;
            r = xend - xstart;
            xendorig = xend;
            xstartorig = xstart;
            xstart -= r;
            xend += r;
            while (xstart + (double)p < xendorig) {
                startx = xstart + (double)p;
                starty = ystart;
                endx = xstartorig + (double)p;
                endy = yend;
                line1 = new Line2D.Double(startx, starty, endx, endy);
                g2d.draw(line1);
                p += this.lineInterval;
            }
            g2d.setClip(oldclip);
        } else if (LineFile.equals("00006_d.jpg")) {
            Line2D.Double line1;
            double endy;
            double endx;
            double starty;
            double startx;
            g2d.setColor(color);
            this.drawPolygonGradientPaintRect(g2d, pgxy.minx, pgxy.miny, pgxy.maxx, pgxy.maxy, color, GradientType, vertical, comhalf_heigh);
            g2d.fill(shape);
            g2d.setColor(colorbk);
            int p = 0;
            float[] dash1 = new float[]{5.0f};
            g2d.setStroke(new BasicStroke(1.0f, 0, 0, 20.0f, dash1, 0.0f));
            double r = xend - xstart;
            double xendorig = xend;
            double xstartorig = xstart;
            xstart -= r;
            xend += r;
            while (xstart + (double)p < xendorig) {
                startx = xstart + (double)p;
                starty = yend;
                endx = xstartorig + (double)p;
                endy = ystart;
                line1 = new Line2D.Double(startx, starty, endx, endy);
                g2d.draw(line1);
                p += this.lineInterval;
            }
            p = 0;
            r = xend - xstart;
            xendorig = xend;
            xstartorig = xstart;
            xstart -= r;
            xend += r;
            while (xstart + (double)p < xendorig) {
                startx = xstart + (double)p;
                starty = ystart;
                endx = xstartorig + (double)p;
                endy = yend;
                line1 = new Line2D.Double(startx, starty, endx, endy);
                g2d.draw(line1);
                p += this.lineInterval;
            }
            g2d.setStroke(stroke);
            g2d.setClip(oldclip);
        } else if (LineFile.equals("00000_1.jpg")) {
            g2d.setColor(color);
            if (this.rate < 1.0f) {
                g2d.setStroke(new BasicStroke(1.0f));
            } else {
                g2d.setStroke(new BasicStroke((int)this.rate));
            }
            this.drawCrystal(g2d, Math.round(pgxy.minx), Math.round(pgxy.miny), Math.round(pgxy.maxx), Math.round(pgxy.maxy), color);
            g2d.setColor(colorbk);
            g2d.setClip(oldclip);
        } else if (LineFile.equals("00000_0.jpg")) {
            g2d.setColor(color);
            this.drawPolygonGradientPaintRect(g2d, pgxy.minx, pgxy.miny, pgxy.maxx, pgxy.maxy, color, GradientType, vertical, comhalf_heigh);
            g2d.fill(shape);
            g2d.setColor(colorbk);
            g2d.setClip(oldclip);
        } else {
            try {
                File objFile = new File("texture/" + LineFile);
                BufferedImage bgImg = ImageIO.read(objFile);
                if (this.bGray) {
                    WritableRaster raster = bgImg.getRaster();
                    int[] sample = new int[4];
                    for (int k = 0; k < bgImg.getWidth(); ++k) {
                        for (int m = 0; m < bgImg.getHeight(); ++m) {
                            raster.getPixel(k, m, sample);
                            Color corig = new Color(sample[0], sample[1], sample[2], sample[3]);
                            Color cl = this.getGrayColor(corig);
                            sample[0] = cl.getRed();
                            sample[1] = cl.getGreen();
                            sample[2] = cl.getBlue();
                            sample[3] = cl.getAlpha();
                            raster.setPixel(k, m, sample);
                        }
                    }
                }
                Rectangle rect = new Rectangle(pgxy.minx, pgxy.miny, pgxy.maxx - pgxy.minx, pgxy.maxy - pgxy.miny);
                TexturePaint texture = new TexturePaint(bgImg, rect);
                Paint pp = g2d.getPaint();
                g2d.setPaint(texture);
                g2d.fill(shape);
                g2d.setClip(oldclip);
                g2d.setPaint(pp);
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        g2d.setStroke(origstroke);
    }

    public void drawCrystal(Graphics2D g2d, double startX, double startY, double endX, double endY, Color color) {
        int li_width = (int)(endX - startX);
        int li_height = (int)Math.round(endY - startY);
        if (li_height <= 1) {
            return;
        }
        Color bgColor = color;
        int[] li_fromcolor = new int[]{bgColor.getRed(), bgColor.getGreen(), bgColor.getBlue()};
        int[][] li_delcolors = this.getDelColors(li_fromcolor, li_height - 1);
        for (int i = 0; i < li_delcolors.length; ++i) {
            int li_r = li_fromcolor[0] + li_delcolors[i][0];
            int li_g = li_fromcolor[1] + li_delcolors[i][1];
            int li_b = li_fromcolor[2] + li_delcolors[i][2];
            if (li_r > 255) {
                li_r = 255;
            }
            if (li_g > 255) {
                li_g = 255;
            }
            if (li_b > 255) {
                li_b = 255;
            }
            g2d.setColor(new Color(li_r, li_g, li_b));
            g2d.drawLine((int)startX + 1, (int)startY + i, (int)startX + 1 + li_width - 2, (int)startY + i);
        }
    }

    public void drawPolygonGradientPaintRect(Graphics2D g2d, double startX, double startY, double endX, double endY, Color color, GradientEnum GradientType, double vertical, double comhalf_heigh) {
        g2d.setColor(this.getGrayColor(color));
        if (GradientType == GradientEnum.Null) {
            g2d.setColor(this.getGrayColor(color));
        } else if (GradientType == GradientEnum.Default) {
            g2d.setPaint(new GradientPaint(0.0f, (float)(startY + (endY - startY) / 2.0), Color.white, 0.0f, (float)endY, this.getGrayColor(color), true));
        } else if (GradientType == GradientEnum.Top_left_to_bottom_right) {
            g2d.setPaint(new GradientPaint((float)startX, (float)startY, Color.white, (float)endX, (float)endY, color, true));
        } else if (GradientType == GradientEnum.Right) {
            g2d.setPaint(new GradientPaint((float)startX, (float)(startY + (endY - startY) / 2.0), Color.white, (float)endX, (float)(startY + (endY - startY) / 2.0), color, true));
        } else if (GradientType == GradientEnum.Bottom_left_to_top_right) {
            g2d.setPaint(new GradientPaint((float)startX, (float)endY, Color.white, (float)endX, (float)startY, color, true));
        } else if (GradientType == GradientEnum.Up) {
            g2d.setPaint(new GradientPaint((float)(startX + (endX - startX) / 2.0), (float)endY, Color.white, (float)(startX + (endX - startX) / 2.0), (float)startY, color, true));
        } else if (GradientType == GradientEnum.Bottom_right_to_top_left) {
            g2d.setPaint(new GradientPaint((float)endX, (float)endY, Color.white, (float)startX, (float)startY, color, true));
        } else if (GradientType == GradientEnum.Left) {
            g2d.setPaint(new GradientPaint((float)endX, (float)(startY + (endY - startY) / 2.0), Color.white, (float)startX, (float)(startY + (endY - startY) / 2.0), color, true));
        } else if (GradientType == GradientEnum.Top_right_to_bottom_left) {
            g2d.setPaint(new GradientPaint((float)endX, (float)startY, Color.white, (float)startX, (float)endY, color, true));
        } else if (GradientType == GradientEnum.Down) {
            g2d.setPaint(new GradientPaint((float)(startX + (endX - startX) / 2.0), (float)startY, Color.white, (float)(startX + (endX - startX) / 2.0), (float)endY, color, true));
        } else if (GradientType == GradientEnum.Center_to_Border) {
            float[] dist = new float[]{0.0f, 0.2f, 1.0f};
            Color[] colors = new Color[]{color, color, Color.WHITE};
            Point2D.Float center = new Point2D.Float((float)(startX + (endX - startX) / 2.0), (float)(startY + (endY - startY) / 2.0));
            double r = 1.0;
            if (endX - startX == endY - startY) {
                r = (endY - startY) / 2.0;
            } else if (endX - startX < endY - startY) {
                r = (endY - startY) / 2.0;
            } else if (endX - startX > endY - startY) {
                r = (endX - startX) / 2.0;
            }
            if (r <= 0.0) {
                r = 1.0;
            }
            g2d.setPaint(new RadialGradientPaint(center, (float)Math.floor(r), dist, colors, MultipleGradientPaint.CycleMethod.NO_CYCLE));
        } else if (GradientType == GradientEnum.Center) {
            float[] dist = new float[]{0.0f, 0.2f, 1.0f};
            Color[] colors = new Color[]{Color.WHITE, Color.WHITE, color};
            Point2D.Float center = new Point2D.Float((float)(startX + (endX - startX) / 2.0), (float)(startY + (endY - startY) / 2.0));
            double r = 1.0;
            if (endX - startX == endY - startY) {
                r = (endY - startY) / 2.0;
            } else if (endX - startX < endY - startY) {
                r = (endY - startY) / 2.0;
            } else if (endX - startX > endY - startY) {
                r = (endX - startX) / 2.0;
            }
            if (r <= 0.0) {
                r = 1.0;
            }
            g2d.setPaint(new RadialGradientPaint(center, (float)Math.floor(r), dist, colors, MultipleGradientPaint.CycleMethod.NO_CYCLE));
        } else if (GradientType == GradientEnum.Vertical) {
            g2d.setPaint(new GradientPaint((float)(startX + (endX - startX) / 2.0), 0.0f, Color.white, (float)endX, 0.0f, this.getGrayColor(color), true));
        } else if (GradientType == GradientEnum.Horizontal) {
            g2d.setPaint(new GradientPaint(0.0f, (float)(startY + (endY - startY) / 2.0), Color.white, 0.0f, (float)endY, this.getGrayColor(color), true));
        }
    }

    private Area drawPolygon(Protein pr, Component com, int vertical, int horizontal, int centerx, int centery, double wide, double high, double angle, String name, DrawTypeEnum nameDrawType, int size, Color color, Color colortext, Color colorline, Graphics2D g2d, ShapeEnum shapeType, boolean isActive, int strokesize, GradientEnum GradientType, String SelectTextureFile, boolean isborderdahs) {
        vertical = -vertical;
        Color colororig = g2d.getColor();
        Stroke origstroke = g2d.getStroke();
        double startx = 0.0;
        double starty = 0.0;
        double endx = 0.0;
        double endy = 0.0;
        double startX = 0.0;
        double startY = 0.0;
        double endX = 0.0;
        double endY = 0.0;
        startx = (double)centerx - wide / 2.0;
        starty = (double)centery - high / 2.0;
        endx = (double)centerx + wide / 2.0;
        endy = (double)centery + high / 2.0;
        startX = (-300.0 + (double)horizontal + startx * this.LENGTH_RATE) * (double)this.rate;
        endX = (-300.0 + (double)horizontal + endx * this.LENGTH_RATE) * (double)this.rate;
        startY = ((double)(vertical - centery) - high / 2.0 * this.LENGTH_RATE) * (double)this.rate;
        endY = ((double)(vertical - centery) + high / 2.0 * this.LENGTH_RATE) * (double)this.rate;
        double centerX = 0.0;
        double centerY = 0.0;
        int iradius = 4;
        centerX = startX + (endX - startX) / 2.0;
        centerY = startY + (endY - startY) / 2.0;
        double comhalf_heigh = (endY - startY) / 2.0;
        Area sa = null;
        sa = this.drawPolygonAndAnchor(g2d, pr, com, isActive, vertical, color, colorline, colororig, colortext, origstroke, strokesize, size, name, nameDrawType, SelectTextureFile, GradientType, shapeType, iradius, comhalf_heigh, centerX, centerY, startX, startY, endX, endY, angle, isborderdahs);
        g2d.setStroke(origstroke);
        return sa;
    }

    private int[][] getDelColors(int[] _fromColor, int _height) {
        int[][] delColor = new int[_height][3];
        int li_half = (int)Math.round((double)_height / 2.0);
        if (li_half == 0) {
            li_half = 1;
        }
        double li_prefix = 57.0;
        double li_d1 = 100.0 / (double)li_half;
        if (li_d1 == 0.0) {
            li_d1 = 1.0;
        }
        for (int i = li_half - 1; i >= 0; --i) {
            delColor[i][0] = (int)(li_prefix + (double)(li_half - 1 - i) * li_d1);
            delColor[i][1] = (int)(li_prefix + (double)(li_half - 1 - i) * li_d1);
            delColor[i][2] = (int)(li_prefix + (double)(li_half - 1 - i) * li_d1);
        }
        double li_d2 = 100.0 / (double)li_half * 0.5;
        if (li_d2 == 0.0) {
            li_d2 = 1.0;
        }
        for (int i = li_half; i < _height; ++i) {
            delColor[i][0] = (int)((double)(i - li_half) * li_d2);
            delColor[i][1] = (int)((double)(i - li_half) * li_d2);
            delColor[i][2] = (int)((double)(i - li_half) * li_d2);
        }
        return delColor;
    }

    private Area drawLine(Protein pr, Component com, int vertical, int horizontal, Point start, Point end, Point control1, Point control2, DrawTypeEnum lineType, int lineWeight, Color color, Graphics2D g2d, boolean isActive, ShapeEnum shapeType, String fname, DrawTypeEnum nameDrawType, int size, Color colortext) {
        vertical = -vertical;
        Color colororig = g2d.getColor();
        Stroke origstroke = g2d.getStroke();
        double dwide = 5.0;
        int iradius = 4;
        int startX = (int)((-300.0 + (double)horizontal + start.getX() * this.LENGTH_RATE) * (double)this.rate);
        int startY = (int)(((double)vertical - start.getY()) * (double)this.rate);
        int endX = (int)((-300.0 + (double)horizontal + end.getX() * this.LENGTH_RATE) * (double)this.rate);
        int endY = (int)(((double)vertical - end.getY()) * (double)this.rate);
        g2d.setColor(color);
        float thick = 0.0f;
        thick = (float)lineWeight * this.rate < 1.0f ? 1.0f : (float)lineWeight * this.rate;
        if (com.isbDash()) {
            float[] dash1 = new float[]{5.0f * this.rate};
            g2d.setStroke(new BasicStroke(thick, 1, 1, 20.0f, dash1, 0.0f));
        } else {
            g2d.setStroke(new BasicStroke(thick, 1, 1));
        }
        Color ac = Color.BLUE;
        Color pc = new Color(0, 255, 0);
        if (shapeType == ShapeEnum.Straight) {
            if (fname.equals("") || fname.equals(null) || fname.equals(" ")) {
                g2d.setColor(color);
                Line2D.Double line = new Line2D.Double(startX, startY, endX, endY);
                g2d.draw(line);
                g2d.setColor(colororig);
            } else {
                g2d.setFont(new Font("Arial", 1, (int)((float)size * this.rate)));
                double centerX = 0.0;
                double centerY = 0.0;
                centerX = (double)startX + (double)(endX - startX) / 2.0;
                centerY = (double)startY + (double)(endY - startY) / 2.0;
                double interx1 = 0.0;
                double intery1 = 0.0;
                double interx2 = 0.0;
                double intery2 = 0.0;
                double textwide = 0.0;
                double texthigh = 0.0;
                FontMetrics noteFontMetrics = g2d.getFontMetrics();
                textwide = noteFontMetrics.stringWidth(fname);
                texthigh = noteFontMetrics.getHeight();
                double angle = 0.0;
                double dx = 0.0;
                double dy = 0.0;
                dx = Math.abs(endX - startX);
                dy = Math.abs(endY - startY);
                if (startX > endX && startY < endY) {
                    angle = Math.atan(dy / dx);
                    interx1 = centerX + Math.abs(textwide / 2.0 * Math.cos(angle));
                    intery1 = centerY - Math.abs(textwide / 2.0 * Math.sin(angle));
                    interx2 = centerX - Math.abs(textwide / 2.0 * Math.cos(angle));
                    intery2 = centerY + Math.abs(textwide / 2.0 * Math.sin(angle));
                } else if (startX < endX && startY < endY) {
                    angle = Math.atan(dx / dy);
                    interx1 = centerX - Math.abs(textwide / 2.0 * Math.sin(angle));
                    intery1 = centerY - Math.abs(textwide / 2.0 * Math.cos(angle));
                    interx2 = centerX + Math.abs(textwide / 2.0 * Math.sin(angle));
                    intery2 = centerY + Math.abs(textwide / 2.0 * Math.cos(angle));
                    angle = 1.5707963267948966 + angle;
                } else if (startX < endX && startY > endY) {
                    angle = Math.atan(dy / dx);
                    interx1 = centerX - Math.abs(textwide / 2.0 * Math.cos(angle));
                    intery1 = centerY + Math.abs(textwide / 2.0 * Math.sin(angle));
                    interx2 = centerX + Math.abs(textwide / 2.0 * Math.cos(angle));
                    intery2 = centerY - Math.abs(textwide / 2.0 * Math.sin(angle));
                    angle = Math.PI + angle;
                } else if (startX > endX && startY > endY) {
                    angle = Math.atan(dx / dy);
                    interx1 = centerX + Math.abs(textwide / 2.0 * Math.sin(angle));
                    intery1 = centerY + Math.abs(textwide / 2.0 * Math.cos(angle));
                    interx2 = centerX - Math.abs(textwide / 2.0 * Math.sin(angle));
                    intery2 = centerY - Math.abs(textwide / 2.0 * Math.cos(angle));
                    angle = 4.71238898038469 + angle;
                } else if (startX >= endX && startY == endY) {
                    angle = 0.0;
                    interx1 = centerX + textwide / 2.0;
                    intery1 = centerY;
                    interx2 = centerX - textwide / 2.0;
                    intery2 = centerY;
                } else if (startX == endX && startY <= endY) {
                    angle = 1.5707963267948966;
                    interx1 = centerX;
                    intery1 = centerY - textwide / 2.0;
                    interx2 = centerX;
                    intery2 = centerY + textwide / 2.0;
                } else if (startX <= endX && startY == endY) {
                    angle = Math.PI;
                    interx1 = centerX - textwide / 2.0;
                    intery1 = centerY;
                    interx2 = centerX + textwide / 2.0;
                    intery2 = centerY;
                } else if (startX == endX && startY >= endY) {
                    angle = 4.71238898038469;
                    interx1 = centerX;
                    intery1 = centerY + textwide / 2.0;
                    interx2 = centerX;
                    intery2 = centerY - textwide / 2.0;
                }
                if (angle > 0.0) {
                    angle = Math.PI * 2 - angle;
                }
                angle += Math.PI;
                if (nameDrawType == DrawTypeEnum.Center) {
                    g2d.setColor(colortext);
                    g2d.rotate(angle, centerX, centerY);
                    g2d.drawString(fname, (float)(centerX - (double)noteFontMetrics.stringWidth(fname) / 2.0), (float)(centerY + (double)noteFontMetrics.getHeight() / 4.0));
                    g2d.rotate(-angle, centerX, centerY);
                    g2d.setColor(color);
                    Line2D.Double line1 = new Line2D.Double(startX, startY, (int)interx1, (int)intery1);
                    g2d.draw(line1);
                    Line2D.Double line2 = new Line2D.Double((int)interx2, (int)intery2, endX, endY);
                    g2d.draw(line2);
                    g2d.setColor(colororig);
                } else if (nameDrawType == DrawTypeEnum.Down) {
                    g2d.setColor(colortext);
                    g2d.rotate(angle, centerX, centerY);
                    g2d.drawString(fname, (float)(centerX - (double)noteFontMetrics.stringWidth(fname) / 2.0), (float)(centerY + (double)noteFontMetrics.getHeight()));
                    g2d.rotate(-angle, centerX, centerY);
                    g2d.setColor(color);
                    Line2D.Double line1 = new Line2D.Double(startX, startY, endX, endY);
                    g2d.draw(line1);
                    g2d.setColor(colororig);
                } else if (nameDrawType == DrawTypeEnum.Up) {
                    g2d.setColor(colortext);
                    g2d.rotate(angle, centerX, centerY);
                    g2d.drawString(fname, (float)(centerX - (double)noteFontMetrics.stringWidth(fname) / 2.0), (float)(centerY - (double)noteFontMetrics.getHeight() / 2.0));
                    g2d.rotate(-angle, centerX, centerY);
                    g2d.setColor(color);
                    Line2D.Double line1 = new Line2D.Double(startX, startY, endX, endY);
                    g2d.draw(line1);
                    g2d.setColor(colororig);
                } else if (nameDrawType == DrawTypeEnum.Hide) {
                    g2d.setColor(color);
                    Line2D.Double line1 = new Line2D.Double(startX, startY, endX, endY);
                    g2d.draw(line1);
                    g2d.setColor(colororig);
                }
            }
            GeneralPath pt = new GeneralPath();
            pt.moveTo((double)startX - dwide, (double)startY - dwide);
            pt.lineTo((double)endX - dwide, (double)endY - dwide);
            pt.lineTo((double)endX + dwide, (double)endY + dwide);
            pt.lineTo((double)startX + dwide, (double)startY + dwide);
            com.GeomArea = new java.awt.geom.Area(pt);
            if (isActive) {
                g2d.setColor(ac);
                g2d.fillOval(startX - iradius, startY - iradius, 2 * iradius, 2 * iradius);
                g2d.fillOval(endX - iradius, endY - iradius, 2 * iradius, 2 * iradius);
            }
            g2d.setColor(color);
            if (lineType == DrawTypeEnum.Arrow) {
                this.drawArrow(g2d, startX, startY, endX, endY, lineWeight);
            } else if (lineType == DrawTypeEnum.DoubleArrow) {
                this.drawArrow(g2d, startX, startY, endX, endY, lineWeight);
                this.drawArrow(g2d, endX, endY, startX, startY, lineWeight);
            } else if (lineType == DrawTypeEnum.Scale) {
                this.drawScale(g2d, startX, startY, endX, endY);
                this.drawScale(g2d, endX, endY, startX, startY);
            } else if (lineType == DrawTypeEnum.ScaleArrow) {
                this.drawArrow(g2d, startX, startY, endX, endY, lineWeight);
                this.drawArrow(g2d, endX, endY, startX, startY, lineWeight);
                this.drawScale(g2d, (int)((float)startX - 4.0f * this.rate), startY, (int)((float)endX + 4.0f * this.rate), endY);
                this.drawScale(g2d, (int)((float)endX + 4.0f * this.rate), endY, (int)((float)startX - 4.0f * this.rate), startY);
            }
            g2d.setColor(colororig);
        } else if (shapeType == ShapeEnum.PolylineOne) {
            g2d.setColor(color);
            int Control1X = (int)((-300.0 + (double)horizontal + control1.getX() * this.LENGTH_RATE) * (double)this.rate);
            int Control1Y = (int)(((double)vertical - control1.getY()) * (double)this.rate);
            GeneralPath path = new GeneralPath();
            path.moveTo(startX, startY);
            path.lineTo(Control1X, Control1Y);
            path.lineTo(endX, endY);
            g2d.draw(path);
            GeneralPath pt = new GeneralPath();
            pt.moveTo((double)startX - dwide, (double)startY - dwide);
            pt.lineTo((double)Control1X - dwide, (double)Control1Y - dwide);
            pt.lineTo((double)endX - dwide, (double)endY - dwide);
            pt.lineTo((double)endX + dwide, (double)endY + dwide);
            pt.lineTo((double)Control1X + dwide, (double)Control1Y + dwide);
            pt.lineTo((double)startX + dwide, (double)startY + dwide);
            pt.lineTo((double)startX - dwide, (double)startY - dwide);
            com.GeomArea = new java.awt.geom.Area(pt);
            if (isActive) {
                g2d.setColor(Color.RED);
                g2d.fillRect(Control1X - iradius, Control1Y - iradius, 2 * iradius, 2 * iradius);
                g2d.setColor(ac);
                g2d.fillOval(startX - iradius, startY - iradius, 2 * iradius, 2 * iradius);
                g2d.fillOval(endX - iradius, endY - iradius, 2 * iradius, 2 * iradius);
                com.ControlArea1 = new Area(Control1X - iradius, Control1Y - iradius, Control1X + iradius, Control1Y + iradius);
            }
            if (lineType == DrawTypeEnum.Arrow) {
                this.drawArrow(g2d, startX, startY, Control1X, Control1Y, lineWeight);
            } else if (lineType == DrawTypeEnum.DoubleArrow) {
                this.drawArrow(g2d, startX, startY, Control1X, Control1Y, lineWeight);
                this.drawArrow(g2d, endX, endY, Control1X, Control1Y, lineWeight);
            } else if (lineType == DrawTypeEnum.Scale) {
                this.drawScale(g2d, startX, startY, Control1X, Control1Y);
                this.drawScale(g2d, endX, endY, Control1X, Control1Y);
            } else if (lineType == DrawTypeEnum.ScaleArrow) {
                this.drawArrow(g2d, startX, startY, Control1X, Control1Y, lineWeight);
                this.drawArrow(g2d, endX, endY, Control1X, Control1Y, lineWeight);
                this.drawScale(g2d, (int)((float)startX - 4.0f * this.rate), startY, (int)((float)endX + 4.0f * this.rate), endY);
                this.drawScale(g2d, (int)((float)endX + 4.0f * this.rate), endY, (int)((float)startX - 4.0f * this.rate), startY);
            }
            g2d.setColor(colororig);
        } else if (shapeType == ShapeEnum.Curve) {
            g2d.setColor(color);
            int Control1X = (int)((-300.0 + (double)horizontal + control1.getX() * this.LENGTH_RATE) * (double)this.rate);
            int Control1Y = (int)(((double)vertical - control1.getY()) * (double)this.rate);
            QuadCurve2D.Double q = new QuadCurve2D.Double(startX, startY, Control1X, Control1Y, endX, endY);
            g2d.draw(q);
            GeneralPath pt = new GeneralPath();
            pt.moveTo((double)startX - dwide, (double)startY - dwide);
            pt.quadTo((double)Control1X - dwide, (double)Control1Y - dwide, (double)endX - dwide, (double)endY - dwide);
            pt.lineTo((double)endX + dwide, (double)endY + dwide);
            pt.quadTo((double)Control1X + dwide, (double)Control1Y + dwide, (double)startX + dwide, (double)startY + dwide);
            pt.lineTo((double)startX - dwide, (double)startY - dwide);
            com.GeomArea = new java.awt.geom.Area(pt);
            if (isActive) {
                g2d.setColor(Color.RED);
                g2d.fillRect(Control1X - iradius, Control1Y - iradius, 2 * iradius, 2 * iradius);
                g2d.setColor(ac);
                g2d.fillOval(startX - iradius, startY - iradius, 2 * iradius, 2 * iradius);
                g2d.fillOval(endX - iradius, endY - iradius, 2 * iradius, 2 * iradius);
                com.ControlArea1 = new Area(Control1X - iradius, Control1Y - iradius, Control1X + iradius, Control1Y + iradius);
            }
            if (lineType == DrawTypeEnum.Arrow) {
                this.drawArrow(g2d, startX, startY, Control1X, Control1Y, lineWeight);
            } else if (lineType == DrawTypeEnum.DoubleArrow) {
                this.drawArrow(g2d, startX, startY, Control1X, Control1Y, lineWeight);
                this.drawArrow(g2d, endX, endY, Control1X, Control1Y, lineWeight);
            } else if (lineType == DrawTypeEnum.Scale) {
                this.drawScale(g2d, startX, startY, Control1X, Control1Y);
                this.drawScale(g2d, endX, endY, Control1X, Control1Y);
            } else if (lineType == DrawTypeEnum.ScaleArrow) {
                this.drawArrow(g2d, startX, startY, Control1X, Control1Y, lineWeight);
                this.drawArrow(g2d, endX, endY, Control1X, Control1Y, lineWeight);
                this.drawScale(g2d, (int)((float)startX - 4.0f * this.rate), startY, (int)((float)Control1X + 4.0f * this.rate), Control1Y);
                this.drawScale(g2d, (int)((float)endX + 4.0f * this.rate), endY, (int)((float)Control1X - 4.0f * this.rate), Control1Y);
            }
            g2d.setColor(colororig);
        } else if (shapeType == ShapeEnum.PolylineTwo) {
            g2d.setColor(color);
            int Control1X = (int)((-300.0 + (double)horizontal + control1.getX() * this.LENGTH_RATE) * (double)this.rate);
            int Control1Y = (int)(((double)vertical - control1.getY()) * (double)this.rate);
            int Control2X = (int)((-300.0 + (double)horizontal + control2.getX() * this.LENGTH_RATE) * (double)this.rate);
            int Control2Y = (int)(((double)vertical - control2.getY()) * (double)this.rate);
            GeneralPath path = new GeneralPath();
            path.moveTo(startX, startY);
            path.lineTo(Control1X, Control1Y);
            path.lineTo(Control2X, Control2Y);
            path.lineTo(endX, endY);
            GeneralPath pt = new GeneralPath();
            pt.moveTo((double)startX - dwide, (double)startY - dwide);
            pt.lineTo((double)Control1X - dwide, (double)Control1Y - dwide);
            pt.lineTo((double)Control2X - dwide, (double)Control2Y - dwide);
            pt.lineTo((double)endX - dwide, (double)endY - dwide);
            pt.lineTo((double)endX + dwide, (double)endY + dwide);
            pt.lineTo((double)Control2X + dwide, (double)Control2Y + dwide);
            pt.lineTo((double)Control1X + dwide, (double)Control1Y + dwide);
            pt.lineTo((double)startX + dwide, (double)startY + dwide);
            pt.lineTo((double)startX - dwide, (double)startY - dwide);
            com.GeomArea = new java.awt.geom.Area(pt);
            g2d.draw(path);
            if (isActive) {
                g2d.setColor(Color.RED);
                g2d.fillRect(Control1X - iradius, Control1Y - iradius, 2 * iradius, 2 * iradius);
                g2d.setColor(Color.ORANGE);
                g2d.fillRect(Control2X - iradius, Control2Y - iradius, 2 * iradius, 2 * iradius);
                g2d.setColor(ac);
                g2d.fillOval(startX - iradius, startY - iradius, 2 * iradius, 2 * iradius);
                g2d.fillOval(endX - iradius, endY - iradius, 2 * iradius, 2 * iradius);
                com.ControlArea1 = new Area(Control1X - iradius, Control1Y - iradius, Control1X + iradius, Control1Y + iradius);
                com.ControlArea2 = new Area(Control2X - iradius, Control2Y - iradius, Control2X + iradius, Control2Y + iradius);
            }
            if (lineType == DrawTypeEnum.Arrow) {
                this.drawArrow(g2d, startX, startY, Control1X, Control1Y, lineWeight);
            } else if (lineType == DrawTypeEnum.DoubleArrow) {
                this.drawArrow(g2d, startX, startY, Control1X, Control1Y, lineWeight);
                this.drawArrow(g2d, endX, endY, Control2X, Control2Y, lineWeight);
            } else if (lineType == DrawTypeEnum.Scale) {
                this.drawScale(g2d, startX, startY, Control1X, Control1Y);
                this.drawScale(g2d, endX, endY, Control2X, Control2Y);
            } else if (lineType == DrawTypeEnum.ScaleArrow) {
                this.drawArrow(g2d, startX, startY, Control1X, Control1Y, lineWeight);
                this.drawArrow(g2d, endX, endY, Control2X, Control2Y, lineWeight);
                this.drawScale(g2d, (int)((float)startX - 4.0f * this.rate), startY, (int)((float)endX + 4.0f * this.rate), endY);
                this.drawScale(g2d, (int)((float)endX + 4.0f * this.rate), endY, (int)((float)startX - 4.0f * this.rate), startY);
            }
            g2d.setColor(colororig);
        } else if (shapeType == ShapeEnum.Bezier) {
            g2d.setColor(color);
            int Control1X = (int)((-300.0 + (double)horizontal + control1.getX() * this.LENGTH_RATE) * (double)this.rate);
            int Control1Y = (int)(((double)vertical - control1.getY()) * (double)this.rate);
            int Control2X = (int)((-300.0 + (double)horizontal + control2.getX() * this.LENGTH_RATE) * (double)this.rate);
            int Control2Y = (int)(((double)vertical - control2.getY()) * (double)this.rate);
            CubicCurve2D.Double q = new CubicCurve2D.Double(startX, startY, Control1X, Control1Y, Control2X, Control2Y, endX, endY);
            g2d.draw(q);
            GeneralPath pt = new GeneralPath();
            pt.moveTo((double)startX - dwide, (double)startY - dwide);
            pt.curveTo((double)Control1X - dwide, (double)Control1Y - dwide, (double)Control2X - dwide, (double)Control2Y - dwide, (double)endX - dwide, (double)endY - dwide);
            pt.lineTo((double)endX + dwide, (double)endY + dwide);
            pt.curveTo((double)Control2X + dwide, (double)Control2Y + dwide, (double)Control1X + dwide, (double)Control1Y + dwide, (double)startX + dwide, (double)startY + dwide);
            pt.lineTo((double)startX - dwide, (double)startY - dwide);
            com.GeomArea = new java.awt.geom.Area(pt);
            if (isActive) {
                g2d.setColor(Color.RED);
                g2d.fillRect(Control1X - iradius, Control1Y - iradius, 2 * iradius, 2 * iradius);
                g2d.setColor(Color.ORANGE);
                g2d.fillRect(Control2X - iradius, Control2Y - iradius, 2 * iradius, 2 * iradius);
                g2d.setColor(ac);
                g2d.fillOval(startX - iradius, startY - iradius, 2 * iradius, 2 * iradius);
                g2d.setColor(ac);
                g2d.fillOval(endX - iradius, endY - iradius, 2 * iradius, 2 * iradius);
                com.ControlArea1 = new Area(Control1X - iradius, Control1Y - iradius, Control1X + iradius, Control1Y + iradius);
                com.ControlArea2 = new Area(Control2X - iradius, Control2Y - iradius, Control2X + iradius, Control2Y + iradius);
            }
            if (lineType == DrawTypeEnum.Arrow) {
                this.drawArrow(g2d, startX, startY, Control1X, Control1Y, lineWeight);
            } else if (lineType == DrawTypeEnum.DoubleArrow) {
                this.drawArrow(g2d, startX, startY, Control1X, Control1Y, lineWeight);
                this.drawArrow(g2d, endX, endY, Control2X, Control2Y, lineWeight);
            } else if (lineType == DrawTypeEnum.Scale) {
                this.drawScale(g2d, startX, startY, Control1X, Control1Y);
                this.drawScale(g2d, endX, endY, Control2X, Control2Y);
            } else if (lineType == DrawTypeEnum.ScaleArrow) {
                this.drawArrow(g2d, startX, startY, Control1X, Control1Y, lineWeight);
                this.drawArrow(g2d, endX, endY, Control2X, Control2Y, lineWeight);
                this.drawScale(g2d, (int)((float)startX - 4.0f * this.rate), startY, (int)((float)endX + 4.0f * this.rate), endY);
                this.drawScale(g2d, (int)((float)endX + 4.0f * this.rate), endY, (int)((float)startX - 4.0f * this.rate), startY);
            }
            g2d.setColor(colororig);
        }
        com.startArea = new Area(startX - iradius, startY - iradius, startX + iradius, startY + iradius);
        com.endArea = new Area(endX - iradius, endY - iradius, endX + iradius, endY + iradius);
        g2d.setColor(colororig);
        Area area = new Area(startX, startY, endX, endY);
        g2d.setStroke(origstroke);
        return area;
    }

    private void drawScale(Graphics2D g2d, int x1, int y1, int x2, int y2) {
        double distance = Math.abs(Point2D.distance(x1, y1, x2, y2));
        int arrowLen = (int)(10.0f * this.rate);
        double xa = (double)x1 - (double)(arrowLen * (y2 - y1)) / distance;
        double ya = (double)y1 + (double)(arrowLen * (x2 - x1)) / distance;
        double xb = (double)x1 + (double)(arrowLen * (y2 - y1)) / distance;
        double yb = (double)y1 - (double)(arrowLen * (x2 - x1)) / distance;
        Line2D.Double line = new Line2D.Double(xa, ya, xb, yb);
        g2d.draw(line);
    }

    private void drawArrow(Graphics2D g2d, int x1, int y1, int x2, int y2, float linesize) {
        double distance = Math.abs(Point2D.distance(x1, y1, x2, y2));
        double x0 = 0.0;
        double y0 = 0.0;
        double xa = 0.0;
        double ya = 0.0;
        double xb = 0.0;
        double yb = 0.0;
        double dw = 10.0f * this.rate;
        double dh = (4.0f + linesize) * this.rate;
        double dx = Math.abs(x1 - x2);
        double dy = Math.abs(y1 - y2);
        x0 = (double)x2 + (distance += (double)(4.0f * this.rate));
        y0 = y2;
        xa = (double)x2 + distance - dw;
        ya = y2;
        xb = (double)x2 + distance - dw;
        yb = y2;
        double anglepoint = 0.0;
        anglepoint = Math.atan(dh / (distance - dw));
        double anglerotation = 0.0;
        if (y1 >= y2 && x1 >= x2) {
            anglerotation = Math.atan(dy / dx);
        } else if (y1 >= y2 && x1 <= x2) {
            anglerotation = 1.5707963267948966 + Math.atan(dx / dy);
        } else if (y1 <= y2 && x1 <= x2) {
            anglerotation = Math.PI + Math.atan(dy / dx);
        } else if (y1 <= y2 && x1 >= x2) {
            anglerotation = 4.71238898038469 + Math.atan(dx / dy);
        }
        double anglefull1 = -anglerotation;
        double anglefulla = -anglerotation + anglepoint;
        double anglefullb = -anglerotation - anglepoint;
        double arcx = 0.0;
        double arcy = 0.0;
        arcx = (x0 - (double)x2) * Math.cos(anglefull1) - (y0 - (double)y2) * Math.sin(anglefull1) + (double)x2;
        arcy = -1.0 * (x0 - (double)x2) * Math.sin(anglefull1) + (y0 - (double)y2) * Math.cos(anglefull1) + (double)y2;
        x0 = (int)Math.round(arcx);
        y0 = (int)Math.round(arcy);
        arcx = (xa - (double)x2) * Math.cos(anglefulla) - (ya - (double)y2) * Math.sin(anglefulla) + (double)x2;
        arcy = -1.0 * (xa - (double)x2) * Math.sin(anglefulla) + (ya - (double)y2) * Math.cos(anglefulla) + (double)y2;
        xa = (int)Math.round(arcx);
        ya = (int)Math.round(arcy);
        arcx = (xb - (double)x2) * Math.cos(anglefullb) - (yb - (double)y2) * Math.sin(anglefullb) + (double)x2;
        arcy = -1.0 * (xb - (double)x2) * Math.sin(anglefullb) + (yb - (double)y2) * Math.cos(anglefullb) + (double)y2;
        xb = (int)Math.round(arcx);
        yb = (int)Math.round(arcy);
        int[] px = new int[3];
        int[] py = new int[3];
        px[0] = (int)x0;
        px[1] = (int)xa;
        px[2] = (int)xb;
        py[0] = (int)y0;
        py[1] = (int)ya;
        py[2] = (int)yb;
        g2d.fillPolygon(px, py, 3);
    }

    private Area drawSite(Protein pr, Component com, int vertical, int horizontal, String positionStr, String text, int deltaX, int deltaY, int size, boolean isShowPosition, Color colorText, Color color, Color colorline, ShapeEnum shapeType, boolean isActive, double angle, double wide, double high, int strokesize, GradientEnum GradientType, String SelectTextureFile, Graphics2D g2d, boolean isborderdahs) {
        Area sa = null;
        Stroke origstroke = g2d.getStroke();
        Color colororig = g2d.getColor();
        vertical = -vertical;
        Area area = new Area();
        double centralX = 0.0;
        double centralY = 0.0;
        if (text.trim().equals("")) {
            text = "     ";
        }
        g2d.setFont(new Font("Arial", 1, (int)((float)size * this.rate)));
        StringTokenizer st = new StringTokenizer(positionStr, ";");
        int siteCount = st.countTokens();
        float thick = 1.0f;
        g2d.setStroke(new BasicStroke((float)strokesize * this.rate, 1, 1));
        if (siteCount == 1) {
            Line2D.Double positionline;
            Rectangle2D.Double rec;
            int site = Integer.parseInt(st.nextToken());
            double siteX = -300.0 + (double)horizontal + (double)site * this.LENGTH_RATE;
            centralX = ((double)deltaX * this.LENGTH_RATE + (double)horizontal - 300.0) * (double)this.rate;
            centralY = (float)(vertical - deltaY) * this.rate;
            if (deltaY >= 0) {
                g2d.setColor(Color.BLACK);
                rec = new Rectangle2D.Double((int)Math.round(siteX * (double)this.rate) - 10, ((double)vertical - this.HALF_HEIGHT) * (double)this.rate - (double)this.LINE_HEIGHT, 20.0, this.LINE_HEIGHT);
                positionline = new Line2D.Double(Math.round(siteX * (double)this.rate), (int)Math.round(((double)vertical - this.HALF_HEIGHT) * (double)this.rate), Math.round(siteX * (double)this.rate), ((double)vertical - this.HALF_HEIGHT) * (double)this.rate - (double)this.LINE_HEIGHT);
                Line2D.Double directLine = new Line2D.Double(Math.round(siteX * (double)this.rate), (int)Math.round(((double)vertical - this.HALF_HEIGHT) * (double)this.rate - (double)this.LINE_HEIGHT), centralX, centralY);
                g2d.setColor(this.getGrayColor(colorline));
                g2d.draw(directLine);
                g2d.draw(positionline);
                g2d.setColor(this.getGrayColor(colorText));
                if (isShowPosition) {
                    g2d.setFont(new Font("Arial", 1, this.positionFontSize));
                    g2d.drawString(String.valueOf(site), (float)(siteX * (double)this.rate + 2.0), (float)(((double)vertical - this.HALF_HEIGHT) * (double)this.rate - (double)this.positionFontMetrics.getDescent()));
                }
                g2d.setFont(new Font("Arial", 1, (int)((float)size * this.rate)));
                if (shapeType == ShapeEnum.Null) {
                    g2d.drawString(text, (float)(centralX - (double)g2d.getFontMetrics().stringWidth(text) / 2.0), (float)(centralY - (double)g2d.getFontMetrics().getDescent()));
                }
                area = new Area(centralX - (double)g2d.getFontMetrics().stringWidth(text) / 2.0, centralY + 20.0, centralX + (double)g2d.getFontMetrics().stringWidth(text) / 2.0, centralY - (double)g2d.getFontMetrics().getHeight() - 20.0);
            } else {
                g2d.setColor(Color.BLACK);
                rec = new Rectangle2D.Double(siteX * (double)this.rate - 10.0, ((double)vertical + this.HALF_HEIGHT) * (double)this.rate, 20.0, this.LINE_HEIGHT);
                positionline = new Line2D.Double(Math.round(siteX * (double)this.rate), (int)Math.round(((double)vertical + this.HALF_HEIGHT) * (double)this.rate), Math.round(siteX * (double)this.rate), ((double)vertical + this.HALF_HEIGHT) * (double)this.rate + (double)this.LINE_HEIGHT);
                Line2D.Double directLine = new Line2D.Double(Math.round(siteX * (double)this.rate), (int)Math.round(((double)vertical + this.HALF_HEIGHT) * (double)this.rate) + this.LINE_HEIGHT, Math.round(centralX), centralY);
                g2d.setColor(this.getGrayColor(colorline));
                g2d.draw(directLine);
                g2d.draw(positionline);
                g2d.setColor(this.getGrayColor(colorText));
                if (isShowPosition) {
                    g2d.setFont(new Font("Arial", 1, this.positionFontSize));
                    g2d.drawString(String.valueOf(site), (float)(siteX * (double)this.rate + 2.0), (float)(((double)vertical + this.HALF_HEIGHT) * (double)this.rate) + (float)this.positionFontMetrics.getAscent());
                }
                g2d.setFont(new Font("Arial", 1, (int)((float)size * this.rate)));
                if (shapeType == ShapeEnum.Null) {
                    g2d.drawString(text, (float)(centralX - (double)g2d.getFontMetrics().stringWidth(text) / 2.0), (float)(centralY + (double)g2d.getFontMetrics().getAscent()));
                }
                area = new Area(centralX - (double)g2d.getFontMetrics().stringWidth(text) / 2.0, centralY - 20.0, centralX + (double)g2d.getFontMetrics().stringWidth(text) / 2.0, centralY + (double)g2d.getFontMetrics().getHeight() + 20.0);
            }
            SitePosition sp1 = new SitePosition(rec, site);
            com.sp.clear();
            com.sp.add(sp1);
        } else if (siteCount == 2) {
            Line2D.Double lastAngleLine;
            Line2D.Double lastSiteline;
            Line2D.Double firstSiteline;
            Rectangle2D.Double rec1 = null;
            Rectangle2D.Double rec2 = null;
            g2d.setColor(this.getGrayColor(colorline));
            LinkedList<Integer> siteList = new LinkedList<Integer>();
            for (int i = 0; i < siteCount; ++i) {
                siteList.add(Integer.parseInt(st.nextToken()));
            }
            Collections.sort(siteList);
            int firstSite = Integer.parseInt(String.valueOf(siteList.getFirst()));
            int lastSite = Integer.parseInt(String.valueOf(siteList.getLast()));
            g2d.setColor(Color.BLACK);
            double firstSiteX = -300.0 + (double)horizontal + (double)firstSite * this.LENGTH_RATE;
            double lastSiteX = -300.0 + (double)horizontal + (double)lastSite * this.LENGTH_RATE;
            centralX = ((double)deltaX * this.LENGTH_RATE - 300.0 + (double)horizontal) * (double)this.rate;
            centralY = (float)(vertical - deltaY) * this.rate;
            if (deltaY >= 0) {
                rec1 = new Rectangle2D.Double(firstSiteX * (double)this.rate - 10.0, (int)Math.round(((double)vertical - this.HALF_HEIGHT) * (double)this.rate - (double)this.LINE_HEIGHT), 20.0, this.LINE_HEIGHT);
                rec2 = new Rectangle2D.Double(lastSiteX * (double)this.rate - 10.0, (int)Math.round(((double)vertical - this.HALF_HEIGHT) * (double)this.rate - (double)this.LINE_HEIGHT), 20.0, this.LINE_HEIGHT);
                firstSiteline = new Line2D.Double(Math.round(firstSiteX * (double)this.rate), (int)Math.round(((double)vertical - this.HALF_HEIGHT) * (double)this.rate), Math.round(firstSiteX * (double)this.rate), ((double)vertical - this.HALF_HEIGHT) * (double)this.rate - (double)this.LINE_HEIGHT);
                g2d.draw(firstSiteline);
                lastSiteline = new Line2D.Double(Math.round(lastSiteX * (double)this.rate), (int)Math.round(((double)vertical - this.HALF_HEIGHT) * (double)this.rate), Math.round(lastSiteX * (double)this.rate), ((double)vertical - this.HALF_HEIGHT) * (double)this.rate - (double)this.LINE_HEIGHT);
                g2d.draw(lastSiteline);
                Line2D.Double firstAngleLine = new Line2D.Double(Math.round(firstSiteX * (double)this.rate), (int)Math.round(((double)vertical - this.HALF_HEIGHT) * (double)this.rate - (double)this.LINE_HEIGHT), Math.round(centralX - (double)g2d.getFontMetrics().stringWidth(text) / 2.0), centralY);
                g2d.draw(firstAngleLine);
                lastAngleLine = new Line2D.Double(Math.round(lastSiteX * (double)this.rate), (int)Math.round(((double)vertical - this.HALF_HEIGHT) * (double)this.rate - (double)this.LINE_HEIGHT), Math.round(centralX + (double)g2d.getFontMetrics().stringWidth(text) / 2.0), centralY);
                g2d.draw(lastAngleLine);
                g2d.setColor(this.getGrayColor(colorText));
                if (isShowPosition) {
                    g2d.setFont(new Font("Arial", 1, this.positionFontSize));
                    g2d.drawString(String.valueOf(firstSite), (float)(firstSiteX * (double)this.rate - 2.0 - (double)this.positionFontMetrics.stringWidth(String.valueOf(firstSite))), (float)(((double)vertical - this.HALF_HEIGHT) * (double)this.rate - (double)this.positionFontMetrics.getDescent()));
                    g2d.drawString(String.valueOf(lastSite), (float)(lastSiteX * (double)this.rate + 2.0), (float)(((double)vertical - this.HALF_HEIGHT) * (double)this.rate - (double)this.positionFontMetrics.getDescent()));
                }
                g2d.setFont(new Font("Arial", 1, (int)((float)size * this.rate)));
                if (shapeType == ShapeEnum.Null) {
                    g2d.drawString(text, (float)(centralX - (double)g2d.getFontMetrics().stringWidth(text) / 2.0), (float)(centralY - (double)g2d.getFontMetrics().getDescent()));
                }
                area = new Area(centralX - (double)g2d.getFontMetrics().stringWidth(text) / 2.0, centralY + 20.0, centralX + (double)g2d.getFontMetrics().stringWidth(text) / 2.0, centralY - (double)g2d.getFontMetrics().getHeight() - 20.0);
            } else {
                rec1 = new Rectangle2D.Double(firstSiteX * (double)this.rate - 10.0, ((double)vertical + this.HALF_HEIGHT) * (double)this.rate, 20.0, this.LINE_HEIGHT);
                rec2 = new Rectangle2D.Double(lastSiteX * (double)this.rate - 10.0, ((double)vertical + this.HALF_HEIGHT) * (double)this.rate, 20.0, this.LINE_HEIGHT);
                g2d.setColor(this.getGrayColor(colorline));
                firstSiteline = new Line2D.Double(Math.round(firstSiteX * (double)this.rate), (int)Math.round(((double)vertical + this.HALF_HEIGHT) * (double)this.rate), Math.round(firstSiteX * (double)this.rate), ((double)vertical + this.HALF_HEIGHT) * (double)this.rate + (double)this.LINE_HEIGHT);
                g2d.draw(firstSiteline);
                lastSiteline = new Line2D.Double(Math.round(lastSiteX * (double)this.rate), (int)Math.round(((double)vertical + this.HALF_HEIGHT) * (double)this.rate), Math.round(lastSiteX * (double)this.rate), ((double)vertical + this.HALF_HEIGHT) * (double)this.rate + (double)this.LINE_HEIGHT);
                g2d.draw(lastSiteline);
                Line2D.Double firstAngleLine = new Line2D.Double(Math.round(firstSiteX * (double)this.rate), (int)Math.round(((double)vertical + this.HALF_HEIGHT) * (double)this.rate + (double)this.LINE_HEIGHT), Math.round(centralX - (double)g2d.getFontMetrics().stringWidth(text) / 2.0), centralY);
                g2d.draw(firstAngleLine);
                lastAngleLine = new Line2D.Double(Math.round(lastSiteX * (double)this.rate), (int)Math.round(((double)vertical + this.HALF_HEIGHT) * (double)this.rate + (double)this.LINE_HEIGHT), Math.round(centralX + (double)g2d.getFontMetrics().stringWidth(text) / 2.0), centralY);
                g2d.draw(lastAngleLine);
                g2d.setColor(this.getGrayColor(colorText));
                if (isShowPosition) {
                    g2d.setFont(new Font("Arial", 1, this.positionFontSize));
                    g2d.drawString(String.valueOf(firstSite), (float)(Math.round(firstSiteX * (double)this.rate) - 2L - (long)this.positionFontMetrics.stringWidth(String.valueOf(firstSite))), (float)(((double)vertical + this.HALF_HEIGHT) * (double)this.rate + (double)this.positionFontMetrics.getAscent()));
                    g2d.drawString(String.valueOf(lastSite), (float)(lastSiteX * (double)this.rate + 2.0), (float)(((double)vertical + this.HALF_HEIGHT) * (double)this.rate) + (float)this.positionFontMetrics.getAscent());
                }
                g2d.setFont(new Font("Arial", 1, (int)((float)size * this.rate)));
                if (shapeType == ShapeEnum.Null) {
                    g2d.drawString(text, (float)(centralX - (double)g2d.getFontMetrics().stringWidth(text) / 2.0), (float)(centralY + (double)g2d.getFontMetrics().getAscent()));
                }
                area = new Area(centralX - (double)g2d.getFontMetrics().stringWidth(text) / 2.0, centralY - 20.0, centralX + (double)g2d.getFontMetrics().stringWidth(text) / 2.0, centralY + (double)g2d.getFontMetrics().getHeight() + 20.0);
            }
            SitePosition sp1 = new SitePosition(rec1, firstSite);
            SitePosition sp2 = new SitePosition(rec2, lastSite);
            com.sp.clear();
            com.sp.add(sp1);
            com.sp.add(sp2);
        } else {
            Line2D.Double directLine;
            SitePosition sp1;
            g2d.setColor(this.getGrayColor(colorline));
            LinkedList<Integer> siteList = new LinkedList<Integer>();
            for (int i = 0; i < siteCount; ++i) {
                siteList.add(Integer.parseInt(st.nextToken()));
            }
            Collections.sort(siteList);
            g2d.setColor(Color.BLACK);
            centralX = ((double)deltaX * this.LENGTH_RATE + (double)horizontal - 300.0) * (double)this.rate;
            centralY = (float)(vertical - deltaY) * this.rate;
            com.sp.clear();
            if (deltaY >= 0) {
                Iterator iter = siteList.iterator();
                while (iter.hasNext()) {
                    int site = Integer.parseInt(String.valueOf(iter.next()));
                    double siteX = -300.0 + (double)horizontal + (double)site * this.LENGTH_RATE;
                    Rectangle2D.Double rec = new Rectangle2D.Double(siteX * (double)this.rate - 10.0, ((double)vertical - this.HALF_HEIGHT) * (double)this.rate - (double)this.LINE_HEIGHT, 20.0, this.LINE_HEIGHT);
                    sp1 = new SitePosition(rec, site);
                    com.sp.add(sp1);
                    Line2D.Double positionline = new Line2D.Double(Math.round(siteX * (double)this.rate), (int)Math.round(((double)vertical - this.HALF_HEIGHT) * (double)this.rate), Math.round(siteX * (double)this.rate), ((double)vertical - this.HALF_HEIGHT) * (double)this.rate - (double)this.LINE_HEIGHT);
                    g2d.draw(positionline);
                    directLine = new Line2D.Double(Math.round(siteX * (double)this.rate), (int)Math.round(((double)vertical - this.HALF_HEIGHT) * (double)this.rate - (double)this.LINE_HEIGHT), Math.round(centralX), centralY);
                    g2d.draw(directLine);
                    g2d.setColor(this.getGrayColor(colorText));
                    if (!isShowPosition) continue;
                    g2d.setFont(new Font("Arial", 1, this.positionFontSize));
                    g2d.drawString(String.valueOf(site), (float)(siteX * (double)this.rate + 2.0), (float)(((double)vertical - this.HALF_HEIGHT) * (double)this.rate - (double)this.positionFontMetrics.getDescent()));
                }
                g2d.setColor(this.getGrayColor(colorText));
                g2d.setFont(new Font("Arial", 1, (int)((float)size * this.rate)));
                if (shapeType == ShapeEnum.Null) {
                    g2d.drawString(text, (float)(centralX - (double)g2d.getFontMetrics().stringWidth(text) / 2.0), (float)(centralY - (double)g2d.getFontMetrics().getDescent()));
                }
                area = new Area(centralX - (double)g2d.getFontMetrics().stringWidth(text) / 2.0, centralY + 20.0, centralX + (double)g2d.getFontMetrics().stringWidth(text) / 2.0, centralY - (double)g2d.getFontMetrics().getHeight() - 20.0);
            } else {
                Iterator iter = siteList.iterator();
                while (iter.hasNext()) {
                    g2d.setColor(this.getGrayColor(colorline));
                    int site = Integer.parseInt(String.valueOf(iter.next()));
                    double siteX = -300.0 + (double)horizontal + (double)site * this.LENGTH_RATE;
                    Rectangle2D.Double rec = new Rectangle2D.Double(siteX * (double)this.rate - 10.0, ((double)vertical + this.HALF_HEIGHT) * (double)this.rate, 20.0, this.LINE_HEIGHT);
                    sp1 = new SitePosition(rec, site);
                    com.sp.add(sp1);
                    Line2D.Double positionline = new Line2D.Double(Math.round(siteX * (double)this.rate), (int)Math.round(((double)vertical + this.HALF_HEIGHT) * (double)this.rate), Math.round(siteX * (double)this.rate), ((double)vertical + this.HALF_HEIGHT) * (double)this.rate + (double)this.LINE_HEIGHT);
                    g2d.draw(positionline);
                    directLine = new Line2D.Double(Math.round(siteX * (double)this.rate), (int)Math.round(((double)vertical + this.HALF_HEIGHT) * (double)this.rate + (double)this.LINE_HEIGHT), Math.round(centralX), centralY);
                    g2d.draw(directLine);
                    g2d.setColor(this.getGrayColor(colorText));
                    if (!isShowPosition) continue;
                    g2d.setFont(new Font("Arial", 1, this.positionFontSize));
                    g2d.drawString(String.valueOf(site), (float)Math.round(siteX * (double)this.rate + 2.0), (float)(((double)vertical + this.HALF_HEIGHT) * (double)this.rate) + (float)this.positionFontMetrics.getAscent());
                }
                g2d.setColor(this.getGrayColor(colorText));
                g2d.setFont(new Font("Arial", 1, (int)((float)size * this.rate)));
                if (shapeType == ShapeEnum.Null) {
                    g2d.drawString(text, (float)(centralX - (double)g2d.getFontMetrics().stringWidth(text) / 2.0), (float)(centralY + (double)g2d.getFontMetrics().getAscent()));
                }
                area = new Area(centralX - (double)g2d.getFontMetrics().stringWidth(text) / 2.0, centralY - 20.0, centralX + (double)g2d.getFontMetrics().stringWidth(text) / 2.0, centralY + (double)g2d.getFontMetrics().getHeight() + 20.0);
            }
        }
        g2d.setFont(new Font("Arial", 1, this.positionFontSize));
        if (shapeType != ShapeEnum.Null) {
            g2d.setStroke(origstroke);
            double centerx = 0.0;
            double centery = 0.0;
            double startx = 0.0;
            double starty = 0.0;
            double endx = 0.0;
            double endy = 0.0;
            double startX = 0.0;
            double startY = 0.0;
            double endX = 0.0;
            double endY = 0.0;
            centerx = deltaX;
            centery = deltaY;
            com.setCenterx(deltaX);
            com.setCentery(deltaY);
            startx = centerx - wide / 2.0;
            starty = centery - high / 2.0;
            endx = centerx + wide / 2.0;
            endy = centery + high / 2.0;
            startX = (-300.0 + (double)horizontal + startx * this.LENGTH_RATE) * (double)this.rate;
            endX = (-300.0 + (double)horizontal + endx * this.LENGTH_RATE) * (double)this.rate;
            startY = ((double)vertical - centery - high / 2.0 * this.LENGTH_RATE) * (double)this.rate;
            endY = ((double)vertical - centery + high / 2.0 * this.LENGTH_RATE) * (double)this.rate;
            int iradius = 4;
            Color ac = Color.BLUE;
            Color pc = new Color(0, 255, 0);
            double centerX = 0.0;
            double centerY = 0.0;
            Color colorbk = colorline;
            double comhalf_heigh = (endY - startY) / 2.0;
            centerX = startX + (endX - startX) / 2.0;
            centerY = startY + (endY - startY) / 2.0;
            sa = this.drawPolygonAndAnchor(g2d, pr, com, isActive, vertical, color, colorline, colororig, colorText, origstroke, strokesize, size, text, DrawTypeEnum.Center, SelectTextureFile, GradientType, shapeType, iradius, comhalf_heigh, centerX, centerY, startX, startY, endX, endY, angle, isborderdahs);
        }
        g2d.setStroke(origstroke);
        if (sa == null) {
            return area;
        }
        return sa;
    }

    private Area drawNote(Protein pr, Component com, int vertical, int horizontal, String note, int deltaX, int deltaY, int size, DrawTypeEnum style, double angle, Color color, boolean isActive, int linesize, Color colorline, boolean bdash, String strFont, Graphics2D g2d) {
        vertical = -vertical;
        Color colororig = g2d.getColor();
        g2d.setColor(color);
        Stroke origstroke = g2d.getStroke();
        if (style == DrawTypeEnum.Bold) {
            g2d.setFont(new Font(strFont, 1, (int)((float)size * this.rate)));
        } else if (style == DrawTypeEnum.Italic) {
            g2d.setFont(new Font(strFont, 2, (int)((float)size * this.rate)));
        } else if (style == DrawTypeEnum.Plain) {
            g2d.setFont(new Font(strFont, 0, (int)((float)size * this.rate)));
        } else if (style == DrawTypeEnum.Bold_Italic) {
            g2d.setFont(new Font(strFont, 3, (int)((float)size * this.rate)));
        }
        FontMetrics noteFontMetrics = g2d.getFontMetrics();
        double centralX = ((double)deltaX * this.LENGTH_RATE + (double)horizontal - 300.0) * (double)this.rate;
        double centralY = (float)(vertical - deltaY) * this.rate;
        double startX = centralX - (double)noteFontMetrics.stringWidth(note) / 2.0;
        double endX = centralX + (double)noteFontMetrics.stringWidth(note) / 2.0;
        double startY = centralY - (double)noteFontMetrics.getHeight() / 2.0;
        double endY = centralY + (double)noteFontMetrics.getHeight() / 2.0;
        double dangle = angle;
        PolygonXY pgxy = new PolygonXY();
        pgxy.getPolygonXY(startX, startY, endX, endY, "Rectangle", dangle, this.rate);
        pgxy.CacuMinMaxXY();
        int iradius = 4;
        if (isActive) {
            g2d.setColor(Color.RED);
            g2d.fillOval((int)(centralX - (double)iradius), (int)(centralY - (double)iradius), 2 * iradius, 2 * iradius);
            g2d.setColor(Color.ORANGE);
            Ellipse2D.Double shapeAnchor1 = new Ellipse2D.Double((int)pgxy.endax[0] - iradius, (int)pgxy.enday[0] - iradius, 2 * iradius, 2 * iradius);
            com.GeomAnchor1 = new java.awt.geom.Area(shapeAnchor1);
            Ellipse2D.Double shapeAnchor2 = new Ellipse2D.Double((int)pgxy.endax[1] - iradius, (int)pgxy.enday[1] - iradius, 2 * iradius, 2 * iradius);
            com.GeomAnchor2 = new java.awt.geom.Area(shapeAnchor2);
            Ellipse2D.Double shapeAnchor3 = new Ellipse2D.Double((int)pgxy.endax[2] - iradius, (int)pgxy.enday[2] - iradius, 2 * iradius, 2 * iradius);
            com.GeomAnchor3 = new java.awt.geom.Area(shapeAnchor3);
            Ellipse2D.Double shapeAnchor4 = new Ellipse2D.Double((int)pgxy.endax[3] - iradius, (int)pgxy.enday[3] - iradius, 2 * iradius, 2 * iradius);
            com.GeomAnchor4 = new java.awt.geom.Area(shapeAnchor4);
            g2d.fill(shapeAnchor4);
            g2d.fill(shapeAnchor3);
            g2d.fill(shapeAnchor2);
            g2d.fill(shapeAnchor1);
            Rectangle2D.Double shapeAnchorE1 = new Rectangle2D.Double((int)pgxy.endcx[0] - iradius, (int)pgxy.endcy[0] - iradius, 2 * iradius, 2 * iradius);
            com.GeomAnchorE1 = new java.awt.geom.Area(shapeAnchorE1);
            Rectangle2D.Double shapeAnchorE2 = new Rectangle2D.Double((int)pgxy.endcx[1] - iradius, (int)pgxy.endcy[1] - iradius, 2 * iradius, 2 * iradius);
            com.GeomAnchorE2 = new java.awt.geom.Area(shapeAnchorE2);
            Rectangle2D.Double shapeAnchorE3 = new Rectangle2D.Double((int)pgxy.endcx[2] - iradius, (int)pgxy.endcy[2] - iradius, 2 * iradius, 2 * iradius);
            com.GeomAnchorE3 = new java.awt.geom.Area(shapeAnchorE3);
            Rectangle2D.Double shapeAnchorE4 = new Rectangle2D.Double((int)pgxy.endcx[3] - iradius, (int)pgxy.endcy[3] - iradius, 2 * iradius, 2 * iradius);
            com.GeomAnchorE4 = new java.awt.geom.Area(shapeAnchorE4);
            g2d.fill(shapeAnchorE4);
            g2d.fill(shapeAnchorE3);
            g2d.fill(shapeAnchorE2);
            g2d.fill(shapeAnchorE1);
            iradius = 5;
            g2d.setColor(Color.RED);
            if (com.GeomAnchorRotate != null && com.bAnchorRotateSelected && com.dEndRotateDrag != null) {
                double dx = com.dEndRotateDrag.x;
                double dy = com.dEndRotateDrag.y;
                Rectangle2D.Double shapeOval = new Rectangle2D.Double((int)dx - iradius, (int)dy - iradius, 2 * iradius, 2 * iradius);
                com.GeomAnchorRotate = new java.awt.geom.Area(shapeOval);
                g2d.drawOval((int)dx - iradius, (int)dy - iradius, 2 * iradius, 2 * iradius);
                this.drawAnchorRotateArrow(g2d, (int)(dx + (double)iradius), (int)(dy + (double)(iradius / 8)), (int)(dx + (double)iradius), (int)(dy - (double)iradius));
            } else {
                double rx = Math.sqrt(Math.pow(pgxy.endax[0] - centralX, 2.0) + Math.pow(pgxy.enday[0] - centralY, 2.0));
                Rectangle2D.Double shapeOval = new Rectangle2D.Double(endX + rx + 15.0 - (double)iradius, startY - (double)iradius - 15.0, 2 * iradius, 2 * iradius);
                com.GeomAnchorRotate = new java.awt.geom.Area(shapeOval);
                double cx = endX + rx + 15.0 - (double)iradius;
                double cy = startY - (double)iradius - 15.0;
                double cw = 2 * iradius;
                double ch = 2 * iradius;
                double startang = 0.0;
                double endang = 270.0;
                Arc2D.Double arc1 = new Arc2D.Double(cx, cy, cw, ch, startang, endang, 0);
                g2d.draw(arc1);
                this.drawAnchorRotateArrow(g2d, (int)(endX + rx + 15.0 + (double)iradius), (int)(startY + (double)(iradius / 8) - 15.0), (int)(endX + rx + 15.0 + (double)iradius), (int)(startY - (double)iradius - 15.0));
            }
            com.ControlArea1 = new Area(centralX - (double)iradius, centralY - (double)iradius, centralX + (double)(2 * iradius), centralY + (double)(2 * iradius));
        }
        Area area = null;
        float thick1 = linesize;
        if (bdash) {
            float[] dash1 = new float[]{5.0f};
            g2d.setStroke(new BasicStroke(thick1 * this.rate, 1, 1, 20.0f, dash1, 0.0f));
        } else {
            g2d.setStroke(new BasicStroke(thick1 * this.rate, 1, 1));
        }
        g2d.rotate(dangle * 2.0 * Math.PI / 360.0, centralX, centralY);
        if (linesize > 0) {
            g2d.setColor(colorline);
            g2d.drawRect((int)(centralX - (double)noteFontMetrics.stringWidth(note) / 2.0), (int)(centralY - (double)noteFontMetrics.getHeight() / 2.0), noteFontMetrics.stringWidth(note), (int)((double)noteFontMetrics.getHeight() / 1.0));
        }
        g2d.setColor(color);
        g2d.drawString(note, (float)(centralX - (double)noteFontMetrics.stringWidth(note) / 2.0), (float)(centralY + (double)noteFontMetrics.getHeight() / 4.0));
        g2d.rotate(-dangle * 2.0 * Math.PI / 360.0, centralX, centralY);
        area = new Area(pgxy.minx, pgxy.miny, pgxy.maxx, pgxy.maxy);
        g2d.setStroke(origstroke);
        g2d.setColor(colororig);
        return area;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2d.translate((float)this.getWidth() / 2.0f, (float)this.getHeight() / 2.0f);
        if (this.proteinList.isEmpty()) {
            if (!this.boot) {
                this.drawLogo(g2d);
            }
        } else {
            this.drawComponent(g2d);
        }
    }

    public LinkedList<Protein> getProteinList() {
        return this.proteinList;
    }

    public void setProteinList(LinkedList<Protein> proteinList) {
        this.proteinList = proteinList;
    }

    public int getCurrentProteinNum() {
        return this.currentProteinNum;
    }

    public void setCurrentProteinNum(int num) {
        this.currentProteinNum = num;
    }

    public Protein getCurrentProtein() {
        return this.proteinList.get(this.currentProteinNum);
    }

    public void setCurrentVertical(int vertical) {
        this.currentVertical = vertical;
    }

    public int getCurrentVertical() {
        return this.currentVertical;
    }

    public void outputSVG(Graphics2D g2d, String outputPath, int width, int height) {
        try {
            SVGService ss = new SVGService();
            ss.SVGFilePathFull = outputPath;
            ss.proteinList = this.proteinList;
            ss.canvasWide = width;
            ss.canvasHigh = height;
            ss.rate = this.rate;
            Document doc = new Document();
            doc = this.Mode.equals("N") ? ss.drawSVGComponentNucleotide(g2d) : ss.drawSVGComponentProtein(g2d);
            XMLOutputter xmlOut = new XMLOutputter(Format.getPrettyFormat());
            xmlOut.output(doc, (OutputStream)new FileOutputStream(new File(outputPath)));
            ss.reWriteSVGFile(outputPath);
        }
        catch (IOException ex) {
            Logger.getLogger(CanvasPanel.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void outputImage(int width, int height, String outputFilePath, String imageType) {
        float tempRate = this.rate;
        try {
            for (Protein protein : this.proteinList) {
                protein.isActive = false;
                protein.selectNum = -1;
                LinkedList<Component> componentList = protein.getComponentList();
                if (componentList.size() <= 0) continue;
                for (int k = 0; k < componentList.size(); ++k) {
                    Component component = componentList.get(k);
                    component.bSelected = false;
                    component.isActive = false;
                }
            }
            this.rate = this.batchOutrate != 0.0f ? this.batchOutrate : this.rate * (float)width / (float)this.getWidth();
            BufferedImage image = new BufferedImage(width, height, 6);
            if (imageType.equals("JPG")) {
                image = new BufferedImage(width, height, 5);
            }
            Graphics2D g2d = image.createGraphics();
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
            g2d.setFont(new Font("Arial", 1, this.positionFontSize));
            g2d.setBackground(Color.white);
            g2d.fillRect(0, 0, width, height);
            g2d.translate((float)width / 2.0f, (float)height / 2.0f);
            this.drawComponent(g2d);
            g2d.dispose();
            image.flush();
            if (imageType.equals("TIFF600dpi")) {
                new TiffOutput(image, outputFilePath, 600);
            } else if (imageType.equals("TIFF300dpi")) {
                new TiffOutput(image, outputFilePath, 300);
            } else if (imageType.equals("SVG")) {
                this.outputSVG(g2d, outputFilePath, width, height);
            } else {
                ImageIO.write((RenderedImage)image, imageType, new File(outputFilePath));
            }
        }
        catch (IOException ex) {
            // empty catch block
        }
        this.rate = tempRate;
    }

    public void setWHRatio() {
        this.whRatio = (double)this.getWidth() / (double)this.getHeight();
    }

    public void zoomInScale(double drate) {
    }

    public void zoomOutScale(double drate) {
        int width = (int)Math.round((double)this.getWidth() * drate / (double)this.rate / 100.0) * 100;
        int height = (int)Math.round((double)width / this.whRatio / 100.0) * 100;
        this.rate = (float)drate;
        this.setPreferredSize(new Dimension(width, height));
        this.setSize(width, height);
        this.repaint();
    }

    public void zoomIn() {
    }

    public void zoomOut() {
    }

    public void setPanelSize(int width, int height, float rate) {
        this.rate = rate;
        this.setSize(width, height);
        this.setPreferredSize(new Dimension(width, height));
        this.repaint();
    }

    public void setPanelSize(int width, int height) {
        this.setSize(width, height);
        this.setPreferredSize(new Dimension(width, height));
        this.repaint();
    }

    public void increaseRATE() {
        this.rate += this.RATE_STEP;
    }

    public void decreaseRATE() {
        this.rate -= this.RATE_STEP;
    }

    public float getRATE() {
        return this.rate;
    }

    public void setIsLengthRatio(boolean isLengthRate) {
        this.isLengthRate = isLengthRate;
    }

    private void initComponents() {
        this.setBackground(new Color(255, 255, 255));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                CanvasPanel.this.formMousePressed(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                CanvasPanel.this.formMouseReleased(evt);
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent evt) {
                CanvasPanel.this.formMouseDragged(evt);
            }

            @Override
            public void mouseMoved(MouseEvent evt) {
                CanvasPanel.this.formMouseMoved(evt);
            }
        });
        this.setLayout(new BorderLayout());
    }

    public void adjustSelectProteinXY() {
        if (this.selectProtein.size() > 0) {
            for (int i = 0; i < this.selectProtein.size(); ++i) {
                Protein protein = this.selectProtein.get(i);
                Point2D.Double pd = this.preDragProteinVH.get(i);
                double intervalX = this.dEndPrevDrag.x - this.dStartPrevDrag.x;
                double intervalY = this.dEndPrevDrag.y - this.dStartPrevDrag.y;
                int vertical = (int)pd.y - (int)intervalY;
                int horizontal = (int)pd.x + (int)intervalX;
                protein.setVertical(vertical);
                protein.setLocked(false);
                protein.setHorizontal(horizontal);
            }
        }
    }

    private void formMouseDragged(MouseEvent evt) {
        if (!this.bCanClickContrl) {
            return;
        }
        int x = evt.getX() - this.getWidth() / 2;
        int y = evt.getY() - this.getHeight() / 2;
        double lengthRate = 600.0 / (double)this.maxLength;
        if (this.bSelected) {
            if (this.selectProtein.size() <= 0) {
                this.dEndSelect = new Point2D.Double(x, y);
            } else {
                this.dEndPrevDrag = new Point2D.Double(x, y);
                this.adjustSelectProteinXY();
            }
            this.repaint();
            return;
        }
        if (this.ProteinSelect != null && this.ComponentSelect == null) {
            int vertical = (int)((float)(-y) / this.rate);
            int horizontal = (int)((double)((float)x / this.rate) + (300.0 - (double)this.ProteinSelect.getEnd() * lengthRate / 2.0));
            this.ProteinSelect.setVertical(vertical);
            if (!this.ProteinSelect.isLocked()) {
                this.ProteinSelect.setHorizontal(horizontal);
            }
            this.currentVertical = vertical;
            this.repaint();
            this.isDrag = true;
            return;
        }
        block0: for (int i = 0; i < this.proteinList.size(); ++i) {
            Protein protein = this.proteinList.get(i);
            if (!this.isLengthRate) {
                lengthRate = 600.0 / (double)protein.getEnd();
            }
            if (!protein.isActive()) {
                LinkedList<Component> componentList = protein.getComponentList();
                for (Component component : componentList) {
                    int intevaly;
                    if (component != this.ComponentSelect) continue;
                    if (component.getType() == ComponentEnum.Site) {
                        if (component.bControlArea1Selected) {
                            if (component.dStartPrevDrag == null) {
                                component.dStartPrevDrag = new Point2D.Double((int)(((double)x + (300.0 - (double)protein.getHorizontal()) * (double)this.rate) / lengthRate / (double)this.rate), y);
                                this.isDrag = true;
                                continue block0;
                            }
                            component.dEndPrevDrag = new Point2D.Double((int)(((double)x + (300.0 - (double)protein.getHorizontal()) * (double)this.rate) / lengthRate / (double)this.rate), y);
                            int intevalx = 0;
                            intevaly = 0;
                            intevalx = (int)(component.dEndPrevDrag.x - component.dStartPrevDrag.x);
                            if (component.sp.size() > 0) {
                                SitePosition sp1;
                                int t;
                                int idrag = 0;
                                String strSite = "";
                                for (t = 0; t < component.sp.size(); ++t) {
                                    sp1 = component.sp.get(t);
                                    if (component.ichoosesite == sp1.sitePos) {
                                        if (sp1.sitePos + intevalx < 1 || sp1.sitePos + intevalx > protein.getEnd()) break;
                                        sp1.sitePos += intevalx;
                                        component.ichoosesite = sp1.sitePos;
                                        ++idrag;
                                    }
                                    component.sp.set(t, sp1);
                                }
                                if (idrag > 0) {
                                    for (t = 0; t < component.sp.size(); ++t) {
                                        sp1 = component.sp.get(t);
                                        strSite = t < component.sp.size() - 1 ? strSite + sp1.sitePos + ";" : strSite + sp1.sitePos;
                                    }
                                    String[] arr = component.getParameter().split("#&%");
                                    String arrnew = strSite;
                                    for (int l = 1; l < 7; ++l) {
                                        arrnew = arrnew + "#&%" + arr[l];
                                    }
                                    component.parameter = arrnew;
                                }
                            }
                            component.dStartPrevDrag = new Point2D.Double((int)(((double)x + (300.0 - (double)protein.getHorizontal()) * (double)this.rate) / lengthRate / (double)this.rate), y);
                            this.isDrag = true;
                            continue block0;
                        }
                        if (component.bAnchor1Selected || component.bAnchor2Selected || component.bAnchor3Selected || component.bAnchor4Selected) {
                            int k = 0;
                            if (component.bAnchor1Selected) {
                                k = 0;
                            }
                            if (component.bAnchor2Selected) {
                                k = 1;
                            }
                            if (component.bAnchor3Selected) {
                                k = 2;
                            }
                            if (component.bAnchor4Selected) {
                                k = 3;
                            }
                            this.dragVertex(protein, component, x, y, k);
                            continue block0;
                        }
                        if (component.bAnchorE1Selected || component.bAnchorE2Selected || component.bAnchorE3Selected || component.bAnchorE4Selected) {
                            int k = 0;
                            if (component.bAnchorE1Selected) {
                                k = 0;
                            }
                            if (component.bAnchorE2Selected) {
                                k = 1;
                            }
                            if (component.bAnchorE3Selected) {
                                k = 2;
                            }
                            if (component.bAnchorE4Selected) {
                                k = 3;
                            }
                            this.dragEdge(protein, component, x, y, k);
                            continue block0;
                        }
                        if (component.bAnchorRotateSelected) {
                            this.dragToRotate(protein, component, x, y);
                            continue block0;
                        }
                        component.setCenterx((int)(((double)x + (300.0 - (double)protein.getHorizontal()) * (double)this.rate) / lengthRate / (double)this.rate));
                        component.setCentery((int)((float)(-protein.getVertical()) - (float)y / this.rate));
                        this.isDrag = true;
                        continue block0;
                    }
                    if (component.getType() == ComponentEnum.Bracket) {
                        if (component.bStartArea1Selected) {
                            component.dEndPrevDrag = new Point2D.Double((int)(((double)x + (300.0 - (double)protein.getHorizontal()) * (double)this.rate) / lengthRate / (double)this.rate), y);
                            int intevalx = 0;
                            intevaly = 0;
                            intevalx = component.startArea.getX1() <= component.endArea.getX1() ? (component.dEndPrevDrag.x >= component.dStartPrevDrag.x ? -1 * (int)(component.dEndPrevDrag.x - component.dStartPrevDrag.x) + (int)component.getWide() : (int)(component.dStartPrevDrag.x - component.dEndPrevDrag.x) + (int)component.getWide()) : (component.dEndPrevDrag.x >= component.dStartPrevDrag.x ? (int)(component.dEndPrevDrag.x - component.dStartPrevDrag.x) + (int)component.getWide() : -1 * (int)(component.dStartPrevDrag.x - component.dEndPrevDrag.x) + (int)component.getWide());
                            component.dStartPrevDrag = new Point2D.Double((int)(((double)x + (300.0 - (double)protein.getHorizontal()) * (double)this.rate) / lengthRate / (double)this.rate), y);
                            this.isDrag = true;
                            if (intevalx < 1) continue block0;
                            component.setWide(intevalx);
                            continue block0;
                        }
                        if (component.bEndArea2Selected) {
                            this.isDrag = true;
                            this.dragToRotate(protein, component, x, y);
                            continue block0;
                        }
                        component.setCenterx((int)(((double)x + (300.0 - (double)protein.getHorizontal()) * (double)this.rate) / lengthRate / (double)this.rate));
                        component.setCentery((int)((float)(-protein.getVertical()) - (float)y / this.rate));
                        this.isDrag = true;
                        continue block0;
                    }
                    if (component.getType() == ComponentEnum.Polygon) {
                        if (component.bAnchor1Selected || component.bAnchor2Selected || component.bAnchor3Selected || component.bAnchor4Selected) {
                            int k = 0;
                            if (component.bAnchor1Selected) {
                                k = 0;
                            }
                            if (component.bAnchor2Selected) {
                                k = 1;
                            }
                            if (component.bAnchor3Selected) {
                                k = 2;
                            }
                            if (component.bAnchor4Selected) {
                                k = 3;
                            }
                            this.dragVertex(protein, component, x, y, k);
                            continue block0;
                        }
                        if (component.bAnchorE1Selected || component.bAnchorE2Selected || component.bAnchorE3Selected || component.bAnchorE4Selected) {
                            int k = 0;
                            if (component.bAnchorE1Selected) {
                                k = 0;
                            }
                            if (component.bAnchorE2Selected) {
                                k = 1;
                            }
                            if (component.bAnchorE3Selected) {
                                k = 2;
                            }
                            if (component.bAnchorE4Selected) {
                                k = 3;
                            }
                            this.dragEdge(protein, component, x, y, k);
                            continue block0;
                        }
                        if (component.bAnchorRotateSelected) {
                            this.dragToRotate(protein, component, x, y);
                            continue block0;
                        }
                        component.setCenterx((int)(((double)x + (300.0 - (double)protein.getHorizontal()) * (double)this.rate) / lengthRate / (double)this.rate));
                        component.setCentery((int)((float)(-protein.getVertical()) - (float)y / this.rate));
                        this.isDrag = true;
                        continue block0;
                    }
                    if (component.getType() == ComponentEnum.Note) {
                        if (component.bAnchor1Selected || component.bAnchor2Selected || component.bAnchor3Selected || component.bAnchor4Selected || component.bAnchorE1Selected || component.bAnchorE2Selected || component.bAnchorE3Selected || component.bAnchorE4Selected) continue block0;
                        if (component.bAnchorRotateSelected) {
                            this.dragNoteToRotate(protein, component, x, y);
                            continue block0;
                        }
                        component.setX((int)(((double)x + (300.0 - (double)protein.getHorizontal()) * (double)this.rate) / lengthRate / (double)this.rate));
                        component.setY((int)((float)(-protein.getVertical()) - (float)y / this.rate));
                        this.isDrag = true;
                        continue block0;
                    }
                    if (component.getType() == ComponentEnum.Bracket) {
                        if (component.bStartArea1Selected) {
                            component.dEndPrevDrag = new Point2D.Double((int)(((double)x + (300.0 - (double)protein.getHorizontal()) * (double)this.rate) / lengthRate / (double)this.rate), y);
                            int intevalx = 0;
                            intevaly = 0;
                            intevalx = component.startArea.getX1() <= component.endArea.getX1() ? (component.dEndPrevDrag.x >= component.dStartPrevDrag.x ? -1 * (int)(component.dEndPrevDrag.x - component.dStartPrevDrag.x) + (int)component.getWide() : (int)(component.dStartPrevDrag.x - component.dEndPrevDrag.x) + (int)component.getWide()) : (component.dEndPrevDrag.x >= component.dStartPrevDrag.x ? (int)(component.dEndPrevDrag.x - component.dStartPrevDrag.x) + (int)component.getWide() : -1 * (int)(component.dStartPrevDrag.x - component.dEndPrevDrag.x) + (int)component.getWide());
                            component.dStartPrevDrag = new Point2D.Double((int)(((double)x + (300.0 - (double)protein.getHorizontal()) * (double)this.rate) / lengthRate / (double)this.rate), y);
                            this.isDrag = true;
                            if (intevalx < 1) continue block0;
                            component.setWide(intevalx);
                            continue block0;
                        }
                        if (component.bEndArea2Selected) {
                            double angleend = 0.0;
                            double anglestart = 0.0;
                            double angledis = 0.0;
                            component.dEndRotateDrag = new Point2D.Double((int)(((double)x + (300.0 - (double)protein.getHorizontal()) * (double)this.rate) / lengthRate / (double)this.rate), y);
                            double dx = (int)((-300.0 + (double)protein.getHorizontal() + component.dEndRotateDrag.x * this.LENGTH_RATE) * (double)this.rate);
                            double dy = 1.0 * component.dEndRotateDrag.y / (double)this.rate;
                            int startx = 0;
                            boolean starty = false;
                            int endx = 0;
                            boolean endy = false;
                            int startX = 0;
                            int startY = 0;
                            int endX = 0;
                            int endY = 0;
                            int centerX = 0;
                            int centerY = 0;
                            startx = (int)component.getCenterx() - (int)component.getWide();
                            endx = (int)component.getCenterx() + (int)component.getWide();
                            startX = (int)((-300.0 + (double)protein.getHorizontal() + (double)startx * this.LENGTH_RATE) * (double)this.rate);
                            endX = (int)((-300.0 + (double)protein.getHorizontal() + (double)endx * this.LENGTH_RATE) * (double)this.rate);
                            startY = (int)(((double)(-protein.getVertical()) - component.getCentery() - component.getHigh()) * (double)this.rate);
                            endY = (int)(((double)(-protein.getVertical()) - component.getCentery() + component.getHigh()) * (double)this.rate);
                            centerX = startX + (endX - startX) / 2;
                            centerY = startY + (endY - startY) / 2;
                            angleend = this.getAngleFromXY(dx, dy, centerX, centerY);
                            component.setRotationAngle((int)(angleend * 360.0 / (Math.PI * 2)));
                            this.isDrag = true;
                            continue block0;
                        }
                        component.setCenterx((int)(((double)x + (300.0 - (double)protein.getHorizontal()) * (double)this.rate) / lengthRate / (double)this.rate));
                        component.setCentery((int)((float)(-protein.getVertical()) - (float)y / this.rate));
                        this.isDrag = true;
                        continue block0;
                    }
                    if (component.getType() == ComponentEnum.Domain) {
                        if (component.bAnchor1Selected || component.bAnchor2Selected || component.bAnchor3Selected || component.bAnchor4Selected) {
                            int k = 0;
                            if (component.bAnchor1Selected) {
                                k = 0;
                            }
                            if (component.bAnchor2Selected) {
                                k = 1;
                            }
                            if (component.bAnchor3Selected) {
                                k = 2;
                            }
                            if (component.bAnchor4Selected) {
                                k = 3;
                            }
                            this.dragDomainVertex(protein, component, x, y, k);
                            continue block0;
                        }
                        if (component.bAnchorE1Selected || component.bAnchorE2Selected || component.bAnchorE3Selected || component.bAnchorE4Selected) {
                            int k = 0;
                            if (component.bAnchorE1Selected) {
                                k = 0;
                                return;
                            }
                            if (component.bAnchorE2Selected) {
                                k = 1;
                            }
                            if (component.bAnchorE3Selected) {
                                k = 2;
                                return;
                            }
                            if (component.bAnchorE4Selected) {
                                k = 3;
                            }
                            this.dragDomainEdge(protein, component, x, y, k);
                            continue block0;
                        }
                        if (component.bAnchorRotateSelected) {
                            this.dragToRotateDomain(protein, component, x, y);
                            continue block0;
                        }
                        component.dEndPrevDrag = new Point2D.Double((int)(((double)x + (300.0 - (double)protein.getHorizontal()) * (double)this.rate) / lengthRate / (double)this.rate), y);
                        int intevalx = 0;
                        intevaly = 0;
                        intevalx = (int)(component.dEndPrevDrag.x - component.dStartPrevDrag.x);
                        if (component.getX() + (double)intevalx < 1.0 || component.getX2() + (double)intevalx > (double)protein.getEnd()) continue block0;
                        component.setX(component.getX() + (double)intevalx);
                        component.setX2(component.getX2() + (double)intevalx);
                        component.dStartPrevDrag = new Point2D.Double((int)(((double)x + (300.0 - (double)protein.getHorizontal()) * (double)this.rate) / lengthRate / (double)this.rate), y);
                        this.isDrag = true;
                        continue block0;
                    }
                    if (component.getType() == ComponentEnum.CutLine) {
                        component.dEndPrevDrag = new Point2D.Double((int)(((double)x + (300.0 - (double)protein.getHorizontal()) * (double)this.rate) / lengthRate / (double)this.rate), y);
                        int intevalx = 0;
                        intevaly = 0;
                        intevalx = (int)(component.dEndPrevDrag.x - component.dStartPrevDrag.x);
                        if (component.getX() + (double)intevalx < 1.0 || component.getX2() + (double)intevalx > (double)protein.getEnd()) continue block0;
                        component.x = component.getX() + (double)intevalx;
                        component.y = component.getY() + intevalx;
                        component.x2 = component.getX2() + (double)intevalx;
                        component.dStartPrevDrag = new Point2D.Double((int)(((double)x + (300.0 - (double)protein.getHorizontal()) * (double)this.rate) / lengthRate / (double)this.rate), y);
                        this.isDrag = true;
                        continue block0;
                    }
                    if (component.getType() != ComponentEnum.Line) continue;
                    if (component.bControlArea1Selected) {
                        component.setControlx1((int)(((double)x + (300.0 - (double)protein.getHorizontal()) * (double)this.rate) / lengthRate / (double)this.rate));
                        component.setControly1((int)((float)(-protein.getVertical()) - (float)y / this.rate));
                        this.isDrag = true;
                        continue block0;
                    }
                    if (component.bControlArea2Selected) {
                        component.setControlx2((int)(((double)x + (300.0 - (double)protein.getHorizontal()) * (double)this.rate) / lengthRate / (double)this.rate));
                        component.setControly2((int)((float)(-protein.getVertical()) - (float)y / this.rate));
                        this.isDrag = true;
                        continue block0;
                    }
                    if (component.bStartArea1Selected) {
                        component.setX((int)(((double)x + (300.0 - (double)protein.getHorizontal()) * (double)this.rate) / lengthRate / (double)this.rate));
                        component.setY((int)((float)(-protein.getVertical()) - (float)y / this.rate));
                        this.isDrag = true;
                        continue block0;
                    }
                    if (component.bEndArea2Selected) {
                        component.setX2((int)(((double)x + (300.0 - (double)protein.getHorizontal()) * (double)this.rate) / lengthRate / (double)this.rate));
                        component.setY2((int)((float)(-protein.getVertical()) - (float)y / this.rate));
                        this.isDrag = true;
                        continue block0;
                    }
                    component.dEndPrevDrag = new Point2D.Double((int)(((double)x + (300.0 - (double)protein.getHorizontal()) * (double)this.rate) / lengthRate / (double)this.rate), y);
                    int intevalx = 0;
                    intevaly = 0;
                    intevalx = (int)(component.dEndPrevDrag.x - component.dStartPrevDrag.x);
                    intevaly = (int)(-component.dEndPrevDrag.y / (double)this.rate + component.dStartPrevDrag.y / (double)this.rate);
                    component.setX(component.getX() + (double)intevalx);
                    component.setX2(component.getX2() + (double)intevalx);
                    component.setY(component.getY() + intevaly);
                    component.setY2(component.getY2() + intevaly);
                    component.setControlx1(component.getControlx1() + intevalx);
                    component.setControlx2(component.getControlx2() + intevalx);
                    component.setControly1(component.getControly1() + intevaly);
                    component.setControly2(component.getControly2() + intevaly);
                    component.dStartPrevDrag = new Point2D.Double((int)(((double)x + (300.0 - (double)protein.getHorizontal()) * (double)this.rate) / lengthRate / (double)this.rate), y);
                    this.isDrag = true;
                    continue block0;
                }
                continue;
            }
            int vertical = (int)((float)(-y) / this.rate);
            int horizontal = (int)((double)((float)x / this.rate) + (300.0 - (double)protein.getEnd() * lengthRate / 2.0));
            protein.setVertical(vertical);
            if (!protein.isLocked()) {
                protein.setHorizontal(horizontal);
            }
            this.currentVertical = vertical;
            this.isDrag = true;
            break;
        }
        this.repaint();
    }

    private void formMousePressed(MouseEvent evt) {
        boolean bSelectAnchor;
        Component component;
        int k;
        LinkedList<Component> componentList;
        Protein protein;
        int i;
        if (!this.bCanClickContrl) {
            return;
        }
        int x = evt.getX() - this.getWidth() / 2;
        int y = evt.getY() - this.getHeight() / 2;
        int ihascomselect = 0;
        for (i = 0; i < this.proteinList.size(); ++i) {
            protein = this.proteinList.get(i);
            protein.setIsActive(false);
            componentList = protein.getComponentList();
            for (k = 0; k < componentList.size(); ++k) {
                component = componentList.get(k);
                if (component.isbSelected() && (bSelectAnchor = this.isSelectAnchorPoint(protein, component, x, y))) {
                    return;
                }
                component.setIsActive(false);
                component.bSelected = false;
                component.dStartPrevDrag = null;
                component.dEndPrevDrag = null;
                component.dStartComDrag = null;
                component.dEndComDrag = null;
                component.dStartRotateDrag = null;
                component.dEndRotateDrag = null;
            }
        }
        this.ComponentSelect = null;
        this.ProteinSelect = null;
        block2: for (i = this.proteinList.size() - 1; i >= 0; --i) {
            protein = this.proteinList.get(i);
            componentList = protein.getComponentList();
            for (k = componentList.size() - 1; k >= 0; --k) {
                component = componentList.get(k);
                if (component.getType() == ComponentEnum.Domain && component.GeomArea.contains(x, y)) {
                    component.setIsActive(true);
                    component.bSelected = true;
                    this.ComponentSelect = component;
                    component.dStartPrevDrag = new Point2D.Double((int)(((double)x + (300.0 - (double)protein.getHorizontal()) * (double)this.rate) / this.LENGTH_RATE / (double)this.rate), y);
                    component.dStartComDrag = new Point2D.Double(x, y);
                    ++ihascomselect;
                    continue block2;
                }
                if (component.getType() == ComponentEnum.CutLine) {
                    if (!component.GeomArea.contains(x, y)) continue;
                    component.setIsActive(true);
                    component.bSelected = true;
                    this.ComponentSelect = component;
                    component.dStartPrevDrag = new Point2D.Double((int)(((double)x + (300.0 - (double)protein.getHorizontal()) * (double)this.rate) / this.LENGTH_RATE / (double)this.rate), y);
                    component.dStartComDrag = new Point2D.Double(x, y);
                    ++ihascomselect;
                    continue block2;
                }
                if (component.getType() == ComponentEnum.Mark) {
                    String[] arr = component.getParameter().split("#&%");
                    if (component.getArea().isMarkAdjustInside(x, y) && arr[1].equals("Wide")) {
                        component.setIsActive(true);
                        this.ComponentSelect = component;
                        ++ihascomselect;
                        continue block2;
                    }
                    if (!component.getArea().isMarkInside(x, y)) continue;
                    component.setIsActive(true);
                    this.ComponentSelect = component;
                    ++ihascomselect;
                    continue block2;
                }
                if (component.getType() == ComponentEnum.Line) {
                    if (!component.GeomArea.contains(x, y)) continue;
                    component.setIsActive(true);
                    component.bSelected = true;
                    this.ComponentSelect = component;
                    component.dStartPrevDrag = new Point2D.Double((int)(((double)x + (300.0 - (double)protein.getHorizontal()) * (double)this.rate) / this.LENGTH_RATE / (double)this.rate), y);
                    bSelectAnchor = this.isSelectAnchorPoint(protein, component, x, y);
                    ++ihascomselect;
                    continue block2;
                }
                if (component.getType() == ComponentEnum.Site) {
                    component.ichoosesite = -1;
                    component.bControlArea1Selected = false;
                    if (component.sp.size() > 0) {
                        for (int d = 0; d < component.sp.size(); ++d) {
                            SitePosition sp1 = component.sp.get(d);
                            if (!sp1.rec.contains(x, y)) continue;
                            component.ichoosesite = sp1.sitePos;
                            component.bControlArea1Selected = true;
                            component.bSelected = true;
                            this.ComponentSelect = component;
                            component.dStartPrevDrag = new Point2D.Double((int)(((double)x + (300.0 - (double)protein.getHorizontal()) * (double)this.rate) / this.LENGTH_RATE / (double)this.rate), y);
                            component.dStartComDrag = new Point2D.Double(x, y);
                            component.dStartRotateDrag = new Point2D.Double(x, y);
                            component.setIsActive(true);
                            ++ihascomselect;
                            this.repaint();
                            return;
                        }
                    }
                }
                if (component.GeomArea != null) {
                    if (!component.GeomArea.contains(x, y)) continue;
                    component.bSelected = true;
                    this.ComponentSelect = component;
                    component.dStartPrevDrag = new Point2D.Double((int)(((double)x + (300.0 - (double)protein.getHorizontal()) * (double)this.rate) / this.LENGTH_RATE / (double)this.rate), y);
                    component.dStartComDrag = new Point2D.Double(x, y);
                    component.dStartRotateDrag = new Point2D.Double(x, y);
                    component.setIsActive(true);
                    ++ihascomselect;
                    continue block2;
                }
                if (component.getArea() == null || !component.getArea().isInside(x, y)) continue;
                component.bSelected = true;
                this.ComponentSelect = component;
                component.dStartPrevDrag = new Point2D.Double((int)(((double)x + (300.0 - (double)protein.getHorizontal()) * (double)this.rate) / this.LENGTH_RATE / (double)this.rate), y);
                component.dStartComDrag = new Point2D.Double(x, y);
                component.dStartRotateDrag = new Point2D.Double(x, y);
                component.setIsActive(true);
                ++ihascomselect;
                continue block2;
            }
        }
        if (ihascomselect <= 0) {
            for (i = this.proteinList.size() - 1; i >= 0; --i) {
                protein = this.proteinList.get(i);
                if (!protein.getArea().isInside(x, y)) continue;
                protein.setIsActive(true);
                this.ProteinSelect = protein;
                break;
            }
        }
        if (this.bSelected) {
            if (this.dStartSelect != null && this.dEndSelect != null) {
                if (!((double)x >= this.dStartSelect.x && (double)y >= this.dStartSelect.y && (double)x <= this.dEndSelect.x && (double)y <= this.dEndSelect.y)) {
                    this.bSelected = false;
                    this.dStartSelect = null;
                    this.dEndSelect = null;
                    this.selectProtein.clear();
                } else if (this.dStartPrevDrag == null) {
                    this.dStartPrevDrag = new Point2D.Double(x, y);
                    this.preDragProteinVH.clear();
                    for (int k2 = 0; k2 < this.selectProtein.size(); ++k2) {
                        Protein pt = this.selectProtein.get(k2);
                        Point2D.Double pd = new Point2D.Double(pt.getHorizontal(), pt.getVertical());
                        this.preDragProteinVH.add(pd);
                    }
                }
            } else {
                this.dStartSelect = new Point2D.Double(x, y);
                this.selectProtein.clear();
            }
        }
        this.repaint();
    }

    public void clearComponentActiveState() {
        for (int i = 0; i < this.proteinList.size(); ++i) {
            Protein protein = this.proteinList.get(i);
            LinkedList<Component> componentList = protein.getComponentList();
            for (int k = 0; k < componentList.size(); ++k) {
                Component component = componentList.get(k);
                component.setIsActive(false);
                component.bSelected = false;
                component.dStartPrevDrag = null;
                component.dEndPrevDrag = null;
                component.dStartRotateDrag = null;
                component.dEndRotateDrag = null;
            }
        }
        this.ComponentSelect = null;
        this.ProteinSelect = null;
    }

    private void formMouseReleased(MouseEvent evt) {
        if (!this.bCanClickContrl) {
            return;
        }
        if (this.bSelected) {
            Protein protein;
            int i;
            if (this.selectProtein.size() > 0) {
                for (i = 0; i < this.proteinList.size(); ++i) {
                    protein = this.proteinList.get(i);
                }
                this.selectProtein.clear();
                this.dStartPrevDrag = null;
                this.dEndPrevDrag = null;
                this.preDragProteinVH.clear();
            }
            for (i = 0; i < this.proteinList.size(); ++i) {
                protein = this.proteinList.get(i);
                String[] arrPro = protein.getParameter().split("#&%");
                int proteinStart = Integer.parseInt(arrPro[0]);
                int proteinEnd = Integer.parseInt(arrPro[2]);
                double startX = -300.0 + (double)protein.getHorizontal() + (double)proteinStart * this.LENGTH_RATE;
                double endX = -300.0 + (double)protein.getHorizontal() + (double)proteinEnd * this.LENGTH_RATE;
                double vertical = -1 * protein.getVertical();
                if (!(vertical >= this.dStartSelect.y) || !(vertical <= this.dEndSelect.y) || !(startX >= this.dStartSelect.x) || !(endX <= this.dEndSelect.x)) continue;
                this.selectProtein.add(protein);
            }
        }
        if (this.ComponentSelect != null) {
            this.ComponentSelect.dEndPrevDrag = null;
            this.ComponentSelect.dStartPrevDrag = null;
            this.ComponentSelect.dEndRotateDrag = null;
            this.ComponentSelect.dStartRotateDrag = null;
        }
        this.repaint();
        if (this.isDrag && this.df != null) {
            try {
                this.saveCurrentState();
            }
            catch (CloneNotSupportedException ex) {
                ex.printStackTrace();
            }
        }
        this.isDrag = false;
    }

    private void formMouseMoved(MouseEvent evt) {
        if (!this.bCanClickContrl) {
            return;
        }
        int x = evt.getX() - this.getWidth() / 2;
        int y = evt.getY() - this.getHeight() / 2;
        boolean icon = false;
        block0: for (int i = 0; i < this.proteinList.size(); ++i) {
            Protein protein = this.proteinList.get(i);
            LinkedList<Component> componentList = protein.getComponentList();
            for (Component component : componentList) {
                if (component.getType() != ComponentEnum.Line || component.GeomArea == null || !component.GeomArea.contains(x, y)) continue;
                icon = true;
                continue block0;
            }
        }
        Cursor curorig = Cursor.getDefaultCursor();
        if (icon) {
            this.setCursor(new Cursor(12));
        } else {
            this.setCursor(curorig);
        }
    }

    public boolean isSelectAnchorPoint(Protein protein, Component component, int x, int y) {
        if (component.bSelected) {
            int iselectcontrol = 0;
            if (component.ControlArea1 != null) {
                if (component.ControlArea1.isInside(x, y)) {
                    component.bControlArea1Selected = true;
                    component.dStartPrevDrag = new Point2D.Double((int)(((double)x + (300.0 - (double)protein.getHorizontal()) * (double)this.rate) / this.LENGTH_RATE / (double)this.rate), y);
                    component.dStartComDrag = new Point2D.Double(x, y);
                    ++iselectcontrol;
                } else {
                    component.bControlArea1Selected = false;
                }
            } else {
                component.bControlArea1Selected = false;
            }
            if (component.ControlArea2 != null) {
                if (component.ControlArea2.isInside(x, y)) {
                    component.bControlArea2Selected = true;
                    component.dStartPrevDrag = new Point2D.Double((int)(((double)x + (300.0 - (double)protein.getHorizontal()) * (double)this.rate) / this.LENGTH_RATE / (double)this.rate), y);
                    component.dStartComDrag = new Point2D.Double(x, y);
                    ++iselectcontrol;
                } else {
                    component.bControlArea2Selected = false;
                }
            } else {
                component.bControlArea2Selected = false;
            }
            if (component.startArea != null) {
                if (component.startArea.isInside(x, y)) {
                    component.bStartArea1Selected = true;
                    component.dStartPrevDrag = new Point2D.Double((int)(((double)x + (300.0 - (double)protein.getHorizontal()) * (double)this.rate) / this.LENGTH_RATE / (double)this.rate), y);
                    component.dStartRotateDrag = new Point2D.Double((int)(((double)x + (300.0 - (double)protein.getHorizontal()) * (double)this.rate) / this.LENGTH_RATE / (double)this.rate), y);
                    component.dStartComDrag = new Point2D.Double(x, y);
                    ++iselectcontrol;
                } else {
                    component.bStartArea1Selected = false;
                }
            } else {
                component.bStartArea1Selected = false;
            }
            if (component.endArea != null) {
                if (component.endArea.isInside(x, y)) {
                    component.bEndArea2Selected = true;
                    component.dStartPrevDrag = new Point2D.Double((int)(((double)x + (300.0 - (double)protein.getHorizontal()) * (double)this.rate) / this.LENGTH_RATE / (double)this.rate), y);
                    component.dStartComDrag = new Point2D.Double(x, y);
                    component.dStartRotateDrag = new Point2D.Double(x, y);
                    ++iselectcontrol;
                } else {
                    component.bEndArea2Selected = false;
                }
            } else {
                component.bEndArea2Selected = false;
            }
            if (component.GeomAnchor1 != null) {
                if (component.GeomAnchor1.contains(x, y)) {
                    component.bAnchor1Selected = true;
                    component.dStartPrevDrag = new Point2D.Double((int)(((double)x + (300.0 - (double)protein.getHorizontal()) * (double)this.rate) / this.LENGTH_RATE / (double)this.rate), y);
                    component.dStartComDrag = new Point2D.Double(x, y);
                    ++iselectcontrol;
                } else {
                    component.bAnchor1Selected = false;
                }
            } else {
                component.bAnchor1Selected = false;
            }
            if (component.GeomAnchor2 != null) {
                if (component.GeomAnchor2.contains(x, y)) {
                    component.bAnchor2Selected = true;
                    component.dStartPrevDrag = new Point2D.Double((int)(((double)x + (300.0 - (double)protein.getHorizontal()) * (double)this.rate) / this.LENGTH_RATE / (double)this.rate), y);
                    component.dStartComDrag = new Point2D.Double(x, y);
                    ++iselectcontrol;
                } else {
                    component.bAnchor2Selected = false;
                }
            } else {
                component.bAnchor2Selected = false;
            }
            if (component.GeomAnchor3 != null) {
                if (component.GeomAnchor3.contains(x, y)) {
                    component.bAnchor3Selected = true;
                    component.dStartPrevDrag = new Point2D.Double((int)(((double)x + (300.0 - (double)protein.getHorizontal()) * (double)this.rate) / this.LENGTH_RATE / (double)this.rate), y);
                    component.dStartComDrag = new Point2D.Double(x, y);
                    ++iselectcontrol;
                } else {
                    component.bAnchor3Selected = false;
                }
            } else {
                component.bAnchor3Selected = false;
            }
            if (component.GeomAnchor4 != null) {
                if (component.GeomAnchor4.contains(x, y)) {
                    component.bAnchor4Selected = true;
                    component.dStartPrevDrag = new Point2D.Double((int)(((double)x + (300.0 - (double)protein.getHorizontal()) * (double)this.rate) / this.LENGTH_RATE / (double)this.rate), y);
                    component.dStartComDrag = new Point2D.Double(x, y);
                    ++iselectcontrol;
                } else {
                    component.bAnchor4Selected = false;
                }
            } else {
                component.bAnchor4Selected = false;
            }
            if (component.GeomAnchorE1 != null) {
                if (component.GeomAnchorE1.contains(x, y)) {
                    component.bAnchorE1Selected = true;
                    component.dStartPrevDrag = new Point2D.Double((int)(((double)x + (300.0 - (double)protein.getHorizontal()) * (double)this.rate) / this.LENGTH_RATE / (double)this.rate), y);
                    component.dStartComDrag = new Point2D.Double(x, y);
                    ++iselectcontrol;
                } else {
                    component.bAnchorE1Selected = false;
                }
            } else {
                component.bAnchorE1Selected = false;
            }
            if (component.GeomAnchorE2 != null) {
                if (component.GeomAnchorE2.contains(x, y)) {
                    component.bAnchorE2Selected = true;
                    component.dStartPrevDrag = new Point2D.Double((int)(((double)x + (300.0 - (double)protein.getHorizontal()) * (double)this.rate) / this.LENGTH_RATE / (double)this.rate), y);
                    component.dStartComDrag = new Point2D.Double(x, y);
                    ++iselectcontrol;
                } else {
                    component.bAnchorE2Selected = false;
                }
            } else {
                component.bAnchorE2Selected = false;
            }
            if (component.GeomAnchorE3 != null) {
                if (component.GeomAnchorE3.contains(x, y)) {
                    component.bAnchorE3Selected = true;
                    component.dStartPrevDrag = new Point2D.Double((int)(((double)x + (300.0 - (double)protein.getHorizontal()) * (double)this.rate) / this.LENGTH_RATE / (double)this.rate), y);
                    component.dStartComDrag = new Point2D.Double(x, y);
                    ++iselectcontrol;
                } else {
                    component.bAnchorE3Selected = false;
                }
            } else {
                component.bAnchorE3Selected = false;
            }
            if (component.GeomAnchorE4 != null) {
                if (component.GeomAnchorE4.contains(x, y)) {
                    component.bAnchorE4Selected = true;
                    component.dStartPrevDrag = new Point2D.Double((int)(((double)x + (300.0 - (double)protein.getHorizontal()) * (double)this.rate) / this.LENGTH_RATE / (double)this.rate), y);
                    component.dStartComDrag = new Point2D.Double(x, y);
                    ++iselectcontrol;
                } else {
                    component.bAnchorE4Selected = false;
                }
            } else {
                component.bAnchorE4Selected = false;
            }
            if (component.GeomAnchorRotate != null) {
                if (component.GeomAnchorRotate.contains(x, y)) {
                    component.bAnchorRotateSelected = true;
                    component.dStartPrevDrag = new Point2D.Double((int)(((double)x + (300.0 - (double)protein.getHorizontal()) * (double)this.rate) / this.LENGTH_RATE / (double)this.rate), y);
                    component.dStartRotateDrag = new Point2D.Double((int)(((double)x + (300.0 - (double)protein.getHorizontal()) * (double)this.rate) / this.LENGTH_RATE / (double)this.rate), y);
                    component.dStartComDrag = new Point2D.Double(x, y);
                    ++iselectcontrol;
                } else {
                    component.bAnchorRotateSelected = false;
                }
            } else {
                component.bAnchorRotateSelected = false;
            }
            return iselectcontrol != 0;
        }
        return false;
    }

    public void dragDomainVertex(Protein protein, Component component, int x, int y, int k) {
        component.dEndComDrag = new Point2D.Double(x, y);
        double dx = 0.0;
        double dy = 0.0;
        dx = component.dEndComDrag.x - component.dStartComDrag.x;
        dy = component.dEndComDrag.y - component.dStartComDrag.y;
        component.pgxy.getTransCenterPoint();
        component.pgxy.dragOneAToGetWH(k, (int)dx, (int)dy);
        double fstartx = 0.0;
        double fstarty = 0.0;
        double fendx = 0.0;
        double fendy = 0.0;
        fstartx = component.pgxy.centerx - component.pgxy.iwide;
        fendx = component.pgxy.centerx + component.pgxy.iwide;
        fstarty = component.pgxy.centery - component.pgxy.ihigh;
        fendy = component.pgxy.centery + component.pgxy.ihigh;
        fstartx = (fstartx / (double)this.rate + 300.0 - (double)protein.getHorizontal()) / this.LENGTH_RATE;
        fendx = (fendx / (double)this.rate + 300.0 - (double)protein.getHorizontal()) / this.LENGTH_RATE;
        double centerx = Math.round((component.pgxy.centerx / (double)this.rate + 300.0 - (double)protein.getHorizontal()) / this.LENGTH_RATE);
        double iwide = 0.0;
        double ihigh = 0.0;
        ihigh = Math.abs((double)(-protein.getVertical()) - fstarty / (double)this.rate) * 4.0 / (2.0 * this.LENGTH_RATE);
        iwide = Math.abs(fendx - fstartx) / 2.0;
        if (iwide <= 1.0) {
            iwide = 1.0;
        }
        if (ihigh <= 1.0) {
            ihigh = 1.0;
        }
        if ((component.getShapeType() == ShapeEnum.L_ParallelLine || component.getShapeType() == ShapeEnum.R_ParallelLine || component.getShapeType() == ShapeEnum.L_ParallelCurve || component.getShapeType() == ShapeEnum.R_ParallelCurve) && ihigh < 2.0 * iwide) {
            ihigh = 2.0 * iwide;
        }
        if (this.Mode.equals("P")) {
            ihigh = 0.0;
        }
        component.setHigh(ihigh);
        if (centerx - iwide < 1.0) {
            iwide = centerx - 1.0;
        }
        component.setX((int)(centerx - iwide));
        component.setX2((int)(centerx + iwide));
        component.setWide(iwide);
        component.dStartComDrag = new Point2D.Double(x, y);
        this.isDrag = true;
    }

    public void dragDomainEdge(Protein protein, Component component, int x, int y, int k) {
        component.dEndComDrag = new Point2D.Double(x, y);
        double dx = 0.0;
        double dy = 0.0;
        dx = component.dEndComDrag.x - component.dStartComDrag.x;
        dy = component.dEndComDrag.y - component.dStartComDrag.y;
        component.pgxy.getTransCenterPoint();
        component.pgxy.dragOneEToGetWH(k, (int)dx, (int)dy);
        double fstartx = 0.0;
        double fstarty = 0.0;
        double fendx = 0.0;
        double fendy = 0.0;
        fstartx = component.pgxy.centerx - component.pgxy.iwide;
        fendx = component.pgxy.centerx + component.pgxy.iwide;
        fstarty = component.pgxy.centery - component.pgxy.ihigh;
        fendy = component.pgxy.centery + component.pgxy.ihigh;
        double centerx = 0.0;
        fstartx = (fstartx / (double)this.rate + 300.0 - (double)protein.getHorizontal()) / this.LENGTH_RATE;
        fendx = (fendx / (double)this.rate + 300.0 - (double)protein.getHorizontal()) / this.LENGTH_RATE;
        centerx = Math.round((component.pgxy.centerx / (double)this.rate + 300.0 - (double)protein.getHorizontal()) / this.LENGTH_RATE);
        double iwide = 0.0;
        double ihigh = 0.0;
        iwide = Math.abs(fendx - fstartx) / 2.0;
        ihigh = Math.abs((double)(-protein.getVertical()) - fstarty / (double)this.rate) * 4.0 / (2.0 * this.LENGTH_RATE);
        if (iwide <= 1.0) {
            iwide = 1.0;
        }
        if (ihigh <= 1.0) {
            ihigh = 1.0;
        }
        if ((component.getShapeType() == ShapeEnum.L_ParallelLine || component.getShapeType() == ShapeEnum.R_ParallelLine || component.getShapeType() == ShapeEnum.L_ParallelCurve || component.getShapeType() == ShapeEnum.R_ParallelCurve) && ihigh < 2.0 * iwide) {
            ihigh = 2.0 * iwide;
        }
        component.setWide(iwide);
        if (this.Mode.equals("P")) {
            ihigh = 0.0;
        }
        component.setHigh(ihigh);
        if (centerx - iwide < 1.0) {
            iwide = centerx - 1.0;
        } else if (centerx + iwide > (double)protein.getEnd()) {
            iwide = (double)protein.getEnd() - centerx;
        }
        component.setX((int)(centerx - iwide));
        component.setX2((int)(centerx + iwide));
        component.dStartComDrag = new Point2D.Double(x, y);
        this.isDrag = true;
    }

    public void dragToRotateDomain(Protein protein, Component component, int x, int y) {
        double angleend = 0.0;
        double anglestart = 0.0;
        double angledis = 0.0;
        component.dEndRotateDrag = new Point2D.Double(x, y);
        double dx = component.dEndRotateDrag.x;
        double dy = component.dEndRotateDrag.y;
        double dxstart = component.dStartRotateDrag.x;
        double dystart = component.dStartRotateDrag.y;
        int centerX = 0;
        int centerY = 0;
        centerY = (int)((float)(-protein.getVertical()) * this.rate);
        centerX = (int)(((double)protein.getHorizontal() + (component.getX() + (component.getX2() - component.getX()) / 2.0) * this.LENGTH_RATE - 300.0) * (double)this.rate);
        angleend = this.getAngleFromXY(dx, dy, centerX, centerY);
        anglestart = this.getAngleFromXY(dxstart, dystart, centerX, centerY);
        if (dx > (double)centerX && dy < (double)centerY && dxstart > (double)centerX && dystart > (double)centerY) {
            angleend += Math.PI * 2;
        } else if (dx > (double)centerX && dy > (double)centerY && dxstart > (double)centerX && dystart < (double)centerY) {
            anglestart += Math.PI * 2;
        }
        angledis = -(angleend - anglestart);
        component.setRotationAngle(component.getRotationAngle() + angledis * 360.0 / (Math.PI * 2));
        this.isDrag = true;
        component.dStartRotateDrag = new Point2D.Double(x, y);
    }

    public void dragVertex(Protein protein, Component component, int x, int y, int k) {
        component.dEndComDrag = new Point2D.Double(x, y);
        double dx = 0.0;
        double dy = 0.0;
        dx = component.dEndComDrag.x - component.dStartComDrag.x;
        dy = component.dEndComDrag.y - component.dStartComDrag.y;
        component.pgxy.getTransCenterPoint();
        component.pgxy.dragOneAToGetWH(k, (int)dx, (int)dy);
        double fstartx = 0.0;
        double fstarty = 0.0;
        double fendx = 0.0;
        double fendy = 0.0;
        fstartx = component.pgxy.centerx - component.pgxy.iwide;
        fendx = component.pgxy.centerx + component.pgxy.iwide;
        fstarty = component.pgxy.centery - component.pgxy.ihigh;
        fendy = component.pgxy.centery + component.pgxy.ihigh;
        double centery = 0.0;
        fstartx = (fstartx / (double)this.rate + 300.0 - (double)protein.getHorizontal()) / this.LENGTH_RATE;
        fendx = (fendx / (double)this.rate + 300.0 - (double)protein.getHorizontal()) / this.LENGTH_RATE;
        centery = Math.round((double)(-protein.getVertical()) - component.pgxy.centery / (double)this.rate);
        double iwide = 0.0;
        double ihigh = 0.0;
        iwide = Math.abs(fendx - fstartx) / 2.0;
        ihigh = Math.abs(((double)(-protein.getVertical()) - centery - fstarty / (double)this.rate) / this.LENGTH_RATE);
        if (iwide <= 1.0) {
            iwide = 1.0;
        }
        if (ihigh <= 1.0) {
            ihigh = 1.0;
        }
        if ((component.getShapeType() == ShapeEnum.L_ParallelLine || component.getShapeType() == ShapeEnum.R_ParallelLine || component.getShapeType() == ShapeEnum.L_ParallelCurve || component.getShapeType() == ShapeEnum.R_ParallelCurve) && ihigh < iwide) {
            ihigh = iwide;
        }
        component.setWide(iwide * 2.0);
        component.setHigh(ihigh * 2.0);
        component.dStartComDrag = new Point2D.Double(x, y);
        this.isDrag = true;
    }

    public void dragEdge(Protein protein, Component component, int x, int y, int k) {
        component.dEndComDrag = new Point2D.Double(x, y);
        double dx = 0.0;
        double dy = 0.0;
        dx = component.dEndComDrag.x - component.dStartComDrag.x;
        dy = component.dEndComDrag.y - component.dStartComDrag.y;
        component.pgxy.getTransCenterPoint();
        component.pgxy.dragOneEToGetWH(k, (int)dx, (int)dy);
        double fstartx = 0.0;
        double fstarty = 0.0;
        double fendx = 0.0;
        double fendy = 0.0;
        fstartx = component.pgxy.centerx - component.pgxy.iwide;
        fendx = component.pgxy.centerx + component.pgxy.iwide;
        fstarty = component.pgxy.centery - component.pgxy.ihigh;
        fendy = component.pgxy.centery + component.pgxy.ihigh;
        double centery = 0.0;
        fstartx = (fstartx / (double)this.rate + 300.0 - (double)protein.getHorizontal()) / this.LENGTH_RATE;
        fendx = (fendx / (double)this.rate + 300.0 - (double)protein.getHorizontal()) / this.LENGTH_RATE;
        centery = Math.round((double)(-protein.getVertical()) - component.pgxy.centery / (double)this.rate);
        double iwide = 0.0;
        double ihigh = 0.0;
        iwide = Math.abs(fendx - fstartx) / 2.0;
        ihigh = Math.abs(((double)(-protein.getVertical()) - centery - fstarty / (double)this.rate) / this.LENGTH_RATE);
        if (iwide <= 1.0) {
            iwide = 1.0;
        }
        if (ihigh <= 1.0) {
            ihigh = 1.0;
        }
        if ((component.getShapeType() == ShapeEnum.L_ParallelLine || component.getShapeType() == ShapeEnum.R_ParallelLine || component.getShapeType() == ShapeEnum.L_ParallelCurve || component.getShapeType() == ShapeEnum.R_ParallelCurve) && ihigh < iwide) {
            ihigh = iwide;
        }
        component.setWide(iwide * 2.0);
        component.setHigh(ihigh * 2.0);
        component.dStartComDrag = new Point2D.Double(x, y);
        this.isDrag = true;
    }

    public void dragToRotate(Protein protein, Component component, int x, int y) {
        double angleend = 0.0;
        double anglestart = 0.0;
        double angledis = 0.0;
        component.dEndRotateDrag = new Point2D.Double(x, y);
        double dx = component.dEndRotateDrag.x;
        double dy = component.dEndRotateDrag.y;
        double dxstart = component.dStartRotateDrag.x;
        double dystart = component.dStartRotateDrag.y;
        int centerX = 0;
        int centerY = 0;
        centerY = (int)(((double)(-protein.getVertical()) - component.getCentery()) * (double)this.rate);
        centerX = (int)(((double)protein.getHorizontal() + component.getCenterx() * this.LENGTH_RATE - 300.0) * (double)this.rate);
        angleend = this.getAngleFromXY(dx, dy, centerX, centerY);
        anglestart = this.getAngleFromXY(dxstart, dystart, centerX, centerY);
        if (dx > (double)centerX && dy < (double)centerY && dxstart > (double)centerX && dystart > (double)centerY) {
            angleend += Math.PI * 2;
        } else if (dx > (double)centerX && dy > (double)centerY && dxstart > (double)centerX && dystart < (double)centerY) {
            anglestart += Math.PI * 2;
        }
        angledis = -(angleend - anglestart);
        double newangle = component.getRotationAngle() + angledis * 360.0 / (Math.PI * 2);
        if (newangle >= 360.0) {
            newangle %= 360.0;
        }
        if (newangle <= -360.0) {
            newangle = -(-newangle % 360.0);
        }
        component.setRotationAngle(newangle);
        this.isDrag = true;
        component.dStartRotateDrag = new Point2D.Double(x, y);
    }

    public void dragNoteToRotate(Protein protein, Component component, int x, int y) {
        double angleend = 0.0;
        double anglestart = 0.0;
        double angledis = 0.0;
        component.dEndRotateDrag = new Point2D.Double(x, y);
        double dx = component.dEndRotateDrag.x;
        double dy = component.dEndRotateDrag.y;
        double dxstart = component.dStartRotateDrag.x;
        double dystart = component.dStartRotateDrag.y;
        int centerX = 0;
        int centerY = 0;
        centerY = (int)((float)(-protein.getVertical()) - (float)component.getY() * this.rate);
        centerX = (int)(((double)(-protein.getHorizontal()) + component.getX() * this.LENGTH_RATE - 300.0) / (double)this.rate);
        angleend = this.getAngleFromXY(dx, dy, centerX, centerY);
        anglestart = this.getAngleFromXY(dxstart, dystart, centerX, centerY);
        if (dx > (double)centerX && dy < (double)centerY && dxstart > (double)centerX && dystart > (double)centerY) {
            angleend += Math.PI * 2;
        } else if (dx > (double)centerX && dy > (double)centerY && dxstart > (double)centerX && dystart < (double)centerY) {
            anglestart += Math.PI * 2;
        }
        angledis = -(angleend - anglestart);
        double newangle = component.getRotationAngle() + angledis * 360.0 / (Math.PI * 2);
        if (newangle >= 360.0) {
            newangle %= 360.0;
        }
        if (newangle <= -360.0) {
            newangle = -(-newangle % 360.0);
        }
        component.setRotationAngle(newangle);
        this.isDrag = true;
        component.dStartRotateDrag = new Point2D.Double(x, y);
    }

    public Area drawPolygonAndAnchor(Graphics2D g2d, Protein pr, Component com, boolean isActive, double vertical, Color color, Color colorline, Color colororig, Color colortext, Stroke stroke, int strokesize, double size, String name, DrawTypeEnum nameDrawType, String SelectTextureFile, GradientEnum GradientType, ShapeEnum shapeType, int iradius, double comhalf_heigh, double centerX, double centerY, double startX, double startY, double endX, double endY, double angle, boolean isborderdahs) {
        Stroke origstroke = g2d.getStroke();
        startX = Math.round(startX);
        startY = Math.round(startY);
        endX = Math.round(endX);
        endY = Math.round(endY);
        iradius = 3;
        PolygonXY pgxy = new PolygonXY();
        pgxy.getPolygonXY(startX, startY, endX, endY, shapeType.name().toString(), angle, this.rate);
        pgxy.CacuMinMaxXY();
        com.pgxy = pgxy;
        com.pgxy.centerx = com.getCenterx();
        com.pgxy.centery = com.getCentery();
        Color colorbk = colorline;
        this.drawPolygonTextureRect(pr, com, g2d, startX, startY, endX, endY, pgxy, SelectTextureFile, stroke, color, colorbk, GradientType, shapeType, strokesize, isActive, vertical, comhalf_heigh, isborderdahs);
        Color ac = Color.BLUE;
        Color pc = new Color(0, 255, 0);
        if (isActive) {
            g2d.setColor(Color.RED);
            g2d.setColor(Color.ORANGE);
            Ellipse2D.Double shapeAnchor1 = new Ellipse2D.Double((int)pgxy.endax[0] - iradius, (int)pgxy.enday[0] - iradius, 2 * iradius, 2 * iradius);
            com.GeomAnchor1 = new java.awt.geom.Area(shapeAnchor1);
            Ellipse2D.Double shapeAnchor2 = new Ellipse2D.Double((int)pgxy.endax[1] - iradius, (int)pgxy.enday[1] - iradius, 2 * iradius, 2 * iradius);
            com.GeomAnchor2 = new java.awt.geom.Area(shapeAnchor2);
            Ellipse2D.Double shapeAnchor3 = new Ellipse2D.Double((int)pgxy.endax[2] - iradius, (int)pgxy.enday[2] - iradius, 2 * iradius, 2 * iradius);
            com.GeomAnchor3 = new java.awt.geom.Area(shapeAnchor3);
            Ellipse2D.Double shapeAnchor4 = new Ellipse2D.Double((int)pgxy.endax[3] - iradius, (int)pgxy.enday[3] - iradius, 2 * iradius, 2 * iradius);
            com.GeomAnchor4 = new java.awt.geom.Area(shapeAnchor4);
            g2d.fill(shapeAnchor4);
            g2d.fill(shapeAnchor3);
            g2d.fill(shapeAnchor2);
            g2d.fill(shapeAnchor1);
            Rectangle2D.Double shapeAnchorE1 = new Rectangle2D.Double((int)pgxy.endcx[0] - iradius, (int)pgxy.endcy[0] - iradius, 2 * iradius, 2 * iradius);
            com.GeomAnchorE1 = new java.awt.geom.Area(shapeAnchorE1);
            Rectangle2D.Double shapeAnchorE2 = new Rectangle2D.Double((int)pgxy.endcx[1] - iradius, (int)pgxy.endcy[1] - iradius, 2 * iradius, 2 * iradius);
            com.GeomAnchorE2 = new java.awt.geom.Area(shapeAnchorE2);
            Rectangle2D.Double shapeAnchorE3 = new Rectangle2D.Double((int)pgxy.endcx[2] - iradius, (int)pgxy.endcy[2] - iradius, 2 * iradius, 2 * iradius);
            com.GeomAnchorE3 = new java.awt.geom.Area(shapeAnchorE3);
            Rectangle2D.Double shapeAnchorE4 = new Rectangle2D.Double((int)pgxy.endcx[3] - iradius, (int)pgxy.endcy[3] - iradius, 2 * iradius, 2 * iradius);
            com.GeomAnchorE4 = new java.awt.geom.Area(shapeAnchorE4);
            if (com.getType() != ComponentEnum.Domain) {
                g2d.fill(shapeAnchorE4);
                g2d.fill(shapeAnchorE3);
                g2d.fill(shapeAnchorE2);
                g2d.fill(shapeAnchorE1);
            }
            g2d.setColor(Color.RED);
            iradius = 5;
            if (!(shapeType == ShapeEnum.L_ParallelCurve || shapeType == ShapeEnum.R_ParallelCurve || shapeType == ShapeEnum.L_ParallelLine || shapeType == ShapeEnum.R_ParallelLine || shapeType == ShapeEnum.Cylinder && com.getType() == ComponentEnum.Domain || this.Mode.equals("P") && com.getType() == ComponentEnum.Domain)) {
                g2d.setStroke(new BasicStroke(Math.round(this.raoteAnchorthick), 1, 1));
                if (com.GeomAnchorRotate != null && com.bAnchorRotateSelected && com.dEndRotateDrag != null) {
                    double dx = com.dEndRotateDrag.x;
                    double dy = com.dEndRotateDrag.y;
                    Rectangle2D.Double shapeOval = new Rectangle2D.Double((int)dx - iradius, (int)dy - iradius, 2 * iradius, 2 * iradius);
                    com.GeomAnchorRotate = new java.awt.geom.Area(shapeOval);
                    g2d.drawOval((int)dx - iradius, (int)dy - iradius, 2 * iradius, 2 * iradius);
                    this.drawAnchorRotateArrow(g2d, (int)(dx + (double)iradius), (int)(dy + (double)(iradius / 8)), (int)(dx + (double)iradius), (int)(dy - (double)iradius));
                } else {
                    double rx = Math.sqrt(Math.pow(pgxy.endax[0] - centerX, 2.0) + Math.pow(pgxy.enday[0] - centerY, 2.0));
                    double cx = endX + rx + 15.0 - (double)iradius;
                    double cy = startY - (double)iradius - 15.0;
                    double cw = 2 * iradius;
                    double ch = 2 * iradius;
                    double startang = 0.0;
                    double endang = 270.0;
                    Arc2D.Double arc1 = new Arc2D.Double(cx, cy, cw, ch, startang, endang, 0);
                    g2d.draw(arc1);
                    this.drawAnchorRotateArrow(g2d, (int)(endX + rx + 15.0 + (double)iradius), (int)(startY + (double)(iradius / 8) - 15.0), (int)(endX + rx + 15.0 + (double)iradius), (int)(startY - (double)iradius - 15.0));
                    Rectangle2D.Double shapeOval = new Rectangle2D.Double(endX + rx + 15.0 - (double)iradius, startY - (double)iradius - 15.0, 2 * iradius, 2 * iradius);
                    com.GeomAnchorRotate = new java.awt.geom.Area(shapeOval);
                }
            }
        }
        g2d.setColor(colororig);
        g2d.setStroke(stroke);
        g2d.setColor(colortext);
        g2d.setFont(new Font("Arial", 1, (int)(size * (double)this.rate)));
        if (nameDrawType == DrawTypeEnum.Up) {
            g2d.drawString(name, (float)(centerX - (double)g2d.getFontMetrics().stringWidth(name) / 2.0), (float)(pgxy.miny - 5 - g2d.getFontMetrics().getLeading() - g2d.getFontMetrics().getDescent()));
        } else if (nameDrawType == DrawTypeEnum.Center) {
            g2d.drawString(name, (float)(centerX - (double)g2d.getFontMetrics().stringWidth(name) / 2.0), (float)(centerY + (double)g2d.getFontMetrics().getHeight() / 4.0));
        } else if (nameDrawType == DrawTypeEnum.Down) {
            g2d.drawString(name, (float)(centerX - (double)g2d.getFontMetrics().stringWidth(name) / 2.0), (float)(pgxy.maxy + 5 + g2d.getFontMetrics().getLeading() + g2d.getFontMetrics().getAscent()));
        } else if (nameDrawType == DrawTypeEnum.Hide) {
            // empty if block
        }
        Area sa = null;
        sa = new Area(pgxy.minx, pgxy.miny, pgxy.maxx, pgxy.maxy);
        g2d.setStroke(origstroke);
        return sa;
    }

    private void drawAnchorRotateArrow(Graphics2D g2d, int x1, int y1, int x2, int y2) {
        double distance = Math.abs(Point2D.distance(x1, y1, x2, y2));
        double x0 = 0.0;
        double y0 = 0.0;
        double xa = 0.0;
        double ya = 0.0;
        double xb = 0.0;
        double yb = 0.0;
        double dw = 4.0;
        double dh = 3.0;
        double dx = Math.abs(x1 - x2);
        double dy = Math.abs(y1 - y2);
        x0 = (double)x2 + (distance += 3.0);
        y0 = y2;
        xa = (double)x2 + distance - dw;
        ya = y2;
        xb = (double)x2 + distance - dw;
        yb = y2;
        double anglepoint = 0.0;
        anglepoint = Math.atan(dh / (distance - dw));
        double anglerotation = 0.0;
        if (y1 >= y2 && x1 >= x2) {
            anglerotation = Math.atan(dy / dx);
        } else if (y1 >= y2 && x1 <= x2) {
            anglerotation = 1.5707963267948966 + Math.atan(dx / dy);
        } else if (y1 <= y2 && x1 <= x2) {
            anglerotation = Math.PI + Math.atan(dy / dx);
        } else if (y1 <= y2 && x1 >= x2) {
            anglerotation = 4.71238898038469 + Math.atan(dx / dy);
        }
        double anglefull1 = -anglerotation;
        double anglefulla = -anglerotation + anglepoint;
        double anglefullb = -anglerotation - anglepoint;
        double arcx = 0.0;
        double arcy = 0.0;
        arcx = (x0 - (double)x2) * Math.cos(anglefull1) - (y0 - (double)y2) * Math.sin(anglefull1) + (double)x2;
        arcy = -1.0 * (x0 - (double)x2) * Math.sin(anglefull1) + (y0 - (double)y2) * Math.cos(anglefull1) + (double)y2;
        x0 = (int)Math.round(arcx);
        y0 = (int)Math.round(arcy);
        arcx = (xa - (double)x2) * Math.cos(anglefulla) - (ya - (double)y2) * Math.sin(anglefulla) + (double)x2;
        arcy = -1.0 * (xa - (double)x2) * Math.sin(anglefulla) + (ya - (double)y2) * Math.cos(anglefulla) + (double)y2;
        xa = (int)Math.round(arcx);
        ya = (int)Math.round(arcy);
        arcx = (xb - (double)x2) * Math.cos(anglefullb) - (yb - (double)y2) * Math.sin(anglefullb) + (double)x2;
        arcy = -1.0 * (xb - (double)x2) * Math.sin(anglefullb) + (yb - (double)y2) * Math.cos(anglefullb) + (double)y2;
        xb = (int)Math.round(arcx);
        yb = (int)Math.round(arcy);
        int[] px = new int[3];
        int[] py = new int[3];
        px[0] = (int)xa;
        px[1] = (int)x0;
        px[2] = (int)xb;
        py[0] = (int)ya;
        py[1] = (int)y0;
        py[2] = (int)yb;
        g2d.drawPolyline(px, py, 3);
    }

    public Point2D.Double getBracketCenter(int xa, int ya, int xb, int yb) {
        Point2D.Double centerp = new Point2D.Double();
        int lx = Math.abs(xa - xb) / 2;
        int ly = Math.abs(ya - yb) / 2;
        if (xa < xb && ya < yb) {
            centerp.x = xa + lx;
            centerp.y = ya + ly;
        } else if (xa > xb && ya < yb) {
            centerp.x = xa - lx;
            centerp.y = ya + ly;
        } else if (xa > xb && ya > yb) {
            centerp.x = xa - lx;
            centerp.y = ya - ly;
        } else if (xa < xb && ya > yb) {
            centerp.x = xa + lx;
            centerp.y = ya - ly;
        } else if (xa == xb && ya == yb) {
            centerp.x = xa + lx;
            centerp.y = ya;
        } else if (xa == xb && ya < yb) {
            centerp.x = xa;
            centerp.y = ya + ly;
        } else if (xa > xb && ya == yb) {
            centerp.x = xa - lx;
            centerp.y = ya;
        } else if (xa == xb && ya > yb) {
            centerp.x = xa;
            centerp.y = ya - ly;
        }
        return centerp;
    }

    public int getBracketRotateAngle(int xa, int ya, int xb, int yb) {
        double angle = 0.0;
        int lx = Math.abs(xa - xb) / 2;
        int ly = Math.abs(ya - yb) / 2;
        if (xa < xb && ya < yb) {
            angle = Math.atan(ly / lx);
        } else if (xa > xb && ya < yb) {
            angle = Math.PI - Math.atan(ly / lx);
        } else if (xa > xb && ya > yb) {
            angle = -(Math.PI - Math.atan(ly / lx));
        } else if (xa < xb && ya > yb) {
            angle = -Math.atan(ly / lx);
        } else if (xa == xb && ya == yb) {
            angle = 0.0;
        } else if (xa == xb && ya < yb) {
            angle = 1.5707963267948966;
        } else if (xa > xb && ya == yb) {
            angle = Math.PI;
        } else if (xa == xb && ya > yb) {
            angle = 2.0943951023931953;
        }
        angle = angle * 360.0 / (Math.PI * 2);
        return (int)angle;
    }

    public void findPicMaxWH() {
        if (this.g2dcurr == null) {
            return;
        }
        double ymin = 0.0;
        double ymax = 0.0;
        double ycenter = 0.0;
        double xmin = 0.0;
        double xmax = 0.0;
        double xcenter = 0.0;
        double maxproteinlen = 0.0;
        if (this.proteinList.size() > 0) {
            if (this.isLengthRate) {
                this.maxLength = 1;
                for (Protein protein : this.proteinList) {
                    int end = protein.getEnd();
                    if (end <= this.maxLength) continue;
                    this.maxLength = end;
                }
                maxproteinlen = this.maxLength;
                this.LENGTH_RATE = 600.0 / (double)this.maxLength;
            }
            for (Protein protein : this.proteinList) {
                String[] arrPro = protein.getParameter().split("#&%");
                int vertical = -protein.getVertical();
                int horizontal = protein.getHorizontal();
                int start = Integer.parseInt(arrPro[0]);
                int end = Integer.parseInt(arrPro[2]);
                int proteinHeight = Integer.parseInt(arrPro[4]);
                this.HALF_HEIGHT = (double)proteinHeight / 2.0;
                double startX = -300.0 + (double)horizontal + (double)start * this.LENGTH_RATE;
                double endX = -300.0 + (double)horizontal + (double)end * this.LENGTH_RATE;
                double startY = (double)vertical - this.HALF_HEIGHT;
                double endY = (double)vertical + this.HALF_HEIGHT;
                if (endX > xmax) {
                    xmax = endX;
                }
                if (startX < xmin) {
                    xmin = startX;
                }
                if (endY > ymax) {
                    ymax = endY;
                }
                if (startY < ymin) {
                    ymin = startY;
                }
                LinkedList<Component> componentList = protein.getComponentList();
                for (Component component : componentList) {
                    double endy;
                    double startx;
                    double endx;
                    if (component.getType() == ComponentEnum.Domain) {
                        double iHigh = component.getHigh();
                        if (this.Mode.equals("N")) continue;
                        int iVhigh = (int)(iHigh * 2.0 * this.LENGTH_RATE);
                        if ((double)(iVhigh / 4) < this.HALF_HEIGHT) {
                            startY = Math.round((double)vertical - this.HALF_HEIGHT);
                            endY = Math.round((double)vertical + this.HALF_HEIGHT);
                        } else {
                            startY = vertical - iVhigh / 4;
                            endY = vertical + iVhigh / 4;
                        }
                        if (endY > ymax) {
                            ymax = endY;
                        }
                        if (!(startY < ymin)) continue;
                        ymin = startY;
                        continue;
                    }
                    if (component.getType() == ComponentEnum.CutLine) {
                        double iHigh = component.getHigh();
                        if (this.Mode.equals("N")) {
                            if (iHigh == 0.0) {
                                startY = (double)vertical - this.HALF_HEIGHT;
                                endY = (double)vertical + this.HALF_HEIGHT;
                            } else {
                                int iVhigh = (int)(iHigh * 2.0 * this.LENGTH_RATE);
                                startY = (double)vertical - (double)iVhigh / 4.0;
                                endY = (double)vertical + (double)iVhigh / 4.0;
                            }
                        } else {
                            int iVhigh = (int)(iHigh * 2.0 * this.LENGTH_RATE);
                            if ((double)(iVhigh / 4) < this.HALF_HEIGHT) {
                                startY = Math.round((double)vertical - this.HALF_HEIGHT);
                                endY = Math.round((double)vertical + this.HALF_HEIGHT);
                            } else {
                                startY = vertical - iVhigh / 4;
                                endY = vertical + iVhigh / 4;
                            }
                        }
                        if (endY > ymax) {
                            ymax = endY;
                        }
                        if (!(startY < ymin)) continue;
                        ymin = startY;
                        continue;
                    }
                    if (component.getType() == ComponentEnum.Site) {
                        int deltaX = (int)component.getCenterx();
                        int deltaY = (int)component.getCentery();
                        double centerx = deltaX;
                        double centery = deltaY;
                        double wide = component.getWide();
                        double high = component.getHigh();
                        double startx2 = centerx - wide / 2.0;
                        endx = centerx + wide / 2.0;
                        startX = -300.0 + (double)horizontal + startx2 * this.LENGTH_RATE;
                        endX = -300.0 + (double)horizontal + endx * this.LENGTH_RATE;
                        startY = (double)vertical - centery - high / 2.0 * this.LENGTH_RATE;
                        endY = (double)vertical - centery + high / 2.0 * this.LENGTH_RATE;
                        if (endX > xmax) {
                            xmax = endX;
                        }
                        if (startX < xmin) {
                            xmin = startX;
                        }
                        if (endY > ymax) {
                            ymax = endY;
                        }
                        if (!(startY < ymin)) continue;
                        ymin = startY;
                        continue;
                    }
                    if (component.getType() == ComponentEnum.Note) {
                        String[] arr = component.getParameter().split("#&%");
                        String title = arr[0].trim();
                        double deltaX = component.x;
                        double deltaY = component.y;
                        double centralX = deltaX * this.LENGTH_RATE + (double)horizontal - 300.0;
                        double centralY = (double)vertical - deltaY;
                        DrawTypeEnum style = DrawTypeEnum.valueOf(arr[2]);
                        int size = Integer.parseInt(arr[1]);
                        String strFont = arr.length > 5 ? arr[5] : "Arial";
                        if (style == DrawTypeEnum.Bold) {
                            this.g2dcurr.setFont(new Font(strFont, 1, size));
                        } else if (style == DrawTypeEnum.Italic) {
                            this.g2dcurr.setFont(new Font(strFont, 2, size));
                        } else if (style == DrawTypeEnum.Plain) {
                            this.g2dcurr.setFont(new Font(strFont, 0, size));
                        } else if (style == DrawTypeEnum.Bold_Italic) {
                            this.g2dcurr.setFont(new Font(strFont, 3, size));
                        }
                        FontMetrics noteFontMetrics = this.g2dcurr.getFontMetrics();
                        startX = centralX - (double)noteFontMetrics.stringWidth(title) / 2.0;
                        endX = centralX + (double)noteFontMetrics.stringWidth(title) / 2.0;
                        startY = centralY - (double)noteFontMetrics.getHeight() / 2.0;
                        endY = centralY + (double)noteFontMetrics.getHeight() / 2.0;
                        if (endX > xmax) {
                            xmax = endX;
                        }
                        if (startX < xmin) {
                            xmin = startX;
                        }
                        if (endY > ymax) {
                            ymax = endY;
                        }
                        if (!(startY < ymin)) continue;
                        ymin = startY;
                        continue;
                    }
                    if (component.getType() == ComponentEnum.Line) {
                        int x1 = (int)component.getX();
                        int y1 = component.getY();
                        int x2 = (int)component.getX2();
                        int y2 = component.getY2();
                        int x3 = component.getControlx1();
                        int y3 = component.getControly1();
                        int x4 = component.getControlx2();
                        int y4 = component.getControly2();
                        if (component.shapeType == null) {
                            component.shapeType = ShapeEnum.Straight;
                        }
                        startx = 0.0;
                        double endx2 = 0.0;
                        double starty = 0.0;
                        endy = 0.0;
                        if (component.shapeType == ShapeEnum.Straight) {
                            endx2 = Math.max(x1, x2);
                            startx = Math.min(x1, x2);
                            endy = Math.max(y1, y2);
                            starty = Math.min(y1, y2);
                        } else if (component.shapeType == ShapeEnum.PolylineOne || component.shapeType == ShapeEnum.Curve) {
                            endx2 = Math.max(x1, x2);
                            endx2 = Math.max(endx2, (double)x3);
                            startx = Math.min(x1, x2);
                            startx = Math.min(startx, (double)x3);
                            endy = Math.max(y1, y2);
                            endy = Math.max(endy, (double)y3);
                            starty = Math.min(y1, y2);
                            starty = Math.min(starty, (double)y3);
                        } else if (component.shapeType == ShapeEnum.PolylineTwo || component.shapeType == ShapeEnum.Bezier) {
                            endx2 = Math.max(x1, x2);
                            endx2 = Math.max(endx2, (double)x3);
                            endx2 = Math.max(endx2, (double)x4);
                            startx = Math.min(x1, x2);
                            startx = Math.min(startx, (double)x3);
                            startx = Math.min(startx, (double)x4);
                            endy = Math.max(y1, y2);
                            endy = Math.max(endy, (double)y3);
                            endy = Math.max(endy, (double)y4);
                            starty = Math.min(y1, y2);
                            starty = Math.min(starty, (double)y3);
                            starty = Math.min(starty, (double)y4);
                        }
                        startX = -300.0 + (double)horizontal + startx * this.LENGTH_RATE;
                        startY = (double)vertical - starty;
                        endX = -300.0 + (double)horizontal + endx2 * this.LENGTH_RATE;
                        endY = (double)vertical - endy;
                        if (endX > xmax) {
                            xmax = endX;
                        }
                        if (startX < xmin) {
                            xmin = startX;
                        }
                        if (endY > ymax) {
                            ymax = endY;
                        }
                        if (!(startY < ymin)) continue;
                        ymin = startY;
                        continue;
                    }
                    if (component.getType() == ComponentEnum.Polygon) {
                        double centerx = component.getCenterx();
                        double centery = component.getCentery();
                        double wide = component.getWide();
                        double high = component.getHigh();
                        startx = centerx - wide / 2.0;
                        double starty = centery - high / 2.0;
                        endx = centerx + wide / 2.0;
                        endy = centery + high / 2.0;
                        startX = -300.0 + (double)horizontal + startx * this.LENGTH_RATE;
                        endX = -300.0 + (double)horizontal + endx * this.LENGTH_RATE;
                        startY = (double)vertical - centery - high / 2.0 * this.LENGTH_RATE;
                        endY = (double)vertical - centery + high / 2.0 * this.LENGTH_RATE;
                        if (endX > xmax) {
                            xmax = endX;
                        }
                        if (startX < xmin) {
                            xmin = startX;
                        }
                        if (endY > ymax) {
                            ymax = endY;
                        }
                        if (!(startY < ymin)) continue;
                        ymin = startY;
                        continue;
                    }
                    if (component.getType() != ComponentEnum.Bracket) continue;
                    double centerx = component.getCenterx();
                    double centery = component.getCentery();
                    double wide = component.getWide();
                    double startx3 = centerx - wide;
                    double endx3 = centerx + wide;
                    startX = (int)(-300.0 + (double)horizontal + startx3 * this.LENGTH_RATE);
                    endX = (int)(-300.0 + (double)horizontal + endx3 * this.LENGTH_RATE);
                    int high = 3;
                    if (component.shapeType == ShapeEnum.SquareBracket) {
                        high = 3;
                    } else if (component.shapeType == ShapeEnum.Brace) {
                        high = 5;
                    }
                    startY = (int)((double)vertical - centery - (double)high);
                    endY = (int)((double)vertical - centery + (double)high);
                    if (endX > xmax) {
                        xmax = endX;
                    }
                    if (startX < xmin) {
                        xmin = startX;
                    }
                    if (endY > ymax) {
                        ymax = endY;
                    }
                    if (!(startY < ymin)) continue;
                    ymin = startY;
                }
            }
            this.widthMaxLenPic = (int)Math.max(Math.abs(xmax), Math.abs(xmin)) * 2;
            this.heightMaxLenPic = (int)Math.max(Math.abs(ymax), Math.abs(ymin)) * 2;
        }
    }
}

