/*
 * Decompiled with CFR 0.152.
 */
package gui.ibs;

import gui.Tools;
import gui.ibs.Component;
import gui.ibs.ComponentEnum;
import gui.ibs.CustomComboBoxDemo;
import gui.ibs.EditDialog;
import gui.ibs.PreviewPanel;
import gui.ibs.ResourceBundleUtil;
import gui.ibs.ShapeEnum;
import gui.ibs.Verifier;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.LinkedList;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;

public class CutLineDialog
extends EditDialog {
    private Component component;
    private String DELIMIT = "#&%";
    public ShapeEnum shapeType = ShapeEnum.L_ParallelLine;
    ResourceBundleUtil config;
    public String strNum = "";
    private ButtonGroup buttonGroup1;
    private JButton cancelButton;
    private JTextField centerTextField;
    private JPanel colorLine;
    private CustomComboBoxDemo comboBoxShape;
    private JLabel endLabel;
    private JComboBox jComboBoxDash;
    private JLabel jLabel1;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel2;
    private JLabel jLabel21;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel9;
    private JLabel jLabelProteinDash;
    private JLabel jLabelTip;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JRadioButton jRadioButton3;
    private JSpinner jSpinnerStrokeSize;
    private JTextField jTextFieldID;
    private JTextField jTextFieldradius;
    private JPanel mainPanel;
    private JButton okButton;
    private JPanel previewPanel;
    private JLabel startLabel;
    private JTextField widthTextField;

    public ShapeEnum getShapeType() {
        return this.shapeType;
    }

    public void setShapeType(ShapeEnum shapeType) {
        this.shapeType = shapeType;
    }

    public CutLineDialog(Frame parent, String title, ImageIcon[] imagesShape, boolean modal, String mode, String fstrNum) {
        super(parent, title, modal);
        this.strNum = fstrNum;
        this.setPreferredSize(new Dimension(780, 380));
        this.config = ResourceBundleUtil.getBundle("gui.ibs.config");
        this.initComponents();
        this.comboBoxShape.cutLineDialog20 = this;
        this.comboBoxShape.setComImages(imagesShape, "ShapeCutline");
        this.setTitle(title);
        if (mode.equals("P")) {
            this.jLabelProteinDash.setText("Protein Dash");
        } else {
            this.jLabelProteinDash.setText("Nucleotide Dash");
        }
        String st = "Users can drag the element for absolute positioning, resize it and rotate it through the mouse.";
        this.jLabelTip.setText(st);
        this.previewDraw();
        this.widthTextField.requestFocus();
        this.enableEvents(8L);
        InputMap inputMap = this.rootPane.getInputMap(2);
        inputMap.put(KeyStroke.getKeyStroke("ESCAPE"), "ESCAPE");
        this.rootPane.getActionMap().put("ESCAPE", new AbstractAction("ESCAPE"){

            @Override
            public void actionPerformed(ActionEvent e) {
                CutLineDialog.this.cancelButton.doClick();
            }
        });
        inputMap.put(KeyStroke.getKeyStroke("ENTER"), "ENTER");
        this.rootPane.getActionMap().put("ENTER", new AbstractAction("ENTER"){

            @Override
            public void actionPerformed(ActionEvent e) {
                CutLineDialog.this.okButton.doClick();
            }
        });
    }

    public void shapeChange() {
    }

    public CutLineDialog(Frame parent, String title, ImageIcon[] imagesShape, boolean modal, int proteinhieght, int proteinlenth, String mode, String fstrNum) {
        super(parent, title, modal);
        int wh;
        this.strNum = fstrNum;
        this.setPreferredSize(new Dimension(780, 380));
        this.config = ResourceBundleUtil.getBundle("gui.ibs.config");
        this.initComponents();
        this.setTitle(title);
        this.comboBoxShape.cutLineDialog20 = this;
        this.comboBoxShape.SelectTextureFile = this.config.getString("cutline.SelectTextureFile");
        this.comboBoxShape.setComImages(imagesShape, "ShapeCutline");
        if (mode.equals("P")) {
            String whratep = this.config.getString("cutline.whratep");
            wh = (int)Math.round((double)proteinlenth * Double.valueOf(whratep));
            int icenter = 10 + wh / 2;
            this.centerTextField.setText(String.valueOf(icenter));
            this.widthTextField.setText(String.valueOf(wh));
            this.jTextFieldradius.setText(String.valueOf(wh));
            this.jLabelProteinDash.setText("Protein Dash");
        } else {
            String whraten = this.config.getString("cutline.whraten");
            wh = (int)Math.round((double)proteinlenth * Double.valueOf(whraten));
            int iwide = (int)((double)wh / 2.0);
            int icenter = 10 + iwide;
            this.centerTextField.setText(String.valueOf(icenter));
            this.widthTextField.setText(String.valueOf(wh));
            this.jTextFieldradius.setText(String.valueOf(wh));
            this.jLabelProteinDash.setText("Nucleotide Dash");
        }
        this.jTextFieldID.setText(this.strNum);
        Color bc = new Color(204, 204, 204);
        this.jTextFieldID.setForeground(bc);
        String st = "Users can drag the element for absolute positioning, resize it and rotate it through the mouse.";
        this.jLabelTip.setText(st);
        this.previewDraw();
        this.widthTextField.requestFocus();
        this.enableEvents(8L);
        InputMap inputMap = this.rootPane.getInputMap(2);
        inputMap.put(KeyStroke.getKeyStroke("ESCAPE"), "ESCAPE");
        this.rootPane.getActionMap().put("ESCAPE", new AbstractAction("ESCAPE"){

            @Override
            public void actionPerformed(ActionEvent e) {
                CutLineDialog.this.cancelButton.doClick();
            }
        });
        inputMap.put(KeyStroke.getKeyStroke("ENTER"), "ENTER");
        this.rootPane.getActionMap().put("ENTER", new AbstractAction("ENTER"){

            @Override
            public void actionPerformed(ActionEvent e) {
                CutLineDialog.this.okButton.doClick();
            }
        });
    }

    @Override
    public Component getComponent() {
        return this.component;
    }

    @Override
    public void setComponent(Component component) {
        this.colorLine.setBackground(component.getColorline());
        String[] arr = component.getParameter().split(this.DELIMIT);
        int istart = 0;
        int iend = 0;
        int icenter = 0;
        int iwidth = 0;
        istart = (int)component.getX();
        iend = (int)component.getX2();
        iwidth = Math.abs(istart - iend);
        icenter = (int)((double)istart + (double)iwidth / 2.0);
        this.centerTextField.setText(String.valueOf(icenter));
        this.widthTextField.setText(String.valueOf(iwidth));
        this.shapeType = component.getShapeType();
        this.jSpinnerStrokeSize.setValue(Integer.valueOf(arr[5]));
        if (component.bProteinLDash) {
            this.jComboBoxDash.setSelectedIndex(1);
        } else if (component.bProteinRDash) {
            this.jComboBoxDash.setSelectedIndex(2);
        } else {
            this.jComboBoxDash.setSelectedIndex(0);
        }
        this.jTextFieldradius.setText(String.valueOf((int)component.getHigh()));
        if (this.shapeType == ShapeEnum.L_ParallelLine) {
            this.comboBoxShape.SelectTextureFile = "L_ParallelLine";
            this.comboBoxShape.setComboBoxIndex();
        } else if (this.shapeType == ShapeEnum.L_ParallelCurve) {
            this.comboBoxShape.SelectTextureFile = "L_ParallelCurve";
            this.comboBoxShape.setComboBoxIndex();
        } else if (this.shapeType == ShapeEnum.R_ParallelLine) {
            this.comboBoxShape.SelectTextureFile = "R_ParallelLine";
            this.comboBoxShape.setComboBoxIndex();
        } else if (this.shapeType == ShapeEnum.R_ParallelCurve) {
            this.comboBoxShape.SelectTextureFile = "R_ParallelCurve";
            this.comboBoxShape.setComboBoxIndex();
        }
        if (component.fid != null && !component.fid.trim().equals("") && component.fid.trim() != null) {
            this.jTextFieldID.setText(component.fid);
            this.jTextFieldID.setForeground(Color.BLACK);
        }
        this.previewDraw();
    }

    public void previewDraw() {
        LinkedList<Component> componentList = new LinkedList<Component>();
        String name = "";
        name = " ";
        int iStart = 0;
        int iEnd = 0;
        int iHigh = 0;
        int icenter = 0;
        int iwidth = 0;
        icenter = Integer.parseInt(this.centerTextField.getText().trim());
        iwidth = (int)Double.parseDouble(this.widthTextField.getText().trim());
        iStart = icenter - iwidth / 2;
        iEnd = icenter + iwidth / 2;
        iHigh = (int)Double.parseDouble(this.jTextFieldradius.getText().trim());
        int strokesize = (Integer)this.jSpinnerStrokeSize.getValue();
        boolean iRotationAngle = false;
        String parameter = "Hide" + this.DELIMIT + "Hide" + this.DELIMIT + " " + this.DELIMIT + "Hide" + this.DELIMIT + "0" + this.DELIMIT + strokesize + this.DELIMIT + "Null" + this.DELIMIT + "00000_0.jpg";
        boolean bldash = false;
        boolean brdash = false;
        if (this.jComboBoxDash.getSelectedIndex() == 0) {
            bldash = false;
            brdash = false;
        } else if (this.jComboBoxDash.getSelectedIndex() == 1) {
            bldash = true;
            brdash = false;
        } else if (this.jComboBoxDash.getSelectedIndex() == 2) {
            bldash = false;
            brdash = true;
        }
        if (this.comboBoxShape.SelectTextureFile.equals("L_ParallelLine")) {
            this.shapeType = ShapeEnum.L_ParallelLine;
        } else if (this.comboBoxShape.SelectTextureFile.equals("L_ParallelCurve")) {
            this.shapeType = ShapeEnum.L_ParallelCurve;
        } else if (this.comboBoxShape.SelectTextureFile.equals("R_ParallelLine")) {
            this.shapeType = ShapeEnum.R_ParallelLine;
        } else if (this.comboBoxShape.SelectTextureFile.equals("R_ParallelCurve")) {
            this.shapeType = ShapeEnum.R_ParallelCurve;
        }
        Component domain = new Component(ComponentEnum.Domain, (double)iStart, (double)iEnd, parameter, Color.WHITE, Color.WHITE, this.colorLine.getBackground(), this.shapeType, (double)iHigh, (double)iRotationAngle, bldash, brdash, false, "id");
        componentList.add(domain);
        PreviewPanel.protein.setComponentList(componentList);
        this.previewPanel.repaint();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jLabel6 = new JLabel();
        this.jRadioButton3 = new JRadioButton();
        this.jLabel7 = new JLabel();
        this.jLabel9 = new JLabel();
        this.jLabel11 = new JLabel();
        this.previewPanel = new PreviewPanel();
        this.mainPanel = new JPanel();
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        this.jPanel2 = new JPanel();
        this.startLabel = new JLabel();
        this.centerTextField = new JTextField();
        this.jLabel12 = new JLabel();
        this.jLabel5 = new JLabel();
        this.endLabel = new JLabel();
        this.widthTextField = new JTextField();
        this.jLabel1 = new JLabel();
        this.jTextFieldradius = new JTextField();
        this.jPanel5 = new JPanel();
        this.jLabel2 = new JLabel();
        this.jSpinnerStrokeSize = new JSpinner();
        this.jLabel21 = new JLabel();
        this.colorLine = new JPanel();
        this.jPanel3 = new JPanel();
        this.jLabel4 = new JLabel();
        this.comboBoxShape = new CustomComboBoxDemo();
        this.jLabelProteinDash = new JLabel();
        this.jComboBoxDash = new JComboBox();
        this.jPanel4 = new JPanel();
        this.jLabel13 = new JLabel();
        this.jTextFieldID = new JTextField();
        this.jPanel1 = new JPanel();
        this.jLabelTip = new JLabel();
        this.jLabel6.setText("jLabel6");
        this.jRadioButton3.setText("Ellipse");
        this.jRadioButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CutLineDialog.this.jRadioButton3ActionPerformed(evt);
            }
        });
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(753, 355));
        this.setResizable(false);
        this.previewPanel.setBorder(BorderFactory.createTitledBorder(null, "Preview", 0, 0, new Font("Arial", 1, 14)));
        this.previewPanel.setMinimumSize(new Dimension(280, 240));
        this.previewPanel.setPreferredSize(new Dimension(280, 200));
        this.previewPanel.setLayout(new BorderLayout());
        this.getContentPane().add((java.awt.Component)this.previewPanel, "Center");
        this.mainPanel.setBorder(BorderFactory.createTitledBorder(null, "Option", 0, 0, new Font("Arial", 1, 14)));
        this.mainPanel.setMinimumSize(new Dimension(450, 200));
        this.mainPanel.setPreferredSize(new Dimension(450, 200));
        this.cancelButton.setFont(new Font("Arial", 1, 12));
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CutLineDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.okButton.setFont(new Font("Arial", 1, 12));
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CutLineDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(null, "Location", 0, 0, new Font("Arial", 1, 12)));
        this.jPanel2.setLayout(new GridLayout(2, 4, 10, 10));
        this.startLabel.setFont(new Font("Arial", 1, 12));
        this.startLabel.setHorizontalAlignment(4);
        this.startLabel.setText("Position");
        this.jPanel2.add(this.startLabel);
        this.centerTextField.setHorizontalAlignment(0);
        this.centerTextField.setText("10");
        this.jPanel2.add(this.centerTextField);
        this.jPanel2.add(this.jLabel12);
        this.jPanel2.add(this.jLabel5);
        this.endLabel.setFont(new Font("Arial", 1, 12));
        this.endLabel.setHorizontalAlignment(4);
        this.endLabel.setText("Width");
        this.endLabel.setToolTipText("");
        this.jPanel2.add(this.endLabel);
        this.widthTextField.setHorizontalAlignment(0);
        this.widthTextField.setText("5");
        this.widthTextField.addInputMethodListener(new InputMethodListener(){

            @Override
            public void caretPositionChanged(InputMethodEvent evt) {
            }

            @Override
            public void inputMethodTextChanged(InputMethodEvent evt) {
                CutLineDialog.this.widthTextFieldInputMethodTextChanged(evt);
            }
        });
        this.jPanel2.add(this.widthTextField);
        this.jLabel1.setFont(new Font("Arial", 1, 12));
        this.jLabel1.setHorizontalAlignment(4);
        this.jLabel1.setText("Height");
        this.jLabel1.setToolTipText("");
        this.jPanel2.add(this.jLabel1);
        this.jTextFieldradius.setHorizontalAlignment(0);
        this.jTextFieldradius.setText("5");
        this.jTextFieldradius.setToolTipText("");
        this.jTextFieldradius.addInputMethodListener(new InputMethodListener(){

            @Override
            public void caretPositionChanged(InputMethodEvent evt) {
            }

            @Override
            public void inputMethodTextChanged(InputMethodEvent evt) {
                CutLineDialog.this.jTextFieldradiusInputMethodTextChanged(evt);
            }
        });
        this.jPanel2.add(this.jTextFieldradius);
        this.jPanel5.setBorder(BorderFactory.createTitledBorder(null, "Border", 0, 0, new Font("Arial", 1, 12)));
        this.jPanel5.setLayout(new GridLayout(1, 4, 10, 10));
        this.jLabel2.setFont(new Font("Arial", 1, 12));
        this.jLabel2.setHorizontalAlignment(4);
        this.jLabel2.setText("Line Size");
        this.jPanel5.add(this.jLabel2);
        this.jSpinnerStrokeSize.setModel(new SpinnerNumberModel(1, 1, 2, 1));
        this.jPanel5.add(this.jSpinnerStrokeSize);
        this.jLabel21.setFont(new Font("Arial", 1, 12));
        this.jLabel21.setHorizontalAlignment(4);
        this.jLabel21.setText("Line Color");
        this.jPanel5.add(this.jLabel21);
        this.colorLine.setBackground(Color.black);
        this.colorLine.setBorder(BorderFactory.createBevelBorder(0));
        this.colorLine.setToolTipText("");
        this.colorLine.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                CutLineDialog.this.colorLineMousePressed(evt);
            }
        });
        this.jPanel5.add(this.colorLine);
        this.jPanel3.setBorder(BorderFactory.createTitledBorder(null, "Style", 0, 0, new Font("Arial", 1, 12)));
        this.jPanel3.setLayout(new GridLayout(1, 4, 10, 10));
        this.jLabel4.setFont(new Font("Arial", 1, 12));
        this.jLabel4.setHorizontalAlignment(4);
        this.jLabel4.setText("Parallel Line");
        this.jPanel3.add(this.jLabel4);
        this.jPanel3.add(this.comboBoxShape);
        this.jLabelProteinDash.setFont(new Font("Arial", 1, 12));
        this.jLabelProteinDash.setHorizontalAlignment(4);
        this.jLabelProteinDash.setText("Protein Dash");
        this.jPanel3.add(this.jLabelProteinDash);
        this.jComboBoxDash.setModel(new DefaultComboBoxModel<String>(new String[]{"None", "Left", "Right"}));
        this.jComboBoxDash.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CutLineDialog.this.jComboBoxDashActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.jComboBoxDash);
        this.jPanel4.setBorder(BorderFactory.createTitledBorder(null, "", 0, 0, new Font("Arial", 1, 12)));
        this.jLabel13.setFont(new Font("\u5b8b\u4f53", 1, 12));
        this.jLabel13.setHorizontalAlignment(4);
        this.jLabel13.setText("ID");
        this.jLabel13.setPreferredSize(new Dimension(50, 15));
        this.jPanel4.add(this.jLabel13);
        this.jTextFieldID.setForeground(new Color(255, 255, 255));
        this.jTextFieldID.setPreferredSize(new Dimension(250, 25));
        this.jTextFieldID.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                CutLineDialog.this.jTextFieldIDFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                CutLineDialog.this.jTextFieldIDFocusLost(evt);
            }
        });
        this.jTextFieldID.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                CutLineDialog.this.jTextFieldIDKeyPressed(evt);
            }
        });
        this.jPanel4.add(this.jTextFieldID);
        GroupLayout mainPanelLayout = new GroupLayout(this.mainPanel);
        this.mainPanel.setLayout(mainPanelLayout);
        mainPanelLayout.setHorizontalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addContainerGap().addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel4, -1, 418, Short.MAX_VALUE).addComponent(this.jPanel2, -1, 418, Short.MAX_VALUE).addComponent(this.jPanel3, -1, 418, Short.MAX_VALUE).addComponent(this.jPanel5, -1, 418, Short.MAX_VALUE)).addContainerGap()).addGroup(GroupLayout.Alignment.TRAILING, mainPanelLayout.createSequentialGroup().addComponent(this.cancelButton, -2, 89, -2).addGap(18, 18, 18).addComponent(this.okButton, -2, 89, -2).addGap(114, 114, 114)))));
        mainPanelLayout.setVerticalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, mainPanelLayout.createSequentialGroup().addComponent(this.jPanel4, -1, 46, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -2, 84, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel3, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel5, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton, -2, 25, -2).addComponent(this.okButton, -2, 25, -2)).addGap(30, 30, 30)));
        this.getContentPane().add((java.awt.Component)this.mainPanel, "East");
        this.jPanel1.setPreferredSize(new Dimension(700, 30));
        this.jLabelTip.setHorizontalAlignment(0);
        this.jLabelTip.setPreferredSize(new Dimension(700, 20));
        this.jPanel1.add(this.jLabelTip);
        this.getContentPane().add((java.awt.Component)this.jPanel1, "Last");
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.bModify = true;
        boolean isPositionValiable = new Verifier().verify(this.centerTextField);
        boolean isHeightValiable = new Verifier().verify(this.jTextFieldradius);
        boolean isWidthValiable = new Verifier().verify(this.widthTextField);
        boolean isStrokeSizeValiable = true;
        String name = " ";
        StringBuffer errorSb = new StringBuffer();
        if (!isPositionValiable) {
            errorSb.append("Position : should be a positive integer \n");
        }
        if (!isHeightValiable) {
            errorSb.append("Height : should be a positive integer \n");
        }
        if (!isStrokeSizeValiable) {
            errorSb.append("Stroke Size : should be a positive integer \n");
        }
        if (!isWidthValiable) {
            errorSb.append("Width : should be a positive integer \n");
        }
        if (isPositionValiable && isHeightValiable && isStrokeSizeValiable && isWidthValiable) {
            int iStart = 0;
            int iEnd = 0;
            int iHigh = 0;
            int icenter = 0;
            int iwidth = 0;
            icenter = Integer.parseInt(this.centerTextField.getText().trim());
            iwidth = (int)Double.parseDouble(this.widthTextField.getText().trim());
            iStart = icenter - iwidth / 2;
            iEnd = icenter + iwidth / 2;
            iHigh = (int)Double.parseDouble(this.jTextFieldradius.getText().trim());
            int strokesize = (Integer)this.jSpinnerStrokeSize.getValue();
            boolean iRotationAngle = false;
            String parameter = "Hide" + this.DELIMIT + "Hide" + this.DELIMIT + " " + this.DELIMIT + "Hide" + this.DELIMIT + "0" + this.DELIMIT + strokesize + this.DELIMIT + "Null" + this.DELIMIT + "00000_0.jpg";
            boolean bldash = false;
            boolean brdash = false;
            if (this.jComboBoxDash.getSelectedIndex() == 0) {
                bldash = false;
                brdash = false;
            } else if (this.jComboBoxDash.getSelectedIndex() == 1) {
                bldash = true;
                brdash = false;
            } else if (this.jComboBoxDash.getSelectedIndex() == 2) {
                bldash = false;
                brdash = true;
            }
            if (this.comboBoxShape.SelectTextureFile.equals("L_ParallelLine")) {
                this.shapeType = ShapeEnum.L_ParallelLine;
            } else if (this.comboBoxShape.SelectTextureFile.equals("L_ParallelCurve")) {
                this.shapeType = ShapeEnum.L_ParallelCurve;
            } else if (this.comboBoxShape.SelectTextureFile.equals("R_ParallelLine")) {
                this.shapeType = ShapeEnum.R_ParallelLine;
            } else if (this.comboBoxShape.SelectTextureFile.equals("R_ParallelCurve")) {
                this.shapeType = ShapeEnum.R_ParallelCurve;
            }
            String fid = "";
            fid = this.jTextFieldID.getText();
            this.component = new Component(ComponentEnum.CutLine, (double)iStart, (double)iEnd, parameter, Color.WHITE, Color.WHITE, this.colorLine.getBackground(), this.shapeType, (double)iHigh, (double)iRotationAngle, bldash, brdash, false, fid);
            this.component.setIsActive(true);
            this.component.setbSelected(true);
            this.dispose();
        } else {
            JOptionPane.showConfirmDialog(this, errorSb.toString(), "Properties Error", -1, 0, null);
        }
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jRadioButton3ActionPerformed(ActionEvent evt) {
    }

    private void widthTextFieldInputMethodTextChanged(InputMethodEvent evt) {
        this.previewDraw();
    }

    private void jTextFieldradiusInputMethodTextChanged(InputMethodEvent evt) {
        this.previewDraw();
    }

    private void colorLineMousePressed(MouseEvent evt) {
        final JColorChooser jColorChooser = new JColorChooser();
        jColorChooser.setColor(this.colorLine.getBackground());
        Tools.WindowCenter(JColorChooser.createDialog(this, "Color Choose", true, jColorChooser, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color color = jColorChooser.getColor();
                CutLineDialog.this.colorLine.setBackground(color);
                CutLineDialog.this.previewDraw();
            }
        }, null));
    }

    private void jComboBoxDashActionPerformed(ActionEvent evt) {
        this.previewDraw();
    }

    private void jTextFieldIDKeyPressed(KeyEvent evt) {
    }

    private void jTextFieldIDFocusGained(FocusEvent evt) {
    }

    private void jTextFieldIDFocusLost(FocusEvent evt) {
    }
}

