/*
 * Decompiled with CFR 0.152.
 */
package gui.ibs;

import gui.ibs.ToolOutPut;
import gui.ibs.WorkingModeDialog;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;

public class IBS {
    public static void main(String[] args) {
        if (args.length <= 0) {
            IBS.openframe();
        } else {
            if (args.length == 1 && (args[0].equals("-help") || args[0].equals("-h") || args[0].equals("-?"))) {
                System.out.println("   ******* 1. Export Images with a Configuration File **************  ");
                System.out.println("   Arguments:      ");
                System.out.println("        xmlpath: The directory that contains a set of IBS project files (xml format).");
                System.out.println("        picpath: The directory where you want to export the image to.");
                System.out.println("        format: The output format. The following formats are support ( case-insensitive ):");
                System.out.println("   \t\tA:JPG (72dpi),   ");
                System.out.println("   \t\tB:PNG (72dpi),    ");
                System.out.println("   \t\tC:TIFF (300dpi), ");
                System.out.println("   \t\tD:TIFF (600dpi),   ");
                System.out.println("   \t\tE:SVG (vector image) ");
                System.out.println("        unit: The unit type. Four unit types (pix, cm, mm, inch) are allowed.");
                System.out.println("        width: The width of the output image.");
                System.out.println("        heigh: The height of the output image.");
                System.out.println("        ratio: Whether to keep the ratio of width/height while exporting the image. TRUE/FALSE are allowed.");
                System.out.println("   Example (Config.txt): ");
                System.out.println("        xmlpath = demo/nucleotide");
                System.out.println("        picpath = output");
                System.out.println("        format = D");
                System.out.println("        unit = cm");
                System.out.println("        width = 18");
                System.out.println("        height = 14");
                System.out.println("        ratio = false");
                System.out.println("   Example: java -jar -Xmx 512m IBS.jar -c Config.txt");
                System.out.println("  ");
                System.out.println("   ******* 2. Export Image without Configuration File **************  ");
                System.out.println("   Arguments:      ");
                System.out.println("        -x: xml files directory   ");
                System.out.println("        -p: path of output images  ");
                System.out.println("        -f: output file type:     ");
                System.out.println("   \t\tA:JPG (72dpi),   ");
                System.out.println("   \t\tB:PNG (72dpi),    ");
                System.out.println("   \t\tC:TIFF (300dpi), ");
                System.out.println("   \t\tD:TIFF (600dpi),   ");
                System.out.println("   \t\tE:SVG (vector image)   ");
                System.out.println("        -u: unit : pix,cm,mm,inch; ");
                System.out.println("        -w: width of the output figure    ");
                System.out.println("        -h: height of the output figure   ");
                System.out.println("        -r: keep the ratio of width/height: TRUE/FALSE  ");
                System.out.println("   Example:  java -jar -Xmx512m  IBS.jar -x d:/demo/nucleotide ");
                System.out.println("             -p d:/demo/output  -f D  -u pix -w 800 -h 600 -r true");
                System.out.println("   **************************************************************  ");
                return;
            }
            if (args.length == 2 && args[0].trim().toLowerCase().equals("-c")) {
                ToolOutPut op = new ToolOutPut();
                String[] batcharg = op.readConfig(args[1].trim().toLowerCase());
                if (batcharg != null) {
                    ToolOutPut.batchoutput(batcharg, null);
                }
            } else {
                ToolOutPut op = new ToolOutPut();
                ToolOutPut.batchoutput(args, null);
            }
        }
    }

    public static void openframe() {
        WorkingModeDialog dialog = new WorkingModeDialog((Frame)new JFrame(), true);
        dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        dialog.show();
    }
}

