/*
 * Decompiled with CFR 0.152.
 */
package gui.ibs;

import com.install4j.api.launcher.ApplicationLauncher;
import gui.AcknowledgementDialog;
import gui.CitationDialog;
import gui.ContactDialog;
import gui.Filter;
import gui.ProductDialog;
import gui.Tools;
import gui.ibs.Area;
import gui.ibs.BatchOutputJDialog;
import gui.ibs.BracketDialog;
import gui.ibs.CanvasPanel;
import gui.ibs.CanvasSizeDialog;
import gui.ibs.Component;
import gui.ibs.ComponentEnum;
import gui.ibs.CutLineDialog;
import gui.ibs.DemoFrame;
import gui.ibs.EditDialog;
import gui.ibs.ImageFormatDialog;
import gui.ibs.LineDialog;
import gui.ibs.NoteDialog;
import gui.ibs.NucleotideDomainDialog;
import gui.ibs.OutputJDialog;
import gui.ibs.PolygonDialog;
import gui.ibs.PreviewPanel;
import gui.ibs.Project;
import gui.ibs.Project2XML;
import gui.ibs.Protein;
import gui.ibs.ProteinDialog;
import gui.ibs.ProteinDomainDialog;
import gui.ibs.ResourceBundleUtil;
import gui.ibs.ShapeEnum;
import gui.ibs.SiteDialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class IBSFrame
extends JFrame
implements DropTargetListener {
    public int currentindexrate = 4;
    public static final String DELIMIT = "#&%";
    private String TITLE = "IBS 1.0.2";
    private String filePath = "";
    public CanvasPanel canvasPanel = new CanvasPanel();
    public static DefaultListModel listModel = new DefaultListModel();
    public boolean bSelected = false;
    public Point2D.Double dStartSelect;
    public Point2D.Double dEndSelect;
    public LinkedList<Protein> selectProtein = new LinkedList();
    public ImageIcon[] images;
    public ImageIcon[] imagesShape;
    public ImageIcon[] imagesShapeSite;
    public ImageIcon[] imagesGradient;
    public ImageIcon[] imagesShapeMarker;
    public ImageIcon[] imagesShapeCutLine;
    public static String mode = "";
    ResourceBundleUtil config;
    public boolean isOpening = false;
    private JMenuItem aboutMenuItem;
    private JMenuItem acknowMenuItem;
    private JMenuItem addDomainMenuItem;
    private JMenuItem addLineMenuItem;
    private JMenu addMenu;
    private JMenuItem addNoteMenuItem;
    private JMenuItem addProteinMenuItem;
    private JMenuItem addSiteMenuItem;
    private JMenuItem batchExportMenuItem;
    private JMenuItem canvasMenuItem;
    public static JScrollPane canvasScrollPane;
    private JMenuItem canvasSizeMenuItem;
    private JMenuItem citationMenuItem;
    private JScrollPane componentScrollPane;
    private JPanel consolePanel;
    private JMenuItem contactMenuItem;
    private JButton cutLineButton;
    private JButton cutLineButton1;
    private JMenuItem deleteCanvasMenuItem;
    private JMenuItem deleteMenuItem;
    private JMenuItem demoMenuItem;
    private JButton domainButton;
    private JMenuItem domainMenuItem;
    private JMenuItem duplicateCanvasMenuItem;
    private JMenuItem duplicateMenuItem;
    private JMenuItem editComponentMenuItem;
    private JMenu editMenu;
    private JMenuItem editMenuItem;
    private JMenuItem exitMenuItem;
    private JMenuItem exportImageMenuItem;
    private JMenuItem exportMenuItem;
    private JMenu fileMenu;
    private JMenuItem fitWidthMenuItem;
    private JMenuItem formatMenuItem;
    private JMenu helpMenu;
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButtonBezier;
    private JButton jButtonBracket;
    private JButton jButtonCurve;
    private JButton jButtonPolylineOne;
    private JButton jButtonPolylineTwo;
    public JButton jButtonSelectRedo;
    public JButton jButtonSelectUndo;
    private JButton jButtonStraight;
    private JCheckBox jCheckBoxGray;
    public JComboBox jComboBoxScale;
    private JLabel jLabel1;
    private JMenu jMenu1;
    private JMenuItem jMenuItem1;
    private JMenuItem jMenuItem2;
    private JMenuItem jMenuItem3;
    private JMenuItem jMenuItem4;
    private JMenuItem jMenuItem5;
    private JMenuItem jMenuItem6;
    private JMenuItem jMenuItem7;
    private JMenuItem jMenuItem8;
    public JMenuItem jMenuItemRedo;
    public JMenuItem jMenuItemUndo;
    private JSeparator jSeparator1;
    private JPopupMenu.Separator jSeparator2;
    private JPopupMenu.Separator jSeparator3;
    private JToolBar.Separator jSeparator4;
    private JPopupMenu.Separator jSeparator5;
    private JToolBar jToolBar1;
    private JMenuItem lineMenuItem;
    private JList list;
    private JPanel mainPanel;
    private JMenuBar menuBar;
    private JMenuItem moveDownMenuItem;
    private JMenuItem moveDownMenuItem1;
    private JMenuItem moveEndMenuItem;
    private JMenuItem moveEndMenuItem1;
    private JMenu moveMenu;
    private JMenu moveMenu1;
    private JMenuItem moveTopMenuItem;
    private JMenuItem moveTopMenuItem1;
    private JMenuItem moveUpMenuItem;
    private JMenuItem moveUpMenuItem1;
    private JMenuItem newMenuItem;
    private JMenuItem noteMenuItem;
    private JMenuItem openMenuItem;
    private JPopupMenu panelMenu;
    private JPopupMenu popupMenu;
    private JButton proteinButton;
    private JMenuItem proteinMenuItem;
    private JMenuItem saveAsMenuItem;
    private JMenuItem saveMenuItem;
    private JMenuItem saveProjectMenuItem;
    private JButton siteButton;
    private JMenuItem siteMenuItem;
    private JMenu toolsMenu;
    private JMenuItem updateMenuItem;
    private JMenuItem zoomInMenuItem;
    private JMenuItem zoomOutMenuItem;

    public String getMode() {
        return mode;
    }

    public void setMode(String mode) {
        IBSFrame.mode = mode;
    }

    public ImageIcon[] getImagesShapeCutLine() {
        return this.imagesShapeCutLine;
    }

    public void setImagesShapeCutLine(ImageIcon[] imagesShapeCutLine) {
        this.imagesShapeCutLine = imagesShapeCutLine;
    }

    public ImageIcon[] getImagesShapeMarker() {
        return this.imagesShapeMarker;
    }

    public void setImagesShapeMarker(ImageIcon[] imagesShapeMarker) {
        this.imagesShapeMarker = imagesShapeMarker;
    }

    public ImageIcon[] getImagesGradient() {
        return this.imagesGradient;
    }

    public void setImagesGradient(ImageIcon[] imagesGradient) {
        this.imagesGradient = imagesGradient;
    }

    public ImageIcon[] getImagesShape() {
        return this.imagesShape;
    }

    public void setImagesShape(ImageIcon[] imagesShape) {
        this.imagesShape = imagesShape;
    }

    public ImageIcon[] getImagesShapeSite() {
        return this.imagesShapeSite;
    }

    public void setImagesShapeSite(ImageIcon[] imagesShapeSite) {
        this.imagesShapeSite = imagesShapeSite;
    }

    public Point2D.Double getdEndSelect() {
        return this.dEndSelect;
    }

    public void setdEndSelect(Point2D.Double dEndSelect) {
        this.dEndSelect = dEndSelect;
    }

    public Point2D.Double getdStartSelect() {
        return this.dStartSelect;
    }

    public void setdStartSelect(Point2D.Double dStartSelect) {
        this.dStartSelect = dStartSelect;
    }

    public LinkedList<Protein> getSelectProtein() {
        return this.selectProtein;
    }

    public void setSelectProtein(LinkedList<Protein> selectProtein) {
        this.selectProtein = selectProtein;
    }

    public ImageIcon[] getImages() {
        return this.images;
    }

    public void setImages(ImageIcon[] images) {
        this.images = images;
    }

    public IBSFrame(String fmode) {
        mode = fmode;
        this.setPreferredSize(new Dimension(1020, 760));
        this.config = ResourceBundleUtil.getBundle("gui.ibs.config");
        this.initComponents();
        this.canvasPanel.Mode = fmode;
        if (mode.equals("P")) {
            this.proteinButton.setText("Protein");
            this.jMenuItem2.setEnabled(false);
            this.jMenuItem1.setEnabled(true);
            this.proteinMenuItem.setText("Add Protein");
        } else {
            this.proteinButton.setText("Nucleotide");
            this.jMenuItem1.setEnabled(false);
            this.jMenuItem2.setEnabled(true);
            this.proteinMenuItem.setText("Add Nucleotide");
        }
        this.canvasPanel.setPanelSize(800, 600);
        this.canvasPanel.setWHRatio();
        this.setCanvasSize();
        this.setExtendedState(6);
        new DropTarget(this, 3, this);
    }

    public IBSFrame(String filePath, String fmode) {
        mode = fmode;
        this.setPreferredSize(new Dimension(1020, 760));
        this.filePath = filePath;
        this.config = ResourceBundleUtil.getBundle("gui.ibs.config");
        this.initComponents();
        this.canvasPanel.Mode = fmode;
        if (mode.equals("P")) {
            this.proteinButton.setText("Protein");
            this.jMenuItem2.setEnabled(false);
            this.jMenuItem1.setEnabled(true);
        } else {
            this.proteinButton.setText("Nucleotide");
            this.jMenuItem1.setEnabled(false);
            this.jMenuItem2.setEnabled(true);
        }
        Project project = new Project2XML(filePath).open(mode);
        this.drawPanel(project, filePath);
        this.canvasPanel.setPanelSize(800, 600);
        this.canvasPanel.setWHRatio();
        this.setCanvasSize();
        this.setExtendedState(6);
    }

    public double getRelaRate(double rateIn) {
        int i;
        int itemCount = this.jComboBoxScale.getItemCount();
        double[] rateL = new double[itemCount];
        for (i = 0; i < itemCount; ++i) {
            String strRate = this.jComboBoxScale.getItemAt(i).toString();
            strRate = strRate.substring(0, strRate.length() - 1);
            rateL[i] = (double)Float.valueOf(strRate).floatValue() / 100.0;
        }
        for (i = 0; i < itemCount; ++i) {
            if (rateL[i] == rateIn) {
                this.jComboBoxScale.setSelectedIndex(i);
                return rateL[i];
            }
            if (i == 0) continue;
            if (rateL[i] >= rateIn && rateL[i - 1] < rateIn) {
                this.jComboBoxScale.setSelectedIndex(i - 1);
                return rateL[i - 1];
            }
            if (!(rateL[i] > rateIn) || i != itemCount - 1) continue;
            this.jComboBoxScale.setSelectedIndex(i);
            return rateL[i];
        }
        return 1.0;
    }

    private void drawPanel(Project project, String filePath) {
        LinkedList<Protein> proteinList;
        if (project != null && (proteinList = project.getProteinList()).size() != 0) {
            this.setTitle(this.TITLE + " - " + filePath);
            this.canvasPanel.setPanelSize(project.getWidth(), project.getHeight(), project.getRate());
            this.canvasPanel.setWHRatio();
            this.canvasPanel.setProteinList(project.getProteinList());
            this.canvasPanel.repaint();
            this.repaintList();
        }
        this.canvasPanel.adjustToCenter();
    }

    private void repaintList() {
        listModel.clear();
        LinkedList<Protein> proteinList = this.canvasPanel.getProteinList();
        int k = 1;
        for (Protein protein : proteinList) {
            listModel.addElement(IBSFrame.getListElement(protein, k));
            LinkedList<Component> componentList = protein.getComponentList();
            int p = 1;
            for (Component component : componentList) {
                listModel.addElement(IBSFrame.getListElement(component, p));
                ++p;
            }
            ++k;
        }
    }

    public static String getListElement(Protein protein, int k) {
        Color color = protein.getColor();
        String RGB = "rgb(" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + ")";
        String parameter = "";
        StringTokenizer st = new StringTokenizer(protein.getParameter(), DELIMIT);
        parameter = st.nextToken();
        st.nextToken();
        parameter = parameter + ";" + st.nextToken();
        st.nextToken();
        st.nextToken();
        st.nextToken();
        st.nextToken();
        st.nextToken();
        st.nextToken();
        st.nextToken();
        st.nextToken();
        String sid = st.nextToken().trim();
        if (sid == null) {
            sid = "";
        }
        String element = !sid.equals("") ? (mode.equals("P") ? "<html><font color=rgb(" + RGB + ")>" + (Object)((Object)ComponentEnum.Protein) + "-" + k + ": " + sid + "<font></html>" : "<html><font color=rgb(" + RGB + ")>" + "Nucleotide-" + k + ": " + sid + "<font></html>") : (mode.equals("P") ? "<html><font color=rgb(" + RGB + ")>" + (Object)((Object)ComponentEnum.Protein) + "-" + k + "<font></html>" : "<html><font color=rgb(" + RGB + ")>" + "Nucleotide-" + k + "<font></html>");
        return element;
    }

    public static String getListElement(Component component, int k) {
        ShapeEnum shapeType;
        String name;
        Color color = component.getColor();
        String RGB = "rgb(" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + ")";
        if (component.getColor() == Color.WHITE) {
            RGB = "rgb(0,0,0)";
        }
        String parameter = "";
        String[] arr = component.getParameter().split(DELIMIT);
        String stype = "";
        if (component.getType() == ComponentEnum.Protein) {
            String start = arr[0];
            String end = arr[1];
            parameter = start + ";" + end;
            stype = mode.equals("P") ? "Protein" : "Nucleotide";
        } else if (component.getType() == ComponentEnum.Domain) {
            name = arr[2];
            parameter = component.getX() + ";" + component.getX2() + ";" + name;
            shapeType = component.getShapeType();
            stype = component.getType().toString();
        } else if (component.getType() == ComponentEnum.CutLine) {
            name = arr[2];
            parameter = component.getX() + ";" + component.getX2() + ";" + name;
            shapeType = component.getShapeType();
            stype = "CutLine";
            RGB = "rgb(0,0,0)";
        } else if (component.getType() == ComponentEnum.Site) {
            String site = arr[0];
            String text = arr[1];
            parameter = site + ";" + text;
            stype = component.getType().toString();
        } else if (component.getType() == ComponentEnum.Note) {
            parameter = arr[0];
            stype = component.getType().toString();
        } else if (component.getType() == ComponentEnum.Line) {
            parameter = (int)component.getX() + "," + component.getY() + ") - (" + (int)component.getX2() + "," + component.getY2();
            stype = component.getType().toString();
        } else if (component.getType() == ComponentEnum.Polygon) {
            name = arr[2];
            parameter = (int)component.getCenterx() + ";" + (int)component.getCentery() + ";" + name;
            stype = "Marker";
        } else if (component.getType() == ComponentEnum.Bracket) {
            parameter = (int)component.getCenterx() + ";" + (int)component.getCentery() + ";" + (int)component.getWide();
            stype = component.getType().toString();
        }
        String sid = component.fid;
        if (sid == null) {
            sid = "";
        }
        String element = !sid.equals("") ? "<html><font color=rgb(" + RGB + ")>>>" + stype.trim() + "-" + k + ": " + sid + " <font></html>" : "<html><font color=rgb(" + RGB + ")>>>" + stype.trim() + "-" + k + " <font></html>";
        return element;
    }

    private void addComponent(EditDialog dialog) {
        for (int i = 0; i < this.canvasPanel.getProteinList().size(); ++i) {
            Protein protein = this.canvasPanel.getProteinList().get(i);
            protein.setIsActive(false);
        }
        Protein protein = this.canvasPanel.getCurrentProtein();
        Tools.WindowCenter(dialog);
        if (dialog.getComponent() != null) {
            Component component;
            this.canvasPanel.ComponentSelect = component = dialog.getComponent();
            if (component.getType() == ComponentEnum.Site) {
                String parameter = component.getParameter();
                StringTokenizer ster = new StringTokenizer(parameter, DELIMIT);
                String positions = ster.nextToken();
                StringTokenizer st = new StringTokenizer(positions, ";");
                int siteCount = st.countTokens();
                int deltaX = 0;
                if (siteCount == 1) {
                    int site;
                    deltaX = site = Integer.parseInt(st.nextToken());
                } else if (siteCount == 2) {
                    int centralSite;
                    LinkedList<Integer> siteList = new LinkedList<Integer>();
                    for (int i = 0; i < siteCount; ++i) {
                        siteList.add(Integer.parseInt(st.nextToken()));
                    }
                    Collections.sort(siteList);
                    int firstSite = Integer.parseInt(String.valueOf(siteList.getFirst()));
                    int lastSite = Integer.parseInt(String.valueOf(siteList.getLast()));
                    deltaX = centralSite = (firstSite + lastSite) / 2;
                } else {
                    int centralSite;
                    LinkedList<Integer> siteList = new LinkedList<Integer>();
                    for (int i = 0; i < siteCount; ++i) {
                        siteList.add(Integer.parseInt(st.nextToken()));
                    }
                    Collections.sort(siteList);
                    deltaX = centralSite = (Integer.parseInt(String.valueOf(siteList.getFirst())) + Integer.parseInt(String.valueOf(siteList.getLast()))) / 2;
                }
                component.setX(deltaX);
            } else if (component.getType() != ComponentEnum.Note) {
                if (component.getType() == ComponentEnum.Domain) {
                    this.canvasPanel.ddc.initDialog = false;
                    this.canvasPanel.ddc.iheight = (int)component.getHigh();
                    this.canvasPanel.ddc.iwidth = (int)(component.getX2() - component.getX());
                } else if (component.getType() == ComponentEnum.CutLine) {
                    this.canvasPanel.ddc.initDialog = false;
                    this.canvasPanel.ddc.iheight = (int)component.getHigh();
                    this.canvasPanel.ddc.iwidth = (int)(component.getX2() - component.getX());
                }
            }
            protein.getComponentList().add(component);
            this.canvasPanel.repaint();
            this.repaintList();
        }
    }

    private Protein getIndexProtein(int index) {
        int count = 0;
        LinkedList<Protein> proteinList = this.canvasPanel.getProteinList();
        Protein selectedProtein = proteinList.getFirst();
        for (int i = 0; i < proteinList.size(); ++i) {
            Protein protein = proteinList.get(i);
            if (index == count) {
                protein.setSelectNum(-1);
                selectedProtein = protein;
                break;
            }
            ++count;
            boolean isContained = false;
            LinkedList<Component> componentList = protein.getComponentList();
            for (int j = 0; j < componentList.size(); ++j) {
                if (index == count) {
                    protein.setSelectNum(j);
                    isContained = true;
                    selectedProtein = protein;
                    break;
                }
                ++count;
            }
            if (isContained) break;
        }
        return selectedProtein;
    }

    private void callEditDialog() {
        int selectedIndex = this.list.getSelectedIndex();
        LinkedList<Protein> proteinList = this.canvasPanel.getProteinList();
        int count = 0;
        block6: for (Protein protein : proteinList) {
            if (count > selectedIndex) break;
            if (selectedIndex == count) {
                ProteinDialog pd;
                String strNum;
                if (mode.equals("P")) {
                    strNum = this.getDefaultID("Protein");
                    pd = new ProteinDialog(this, "Edit Protein", true, this.images, this.imagesGradient, mode, strNum);
                } else {
                    strNum = this.getDefaultID("Nucleotide");
                    pd = new ProteinDialog(this, "Edit Nucleotide", true, this.images, this.imagesGradient, mode, strNum);
                }
                pd.setProtein(protein);
                Tools.WindowCenter(pd);
                if (pd.getProtein() == null) break;
                protein.setVertical(pd.getProtein().getVertical());
                protein.setHorizontal(pd.getProtein().getHorizontal());
                protein.setLocked(pd.getProtein().isLocked());
                protein.setParameter(pd.getProtein().getParameter());
                protein.setColor(pd.getProtein().getColor());
                protein.setEnd(pd.getProtein().getEnd());
                protein.setArea(pd.getProtein().getArea());
                this.canvasPanel.repaint();
                this.repaintList();
                if (!pd.bModify) break;
                try {
                    this.canvasPanel.saveCurrentState();
                }
                catch (CloneNotSupportedException ex) {
                    ex.printStackTrace();
                }
                break;
            }
            ++count;
            LinkedList<Component> componentList = protein.getComponentList();
            String[] arrPro = protein.getParameter().split(DELIMIT);
            int proteinStart = Integer.parseInt(arrPro[0]);
            int proteinEnd = Integer.parseInt(arrPro[2]);
            double proteinlen = proteinEnd - proteinStart;
            for (int i = 0; i < componentList.size(); ++i) {
                Component component = componentList.get(i);
                if (selectedIndex == count) {
                    String strNum;
                    int proteinlenth;
                    EditDialog dialog = null;
                    EditDialog dialogN = null;
                    if (component.getType() == ComponentEnum.Domain) {
                        proteinlenth = this.canvasPanel.getCurrentProtein().getEnd();
                        strNum = this.getDefaultID(ComponentEnum.Domain.name());
                        if (mode.equals("P")) {
                            dialog = new ProteinDomainDialog(this, " Edit Domain", true, this.images, this.imagesGradient, proteinlenth, strNum);
                        } else {
                            dialogN = new NucleotideDomainDialog(this, " Edit Domain", true, this.images, this.imagesShape, this.imagesGradient, strNum);
                        }
                    }
                    if (component.getType() == ComponentEnum.CutLine) {
                        String strNum2 = this.getDefaultID(ComponentEnum.CutLine.name());
                        dialog = new CutLineDialog(this, " Edit CutLine", this.imagesShapeCutLine, true, mode, strNum2);
                    } else if (component.getType() == ComponentEnum.Site) {
                        String strNum3 = this.getDefaultID(ComponentEnum.Site.name());
                        dialog = new SiteDialog(this, " Edit Site", true, this.images, this.imagesShapeSite, this.imagesGradient, strNum3);
                    } else if (component.getType() == ComponentEnum.Note) {
                        String strNum4 = this.getDefaultID(ComponentEnum.Note.name());
                        dialog = new NoteDialog((Frame)this, " Edit Note", true, strNum4);
                    } else if (component.getType() == ComponentEnum.Line) {
                        proteinlenth = this.canvasPanel.getCurrentProtein().getEnd();
                        strNum = this.getDefaultID(ComponentEnum.Line.name());
                        dialog = new LineDialog(this, " Edit Line :" + component.getShapeType().name(), true, component.getShapeType(), component.getControlx1(), component.getControly1(), component.getControlx2(), component.getControly2(), proteinlenth, strNum);
                    } else if (component.getType() == ComponentEnum.Polygon) {
                        String strNum5 = this.getDefaultID(ComponentEnum.Polygon.name());
                        dialog = new PolygonDialog(this, "Edit Marker", true, this.images, this.imagesShapeMarker, this.imagesGradient, strNum5);
                    } else if (component.getType() == ComponentEnum.Bracket) {
                        proteinlenth = this.canvasPanel.getCurrentProtein().getEnd();
                        strNum = this.getDefaultID(ComponentEnum.Bracket.name());
                        dialog = new BracketDialog(this, "Edit Bracket", true, proteinlenth, strNum);
                    }
                    if (dialog != null) {
                        dialog.setComponent(component);
                        Tools.WindowCenter(dialog);
                        if (dialog.getComponent() != null) {
                            component = dialog.getComponent();
                            protein.getComponentList().set(i, component);
                            this.canvasPanel.repaint();
                            this.repaintList();
                            if (dialog.bModify) {
                                try {
                                    this.canvasPanel.saveCurrentState();
                                }
                                catch (CloneNotSupportedException ex) {
                                    ex.printStackTrace();
                                }
                            }
                        }
                    } else {
                        dialogN.setComponent(component);
                        Tools.WindowCenter(dialogN);
                        if (dialogN.getComponent() != null) {
                            component = dialogN.getComponent();
                            protein.getComponentList().set(i, component);
                            this.canvasPanel.repaint();
                            this.repaintList();
                            if (dialogN.bModify) {
                                try {
                                    this.canvasPanel.saveCurrentState();
                                }
                                catch (CloneNotSupportedException ex) {
                                    ex.printStackTrace();
                                }
                            }
                        }
                    }
                } else if (count > selectedIndex) continue block6;
                ++count;
            }
        }
    }

    private void selectComponent() {
        Component component;
        int i;
        LinkedList<Component> componentList;
        int selectedIndex = this.list.getSelectedIndex();
        LinkedList<Protein> proteinList = this.canvasPanel.getProteinList();
        int count = 0;
        for (Protein protein : proteinList) {
            protein.setIsActive(false);
            componentList = protein.getComponentList();
            for (i = 0; i < componentList.size(); ++i) {
                component = componentList.get(i);
                component.setIsActive(false);
                component.setbSelected(false);
            }
        }
        block2: for (Protein protein : proteinList) {
            protein.setIsActive(false);
            if (count > selectedIndex) break;
            if (selectedIndex == count) {
                protein.setIsActive(true);
                this.canvasPanel.repaint();
                break;
            }
            ++count;
            componentList = protein.getComponentList();
            for (i = 0; i < componentList.size(); ++i) {
                component = componentList.get(i);
                if (selectedIndex == count) {
                    component.setIsActive(true);
                    component.setbSelected(true);
                    this.canvasPanel.repaint();
                } else if (count > selectedIndex) continue block2;
                ++count;
            }
        }
    }

    private void activeProtein(int selectedNum) {
        int listNum = 0;
        LinkedList<Protein> proteinList = this.canvasPanel.getProteinList();
        for (int i = 0; i < proteinList.size(); ++i) {
            Protein protein = proteinList.get(i);
            if ((listNum = listNum + 1 + protein.getComponentList().size()) < selectedNum) continue;
            this.canvasPanel.setCurrentProteinNum(i);
            this.canvasPanel.setCurrentVertical(protein.getVertical());
        }
    }

    private void activeProtein(int x, int y) {
        int listNum = 0;
        LinkedList<Protein> proteinList = this.canvasPanel.getProteinList();
        try {
            for (int i = 0; i < proteinList.size(); ++i) {
                Rectangle rect;
                Protein protein = proteinList.get(i);
                boolean isContained = false;
                boolean isInsideComponent = false;
                if (protein.getArea().isInside(x, y)) {
                    isContained = true;
                }
                int componentNum = 0;
                LinkedList<Component> componentList = protein.getComponentList();
                for (int j = 0; j < componentList.size(); ++j) {
                    Component component = componentList.get(j);
                    if (!component.bSelected) continue;
                    isInsideComponent = true;
                    componentNum = j;
                    isContained = true;
                    break;
                }
                if (isInsideComponent) {
                    listNum = listNum + 1 + componentNum;
                    this.canvasPanel.setCurrentProteinNum(i);
                    this.canvasPanel.setCurrentVertical(protein.getVertical());
                    PreviewPanel.protein = (Protein)protein.clone();
                    this.list.setSelectedIndex(listNum);
                    JViewport viewport = this.componentScrollPane.getViewport();
                    rect = this.list.getCellBounds(listNum, listNum);
                    Rectangle viewRect = viewport.getViewRect();
                    rect.setLocation(rect.x - viewRect.x, rect.y - viewRect.y);
                    viewport.scrollRectToVisible(rect);
                    break;
                }
                if (isContained) {
                    this.canvasPanel.setCurrentProteinNum(i);
                    this.canvasPanel.setCurrentVertical(protein.getVertical());
                    PreviewPanel.protein = (Protein)protein.clone();
                    this.list.setSelectedIndex(listNum);
                    JViewport viewport = this.componentScrollPane.getViewport();
                    rect = this.list.getCellBounds(listNum, listNum);
                    Rectangle viewRect = viewport.getViewRect();
                    rect.setLocation(rect.x - viewRect.x, rect.y - viewRect.y);
                    viewport.scrollRectToVisible(rect);
                    break;
                }
                listNum = listNum + 1 + componentList.size();
            }
        }
        catch (CloneNotSupportedException ex) {
            Logger.getLogger(IBSFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private Area getLineArea(Component component) {
        Area area = component.getArea();
        Area tempArea = new Area(area.getX1(), area.getY1(), area.getX2(), area.getY2());
        if (Math.abs(area.getY1() - area.getY2()) < 30.0) {
            tempArea = area.getY1() > area.getY2() ? new Area(area.getX1(), area.getY1() + 15.0, area.getX2(), area.getY2() - 15.0) : new Area(area.getX1(), area.getY1() - 15.0, area.getX2(), area.getY2() + 15.0);
        } else if (Math.abs(area.getX1() - area.getX2()) < 30.0) {
            tempArea = area.getX1() > area.getX2() ? new Area(area.getX1() + 15.0, area.getY1(), area.getX2() - 15.0, area.getY2()) : new Area(area.getX1() - 15.0, area.getY1(), area.getX2() + 15.0, area.getY2());
        }
        return tempArea;
    }

    private void callEditDialog(int x, int y) {
        LinkedList<Protein> proteinList = this.canvasPanel.getProteinList();
        for (Protein protein : proteinList) {
            boolean isContained = false;
            LinkedList<Component> componentList = protein.getComponentList();
            for (int i = componentList.size() - 1; i >= 0; --i) {
                String strNum;
                int proteinlenth;
                Component component = componentList.get(i);
                Area area = component.getArea();
                java.awt.geom.Area GeomArea = component.getGeomArea();
                boolean inside = false;
                if (GeomArea != null) {
                    if (GeomArea.contains(x, y)) {
                        inside = true;
                    }
                } else if (area.isInside(x, y)) {
                    inside = true;
                }
                if (!inside) continue;
                isContained = true;
                EditDialog dialog = null;
                EditDialog dialogN = null;
                if (component.getType() == ComponentEnum.Domain) {
                    proteinlenth = this.canvasPanel.getCurrentProtein().getEnd();
                    strNum = this.getDefaultID(ComponentEnum.Domain.name());
                    if (mode.equals("P")) {
                        dialog = new ProteinDomainDialog(this, " Edit Domain", true, this.images, this.imagesGradient, proteinlenth, strNum);
                    } else {
                        dialogN = new NucleotideDomainDialog(this, " Edit Domain", true, this.images, this.imagesShape, this.imagesGradient, strNum);
                    }
                }
                if (component.getType() == ComponentEnum.CutLine) {
                    String strNum2 = this.getDefaultID(ComponentEnum.CutLine.name());
                    dialog = new CutLineDialog(this, " Edit CutLine", this.imagesShapeCutLine, true, mode, strNum2);
                } else if (component.getType() == ComponentEnum.Site) {
                    String strNum3 = this.getDefaultID(ComponentEnum.Site.name());
                    dialog = new SiteDialog(this, " Edit Site", true, this.images, this.imagesShapeSite, this.imagesGradient, strNum3);
                } else if (component.getType() == ComponentEnum.Note) {
                    String strNum4 = this.getDefaultID(ComponentEnum.Note.name());
                    dialog = new NoteDialog((Frame)this, " Edit Note", true, strNum4);
                } else if (component.getType() == ComponentEnum.Line) {
                    proteinlenth = this.canvasPanel.getCurrentProtein().getEnd();
                    strNum = this.getDefaultID(ComponentEnum.Line.name());
                    dialog = new LineDialog(this, " Edit Line :" + component.getShapeType().name(), true, component.getShapeType(), component.getControlx1(), component.getControly1(), component.getControlx2(), component.getControly2(), proteinlenth, strNum);
                } else if (component.getType() == ComponentEnum.Polygon) {
                    String strNum5 = this.getDefaultID(ComponentEnum.Polygon.name());
                    dialog = new PolygonDialog(this, " Marker", true, this.images, this.imagesShapeMarker, this.imagesGradient, strNum5);
                } else if (component.getType() == ComponentEnum.Bracket) {
                    proteinlenth = this.canvasPanel.getCurrentProtein().getEnd();
                    strNum = this.getDefaultID(ComponentEnum.Bracket.name());
                    dialog = new BracketDialog(this, " Bracket", true, proteinlenth, strNum);
                }
                if (dialog != null) {
                    dialog.setComponent(component);
                    Tools.WindowCenter(dialog);
                    if (dialog.getComponent() == null) break;
                    component = dialog.getComponent();
                    protein.getComponentList().set(i, component);
                    this.canvasPanel.ddc.initDialog = false;
                    this.canvasPanel.ddc.iheight = (int)component.getHigh();
                    this.canvasPanel.ddc.iwidth = (int)(component.getX2() - component.getX());
                    this.canvasPanel.repaint();
                    this.repaintList();
                    if (!dialog.bModify) break;
                    try {
                        this.canvasPanel.saveCurrentState();
                    }
                    catch (CloneNotSupportedException ex) {
                        ex.printStackTrace();
                    }
                    break;
                }
                dialogN.setComponent(component);
                Tools.WindowCenter(dialogN);
                if (dialogN.getComponent() == null) break;
                component = dialogN.getComponent();
                protein.getComponentList().set(i, component);
                this.canvasPanel.ddc.initDialog = false;
                this.canvasPanel.ddc.iheight = (int)component.getHigh();
                this.canvasPanel.ddc.iwidth = (int)(component.getX2() - component.getX());
                this.canvasPanel.repaint();
                this.repaintList();
                if (!dialogN.bModify) break;
                try {
                    this.canvasPanel.saveCurrentState();
                }
                catch (CloneNotSupportedException ex) {
                    ex.printStackTrace();
                }
                break;
            }
            if (!isContained && protein.getArea().isInside(x, y)) {
                ProteinDialog pd;
                String strNum;
                if (mode.equals("P")) {
                    strNum = this.getDefaultID("Protein");
                    pd = new ProteinDialog(this, "Edit Protein", true, this.images, this.imagesGradient, mode, strNum);
                } else {
                    strNum = this.getDefaultID("Nucleotide");
                    pd = new ProteinDialog(this, "Edit Nucleotide", true, this.images, this.imagesGradient, mode, strNum);
                }
                pd.setProtein(protein);
                Tools.WindowCenter(pd);
                if (pd.getProtein() != null) {
                    protein.setVertical(pd.getProtein().getVertical());
                    protein.setHorizontal(pd.getProtein().getHorizontal());
                    protein.setLocked(pd.getProtein().isLocked());
                    protein.setParameter(pd.getProtein().getParameter());
                    protein.setColor(pd.getProtein().getColor());
                    protein.setArea(pd.getProtein().getArea());
                    protein.setEnd(pd.getProtein().getEnd());
                    this.repaintList();
                    this.canvasPanel.repaint();
                    if (pd.bModify) {
                        try {
                            this.canvasPanel.saveCurrentState();
                        }
                        catch (CloneNotSupportedException ex) {
                            ex.printStackTrace();
                        }
                    }
                }
                isContained = true;
            }
            if (!isContained) continue;
            break;
        }
        this.canvasPanel.repaint();
    }

    private void exit() {
        Tools.setCurrentFilePath();
        if (this.canvasPanel.getProteinList().size() > 0) {
            int confirm = JOptionPane.showConfirmDialog(this, "Do you want to save the current project?", "Warning", 1, 2, null);
            if (confirm == 0) {
                this.saveProject();
                System.exit(0);
                this.dispose();
            } else if (confirm == 1) {
                System.exit(0);
                this.dispose();
            }
        } else {
            System.exit(0);
            this.dispose();
        }
    }

    private void newProject() {
        ProteinDialog dialog;
        String strNum;
        if (mode.equals("P")) {
            strNum = this.getDefaultID("Protein");
            dialog = new ProteinDialog(this, "New Protein", true, this.images, this.imagesGradient, mode, strNum);
        } else {
            strNum = this.getDefaultID("Nucleotide");
            dialog = new ProteinDialog(this, "New Nucleotide", true, this.images, this.imagesGradient, mode, strNum);
        }
        Tools.WindowCenter(dialog);
        if (dialog.getProtein() != null) {
            this.filePath = "";
            this.setTitle(this.TITLE + " - New Project");
            Protein protein = dialog.getProtein();
            this.canvasPanel.getProteinList().add(protein);
            this.canvasPanel.setCurrentProteinNum(0);
            this.canvasPanel.setCurrentVertical(protein.getVertical());
            this.canvasPanel.repaint();
            this.repaintList();
            this.setCanvasSize();
            try {
                this.canvasPanel.saveCurrentState();
            }
            catch (CloneNotSupportedException ex) {
                ex.printStackTrace();
            }
        }
    }

    void openProject() {
        JFileChooser fc = new JFileChooser(Tools.CURRENT_FILE_PATH);
        fc.setAcceptAllFileFilterUsed(false);
        fc.addChoosableFileFilter(new Filter("XML", "IBS Project (*.XML)"));
        int returnVal = fc.showOpenDialog(this);
        if (returnVal == 0) {
            try {
                this.isOpening = true;
                this.filePath = fc.getSelectedFile().getPath();
                Project2XML pj = new Project2XML();
                String strMode = pj.getXMLMode(this.filePath);
                if (strMode.equals(mode)) {
                    Project project = new Project2XML(this.filePath).open(mode);
                    if (project == null) {
                        return;
                    }
                    double rateProject = Math.floor(project.rate * 10.0f) / 10.0;
                    project.rate = (float)rateProject;
                    int index = this.getSelectIndex(project.rate);
                    this.canvasPanel.rate = (float)rateProject;
                    this.canvasPanel.setIsLengthRatio(true);
                    this.drawPanel(project, this.filePath);
                    this.setCanvasSize();
                    this.canvasPanel.setCurrentProteinNum(0);
                    double q = this.getRelaRate(rateProject);
                    Protein currentProtein = this.canvasPanel.getProteinList().getFirst();
                    PreviewPanel.protein = (Protein)currentProtein.clone();
                    this.canvasPanel.setCurrentVertical(currentProtein.getVertical());
                    this.list.setSelectedIndex(0);
                    Tools.CURRENT_FILE_PATH = this.filePath;
                    this.isOpening = false;
                    try {
                        this.canvasPanel.saveCurrentState();
                        this.canvasPanel.adjustToCenter();
                    }
                    catch (CloneNotSupportedException ex) {
                        Logger.getLogger(IBSFrame.class.getName()).log(Level.SEVERE, null, ex);
                    }
                } else {
                    listModel.clear();
                    mode = strMode;
                    IBSFrame shapeIBSFramep = new IBSFrame(mode);
                    shapeIBSFramep.images = this.images;
                    shapeIBSFramep.imagesShape = this.imagesShape;
                    shapeIBSFramep.imagesShapeSite = this.imagesShapeSite;
                    shapeIBSFramep.imagesShapeMarker = this.imagesShapeMarker;
                    shapeIBSFramep.imagesGradient = this.imagesGradient;
                    shapeIBSFramep.imagesShapeCutLine = this.imagesShapeCutLine;
                    if (mode.equals("P")) {
                        shapeIBSFramep.jMenuItem2.setEnabled(false);
                        shapeIBSFramep.jMenuItem1.setEnabled(true);
                    } else {
                        shapeIBSFramep.jMenuItem2.setEnabled(true);
                        shapeIBSFramep.jMenuItem1.setEnabled(false);
                    }
                    this.demoMenuItem.setEnabled(true);
                    shapeIBSFramep.filePath = this.filePath;
                    shapeIBSFramep.openProjectWithFile();
                    Tools.CURRENT_FILE_PATH = this.filePath;
                    Tools.WindowCenter(shapeIBSFramep);
                    this.dispose();
                    try {
                        shapeIBSFramep.canvasPanel.saveCurrentState();
                        shapeIBSFramep.canvasPanel.adjustToCenter();
                    }
                    catch (CloneNotSupportedException ex) {
                        Logger.getLogger(IBSFrame.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }
            catch (CloneNotSupportedException ex) {
                Logger.getLogger(IBSFrame.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public void openProjectWithFile() {
        try {
            this.isOpening = true;
            Project project = new Project2XML(this.filePath).open(mode);
            if (project == null) {
                return;
            }
            double rateProject = Math.floor(project.rate * 10.0f) / 10.0;
            project.rate = (float)rateProject;
            int index = this.getSelectIndex(project.rate);
            this.canvasPanel.rate = (float)rateProject;
            this.canvasPanel.setIsLengthRatio(true);
            this.drawPanel(project, this.filePath);
            this.setCanvasSize();
            this.canvasPanel.setCurrentProteinNum(0);
            double q = this.getRelaRate(rateProject);
            Protein currentProtein = this.canvasPanel.getProteinList().getFirst();
            PreviewPanel.protein = (Protein)currentProtein.clone();
            this.canvasPanel.setCurrentVertical(currentProtein.getVertical());
            this.list.setSelectedIndex(0);
            Tools.CURRENT_FILE_PATH = this.filePath;
            this.isOpening = false;
        }
        catch (CloneNotSupportedException ex) {
            Logger.getLogger(IBSFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    void openProject(Project project, boolean isLengthRate) {
        try {
            this.isOpening = true;
            this.canvasPanel.setIsLengthRatio(isLengthRate);
            this.drawPanel(project, "New Project");
            this.setCanvasSize();
            this.canvasPanel.setWHRatio();
            this.canvasPanel.setCurrentProteinNum(0);
            Protein currentProtein = this.canvasPanel.getProteinList().getFirst();
            PreviewPanel.protein = (Protein)currentProtein.clone();
            this.canvasPanel.setCurrentVertical(currentProtein.getVertical());
            this.list.setSelectedIndex(0);
            this.isOpening = false;
        }
        catch (CloneNotSupportedException ex) {
            Logger.getLogger(IBSFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void setCanvasSize() {
        String size = "Canvas : " + this.canvasPanel.getWidth() + "\u00d7" + this.canvasPanel.getHeight();
        canvasScrollPane.setBorder(BorderFactory.createTitledBorder(null, size, 0, 0, new Font("Arial", 1, 14)));
    }

    private void saveNewProject() {
        JFileChooser fc = new JFileChooser(Tools.CURRENT_FILE_PATH);
        fc.setAcceptAllFileFilterUsed(false);
        fc.addChoosableFileFilter(new Filter("XML", "IBS Project (*.XML)"));
        int returnVal = fc.showSaveDialog(this);
        if (returnVal == 0) {
            this.filePath = fc.getSelectedFile().getPath();
            if (!this.filePath.toLowerCase().endsWith(".xml")) {
                this.filePath = this.filePath + ".xml";
            }
            File exportfile = new File(this.filePath);
            int confirm = 0;
            if (!exportfile.exists()) {
                try {
                    exportfile.createNewFile();
                }
                catch (IOException ex) {
                    Logger.getLogger(IBSFrame.class.getName()).log(Level.SEVERE, null, ex);
                }
            } else {
                confirm = JOptionPane.showConfirmDialog(this, "Project file already exists.Would you like to overwrite it?", "Warning", 0, 2, null);
            }
            if (confirm == 0) {
                if (exportfile.canWrite()) {
                    int w = (int)(800.0f * this.canvasPanel.rate);
                    int h = (int)((double)w / this.canvasPanel.getWhRatio());
                    Project project = new Project(w, h, this.canvasPanel.getRATE(), this.canvasPanel.getProteinList(), mode);
                    new Project2XML(this.filePath).save(project, mode);
                    this.setTitle(this.TITLE + " - " + this.filePath);
                    Tools.CURRENT_FILE_PATH = this.filePath;
                    JOptionPane.showMessageDialog(this, "Project saved to  " + this.filePath + "  successfully .");
                } else {
                    JOptionPane.showMessageDialog(this, this.filePath + " is currently being used by other software,please close it and try again.", "Warning", 2);
                }
            }
        }
    }

    private void saveProject() {
        try {
            if (this.canvasPanel.getProteinList().size() > 0) {
                if (this.filePath.equals("")) {
                    this.saveNewProject();
                } else {
                    int w = (int)(800.0f * this.canvasPanel.rate);
                    int h = (int)((double)w / this.canvasPanel.getWhRatio());
                    Project project = new Project(w, h, this.canvasPanel.getRATE(), this.canvasPanel.getProteinList(), mode);
                    new Project2XML(this.filePath).save(project, mode);
                    Tools.CURRENT_FILE_PATH = this.filePath;
                    JOptionPane.showMessageDialog(null, "Project saved successfully .");
                }
            }
        }
        catch (HeadlessException headlessException) {
            // empty catch block
        }
    }

    private void initComponents() {
        this.panelMenu = new JPopupMenu();
        this.editComponentMenuItem = new JMenuItem();
        this.addMenu = new JMenu();
        this.addProteinMenuItem = new JMenuItem();
        this.addDomainMenuItem = new JMenuItem();
        this.addSiteMenuItem = new JMenuItem();
        this.addNoteMenuItem = new JMenuItem();
        this.addLineMenuItem = new JMenuItem();
        this.duplicateCanvasMenuItem = new JMenuItem();
        this.deleteCanvasMenuItem = new JMenuItem();
        this.jSeparator2 = new JPopupMenu.Separator();
        this.moveMenu1 = new JMenu();
        this.moveTopMenuItem1 = new JMenuItem();
        this.moveDownMenuItem1 = new JMenuItem();
        this.moveUpMenuItem1 = new JMenuItem();
        this.moveEndMenuItem1 = new JMenuItem();
        this.canvasSizeMenuItem = new JMenuItem();
        this.zoomInMenuItem = new JMenuItem();
        this.zoomOutMenuItem = new JMenuItem();
        this.fitWidthMenuItem = new JMenuItem();
        this.jSeparator1 = new JSeparator();
        this.saveProjectMenuItem = new JMenuItem();
        this.exportImageMenuItem = new JMenuItem();
        this.popupMenu = new JPopupMenu();
        this.editMenuItem = new JMenuItem();
        this.duplicateMenuItem = new JMenuItem();
        this.moveMenu = new JMenu();
        this.moveTopMenuItem = new JMenuItem();
        this.moveUpMenuItem = new JMenuItem();
        this.moveDownMenuItem = new JMenuItem();
        this.moveEndMenuItem = new JMenuItem();
        this.deleteMenuItem = new JMenuItem();
        this.mainPanel = new JPanel();
        canvasScrollPane = new JScrollPane();
        this.consolePanel = new JPanel();
        this.proteinButton = new JButton();
        this.domainButton = new JButton();
        this.siteButton = new JButton();
        this.cutLineButton = new JButton();
        this.cutLineButton1 = new JButton();
        this.jLabel1 = new JLabel();
        this.jComboBoxScale = new JComboBox();
        this.jCheckBoxGray = new JCheckBox();
        this.componentScrollPane = new JScrollPane();
        this.list = new JList();
        this.jToolBar1 = new JToolBar();
        this.jButtonSelectUndo = new JButton();
        this.jButtonSelectRedo = new JButton();
        this.jSeparator4 = new JToolBar.Separator();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.jButtonBracket = new JButton();
        this.jButtonStraight = new JButton();
        this.jButtonCurve = new JButton();
        this.jButtonPolylineTwo = new JButton();
        this.jButtonBezier = new JButton();
        this.jButtonPolylineOne = new JButton();
        this.menuBar = new JMenuBar();
        this.fileMenu = new JMenu();
        this.newMenuItem = new JMenuItem();
        this.openMenuItem = new JMenuItem();
        this.saveMenuItem = new JMenuItem();
        this.saveAsMenuItem = new JMenuItem();
        this.exportMenuItem = new JMenuItem();
        this.exitMenuItem = new JMenuItem();
        this.editMenu = new JMenu();
        this.proteinMenuItem = new JMenuItem();
        this.domainMenuItem = new JMenuItem();
        this.siteMenuItem = new JMenuItem();
        this.jMenuItem8 = new JMenuItem();
        this.noteMenuItem = new JMenuItem();
        this.lineMenuItem = new JMenuItem();
        this.jMenuItem3 = new JMenuItem();
        this.jMenuItem4 = new JMenuItem();
        this.jMenuItem6 = new JMenuItem();
        this.jMenuItem5 = new JMenuItem();
        this.jMenuItem7 = new JMenuItem();
        this.jSeparator3 = new JPopupMenu.Separator();
        this.canvasMenuItem = new JMenuItem();
        this.jSeparator5 = new JPopupMenu.Separator();
        this.jMenuItemUndo = new JMenuItem();
        this.jMenuItemRedo = new JMenuItem();
        this.toolsMenu = new JMenu();
        this.demoMenuItem = new JMenuItem();
        this.batchExportMenuItem = new JMenuItem();
        this.formatMenuItem = new JMenuItem();
        this.jMenu1 = new JMenu();
        this.jMenuItem2 = new JMenuItem();
        this.jMenuItem1 = new JMenuItem();
        this.helpMenu = new JMenu();
        this.acknowMenuItem = new JMenuItem();
        this.citationMenuItem = new JMenuItem();
        this.contactMenuItem = new JMenuItem();
        this.updateMenuItem = new JMenuItem();
        this.aboutMenuItem = new JMenuItem();
        this.editComponentMenuItem.setText("Edit");
        this.editComponentMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IBSFrame.this.editComponentMenuItemActionPerformed(evt);
            }
        });
        this.panelMenu.add(this.editComponentMenuItem);
        this.addMenu.setText("Add");
        this.addProteinMenuItem.setText("Protein");
        this.addProteinMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IBSFrame.this.proteinButtonActionPerformed(evt);
            }
        });
        this.addMenu.add(this.addProteinMenuItem);
        this.addDomainMenuItem.setText("Domain");
        this.addDomainMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IBSFrame.this.domainButtonActionPerformed(evt);
            }
        });
        this.addMenu.add(this.addDomainMenuItem);
        this.addSiteMenuItem.setText("Site");
        this.addSiteMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IBSFrame.this.siteButtonActionPerformed(evt);
            }
        });
        this.addMenu.add(this.addSiteMenuItem);
        this.addNoteMenuItem.setText("Note");
        this.addNoteMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IBSFrame.this.noteButtonActionPerformed(evt);
            }
        });
        this.addMenu.add(this.addNoteMenuItem);
        this.addLineMenuItem.setText("Line");
        this.addLineMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IBSFrame.this.lineButtonActionPerformed(evt);
            }
        });
        this.addMenu.add(this.addLineMenuItem);
        this.panelMenu.add(this.addMenu);
        this.duplicateCanvasMenuItem.setText("Duplicate");
        this.duplicateCanvasMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IBSFrame.this.duplicateMenuItemActionPerformed(evt);
            }
        });
        this.panelMenu.add(this.duplicateCanvasMenuItem);
        this.deleteCanvasMenuItem.setText("Delete");
        this.deleteCanvasMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IBSFrame.this.deleteMenuItemActionPerformed(evt);
            }
        });
        this.panelMenu.add(this.deleteCanvasMenuItem);
        this.panelMenu.add(this.jSeparator2);
        this.moveMenu1.setText("Move");
        this.moveTopMenuItem1.setText("Top");
        this.moveTopMenuItem1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IBSFrame.this.moveTopMenuItem1ActionPerformed(evt);
            }
        });
        this.moveMenu1.add(this.moveTopMenuItem1);
        this.moveDownMenuItem1.setText("Down");
        this.moveDownMenuItem1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IBSFrame.this.moveDownMenuItem1ActionPerformed(evt);
            }
        });
        this.moveMenu1.add(this.moveDownMenuItem1);
        this.moveUpMenuItem1.setText("Up");
        this.moveUpMenuItem1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IBSFrame.this.moveUpMenuItem1ActionPerformed(evt);
            }
        });
        this.moveMenu1.add(this.moveUpMenuItem1);
        this.moveEndMenuItem1.setText("Bottom");
        this.moveEndMenuItem1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IBSFrame.this.moveEndMenuItem1ActionPerformed(evt);
            }
        });
        this.moveMenu1.add(this.moveEndMenuItem1);
        this.panelMenu.add(this.moveMenu1);
        this.canvasSizeMenuItem.setText("Canvas Size");
        this.canvasSizeMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IBSFrame.this.canvasMenuItemActionPerformed(evt);
            }
        });
        this.panelMenu.add(this.canvasSizeMenuItem);
        this.zoomInMenuItem.setAccelerator(KeyStroke.getKeyStroke(38, 0));
        this.zoomInMenuItem.setText("Zoom In");
        this.zoomInMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IBSFrame.this.zoomInMenuItemActionPerformed(evt);
            }
        });
        this.panelMenu.add(this.zoomInMenuItem);
        this.zoomOutMenuItem.setAccelerator(KeyStroke.getKeyStroke(40, 0));
        this.zoomOutMenuItem.setText("Zoom Out");
        this.zoomOutMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IBSFrame.this.zoomOutMenuItemActionPerformed(evt);
            }
        });
        this.panelMenu.add(this.zoomOutMenuItem);
        this.fitWidthMenuItem.setText("Fit Width");
        this.fitWidthMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IBSFrame.this.fitWidthMenuItemActionPerformed(evt);
            }
        });
        this.panelMenu.add(this.fitWidthMenuItem);
        this.panelMenu.add(this.jSeparator1);
        this.saveProjectMenuItem.setText("Save Project");
        this.saveProjectMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IBSFrame.this.saveMenuItemActionPerformed(evt);
            }
        });
        this.panelMenu.add(this.saveProjectMenuItem);
        this.exportImageMenuItem.setText("Export Image");
        this.exportImageMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IBSFrame.this.exportMenuItemActionPerformed(evt);
            }
        });
        this.panelMenu.add(this.exportImageMenuItem);
        this.editMenuItem.setText("Edit");
        this.editMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IBSFrame.this.editMenuItemActionPerformed(evt);
            }
        });
        this.popupMenu.add(this.editMenuItem);
        this.duplicateMenuItem.setText("Duplicate");
        this.duplicateMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IBSFrame.this.duplicateMenuItemActionPerformed(evt);
            }
        });
        this.popupMenu.add(this.duplicateMenuItem);
        this.moveMenu.setText("Move");
        this.moveTopMenuItem.setText("Top");
        this.moveTopMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IBSFrame.this.moveTopMenuItemActionPerformed(evt);
            }
        });
        this.moveMenu.add(this.moveTopMenuItem);
        this.moveUpMenuItem.setText("Up");
        this.moveUpMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IBSFrame.this.moveUpMenuItemActionPerformed(evt);
            }
        });
        this.moveMenu.add(this.moveUpMenuItem);
        this.moveDownMenuItem.setText("Down");
        this.moveDownMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IBSFrame.this.moveDownMenuItemActionPerformed(evt);
            }
        });
        this.moveMenu.add(this.moveDownMenuItem);
        this.moveEndMenuItem.setText("Bottom");
        this.moveEndMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IBSFrame.this.moveEndMenuItemActionPerformed(evt);
            }
        });
        this.moveMenu.add(this.moveEndMenuItem);
        this.popupMenu.add(this.moveMenu);
        this.deleteMenuItem.setText("Delete");
        this.deleteMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IBSFrame.this.deleteMenuItemActionPerformed(evt);
            }
        });
        this.popupMenu.add(this.deleteMenuItem);
        this.setDefaultCloseOperation(0);
        this.setTitle(" IBS 1.0.2 - Illustrator for Biological Sequences");
        this.setIconImage(Tools.GPS_ICON);
        this.setMinimumSize(new Dimension(800, 600));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                IBSFrame.this.formWindowClosing(evt);
            }
        });
        this.mainPanel.setLayout(new BorderLayout());
        canvasScrollPane.getViewport().add(this.canvasPanel);
        this.canvasPanel.df = this;
        canvasScrollPane.setBackground(new Color(255, 255, 255));
        canvasScrollPane.setBorder(BorderFactory.createTitledBorder(null, "Canvas", 0, 0, new Font("Arial", 1, 14)));
        this.canvasPanel.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent evt) {
                IBSFrame.this.drawPanelMouseWheelMoved(evt);
            }
        });
        this.canvasPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                IBSFrame.this.drawPanelMouseClicked(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                IBSFrame.this.drawPanelMousePressed(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                IBSFrame.this.drawPanelMouseReleased(evt);
            }
        });
        this.canvasPanel.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent evt) {
                IBSFrame.this.repaintList();
            }

            @Override
            public void mouseMoved(MouseEvent evt) {
            }
        });
        canvasScrollPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                IBSFrame.this.canvasScrollPaneMouseClicked(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                IBSFrame.this.canvasScrollPaneMousePressed(evt);
            }
        });
        this.mainPanel.add((java.awt.Component)canvasScrollPane, "Center");
        this.consolePanel.setBorder(BorderFactory.createTitledBorder(null, "Console", 0, 0, new Font("Arial", 1, 14)));
        this.consolePanel.setPreferredSize(new Dimension(100, 71));
        this.proteinButton.setFont(new Font("Arial", 1, 12));
        this.proteinButton.setText("Protein");
        this.proteinButton.setMaximumSize(new Dimension(200, 23));
        this.proteinButton.setPreferredSize(new Dimension(120, 23));
        this.proteinButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IBSFrame.this.proteinButtonActionPerformed(evt);
            }
        });
        this.consolePanel.add(this.proteinButton);
        this.domainButton.setFont(new Font("Arial", 1, 12));
        this.domainButton.setText("Domain");
        this.domainButton.setMaximumSize(new Dimension(200, 23));
        this.domainButton.setPreferredSize(new Dimension(100, 23));
        this.domainButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IBSFrame.this.domainButtonActionPerformed(evt);
            }
        });
        this.consolePanel.add(this.domainButton);
        this.siteButton.setFont(new Font("Arial", 1, 12));
        this.siteButton.setText("Site");
        this.siteButton.setMaximumSize(new Dimension(200, 23));
        this.siteButton.setPreferredSize(new Dimension(100, 23));
        this.siteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IBSFrame.this.siteButtonActionPerformed(evt);
            }
        });
        this.consolePanel.add(this.siteButton);
        this.cutLineButton.setFont(new Font("Arial", 1, 12));
        this.cutLineButton.setText("CutLine");
        this.cutLineButton.setMaximumSize(new Dimension(200, 23));
        this.cutLineButton.setPreferredSize(new Dimension(100, 23));
        this.cutLineButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IBSFrame.this.cutLineButtonActionPerformed1(evt);
            }
        });
        this.consolePanel.add(this.cutLineButton);
        this.cutLineButton1.setFont(new Font("Arial", 1, 12));
        this.cutLineButton1.setText("Note");
        this.cutLineButton1.setMaximumSize(new Dimension(200, 23));
        this.cutLineButton1.setPreferredSize(new Dimension(100, 23));
        this.cutLineButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IBSFrame.this.cutLineButton1ActionPerformed1(evt);
            }
        });
        this.consolePanel.add(this.cutLineButton1);
        this.jLabel1.setFont(new Font("Arial", 1, 12));
        this.jLabel1.setText("Zoom");
        this.consolePanel.add(this.jLabel1);
        this.jComboBoxScale.setModel(new DefaultComboBoxModel<String>(new String[]{"70%", "80%", "90%", "100%", "150%", "200%", "250%", "300%", "350%", "400%", "450%", "500%", "550%", "600%", "650%", "700%", "750%", "800%"}));
        this.jComboBoxScale.setSelectedIndex(3);
        this.jComboBoxScale.setPreferredSize(new Dimension(100, 20));
        this.jComboBoxScale.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                IBSFrame.this.jComboBoxScaleMouseClicked(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                IBSFrame.this.jComboBoxScaleMousePressed(evt);
            }
        });
        this.jComboBoxScale.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IBSFrame.this.jComboBoxScaleActionPerformed(evt);
            }
        });
        this.consolePanel.add(this.jComboBoxScale);
        this.jCheckBoxGray.setFont(new Font("Arial", 1, 12));
        this.jCheckBoxGray.setText("Grayscale");
        this.jCheckBoxGray.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                IBSFrame.this.jCheckBoxGrayItemStateChanged(evt);
            }
        });
        this.consolePanel.add(this.jCheckBoxGray);
        this.mainPanel.add((java.awt.Component)this.consolePanel, "South");
        this.getContentPane().add((java.awt.Component)this.mainPanel, "Center");
        this.componentScrollPane.setBorder(BorderFactory.createTitledBorder(null, "Component List", 0, 0, new Font("Arial", 1, 14)));
        this.componentScrollPane.setPreferredSize(new Dimension(194, 100));
        this.list.setBackground(new Color(255, 255, 224));
        this.list.setModel(listModel);
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                IBSFrame.this.listMouseClicked(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                IBSFrame.this.listMousePressed(evt);
            }
        });
        this.list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                IBSFrame.this.listValueChanged(evt);
            }
        });
        this.componentScrollPane.setViewportView(this.list);
        this.getContentPane().add((java.awt.Component)this.componentScrollPane, "East");
        this.jToolBar1.setRollover(true);
        this.jToolBar1.setMinimumSize(new Dimension(261, 10));
        this.jToolBar1.setName("");
        this.jToolBar1.setPreferredSize(new Dimension(100, 40));
        this.jButtonSelectUndo.setForeground(new Color(240, 240, 240));
        this.jButtonSelectUndo.setIcon(new ImageIcon(this.getClass().getResource("/gui/ibs/image/undo.png")));
        this.jButtonSelectUndo.setToolTipText("Undo");
        this.jButtonSelectUndo.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jButtonSelectUndo.setEnabled(false);
        this.jButtonSelectUndo.setFocusable(false);
        this.jButtonSelectUndo.setHorizontalTextPosition(0);
        this.jButtonSelectUndo.setMinimumSize(new Dimension(10, 10));
        this.jButtonSelectUndo.setPreferredSize(new Dimension(10, 10));
        this.jButtonSelectUndo.setVerticalTextPosition(3);
        this.jButtonSelectUndo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IBSFrame.this.jButtonSelectUndoActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonSelectUndo);
        this.jButtonSelectRedo.setForeground(new Color(240, 240, 240));
        this.jButtonSelectRedo.setIcon(new ImageIcon(this.getClass().getResource("/gui/ibs/image/redo.png")));
        this.jButtonSelectRedo.setToolTipText("Redo");
        this.jButtonSelectRedo.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jButtonSelectRedo.setEnabled(false);
        this.jButtonSelectRedo.setFocusable(false);
        this.jButtonSelectRedo.setHorizontalTextPosition(0);
        this.jButtonSelectRedo.setVerticalTextPosition(3);
        this.jButtonSelectRedo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IBSFrame.this.jButtonSelectRedoActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonSelectRedo);
        this.jToolBar1.add(this.jSeparator4);
        this.jButton1.setIcon(new ImageIcon(this.getClass().getResource("/gui/ibs/image/Note.png")));
        this.jButton1.setToolTipText("Draw a note");
        this.jButton1.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jButton1.setFocusable(false);
        this.jButton1.setHorizontalTextPosition(0);
        this.jButton1.setVerticalTextPosition(3);
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IBSFrame.this.jButton1ActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton1);
        this.jButton2.setIcon(new ImageIcon(this.getClass().getResource("/gui/ibs/image/polygon.png")));
        this.jButton2.setToolTipText("Draw a marker");
        this.jButton2.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jButton2.setFocusable(false);
        this.jButton2.setHorizontalTextPosition(0);
        this.jButton2.setVerticalTextPosition(3);
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IBSFrame.this.jButton2ActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton2);
        this.jButtonBracket.setIcon(new ImageIcon(this.getClass().getResource("/gui/ibs/image/bracket.png")));
        this.jButtonBracket.setToolTipText("Draw a bracket");
        this.jButtonBracket.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jButtonBracket.setFocusable(false);
        this.jButtonBracket.setHorizontalTextPosition(0);
        this.jButtonBracket.setVerticalTextPosition(3);
        this.jButtonBracket.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IBSFrame.this.jButtonBracketActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonBracket);
        this.jButtonStraight.setIcon(new ImageIcon(this.getClass().getResource("/gui/ibs/image/Line-Diag.png")));
        this.jButtonStraight.setToolTipText("Draw a straight line");
        this.jButtonStraight.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jButtonStraight.setFocusable(false);
        this.jButtonStraight.setHorizontalTextPosition(0);
        this.jButtonStraight.setVerticalTextPosition(3);
        this.jButtonStraight.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IBSFrame.this.jButtonStraightActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonStraight);
        this.jButtonCurve.setIcon(new ImageIcon(this.getClass().getResource("/gui/ibs/image/curve.png")));
        this.jButtonCurve.setToolTipText("Draw a curve");
        this.jButtonCurve.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jButtonCurve.setFocusable(false);
        this.jButtonCurve.setHorizontalTextPosition(0);
        this.jButtonCurve.setVerticalTextPosition(3);
        this.jButtonCurve.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IBSFrame.this.jButtonCurveActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonCurve);
        this.jButtonPolylineTwo.setIcon(new ImageIcon(this.getClass().getResource("/gui/ibs/image/polylinetwo.png")));
        this.jButtonPolylineTwo.setToolTipText("Draw a polyline with two  knuckle points");
        this.jButtonPolylineTwo.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jButtonPolylineTwo.setFocusable(false);
        this.jButtonPolylineTwo.setHorizontalTextPosition(0);
        this.jButtonPolylineTwo.setVerticalTextPosition(3);
        this.jButtonPolylineTwo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IBSFrame.this.jButtonPolylineTwoActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonPolylineTwo);
        this.jButtonBezier.setIcon(new ImageIcon(this.getClass().getResource("/gui/ibs/image/bezier.png")));
        this.jButtonBezier.setToolTipText("Draw a bezier curve");
        this.jButtonBezier.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jButtonBezier.setFocusable(false);
        this.jButtonBezier.setHorizontalTextPosition(0);
        this.jButtonBezier.setVerticalTextPosition(3);
        this.jButtonBezier.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IBSFrame.this.jButtonBezierActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonBezier);
        this.jButtonPolylineOne.setIcon(new ImageIcon(this.getClass().getResource("/gui/ibs/image/polylineone.png")));
        this.jButtonPolylineOne.setToolTipText("Draw a polyline with one  knuckle point");
        this.jButtonPolylineOne.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jButtonPolylineOne.setFocusable(false);
        this.jButtonPolylineOne.setHorizontalTextPosition(0);
        this.jButtonPolylineOne.setVerticalTextPosition(3);
        this.jButtonPolylineOne.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IBSFrame.this.jButtonPolylineOneActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonPolylineOne);
        this.getContentPane().add((java.awt.Component)this.jToolBar1, "First");
        this.fileMenu.setText("File");
        this.newMenuItem.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        this.newMenuItem.setText("New Project");
        this.newMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IBSFrame.this.newMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.newMenuItem);
        this.openMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.openMenuItem.setText("Open Project");
        this.openMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IBSFrame.this.openMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.openMenuItem);
        this.saveMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.saveMenuItem.setText("Save");
        this.saveMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IBSFrame.this.saveMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.saveMenuItem);
        this.saveAsMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, 3));
        this.saveAsMenuItem.setText("Save As...");
        this.saveAsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IBSFrame.this.saveAsMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.saveAsMenuItem);
        this.exportMenuItem.setAccelerator(KeyStroke.getKeyStroke(69, 2));
        this.exportMenuItem.setText("Export Image");
        this.exportMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IBSFrame.this.exportMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.exportMenuItem);
        this.exitMenuItem.setAccelerator(KeyStroke.getKeyStroke(115, 8));
        this.exitMenuItem.setText("Exit");
        this.exitMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IBSFrame.this.exitMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.exitMenuItem);
        this.menuBar.add(this.fileMenu);
        this.editMenu.setText("Edit");
        this.editMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IBSFrame.this.editMenuActionPerformed(evt);
            }
        });
        this.proteinMenuItem.setText("Add Protein");
        this.proteinMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IBSFrame.this.proteinButtonActionPerformed(evt);
            }
        });
        this.editMenu.add(this.proteinMenuItem);
        this.domainMenuItem.setText("Add Domain");
        this.domainMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IBSFrame.this.domainButtonActionPerformed(evt);
            }
        });
        this.editMenu.add(this.domainMenuItem);
        this.siteMenuItem.setText("Add Site");
        this.siteMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IBSFrame.this.siteButtonActionPerformed(evt);
            }
        });
        this.editMenu.add(this.siteMenuItem);
        this.jMenuItem8.setText("Add Cutline");
        this.jMenuItem8.setToolTipText("");
        this.jMenuItem8.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IBSFrame.this.jMenuItem8ActionPerformed(evt);
            }
        });
        this.editMenu.add(this.jMenuItem8);
        this.noteMenuItem.setText("Add Note");
        this.noteMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IBSFrame.this.noteButtonActionPerformed(evt);
            }
        });
        this.editMenu.add(this.noteMenuItem);
        this.lineMenuItem.setText("Add Bracket");
        this.lineMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IBSFrame.this.lineMenuItemlineButtonActionPerformed(evt);
            }
        });
        this.editMenu.add(this.lineMenuItem);
        this.jMenuItem3.setText("Add Straight Line");
        this.jMenuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IBSFrame.this.jMenuItem3ActionPerformed(evt);
            }
        });
        this.editMenu.add(this.jMenuItem3);
        this.jMenuItem4.setText("Add Curve");
        this.jMenuItem4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IBSFrame.this.jMenuItem4ActionPerformed(evt);
            }
        });
        this.editMenu.add(this.jMenuItem4);
        this.jMenuItem6.setText("Add Bezier Curve");
        this.jMenuItem6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IBSFrame.this.jMenuItem6ActionPerformed(evt);
            }
        });
        this.editMenu.add(this.jMenuItem6);
        this.jMenuItem5.setText("Add Polyline with Two  Knuckle Points");
        this.jMenuItem5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IBSFrame.this.jMenuItem5ActionPerformed(evt);
            }
        });
        this.editMenu.add(this.jMenuItem5);
        this.jMenuItem7.setText("Add Polyline with One  Knuckle Point");
        this.jMenuItem7.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IBSFrame.this.jMenuItem7ActionPerformed(evt);
            }
        });
        this.editMenu.add(this.jMenuItem7);
        this.editMenu.add(this.jSeparator3);
        this.canvasMenuItem.setText("Canvas Size");
        this.canvasMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IBSFrame.this.canvasMenuItemActionPerformed(evt);
            }
        });
        this.editMenu.add(this.canvasMenuItem);
        this.editMenu.add(this.jSeparator5);
        this.jMenuItemUndo.setAccelerator(KeyStroke.getKeyStroke(85, 2));
        this.jMenuItemUndo.setText("Undo");
        this.jMenuItemUndo.setEnabled(false);
        this.jMenuItemUndo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IBSFrame.this.jMenuItemUndoActionPerformed(evt);
            }
        });
        this.editMenu.add(this.jMenuItemUndo);
        this.jMenuItemRedo.setAccelerator(KeyStroke.getKeyStroke(69, 2));
        this.jMenuItemRedo.setText("Redo");
        this.jMenuItemRedo.setEnabled(false);
        this.jMenuItemRedo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IBSFrame.this.jMenuItemRedoActionPerformed(evt);
            }
        });
        this.editMenu.add(this.jMenuItemRedo);
        this.menuBar.add(this.editMenu);
        this.toolsMenu.setText("Tools");
        this.demoMenuItem.setAccelerator(KeyStroke.getKeyStroke(68, 2));
        this.demoMenuItem.setText("Demo");
        this.demoMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IBSFrame.this.demoMenuItemActionPerformed(evt);
            }
        });
        this.toolsMenu.add(this.demoMenuItem);
        this.batchExportMenuItem.setAccelerator(KeyStroke.getKeyStroke(66, 2));
        this.batchExportMenuItem.setText("Batch Export Images");
        this.batchExportMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IBSFrame.this.batchExportMenuItemActionPerformed(evt);
            }
        });
        this.toolsMenu.add(this.batchExportMenuItem);
        this.formatMenuItem.setAccelerator(KeyStroke.getKeyStroke(70, 2));
        this.formatMenuItem.setText("Image Format Converter");
        this.formatMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IBSFrame.this.formatMenuItemActionPerformed(evt);
            }
        });
        this.toolsMenu.add(this.formatMenuItem);
        this.menuBar.add(this.toolsMenu);
        this.jMenu1.setText("Mode");
        this.jMenu1.setToolTipText("");
        this.jMenuItem2.setText("Protein Mode");
        this.jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IBSFrame.this.jMenuItem2ActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.jMenuItem2);
        this.jMenuItem1.setText("Nucleotide Mode");
        this.jMenuItem1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IBSFrame.this.jMenuItem1ActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.jMenuItem1);
        this.menuBar.add(this.jMenu1);
        this.helpMenu.setText("Help");
        this.acknowMenuItem.setText("Acknowledgement");
        this.acknowMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IBSFrame.this.acknowMenuItemActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.acknowMenuItem);
        this.citationMenuItem.setText("Citation");
        this.citationMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IBSFrame.this.citationMenuItemActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.citationMenuItem);
        this.contactMenuItem.setText("Contact Us");
        this.contactMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IBSFrame.this.contactMenuItemActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.contactMenuItem);
        this.updateMenuItem.setText("Check for update");
        this.updateMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IBSFrame.this.updateMenuItemActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.updateMenuItem);
        this.aboutMenuItem.setText("About");
        this.aboutMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IBSFrame.this.aboutMenuItemActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.aboutMenuItem);
        this.menuBar.add(this.helpMenu);
        this.setJMenuBar(this.menuBar);
        this.pack();
    }

    private void proteinButtonActionPerformed(ActionEvent evt) {
        if (this.canvasPanel.getProteinList().size() > 0) {
            ProteinDialog dialog;
            String strNum;
            this.canvasPanel.clearComponentActiveState();
            if (mode.equals("P")) {
                strNum = this.getDefaultID("Protein");
                dialog = new ProteinDialog(this, " New Protein", true, this.images, this.imagesGradient, mode, strNum);
            } else {
                strNum = this.getDefaultID("Nucleotide");
                dialog = new ProteinDialog(this, " New Nucleotide", true, this.images, this.imagesGradient, mode, strNum);
            }
            dialog.setVertical(this.canvasPanel.getCurrentVertical() - 100);
            Tools.WindowCenter(dialog);
            if (dialog.getProtein() != null) {
                Protein protein = dialog.getProtein();
                this.canvasPanel.getProteinList().add(protein);
                this.canvasPanel.setCurrentProteinNum(this.canvasPanel.getProteinList().size() - 1);
                this.canvasPanel.setCurrentVertical(protein.getVertical());
                this.repaintList();
                this.canvasPanel.repaint();
                try {
                    this.canvasPanel.saveCurrentState();
                }
                catch (CloneNotSupportedException ex) {
                    ex.printStackTrace();
                }
            }
        } else {
            this.canvasPanel.setProteinList(new LinkedList<Protein>());
            this.canvasPanel.repaint();
            listModel.clear();
            this.newProject();
        }
    }

    private void domainButtonActionPerformed(ActionEvent evt) {
        if (this.canvasPanel.getProteinList().size() == 0) {
            int confirm = mode.equals("P") ? JOptionPane.showConfirmDialog(null, "Please create a new protein.", "Warning", 2, 2, null) : JOptionPane.showConfirmDialog(null, "Please create a new nucleotide.", "Warning", 2, 2, null);
            if (confirm == 0) {
                this.newProject();
            }
        } else {
            this.canvasPanel.clearComponentActiveState();
            int proteinlenth = this.canvasPanel.getCurrentProtein().getEnd();
            String strNum = this.getDefaultID(ComponentEnum.Domain.name());
            if (mode.equals("P")) {
                this.addComponent(new ProteinDomainDialog(this, " Add Domain", true, this.images, this.imagesGradient, proteinlenth, strNum));
            } else {
                this.addComponent(new NucleotideDomainDialog(this, " Add Domain", true, this.images, this.imagesShape, this.imagesGradient, proteinlenth, this.canvasPanel.ddc, strNum));
            }
        }
    }

    private void siteButtonActionPerformed(ActionEvent evt) {
        if (this.canvasPanel.getProteinList().size() == 0) {
            int confirm = mode.equals("P") ? JOptionPane.showConfirmDialog(null, "Please create a new protein.", "Warning", 2, 2, null) : JOptionPane.showConfirmDialog(null, "Please create a new nucleotide.", "Warning", 2, 2, null);
            if (confirm == 0) {
                this.newProject();
            }
        } else {
            this.canvasPanel.clearComponentActiveState();
            int proteinlenth = this.canvasPanel.getCurrentProtein().getEnd();
            String strNum = this.getDefaultID(ComponentEnum.Site.name());
            this.addComponent(new SiteDialog(this, " Add Site", true, this.images, this.imagesShapeSite, this.imagesGradient, proteinlenth, strNum));
        }
    }

    private void noteButtonActionPerformed(ActionEvent evt) {
        if (this.canvasPanel.getProteinList().size() == 0) {
            int confirm = JOptionPane.showConfirmDialog(null, "Please create a new protein.", "Warning", 2, 2, null);
            if (confirm == 0) {
                this.newProject();
            }
        } else {
            String strNum = this.getDefaultID(ComponentEnum.Note.name());
            this.addComponent(new NoteDialog((Frame)this, " Add Note", true, strNum));
        }
    }

    private void openMenuItemActionPerformed(ActionEvent evt) {
        if (this.canvasPanel.getProteinList().size() > 0) {
            int confirm = JOptionPane.showConfirmDialog(null, "Do you want to save the current project?", "Warning", 1, 2, null);
            if (confirm == 0) {
                this.saveProject();
                this.canvasPanel.clearHis();
                this.openProject();
            } else if (confirm == 1) {
                this.canvasPanel.clearHis();
                this.openProject();
            }
        } else {
            this.canvasPanel.clearHis();
            this.openProject();
            try {
                this.canvasPanel.saveCurrentState();
            }
            catch (CloneNotSupportedException ex) {
                Logger.getLogger(IBSFrame.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void saveMenuItemActionPerformed(ActionEvent evt) {
        this.saveProject();
    }

    private void saveAsMenuItemActionPerformed(ActionEvent evt) {
        this.saveNewProject();
    }

    private void exportMenuItemActionPerformed(ActionEvent evt) {
        Tools.WindowCenter(new OutputJDialog(this.canvasPanel, this, true));
    }

    private void exitMenuItemActionPerformed(ActionEvent evt) {
        Tools.setCurrentFilePath();
        this.exit();
    }

    private void demoMenuItemActionPerformed(ActionEvent evt) {
        Tools.WindowCenter(new DemoFrame(mode, this.images, this.imagesShape, this.imagesShapeSite, this.imagesShapeMarker, this.imagesGradient, this.imagesShapeCutLine));
    }

    private void aboutMenuItemActionPerformed(ActionEvent evt) {
        Tools.WindowCenter(new ProductDialog((Frame)this, true, 2));
    }

    private void zoomInMenuItemActionPerformed(ActionEvent evt) {
        if (this.isOpening) {
            return;
        }
        int index = this.jComboBoxScale.getSelectedIndex();
        if (index == 17) {
            return;
        }
        this.jComboBoxScale.setSelectedIndex(index + 1);
    }

    private void zoomOutMenuItemActionPerformed(ActionEvent evt) {
        if (this.isOpening) {
            return;
        }
        int index = this.jComboBoxScale.getSelectedIndex();
        if (index == 0) {
            return;
        }
        this.jComboBoxScale.setSelectedIndex(index - 1);
    }

    private void fitWidthMenuItemActionPerformed(ActionEvent evt) {
        Dimension dimension = new Dimension(canvasScrollPane.getWidth() - 50, canvasScrollPane.getHeight() - 50);
        this.canvasPanel.setSize(dimension);
        this.canvasPanel.setPreferredSize(dimension);
        this.canvasPanel.repaint();
    }

    private void editMenuItemActionPerformed(ActionEvent evt) {
        if (!this.list.isSelectionEmpty()) {
            this.callEditDialog();
        }
    }

    private void moveUpMenuItemActionPerformed(ActionEvent evt) {
        Protein protein;
        int selectNum;
        if (!this.list.isSelectionEmpty() && (selectNum = (protein = this.getIndexProtein(this.list.getSelectedIndex())).getSelectNum()) > 0) {
            LinkedList<Component> componentList = protein.getComponentList();
            Component temp = componentList.get(selectNum - 1);
            componentList.set(selectNum - 1, componentList.get(selectNum));
            componentList.set(selectNum, temp);
            this.canvasPanel.repaint();
            this.repaintList();
            try {
                this.canvasPanel.saveCurrentState();
            }
            catch (CloneNotSupportedException ex) {
                ex.printStackTrace();
            }
        }
    }

    private void moveDownMenuItemActionPerformed(ActionEvent evt) {
        if (!this.list.isSelectionEmpty()) {
            Protein protein = this.getIndexProtein(this.list.getSelectedIndex());
            int selectNum = protein.getSelectNum();
            LinkedList<Component> componentList = protein.getComponentList();
            if (selectNum >= 0 && selectNum < componentList.size() - 1) {
                Component temp = componentList.get(selectNum + 1);
                componentList.set(selectNum + 1, componentList.get(selectNum));
                componentList.set(selectNum, temp);
                this.canvasPanel.repaint();
                this.repaintList();
                try {
                    this.canvasPanel.saveCurrentState();
                }
                catch (CloneNotSupportedException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    private void deleteMenuItemActionPerformed(ActionEvent evt) {
        if (!this.list.isSelectionEmpty()) {
            int listNum = this.list.getSelectedIndex();
            int count = 0;
            LinkedList<Protein> proteinList = this.canvasPanel.getProteinList();
            for (int i = 0; i < proteinList.size(); ++i) {
                Protein protein = proteinList.get(i);
                if (listNum == count) {
                    proteinList.remove(i);
                    this.canvasPanel.repaint();
                    if (proteinList.size() > 0) {
                        this.canvasPanel.setCurrentProteinNum(0);
                        proteinList.get(0).setIsActive(true);
                        proteinList.get(0).setSelectNum(0);
                    }
                    this.repaintList();
                    try {
                        this.canvasPanel.saveCurrentState();
                    }
                    catch (CloneNotSupportedException ex) {
                        ex.printStackTrace();
                    }
                    break;
                }
                ++count;
                boolean isContained = false;
                LinkedList<Component> componentList = protein.getComponentList();
                for (int j = 0; j < componentList.size(); ++j) {
                    if (listNum == count) {
                        componentList.remove(j);
                        this.canvasPanel.repaint();
                        this.repaintList();
                        isContained = true;
                        try {
                            this.canvasPanel.saveCurrentState();
                        }
                        catch (CloneNotSupportedException ex) {
                            ex.printStackTrace();
                        }
                        break;
                    }
                    ++count;
                }
                if (isContained) break;
            }
        }
    }

    private void listMouseClicked(MouseEvent evt) {
        this.canvasPanel.setFocusable(false);
        this.jComboBoxScale.setFocusable(false);
        this.list.setFocusable(true);
        if (SwingUtilities.isLeftMouseButton(evt) && evt.getClickCount() == 2 && !this.list.isSelectionEmpty()) {
            this.callEditDialog();
        }
        if (SwingUtilities.isLeftMouseButton(evt) && evt.getClickCount() == 1 && !this.list.isSelectionEmpty()) {
            this.selectComponent();
        }
    }

    private void listMousePressed(MouseEvent evt) {
        this.canvasPanel.setFocusable(false);
        this.jComboBoxScale.setFocusable(false);
        this.list.setFocusable(true);
        if (!this.list.isSelectionEmpty()) {
            this.activeProtein(this.list.getSelectedIndex());
            try {
                PreviewPanel.protein = (Protein)this.getIndexProtein(this.list.getSelectedIndex()).clone();
                if (SwingUtilities.isRightMouseButton(evt)) {
                    this.popupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
                    if (String.valueOf(this.list.getSelectedValue()).contains(">>")) {
                        this.moveMenu.setEnabled(true);
                    } else {
                        this.moveMenu.setEnabled(false);
                    }
                }
            }
            catch (CloneNotSupportedException ex) {
                Logger.getLogger(IBSFrame.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void formWindowClosing(WindowEvent evt) {
        Tools.setCurrentFilePath();
        this.exit();
    }

    private void acknowMenuItemActionPerformed(ActionEvent evt) {
        Tools.WindowCenter(new AcknowledgementDialog((Frame)this, true));
    }

    private void contactMenuItemActionPerformed(ActionEvent evt) {
        Tools.WindowCenter(new ContactDialog(this, true, "/gui/ibs/contact.html", 480, 320));
    }

    private void citationMenuItemActionPerformed(ActionEvent evt) {
        Tools.WindowCenter(new CitationDialog(this, true, "/gui/ibs/citation.html", 550, 200));
    }

    private void formatMenuItemActionPerformed(ActionEvent evt) {
        Tools.WindowCenter(new ImageFormatDialog((Frame)this, true));
    }

    private void duplicateMenuItemActionPerformed(ActionEvent evt) {
        String strNum = "";
        if (!this.list.isSelectionEmpty()) {
            try {
                Protein protein = this.getIndexProtein(this.list.getSelectedIndex());
                int selectNum = protein.getSelectNum();
                if (selectNum == -1) {
                    strNum = mode.equals("P") ? this.getDefaultID("Protein") : this.getDefaultID("Nucleotide");
                    Protein clonedProtein = (Protein)protein.clone();
                    String[] arrPro = clonedProtein.getParameter().split(DELIMIT);
                    arrPro[arrPro.length - 1] = strNum;
                    String arrFULL = "";
                    for (int i = 0; i < arrPro.length; ++i) {
                        String arr = arrPro[i];
                        arrFULL = i < arrPro.length - 1 ? arrFULL + arr + DELIMIT : arrFULL + arr;
                    }
                    clonedProtein.setParameter(arrFULL);
                    clonedProtein.setVertical(protein.getVertical() - 100);
                    this.canvasPanel.getProteinList().add(clonedProtein);
                    protein.setIsActive(false);
                } else {
                    int iwide;
                    Component clonedDomain;
                    LinkedList<Component> componentList = protein.getComponentList();
                    Component selectedComponent = componentList.get(selectNum);
                    if (selectedComponent.getType() == ComponentEnum.Domain) {
                        strNum = this.getDefaultID(ComponentEnum.Domain.name());
                        clonedDomain = (Component)selectedComponent.clone();
                        clonedDomain.fid = strNum;
                        iwide = (int)(selectedComponent.getX2() - selectedComponent.getX());
                        if (protein.getEnd() < (int)(selectedComponent.getX2() + 20.0 + (double)iwide)) {
                            clonedDomain.setX((int)selectedComponent.getX() - 20 - iwide);
                            clonedDomain.setX2((int)(selectedComponent.getX2() - 20.0 - (double)iwide));
                        } else {
                            clonedDomain.setX((int)selectedComponent.getX() + 20 + iwide);
                            clonedDomain.setX2((int)(selectedComponent.getX2() + 20.0 + (double)iwide));
                        }
                        clonedDomain.bSelected = true;
                        clonedDomain.setIsActive(true);
                        this.canvasPanel.ComponentSelect = clonedDomain;
                        clonedDomain.GeomArea = selectedComponent.GeomArea;
                        clonedDomain.setArea(selectedComponent.getArea());
                        componentList.add(clonedDomain);
                    }
                    if (selectedComponent.getType() == ComponentEnum.CutLine) {
                        strNum = this.getDefaultID(ComponentEnum.CutLine.name());
                        clonedDomain = (Component)selectedComponent.clone();
                        clonedDomain.fid = strNum;
                        iwide = (int)(selectedComponent.getX2() - selectedComponent.getX());
                        if (protein.getEnd() < (int)(selectedComponent.getX2() + 20.0 + (double)iwide)) {
                            clonedDomain.setX((int)selectedComponent.getX() - 20 - iwide);
                            clonedDomain.setX2((int)(selectedComponent.getX2() - 20.0 - (double)iwide));
                        } else {
                            clonedDomain.setX((int)selectedComponent.getX() + 20 + iwide);
                            clonedDomain.setX2((int)(selectedComponent.getX2() + 20.0 + (double)iwide));
                        }
                        clonedDomain.bSelected = true;
                        clonedDomain.setIsActive(true);
                        this.canvasPanel.ComponentSelect = clonedDomain;
                        clonedDomain.GeomArea = selectedComponent.GeomArea;
                        clonedDomain.setArea(selectedComponent.getArea());
                        componentList.add(clonedDomain);
                    } else if (selectedComponent.getType() == ComponentEnum.Site) {
                        strNum = this.getDefaultID(ComponentEnum.Site.name());
                        Component clonedSite = (Component)selectedComponent.clone();
                        clonedSite.fid = strNum;
                        int deltacenterx = 0;
                        int deltacentery = 0;
                        int deltaposition = 0;
                        int proteinlen = 0;
                        String sdeltacenterx = "";
                        String sdeltacentery = "";
                        String sdeltaposition = "";
                        sdeltacenterx = this.config.getString("SiteClone.deltaCenterxRate");
                        sdeltacentery = this.config.getString("SiteClone.deltaCenteryRate");
                        sdeltaposition = this.config.getString("SiteClone.deltaPositionRate");
                        proteinlen = protein.getEnd();
                        deltacenterx = (int)((double)proteinlen * Double.parseDouble(sdeltacenterx));
                        deltacentery = (int)((double)proteinlen * Double.parseDouble(sdeltacentery));
                        deltaposition = (int)((double)proteinlen * Double.parseDouble(sdeltaposition));
                        clonedSite.setX(selectedComponent.getX() + (double)deltacenterx);
                        clonedSite.setY(selectedComponent.getY() + deltacentery);
                        clonedSite.setCenterx(selectedComponent.getCenterx() + (double)deltacenterx);
                        clonedSite.setCentery(selectedComponent.getCentery() + (double)deltacentery);
                        String[] arr = selectedComponent.getParameter().split(DELIMIT);
                        String fsite = arr[0];
                        StringTokenizer st = new StringTokenizer(fsite, ";");
                        int siteCount = st.countTokens();
                        String nsite = " ";
                        while (st.hasMoreTokens()) {
                            int tsite = Integer.parseInt(st.nextToken());
                            tsite += deltaposition;
                            if (nsite.equals(" ")) {
                                nsite = String.valueOf(tsite);
                                continue;
                            }
                            nsite = nsite + ";" + String.valueOf(tsite);
                        }
                        String nParameter = "";
                        arr[0] = nsite;
                        for (int l = 0; l < arr.length; ++l) {
                            nParameter = l == 0 ? arr[l] : nParameter + DELIMIT + arr[l];
                        }
                        clonedSite.parameter = nParameter;
                        clonedSite.bSelected = true;
                        clonedSite.setIsActive(true);
                        this.canvasPanel.ComponentSelect = clonedSite;
                        clonedSite.GeomArea = selectedComponent.GeomArea;
                        clonedSite.setArea(selectedComponent.getArea());
                        componentList.add(clonedSite);
                    } else if (selectedComponent.getType() == ComponentEnum.Note) {
                        strNum = this.getDefaultID(ComponentEnum.Note.name());
                        Component clonedNote = (Component)selectedComponent.clone();
                        clonedNote.fid = strNum;
                        clonedNote.setX(selectedComponent.getX() + 30.0);
                        clonedNote.setY(selectedComponent.getY() + 30);
                        clonedNote.bSelected = true;
                        clonedNote.setIsActive(true);
                        this.canvasPanel.ComponentSelect = clonedNote;
                        clonedNote.GeomArea = selectedComponent.GeomArea;
                        clonedNote.setArea(selectedComponent.getArea());
                        componentList.add(clonedNote);
                    } else if (selectedComponent.getType() == ComponentEnum.Line) {
                        strNum = this.getDefaultID(ComponentEnum.Line.name());
                        Component clonedLine = (Component)selectedComponent.clone();
                        clonedLine.fid = strNum;
                        clonedLine.setX(selectedComponent.getX() + 30.0);
                        clonedLine.setY(selectedComponent.getY() + 30);
                        clonedLine.setControlx1(selectedComponent.getControlx1() + 30);
                        clonedLine.setControly1(selectedComponent.getControly1() + 30);
                        clonedLine.setControlx2(selectedComponent.getControlx2() + 30);
                        clonedLine.setControly2(selectedComponent.getControly2() + 30);
                        clonedLine.setX2(selectedComponent.getX2() + 30.0);
                        clonedLine.setY2(selectedComponent.getY2() + 30);
                        clonedLine.bSelected = true;
                        clonedLine.setIsActive(true);
                        this.canvasPanel.ComponentSelect = clonedLine;
                        clonedLine.GeomArea = selectedComponent.GeomArea;
                        clonedLine.setArea(selectedComponent.getArea());
                        componentList.add(clonedLine);
                    } else if (selectedComponent.getType() == ComponentEnum.Polygon) {
                        strNum = this.getDefaultID(ComponentEnum.Polygon.name());
                        Component clonedPolygon = (Component)selectedComponent.clone();
                        clonedPolygon.fid = strNum;
                        clonedPolygon.setCenterx(selectedComponent.getCenterx() + 30.0);
                        clonedPolygon.setCentery(selectedComponent.getCentery() + 30.0);
                        clonedPolygon.bSelected = true;
                        clonedPolygon.setIsActive(true);
                        this.canvasPanel.ComponentSelect = clonedPolygon;
                        clonedPolygon.GeomArea = selectedComponent.GeomArea;
                        clonedPolygon.setArea(selectedComponent.getArea());
                        componentList.add(clonedPolygon);
                    } else if (selectedComponent.getType() == ComponentEnum.Bracket) {
                        strNum = this.getDefaultID(ComponentEnum.Bracket.name());
                        Component clonedBracket = (Component)selectedComponent.clone();
                        clonedBracket.fid = strNum;
                        clonedBracket.setCenterx(selectedComponent.getCenterx() + 30.0);
                        clonedBracket.setCentery(selectedComponent.getCentery() + 30.0);
                        clonedBracket.bSelected = true;
                        clonedBracket.setIsActive(true);
                        this.canvasPanel.ComponentSelect = clonedBracket;
                        clonedBracket.GeomArea = selectedComponent.GeomArea;
                        clonedBracket.setArea(selectedComponent.getArea());
                        componentList.add(clonedBracket);
                    }
                    selectedComponent.setIsActive(false);
                    selectedComponent.setbSelected(false);
                }
                this.canvasPanel.repaint();
                this.repaintList();
                try {
                    this.canvasPanel.saveCurrentState();
                }
                catch (CloneNotSupportedException ex) {
                    ex.printStackTrace();
                }
            }
            catch (CloneNotSupportedException ex) {
                Logger.getLogger(IBSFrame.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void editComponentMenuItemActionPerformed(ActionEvent evt) {
        if (!this.list.isSelectionEmpty()) {
            this.callEditDialog();
        }
    }

    private void newMenuItemActionPerformed(ActionEvent evt) {
        boolean isNew = false;
        if (this.canvasPanel.getProteinList().size() > 0) {
            int confirm = JOptionPane.showConfirmDialog(null, "Do you want to save the current project?", "Warning", 1, 2, null);
            if (confirm == 0) {
                this.saveProject();
                isNew = true;
            } else {
                isNew = confirm == 1;
            }
        } else {
            isNew = true;
        }
        if (isNew) {
            this.canvasPanel.setProteinList(new LinkedList<Protein>());
            this.canvasPanel.repaint();
            listModel.clear();
            this.newProject();
        }
    }

    private void updateMenuItemActionPerformed(ActionEvent evt) {
        try {
            ApplicationLauncher.launchApplication((String)"265", null, (boolean)false, null);
        }
        catch (IOException e) {
            e.printStackTrace();
            JOptionPane.showConfirmDialog(this, "Could not launch installer application.", "Error", 0);
        }
    }

    private void batchExportMenuItemActionPerformed(ActionEvent evt) {
        Tools.WindowCenter(new BatchOutputJDialog(this, true, mode));
    }

    private void canvasMenuItemActionPerformed(ActionEvent evt) {
        Tools.WindowCenter(new CanvasSizeDialog(this.canvasPanel, this, true));
        this.setCanvasSize();
    }

    private void lineButtonActionPerformed(ActionEvent evt) {
        if (this.canvasPanel.getProteinList().size() == 0) {
            int confirm = JOptionPane.showConfirmDialog(null, "Please create a new protein.", "Warning", 2, 2, null);
            if (confirm == 0) {
                this.newProject();
            }
        } else {
            Integer cx1 = null;
            Integer cy1 = null;
            Integer cx2 = null;
            Integer cy2 = null;
            int proteinlenth = this.canvasPanel.getCurrentProtein().getEnd();
            String strNum = this.getDefaultID(ComponentEnum.Line.name());
            this.addComponent(new LineDialog(this, " Add Line:" + ShapeEnum.Straight.name(), true, ShapeEnum.Straight, cx1, cy1, cx2, cy2, proteinlenth, strNum));
        }
    }

    private void jMenuItem1ActionPerformed(ActionEvent evt) {
        if (this.canvasPanel.getProteinList().size() > 0) {
            int confirm = JOptionPane.showConfirmDialog(this, "Do you want to save the current project?", "Warning", 1, 2, null);
            if (confirm == 0) {
                this.saveProject();
                this.dispose();
                listModel.clear();
                IBSFrame shapeIBSFramen = new IBSFrame("N");
                shapeIBSFramen.images = this.images;
                shapeIBSFramen.images = this.images;
                shapeIBSFramen.imagesShape = this.imagesShape;
                shapeIBSFramen.imagesShapeSite = this.imagesShapeSite;
                shapeIBSFramen.imagesGradient = this.imagesGradient;
                shapeIBSFramen.imagesShapeMarker = this.imagesShapeMarker;
                shapeIBSFramen.imagesShapeCutLine = this.imagesShapeCutLine;
                mode = "N";
                shapeIBSFramen.jMenuItem1.setEnabled(false);
                shapeIBSFramen.jMenuItem2.setEnabled(true);
                Tools.WindowCenter(shapeIBSFramen);
                shapeIBSFramen.show();
            } else if (confirm == 1) {
                this.dispose();
                listModel.clear();
                IBSFrame shapeIBSFramen = new IBSFrame("N");
                shapeIBSFramen.images = this.images;
                shapeIBSFramen.images = this.images;
                shapeIBSFramen.imagesShape = this.imagesShape;
                shapeIBSFramen.imagesShapeSite = this.imagesShapeSite;
                shapeIBSFramen.imagesGradient = this.imagesGradient;
                shapeIBSFramen.imagesShapeMarker = this.imagesShapeMarker;
                shapeIBSFramen.imagesShapeCutLine = this.imagesShapeCutLine;
                mode = "N";
                shapeIBSFramen.jMenuItem1.setEnabled(false);
                shapeIBSFramen.jMenuItem2.setEnabled(true);
                Tools.WindowCenter(shapeIBSFramen);
                shapeIBSFramen.show();
            }
        } else {
            this.dispose();
            listModel.clear();
            IBSFrame shapeIBSFramen = new IBSFrame("N");
            shapeIBSFramen.images = this.images;
            shapeIBSFramen.images = this.images;
            shapeIBSFramen.imagesShape = this.imagesShape;
            shapeIBSFramen.imagesShapeSite = this.imagesShapeSite;
            shapeIBSFramen.imagesGradient = this.imagesGradient;
            shapeIBSFramen.imagesShapeMarker = this.imagesShapeMarker;
            shapeIBSFramen.imagesShapeCutLine = this.imagesShapeCutLine;
            mode = "N";
            shapeIBSFramen.jMenuItem1.setEnabled(false);
            shapeIBSFramen.jMenuItem2.setEnabled(true);
            this.demoMenuItem.setEnabled(false);
            Tools.WindowCenter(shapeIBSFramen);
            shapeIBSFramen.show();
        }
    }

    private void jCheckBoxGrayItemStateChanged(ItemEvent evt) {
        if (this.jCheckBoxGray.isSelected()) {
            this.canvasPanel.setbGray(true);
        } else {
            this.canvasPanel.setbGray(false);
        }
        this.canvasPanel.repaint();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        if (this.canvasPanel.getProteinList().size() == 0) {
            int confirm = mode.equals("P") ? JOptionPane.showConfirmDialog(null, "Please create a new protein.", "Warning", 2, 2, null) : JOptionPane.showConfirmDialog(null, "Please create a new nucleotide.", "Warning", 2, 2, null);
            if (confirm == 0) {
                this.newProject();
            }
        } else {
            this.canvasPanel.clearComponentActiveState();
            String strNum = this.getDefaultID(ComponentEnum.Note.name());
            this.addComponent(new NoteDialog((Frame)this, " Add Note", true, strNum));
        }
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        if (this.canvasPanel.getProteinList().size() == 0) {
            int confirm = mode.equals("P") ? JOptionPane.showConfirmDialog(null, "Please create a new protein.", "Warning", 2, 2, null) : JOptionPane.showConfirmDialog(null, "Please create a new nucleotide.", "Warning", 2, 2, null);
            if (confirm == 0) {
                this.newProject();
            }
        } else {
            this.canvasPanel.clearComponentActiveState();
            int proteinlenth = this.canvasPanel.getCurrentProtein().getEnd();
            String strNum = this.getDefaultID(ComponentEnum.Polygon.name());
            this.addComponent(new PolygonDialog(this, " Add Marker", true, this.images, this.imagesShapeMarker, this.imagesGradient, proteinlenth, strNum));
        }
    }

    private void jButtonBracketActionPerformed(ActionEvent evt) {
        if (this.canvasPanel.getProteinList().size() == 0) {
            int confirm = mode.equals("P") ? JOptionPane.showConfirmDialog(null, "Please create a new protein.", "Warning", 2, 2, null) : JOptionPane.showConfirmDialog(null, "Please create a new nucleotide.", "Warning", 2, 2, null);
            if (confirm == 0) {
                this.newProject();
            }
        } else {
            this.canvasPanel.clearComponentActiveState();
            int proteinlenth = this.canvasPanel.getCurrentProtein().getEnd();
            String strNum = this.getDefaultID(ComponentEnum.Bracket.name());
            this.addComponent(new BracketDialog(this, " Add Bracket", true, proteinlenth, strNum));
        }
    }

    private void jButtonStraightActionPerformed(ActionEvent evt) {
        if (this.canvasPanel.getProteinList().size() == 0) {
            int confirm = mode.equals("P") ? JOptionPane.showConfirmDialog(null, "Please create a new protein.", "Warning", 2, 2, null) : JOptionPane.showConfirmDialog(null, "Please create a new nucleotide.", "Warning", 2, 2, null);
            if (confirm == 0) {
                this.newProject();
            }
        } else {
            this.canvasPanel.clearComponentActiveState();
            Integer cx1 = null;
            Integer cy1 = null;
            Integer cx2 = null;
            Integer cy2 = null;
            int proteinlenth = this.canvasPanel.getCurrentProtein().getEnd();
            String strNum = this.getDefaultID(ComponentEnum.Line.name());
            this.addComponent(new LineDialog(this, " Add a straight line:", true, ShapeEnum.Straight, cx1, cy1, cx2, cy2, proteinlenth, strNum));
        }
    }

    private void jButtonPolylineOneActionPerformed(ActionEvent evt) {
        if (this.canvasPanel.getProteinList().size() == 0) {
            int confirm = mode.equals("P") ? JOptionPane.showConfirmDialog(null, "Please create a new protein.", "Warning", 2, 2, null) : JOptionPane.showConfirmDialog(null, "Please create a new nucleotide.", "Warning", 2, 2, null);
            if (confirm == 0) {
                this.newProject();
            }
        } else {
            this.canvasPanel.clearComponentActiveState();
            Integer cx1 = null;
            Integer cy1 = null;
            Integer cx2 = null;
            Integer cy2 = null;
            int proteinlenth = this.canvasPanel.getCurrentProtein().getEnd();
            String strNum = this.getDefaultID(ComponentEnum.Line.name());
            this.addComponent(new LineDialog(this, " Add a polyline with one  knuckle point:", true, ShapeEnum.PolylineOne, cx1, cy1, cx2, cy2, proteinlenth, strNum));
        }
    }

    private void jButtonPolylineTwoActionPerformed(ActionEvent evt) {
        if (this.canvasPanel.getProteinList().size() == 0) {
            int confirm = mode.equals("P") ? JOptionPane.showConfirmDialog(null, "Please create a new protein.", "Warning", 2, 2, null) : JOptionPane.showConfirmDialog(null, "Please create a new nucleotide.", "Warning", 2, 2, null);
            if (confirm == 0) {
                this.newProject();
            }
        } else {
            this.canvasPanel.clearComponentActiveState();
            Integer cx1 = null;
            Integer cy1 = null;
            Integer cx2 = null;
            Integer cy2 = null;
            int proteinlenth = this.canvasPanel.getCurrentProtein().getEnd();
            String strNum = this.getDefaultID(ComponentEnum.Line.name());
            this.addComponent(new LineDialog(this, " Add a polyline with two  knuckle points:", true, ShapeEnum.PolylineTwo, cx1, cy1, cx2, cy2, proteinlenth, strNum));
        }
    }

    private void jButtonCurveActionPerformed(ActionEvent evt) {
        if (this.canvasPanel.getProteinList().size() == 0) {
            int confirm = mode.equals("P") ? JOptionPane.showConfirmDialog(null, "Please create a new protein.", "Warning", 2, 2, null) : JOptionPane.showConfirmDialog(null, "Please create a new nucleotide.", "Warning", 2, 2, null);
            if (confirm == 0) {
                this.newProject();
            }
        } else {
            this.canvasPanel.clearComponentActiveState();
            Integer cx1 = null;
            Integer cy1 = null;
            Integer cx2 = null;
            Integer cy2 = null;
            int proteinlenth = this.canvasPanel.getCurrentProtein().getEnd();
            String strNum = this.getDefaultID(ComponentEnum.Line.name());
            this.addComponent(new LineDialog(this, " Add a curve:" + ShapeEnum.Curve.name(), true, ShapeEnum.Curve, cx1, cy1, cx2, cy2, proteinlenth, strNum));
        }
    }

    private void jButtonBezierActionPerformed(ActionEvent evt) {
        if (this.canvasPanel.getProteinList().size() == 0) {
            int confirm = mode.equals("P") ? JOptionPane.showConfirmDialog(null, "Please create a new protein.", "Warning", 2, 2, null) : JOptionPane.showConfirmDialog(null, "Please create a new nucleotide.", "Warning", 2, 2, null);
            if (confirm == 0) {
                this.newProject();
            }
        } else {
            this.canvasPanel.clearComponentActiveState();
            Integer cx1 = null;
            Integer cy1 = null;
            Integer cx2 = null;
            Integer cy2 = null;
            int proteinlenth = this.canvasPanel.getCurrentProtein().getEnd();
            String strNum = this.getDefaultID(ComponentEnum.Line.name());
            this.addComponent(new LineDialog(this, " Add a bezier curve:", true, ShapeEnum.Bezier, cx1, cy1, cx2, cy2, proteinlenth, strNum));
        }
    }

    private void jButtonSelectUndoActionPerformed(ActionEvent evt) {
        try {
            this.canvasPanel.undo();
        }
        catch (CloneNotSupportedException ex) {
            Logger.getLogger(CanvasPanel.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.repaintList();
    }

    private void jButtonSelectRedoActionPerformed(ActionEvent evt) {
        try {
            this.canvasPanel.redo();
        }
        catch (CloneNotSupportedException ex) {
            Logger.getLogger(CanvasPanel.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.repaintList();
    }

    private void moveDownMenuItem1ActionPerformed(ActionEvent evt) {
        if (!this.list.isSelectionEmpty()) {
            Protein protein = this.getIndexProtein(this.list.getSelectedIndex());
            int selectNum = protein.getSelectNum();
            LinkedList<Component> componentList = protein.getComponentList();
            if (selectNum >= 0 && selectNum < componentList.size() - 1) {
                Component temp = componentList.get(selectNum + 1);
                componentList.set(selectNum + 1, componentList.get(selectNum));
                componentList.set(selectNum, temp);
                this.canvasPanel.repaint();
                this.repaintList();
                try {
                    this.canvasPanel.saveCurrentState();
                }
                catch (CloneNotSupportedException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public int getSelectIndex(double dscale) {
        int index = 4;
        if (dscale <= 0.7) {
            index = 0;
        } else if (dscale > 0.7 && dscale <= 0.8) {
            index = 1;
        } else if (dscale > 0.8 && dscale <= 0.9) {
            index = 2;
        } else if (dscale > 0.9 && dscale <= 1.0) {
            index = 3;
        } else if (dscale > 1.0 && dscale <= 1.5) {
            index = 4;
        } else if (dscale > 1.5 && dscale <= 2.0) {
            index = 5;
        } else if (dscale > 2.0 && dscale <= 2.5) {
            index = 6;
        } else if (dscale > 2.5 && dscale <= 3.0) {
            index = 7;
        } else if (dscale > 3.0 && dscale <= 3.5) {
            index = 8;
        } else if (dscale > 3.5 && dscale <= 4.0) {
            index = 9;
        } else if (dscale > 4.0 && dscale <= 4.5) {
            index = 10;
        } else if (dscale > 4.5 && dscale <= 5.0) {
            index = 11;
        } else if (dscale > 5.0 && dscale <= 5.5) {
            index = 12;
        } else if (dscale > 5.5 && dscale <= 6.0) {
            index = 13;
        } else if (dscale > 6.0 && dscale <= 6.5) {
            index = 14;
        } else if (dscale > 6.5 && dscale <= 7.0) {
            index = 15;
        } else if (dscale > 7.0 && dscale <= 7.5) {
            index = 16;
        } else if (dscale >= 7.5) {
            index = 17;
        }
        return index;
    }

    private void jComboBoxScaleActionPerformed(ActionEvent evt) {
        if (this.isOpening) {
            return;
        }
        int index = this.jComboBoxScale.getSelectedIndex();
        double dscale = 1.0;
        if (index == 0) {
            dscale = 0.7;
        } else if (index == 1) {
            dscale = 0.8;
        } else if (index == 2) {
            dscale = 0.9;
        } else if (index == 3) {
            dscale = 1.0;
        } else if (index == 4) {
            dscale = 1.5;
        } else if (index == 5) {
            dscale = 2.0;
        } else if (index == 6) {
            dscale = 2.5;
        } else if (index == 7) {
            dscale = 3.0;
        } else if (index == 8) {
            dscale = 3.5;
        } else if (index == 9) {
            dscale = 4.0;
        } else if (index == 10) {
            dscale = 4.5;
        } else if (index == 11) {
            dscale = 5.0;
        } else if (index == 12) {
            dscale = 5.5;
        } else if (index == 13) {
            dscale = 6.0;
        } else if (index == 14) {
            dscale = 6.5;
        } else if (index == 15) {
            dscale = 7.0;
        } else if (index == 16) {
            dscale = 7.5;
        } else if (index == 17) {
            dscale = 8.0;
        }
        this.currentindexrate = index;
        this.canvasPanel.zoomOutScale(dscale);
        if (this.canvasPanel.getWidth() > canvasScrollPane.getWidth()) {
            canvasScrollPane.getViewport().setViewPosition(new Point(this.canvasPanel.getWidth() / 4, this.canvasPanel.getHeight() / 4));
        }
        this.setCanvasSize();
    }

    private void cutLineButtonActionPerformed1(ActionEvent evt) {
        if (this.canvasPanel.getProteinList().size() == 0) {
            int confirm = mode.equals("P") ? JOptionPane.showConfirmDialog(null, "Please create a new protein.", "Warning", 2, 2, null) : JOptionPane.showConfirmDialog(null, "Please create a new nucleotide.", "Warning", 2, 2, null);
            if (confirm == 0) {
                this.newProject();
            }
        } else {
            String[] arrPro = this.canvasPanel.getCurrentProtein().getParameter().split(DELIMIT);
            int proteinlen = this.canvasPanel.getCurrentProtein().getEnd();
            int proteinHeight = Integer.parseInt(arrPro[4]);
            String strNum = this.getDefaultID(ComponentEnum.CutLine.name());
            this.addComponent(new CutLineDialog(this, " Add CutLine", this.imagesShapeCutLine, true, proteinHeight, proteinlen, mode, strNum));
        }
    }

    private void cutLineButton1ActionPerformed1(ActionEvent evt) {
        if (this.canvasPanel.getProteinList().size() == 0) {
            int confirm = mode.equals("P") ? JOptionPane.showConfirmDialog(null, "Please create a new protein.", "Warning", 2, 2, null) : JOptionPane.showConfirmDialog(null, "Please create a new nucleotide.", "Warning", 2, 2, null);
            if (confirm == 0) {
                this.newProject();
            }
        } else {
            this.canvasPanel.clearComponentActiveState();
            String strNum = this.getDefaultID(ComponentEnum.Note.name());
            this.addComponent(new NoteDialog((Frame)this, " Add Note", true, strNum));
        }
    }

    private void editMenuActionPerformed(ActionEvent evt) {
    }

    private void lineMenuItemlineButtonActionPerformed(ActionEvent evt) {
        if (this.canvasPanel.getProteinList().size() == 0) {
            int confirm = JOptionPane.showConfirmDialog(null, "Please create a new protein.", "Warning", 2, 2, null);
            if (confirm == 0) {
                this.newProject();
            }
        } else {
            this.canvasPanel.clearComponentActiveState();
            int proteinlenth = this.canvasPanel.getCurrentProtein().getEnd();
            String strNum = this.getDefaultID(ComponentEnum.Bracket.name());
            this.addComponent(new BracketDialog(this, " Add Bracket", true, proteinlenth, strNum));
        }
    }

    private void jMenuItem3ActionPerformed(ActionEvent evt) {
        if (this.canvasPanel.getProteinList().size() == 0) {
            int confirm = JOptionPane.showConfirmDialog(null, "Please create a new protein.", "Warning", 2, 2, null);
            if (confirm == 0) {
                this.newProject();
            }
        } else {
            this.canvasPanel.clearComponentActiveState();
            Integer cx1 = null;
            Integer cy1 = null;
            Integer cx2 = null;
            Integer cy2 = null;
            int proteinlenth = this.canvasPanel.getCurrentProtein().getEnd();
            String strNum = this.getDefaultID(ComponentEnum.Line.name());
            this.addComponent(new LineDialog(this, " Add Line:" + ShapeEnum.Straight.name(), true, ShapeEnum.Straight, cx1, cy1, cx2, cy2, proteinlenth, strNum));
        }
    }

    private void jMenuItem4ActionPerformed(ActionEvent evt) {
        if (this.canvasPanel.getProteinList().size() == 0) {
            int confirm = JOptionPane.showConfirmDialog(null, "Please create a new protein.", "Warning", 2, 2, null);
            if (confirm == 0) {
                this.newProject();
            }
        } else {
            this.canvasPanel.clearComponentActiveState();
            Integer cx1 = null;
            Integer cy1 = null;
            Integer cx2 = null;
            Integer cy2 = null;
            int proteinlenth = this.canvasPanel.getCurrentProtein().getEnd();
            String strNum = this.getDefaultID(ComponentEnum.Line.name());
            this.addComponent(new LineDialog(this, " Add Line:" + ShapeEnum.Curve.name(), true, ShapeEnum.Curve, cx1, cy1, cx2, cy2, proteinlenth, strNum));
        }
    }

    private void jMenuItem6ActionPerformed(ActionEvent evt) {
        if (this.canvasPanel.getProteinList().size() == 0) {
            int confirm = JOptionPane.showConfirmDialog(null, "Please create a new protein.", "Warning", 2, 2, null);
            if (confirm == 0) {
                this.newProject();
            }
        } else {
            this.canvasPanel.clearComponentActiveState();
            Integer cx1 = null;
            Integer cy1 = null;
            Integer cx2 = null;
            Integer cy2 = null;
            int proteinlenth = this.canvasPanel.getCurrentProtein().getEnd();
            String strNum = this.getDefaultID(ComponentEnum.Line.name());
            this.addComponent(new LineDialog(this, " Add Line:" + ShapeEnum.Bezier.name(), true, ShapeEnum.Bezier, cx1, cy1, cx2, cy2, proteinlenth, strNum));
        }
    }

    private void jMenuItem5ActionPerformed(ActionEvent evt) {
        if (this.canvasPanel.getProteinList().size() == 0) {
            int confirm = JOptionPane.showConfirmDialog(null, "Please create a new protein.", "Warning", 2, 2, null);
            if (confirm == 0) {
                this.newProject();
            }
        } else {
            this.canvasPanel.clearComponentActiveState();
            Integer cx1 = null;
            Integer cy1 = null;
            Integer cx2 = null;
            Integer cy2 = null;
            int proteinlenth = this.canvasPanel.getCurrentProtein().getEnd();
            String strNum = this.getDefaultID(ComponentEnum.Line.name());
            this.addComponent(new LineDialog(this, " Add Line:" + ShapeEnum.PolylineTwo.name(), true, ShapeEnum.PolylineTwo, cx1, cy1, cx2, cy2, proteinlenth, strNum));
        }
    }

    private void jMenuItem7ActionPerformed(ActionEvent evt) {
        if (this.canvasPanel.getProteinList().size() == 0) {
            int confirm = JOptionPane.showConfirmDialog(null, "Please create a new protein.", "Warning", 2, 2, null);
            if (confirm == 0) {
                this.newProject();
            }
        } else {
            this.canvasPanel.clearComponentActiveState();
            Integer cx1 = null;
            Integer cy1 = null;
            Integer cx2 = null;
            Integer cy2 = null;
            int proteinlenth = this.canvasPanel.getCurrentProtein().getEnd();
            String strNum = this.getDefaultID(ComponentEnum.Line.name());
            this.addComponent(new LineDialog(this, " Add Line:" + ShapeEnum.PolylineOne.name(), true, ShapeEnum.PolylineOne, cx1, cy1, cx2, cy2, proteinlenth, strNum));
        }
    }

    private void jMenuItem2ActionPerformed(ActionEvent evt) {
        if (this.canvasPanel.getProteinList().size() > 0) {
            int confirm = JOptionPane.showConfirmDialog(this, "Do you want to save the current project?", "Warning", 1, 2, null);
            if (confirm == 0) {
                this.saveProject();
                this.dispose();
                listModel.clear();
                IBSFrame shapeIBSFramep = new IBSFrame("P");
                shapeIBSFramep.images = this.images;
                shapeIBSFramep.imagesShape = this.imagesShape;
                shapeIBSFramep.imagesShapeSite = this.imagesShapeSite;
                shapeIBSFramep.imagesShapeMarker = this.imagesShapeMarker;
                shapeIBSFramep.imagesGradient = this.imagesGradient;
                shapeIBSFramep.imagesShapeCutLine = this.imagesShapeCutLine;
                mode = "P";
                shapeIBSFramep.jMenuItem2.setEnabled(false);
                shapeIBSFramep.jMenuItem1.setEnabled(true);
                this.demoMenuItem.setEnabled(true);
                Tools.WindowCenter(shapeIBSFramep);
                shapeIBSFramep.show();
            } else if (confirm == 1) {
                this.dispose();
                listModel.clear();
                IBSFrame shapeIBSFramep = new IBSFrame("P");
                shapeIBSFramep.images = this.images;
                shapeIBSFramep.imagesShape = this.imagesShape;
                shapeIBSFramep.imagesShapeSite = this.imagesShapeSite;
                shapeIBSFramep.imagesShapeMarker = this.imagesShapeMarker;
                shapeIBSFramep.imagesGradient = this.imagesGradient;
                shapeIBSFramep.imagesShapeCutLine = this.imagesShapeCutLine;
                mode = "P";
                shapeIBSFramep.jMenuItem2.setEnabled(false);
                shapeIBSFramep.jMenuItem1.setEnabled(true);
                this.demoMenuItem.setEnabled(true);
                Tools.WindowCenter(shapeIBSFramep);
                shapeIBSFramep.show();
            }
        } else {
            this.dispose();
            listModel.clear();
            IBSFrame shapeIBSFramep = new IBSFrame("P");
            shapeIBSFramep.images = this.images;
            shapeIBSFramep.imagesShape = this.imagesShape;
            shapeIBSFramep.imagesShapeSite = this.imagesShapeSite;
            shapeIBSFramep.imagesShapeMarker = this.imagesShapeMarker;
            shapeIBSFramep.imagesGradient = this.imagesGradient;
            shapeIBSFramep.imagesShapeCutLine = this.imagesShapeCutLine;
            mode = "P";
            shapeIBSFramep.jMenuItem2.setEnabled(false);
            shapeIBSFramep.jMenuItem1.setEnabled(true);
            this.demoMenuItem.setEnabled(true);
            Tools.WindowCenter(shapeIBSFramep);
            shapeIBSFramep.show();
        }
    }

    private void jMenuItemUndoActionPerformed(ActionEvent evt) {
        try {
            this.canvasPanel.undo();
        }
        catch (CloneNotSupportedException ex) {
            Logger.getLogger(CanvasPanel.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.repaintList();
    }

    private void jMenuItemRedoActionPerformed(ActionEvent evt) {
        try {
            this.canvasPanel.redo();
        }
        catch (CloneNotSupportedException ex) {
            Logger.getLogger(CanvasPanel.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.repaintList();
    }

    private void jMenuItem8ActionPerformed(ActionEvent evt) {
        if (this.canvasPanel.getProteinList().size() == 0) {
            int confirm = mode.equals("P") ? JOptionPane.showConfirmDialog(null, "Please create a new protein.", "Warning", 2, 2, null) : JOptionPane.showConfirmDialog(null, "Please create a new nucleotide.", "Warning", 2, 2, null);
            if (confirm == 0) {
                this.newProject();
            }
        } else {
            String[] arrPro = this.canvasPanel.getCurrentProtein().getParameter().split(DELIMIT);
            int proteinlen = this.canvasPanel.getCurrentProtein().getEnd();
            int proteinHeight = Integer.parseInt(arrPro[4]);
            String strNum = this.getDefaultID(ComponentEnum.CutLine.name());
            this.addComponent(new CutLineDialog(this, " Add CutLine", this.imagesShapeCutLine, true, proteinHeight, proteinlen, mode, strNum));
        }
    }

    private void moveTopMenuItemActionPerformed(ActionEvent evt) {
        Protein protein;
        int selectNum;
        if (!this.list.isSelectionEmpty() && (selectNum = (protein = this.getIndexProtein(this.list.getSelectedIndex())).getSelectNum()) > 0) {
            LinkedList<Component> componentList = protein.getComponentList();
            Component temp = componentList.get(0);
            componentList.set(0, componentList.get(selectNum));
            componentList.set(selectNum, temp);
            this.canvasPanel.repaint();
            this.repaintList();
            try {
                this.canvasPanel.saveCurrentState();
            }
            catch (CloneNotSupportedException ex) {
                ex.printStackTrace();
            }
        }
    }

    private void moveEndMenuItemActionPerformed(ActionEvent evt) {
        if (!this.list.isSelectionEmpty()) {
            Protein protein = this.getIndexProtein(this.list.getSelectedIndex());
            int selectNum = protein.getSelectNum();
            LinkedList<Component> componentList = protein.getComponentList();
            if (selectNum >= 0 && selectNum < componentList.size() - 1) {
                Component temp = componentList.get(componentList.size() - 1);
                componentList.set(componentList.size() - 1, componentList.get(selectNum));
                componentList.set(selectNum, temp);
                this.canvasPanel.repaint();
                this.repaintList();
                try {
                    this.canvasPanel.saveCurrentState();
                }
                catch (CloneNotSupportedException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    private void moveTopMenuItem1ActionPerformed(ActionEvent evt) {
        Protein protein;
        int selectNum;
        if (!this.list.isSelectionEmpty() && (selectNum = (protein = this.getIndexProtein(this.list.getSelectedIndex())).getSelectNum()) > 0) {
            LinkedList<Component> componentList = protein.getComponentList();
            Component temp = componentList.get(0);
            componentList.set(0, componentList.get(selectNum));
            componentList.set(selectNum, temp);
            this.canvasPanel.repaint();
            this.repaintList();
            try {
                this.canvasPanel.saveCurrentState();
            }
            catch (CloneNotSupportedException ex) {
                ex.printStackTrace();
            }
        }
    }

    private void canvasScrollPaneMouseClicked(MouseEvent evt) {
        this.canvasPanel.setFocusable(true);
        canvasScrollPane.setFocusable(false);
        this.jComboBoxScale.setFocusable(false);
        this.list.setFocusable(false);
    }

    private void canvasScrollPaneMousePressed(MouseEvent evt) {
        this.canvasPanel.setFocusable(true);
        canvasScrollPane.setFocusable(false);
        this.jComboBoxScale.setFocusable(false);
        this.list.setFocusable(false);
    }

    private void jComboBoxScaleMouseClicked(MouseEvent evt) {
        this.canvasPanel.setFocusable(true);
        this.jComboBoxScale.setFocusable(true);
        this.list.setFocusable(false);
    }

    private void jComboBoxScaleMousePressed(MouseEvent evt) {
        this.canvasPanel.setFocusable(true);
        this.jComboBoxScale.setFocusable(true);
        this.list.setFocusable(false);
    }

    private void listValueChanged(ListSelectionEvent evt) {
        if (!this.list.isSelectionEmpty()) {
            this.selectComponent();
        }
    }

    private void moveUpMenuItem1ActionPerformed(ActionEvent evt) {
        Protein protein;
        int selectNum;
        if (!this.list.isSelectionEmpty() && (selectNum = (protein = this.getIndexProtein(this.list.getSelectedIndex())).getSelectNum()) > 0) {
            LinkedList<Component> componentList = protein.getComponentList();
            Component temp = componentList.get(selectNum - 1);
            componentList.set(selectNum - 1, componentList.get(selectNum));
            componentList.set(selectNum, temp);
            this.canvasPanel.repaint();
            this.repaintList();
            try {
                this.canvasPanel.saveCurrentState();
            }
            catch (CloneNotSupportedException ex) {
                ex.printStackTrace();
            }
        }
    }

    private void moveEndMenuItem1ActionPerformed(ActionEvent evt) {
        if (!this.list.isSelectionEmpty()) {
            Protein protein = this.getIndexProtein(this.list.getSelectedIndex());
            int selectNum = protein.getSelectNum();
            LinkedList<Component> componentList = protein.getComponentList();
            if (selectNum >= 0 && selectNum < componentList.size() - 1) {
                Component temp = componentList.get(componentList.size() - 1);
                componentList.set(componentList.size() - 1, componentList.get(selectNum));
                componentList.set(selectNum, temp);
                this.canvasPanel.repaint();
                this.repaintList();
                try {
                    this.canvasPanel.saveCurrentState();
                }
                catch (CloneNotSupportedException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    private void drawPanelMouseClicked(MouseEvent evt) {
        this.canvasPanel.setFocusable(true);
        this.jComboBoxScale.setFocusable(false);
        this.list.setFocusable(false);
        if (SwingUtilities.isLeftMouseButton(evt) && evt.getClickCount() == 2) {
            this.callEditDialog(evt.getX() - this.canvasPanel.getWidth() / 2, evt.getY() - this.canvasPanel.getHeight() / 2);
        }
    }

    private void drawPanelMousePressed(MouseEvent evt) {
        this.canvasPanel.setFocusable(true);
        this.jComboBoxScale.setFocusable(false);
        this.list.setFocusable(false);
        if (SwingUtilities.isLeftMouseButton(evt)) {
            this.activeProtein(evt.getX() - this.canvasPanel.getWidth() / 2, evt.getY() - this.canvasPanel.getHeight() / 2);
        }
        if (SwingUtilities.isRightMouseButton(evt)) {
            this.activeProtein(evt.getX() - this.canvasPanel.getWidth() / 2, evt.getY() - this.canvasPanel.getHeight() / 2);
            if (this.canvasPanel.getProteinList().size() > 0) {
                this.panelMenu.show(evt.getComponent(), evt.getX(), evt.getY());
            }
        }
    }

    private void drawPanelMouseReleased(MouseEvent evt) {
        this.activeProtein(evt.getX() - this.canvasPanel.getWidth() / 2, evt.getY() - this.canvasPanel.getHeight() / 2);
    }

    private void drawPanelMouseWheelMoved(MouseWheelEvent evt) {
        int index;
        int icount = this.jComboBoxScale.getItemCount() - 1;
        index = evt.getWheelRotation() < 0 ? ((index = this.jComboBoxScale.getSelectedIndex()) >= icount ? icount : ++index) : ((index = this.jComboBoxScale.getSelectedIndex()) <= 0 ? 0 : --index);
        if (this.jComboBoxScale.getSelectedIndex() == index && index == 0) {
            return;
        }
        this.jComboBoxScale.setSelectedIndex(index);
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        block17: {
            boolean isNew = false;
            if (this.canvasPanel.getProteinList().size() > 0) {
                int confirm = JOptionPane.showConfirmDialog(null, "Do you want to save the current project?", "Warning", 1, 2, null);
                if (confirm == 0) {
                    this.saveProject();
                    isNew = true;
                } else {
                    isNew = confirm == 1;
                }
            } else {
                isNew = true;
            }
            if (isNew) {
                try {
                    Transferable tr = dtde.getTransferable();
                    if (dtde.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                        dtde.acceptDrop(3);
                        List filelist = (List)tr.getTransferData(DataFlavor.javaFileListFlavor);
                        for (File file : filelist) {
                            this.filePath = file.getAbsolutePath();
                            Project2XML pj = new Project2XML();
                            String strMode = pj.getXMLMode(this.filePath);
                            if (strMode.equals(mode)) {
                                Project project = new Project2XML(this.filePath).open(mode);
                                this.drawPanel(project, this.filePath);
                                this.setCanvasSize();
                                this.canvasPanel.setCurrentProteinNum(0);
                                Protein currentProtein = this.canvasPanel.getProteinList().getFirst();
                                try {
                                    PreviewPanel.protein = (Protein)currentProtein.clone();
                                }
                                catch (CloneNotSupportedException ex) {
                                    Logger.getLogger(IBSFrame.class.getName()).log(Level.SEVERE, null, ex);
                                }
                                this.canvasPanel.setCurrentVertical(currentProtein.getVertical());
                                this.list.setSelectedIndex(0);
                                continue;
                            }
                            listModel.clear();
                            mode = strMode;
                            IBSFrame shapeIBSFramep = new IBSFrame(mode);
                            shapeIBSFramep.images = this.images;
                            shapeIBSFramep.imagesShape = this.imagesShape;
                            shapeIBSFramep.imagesShapeSite = this.imagesShapeSite;
                            shapeIBSFramep.imagesShapeMarker = this.imagesShapeMarker;
                            shapeIBSFramep.imagesGradient = this.imagesGradient;
                            shapeIBSFramep.imagesShapeCutLine = this.imagesShapeCutLine;
                            if (mode.equals("P")) {
                                shapeIBSFramep.jMenuItem2.setEnabled(false);
                                shapeIBSFramep.jMenuItem1.setEnabled(true);
                            } else {
                                shapeIBSFramep.jMenuItem2.setEnabled(true);
                                shapeIBSFramep.jMenuItem1.setEnabled(false);
                            }
                            this.demoMenuItem.setEnabled(true);
                            shapeIBSFramep.filePath = this.filePath;
                            shapeIBSFramep.openProjectWithFile();
                            Tools.CURRENT_FILE_PATH = this.filePath;
                            Tools.WindowCenter(shapeIBSFramep);
                            this.dispose();
                            try {
                                shapeIBSFramep.canvasPanel.saveCurrentState();
                            }
                            catch (CloneNotSupportedException ex) {
                                Logger.getLogger(IBSFrame.class.getName()).log(Level.SEVERE, null, ex);
                            }
                        }
                        dtde.dropComplete(true);
                        break block17;
                    }
                    dtde.rejectDrop();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
                catch (UnsupportedFlavorException ufe) {
                    ufe.printStackTrace();
                }
            }
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            Tools.WindowCenter(new IBSFrame(args[0]));
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Tools.WindowCenter(new IBSFrame("P"));
                }
            });
        }
    }

    public String getDefaultID(String strType) {
        String strMaxId = "";
        if (strType.equals("Protein") || strType.equals("Nucleotide")) {
            int iMaxNum = 0;
            for (Protein protein : this.canvasPanel.getProteinList()) {
                int iNum;
                String strNum;
                String[] arrPro = protein.getParameter().split(DELIMIT);
                String shortstrType = this.getShortType(strType);
                String strId = arrPro[11].trim();
                if (strId.equals("") || strId == null || strId.indexOf(shortstrType) != 0 || !Tools.isNumber(strNum = strId.substring(1)) || iMaxNum >= (iNum = Integer.valueOf(strNum).intValue())) continue;
                iMaxNum = iNum;
            }
            String shortstrType = this.getShortType(strType);
            strMaxId = shortstrType + ++iMaxNum;
            return strMaxId;
        }
        int iMaxNum = 0;
        Protein pr = this.canvasPanel.getCurrentProtein();
        if (pr == null) {
            return "";
        }
        LinkedList<Component> componentList = pr.getComponentList();
        for (Component component : componentList) {
            int iNum;
            String strNum;
            String strId;
            if (!component.getType().name().equals(strType)) continue;
            String shortstrType = this.getShortType(strType);
            if (component.fid == null || (strId = component.fid.trim()).equals("") || strId == null || strId.indexOf(shortstrType) != 0 || !Tools.isNumber(strNum = strId.substring(1).trim()) || iMaxNum >= (iNum = Integer.valueOf(strNum).intValue())) continue;
            iMaxNum = iNum;
        }
        String shortstrType = this.getShortType(strType);
        strMaxId = shortstrType + ++iMaxNum;
        return strMaxId;
    }

    public String getShortType(String strType) {
        if (strType.trim().equals("Protein")) {
            strType = "P";
        } else if (strType.trim().equals("Nucleotide")) {
            strType = "N";
        } else if (strType.trim().equals("Polygon")) {
            strType = "M";
        } else if (strType.trim().equals("Domain")) {
            strType = "D";
        } else if (strType.trim().equals("Site")) {
            strType = "S";
        } else if (strType.trim().equals("Line")) {
            strType = "L";
        } else if (strType.trim().equals("Bracket")) {
            strType = "B";
        } else if (strType.trim().equals("CutLine")) {
            strType = "C";
        } else if (strType.trim().equals("Note")) {
            strType = "T";
        }
        return strType;
    }
}

