/*
 * Decompiled with CFR 0.152.
 */
package gui.ibs;

import gui.Tools;
import gui.ibs.Component;
import gui.ibs.ComponentEnum;
import gui.ibs.DrawTypeEnum;
import gui.ibs.EditDialog;
import gui.ibs.PreviewPanel;
import gui.ibs.ShapeEnum;
import gui.ibs.Verifier;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.LinkedList;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;

public class LineDialog
extends EditDialog {
    private Component component;
    private String DELIMIT = "#&%";
    public ShapeEnum shapeType = ShapeEnum.Straight;
    public Integer cx1 = null;
    Integer cy1 = null;
    Integer cx2 = null;
    Integer cy2 = null;
    public boolean bDash = false;
    public double proteinlen = 100.0;
    public String strNum = "";
    private JButton cancelButton;
    private JLabel colorLabel;
    private JPanel colorPanel;
    private JPanel controlPanel;
    private JCheckBox jCheckBoxDash;
    private JLabel jLabel1;
    private JLabel jLabel11;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabelTip;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JSpinner jSpinnerweight;
    private JTextField jTextFieldID;
    private JButton okButton;
    private JPanel previewPanel;
    private JLabel sizeLabel;
    private JComboBox styleComboBox;
    private JLabel styleLabel;
    private JLabel x1Label;
    private JTextField x1TextField;
    private JLabel x2Label;
    private JTextField x2TextField;
    private JLabel y1Label;
    private JTextField y1TextField;
    private JLabel y2Label;
    private JTextField y2TextField;

    public LineDialog(Frame parent, String title, boolean modal, ShapeEnum shapeType, Integer cx1, Integer cy1, Integer cx2, Integer cy2, double proteinlenth, String fstrNum) {
        super(parent, title, modal);
        this.strNum = fstrNum;
        this.setPreferredSize(new Dimension(700, 380));
        this.shapeType = shapeType;
        this.initComponents();
        this.setTitle(title);
        this.cx1 = cx1;
        this.cy1 = cy1;
        this.cx2 = cx2;
        this.cy2 = cy2;
        String st = "Press the shortcut key: 'Ctrl + |' to be vertical;  'Ctrl + -' to be horizontal; 'Ctrl + R' to get right angle;";
        this.jLabelTip.setText(st);
        this.proteinlen = proteinlenth;
        int wh = (int)Math.round(proteinlenth * 25.0 / 100.0);
        this.x2TextField.setText(String.valueOf(wh));
        this.jTextFieldID.setText(this.strNum);
        Color bc = new Color(204, 204, 204);
        this.jTextFieldID.setForeground(bc);
        this.previewDraw();
        this.jSpinnerweight.requestFocus();
        this.enableEvents(8L);
        InputMap inputMap = this.rootPane.getInputMap(2);
        inputMap.put(KeyStroke.getKeyStroke("ESCAPE"), "ESCAPE");
        this.rootPane.getActionMap().put("ESCAPE", new AbstractAction("ESCAPE"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LineDialog.this.cancelButton.doClick();
            }
        });
        inputMap.put(KeyStroke.getKeyStroke("ENTER"), "ENTER");
        this.rootPane.getActionMap().put("ENTER", new AbstractAction("ENTER"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LineDialog.this.okButton.doClick();
            }
        });
    }

    @Override
    public Component getComponent() {
        return this.component;
    }

    @Override
    public void setComponent(Component component) {
        this.colorPanel.setBackground(component.getColor());
        String[] arr = component.getParameter().split(this.DELIMIT);
        this.jSpinnerweight.setValue(Integer.valueOf(arr[0]));
        this.styleComboBox.setSelectedItem(arr[1]);
        this.x1TextField.setText(String.valueOf((int)component.getX()));
        this.y1TextField.setText(String.valueOf(component.getY()));
        this.x2TextField.setText(String.valueOf((int)component.getX2()));
        this.y2TextField.setText(String.valueOf(component.getY2()));
        String fname = "";
        int size = 10;
        if (arr.length > 2) {
            fname = arr[2];
            DrawTypeEnum nameDrawType = DrawTypeEnum.valueOf(arr[3]);
            size = Integer.parseInt(arr[4]);
        } else {
            fname = "";
            DrawTypeEnum nameDrawType = DrawTypeEnum.Hide;
            size = 10;
        }
        if (component.isbDash()) {
            this.jCheckBoxDash.setSelected(true);
        } else {
            this.jCheckBoxDash.setSelected(false);
        }
        if (component.fid != null && !component.fid.trim().equals("") && component.fid.trim() != null) {
            this.jTextFieldID.setText(component.fid);
            this.jTextFieldID.setForeground(Color.BLACK);
        }
        this.previewDraw();
    }

    public boolean isbDash() {
        return this.bDash;
    }

    public void setbDash(boolean bDash) {
        this.bDash = bDash;
    }

    public Integer getCx1() {
        return this.cx1;
    }

    public void setCx1(Integer cx1) {
        this.cx1 = cx1;
    }

    public Integer getCx2() {
        return this.cx2;
    }

    public void setCx2(Integer cx2) {
        this.cx2 = cx2;
    }

    public Integer getCy1() {
        return this.cy1;
    }

    public void setCy1(Integer cy1) {
        this.cy1 = cy1;
    }

    public Integer getCy2() {
        return this.cy2;
    }

    public void setCy2(Integer cy2) {
        this.cy2 = cy2;
    }

    private void previewDraw() {
        LinkedList<Component> componentList = new LinkedList<Component>();
        String parameter = String.valueOf(this.styleComboBox.getSelectedItem());
        int x1 = (int)Double.parseDouble(this.x1TextField.getText().trim());
        int y1 = (int)Double.parseDouble(this.y1TextField.getText().trim());
        int x2 = (int)Double.parseDouble(this.x2TextField.getText().trim());
        int y2 = (int)Double.parseDouble(this.y2TextField.getText().trim());
        Component line = new Component(ComponentEnum.Line, x1, y1, x2, y2, this.cx1, this.cy1, this.cx2, this.cy2, parameter, this.colorPanel.getBackground(), this.shapeType, this.bDash);
        componentList.add(line);
        PreviewPanel.protein.setComponentList(componentList);
        this.previewPanel.repaint();
    }

    private void initComponents() {
        this.previewPanel = new PreviewPanel();
        this.controlPanel = new JPanel();
        this.jLabel4 = new JLabel();
        this.jLabel1 = new JLabel();
        this.jPanel2 = new JPanel();
        this.x1Label = new JLabel();
        this.x1TextField = new JTextField();
        this.y1Label = new JLabel();
        this.y1TextField = new JTextField();
        this.x2Label = new JLabel();
        this.x2TextField = new JTextField();
        this.y2Label = new JLabel();
        this.y2TextField = new JTextField();
        this.jPanel3 = new JPanel();
        this.sizeLabel = new JLabel();
        this.jSpinnerweight = new JSpinner();
        this.jCheckBoxDash = new JCheckBox();
        this.jLabel3 = new JLabel();
        this.colorLabel = new JLabel();
        this.colorPanel = new JPanel();
        this.styleLabel = new JLabel();
        this.styleComboBox = new JComboBox();
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        this.jPanel4 = new JPanel();
        this.jLabel11 = new JLabel();
        this.jTextFieldID = new JTextField();
        this.jPanel1 = new JPanel();
        this.jLabelTip = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(700, 320));
        this.setPreferredSize(new Dimension(800, 470));
        this.setResizable(false);
        this.previewPanel.setBorder(BorderFactory.createTitledBorder(null, "Preview", 0, 0, new Font("Arial", 1, 14)));
        this.previewPanel.setMinimumSize(new Dimension(280, 200));
        this.previewPanel.setPreferredSize(new Dimension(280, 440));
        this.previewPanel.setLayout(new BorderLayout());
        this.getContentPane().add((java.awt.Component)this.previewPanel, "Center");
        this.controlPanel.setBorder(BorderFactory.createTitledBorder(null, "Options", 0, 0, new Font("Arial", 1, 14)));
        this.controlPanel.setMinimumSize(new Dimension(450, 200));
        this.controlPanel.setPreferredSize(new Dimension(450, 440));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(null, "Position", 0, 0, new Font("Arial", 1, 12)));
        this.jPanel2.setLayout(new GridLayout(2, 4, 10, 10));
        this.x1Label.setFont(new Font("Arial", 1, 12));
        this.x1Label.setHorizontalAlignment(11);
        this.x1Label.setText("X1");
        this.jPanel2.add(this.x1Label);
        this.x1TextField.setHorizontalAlignment(0);
        this.x1TextField.setText("0");
        this.jPanel2.add(this.x1TextField);
        this.y1Label.setFont(new Font("Arial", 1, 12));
        this.y1Label.setHorizontalAlignment(11);
        this.y1Label.setText("Y1");
        this.jPanel2.add(this.y1Label);
        this.y1TextField.setHorizontalAlignment(0);
        this.y1TextField.setText("60");
        this.jPanel2.add(this.y1TextField);
        this.x2Label.setFont(new Font("Arial", 1, 12));
        this.x2Label.setHorizontalAlignment(11);
        this.x2Label.setText("X2");
        this.jPanel2.add(this.x2Label);
        this.x2TextField.setHorizontalAlignment(0);
        this.x2TextField.setText("80");
        this.jPanel2.add(this.x2TextField);
        this.y2Label.setFont(new Font("Arial", 1, 12));
        this.y2Label.setHorizontalAlignment(11);
        this.y2Label.setText("Y2");
        this.jPanel2.add(this.y2Label);
        this.y2TextField.setHorizontalAlignment(0);
        this.y2TextField.setText("60");
        this.jPanel2.add(this.y2TextField);
        this.jPanel3.setBorder(BorderFactory.createTitledBorder(null, "Stroke", 0, 0, new Font("Arial", 1, 12)));
        this.jPanel3.setLayout(new GridLayout(2, 4, 10, 10));
        this.sizeLabel.setFont(new Font("Arial", 1, 12));
        this.sizeLabel.setHorizontalAlignment(11);
        this.sizeLabel.setText("Line Size");
        this.jPanel3.add(this.sizeLabel);
        this.jSpinnerweight.setModel(new SpinnerNumberModel(1, 1, 5, 1));
        this.jPanel3.add(this.jSpinnerweight);
        this.jCheckBoxDash.setText("Dash");
        this.jCheckBoxDash.setToolTipText("");
        this.jCheckBoxDash.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                LineDialog.this.jCheckBoxDashItemStateChanged(evt);
            }
        });
        this.jPanel3.add(this.jCheckBoxDash);
        this.jPanel3.add(this.jLabel3);
        this.colorLabel.setFont(new Font("Arial", 1, 12));
        this.colorLabel.setHorizontalAlignment(11);
        this.colorLabel.setText("Color");
        this.jPanel3.add(this.colorLabel);
        this.colorPanel.setBackground(Color.black);
        this.colorPanel.setBorder(BorderFactory.createBevelBorder(0));
        this.colorPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                LineDialog.this.colorPanelMousePressed(evt);
            }
        });
        this.jPanel3.add(this.colorPanel);
        this.styleLabel.setFont(new Font("Arial", 1, 12));
        this.styleLabel.setHorizontalAlignment(11);
        this.styleLabel.setText("Style");
        this.jPanel3.add(this.styleLabel);
        this.styleComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Line", "Arrow", "DoubleArrow", "Scale", "ScaleArrow"}));
        this.styleComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                LineDialog.this.styleComboBoxItemStateChanged(evt);
            }
        });
        this.jPanel3.add(this.styleComboBox);
        this.cancelButton.setFont(new Font("Arial", 1, 12));
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LineDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.okButton.setFont(new Font("Arial", 1, 12));
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LineDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.jPanel4.setBorder(BorderFactory.createTitledBorder(null, "", 0, 0, new Font("Arial", 1, 12)));
        this.jLabel11.setFont(new Font("\u5b8b\u4f53", 1, 12));
        this.jLabel11.setHorizontalAlignment(4);
        this.jLabel11.setText("ID");
        this.jLabel11.setPreferredSize(new Dimension(45, 15));
        this.jPanel4.add(this.jLabel11);
        this.jTextFieldID.setForeground(new Color(255, 255, 255));
        this.jTextFieldID.setPreferredSize(new Dimension(250, 25));
        this.jTextFieldID.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                LineDialog.this.jTextFieldIDFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                LineDialog.this.jTextFieldIDFocusLost(evt);
            }
        });
        this.jTextFieldID.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                LineDialog.this.jTextFieldIDKeyPressed(evt);
            }
        });
        this.jPanel4.add(this.jTextFieldID);
        GroupLayout controlPanelLayout = new GroupLayout(this.controlPanel);
        this.controlPanel.setLayout(controlPanelLayout);
        controlPanelLayout.setHorizontalGroup(controlPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(controlPanelLayout.createSequentialGroup().addGroup(controlPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(controlPanelLayout.createSequentialGroup().addComponent(this.jLabel4, -2, 87, -2).addGap(204, 204, 204).addComponent(this.jLabel1, -2, 87, -2)).addGroup(controlPanelLayout.createSequentialGroup().addContainerGap().addGroup(controlPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, controlPanelLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addGroup(controlPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel2, -2, 418, -2).addComponent(this.jPanel3, -2, 420, -2).addGroup(controlPanelLayout.createSequentialGroup().addGap(119, 119, 119).addComponent(this.cancelButton, -2, 87, -2).addGap(18, 18, 18).addComponent(this.okButton, -2, 87, -2)))).addComponent(this.jPanel4, -1, -1, Short.MAX_VALUE)))).addContainerGap()));
        controlPanelLayout.setVerticalGroup(controlPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(controlPanelLayout.createSequentialGroup().addGap(20, 20, 20).addComponent(this.jPanel4, -1, 36, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanel2, -2, 86, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel3, -2, 88, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(controlPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton, -2, 28, -2).addComponent(this.okButton, -2, 28, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(controlPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel4, -2, 28, -2).addComponent(this.jLabel1, -2, 28, -2))));
        this.getContentPane().add((java.awt.Component)this.controlPanel, "East");
        this.jPanel1.setPreferredSize(new Dimension(700, 30));
        this.jLabelTip.setPreferredSize(new Dimension(700, 20));
        this.jPanel1.add(this.jLabelTip);
        this.getContentPane().add((java.awt.Component)this.jPanel1, "Last");
        this.pack();
    }

    private void colorPanelMousePressed(MouseEvent evt) {
        final JColorChooser jColorChooser = new JColorChooser();
        jColorChooser.setColor(this.colorPanel.getBackground());
        Tools.WindowCenter(JColorChooser.createDialog(this, "Color Choose", true, jColorChooser, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color color = jColorChooser.getColor();
                LineDialog.this.colorPanel.setBackground(color);
                LineDialog.this.previewDraw();
            }
        }, null));
    }

    private void styleComboBoxItemStateChanged(ItemEvent evt) {
        this.previewDraw();
    }

    private void jCheckBoxDashItemStateChanged(ItemEvent evt) {
        this.bDash = this.jCheckBoxDash.isSelected();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.bModify = true;
        boolean isX1Valiable = new Verifier().isInteger(this.x1TextField);
        boolean isY1Valiable = new Verifier().isInteger(this.y1TextField);
        boolean isX2Valiable = new Verifier().isInteger(this.x2TextField);
        boolean isY2Valiable = new Verifier().isInteger(this.y2TextField);
        StringBuffer errorSb = new StringBuffer();
        if (!isX1Valiable) {
            errorSb.append("X1 : should be a positive integer \n");
        }
        if (!isY1Valiable) {
            errorSb.append("Y1 : should be a positive integer \n");
        }
        if (!isX2Valiable) {
            errorSb.append("X2 : should be a positive integer \n");
        }
        if (!isY2Valiable) {
            errorSb.append("Y2 : should be a positive integer \n");
        }
        if (isX1Valiable) {
            String name = " ";
            String parameter = this.jSpinnerweight.getValue() + this.DELIMIT + this.styleComboBox.getSelectedItem() + this.DELIMIT + name + this.DELIMIT + (Object)((Object)DrawTypeEnum.Hide) + this.DELIMIT + "0";
            int x1 = (int)Double.parseDouble(this.x1TextField.getText().trim());
            int y1 = (int)Double.parseDouble(this.y1TextField.getText().trim());
            int x2 = (int)Double.parseDouble(this.x2TextField.getText().trim());
            int y2 = (int)Double.parseDouble(this.y2TextField.getText().trim());
            String fid = "";
            fid = this.jTextFieldID.getText();
            this.component = new Component(ComponentEnum.Line, x1, y1, x2, y2, this.cx1, this.cy1, this.cx2, this.cy2, parameter, this.colorPanel.getBackground(), Color.BLACK, this.shapeType, this.bDash, fid);
            this.component.setIsActive(true);
            this.component.setbSelected(true);
            this.dispose();
        } else {
            JOptionPane.showConfirmDialog(this, errorSb.toString(), "Properties Error", -1, 0, null);
        }
    }

    private void jTextFieldIDKeyPressed(KeyEvent evt) {
    }

    private void jTextFieldIDFocusGained(FocusEvent evt) {
    }

    private void jTextFieldIDFocusLost(FocusEvent evt) {
    }
}

