/*
 * Decompiled with CFR 0.152.
 */
package gui.ibs;

import gui.Tools;
import gui.ibs.Component;
import gui.ibs.ComponentEnum;
import gui.ibs.EditDialog;
import gui.ibs.PreviewPanel;
import gui.ibs.Verifier;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.LinkedList;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;

public class NoteDialog
extends EditDialog {
    private Component component;
    private String DELIMIT = "#&%";
    public String strNum = "";
    private JPanel LineColorjPanel;
    private JLabel angleLabel;
    private JLabel angleLabel1;
    private JButton cancelButton;
    private JLabel colorLabel;
    private JPanel colorPanel;
    private JPanel controlPanel;
    private JLabel deltaXLabel;
    private JLabel deltaXLabel1;
    private JTextField deltaXTextField;
    private JLabel deltaYLabel;
    private JLabel deltaYLabel1;
    private JTextField deltaYTextField;
    private JCheckBox jCheckBoxLineDash;
    private JComboBox jComboBoxFont;
    private JLabel jLabel1;
    private JLabel jLabel11;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JSpinner jSpinnerAngle;
    private JSpinner jSpinnerLineSize;
    private JTextField jTextFieldID;
    private JPanel mainPanel;
    private JButton okButton;
    private JPanel previewPanel;
    private JLabel sizeLabel;
    private JTextField sizeTextField;
    private JComboBox styleComboBox;
    private JLabel styleLabel;
    private JPanel textPanel;
    private JTextField textTextField;

    public NoteDialog(Frame parent, String title, boolean modal, String fstrNum) {
        super(parent, title, modal);
        this.strNum = fstrNum;
        this.setPreferredSize(new Dimension(740, 550));
        this.initComponents();
        this.setTitle(title);
        this.loadfont();
        String strFont = "Arial";
        this.jComboBoxFont.setSelectedItem(strFont);
        this.jTextFieldID.setText(this.strNum);
        Color bc = new Color(204, 204, 204);
        this.jTextFieldID.setForeground(bc);
        this.previewDraw();
        this.textTextField.requestFocus();
        this.enableEvents(8L);
        InputMap inputMap = this.rootPane.getInputMap(2);
        inputMap.put(KeyStroke.getKeyStroke("ESCAPE"), "ESCAPE");
        this.rootPane.getActionMap().put("ESCAPE", new AbstractAction("ESCAPE"){

            @Override
            public void actionPerformed(ActionEvent e) {
                NoteDialog.this.cancelButton.doClick();
            }
        });
        inputMap.put(KeyStroke.getKeyStroke("ENTER"), "ENTER");
        this.rootPane.getActionMap().put("ENTER", new AbstractAction("ENTER"){

            @Override
            public void actionPerformed(ActionEvent e) {
                NoteDialog.this.okButton.doClick();
            }
        });
    }

    @Override
    public Component getComponent() {
        return this.component;
    }

    public void loadfont() {
        GraphicsEnvironment e = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] fontName = e.getAvailableFontFamilyNames();
        for (int i = 0; i < fontName.length; ++i) {
            this.jComboBoxFont.addItem(fontName[i]);
        }
    }

    @Override
    public void setComponent(Component component) {
        this.colorPanel.setBackground(component.getColor());
        String[] arr = component.getParameter().split(this.DELIMIT);
        this.textTextField.setText(arr[0]);
        this.sizeTextField.setText(arr[1]);
        this.styleComboBox.setSelectedItem(arr[2]);
        this.jSpinnerAngle.setValue(Integer.valueOf(arr[3]));
        this.deltaXTextField.setText(String.valueOf((int)component.getX()));
        this.deltaYTextField.setText(String.valueOf(component.getY()));
        this.jSpinnerLineSize.setValue(Integer.valueOf(arr[4]));
        String strFont = "Arial";
        if (arr.length > 5) {
            strFont = arr[5];
        }
        this.jComboBoxFont.setSelectedItem(strFont);
        this.jSpinnerAngle.setValue((int)component.getRotationAngle());
        this.LineColorjPanel.setBackground(component.getColorline());
        this.jCheckBoxLineDash.setSelected(component.bDash);
        if (component.fid != null && !component.fid.trim().equals("") && component.fid.trim() != null) {
            this.jTextFieldID.setText(component.fid);
            this.jTextFieldID.setForeground(Color.BLACK);
        }
        this.previewDraw();
    }

    public void previewDraw() {
        LinkedList<Component> componentList = new LinkedList<Component>();
        String parameter = "text" + this.DELIMIT + "70" + this.DELIMIT + this.styleComboBox.getSelectedItem() + this.DELIMIT + this.jSpinnerAngle.getValue() + this.DELIMIT + this.jSpinnerLineSize.getValue();
        int angle = (Integer)this.jSpinnerAngle.getValue();
        Component note = new Component(ComponentEnum.Note, 20, 20, parameter, this.colorPanel.getBackground(), this.LineColorjPanel.getBackground(), this.jCheckBoxLineDash.isSelected(), angle, "id");
        componentList.add(note);
        PreviewPanel.protein.setComponentList(componentList);
        this.previewPanel.repaint();
    }

    private void initComponents() {
        this.previewPanel = new PreviewPanel();
        this.mainPanel = new JPanel();
        this.textPanel = new JPanel();
        this.textTextField = new JTextField();
        this.controlPanel = new JPanel();
        this.sizeLabel = new JLabel();
        this.sizeTextField = new JTextField();
        this.colorLabel = new JLabel();
        this.colorPanel = new JPanel();
        this.styleLabel = new JLabel();
        this.styleComboBox = new JComboBox();
        this.jLabel1 = new JLabel();
        this.jComboBoxFont = new JComboBox();
        this.jPanel1 = new JPanel();
        this.deltaXLabel = new JLabel();
        this.deltaXTextField = new JTextField();
        this.deltaYLabel = new JLabel();
        this.deltaYTextField = new JTextField();
        this.angleLabel = new JLabel();
        this.jSpinnerAngle = new JSpinner();
        this.jLabel3 = new JLabel();
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        this.jPanel2 = new JPanel();
        this.deltaXLabel1 = new JLabel();
        this.jSpinnerLineSize = new JSpinner();
        this.jCheckBoxLineDash = new JCheckBox();
        this.angleLabel1 = new JLabel();
        this.deltaYLabel1 = new JLabel();
        this.LineColorjPanel = new JPanel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jPanel3 = new JPanel();
        this.jLabel11 = new JLabel();
        this.jTextFieldID = new JTextField();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(700, 320));
        this.setResizable(false);
        this.previewPanel.setBorder(BorderFactory.createTitledBorder(null, "Preview", 0, 0, new Font("Arial", 1, 14)));
        this.previewPanel.setMinimumSize(new Dimension(280, 240));
        this.previewPanel.setLayout(new BorderLayout());
        this.getContentPane().add((java.awt.Component)this.previewPanel, "Center");
        this.mainPanel.setBorder(BorderFactory.createTitledBorder(null, "Option", 0, 0, new Font("Arial", 1, 14)));
        this.mainPanel.setMinimumSize(new Dimension(271, 240));
        this.mainPanel.setPreferredSize(new Dimension(400, 100));
        this.textPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createTitledBorder(""), "Text", 0, 0, new Font("Arial", 1, 12)));
        this.textPanel.setPreferredSize(new Dimension(400, 65));
        this.textTextField.setHorizontalAlignment(0);
        this.textTextField.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.textTextField.setPreferredSize(new Dimension(350, 25));
        this.textPanel.add(this.textTextField);
        this.controlPanel.setBorder(BorderFactory.createTitledBorder(null, "Style", 0, 0, new Font("Arial", 1, 12)));
        this.sizeLabel.setFont(new Font("Arial", 1, 12));
        this.sizeLabel.setHorizontalAlignment(11);
        this.sizeLabel.setText("Font Size");
        this.sizeTextField.setHorizontalAlignment(0);
        this.sizeTextField.setText("32");
        this.colorLabel.setFont(new Font("Arial", 1, 12));
        this.colorLabel.setHorizontalAlignment(11);
        this.colorLabel.setText("Text Color");
        this.colorPanel.setBackground(Color.black);
        this.colorPanel.setBorder(BorderFactory.createBevelBorder(0));
        this.colorPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                NoteDialog.this.colorPanelMousePressed(evt);
            }
        });
        this.styleLabel.setFont(new Font("Arial", 1, 12));
        this.styleLabel.setHorizontalAlignment(11);
        this.styleLabel.setText("Font Style");
        this.styleComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Bold", "Italic", "Bold_Italic", "Plain"}));
        this.styleComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                NoteDialog.this.styleComboBoxItemStateChanged(evt);
            }
        });
        this.jLabel1.setFont(new Font("Arial", 1, 12));
        this.jLabel1.setHorizontalAlignment(4);
        this.jLabel1.setText("Font");
        this.jComboBoxFont.setEditable(true);
        GroupLayout controlPanelLayout = new GroupLayout(this.controlPanel);
        this.controlPanel.setLayout(controlPanelLayout);
        controlPanelLayout.setHorizontalGroup(controlPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(controlPanelLayout.createSequentialGroup().addComponent(this.sizeLabel, -2, 84, -2).addGap(10, 10, 10).addComponent(this.sizeTextField, -2, 84, -2).addGap(10, 10, 10).addComponent(this.colorLabel, -2, 84, -2).addGap(10, 10, 10).addComponent(this.colorPanel, -2, 84, -2)).addGroup(controlPanelLayout.createSequentialGroup().addComponent(this.styleLabel, -2, 84, -2).addGap(10, 10, 10).addComponent(this.styleComboBox, -2, 84, -2)).addGroup(controlPanelLayout.createSequentialGroup().addComponent(this.jLabel1, -2, 84, -2).addGap(10, 10, 10).addComponent(this.jComboBoxFont, 0, -1, Short.MAX_VALUE)));
        controlPanelLayout.setVerticalGroup(controlPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(controlPanelLayout.createSequentialGroup().addGroup(controlPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.sizeLabel, -2, 26, -2).addComponent(this.sizeTextField, -2, 26, -2).addComponent(this.colorLabel, -2, 26, -2).addComponent(this.colorPanel, -2, 26, -2)).addGap(10, 10, 10).addGroup(controlPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.styleLabel, -2, 26, -2).addComponent(this.styleComboBox, -2, 26, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(controlPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1, -2, 26, -2).addComponent(this.jComboBoxFont, -2, 26, -2)).addContainerGap(12, Short.MAX_VALUE)));
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(null, "Location", 0, 0, new Font("Arial", 1, 12)));
        this.jPanel1.setLayout(new GridLayout(2, 4, 10, 10));
        this.deltaXLabel.setFont(new Font("Arial", 1, 12));
        this.deltaXLabel.setHorizontalAlignment(11);
        this.deltaXLabel.setText("Central X");
        this.jPanel1.add(this.deltaXLabel);
        this.deltaXTextField.setHorizontalAlignment(0);
        this.deltaXTextField.setText("0");
        this.jPanel1.add(this.deltaXTextField);
        this.deltaYLabel.setFont(new Font("Arial", 1, 12));
        this.deltaYLabel.setHorizontalAlignment(11);
        this.deltaYLabel.setText("Central Y");
        this.jPanel1.add(this.deltaYLabel);
        this.deltaYTextField.setHorizontalAlignment(0);
        this.deltaYTextField.setText("60");
        this.jPanel1.add(this.deltaYTextField);
        this.angleLabel.setFont(new Font("Arial", 1, 12));
        this.angleLabel.setHorizontalAlignment(11);
        this.angleLabel.setText("Angle");
        this.jPanel1.add(this.angleLabel);
        this.jSpinnerAngle.setModel(new SpinnerNumberModel(0, -360, 360, 1));
        this.jPanel1.add(this.jSpinnerAngle);
        this.jPanel1.add(this.jLabel3);
        this.cancelButton.setFont(new Font("Arial", 1, 12));
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NoteDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.okButton.setFont(new Font("Arial", 1, 12));
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NoteDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(null, "Border", 0, 0, new Font("Arial", 1, 12)));
        this.jPanel2.setLayout(new GridLayout(2, 4, 10, 10));
        this.deltaXLabel1.setFont(new Font("Arial", 1, 12));
        this.deltaXLabel1.setHorizontalAlignment(11);
        this.deltaXLabel1.setText("Line Size");
        this.jPanel2.add(this.deltaXLabel1);
        this.jSpinnerLineSize.setModel(new SpinnerNumberModel(0, 0, 5, 1));
        this.jPanel2.add(this.jSpinnerLineSize);
        this.jCheckBoxLineDash.setFont(new Font("Arial", 1, 12));
        this.jCheckBoxLineDash.setText("Dash");
        this.jCheckBoxLineDash.setHorizontalAlignment(2);
        this.jPanel2.add(this.jCheckBoxLineDash);
        this.angleLabel1.setFont(new Font("Arial", 1, 12));
        this.angleLabel1.setHorizontalAlignment(11);
        this.jPanel2.add(this.angleLabel1);
        this.deltaYLabel1.setFont(new Font("Arial", 1, 12));
        this.deltaYLabel1.setHorizontalAlignment(11);
        this.deltaYLabel1.setText("Line Color");
        this.jPanel2.add(this.deltaYLabel1);
        this.LineColorjPanel.setBackground(new Color(0, 0, 0));
        this.LineColorjPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                NoteDialog.this.LineColorjPanelMousePressed(evt);
            }
        });
        GroupLayout LineColorjPanelLayout = new GroupLayout(this.LineColorjPanel);
        this.LineColorjPanel.setLayout(LineColorjPanelLayout);
        LineColorjPanelLayout.setHorizontalGroup(LineColorjPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 84, Short.MAX_VALUE));
        LineColorjPanelLayout.setVerticalGroup(LineColorjPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 25, Short.MAX_VALUE));
        this.jPanel2.add(this.LineColorjPanel);
        this.jPanel2.add(this.jLabel4);
        this.jPanel2.add(this.jLabel5);
        this.jPanel3.setBorder(BorderFactory.createTitledBorder(null, "", 0, 0, new Font("Arial", 1, 12)));
        this.jLabel11.setFont(new Font("\u5b8b\u4f53", 1, 12));
        this.jLabel11.setHorizontalAlignment(4);
        this.jLabel11.setText("ID");
        this.jLabel11.setPreferredSize(new Dimension(65, 15));
        this.jPanel3.add(this.jLabel11);
        this.jTextFieldID.setForeground(new Color(255, 255, 255));
        this.jTextFieldID.setPreferredSize(new Dimension(250, 25));
        this.jTextFieldID.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                NoteDialog.this.jTextFieldIDFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                NoteDialog.this.jTextFieldIDFocusLost(evt);
            }
        });
        this.jTextFieldID.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                NoteDialog.this.jTextFieldIDKeyPressed(evt);
            }
        });
        this.jPanel3.add(this.jTextFieldID);
        GroupLayout mainPanelLayout = new GroupLayout(this.mainPanel);
        this.mainPanel.setLayout(mainPanelLayout);
        mainPanelLayout.setHorizontalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addContainerGap().addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.textPanel, GroupLayout.Alignment.TRAILING, -2, 0, Short.MAX_VALUE).addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE).addGroup(mainPanelLayout.createSequentialGroup().addGap(70, 70, 70).addComponent(this.cancelButton).addGap(18, 18, 18).addComponent(this.okButton, -2, 71, -2)).addComponent(this.controlPanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel1, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel2, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        mainPanelLayout.setVerticalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addComponent(this.jPanel3, -2, 39, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.textPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.controlPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -2, 85, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanel2, -2, 85, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton, -2, 28, -2).addComponent(this.okButton, -2, 26, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.getContentPane().add((java.awt.Component)this.mainPanel, "East");
        this.pack();
    }

    private void colorPanelMousePressed(MouseEvent evt) {
        final JColorChooser jColorChooser = new JColorChooser();
        jColorChooser.setColor(this.colorPanel.getBackground());
        Tools.WindowCenter(JColorChooser.createDialog(this, "Color Choose", true, jColorChooser, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color color = jColorChooser.getColor();
                NoteDialog.this.colorPanel.setBackground(color);
                NoteDialog.this.previewDraw();
            }
        }, null));
    }

    private void styleComboBoxItemStateChanged(ItemEvent evt) {
        this.previewDraw();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.bModify = true;
        boolean isDeltaXValiable = new Verifier().isInteger(this.deltaXTextField);
        boolean isDeltaYValiable = new Verifier().isInteger(this.deltaYTextField);
        boolean isFontSizeTextValiable = new Verifier().verify(this.sizeTextField);
        boolean isTitleEmpty = new Verifier().isEmpty(this.textTextField);
        boolean isLineSizeValiable = true;
        StringBuffer errorSb = new StringBuffer();
        if (isTitleEmpty) {
            errorSb.append("Text : should not be empty\n");
        }
        if (!isLineSizeValiable) {
            errorSb.append("Line Size : should be a positive integer \n");
        }
        if (!isDeltaXValiable) {
            errorSb.append("Delta X : should be a positive integer \n");
        }
        if (!isDeltaYValiable) {
            errorSb.append("Delta Y : should be a positive integer \n");
        }
        if (!isFontSizeTextValiable) {
            errorSb.append("Font Size : should be a positive integer \n");
        }
        if (!isTitleEmpty && isDeltaXValiable && isFontSizeTextValiable) {
            String parameter = this.textTextField.getText() + this.DELIMIT + this.sizeTextField.getText().trim() + this.DELIMIT + this.styleComboBox.getSelectedItem() + this.DELIMIT + this.jSpinnerAngle.getValue() + this.DELIMIT + this.jSpinnerLineSize.getValue() + this.DELIMIT + this.jComboBoxFont.getSelectedItem();
            int deltaX = (int)Double.parseDouble(this.deltaXTextField.getText().trim());
            int deltaY = (int)Double.parseDouble(this.deltaYTextField.getText().trim());
            int angle = (Integer)this.jSpinnerAngle.getValue();
            String fid = "";
            fid = this.jTextFieldID.getText();
            this.component = new Component(ComponentEnum.Note, deltaX, deltaY, parameter, this.colorPanel.getBackground(), this.LineColorjPanel.getBackground(), this.jCheckBoxLineDash.isSelected(), angle, fid);
            this.component.setIsActive(true);
            this.dispose();
        } else {
            JOptionPane.showConfirmDialog(this, errorSb.toString(), "Properties Error", -1, 0, null);
        }
    }

    private void LineColorjPanelMousePressed(MouseEvent evt) {
        final JColorChooser jColorChooser = new JColorChooser();
        jColorChooser.setColor(this.LineColorjPanel.getBackground());
        Tools.WindowCenter(JColorChooser.createDialog(this, "Color Choose", true, jColorChooser, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color color = jColorChooser.getColor();
                NoteDialog.this.LineColorjPanel.setBackground(color);
                NoteDialog.this.previewDraw();
            }
        }, null));
    }

    private void jTextFieldIDKeyPressed(KeyEvent evt) {
    }

    private void jTextFieldIDFocusGained(FocusEvent evt) {
    }

    private void jTextFieldIDFocusLost(FocusEvent evt) {
    }
}

