/*
 * Decompiled with CFR 0.152.
 */
package gui.ibs;

import gui.Tools;
import gui.ibs.Component;
import gui.ibs.ComponentEnum;
import gui.ibs.DrawTypeEnum;
import gui.ibs.GetLocalFontFamily;
import gui.ibs.Project;
import gui.ibs.Protein;
import gui.ibs.ShapeEnum;
import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class Project2XML {
    private final String DELIMIT = "#&%";
    public String filePath;
    private final String VERSION = "IBS 1.0";
    private DecimalFormat df = new DecimalFormat("#0.0#");

    public Project2XML(String filePath) {
        this.filePath = filePath;
    }

    public Project2XML() {
    }

    private Document buildDocument(Project project, String mode) {
        Document doc = new Document();
        if (project != null) {
            LinkedList<Protein> proteinList = project.getProteinList();
            proteinList = this.adjustProteinHorizontal(proteinList);
            int width = project.getWidth();
            int height = project.getHeight();
            float rate = project.getRate();
            Element projectElement = new Element("project");
            doc.setRootElement(projectElement);
            projectElement.setAttribute("version", "IBS 1.0");
            if (mode.equals("P")) {
                projectElement.setAttribute("mode", "protein");
            } else {
                projectElement.setAttribute("mode", "nucleotide");
            }
            projectElement.setAttribute("width", String.valueOf(width));
            projectElement.setAttribute("height", String.valueOf(height));
            projectElement.setAttribute("rate", this.df.format(rate).replaceAll(",", "."));
            for (Protein protein : proteinList) {
                projectElement.addContent(this.buildProtein(protein, mode));
            }
        }
        return doc;
    }

    public Element buildProtein(Protein protein, String mode) {
        Color color = protein.getColor();
        String parameter = protein.getParameter();
        String[] arr = parameter.split("#&%");
        String start = arr[0];
        String startDirection = arr[1];
        String end = arr[2];
        String endDirection = arr[3];
        String height = arr[4];
        String size = arr[5];
        String gradient = arr[6];
        String texture = arr[7];
        String strDash = arr[8];
        String strLineSize = arr[9];
        String proteinColorLineStr = arr[10];
        String pid = arr[11];
        StringTokenizer ster = new StringTokenizer(proteinColorLineStr, ",");
        Color colorline = new Color(Integer.parseInt(ster.nextToken()), Integer.parseInt(ster.nextToken()), Integer.parseInt(ster.nextToken()));
        Element proteinElement = new Element("protein");
        proteinElement.setAttribute("vertical", String.valueOf(protein.getVertical()));
        proteinElement.setAttribute("horizontal", String.valueOf(protein.getHorizontal()));
        proteinElement.setAttribute("locked", String.valueOf(protein.isLocked()));
        Element proteinStartElement = new Element("start");
        proteinStartElement.setAttribute("direction", startDirection);
        proteinStartElement.addContent(start);
        Element proteinEndElement = new Element("end");
        proteinEndElement.setAttribute("direction", endDirection);
        proteinEndElement.addContent(end);
        Element proteinHeightElement = new Element("height");
        proteinHeightElement.addContent(height);
        proteinHeightElement.setAttribute("size", size);
        proteinHeightElement.setAttribute("color", color.getRed() + "," + color.getGreen() + "," + color.getBlue());
        proteinHeightElement.setAttribute("colorline", colorline.getRed() + "," + colorline.getGreen() + "," + colorline.getBlue());
        Element proteinDashElement = new Element("dash");
        proteinDashElement.addContent(strDash);
        Element proteinLineSizeElement = new Element("dash");
        proteinLineSizeElement.addContent(strLineSize);
        proteinElement.addContent(proteinLineSizeElement);
        Element proteinpidElement = new Element("id");
        proteinpidElement.addContent(pid);
        proteinElement.addContent(proteinpidElement);
        proteinElement.addContent(proteinStartElement);
        proteinElement.addContent(proteinEndElement);
        proteinElement.addContent(proteinHeightElement);
        proteinElement.addContent(proteinDashElement);
        Element proteinGradientElement = new Element("gradient");
        Element proteinTextureElement = new Element("texture");
        proteinElement.addContent(proteinGradientElement);
        proteinElement.addContent(proteinTextureElement);
        proteinGradientElement.addContent(gradient);
        proteinTextureElement.addContent(texture);
        Element proteinFontElement = new Element("textfont");
        proteinFontElement.addContent("");
        proteinElement.addContent(proteinFontElement);
        LinkedList<Component> componentList = protein.getComponentList();
        for (Component component : componentList) {
            if (component.getType() == ComponentEnum.Domain) {
                proteinElement.addContent(this.domainElement(component, mode));
            }
            if (component.getType() == ComponentEnum.CutLine) {
                proteinElement.addContent(this.cutlineElement(component, mode));
                continue;
            }
            if (component.getType() == ComponentEnum.Site) {
                proteinElement.addContent(this.siteElement(component));
                continue;
            }
            if (component.getType() == ComponentEnum.Note) {
                proteinElement.addContent(this.noteElement(component));
                continue;
            }
            if (component.getType() == ComponentEnum.Line) {
                proteinElement.addContent(this.lineElement(component));
                continue;
            }
            if (component.getType() == ComponentEnum.Polygon) {
                proteinElement.addContent(this.polygonElement(component));
                continue;
            }
            if (component.getType() != ComponentEnum.Bracket) continue;
            proteinElement.addContent(this.bracketElement(component));
        }
        return proteinElement;
    }

    private Element polygonElement(Component component) {
        String parameter = component.getParameter();
        StringTokenizer st = new StringTokenizer(parameter, "#&%");
        String name = st.nextToken();
        String nameDrawType = st.nextToken();
        String size = st.nextToken();
        String strStrokeSize = st.nextToken();
        String gradient = st.nextToken();
        String texture = st.nextToken();
        String sCenterx = String.valueOf((int)component.getCenterx());
        String sCentery = String.valueOf((int)component.getCentery());
        String sWide = String.valueOf((int)component.getWide());
        String sHigh = String.valueOf((int)component.getHigh());
        String sRotationAngle = String.valueOf((int)component.getRotationAngle());
        String strShapeType = component.getShapeType().name();
        Color color = component.getColor();
        Color colortext = component.getColorText();
        Color colorline = component.getColorline();
        Element polygonElement = new Element("component");
        polygonElement.setAttribute("type", "polygon");
        Element polygonNameElement = new Element("name");
        Element polygonStrokeSizeElement = new Element("strokesize");
        Element polygonGradientElement = new Element("gradient");
        Element polygonTextureElement = new Element("texture");
        Element polygonCenterxElement = new Element("centerx");
        Element polygonCenteryElement = new Element("centery");
        Element polygonWideElement = new Element("wide");
        Element polygonHighElement = new Element("high");
        Element polygonRotationAngleElement = new Element("rotationAngle");
        Element polygonShapeTypeElement = new Element("shapetype");
        Element polygondashElement = new Element("dash");
        polygondashElement.addContent(String.valueOf(component.isbDash()));
        polygonElement.addContent(polygonNameElement);
        polygonNameElement.setAttribute("direction", nameDrawType);
        polygonNameElement.setAttribute("size", size);
        polygonNameElement.setAttribute("color", color.getRed() + "," + color.getGreen() + "," + color.getBlue());
        polygonNameElement.setAttribute("colortext", colortext.getRed() + "," + colortext.getGreen() + "," + colortext.getBlue());
        polygonNameElement.setAttribute("colorline", colorline.getRed() + "," + colorline.getGreen() + "," + colorline.getBlue());
        polygonNameElement.addContent(name);
        polygonShapeTypeElement.addContent(strShapeType);
        polygonStrokeSizeElement.addContent(strStrokeSize);
        polygonGradientElement.addContent(gradient);
        polygonTextureElement.addContent(texture);
        polygonCenterxElement.addContent(sCenterx);
        polygonCenteryElement.addContent(sCentery);
        polygonWideElement.addContent(sWide);
        polygonHighElement.addContent(sHigh);
        polygonRotationAngleElement.addContent(sRotationAngle);
        String fid = component.getFid();
        Element fidElement = new Element("id");
        fidElement.addContent(fid);
        polygonElement.addContent(fidElement);
        polygonElement.addContent(polygonStrokeSizeElement);
        polygonElement.addContent(polygonGradientElement);
        polygonElement.addContent(polygonTextureElement);
        polygonElement.addContent(polygonCenterxElement);
        polygonElement.addContent(polygonCenteryElement);
        polygonElement.addContent(polygonWideElement);
        polygonElement.addContent(polygonHighElement);
        polygonElement.addContent(polygonRotationAngleElement);
        polygonElement.addContent(polygonShapeTypeElement);
        polygonElement.addContent(polygondashElement);
        return polygonElement;
    }

    private Element bracketElement(Component component) {
        String parameter = component.getParameter();
        StringTokenizer st = new StringTokenizer(parameter, "#&%");
        String strStrokeSize = st.nextToken();
        String sCenterx = String.valueOf((int)component.getCenterx());
        String sCentery = String.valueOf((int)component.getCentery());
        String sWide = String.valueOf((int)component.getWide());
        String sRotationAngle = String.valueOf((int)component.getRotationAngle());
        String strShapeType = component.getShapeType().name();
        Color color = component.getColor();
        Element bracketElement = new Element("component");
        bracketElement.setAttribute("type", "bracket");
        Element bracketStrokeSizeElement = new Element("strokesize");
        Element bracketCenterxElement = new Element("centerx");
        Element bracketCenteryElement = new Element("centery");
        Element bracketWideElement = new Element("wide");
        Element bracketRotationAngleElement = new Element("rotationAngle");
        Element bracketShapeTypeElement = new Element("shapetype");
        Element colorElement = new Element("color");
        String fid = component.getFid();
        Element fidElement = new Element("id");
        fidElement.addContent(fid);
        bracketElement.addContent(fidElement);
        colorElement.addContent(color.getRed() + "," + color.getGreen() + "," + color.getBlue());
        bracketShapeTypeElement.addContent(strShapeType);
        bracketStrokeSizeElement.addContent(strStrokeSize);
        bracketCenterxElement.addContent(sCenterx);
        bracketCenteryElement.addContent(sCentery);
        bracketWideElement.addContent(sWide);
        bracketRotationAngleElement.addContent(sRotationAngle);
        bracketElement.addContent(colorElement);
        bracketElement.addContent(bracketStrokeSizeElement);
        bracketElement.addContent(bracketCenterxElement);
        bracketElement.addContent(bracketCenteryElement);
        bracketElement.addContent(bracketWideElement);
        bracketElement.addContent(bracketRotationAngleElement);
        bracketElement.addContent(bracketShapeTypeElement);
        return bracketElement;
    }

    private Element domainElement(Component component, String mode) {
        String sRotationAngle;
        String strHigh;
        String parameter = component.getParameter();
        StringTokenizer st = new StringTokenizer(parameter, "#&%");
        String start = String.valueOf((int)component.getX());
        String startDrawType = st.nextToken();
        String end = mode.equals("P") ? String.valueOf((int)component.getX2()) : String.valueOf((int)component.getX2());
        String endDrawType = st.nextToken();
        String name = st.nextToken();
        String nameDrawType = st.nextToken();
        String size = st.nextToken();
        String strStrokeSize = st.nextToken();
        String gradient = st.nextToken();
        String texture = st.nextToken();
        String strShapeType = component.getShapeType().name();
        if (mode.equals("P")) {
            strHigh = component.getShapeType() == ShapeEnum.L_ParallelCurve || component.getShapeType() == ShapeEnum.R_ParallelCurve || component.getShapeType() == ShapeEnum.L_ParallelLine || component.getShapeType() == ShapeEnum.R_ParallelLine ? String.valueOf((int)component.getHigh()) : "10";
            sRotationAngle = "0";
        } else {
            strHigh = String.valueOf((int)component.getHigh());
            sRotationAngle = String.valueOf((int)component.getRotationAngle());
        }
        Element domainElement = new Element("component");
        Element domainStartElement = new Element("start");
        Element domainEndElement = new Element("end");
        Element domainNameElement = new Element("name");
        Element domainHighElement = new Element("high");
        Element domainShapeTypeElement = new Element("shapetype");
        Element domainStrokeSizeElement = new Element("strokesize");
        Element domainGradientElement = new Element("gradient");
        Element domainTextureElement = new Element("texture");
        Element polygonRotationAngleElement = new Element("rotationAngle");
        Element domainDashElement = new Element("dash");
        domainElement.setAttribute("type", "domain");
        domainDashElement.addContent(String.valueOf(component.isbDash()));
        Element polygonLeftDashElement = new Element("leftdash");
        Element polygonRightDashElement = new Element("rightdash");
        polygonLeftDashElement.addContent(String.valueOf(component.bProteinLDash));
        polygonRightDashElement.addContent(String.valueOf(component.bProteinRDash));
        Color color = component.getColor();
        Color colortext = component.getColorText();
        Color colorline = component.getColorline();
        domainElement.addContent(domainStartElement);
        domainStartElement.setAttribute("direction", startDrawType);
        domainStartElement.addContent(start);
        domainElement.addContent(domainEndElement);
        domainEndElement.setAttribute("direction", endDrawType);
        domainEndElement.addContent(end);
        domainElement.addContent(domainNameElement);
        domainNameElement.setAttribute("direction", nameDrawType);
        domainNameElement.setAttribute("size", size);
        domainNameElement.setAttribute("color", color.getRed() + "," + color.getGreen() + "," + color.getBlue());
        domainNameElement.setAttribute("colortext", colortext.getRed() + "," + colortext.getGreen() + "," + colortext.getBlue());
        domainNameElement.setAttribute("colorline", colorline.getRed() + "," + colorline.getGreen() + "," + colorline.getBlue());
        domainNameElement.addContent(name);
        domainHighElement.addContent(strHigh);
        domainShapeTypeElement.addContent(strShapeType);
        domainStrokeSizeElement.addContent(strStrokeSize);
        domainGradientElement.addContent(gradient);
        domainTextureElement.addContent(texture);
        polygonRotationAngleElement.addContent(sRotationAngle);
        domainElement.addContent(domainHighElement);
        domainElement.addContent(domainShapeTypeElement);
        domainElement.addContent(domainStrokeSizeElement);
        domainElement.addContent(domainGradientElement);
        domainElement.addContent(domainTextureElement);
        domainElement.addContent(polygonRotationAngleElement);
        domainElement.addContent(domainDashElement);
        domainElement.addContent(polygonLeftDashElement);
        domainElement.addContent(polygonRightDashElement);
        String fid = component.getFid();
        Element fidElement = new Element("id");
        fidElement.addContent(fid);
        domainElement.addContent(fidElement);
        Element domainFontElement = new Element("textfont");
        domainFontElement.addContent("");
        domainElement.addContent(domainFontElement);
        return domainElement;
    }

    private Element cutlineElement(Component component, String mode) {
        String strHigh;
        String parameter = component.getParameter();
        StringTokenizer st = new StringTokenizer(parameter, "#&%");
        String start = String.valueOf((int)component.getX());
        String startDrawType = st.nextToken();
        String end = mode.equals("P") ? String.valueOf((int)component.getX2()) : String.valueOf((int)component.getX2());
        String endDrawType = st.nextToken();
        String name = st.nextToken();
        String nameDrawType = st.nextToken();
        String size = st.nextToken();
        String strStrokeSize = st.nextToken();
        String gradient = st.nextToken();
        String texture = st.nextToken();
        String strShapeType = component.getShapeType().name();
        if (mode.equals("P")) {
            strHigh = component.getShapeType() == ShapeEnum.L_ParallelCurve || component.getShapeType() == ShapeEnum.R_ParallelCurve || component.getShapeType() == ShapeEnum.L_ParallelLine || component.getShapeType() == ShapeEnum.R_ParallelLine ? String.valueOf((int)component.getHigh()) : "10";
            String sRotationAngle = "0";
        } else {
            strHigh = String.valueOf((int)component.getHigh());
            String sRotationAngle = String.valueOf((int)component.getRotationAngle());
        }
        Element domainElement = new Element("component");
        Element domainStartElement = new Element("start");
        Element domainEndElement = new Element("end");
        Element domainNameElement = new Element("name");
        Element domainHighElement = new Element("high");
        Element domainShapeTypeElement = new Element("shapetype");
        Element domainStrokeSizeElement = new Element("strokesize");
        Element domainDashElement = new Element("dash");
        domainElement.setAttribute("type", "cutline");
        domainDashElement.addContent(String.valueOf(component.isbDash()));
        Element polygonLeftDashElement = new Element("leftdash");
        Element polygonRightDashElement = new Element("rightdash");
        polygonLeftDashElement.addContent(String.valueOf(component.bProteinLDash));
        polygonRightDashElement.addContent(String.valueOf(component.bProteinRDash));
        Color color = component.getColor();
        Color colortext = component.getColorText();
        Color colorline = component.getColorline();
        domainElement.addContent(domainStartElement);
        domainStartElement.setAttribute("direction", startDrawType);
        domainStartElement.addContent(start);
        domainElement.addContent(domainEndElement);
        domainEndElement.setAttribute("direction", endDrawType);
        domainEndElement.addContent(end);
        domainElement.addContent(domainNameElement);
        domainNameElement.setAttribute("color", color.getRed() + "," + color.getGreen() + "," + color.getBlue());
        domainNameElement.setAttribute("colorline", colorline.getRed() + "," + colorline.getGreen() + "," + colorline.getBlue());
        domainNameElement.addContent(name);
        domainHighElement.addContent(strHigh);
        domainShapeTypeElement.addContent(strShapeType);
        domainStrokeSizeElement.addContent(strStrokeSize);
        domainElement.addContent(domainHighElement);
        domainElement.addContent(domainShapeTypeElement);
        domainElement.addContent(domainStrokeSizeElement);
        domainElement.addContent(domainDashElement);
        domainElement.addContent(polygonLeftDashElement);
        domainElement.addContent(polygonRightDashElement);
        String fid = component.getFid();
        Element fidElement = new Element("id");
        fidElement.addContent(fid);
        domainElement.addContent(fidElement);
        Element domainFontElement = new Element("textfont");
        domainFontElement.addContent("");
        domainElement.addContent(domainFontElement);
        return domainElement;
    }

    private Element siteElement(Component component) {
        String[] arr = component.getParameter().split("#&%");
        String positions = arr[0];
        String text = arr[1];
        String size = arr[2];
        String isShow = arr[3];
        String deltaX = String.valueOf((int)component.getX());
        String deltaY = String.valueOf(component.getY());
        Color color = component.getColor();
        Color colortext = component.getColorText();
        Color colorline = component.getColorline();
        String strStrokeSize = arr[4];
        String gradient = arr[5];
        String texture = arr[6];
        String sCenterx = String.valueOf((int)component.getCenterx());
        String sCentery = String.valueOf((int)component.getCentery());
        String sWide = String.valueOf((int)component.getWide());
        String sHigh = String.valueOf((int)component.getHigh());
        String sRotationAngle = String.valueOf((int)component.getRotationAngle());
        String strShapeType = component.getShapeType().name();
        Element siteElement = new Element("component");
        Element sitePositionElement = new Element("position");
        Element siteTextElement = new Element("text");
        Element siteDashElement = new Element("dash");
        siteElement.setAttribute("type", "site");
        siteDashElement.addContent(String.valueOf(component.isbDash()));
        siteElement.addContent(sitePositionElement);
        sitePositionElement.addContent(positions);
        sitePositionElement.setAttribute("show", isShow);
        siteElement.addContent(siteTextElement);
        siteTextElement.setAttribute("deltax", deltaX);
        siteTextElement.setAttribute("deltay", deltaY);
        siteTextElement.setAttribute("size", size);
        siteTextElement.setAttribute("color", color.getRed() + "," + color.getGreen() + "," + color.getBlue());
        siteTextElement.setAttribute("colortext", colortext.getRed() + "," + colortext.getGreen() + "," + colortext.getBlue());
        siteTextElement.setAttribute("colorline", colorline.getRed() + "," + colorline.getGreen() + "," + colorline.getBlue());
        siteTextElement.addContent(text);
        Element siteStrokeSizeElement = new Element("strokesize");
        Element siteGradientElement = new Element("gradient");
        Element siteTextureElement = new Element("texture");
        Element siteCenterxElement = new Element("centerx");
        Element siteCenteryElement = new Element("centery");
        Element siteWideElement = new Element("wide");
        Element siteHighElement = new Element("high");
        Element siteRotationAngleElement = new Element("rotationAngle");
        Element siteShapeTypeElement = new Element("shapetype");
        siteShapeTypeElement.addContent(strShapeType);
        siteStrokeSizeElement.addContent(strStrokeSize);
        siteGradientElement.addContent(gradient);
        siteTextureElement.addContent(texture);
        siteCenterxElement.addContent(sCenterx);
        siteCenteryElement.addContent(sCentery);
        siteWideElement.addContent(sWide);
        siteHighElement.addContent(sHigh);
        siteRotationAngleElement.addContent(sRotationAngle);
        siteElement.addContent(siteStrokeSizeElement);
        siteElement.addContent(siteGradientElement);
        siteElement.addContent(siteTextureElement);
        siteElement.addContent(siteCenterxElement);
        siteElement.addContent(siteCenteryElement);
        siteElement.addContent(siteWideElement);
        siteElement.addContent(siteHighElement);
        siteElement.addContent(siteRotationAngleElement);
        siteElement.addContent(siteShapeTypeElement);
        siteElement.addContent(siteDashElement);
        Element siteFontElement = new Element("textfont");
        siteElement.addContent("");
        siteElement.addContent(siteFontElement);
        String fid = component.getFid();
        Element fidElement = new Element("id");
        fidElement.addContent(fid);
        siteElement.addContent(fidElement);
        return siteElement;
    }

    private Element noteElement(Component component) {
        String strfont;
        Color color = component.getColor();
        Color linecolor = component.getColorline();
        boolean bdash = component.bDash;
        String[] arr = component.getParameter().split("#&%");
        String text = arr[0].trim();
        String size = arr[1];
        String style = arr[2];
        String angle = String.valueOf((int)component.getRotationAngle());
        String linesize = arr[4];
        if (arr.length > 5) {
            strfont = arr[5];
            if (System.getProperty("os.name").equals("Linux") && strfont.equals("Arial")) {
                strfont = "Serif";
            }
        } else {
            strfont = System.getProperty("os.name").equals("Linux") ? "Serif" : "Arial";
        }
        String deltaX = String.valueOf((int)component.getX());
        String deltaY = String.valueOf(component.getY());
        Element noteElement = new Element("component");
        Element noteTextElement = new Element("text");
        noteElement.setAttribute("type", "note");
        noteElement.addContent(noteTextElement);
        noteTextElement.setAttribute("deltax", deltaX);
        noteTextElement.setAttribute("deltay", deltaY);
        noteTextElement.setAttribute("size", size);
        noteTextElement.setAttribute("style", style);
        noteTextElement.setAttribute("angle", angle);
        noteTextElement.setAttribute("linesize", linesize);
        noteTextElement.setAttribute("color", color.getRed() + "," + color.getGreen() + "," + color.getBlue());
        noteTextElement.setAttribute("linecolor", linecolor.getRed() + "," + linecolor.getGreen() + "," + linecolor.getBlue());
        noteTextElement.setAttribute("linedash", String.valueOf(bdash));
        String fid = component.getFid();
        Element fidElement = new Element("id");
        fidElement.addContent(fid);
        noteElement.addContent(fidElement);
        noteTextElement.addContent(text);
        Element noteTextFontElement = new Element("textfont");
        noteTextFontElement.addContent(strfont);
        noteElement.addContent(noteTextFontElement);
        return noteElement;
    }

    private Element lineElement(Component component) {
        DrawTypeEnum nameDrawType;
        Color color = component.getColor();
        String[] arr = component.getParameter().split("#&%");
        String weight = arr[0];
        String style = arr[1];
        String fname = "";
        int size = 10;
        if (arr.length > 2) {
            fname = arr[2];
            nameDrawType = DrawTypeEnum.valueOf(arr[3]);
            size = Integer.parseInt(arr[4]);
            fname.trim();
        } else {
            fname = "";
            nameDrawType = DrawTypeEnum.Center;
            size = 10;
        }
        String x1 = String.valueOf((int)component.getX());
        String y1 = String.valueOf(component.getY());
        String x2 = String.valueOf((int)component.getX2());
        String y2 = String.valueOf(component.getY2());
        String conx1 = String.valueOf(component.getControlx1());
        String cony1 = String.valueOf(component.getControly1());
        String conx2 = String.valueOf(component.getControlx2());
        String cony2 = String.valueOf(component.getControly2());
        String strShapeType = component.getShapeType().name();
        Element lineElement = new Element("component");
        lineElement.setAttribute("type", "line");
        Element weightElement = new Element("weight");
        weightElement.setAttribute("style", style);
        weightElement.setAttribute("color", color.getRed() + "," + color.getGreen() + "," + color.getBlue());
        weightElement.addContent(weight);
        Element textElement = new Element("text");
        textElement.setAttribute("size", String.valueOf(size));
        textElement.setAttribute("color", component.getColorText().getRed() + "," + component.getColorText().getGreen() + "," + component.getColorText().getBlue());
        textElement.setAttribute("direction", nameDrawType.name().toString());
        textElement.addContent(fname);
        Element x1Element = new Element("x1");
        x1Element.addContent(x1);
        Element y1Element = new Element("y1");
        y1Element.addContent(y1);
        Element x2Element = new Element("x2");
        x2Element.addContent(x2);
        Element y2Element = new Element("y2");
        y2Element.addContent(y2);
        Element lineShapeTypeElement = new Element("shapetype");
        lineShapeTypeElement.addContent(strShapeType);
        Element conx1Element = new Element("controlx1");
        conx1Element.addContent(conx1);
        Element cony1Element = new Element("controly1");
        cony1Element.addContent(cony1);
        Element conx2Element = new Element("controlx2");
        conx2Element.addContent(conx2);
        Element cony2Element = new Element("controly2");
        cony2Element.addContent(cony2);
        Element dashElement = new Element("dash");
        dashElement.addContent(String.valueOf(component.isbDash()));
        String fid = component.getFid();
        Element fidElement = new Element("id");
        fidElement.addContent(fid);
        lineElement.addContent(fidElement);
        lineElement.addContent(weightElement);
        lineElement.addContent(textElement);
        lineElement.addContent(x1Element);
        lineElement.addContent(y1Element);
        lineElement.addContent(x2Element);
        lineElement.addContent(y2Element);
        if (!strShapeType.equals("Straight")) {
            lineElement.addContent(conx1Element);
            lineElement.addContent(cony1Element);
            if (!strShapeType.equals("PolylineOne") && !strShapeType.equals("Curve")) {
                lineElement.addContent(conx2Element);
                lineElement.addContent(cony2Element);
            }
        }
        lineElement.addContent(lineShapeTypeElement);
        lineElement.addContent(dashElement);
        return lineElement;
    }

    public void save(Project project, String mode) {
        try {
            Document doc = this.buildDocument(project, mode);
            XMLOutputter xmlOut = new XMLOutputter(Format.getPrettyFormat());
            xmlOut.output(doc, (OutputStream)new FileOutputStream(new File(this.filePath)));
        }
        catch (IOException ex) {
            Logger.getLogger(Project2XML.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public Project open(String ibsmode) {
        Project project = null;
        try {
            SAXBuilder builder = new SAXBuilder(false);
            Document doc = builder.build(new File(this.filePath));
            project = this.analysisXML(doc, ibsmode);
            return project;
        }
        catch (JDOMException ex) {
            Logger.getLogger(Project2XML.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(Project2XML.class.getName()).log(Level.SEVERE, null, ex);
        }
        return project;
    }

    public Project openDemo(String mode) {
        Project project = null;
        InputStream is2 = mode.equals("P") ? this.getClass().getResourceAsStream("/gui/ibs/001.xml") : this.getClass().getResourceAsStream("/gui/ibs/002.xml");
        try {
            SAXBuilder builder = new SAXBuilder(false);
            Document doc = builder.build(is2);
            project = this.analysisXML(doc, mode);
            return project;
        }
        catch (JDOMException ex) {
            Logger.getLogger(Project2XML.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(Project2XML.class.getName()).log(Level.SEVERE, null, ex);
        }
        return project;
    }

    public String getXMLMode(String filePath1) {
        System.out.println(filePath1);
        Object project = null;
        try {
            FileInputStream xmlFile = new FileInputStream(filePath1);
            SAXBuilder builder = new SAXBuilder(false);
            Document doc = builder.build(xmlFile);
            String strFontErro = "";
            LinkedList proteinList = new LinkedList();
            Element root = doc.getRootElement();
            String projectVersion = root.getAttributeValue("version");
            List allroot = root.getAttributes();
            boolean bmode = false;
            for (int p = 0; p < allroot.size(); ++p) {
                String sl = allroot.get(p).toString();
                if (!sl.contains("[Attribute: mode=")) continue;
                bmode = true;
            }
            String mode = "N";
            bmode = true;
            if (true) {
                String fmode = root.getAttributeValue("mode");
                if (fmode == null) {
                    fmode = "protein";
                    mode = "P";
                } else if (fmode.equals("protein")) {
                    fmode = "protein";
                    mode = "P";
                } else if (fmode.equals("nucleotide")) {
                    fmode = "nucleotide";
                    mode = "N";
                }
            } else {
                String fmode = "protein";
                mode = "P";
            }
            return mode;
        }
        catch (JDOMException ex) {
            Logger.getLogger(Project2XML.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(Project2XML.class.getName()).log(Level.SEVERE, null, ex);
        }
        return "P";
    }

    public LinkedList<Protein> adjustProteinHorizontal(LinkedList<Protein> proteinList) {
        int hori;
        Protein pt;
        int i;
        int minhoriz = 0;
        int maxhoriz = 0;
        int size = proteinList.size();
        for (i = 0; i < size; ++i) {
            pt = proteinList.get(i);
            if (i == 0) {
                minhoriz = pt.getHorizontal();
                maxhoriz = pt.getHorizontal();
                continue;
            }
            if (minhoriz > pt.getHorizontal()) {
                minhoriz = pt.getHorizontal();
            }
            if (maxhoriz >= pt.getHorizontal()) continue;
            maxhoriz = pt.getHorizontal();
        }
        if (minhoriz == maxhoriz) {
            return proteinList;
        }
        if (minhoriz <= 0 && maxhoriz >= 0) {
            return proteinList;
        }
        if (minhoriz > 0 && maxhoriz > 0) {
            for (i = 0; i < size; ++i) {
                pt = proteinList.get(i);
                hori = pt.getHorizontal();
                pt.setHorizontal(hori -= minhoriz);
                proteinList.set(i, pt);
            }
        }
        if (minhoriz < 0 && maxhoriz < 0) {
            for (i = 0; i < size; ++i) {
                pt = proteinList.get(i);
                hori = pt.getHorizontal();
                pt.setHorizontal(hori -= maxhoriz);
                proteinList.set(i, pt);
            }
        }
        return proteinList;
    }

    private Project analysisXML(Document doc, String ibsmode) {
        String strFontErro = "";
        try {
            String fmode;
            LinkedList<Protein> proteinList = new LinkedList<Protein>();
            Element root = doc.getRootElement();
            String projectVersion = root.getAttributeValue("version");
            List allroot = root.getAttributes();
            boolean bmode = false;
            for (int p = 0; p < allroot.size(); ++p) {
                String sl = allroot.get(p).toString();
                if (!sl.contains("[Attribute: mode=")) continue;
                bmode = true;
            }
            String mode = "N";
            bmode = true;
            if (true) {
                fmode = root.getAttributeValue("mode");
                if (fmode == null) {
                    fmode = "protein";
                    mode = "P";
                } else if (fmode.equals("protein")) {
                    fmode = "protein";
                    mode = "P";
                } else if (fmode.equals("nucleotide")) {
                    fmode = "nucleotide";
                    mode = "N";
                }
            } else {
                fmode = "protein";
                mode = "P";
            }
            if (ibsmode.equals("P") && !mode.equals("P")) {
                JOptionPane.showMessageDialog(null, this.filePath + " is  not a  protein mode file!");
                return null;
            }
            if (ibsmode.equals("N") && !mode.equals("N")) {
                JOptionPane.showMessageDialog(null, this.filePath + " is  not a  nucleotide mode file!");
                return null;
            }
            int width = Integer.parseInt(root.getAttributeValue("width"));
            int height = Integer.parseInt(root.getAttributeValue("height"));
            float rate = 1.0f;
            try {
                String rStr = root.getAttributeValue("rate");
                rate = rStr.contains(",") ? Float.parseFloat(rStr.replaceAll(",", ".")) : Float.parseFloat(rStr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (projectVersion.equals("IBS 1.0") || projectVersion.equals("DOG 2.0") || projectVersion.equals("DOG 1.0")) {
                List projectNodeList = root.getChildren("protein");
                for (Element protein : projectNodeList) {
                    Color proteinlineColor;
                    String texture1;
                    String gradient1;
                    int vertical = Integer.parseInt(protein.getAttributeValue("vertical"));
                    int horizontal = Integer.parseInt(protein.getAttributeValue("horizontal"));
                    boolean isLocked = Boolean.parseBoolean(protein.getAttributeValue("locked"));
                    Element proteinStartElement = protein.getChild("start");
                    String proteinStart = proteinStartElement.getText();
                    String proteinStartType = proteinStartElement.getAttributeValue("direction");
                    Element proteinEndElement = protein.getChild("end");
                    String proteinEnd = proteinEndElement.getText();
                    String proteinEndType = proteinEndElement.getAttributeValue("direction");
                    Element proteinHeightElement = protein.getChild("height");
                    String proteinHeight = proteinHeightElement.getText();
                    String proteinColorStr = proteinHeightElement.getAttributeValue("color");
                    StringTokenizer ster = new StringTokenizer(proteinColorStr, ",");
                    Color proteinColor = new Color(Integer.parseInt(ster.nextToken()), Integer.parseInt(ster.nextToken()), Integer.parseInt(ster.nextToken()));
                    String proteinSize = proteinHeightElement.getAttributeValue("size");
                    List ell = protein.getChildren();
                    boolean bgradient = false;
                    boolean btexture = false;
                    boolean bProteinDash = false;
                    boolean bLinesize = false;
                    boolean bpid = false;
                    String pid = " ";
                    for (int l = 0; l < ell.size(); ++l) {
                        if (ell.get(l).toString().equals("[Element: <gradient/>]")) {
                            bgradient = true;
                        }
                        if (ell.get(l).toString().equals("[Element: <texture/>]")) {
                            btexture = true;
                        }
                        if (ell.get(l).toString().equals("[Element: <dash/>]")) {
                            bProteinDash = true;
                        }
                        if (ell.get(l).toString().equals("[Element: <linesize/>]")) {
                            bLinesize = true;
                        }
                        if (!ell.get(l).toString().equals("[Element: <id/>]")) continue;
                        bpid = true;
                    }
                    String sproteindash = "false";
                    String sLinesize = "1";
                    if (bgradient) {
                        Element domaingradient = protein.getChild("gradient");
                        gradient1 = domaingradient.getText();
                    } else {
                        gradient1 = "Horizontal";
                    }
                    if (btexture) {
                        Element domaintexture = protein.getChild("texture");
                        texture1 = domaintexture.getText();
                    } else {
                        texture1 = "00000_0.jpg";
                    }
                    if (bProteinDash) {
                        Element domaindash = protein.getChild("dash");
                        sproteindash = domaindash.getText();
                    } else {
                        sproteindash = "false";
                    }
                    if (bLinesize) {
                        Element domainbLinesize = protein.getChild("linesize");
                        sLinesize = domainbLinesize.getText();
                    } else {
                        sLinesize = "1";
                    }
                    if (bpid) {
                        Element domainbid = protein.getChild("id");
                        pid = domainbid.getText();
                        if (pid.equals("")) {
                            pid = " ";
                        }
                    } else {
                        pid = " ";
                    }
                    List all = proteinHeightElement.getAttributes();
                    boolean bcolorline1 = false;
                    for (int p = 0; p < all.size(); ++p) {
                        String sl = all.get(p).toString();
                        if (!sl.contains("[Attribute: colorline=")) continue;
                        bcolorline1 = true;
                    }
                    String colorlineStr1 = "0,0,0";
                    if (bcolorline1) {
                        colorlineStr1 = proteinHeightElement.getAttributeValue("colorline");
                        StringTokenizer stline = new StringTokenizer(colorlineStr1, ",");
                        proteinlineColor = new Color(Integer.parseInt(stline.nextToken()), Integer.parseInt(stline.nextToken()), Integer.parseInt(stline.nextToken()));
                    } else {
                        proteinlineColor = Color.BLACK;
                    }
                    String proteinParameter = proteinStart + "#&%" + proteinStartType + "#&%" + proteinEnd + "#&%" + proteinEndType + "#&%" + proteinHeight + "#&%" + proteinSize + "#&%" + gradient1 + "#&%" + texture1 + "#&%" + sproteindash + "#&%" + sLinesize + "#&%" + colorlineStr1 + "#&%" + pid;
                    LinkedList<Component> componentList = new LinkedList<Component>();
                    List componentNodeList = protein.getChildren("component");
                    for (Element component : componentNodeList) {
                        Element domainStart;
                        String colorStr;
                        String nameSize;
                        StringTokenizer stline;
                        String sl;
                        List el;
                        String componentType = component.getAttributeValue("type");
                        if (componentType.equals("domain")) {
                            if (fmode.equals("protein")) {
                                Color colortext;
                                Color colorline;
                                String strhigh;
                                String texture;
                                String gradient;
                                el = component.getChildren();
                                String strokesize = "1";
                                if (el.toString().contains("[Element: <gradient/>]")) {
                                    Element domaingradient = component.getChild("gradient");
                                    gradient = domaingradient.getText();
                                } else {
                                    gradient = "Horizontal";
                                }
                                if (el.toString().contains("[Element: <strokesize/>]")) {
                                    Element domainstrokesize = component.getChild("strokesize");
                                    strokesize = domainstrokesize.getText();
                                } else {
                                    strokesize = "1";
                                }
                                if (el.toString().contains("[Element: <texture/>]")) {
                                    Element domaintexture = component.getChild("texture");
                                    texture = domaintexture.getText();
                                } else {
                                    gradient = "Horizontal";
                                    texture = "00000_0.jpg";
                                }
                                String sdomaindash = "false";
                                if (el.toString().contains("[Element: <dash/>]")) {
                                    Element domaindash = component.getChild("dash");
                                    sdomaindash = domaindash.getText();
                                } else {
                                    sdomaindash = "false";
                                }
                                String strshapetype = "Rectangle";
                                if (el.toString().contains("[Element: <shapetype/>]")) {
                                    Element domainshapetype = component.getChild("shapetype");
                                    strshapetype = domainshapetype.getText();
                                } else {
                                    strshapetype = "Rectangle";
                                }
                                if (el.toString().contains("[Element: <high/>]")) {
                                    Element domainHigh = component.getChild("high");
                                    strhigh = domainHigh.getText();
                                } else {
                                    strhigh = "0";
                                }
                                int iHigh = Integer.valueOf(strhigh);
                                String strbleftd = "false";
                                if (el.toString().contains("[Element: <leftdash/>]")) {
                                    Element domainbleftd = component.getChild("leftdash");
                                    strbleftd = domainbleftd.getText();
                                } else {
                                    strbleftd = "false";
                                }
                                String strbrightd = "false";
                                if (el.toString().contains("[Element: <rightdash/>]")) {
                                    Element domainbrightd = component.getChild("rightdash");
                                    strbrightd = domainbrightd.getText();
                                } else {
                                    strbrightd = "false";
                                }
                                double iRotationAngle = 0.0;
                                Element domainStart2 = component.getChild("start");
                                int start = Integer.parseInt(domainStart2.getText());
                                String startDirect = domainStart2.getAttributeValue("direction");
                                Element domainEnd = component.getChild("end");
                                int end = Integer.parseInt(domainEnd.getText());
                                String endDirect = domainEnd.getAttributeValue("direction");
                                Element domainName = component.getChild("name");
                                String name = domainName.getText();
                                if (name.equals("")) {
                                    name = " ";
                                }
                                List al = domainName.getAttributes();
                                boolean bcolorline = false;
                                boolean bcolortext = false;
                                for (int p = 0; p < al.size(); ++p) {
                                    sl = al.get(p).toString();
                                    if (sl.contains("[Attribute: colorline=")) {
                                        bcolorline = true;
                                    }
                                    if (!sl.contains("[Attribute: colortext=")) continue;
                                    bcolortext = true;
                                }
                                if (bcolorline) {
                                    String colorlineStr = domainName.getAttributeValue("colorline");
                                    stline = new StringTokenizer(colorlineStr, ",");
                                    colorline = new Color(Integer.parseInt(stline.nextToken()), Integer.parseInt(stline.nextToken()), Integer.parseInt(stline.nextToken()));
                                } else {
                                    colorline = Color.BLACK;
                                }
                                if (bcolortext) {
                                    String colortextStr = domainName.getAttributeValue("colortext");
                                    StringTokenizer sttext = new StringTokenizer(colortextStr, ",");
                                    colortext = new Color(Integer.parseInt(sttext.nextToken()), Integer.parseInt(sttext.nextToken()), Integer.parseInt(sttext.nextToken()));
                                } else {
                                    colortext = Color.BLACK;
                                }
                                String nameDirect = domainName.getAttributeValue("direction");
                                nameSize = domainName.getAttributeValue("size");
                                colorStr = domainName.getAttributeValue("color");
                                StringTokenizer st = new StringTokenizer(colorStr, ",");
                                Color color = new Color(Integer.parseInt(st.nextToken()), Integer.parseInt(st.nextToken()), Integer.parseInt(st.nextToken()));
                                String parameter = startDirect + "#&%" + endDirect + "#&%" + name + "#&%" + nameDirect + "#&%" + nameSize + "#&%" + strokesize + "#&%" + gradient + "#&%" + texture;
                                String fid = "";
                                if (el.toString().contains("[Element: <id/>]")) {
                                    Element sitedash = component.getChild("id");
                                    fid = sitedash.getText();
                                } else {
                                    fid = "";
                                }
                                if (strshapetype.equals("Rectangle")) {
                                    componentList.add(new Component(ComponentEnum.Domain, start, end, parameter, color, colortext, colorline, Boolean.valueOf(sdomaindash)));
                                    continue;
                                }
                                componentList.add(new Component(ComponentEnum.Domain, (double)start, (double)end, parameter, color, colortext, colorline, ShapeEnum.valueOf(strshapetype), (double)iHigh, iRotationAngle, Boolean.valueOf(strbleftd), Boolean.valueOf(strbrightd), (boolean)Boolean.valueOf(sdomaindash), fid));
                                continue;
                            }
                            domainStart = component.getChild("start");
                            int start = Integer.parseInt(domainStart.getText());
                            String startDirect = domainStart.getAttributeValue("direction");
                            Element domainEnd = component.getChild("end");
                            int end = Integer.parseInt(domainEnd.getText());
                            String endDirect = domainEnd.getAttributeValue("direction");
                            Element domainName = component.getChild("name");
                            String name = domainName.getText();
                            if (name.equals("")) {
                                name = " ";
                            }
                            String nameDirect = domainName.getAttributeValue("direction");
                            String nameSize2 = domainName.getAttributeValue("size");
                            String colorStr2 = domainName.getAttributeValue("color");
                            StringTokenizer st = new StringTokenizer(colorStr2, ",");
                            Color color = new Color(Integer.parseInt(st.nextToken()), Integer.parseInt(st.nextToken()), Integer.parseInt(st.nextToken()));
                            String colorlineStr = domainName.getAttributeValue("colorline");
                            StringTokenizer stline2 = new StringTokenizer(colorlineStr, ",");
                            Color colorline = new Color(Integer.parseInt(stline2.nextToken()), Integer.parseInt(stline2.nextToken()), Integer.parseInt(stline2.nextToken()));
                            String colortextStr = domainName.getAttributeValue("colortext");
                            StringTokenizer sttext = new StringTokenizer(colortextStr, ",");
                            Color colortext = new Color(Integer.parseInt(sttext.nextToken()), Integer.parseInt(sttext.nextToken()), Integer.parseInt(sttext.nextToken()));
                            Element domainstrokesize = component.getChild("strokesize");
                            String strokesize = domainstrokesize.getText();
                            Element domaingradient = component.getChild("gradient");
                            String gradient = domaingradient.getText();
                            Element domaintexture = component.getChild("texture");
                            String texture = domaintexture.getText();
                            Element domainRotationAngle = component.getChild("rotationAngle");
                            String sRotationAngle = domainRotationAngle.getText();
                            int iRotationAngle = Integer.valueOf(sRotationAngle);
                            String parameter = startDirect + "#&%" + endDirect + "#&%" + name + "#&%" + nameDirect + "#&%" + nameSize2 + "#&%" + strokesize + "#&%" + gradient + "#&%" + texture;
                            boolean y1 = false;
                            boolean y2 = false;
                            Element domainHigh = component.getChild("high");
                            String strhigh = domainHigh.getText();
                            int iHigh = Integer.valueOf(strhigh);
                            Element domainshapetype = component.getChild("shapetype");
                            String strshapetype = domainshapetype.getText();
                            ShapeEnum shapetype = ShapeEnum.valueOf(strshapetype);
                            Element domainborderdash = component.getChild("dash");
                            String strborderdash = domainborderdash.getText();
                            Element domainbleftdash = component.getChild("leftdash");
                            String strbleftdash = domainbleftdash.getText();
                            Element domainbrightdash = component.getChild("rightdash");
                            String strbrightdash = domainbrightdash.getText();
                            String fid = "";
                            List el2 = component.getChildren();
                            if (el2.toString().contains("[Element: <id/>]")) {
                                Element sitedash = component.getChild("id");
                                fid = sitedash.getText();
                            } else {
                                fid = "";
                            }
                            componentList.add(new Component(ComponentEnum.Domain, (double)start, (double)end, parameter, color, colortext, colorline, shapetype, (double)iHigh, (double)iRotationAngle, Boolean.valueOf(strbleftdash), Boolean.valueOf(strbrightdash), (boolean)Boolean.valueOf(strborderdash), fid));
                            continue;
                        }
                        if (componentType.equals("cutline")) {
                            if (fmode.equals("protein")) {
                                Color colorline;
                                String strhigh;
                                el = component.getChildren();
                                String strokesize = "1";
                                String gradient = "Null";
                                if (el.toString().contains("[Element: <strokesize/>]")) {
                                    Element domainstrokesize = component.getChild("strokesize");
                                    strokesize = domainstrokesize.getText();
                                } else {
                                    strokesize = "1";
                                }
                                String texture = "00000_0.jpg";
                                String sdomaindash = "false";
                                if (el.toString().contains("[Element: <dash/>]")) {
                                    Element domaindash = component.getChild("dash");
                                    sdomaindash = domaindash.getText();
                                } else {
                                    sdomaindash = "false";
                                }
                                String strshapetype = "Rectangle";
                                if (el.toString().contains("[Element: <shapetype/>]")) {
                                    Element domainshapetype = component.getChild("shapetype");
                                    strshapetype = domainshapetype.getText();
                                } else {
                                    strshapetype = "Rectangle";
                                }
                                if (el.toString().contains("[Element: <high/>]")) {
                                    Element domainHigh = component.getChild("high");
                                    strhigh = domainHigh.getText();
                                } else {
                                    strhigh = "0";
                                }
                                int iHigh = Integer.valueOf(strhigh);
                                String strbleftd = "false";
                                if (el.toString().contains("[Element: <leftdash/>]")) {
                                    Element domainbleftd = component.getChild("leftdash");
                                    strbleftd = domainbleftd.getText();
                                } else {
                                    strbleftd = "false";
                                }
                                String strbrightd = "false";
                                if (el.toString().contains("[Element: <rightdash/>]")) {
                                    Element domainbrightd = component.getChild("rightdash");
                                    strbrightd = domainbrightd.getText();
                                } else {
                                    strbrightd = "false";
                                }
                                double iRotationAngle = 0.0;
                                Element domainStart3 = component.getChild("start");
                                int start = Integer.parseInt(domainStart3.getText());
                                String startDirect = domainStart3.getAttributeValue("direction");
                                Element domainEnd = component.getChild("end");
                                int end = Integer.parseInt(domainEnd.getText());
                                String endDirect = domainEnd.getAttributeValue("direction");
                                Element domainName = component.getChild("name");
                                String name = domainName.getText();
                                if (name.equals("")) {
                                    name = " ";
                                }
                                List al = domainName.getAttributes();
                                boolean bcolorline = false;
                                boolean bcolortext = false;
                                for (int p = 0; p < al.size(); ++p) {
                                    sl = al.get(p).toString();
                                    if (!sl.contains("[Attribute: colorline=")) continue;
                                    bcolorline = true;
                                }
                                if (bcolorline) {
                                    String colorlineStr = domainName.getAttributeValue("colorline");
                                    stline = new StringTokenizer(colorlineStr, ",");
                                    colorline = new Color(Integer.parseInt(stline.nextToken()), Integer.parseInt(stline.nextToken()), Integer.parseInt(stline.nextToken()));
                                } else {
                                    colorline = Color.BLACK;
                                }
                                Color colortext = Color.BLACK;
                                String nameDirect = "Hide";
                                nameSize = "0";
                                colorStr = domainName.getAttributeValue("color");
                                StringTokenizer st = new StringTokenizer(colorStr, ",");
                                Color color = new Color(Integer.parseInt(st.nextToken()), Integer.parseInt(st.nextToken()), Integer.parseInt(st.nextToken()));
                                String parameter = startDirect + "#&%" + endDirect + "#&%" + name + "#&%" + nameDirect + "#&%" + nameSize + "#&%" + strokesize + "#&%" + gradient + "#&%" + texture;
                                String fid = "";
                                if (el.toString().contains("[Element: <id/>]")) {
                                    Element sitedash = component.getChild("id");
                                    fid = sitedash.getText();
                                } else {
                                    fid = "";
                                }
                                if (strshapetype.equals("Rectangle")) {
                                    componentList.add(new Component(ComponentEnum.CutLine, start, end, parameter, color, colortext, colorline, Boolean.valueOf(sdomaindash)));
                                    continue;
                                }
                                componentList.add(new Component(ComponentEnum.CutLine, (double)start, (double)end, parameter, color, colortext, colorline, ShapeEnum.valueOf(strshapetype), (double)iHigh, iRotationAngle, Boolean.valueOf(strbleftd), Boolean.valueOf(strbrightd), (boolean)Boolean.valueOf(sdomaindash), fid));
                                continue;
                            }
                            domainStart = component.getChild("start");
                            int start = Integer.parseInt(domainStart.getText());
                            String startDirect = domainStart.getAttributeValue("direction");
                            Element domainEnd = component.getChild("end");
                            int end = Integer.parseInt(domainEnd.getText());
                            String endDirect = domainEnd.getAttributeValue("direction");
                            Element domainName = component.getChild("name");
                            String name = domainName.getText();
                            if (name.equals("")) {
                                name = " ";
                            }
                            String nameDirect = "Hide";
                            String nameSize3 = "0";
                            String colorStr3 = domainName.getAttributeValue("color");
                            StringTokenizer st = new StringTokenizer(colorStr3, ",");
                            Color color = new Color(Integer.parseInt(st.nextToken()), Integer.parseInt(st.nextToken()), Integer.parseInt(st.nextToken()));
                            String colorlineStr = domainName.getAttributeValue("colorline");
                            StringTokenizer stline3 = new StringTokenizer(colorlineStr, ",");
                            Color colorline = new Color(Integer.parseInt(stline3.nextToken()), Integer.parseInt(stline3.nextToken()), Integer.parseInt(stline3.nextToken()));
                            Color colortext = Color.BLACK;
                            Element domainstrokesize = component.getChild("strokesize");
                            String strokesize = domainstrokesize.getText();
                            String gradient = "Null";
                            String texture = "00000_0.jpg";
                            String sRotationAngle = "0";
                            int iRotationAngle = Integer.valueOf(sRotationAngle);
                            String parameter = startDirect + "#&%" + endDirect + "#&%" + name + "#&%" + nameDirect + "#&%" + nameSize3 + "#&%" + strokesize + "#&%" + gradient + "#&%" + texture;
                            boolean y1 = false;
                            boolean y2 = false;
                            Element domainHigh = component.getChild("high");
                            String strhigh = domainHigh.getText();
                            int iHigh = Integer.valueOf(strhigh);
                            Element domainshapetype = component.getChild("shapetype");
                            String strshapetype = domainshapetype.getText();
                            ShapeEnum shapetype = ShapeEnum.valueOf(strshapetype);
                            Element domainborderdash = component.getChild("dash");
                            String strborderdash = domainborderdash.getText();
                            Element domainbleftdash = component.getChild("leftdash");
                            String strbleftdash = domainbleftdash.getText();
                            Element domainbrightdash = component.getChild("rightdash");
                            String strbrightdash = domainbrightdash.getText();
                            String fid = "";
                            List el3 = component.getChildren();
                            if (el3.toString().contains("[Element: <id/>]")) {
                                Element sitedash = component.getChild("id");
                                fid = sitedash.getText();
                            } else {
                                fid = "";
                            }
                            componentList.add(new Component(ComponentEnum.CutLine, (double)start, (double)end, parameter, color, colortext, colorline, shapetype, (double)iHigh, (double)iRotationAngle, Boolean.valueOf(strbleftdash), Boolean.valueOf(strbrightdash), (boolean)Boolean.valueOf(strborderdash), fid));
                            continue;
                        }
                        if (componentType.equals("site")) {
                            ShapeEnum shapetype;
                            String sRotationAngle;
                            String sHigh;
                            String sWide;
                            String sCentery;
                            String sCenterx;
                            String strokesize;
                            String texture;
                            String gradient;
                            Color colortext;
                            Color colorline;
                            Element sitePosition = component.getChild("position");
                            String position = sitePosition.getText();
                            String show = sitePosition.getAttributeValue("show");
                            Element siteText = component.getChild("text");
                            String text = siteText.getText();
                            if (text.equals("")) {
                                text = "     ";
                            }
                            int deltaX = Integer.parseInt(siteText.getAttributeValue("deltax"));
                            int deltaY = Integer.parseInt(siteText.getAttributeValue("deltay"));
                            String size = siteText.getAttributeValue("size");
                            String colorStr4 = siteText.getAttributeValue("color");
                            StringTokenizer st = new StringTokenizer(colorStr4, ",");
                            Color color = new Color(Integer.parseInt(st.nextToken()), Integer.parseInt(st.nextToken()), Integer.parseInt(st.nextToken()));
                            List al = siteText.getAttributes();
                            boolean bcolorline = false;
                            boolean bcolortext = false;
                            for (int p = 0; p < al.size(); ++p) {
                                String sl2 = al.get(p).toString();
                                if (sl2.contains("[Attribute: colorline=")) {
                                    bcolorline = true;
                                }
                                if (!sl2.contains("[Attribute: colortext=")) continue;
                                bcolortext = true;
                            }
                            if (bcolorline) {
                                String colorlineStr = siteText.getAttributeValue("colorline");
                                StringTokenizer stline4 = new StringTokenizer(colorlineStr, ",");
                                colorline = new Color(Integer.parseInt(stline4.nextToken()), Integer.parseInt(stline4.nextToken()), Integer.parseInt(stline4.nextToken()));
                            } else {
                                colorline = Color.BLACK;
                            }
                            if (bcolortext) {
                                String colortextStr = siteText.getAttributeValue("colortext");
                                StringTokenizer sttext = new StringTokenizer(colortextStr, ",");
                                colortext = new Color(Integer.parseInt(sttext.nextToken()), Integer.parseInt(sttext.nextToken()), Integer.parseInt(sttext.nextToken()));
                            } else {
                                colortext = Color.BLACK;
                            }
                            List el4 = component.getChildren();
                            if (el4.toString().contains("[Element: <gradient/>]")) {
                                Element sitegradient = component.getChild("gradient");
                                gradient = sitegradient.getText();
                            } else {
                                gradient = "Center";
                            }
                            if (el4.toString().contains("[Element: <texture/>]")) {
                                Element sitetexture = component.getChild("texture");
                                texture = sitetexture.getText();
                            } else {
                                texture = "00000_0.jpg";
                            }
                            if (el4.toString().contains("[Element: <strokesize/>]")) {
                                Element sitestrokesize = component.getChild("strokesize");
                                strokesize = sitestrokesize.getText();
                            } else {
                                strokesize = "1";
                            }
                            if (el4.toString().contains("[Element: <centerx/>]")) {
                                Element siteCenterx = component.getChild("centerx");
                                sCenterx = siteCenterx.getText();
                            } else {
                                sCenterx = String.valueOf(deltaX);
                            }
                            if (el4.toString().contains("[Element: <centery/>]")) {
                                Element siteCentery = component.getChild("centery");
                                sCentery = siteCentery.getText();
                            } else {
                                sCentery = String.valueOf(deltaY);
                            }
                            if (el4.toString().contains("[Element: <wide/>]")) {
                                Element siteWide = component.getChild("wide");
                                sWide = siteWide.getText();
                            } else {
                                sWide = String.valueOf(5);
                            }
                            if (el4.toString().contains("[Element: <high/>]")) {
                                Element siteHigh = component.getChild("high");
                                sHigh = siteHigh.getText();
                            } else {
                                sHigh = String.valueOf(5);
                            }
                            if (el4.toString().contains("[Element: <rotationAngle/>]")) {
                                Element siteRotationAngle = component.getChild("rotationAngle");
                                sRotationAngle = siteRotationAngle.getText();
                            } else {
                                sRotationAngle = String.valueOf(0);
                            }
                            if (el4.toString().contains("[Element: <shapetype/>]")) {
                                Element siteshapetype = component.getChild("shapetype");
                                String strshapetype = siteshapetype.getText();
                                shapetype = ShapeEnum.valueOf(strshapetype);
                            } else {
                                shapetype = ShapeEnum.Null;
                            }
                            String ssitedash = "false";
                            if (el4.toString().contains("[Element: <dash/>]")) {
                                Element sitedash = component.getChild("dash");
                                ssitedash = sitedash.getText();
                            } else {
                                ssitedash = "false";
                            }
                            String fid = "";
                            if (el4.toString().contains("[Element: <id/>]")) {
                                Element sitedash = component.getChild("id");
                                fid = sitedash.getText();
                            } else {
                                fid = "";
                            }
                            int iCenterx = Integer.valueOf(sCenterx);
                            int iCentery = Integer.valueOf(sCentery);
                            int iWide = Integer.valueOf(sWide);
                            int iHigh = Integer.valueOf(sHigh);
                            int iRotationAngle = Integer.valueOf(sRotationAngle);
                            String parameter = position + "#&%" + text + "#&%" + size + "#&%" + show + "#&%" + strokesize + "#&%" + gradient + "#&%" + texture;
                            componentList.add(new Component(ComponentEnum.Site, iCenterx, iCentery, parameter, colortext, shapetype, "site", iWide, iHigh, iRotationAngle, color, colorline, (boolean)Boolean.valueOf(ssitedash), fid));
                            continue;
                        }
                        if (componentType.equals("note")) {
                            String strfont;
                            Color colorline;
                            Element noteText = component.getChild("text");
                            String text = noteText.getText().trim();
                            int deltaX = Integer.parseInt(noteText.getAttributeValue("deltax"));
                            int deltaY = Integer.parseInt(noteText.getAttributeValue("deltay"));
                            String size = noteText.getAttributeValue("size");
                            String style = noteText.getAttributeValue("style");
                            String angle = noteText.getAttributeValue("angle");
                            String colorStr5 = noteText.getAttributeValue("color");
                            StringTokenizer st = new StringTokenizer(colorStr5, ",");
                            Color color = new Color(Integer.parseInt(st.nextToken()), Integer.parseInt(st.nextToken()), Integer.parseInt(st.nextToken()));
                            int linesize = 0;
                            boolean blinedash = false;
                            List al = noteText.getAttributes();
                            boolean bcolorline = false;
                            boolean bhasdash = false;
                            boolean blinesize = false;
                            for (int p = 0; p < al.size(); ++p) {
                                String sl3 = al.get(p).toString();
                                if (sl3.contains("[Attribute: linecolor=")) {
                                    bcolorline = true;
                                }
                                if (sl3.contains("[Attribute: linesize=")) {
                                    blinesize = true;
                                }
                                if (!sl3.contains("[Attribute: linedash=")) continue;
                                bhasdash = true;
                            }
                            if (bcolorline) {
                                String colorlineStr = noteText.getAttributeValue("linecolor");
                                StringTokenizer stline5 = new StringTokenizer(colorlineStr, ",");
                                colorline = new Color(Integer.parseInt(stline5.nextToken()), Integer.parseInt(stline5.nextToken()), Integer.parseInt(stline5.nextToken()));
                            } else {
                                colorline = Color.BLACK;
                            }
                            if (bhasdash) {
                                String strbdash = noteText.getAttributeValue("linedash");
                                blinedash = Boolean.valueOf(strbdash);
                            } else {
                                blinedash = false;
                            }
                            if (blinesize) {
                                String strlinesize = noteText.getAttributeValue("linesize");
                                linesize = Integer.valueOf(strlinesize);
                            } else {
                                linesize = 0;
                            }
                            List el5 = component.getChildren();
                            if (el5.toString().contains("[Element: <textfont/>]")) {
                                Element font = component.getChild("textfont");
                                strfont = font.getText();
                                if (System.getProperty("os.name").equals("Linux") && strfont.equals("Arial")) {
                                    strfont = "Serif";
                                }
                            } else {
                                strfont = System.getProperty("os.name").equals("Linux") ? "Serif" : "Arial";
                            }
                            if (!GetLocalFontFamily.isHasFont(strfont)) {
                                strFontErro = "Font invalid!";
                            }
                            String fid = " ";
                            if (el5.toString().contains("[Element: <id/>]")) {
                                Element sitedash = component.getChild("id");
                                fid = sitedash.getText();
                            } else {
                                fid = "";
                            }
                            String parameter = text + "#&%" + size + "#&%" + style + "#&%" + angle + "#&%" + linesize + "#&%" + strfont;
                            componentList.add(new Component(ComponentEnum.Note, deltaX, deltaY, parameter, color, colorline, blinedash, Integer.valueOf(angle), fid));
                            continue;
                        }
                        if (componentType.equals("line")) {
                            ShapeEnum shapetype;
                            Element weightElement = component.getChild("weight");
                            String weight = weightElement.getText();
                            String style = weightElement.getAttributeValue("style");
                            String colorStr6 = weightElement.getAttributeValue("color");
                            StringTokenizer st = new StringTokenizer(colorStr6, ",");
                            Color color = new Color(Integer.parseInt(st.nextToken()), Integer.parseInt(st.nextToken()), Integer.parseInt(st.nextToken()));
                            int x1 = Integer.parseInt(component.getChildText("x1"));
                            int y1 = Integer.parseInt(component.getChildText("y1"));
                            int x2 = Integer.parseInt(component.getChildText("x2"));
                            int y2 = Integer.parseInt(component.getChildText("y2"));
                            List el6 = component.getChildren();
                            boolean bDash = false;
                            String fname = "";
                            DrawTypeEnum nameDrawType = DrawTypeEnum.Center;
                            int size = 10;
                            Color colortext = Color.BLACK;
                            int conx1 = 0;
                            int cony1 = 0;
                            int conx2 = 0;
                            int cony2 = 0;
                            if (el6.toString().contains("[Element: <controlx1/>]")) {
                                conx1 = Integer.parseInt(component.getChildText("controlx1"));
                            }
                            if (el6.toString().contains("[Element: <controly1/>]")) {
                                cony1 = Integer.parseInt(component.getChildText("controly1"));
                            }
                            if (el6.toString().contains("[Element: <controlx2/>]")) {
                                conx2 = Integer.parseInt(component.getChildText("controlx2"));
                            }
                            if (el6.toString().contains("[Element: <controly2/>]")) {
                                cony2 = Integer.parseInt(component.getChildText("controly2"));
                            }
                            if (el6.toString().contains("[Element: <shapetype/>]")) {
                                Element domainshapetype = component.getChild("shapetype");
                                String strshapetype = domainshapetype.getText();
                                shapetype = ShapeEnum.valueOf(strshapetype);
                            } else {
                                shapetype = ShapeEnum.Straight;
                            }
                            if (el6.toString().contains("[Element: <dash/>]")) {
                                bDash = Boolean.parseBoolean(component.getChildText("dash"));
                            }
                            if (el6.toString().contains("[Element: <text/>]")) {
                                fname = component.getChildText("text");
                                Element textElement = component.getChild("text");
                                String colortextstr = textElement.getAttributeValue("color");
                                StringTokenizer st1 = new StringTokenizer(colortextstr, ",");
                                colortext = new Color(Integer.parseInt(st1.nextToken()), Integer.parseInt(st1.nextToken()), Integer.parseInt(st1.nextToken()));
                                nameDrawType = DrawTypeEnum.valueOf(textElement.getAttributeValue("direction"));
                                size = Integer.parseInt(textElement.getAttributeValue("size"));
                            }
                            String parameter = weight + "#&%" + style + "#&%" + fname + "#&%" + nameDrawType.name().toString() + "#&%" + String.valueOf(size);
                            String fid = "";
                            if (el6.toString().contains("[Element: <id/>]")) {
                                Element sitedash = component.getChild("id");
                                fid = sitedash.getText();
                            } else {
                                fid = "";
                            }
                            componentList.add(new Component(ComponentEnum.Line, x1, y1, x2, y2, conx1, cony1, conx2, cony2, parameter, color, colortext, shapetype, bDash, fid));
                            continue;
                        }
                        if (componentType.equals("bracket")) {
                            Element colorElement = component.getChild("color");
                            String colorStr7 = colorElement.getText();
                            StringTokenizer st = new StringTokenizer(colorStr7, ",");
                            Color color = new Color(Integer.parseInt(st.nextToken()), Integer.parseInt(st.nextToken()), Integer.parseInt(st.nextToken()));
                            Element domainstrokesize = component.getChild("strokesize");
                            String strokesize = domainstrokesize.getText();
                            Element domainCenterx = component.getChild("centerx");
                            String sCenterx = domainCenterx.getText();
                            Element domainCentery = component.getChild("centery");
                            String sCentery = domainCentery.getText();
                            Element domainWide = component.getChild("wide");
                            String sWide = domainWide.getText();
                            Element domainRotationAngle = component.getChild("rotationAngle");
                            String sRotationAngle = domainRotationAngle.getText();
                            int iCenterx = Integer.valueOf(sCenterx);
                            int iCentery = Integer.valueOf(sCentery);
                            int iWide = Integer.valueOf(sWide);
                            int iRotationAngle = Integer.valueOf(sRotationAngle);
                            String parameter = strokesize;
                            Element domainshapetype = component.getChild("shapetype");
                            String strshapetype = domainshapetype.getText();
                            ShapeEnum shapetype = ShapeEnum.valueOf(strshapetype);
                            String fid = "";
                            List el7 = component.getChildren();
                            if (el7.toString().contains("[Element: <id/>]")) {
                                Element sitedash = component.getChild("id");
                                fid = sitedash.getText();
                            } else {
                                fid = "";
                            }
                            componentList.add(new Component(ComponentEnum.Bracket, color, iCenterx, iCentery, iWide, iRotationAngle, parameter, shapetype, fid));
                            continue;
                        }
                        if (!componentType.equals("polygon")) continue;
                        Element polygonName = component.getChild("name");
                        String name = polygonName.getText();
                        if (name.equals("")) {
                            name = " ";
                        }
                        String spolygondash = "false";
                        Element polygondash = component.getChild("dash");
                        spolygondash = polygondash.getText();
                        String nameDirect = polygonName.getAttributeValue("direction");
                        String nameSize4 = polygonName.getAttributeValue("size");
                        String colorStr8 = polygonName.getAttributeValue("color");
                        String colortextStr = polygonName.getAttributeValue("colortext");
                        String colorlineStr = polygonName.getAttributeValue("colorline");
                        StringTokenizer st = new StringTokenizer(colorStr8, ",");
                        Color color = new Color(Integer.parseInt(st.nextToken()), Integer.parseInt(st.nextToken()), Integer.parseInt(st.nextToken()));
                        StringTokenizer sttext = new StringTokenizer(colortextStr, ",");
                        Color colortext = new Color(Integer.parseInt(sttext.nextToken()), Integer.parseInt(sttext.nextToken()), Integer.parseInt(sttext.nextToken()));
                        StringTokenizer stline6 = new StringTokenizer(colorlineStr, ",");
                        Color colorline = new Color(Integer.parseInt(stline6.nextToken()), Integer.parseInt(stline6.nextToken()), Integer.parseInt(stline6.nextToken()));
                        Element polygonstrokesize = component.getChild("strokesize");
                        String strokesize = polygonstrokesize.getText();
                        Element polygongradient = component.getChild("gradient");
                        String gradient = polygongradient.getText();
                        Element polygontexture = component.getChild("texture");
                        String texture = polygontexture.getText();
                        Element polygonCenterx = component.getChild("centerx");
                        String sCenterx = polygonCenterx.getText();
                        Element polygonCentery = component.getChild("centery");
                        String sCentery = polygonCentery.getText();
                        Element polygonWide = component.getChild("wide");
                        String sWide = polygonWide.getText();
                        Element polygonHigh = component.getChild("high");
                        String sHigh = polygonHigh.getText();
                        Element polygonRotationAngle = component.getChild("rotationAngle");
                        String sRotationAngle = polygonRotationAngle.getText();
                        int iCenterx = Integer.valueOf(sCenterx);
                        int iCentery = Integer.valueOf(sCentery);
                        int iWide = Integer.valueOf(sWide);
                        int iHigh = Integer.valueOf(sHigh);
                        int iRotationAngle = Integer.valueOf(sRotationAngle);
                        String parameter = name + "#&%" + nameDirect + "#&%" + nameSize4 + "#&%" + strokesize + "#&%" + gradient + "#&%" + texture + "#&%" + sproteindash;
                        Element polygonshapetype = component.getChild("shapetype");
                        String strshapetype = polygonshapetype.getText();
                        ShapeEnum shapetype = ShapeEnum.valueOf(strshapetype);
                        String fid = "";
                        List el8 = component.getChildren();
                        if (el8.toString().contains("[Element: <id/>]")) {
                            Element sitedash = component.getChild("id");
                            fid = sitedash.getText();
                        } else {
                            fid = "";
                        }
                        componentList.add(new Component(ComponentEnum.Polygon, iCenterx, iCentery, iWide, iHigh, iRotationAngle, parameter, color, colortext, colorline, shapetype, Boolean.valueOf(spolygondash), fid));
                    }
                    proteinList.add(new Protein(vertical, horizontal, isLocked, Integer.parseInt(proteinEnd), proteinParameter, proteinColor, componentList));
                }
                int psize = proteinList.size();
                if (psize > 0) {
                    for (int i = 0; i < psize; ++i) {
                        boolean bmodifypr = false;
                        Protein pr = proteinList.get(i);
                        String[] arrPro = pr.getParameter().split("#&%");
                        String fid = "";
                        fid = arrPro[11] == null ? "" : arrPro[11].trim();
                        if (fid.equals("")) {
                            String fp = "";
                            fp = mode.equals("P") ? "Protein" : "Nucleotide";
                            fid = this.getDefaultID(fp, proteinList, null);
                            String strPar = "";
                            for (int k = 0; k < arrPro.length - 1; ++k) {
                                strPar = strPar + arrPro[k] + "#&%";
                            }
                            strPar = strPar + fid;
                            pr.setParameter(strPar);
                            bmodifypr = true;
                        }
                        LinkedList<Component> comList = pr.getComponentList();
                        for (int r = 0; r < comList.size(); ++r) {
                            boolean bmodifycom = false;
                            Component component = comList.get(r);
                            String fcomid = "";
                            fcomid = component.fid == null ? "" : component.fid.trim();
                            if (!fcomid.equals("")) continue;
                            String strNum = "";
                            if (component.getType() == ComponentEnum.Domain) {
                                strNum = this.getDefaultID(ComponentEnum.Domain.name(), proteinList, pr);
                            } else if (component.getType() == ComponentEnum.CutLine) {
                                strNum = this.getDefaultID(ComponentEnum.CutLine.name(), proteinList, pr);
                            } else if (component.getType() == ComponentEnum.Site) {
                                strNum = this.getDefaultID(ComponentEnum.Site.name(), proteinList, pr);
                            } else if (component.getType() == ComponentEnum.Note) {
                                strNum = this.getDefaultID(ComponentEnum.Note.name(), proteinList, pr);
                            } else if (component.getType() == ComponentEnum.Line) {
                                strNum = this.getDefaultID(ComponentEnum.Line.name(), proteinList, pr);
                            } else if (component.getType() == ComponentEnum.Polygon) {
                                strNum = this.getDefaultID(ComponentEnum.Polygon.name(), proteinList, pr);
                            } else if (component.getType() == ComponentEnum.Bracket) {
                                strNum = this.getDefaultID(ComponentEnum.Bracket.name(), proteinList, pr);
                            }
                            bmodifycom = true;
                            if (!bmodifycom) continue;
                            component.fid = strNum;
                            comList.set(r, component);
                            pr.setComponentList(comList);
                            proteinList.set(i, pr);
                            bmodifypr = true;
                        }
                        if (!bmodifypr) continue;
                        proteinList.set(i, pr);
                    }
                }
                proteinList = this.adjustProteinHorizontal(proteinList);
            } else {
                JOptionPane.showMessageDialog(null, this.filePath + " not a " + "IBS 1.0" + " project or has been corrupted.", "Error : cannot open file", 0, null);
            }
            if (strFontErro.length() > 0) {
                JOptionPane.showMessageDialog(null, strFontErro);
            }
            return new Project(width, height, rate, proteinList, mode);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getDefaultID(String strType, LinkedList<Protein> proteinList, Protein currentProtein) {
        String strMaxId = "";
        if (strType.equals("Protein") || strType.equals("Nucleotide")) {
            int iMaxNum = 0;
            for (Protein protein : proteinList) {
                int iNum;
                String strNum;
                String[] arrPro = protein.getParameter().split("#&%");
                String shortstrType = this.getShortType(strType);
                String strId = arrPro[11].trim();
                if (strId.equals("") || strId == null || strId.indexOf(shortstrType) != 0 || !Tools.isNumber(strNum = strId.substring(1)) || iMaxNum >= (iNum = Integer.valueOf(strNum).intValue())) continue;
                iMaxNum = iNum;
            }
            String shortstrType = this.getShortType(strType);
            strMaxId = shortstrType + ++iMaxNum;
            return strMaxId;
        }
        int iMaxNum = 0;
        Protein pr = currentProtein;
        if (pr == null) {
            return "";
        }
        LinkedList<Component> componentList = pr.getComponentList();
        for (Component component : componentList) {
            int iNum;
            String strNum;
            String strId;
            if (!component.getType().name().equals(strType)) continue;
            String shortstrType = this.getShortType(strType);
            if (component.fid == null || (strId = component.fid.trim()).equals("") || strId == null || strId.indexOf(shortstrType) != 0 || !Tools.isNumber(strNum = strId.substring(1)) || iMaxNum >= (iNum = Integer.valueOf(strNum).intValue())) continue;
            iMaxNum = iNum;
        }
        String shortstrType = this.getShortType(strType);
        strMaxId = shortstrType + ++iMaxNum;
        return strMaxId;
    }

    public String getShortType(String strType) {
        if (strType.trim().equals("Protein")) {
            strType = "P";
        } else if (strType.trim().equals("Nucleotide")) {
            strType = "N";
        } else if (strType.trim().equals("Polygon")) {
            strType = "M";
        } else if (strType.trim().equals("Domain")) {
            strType = "D";
        } else if (strType.trim().equals("Site")) {
            strType = "S";
        } else if (strType.trim().equals("Line")) {
            strType = "L";
        } else if (strType.trim().equals("Bracket")) {
            strType = "B";
        } else if (strType.trim().equals("CutLine")) {
            strType = "C";
        } else if (strType.trim().equals("Note")) {
            strType = "T";
        }
        return strType;
    }
}

