/*
 * Decompiled with CFR 0.152.
 */
package gui.ibs;

import gui.Tools;
import gui.ibs.Area;
import gui.ibs.Component;
import gui.ibs.ComponentEnum;
import gui.ibs.DomainDashConf;
import gui.ibs.DrawTypeEnum;
import gui.ibs.GradientEnum;
import gui.ibs.PolygonXY;
import gui.ibs.Protein;
import gui.ibs.ShapeEnum;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.StringTokenizer;
import org.jdom.Document;
import org.jdom.Element;

public class SVGService {
    public boolean bGray = false;
    public int svgID = 0;
    public double rate = 0.0;
    public double canvasWide = 0.0;
    public double canvasHigh = 0.0;
    public double HALF_LENGTH = 300.0;
    public double LENGTH_RATE = 1.0;
    public double HALF_HEIGHT;
    public int LINE_HEIGHT = 10;
    public int positionFontSize = 12;
    public FontMetrics positionFontMetrics;
    public LinkedList<Protein> proteinList = new LinkedList();
    public boolean isLengthRate = true;
    public static final String DELIMIT = "#&%";
    public String SVGFilePath = "";
    public String SVGFilePathFull = "";
    public int lineInterval = 5;

    public String getSVGFilePathFull() {
        return this.SVGFilePathFull;
    }

    public void setSVGFilePathFull(String SVGFilePathFull) {
        this.SVGFilePathFull = SVGFilePathFull;
    }

    public String getSVGFilePath() {
        return this.SVGFilePath;
    }

    public void setSVGFilePath(String SVGFilePath) {
        this.SVGFilePath = SVGFilePath;
    }

    public boolean isbGray() {
        return this.bGray;
    }

    public void setbGray(boolean bGray) {
        this.bGray = bGray;
    }

    public boolean isIsLengthRate() {
        return this.isLengthRate;
    }

    public void setIsLengthRate(boolean isLengthRate) {
        this.isLengthRate = isLengthRate;
    }

    public LinkedList<Protein> getproteinList() {
        return this.proteinList;
    }

    public void setproteinList(LinkedList<Protein> proteinList) {
        this.proteinList = proteinList;
    }

    public FontMetrics getPositionFontMetrics() {
        return this.positionFontMetrics;
    }

    public void setPositionFontMetrics(FontMetrics positionFontMetrics) {
        this.positionFontMetrics = positionFontMetrics;
    }

    public int getPositionFontSize() {
        return this.positionFontSize;
    }

    public void setPositionFontSize(int positionFontSize) {
        this.positionFontSize = positionFontSize;
    }

    public int getLINE_HEIGHT() {
        return this.LINE_HEIGHT;
    }

    public void setLINE_HEIGHT(int LINE_HEIGHT) {
        this.LINE_HEIGHT = LINE_HEIGHT;
    }

    public double getHALF_HEIGHT() {
        return this.HALF_HEIGHT;
    }

    public void setHALF_HEIGHT(double HALF_HEIGHT) {
        this.HALF_HEIGHT = HALF_HEIGHT;
    }

    public double getHALF_LENGTH() {
        return this.HALF_LENGTH;
    }

    public void setHALF_LENGTH(double HALF_LENGTH) {
        this.HALF_LENGTH = HALF_LENGTH;
    }

    public double getLENGTH_RATE() {
        return this.LENGTH_RATE;
    }

    public void setLENGTH_RATE(double LENGTH_RATE) {
        this.LENGTH_RATE = LENGTH_RATE;
    }

    public double getCanvasHigh() {
        return this.canvasHigh;
    }

    public void setCanvasHigh(double canvasHigh) {
        this.canvasHigh = canvasHigh;
    }

    public double getCanvasWide() {
        return this.canvasWide;
    }

    public void setCanvasWide(double canvasWide) {
        this.canvasWide = canvasWide;
    }

    public double getRate() {
        return this.rate;
    }

    public void setRate(double rate) {
        this.rate = rate;
    }

    public int getSvgID() {
        return this.svgID;
    }

    public void setSvgID(int svgID) {
        this.svgID = svgID;
    }

    public void drawSVGRecPolygon(double x, double y, Color color, double width, double height, Element svgElement) {
        ++this.svgID;
        Element linearGradientElement = new Element("linearGradient");
        linearGradientElement.setAttribute("id", "SVGID_" + this.svgID + "_");
        linearGradientElement.setAttribute("x1", "0%");
        linearGradientElement.setAttribute("y1", "0%");
        linearGradientElement.setAttribute("x2", "0%");
        linearGradientElement.setAttribute("y2", "100%");
        Element stop1 = new Element("stop"){};
        stop1.setAttribute("offset", "0%");
        stop1.setAttribute("style", "stop-color:" + Tools.ColorToHex(color));
        linearGradientElement.addContent(stop1);
        Element stop2 = new Element("stop");
        stop2.setAttribute("offset", "50%");
        stop2.setAttribute("style", "stop-color:#FFFFFF");
        linearGradientElement.addContent(stop2);
        Element stop3 = new Element("stop");
        stop3.setAttribute("offset", "100%");
        stop3.setAttribute("style", "stop-color:" + Tools.ColorToHex(color));
        linearGradientElement.addContent(stop3);
        svgElement.addContent(linearGradientElement);
        Element recElement = new Element("rect");
        recElement.setAttribute("x", String.valueOf((double)((float)x) + this.canvasWide / 2.0));
        recElement.setAttribute("y", String.valueOf((double)((float)y) + this.canvasHigh / 2.0));
        recElement.setAttribute("fill", "url(#SVGID_" + this.svgID + "_)");
        recElement.setAttribute("stroke", "#000000");
        recElement.setAttribute("stroke-width", this.rate < 1.0 ? "1" : String.valueOf((int)this.rate));
        recElement.setAttribute("width", String.valueOf((float)width));
        recElement.setAttribute("height", String.valueOf((float)height));
        svgElement.addContent(recElement);
        ++this.svgID;
    }

    public void drawSVGTextureLine(double x1, double y1, double x2, double y2, int weight, Color color, String clipPathid, String stroke_dasharray, Element svgElement) {
        Element LineElement = new Element("line");
        LineElement.setAttribute("x1", String.valueOf((double)((float)x1) + this.canvasWide / 2.0));
        LineElement.setAttribute("y1", String.valueOf((double)((float)y1) + this.canvasHigh / 2.0));
        LineElement.setAttribute("x2", String.valueOf((double)((float)x2) + this.canvasWide / 2.0));
        LineElement.setAttribute("y2", String.valueOf((double)((float)y2) + this.canvasHigh / 2.0));
        LineElement.setAttribute("fill", "none");
        LineElement.setAttribute("stroke", Tools.ColorToHex(color));
        LineElement.setAttribute("stroke-width", (double)weight * this.rate < 1.0 ? "1" : String.valueOf((int)((double)weight * this.rate + 1.0)));
        LineElement.setAttribute("clip-path", "url(#" + clipPathid + ")");
        LineElement.setAttribute("clip-rule", "evenodd");
        if (!stroke_dasharray.equals("")) {
            LineElement.setAttribute("stroke-dasharray", stroke_dasharray);
        }
        svgElement.addContent(LineElement);
    }

    private void drawSVGScale(double x1, double y1, double x2, double y2, int weight, Color color, Element svgElement) {
        double distance = Math.abs(Point2D.distance(x1, y1, x2, y2));
        int arrowLen = 10;
        double xa = x1 - (double)arrowLen * (y2 - y1) / distance;
        double ya = y1 + (double)arrowLen * (x2 - x1) / distance;
        double xb = x1 + (double)arrowLen * (y2 - y1) / distance;
        double yb = y1 - (double)arrowLen * (x2 - x1) / distance;
        this.drawSVGLine(xa, ya, xb, yb, weight, color, false, svgElement);
    }

    public void drawSVGLine(double x1, double y1, double x2, double y2, boolean bdash, Element svgElement) {
        Element lineElement = new Element("line");
        lineElement.setAttribute("fill", "#000000");
        lineElement.setAttribute("stroke", "#000000");
        if (bdash) {
            lineElement.setAttribute("stroke-dasharray", "3");
        }
        lineElement.setAttribute("stroke-width", this.rate < 1.0 ? "1" : String.valueOf((int)this.rate));
        lineElement.setAttribute("x1", String.valueOf((double)((float)x1) + this.canvasWide / 2.0));
        lineElement.setAttribute("y1", String.valueOf((double)((float)y1) + this.canvasHigh / 2.0));
        lineElement.setAttribute("x2", String.valueOf((double)((float)x2) + this.canvasWide / 2.0));
        lineElement.setAttribute("y2", String.valueOf((double)((float)y2) + this.canvasHigh / 2.0));
        svgElement.addContent(lineElement);
    }

    private void drawSVGLine(double x1, double y1, double x2, double y2, int weight, Color color, boolean bdash, Element svgElement) {
        Element lineElement = new Element("line");
        lineElement.setAttribute("fill", Tools.ColorToHex(color));
        lineElement.setAttribute("stroke", Tools.ColorToHex(color));
        if (bdash) {
            lineElement.setAttribute("stroke-dasharray", "3");
        }
        lineElement.setAttribute("stroke-width", (double)weight * this.rate < 1.0 ? "1" : String.valueOf((int)((double)weight * this.rate + 1.0)));
        lineElement.setAttribute("x1", String.valueOf((double)((float)x1) + this.canvasWide / 2.0));
        lineElement.setAttribute("y1", String.valueOf((double)((float)y1) + this.canvasHigh / 2.0));
        lineElement.setAttribute("x2", String.valueOf((double)((float)x2) + this.canvasWide / 2.0));
        lineElement.setAttribute("y2", String.valueOf((double)((float)y2) + this.canvasHigh / 2.0));
        svgElement.addContent(lineElement);
    }

    public void drawSVGLines(double x1, double y1, double x2, double y2, int weight, Color color, String lineType, String fname, String nameDrawType, int size, Color colortext, boolean bdash, Element svgElement, Graphics2D g2d) {
        double startX = x1;
        double startY = y1;
        double endX = x2;
        double endY = y2;
        if (fname.equals("") || fname.equals(null) || fname.equals(" ")) {
            this.drawSVGLine(x1, y1, x2, y2, weight, color, bdash, svgElement);
        } else {
            g2d.setFont(new Font("Arial", 1, (int)((double)size * this.rate)));
            double centerX = 0.0;
            double centerY = 0.0;
            centerX = startX + (endX - startX) / 2.0;
            centerY = startY + (endY - startY) / 2.0;
            double interx1 = 0.0;
            double intery1 = 0.0;
            double interx2 = 0.0;
            double intery2 = 0.0;
            double textwide = 0.0;
            double texthigh = 0.0;
            FontMetrics noteFontMetrics = g2d.getFontMetrics();
            textwide = noteFontMetrics.stringWidth(fname);
            texthigh = noteFontMetrics.getHeight();
            double angle = 0.0;
            double dx = 0.0;
            double dy = 0.0;
            dx = Math.abs(endX - startX);
            dy = Math.abs(endY - startY);
            if (startX > endX && startY < endY) {
                angle = Math.atan(dy / dx);
                interx1 = centerX + Math.abs(textwide * 6.0 / 4.0 / 2.0 * Math.cos(angle));
                intery1 = centerY - Math.abs(textwide * 6.0 / 4.0 / 2.0 * Math.sin(angle));
                interx2 = centerX - Math.abs(textwide * 6.0 / 4.0 / 2.0 * Math.cos(angle));
                intery2 = centerY + Math.abs(textwide * 6.0 / 4.0 / 2.0 * Math.sin(angle));
            } else if (startX < endX && startY < endY) {
                angle = Math.atan(dx / dy);
                interx1 = centerX - Math.abs(textwide * 6.0 / 4.0 / 2.0 * Math.sin(angle));
                intery1 = centerY - Math.abs(textwide * 6.0 / 4.0 / 2.0 * Math.cos(angle));
                interx2 = centerX + Math.abs(textwide * 6.0 / 4.0 / 2.0 * Math.sin(angle));
                intery2 = centerY + Math.abs(textwide * 6.0 / 4.0 / 2.0 * Math.cos(angle));
                angle = 1.5707963267948966 + angle;
            } else if (startX < endX && startY > endY) {
                angle = Math.atan(dy / dx);
                interx1 = centerX - Math.abs(textwide * 6.0 / 4.0 / 2.0 * Math.cos(angle));
                intery1 = centerY + Math.abs(textwide * 6.0 / 4.0 / 2.0 * Math.sin(angle));
                interx2 = centerX + Math.abs(textwide * 6.0 / 4.0 / 2.0 * Math.cos(angle));
                intery2 = centerY - Math.abs(textwide * 6.0 / 4.0 / 2.0 * Math.sin(angle));
                angle = Math.PI + angle;
            } else if (startX > endX && startY > endY) {
                angle = Math.atan(dx / dy);
                interx1 = centerX + Math.abs(textwide * 6.0 / 4.0 / 2.0 * Math.sin(angle));
                intery1 = centerY + Math.abs(textwide * 6.0 / 4.0 / 2.0 * Math.cos(angle));
                interx2 = centerX - Math.abs(textwide * 6.0 / 4.0 / 2.0 * Math.sin(angle));
                intery2 = centerY - Math.abs(textwide * 6.0 / 4.0 / 2.0 * Math.cos(angle));
                angle = 4.71238898038469 + angle;
            } else if (startX >= endX && startY == endY) {
                angle = 0.0;
                interx1 = centerX + textwide * 6.0 / 4.0 / 2.0;
                intery1 = centerY;
                interx2 = centerX - textwide * 6.0 / 4.0 / 2.0;
                intery2 = centerY;
            } else if (startX == endX && startY <= endY) {
                angle = 1.5707963267948966;
                interx1 = centerX;
                intery1 = centerY - textwide * 6.0 / 4.0 / 2.0;
                interx2 = centerX;
                intery2 = centerY + textwide * 6.0 / 4.0 / 2.0;
            } else if (startX <= endX && startY == endY) {
                angle = Math.PI;
                interx1 = centerX - textwide * 6.0 / 4.0 / 2.0;
                intery1 = centerY;
                interx2 = centerX + textwide * 6.0 / 4.0 / 2.0;
                intery2 = centerY;
            } else if (startX == endX && startY >= endY) {
                angle = 4.71238898038469;
                interx1 = centerX;
                intery1 = centerY + textwide * 6.0 / 4.0 / 2.0;
                interx2 = centerX;
                intery2 = centerY - textwide * 6.0 / 4.0 / 2.0;
            }
            if (angle > 0.0) {
                angle = Math.PI * 2 - angle;
            }
            angle += Math.PI;
            angle = 360.0 * angle / (Math.PI * 2);
            if (nameDrawType.equals("Center")) {
                Element startTextElement = new Element("text");
                startTextElement.setAttribute("id", "SVGID_" + this.svgID + "_");
                ++this.svgID;
                startTextElement.setAttribute("transform", "translate(" + (centerX + this.canvasWide / 2.0) + "," + (centerY + this.canvasHigh / 2.0) + ") " + "rotate(" + angle + ") " + "translate(-" + (centerX + this.canvasWide / 2.0) + ",-" + (centerY + this.canvasHigh / 2.0) + ") ");
                startTextElement.setAttribute("x", String.valueOf((int)(centerX - textwide / 2.0 + this.canvasWide / 2.0)));
                startTextElement.setAttribute("y", String.valueOf((int)(centerY + texthigh / 4.0 + this.canvasHigh / 2.0)));
                startTextElement.setAttribute("fill", Tools.ColorToHex(colortext));
                startTextElement.setAttribute("font-family", "'Arial-BoldMT'");
                startTextElement.setAttribute("font-size", String.valueOf(size));
                startTextElement.setText(fname);
                svgElement.addContent(startTextElement);
                this.drawSVGLine(startX, startY, interx1, intery1, weight, color, bdash, svgElement);
                this.drawSVGLine(interx2, intery2, endX, endY, weight, color, bdash, svgElement);
            } else if (nameDrawType.equals("Down")) {
                Element startTextElement = new Element("text");
                startTextElement.setAttribute("id", "SVGID_" + this.svgID + "_");
                ++this.svgID;
                startTextElement.setAttribute("transform", "translate(" + (centerX + this.canvasWide / 2.0) + "," + (centerY + this.canvasHigh / 2.0) + ") " + "rotate(" + angle + ") " + "translate(-" + (centerX + this.canvasWide / 2.0) + ",-" + (centerY + this.canvasHigh / 2.0) + ") ");
                startTextElement.setAttribute("x", String.valueOf((int)(centerX - textwide / 2.0 + this.canvasWide / 2.0)));
                startTextElement.setAttribute("y", String.valueOf((int)(centerY + texthigh + this.canvasHigh / 2.0)));
                startTextElement.setAttribute("fill", Tools.ColorToHex(colortext));
                startTextElement.setAttribute("font-family", "'Arial-BoldMT'");
                startTextElement.setAttribute("font-size", String.valueOf(size));
                startTextElement.setText(fname);
                svgElement.addContent(startTextElement);
                this.drawSVGLine(startX, startY, endX, endY, weight, color, bdash, svgElement);
            } else if (nameDrawType.equals("Up")) {
                Element startTextElement = new Element("text");
                startTextElement.setAttribute("id", "SVGID_" + this.svgID + "_");
                ++this.svgID;
                startTextElement.setAttribute("transform", "translate(" + (centerX + this.canvasWide / 2.0) + "," + (centerY + this.canvasHigh / 2.0) + ") " + "rotate(" + angle + ") " + "translate(-" + (centerX + this.canvasWide / 2.0) + ",-" + (centerY + this.canvasHigh / 2.0) + ") ");
                startTextElement.setAttribute("x", String.valueOf((int)(centerX - textwide / 2.0 + this.canvasWide / 2.0)));
                startTextElement.setAttribute("y", String.valueOf((int)(centerY - texthigh / 2.0 + this.canvasHigh / 2.0)));
                startTextElement.setAttribute("fill", Tools.ColorToHex(colortext));
                startTextElement.setAttribute("font-family", "'Arial-BoldMT'");
                startTextElement.setAttribute("font-size", String.valueOf(size));
                startTextElement.setText(fname);
                svgElement.addContent(startTextElement);
                this.drawSVGLine(startX, startY, endX, endY, weight, color, bdash, svgElement);
            } else if (nameDrawType.equals("Hide")) {
                this.drawSVGLine(startX, startY, endX, endY, weight, color, bdash, svgElement);
            }
        }
        if (lineType.equals("Arrow")) {
            this.drawSVGArrow((int)x1, (int)y1, (int)x2, (int)y2, weight, color, svgElement);
        } else if (lineType.equals("DoubleArrow")) {
            this.drawSVGArrow((int)x1, (int)y1, (int)x2, (int)y2, weight, color, svgElement);
            this.drawSVGArrow((int)x2, (int)y2, (int)x1, (int)y1, weight, color, svgElement);
        } else if (lineType.equals("Scale")) {
            this.drawSVGScale(x1, y1, x2, y2, weight, color, svgElement);
            this.drawSVGScale(x2, y2, x1, y1, weight, color, svgElement);
        } else if (lineType.equals("ScaleArrow")) {
            this.drawSVGScale(x1, y1, x2, y2, weight, color, svgElement);
            this.drawSVGScale(x2, y2, x1, y1, weight, color, svgElement);
            this.drawSVGArrow((int)x1, (int)y1, (int)x2, (int)y2, weight, color, svgElement);
            this.drawSVGArrow((int)x2, (int)y2, (int)x1, (int)y1, weight, color, svgElement);
        }
    }

    public void drawSVGPolyLineOne(double x1, double y1, double cx2, double cy2, double x2, double y2, int weight, Color color, String lineType, boolean bdash, Element svgElement) {
        if (lineType.equals("Arrow")) {
            this.drawSVGArrow((int)x1, (int)y1, (int)cx2, (int)cy2, weight, color, svgElement);
        } else if (lineType.equals("DoubleArrow")) {
            this.drawSVGArrow((int)x1, (int)y1, (int)cx2, (int)cy2, weight, color, svgElement);
            this.drawSVGArrow((int)x2, (int)y2, (int)cx2, (int)cy2, weight, color, svgElement);
        } else if (lineType.equals("Scale")) {
            this.drawSVGScale(x1, y1, cx2, cy2, weight, color, svgElement);
            this.drawSVGScale(x2, y2, cx2, cy2, weight, color, svgElement);
        }
        Element PolyLineOneElement = new Element("path");
        String d = "M " + ((double)((float)x1) + this.canvasWide / 2.0) + " " + ((double)((float)y1) + this.canvasHigh / 2.0) + " L " + ((double)((float)cx2) + this.canvasWide / 2.0) + " " + ((double)((float)cy2) + this.canvasHigh / 2.0) + " L " + ((double)((float)x2) + this.canvasWide / 2.0) + " " + ((double)((float)y2) + this.canvasHigh / 2.0);
        PolyLineOneElement.setAttribute("d", d);
        PolyLineOneElement.setAttribute("fill", "none");
        if (bdash) {
            PolyLineOneElement.setAttribute("stroke-dasharray", "3");
        }
        PolyLineOneElement.setAttribute("stroke", Tools.ColorToHex(color));
        PolyLineOneElement.setAttribute("stroke-width", (double)weight * this.rate < 1.0 ? "1" : String.valueOf((int)((double)weight * this.rate + 1.0)));
        svgElement.addContent(PolyLineOneElement);
    }

    public void drawSVGPolyCurveOne(double x1, double y1, double cx2, double cy2, double x2, double y2, int weight, Color color, String lineType, boolean bdash, Element svgElement) {
        if (lineType.equals("Arrow")) {
            this.drawSVGArrow((int)x1, (int)y1, (int)cx2, (int)cy2, weight, color, svgElement);
        } else if (lineType.equals("DoubleArrow")) {
            this.drawSVGArrow((int)x1, (int)y1, (int)cx2, (int)cy2, weight, color, svgElement);
            this.drawSVGArrow((int)x2, (int)y2, (int)cx2, (int)cy2, weight, color, svgElement);
        } else if (lineType.equals("Scale")) {
            this.drawSVGScale(x1, y1, cx2, cy2, weight, color, svgElement);
            this.drawSVGScale(x2, y2, cx2, cy2, weight, color, svgElement);
        } else if (lineType.equals("ScaleArrow")) {
            this.drawSVGScale(x1, y1, cx2, cy2, weight, color, svgElement);
            this.drawSVGScale(x2, y2, cx2, cy2, weight, color, svgElement);
            this.drawSVGArrow((int)x1, (int)y1, (int)cx2, (int)cy2, weight, color, svgElement);
            this.drawSVGArrow((int)x2, (int)y2, (int)cx2, (int)cy2, weight, color, svgElement);
        }
        Element PolyCurveOneElement = new Element("path");
        String d = "M " + ((double)((float)x1) + this.canvasWide / 2.0) + " " + ((double)((float)y1) + this.canvasHigh / 2.0) + " S " + ((double)((float)cx2) + this.canvasWide / 2.0) + " " + ((double)((float)cy2) + this.canvasHigh / 2.0) + " " + ((double)((float)x2) + this.canvasWide / 2.0) + " " + ((double)((float)y2) + this.canvasHigh / 2.0);
        PolyCurveOneElement.setAttribute("d", d);
        PolyCurveOneElement.setAttribute("fill", "none");
        if (bdash) {
            PolyCurveOneElement.setAttribute("stroke-dasharray", "3");
        }
        PolyCurveOneElement.setAttribute("stroke", Tools.ColorToHex(color));
        PolyCurveOneElement.setAttribute("stroke-width", (double)weight * this.rate < 1.0 ? "1" : String.valueOf((int)((double)weight * this.rate + 1.0)));
        svgElement.addContent(PolyCurveOneElement);
    }

    public void drawSVGPolyLineTwo(double x1, double y1, double cx1, double cy1, double cx2, double cy2, double x2, double y2, int weight, Color color, String lineType, boolean bdash, Element svgElement) {
        if (lineType.equals("Arrow")) {
            this.drawSVGArrow((int)x1, (int)y1, (int)cx1, (int)cy1, weight, color, svgElement);
        } else if (lineType.equals("DoubleArrow")) {
            this.drawSVGArrow((int)x1, (int)y1, (int)cx1, (int)cy1, weight, color, svgElement);
            this.drawSVGArrow((int)x2, (int)y2, (int)cx2, (int)cy2, weight, color, svgElement);
        } else if (lineType.equals("Scale")) {
            this.drawSVGScale(x1, y1, cx1, cy1, weight, color, svgElement);
            this.drawSVGScale(x2, y2, cx2, cy2, weight, color, svgElement);
        }
        Element PolyLineTwoElement = new Element("path");
        String d = "M " + ((double)((float)x1) + this.canvasWide / 2.0) + " " + ((double)((float)y1) + this.canvasHigh / 2.0) + " L " + ((double)((float)cx1) + this.canvasWide / 2.0) + " " + ((double)((float)cy1) + this.canvasHigh / 2.0) + " L " + ((double)((float)cx2) + this.canvasWide / 2.0) + " " + ((double)((float)cy2) + this.canvasHigh / 2.0) + " L " + ((double)((float)x2) + this.canvasWide / 2.0) + " " + ((double)((float)y2) + this.canvasHigh / 2.0);
        PolyLineTwoElement.setAttribute("d", d);
        PolyLineTwoElement.setAttribute("fill", "none");
        if (bdash) {
            PolyLineTwoElement.setAttribute("stroke-dasharray", "3");
        }
        PolyLineTwoElement.setAttribute("stroke", Tools.ColorToHex(color));
        PolyLineTwoElement.setAttribute("stroke-width", (double)weight * this.rate < 1.0 ? "1" : String.valueOf((int)((double)weight * this.rate + 1.0)));
        svgElement.addContent(PolyLineTwoElement);
    }

    public void drawSVGPolyCurveTwo(double x1, double y1, double cx1, double cy1, double cx2, double cy2, double x2, double y2, int weight, Color color, String lineType, boolean bdash, Element svgElement) {
        if (lineType.equals("Arrow")) {
            this.drawSVGArrow((int)x1, (int)y1, (int)cx1, (int)cy1, weight, color, svgElement);
        } else if (lineType.equals("DoubleArrow")) {
            this.drawSVGArrow((int)x1, (int)y1, (int)cx1, (int)cy1, weight, color, svgElement);
            this.drawSVGArrow((int)x2, (int)y2, (int)cx2, (int)cy2, weight, color, svgElement);
        } else if (lineType.equals("Scale")) {
            this.drawSVGScale(x1, y1, cx1, cy1, weight, color, svgElement);
            this.drawSVGScale(x2, y2, cx2, cy2, weight, color, svgElement);
        }
        Element PolyCurveTwoElement = new Element("path");
        String d = "M " + ((double)((float)x1) + this.canvasWide / 2.0) + " " + ((double)((float)y1) + this.canvasHigh / 2.0) + " C " + ((double)((float)cx1) + this.canvasWide / 2.0) + " " + ((double)((float)cy1) + this.canvasHigh / 2.0) + " " + ((double)((float)cx2) + this.canvasWide / 2.0) + " " + ((double)((float)cy2) + this.canvasHigh / 2.0) + " " + ((double)((float)x2) + this.canvasWide / 2.0) + " " + ((double)((float)y2) + this.canvasHigh / 2.0);
        PolyCurveTwoElement.setAttribute("d", d);
        PolyCurveTwoElement.setAttribute("fill", "none");
        if (bdash) {
            PolyCurveTwoElement.setAttribute("stroke-dasharray", "3");
        }
        PolyCurveTwoElement.setAttribute("stroke", Tools.ColorToHex(color));
        PolyCurveTwoElement.setAttribute("stroke-width", (double)weight * this.rate < 1.0 ? "1" : String.valueOf((int)((double)weight * this.rate + 1.0)));
        svgElement.addContent(PolyCurveTwoElement);
    }

    public void drawSVGArrow(double x1, double y1, int x2, int y2, int weight, Color color, Element svgElement) {
        double distance = Math.abs(Point2D.distance(x1, y1, x2, y2));
        double x0 = 0.0;
        double y0 = 0.0;
        double xa = 0.0;
        double ya = 0.0;
        double xb = 0.0;
        double yb = 0.0;
        double dw = 10.0 * this.rate;
        double dh = (double)(4 + weight) * this.rate;
        double dx = Math.abs(x1 - (double)x2);
        double dy = Math.abs(y1 - (double)y2);
        x0 = (double)x2 + (distance += 0.5 * this.rate);
        y0 = y2;
        xa = (double)x2 + distance - dw;
        ya = y2;
        xb = (double)x2 + distance - dw;
        yb = y2;
        double anglepoint = 0.0;
        anglepoint = Math.atan(dh / (distance - dw));
        double anglerotation = 0.0;
        if (y1 >= (double)y2 && x1 >= (double)x2) {
            anglerotation = Math.atan(dy / dx);
        } else if (y1 >= (double)y2 && x1 <= (double)x2) {
            anglerotation = 1.5707963267948966 + Math.atan(dx / dy);
        } else if (y1 <= (double)y2 && x1 <= (double)x2) {
            anglerotation = Math.PI + Math.atan(dy / dx);
        } else if (y1 <= (double)y2 && x1 >= (double)x2) {
            anglerotation = 4.71238898038469 + Math.atan(dx / dy);
        }
        double anglefull1 = -anglerotation;
        double anglefulla = -anglerotation + anglepoint;
        double anglefullb = -anglerotation - anglepoint;
        double arcx = 0.0;
        double arcy = 0.0;
        arcx = (x0 - (double)x2) * Math.cos(anglefull1) - (y0 - (double)y2) * Math.sin(anglefull1) + (double)x2;
        arcy = -1.0 * (x0 - (double)x2) * Math.sin(anglefull1) + (y0 - (double)y2) * Math.cos(anglefull1) + (double)y2;
        x0 = (int)Math.round(arcx);
        y0 = (int)Math.round(arcy);
        arcx = (xa - (double)x2) * Math.cos(anglefulla) - (ya - (double)y2) * Math.sin(anglefulla) + (double)x2;
        arcy = -1.0 * (xa - (double)x2) * Math.sin(anglefulla) + (ya - (double)y2) * Math.cos(anglefulla) + (double)y2;
        xa = (int)Math.round(arcx);
        ya = (int)Math.round(arcy);
        arcx = (xb - (double)x2) * Math.cos(anglefullb) - (yb - (double)y2) * Math.sin(anglefullb) + (double)x2;
        arcy = -1.0 * (xb - (double)x2) * Math.sin(anglefullb) + (yb - (double)y2) * Math.cos(anglefullb) + (double)y2;
        xb = (int)Math.round(arcx);
        yb = (int)Math.round(arcy);
        int[] px = new int[3];
        int[] py = new int[3];
        px[0] = (int)x0;
        px[1] = (int)xa;
        px[2] = (int)xb;
        py[0] = (int)y0;
        py[1] = (int)ya;
        py[2] = (int)yb;
        Element ArrowElement = new Element("polygon");
        String points = (double)px[0] + this.canvasWide / 2.0 + "," + ((double)py[0] + this.canvasHigh / 2.0) + " " + ((double)px[1] + this.canvasWide / 2.0) + "," + ((double)py[1] + this.canvasHigh / 2.0) + " " + ((double)px[2] + this.canvasWide / 2.0) + "," + ((double)py[2] + this.canvasHigh / 2.0);
        ArrowElement.setAttribute("points", points);
        ArrowElement.setAttribute("fill", Tools.ColorToHex(color));
        ArrowElement.setAttribute("stroke", Tools.ColorToHex(color));
        ArrowElement.setAttribute("stroke-width", (double)weight * this.rate < 1.0 ? "1" : String.valueOf((int)((double)weight * this.rate + 1.0)));
        svgElement.addContent(ArrowElement);
    }

    public PolygonXY getBracketXY(double startX, double startY, double endX, double endY, String shapeType, int angle) {
        PolygonXY pgxyscale = new PolygonXY();
        pgxyscale.angle = angle;
        double radius = 0.0;
        double centerX = startX + (endX - startX) / 2.0;
        double centerY = startY + (endY - startY) / 2.0;
        double zeroAngleX = 0.0;
        double zeroAngleY = 0.0;
        double scaleX = 1.0;
        double scaleY = 1.0;
        int itype = 1;
        if (endX - startX == endY - startY) {
            radius = (endX - startX) / 2.0;
            zeroAngleX = endX;
            zeroAngleY = centerY;
            itype = 1;
            scaleX = 1.0;
            scaleY = 1.0;
        } else if (endX - startX <= endY - startY) {
            radius = (endX - startX) / 2.0;
            zeroAngleX = centerX + radius;
            zeroAngleY = centerY;
            itype = 2;
            scaleX = 1.0;
            scaleY = (endY - startY) / (endX - startX);
        } else if (endX - startX >= endY - startY) {
            radius = (endY - startY) / 2.0;
            zeroAngleX = centerX + radius;
            zeroAngleY = centerY;
            itype = 3;
            scaleX = (endX - startX) / (endY - startY);
            scaleY = 1.0;
        }
        double arcx = 0.0;
        double arcy = 0.0;
        double initangle = 0.0;
        double inputangle = Math.PI * -2 * (double)angle / 360.0;
        double arcangle = 0.0;
        if (shapeType == "SquareBracket" || shapeType == "Brace") {
            initangle = 0.0;
            pgxyscale.x = new int[4];
            pgxyscale.y = new int[4];
            for (int i = 0; i <= 3; ++i) {
                double r;
                if (i == 3) {
                    r = Math.sqrt(Math.pow(centerX - endX, 2.0) + Math.pow(centerY - startY, 2.0));
                    initangle = Math.atan((endY - startY) / 2.0 / ((endX - startX) / 2.0));
                    arcangle = initangle + inputangle;
                    zeroAngleX = centerX + r;
                    zeroAngleY = centerY;
                    arcx = (zeroAngleX - centerX) * Math.cos(arcangle) - (zeroAngleY - centerY) * Math.sin(arcangle) + centerX;
                    arcy = -1.0 * (zeroAngleX - centerX) * Math.sin(arcangle) + (zeroAngleY - centerY) * Math.cos(arcangle) + centerY;
                } else if (i == 0) {
                    r = Math.sqrt(Math.pow(centerX - startX, 2.0) + Math.pow(centerY - startY, 2.0));
                    initangle = 1.5707963267948966 + Math.atan((endX - startX) / 2.0 / ((endY - startY) / 2.0));
                    arcangle = initangle + inputangle;
                    zeroAngleX = centerX + r;
                    zeroAngleY = centerY;
                    arcx = (zeroAngleX - centerX) * Math.cos(arcangle) - (zeroAngleY - centerY) * Math.sin(arcangle) + centerX;
                    arcy = -1.0 * (zeroAngleX - centerX) * Math.sin(arcangle) + (zeroAngleY - centerY) * Math.cos(arcangle) + centerY;
                } else if (i == 1) {
                    r = Math.sqrt(Math.pow(centerX - startX, 2.0) + Math.pow(centerY - endY, 2.0));
                    initangle = Math.PI + Math.atan((endY - startY) / 2.0 / ((endX - startX) / 2.0));
                    arcangle = initangle + inputangle;
                    zeroAngleX = centerX + r;
                    zeroAngleY = centerY;
                    arcx = (zeroAngleX - centerX) * Math.cos(arcangle) - (zeroAngleY - centerY) * Math.sin(arcangle) + centerX;
                    arcy = -1.0 * (zeroAngleX - centerX) * Math.sin(arcangle) + (zeroAngleY - centerY) * Math.cos(arcangle) + centerY;
                } else if (i == 2) {
                    r = Math.sqrt(Math.pow(centerX - endX, 2.0) + Math.pow(centerY - endY, 2.0));
                    initangle = 4.71238898038469 + Math.atan((endX - startX) / 2.0 / ((endY - startY) / 2.0));
                    arcangle = initangle + inputangle;
                    zeroAngleX = centerX + r;
                    zeroAngleY = centerY;
                    arcx = (zeroAngleX - centerX) * Math.cos(arcangle) - (zeroAngleY - centerY) * Math.sin(arcangle) + centerX;
                    arcy = -1.0 * (zeroAngleX - centerX) * Math.sin(arcangle) + (zeroAngleY - centerY) * Math.cos(arcangle) + centerY;
                }
                pgxyscale.x[i] = (int)arcx;
                pgxyscale.y[i] = (int)arcy;
                pgxyscale.pointcount = 4;
            }
        }
        return pgxyscale;
    }

    public void drawSVGBracket(int vertical, int horizontal, int centerx, int centery, int wide, int angle, int weight, Color color, String shapeType, Element svgElement) {
        int startX = 0;
        int startY = 0;
        int endX = 0;
        int endY = 0;
        int high = 3;
        int startx = 0;
        int endx = 0;
        if (shapeType.equals("SquareBracket")) {
            high = 3;
        } else if (shapeType.equals("ShapeEnum.Brace")) {
            high = 5;
        }
        startx = centerx - wide;
        endx = centerx + wide;
        startX = (int)((-this.HALF_LENGTH + (double)horizontal + (double)startx * this.LENGTH_RATE) * this.rate);
        endX = (int)((-this.HALF_LENGTH + (double)horizontal + (double)endx * this.LENGTH_RATE) * this.rate);
        startY = (int)((double)(-vertical - centery) * this.rate) - high;
        endY = (int)((double)(-vertical - centery) * this.rate) + high;
        Element rotateElement = new Element("g");
        if (shapeType.equals("SquareBracket")) {
            rotateElement.setAttribute("transform", "rotate(0)");
            Element bracketElement = new Element("path");
            PolygonXY pgxy = new PolygonXY();
            pgxy = this.getBracketXY(startX, startY, endX, endY, shapeType, angle);
            pgxy.CacuMinMaxXY();
            String d = "M " + ((double)pgxy.x[0] + this.canvasWide / 2.0) + "," + ((double)pgxy.y[0] + this.canvasHigh / 2.0);
            for (int i = 1; i < pgxy.x.length; ++i) {
                d = d + " L " + ((double)pgxy.x[i] + this.canvasWide / 2.0) + "," + ((double)pgxy.y[i] + this.canvasHigh / 2.0);
            }
            bracketElement.setAttribute("d", d);
            bracketElement.setAttribute("fill", "none");
            bracketElement.setAttribute("stroke", Tools.ColorToHex(color));
            bracketElement.setAttribute("stroke-width", (double)weight * this.rate < 1.0 ? "1" : String.valueOf((int)((double)weight * this.rate + 1.0)));
            rotateElement.addContent(bracketElement);
        } else if (shapeType.equals("Brace")) {
            startY = (int)((double)(-vertical - centery) * this.rate) - high;
            endY = (int)((double)(-vertical - centery) * this.rate) + high;
            if (angle < 0) {
                angle = (int)(360.0 + (double)angle);
            }
            double centerX = startX + (endX - startX) / 2;
            double centerY = startY + (endY - startY) / 2;
            rotateElement.setAttribute("transform", "translate(" + (centerX + this.canvasWide / 2.0) + "," + (centerY + this.canvasHigh / 2.0) + ") " + "rotate(" + angle + ") " + "translate(-" + (centerX + this.canvasWide / 2.0) + ",-" + (centerY + this.canvasHigh / 2.0) + ") ");
            int cx = 0;
            int cy = 0;
            int cw = 0;
            int ch = 0;
            String d = "";
            cx = startX;
            cy = startY;
            cw = 2 * high;
            ch = 2 * high;
            Element bracketElement1 = new Element("path");
            d = "M" + ((double)cx + this.canvasWide / 2.0) + "," + ((double)cy + this.canvasHigh / 2.0);
            d = d + " a" + (float)cw + "," + (float)ch + " 0 0,0 " + (float)cw + "," + (float)ch;
            bracketElement1.setAttribute("d", d);
            bracketElement1.setAttribute("fill", "none");
            bracketElement1.setAttribute("stroke", Tools.ColorToHex(color));
            bracketElement1.setAttribute("stroke-width", (double)weight * this.rate < 1.0 ? "1" : String.valueOf((int)((double)weight * this.rate + 1.0)));
            rotateElement.addContent(bracketElement1);
            int cstartx = 0;
            int cstarty = 0;
            int cendx = 0;
            int cendy = 0;
            cstartx = startX + high;
            cstarty = endY;
            cendx = startX + (endX - startX) / 2 - high;
            cendy = endY;
            Element bracketElement2 = new Element("path");
            d = "M" + ((double)cstartx + this.canvasWide / 2.0) + "," + ((double)cstarty + this.canvasHigh / 2.0);
            d = d + " L" + ((double)cendx + this.canvasWide / 2.0) + "," + ((double)cendy + this.canvasHigh / 2.0);
            bracketElement2.setAttribute("d", d);
            bracketElement2.setAttribute("fill", "none");
            bracketElement2.setAttribute("stroke", Tools.ColorToHex(color));
            bracketElement2.setAttribute("stroke-width", (double)weight * this.rate < 1.0 ? "1" : String.valueOf((int)((double)weight * this.rate + 1.0)));
            rotateElement.addContent(bracketElement2);
            cx = startX + (endX - startX) / 2 - 2 * high;
            cy = endY;
            cw = 2 * high;
            ch = 2 * high;
            Element bracketElement3 = new Element("path");
            d = "M" + ((double)cx + this.canvasWide / 2.0) + "," + ((double)cy + this.canvasHigh / 2.0);
            d = d + " a" + (float)cw + "," + (float)ch + " 0 0,1 " + (float)cw + "," + (float)ch;
            bracketElement3.setAttribute("d", d);
            bracketElement3.setAttribute("fill", "none");
            bracketElement3.setAttribute("stroke", Tools.ColorToHex(color));
            bracketElement3.setAttribute("stroke-width", (double)weight * this.rate < 1.0 ? "1" : String.valueOf((int)((double)weight * this.rate + 1.0)));
            rotateElement.addContent(bracketElement3);
            cx = startX + (endX - startX) / 2;
            cy = endY + 2 * high;
            cw = 2 * high;
            ch = 2 * high;
            Element bracketElement4 = new Element("path");
            d = "M" + ((double)cx + this.canvasWide / 2.0) + "," + ((double)cy + this.canvasHigh / 2.0);
            d = d + " a" + (float)cw + "," + (float)ch + " 0 0,1 " + (float)cw + "," + (float)(-ch);
            bracketElement4.setAttribute("d", d);
            bracketElement4.setAttribute("fill", "none");
            bracketElement4.setAttribute("stroke", Tools.ColorToHex(color));
            bracketElement4.setAttribute("stroke-width", (double)weight * this.rate < 1.0 ? "1" : String.valueOf((int)((double)weight * this.rate + 1.0)));
            rotateElement.addContent(bracketElement4);
            cstartx = startX + (endX - startX) / 2 + high;
            cstarty = endY;
            cendx = endX - high;
            cendy = endY;
            Element bracketElement5 = new Element("path");
            d = "M" + ((double)cstartx + this.canvasWide / 2.0) + "," + ((double)cstarty + this.canvasHigh / 2.0);
            d = d + " L" + ((double)cendx + this.canvasWide / 2.0) + "," + ((double)cendy + this.canvasHigh / 2.0);
            bracketElement5.setAttribute("d", d);
            bracketElement5.setAttribute("fill", "none");
            bracketElement5.setAttribute("stroke", Tools.ColorToHex(color));
            bracketElement5.setAttribute("stroke-width", (double)weight * this.rate < 1.0 ? "1" : String.valueOf((int)((double)weight * this.rate + 1.0)));
            rotateElement.addContent(bracketElement5);
            cx = endX - 2 * high;
            cy = startY + 2 * high;
            cw = 2 * high;
            ch = 2 * high;
            Element bracketElement6 = new Element("path");
            d = "M" + ((double)cx + this.canvasWide / 2.0) + "," + ((double)cy + this.canvasHigh / 2.0);
            d = d + " a" + (float)cw + "," + (float)ch + " 0 0,0 " + (float)cw + "," + (float)(-ch);
            bracketElement6.setAttribute("d", d);
            bracketElement6.setAttribute("fill", "none");
            bracketElement6.setAttribute("stroke", Tools.ColorToHex(color));
            bracketElement6.setAttribute("stroke-width", (double)weight * this.rate < 1.0 ? "1" : String.valueOf((int)((double)weight * this.rate + 1.0)));
            rotateElement.addContent(bracketElement6);
        }
        svgElement.addContent(rotateElement);
    }

    public void drawSVGText(int size, double x, double y, String text, Element svgElement) {
        Element startTextElement = new Element("text");
        svgElement.addContent(startTextElement);
        startTextElement.setAttribute("font-family", "'Arial-BoldMT'");
        startTextElement.setAttribute("font-size", String.valueOf(size));
        startTextElement.setAttribute("x", String.valueOf((float)(x + this.canvasWide / 2.0)));
        startTextElement.setAttribute("y", String.valueOf((float)(y + this.canvasHigh / 2.0)));
        startTextElement.setText(text);
    }

    public void drawSVGText(int size, double x, double y, Color color, String text, Element svgElement) {
        Element startTextElement = new Element("text");
        svgElement.addContent(startTextElement);
        startTextElement.setAttribute("fill", Tools.ColorToHex(color));
        startTextElement.setAttribute("font-family", "'Arial-BoldMT'");
        startTextElement.setAttribute("font-size", String.valueOf(size));
        startTextElement.setAttribute("x", String.valueOf((float)(x + this.canvasWide / 2.0)));
        startTextElement.setAttribute("y", String.valueOf((float)(y + this.canvasHigh / 2.0)));
        startTextElement.setText(text);
    }

    public void drawSVGText(int size, double x, double y, Color color, String strfont, String style, double angle, String note, Graphics2D g2d, Element svgElement) {
        Element startTextElement = new Element("text");
        svgElement.addContent(startTextElement);
        startTextElement.setAttribute("fill", Tools.ColorToHex(color));
        FontMetrics fontMetrics = g2d.getFontMetrics();
        if (angle < 0.0) {
            angle = (int)(360.0 + angle);
        }
        startTextElement.setAttribute("x", String.valueOf(x - (double)fontMetrics.stringWidth(note) / 2.0));
        startTextElement.setAttribute("y", String.valueOf(y + (double)fontMetrics.getHeight() / 4.0));
        startTextElement.setAttribute("font-size", String.valueOf(size));
        startTextElement.setAttribute("transform", "translate(" + x + "," + y + ") " + "rotate(" + angle + ") " + "translate(-" + x + ",-" + y + ") ");
        startTextElement.setText(note);
    }

    public void drawSVGPolygon(Protein pr, Component com, double startx, double starty, double endx, double endy, double bnewminx, double bnewminy, double bnewmaxx, double bnewmaxy, int[] px, int[] py, double weight, Color color, double rotateAngle, String sGradient, String shape, String text, int fontsize, Color textColor, String nameDrawType, int linesize, Color lineColor, String texturefile, String newSVGFilePath, double ihigh, boolean bdash, boolean isdrawprotein, Graphics2D g2d, Element svgElement) {
        Element stop2;
        bnewminx -= 20.0;
        bnewminy -= 20.0;
        bnewmaxx += 20.0;
        bnewmaxy += 20.0;
        double centerx = 0.0;
        double centery = 0.0;
        centerx = startx + (endx - startx) / 2.0;
        centery = starty + (endy - starty) / 2.0;
        Element rotateElement = new Element("g");
        if (!shape.equals("RoundRectangle") && !shape.equals("Circle")) {
            rotateAngle = 0.0;
        }
        if (rotateAngle < 0.0) {
            rotateAngle = (int)(360.0 + rotateAngle);
        }
        rotateElement.setAttribute("transform", "rotate(0) ");
        double radius = 10.0;
        String lgx1 = "";
        String lgy1 = "";
        String lgx2 = "";
        String lgy2 = "";
        if (sGradient.equals("Down")) {
            lgx1 = "0%";
            lgy1 = "0%";
            lgx2 = "0%";
            lgy2 = "100%";
        } else if (sGradient.equals("Left")) {
            lgx1 = "100%";
            lgy1 = "0%";
            lgx2 = "0%";
            lgy2 = "0%";
        } else if (sGradient.equals("Up")) {
            lgx1 = "0%";
            lgy1 = "100%";
            lgx2 = "0%";
            lgy2 = "0%";
        } else if (sGradient.equals("Right")) {
            lgx1 = "0%";
            lgy1 = "0%";
            lgx2 = "100%";
            lgy2 = "0%";
        } else if (sGradient.equals("Top_left_to_bottom_right")) {
            lgx1 = "0%";
            lgy1 = "0%";
            lgx2 = "100%";
            lgy2 = "100%";
        } else if (sGradient.equals("Bottom_left_to_top_right")) {
            lgx1 = "0%";
            lgy1 = "100%";
            lgx2 = "100%";
            lgy2 = "0%";
        } else if (sGradient.equals("Bottom_right_to_top_left")) {
            lgx1 = "100%";
            lgy1 = "100%";
            lgx2 = "0%";
            lgy2 = "0%";
        } else if (sGradient.equals("Top_right_to_bottom_left")) {
            lgx1 = "100%";
            lgy1 = "0%";
            lgx2 = "0%";
            lgy2 = "100%";
        } else if (sGradient.equals("Horizontal")) {
            lgx1 = "0%";
            lgy1 = "0%";
            lgx2 = "0%";
            lgy2 = "100%";
        } else if (sGradient.equals("Vertical")) {
            lgx1 = "0%";
            lgy1 = "0%";
            lgx2 = "100%";
            lgy2 = "0%";
        } else if (sGradient.equals("Horizontal")) {
            lgx1 = "0%";
            lgy1 = "0%";
            lgx2 = "0%";
            lgy2 = "100%";
        } else {
            lgx1 = "0%";
            lgy1 = "0%";
            lgx2 = "0%";
            lgy2 = "0%";
        }
        ++this.svgID;
        Element linearGradientElement = new Element("linearGradient");
        String linearGradientid = "SVGID_" + this.svgID + "_";
        linearGradientElement.setAttribute("id", linearGradientid);
        ++this.svgID;
        linearGradientElement.setAttribute("x1", lgx1);
        linearGradientElement.setAttribute("y1", lgy1);
        linearGradientElement.setAttribute("x2", lgx2);
        linearGradientElement.setAttribute("y2", lgy2);
        Element radialGradientElement = new Element("radialGradient");
        String radialGradientid = "SVGID_" + this.svgID + "_";
        radialGradientElement.setAttribute("id", radialGradientid);
        ++this.svgID;
        radialGradientElement.setAttribute("gradientUnits", "userSpaceOnUse");
        double cx = 0.0;
        double cy = 0.0;
        double r = 0.0;
        if (shape.equals("Circle")) {
            cx = startx + (endx - startx) / 2.0 + this.canvasWide / 2.0;
            cy = starty + (endy - starty) / 2.0 + this.canvasHigh / 2.0;
            r = (Math.abs(endx - startx) / 2.0 + Math.abs(endy - starty) / 2.0) / 2.0;
        } else {
            cx = startx + (endx - startx) / 2.0 + this.canvasWide / 2.0;
            cy = starty + (endy - starty) / 2.0 + this.canvasHigh / 2.0;
            r = (Math.abs(endx - startx) / 2.0 + Math.abs(endy - starty) / 2.0) / 2.0;
        }
        radialGradientElement.setAttribute("cx", String.valueOf(cx));
        radialGradientElement.setAttribute("cy", String.valueOf(cy));
        radialGradientElement.setAttribute("r", String.valueOf(r));
        Element stop1 = new Element("stop"){};
        String sGradienttype = sGradient;
        if (sGradient.equals("Horizontal") || sGradient.equals("Vertical") || sGradient.equals("Horizontal")) {
            stop1.setAttribute("offset", "0%");
            stop1.setAttribute("style", "stop-color:" + Tools.ColorToHex(color));
            linearGradientElement.addContent(stop1);
            stop2 = new Element("stop");
            stop2.setAttribute("offset", "50%");
            stop2.setAttribute("style", "stop-color:#FFFFFF");
            linearGradientElement.addContent(stop2);
            Element stop3 = new Element("stop");
            stop3.setAttribute("offset", "100%");
            stop3.setAttribute("style", "stop-color:" + Tools.ColorToHex(color));
            linearGradientElement.addContent(stop3);
            svgElement.addContent(linearGradientElement);
            sGradienttype = "line";
        } else if (sGradient.equals("Center")) {
            stop1.setAttribute("offset", "0%");
            stop1.setAttribute("style", "stop-color:#FFFFFF");
            radialGradientElement.addContent(stop1);
            stop2 = new Element("stop");
            stop2.setAttribute("offset", "100%");
            stop2.setAttribute("style", "stop-color:" + Tools.ColorToHex(color));
            radialGradientElement.addContent(stop2);
            svgElement.addContent(radialGradientElement);
            sGradienttype = "radial";
        } else if (sGradient.equals("Center_to_Border")) {
            stop1.setAttribute("offset", "0%");
            stop1.setAttribute("style", "stop-color:" + Tools.ColorToHex(color));
            radialGradientElement.addContent(stop1);
            stop2 = new Element("stop");
            stop2.setAttribute("offset", "100%");
            stop2.setAttribute("style", "stop-color:#FFFFFF");
            radialGradientElement.addContent(stop2);
            svgElement.addContent(radialGradientElement);
            sGradienttype = "radial";
        } else {
            stop1.setAttribute("offset", "0%");
            stop1.setAttribute("style", "stop-color:" + Tools.ColorToHex(color));
            linearGradientElement.addContent(stop1);
            stop2 = new Element("stop");
            stop2.setAttribute("offset", "100%");
            stop2.setAttribute("style", "stop-color:#FFFFFF");
            linearGradientElement.addContent(stop2);
            svgElement.addContent(linearGradientElement);
            sGradienttype = "line";
        }
        if (!(texturefile.equals("00000_0.jpg") || texturefile.equals("00000_1.jpg") || texturefile.equals("00001.jpg") || texturefile.equals("00001_d.jpg") || texturefile.equals("00002.jpg") || texturefile.equals("00002_d.jpg") || texturefile.equals("00002.jpg") || texturefile.equals("00002_d.jpg") || texturefile.equals("00003.jpg") || texturefile.equals("00003_d.jpg") || texturefile.equals("00004.jpg") || texturefile.equals("00004_d.jpg") || texturefile.equals("00005.jpg") || texturefile.equals("00005_d.jpg") || texturefile.equals("00006.jpg") || texturefile.equals("00006_d.jpg"))) {
            this.copyTextureFile(this.SVGFilePathFull, texturefile);
        }
        Element clipPathElement = new Element("clipPath");
        String clipPathid = "SVGID_" + this.svgID + "_";
        clipPathElement.setAttribute("id", clipPathid);
        ++this.svgID;
        Element imagePathElement = new Element("image");
        imagePathElement.setAttribute("id", "SVGID_" + this.svgID + "_");
        ++this.svgID;
        imagePathElement.setAttribute("x", String.valueOf(0));
        imagePathElement.setAttribute("y", String.valueOf(0));
        imagePathElement.setAttribute("width", String.valueOf(this.canvasWide));
        imagePathElement.setAttribute("height", String.valueOf(this.canvasHigh));
        imagePathElement.setAttribute("xlink", newSVGFilePath + ".file\\" + texturefile);
        imagePathElement.setAttribute("clip-path", "url(#" + clipPathid + ")");
        imagePathElement.setAttribute("clip-rule", "evenodd");
        imagePathElement.setAttribute("preserveAspectRatio", "xMaxYMax slice");
        if (shape.equals("Circle")) {
            Element circleElement = new Element("ellipse");
            double rx = (endx - startx) / 2.0;
            double ry = (endy - starty) / 2.0;
            circleElement.setAttribute("cx", String.valueOf((double)((float)startx) + this.canvasWide / 2.0 + (double)((float)rx)));
            circleElement.setAttribute("cy", String.valueOf((double)((float)starty) + this.canvasHigh / 2.0 + (double)((float)ry)));
            circleElement.setAttribute("rx", String.valueOf((float)rx));
            circleElement.setAttribute("ry", String.valueOf((float)ry));
            if (sGradient.equals("Null")) {
                if (!texturefile.equals("00000_0.jpg")) {
                    circleElement.setAttribute("fill", "none");
                } else {
                    circleElement.setAttribute("fill", Tools.ColorToHex(color));
                }
            } else if (sGradienttype.equals("radial")) {
                circleElement.setAttribute("fill", "url(#" + radialGradientid + ")");
            } else {
                circleElement.setAttribute("fill", "url(#" + linearGradientid + ")");
            }
            circleElement.setAttribute("stroke", Tools.ColorToHex(lineColor));
            circleElement.setAttribute("stroke-width", (double)linesize * this.rate < 1.0 ? "1" : String.valueOf((int)((double)linesize * this.rate + 1.0)));
            circleElement.setAttribute("transform", "translate(" + (centerx + this.canvasWide / 2.0) + "," + (centery + this.canvasHigh / 2.0) + ") " + "rotate(" + rotateAngle + ") " + "translate(-" + (centerx + this.canvasWide / 2.0) + ",-" + (centery + this.canvasHigh / 2.0) + ") ");
            if (texturefile.equals("00000_1.jpg")) {
                clipPathElement.addContent(circleElement);
                rotateElement.addContent(clipPathElement);
                Element circleElement4 = new Element("ellipse");
                circleElement4.setAttribute("cx", String.valueOf((double)((float)startx) + this.canvasWide / 2.0 + (double)((float)rx)));
                circleElement4.setAttribute("cy", String.valueOf((double)((float)starty) + this.canvasHigh / 2.0 + (double)((float)ry)));
                circleElement4.setAttribute("rx", String.valueOf((float)rx));
                circleElement4.setAttribute("ry", String.valueOf((float)ry));
                circleElement4.setAttribute("fill", "none");
                circleElement4.setAttribute("stroke", Tools.ColorToHex(lineColor));
                if (bdash) {
                    circleElement4.setAttribute("stroke-dasharray", "3");
                }
                circleElement4.setAttribute("stroke-width", (double)linesize * this.rate < 1.0 ? "1" : String.valueOf((int)((double)linesize * this.rate + 1.0)));
                circleElement4.setAttribute("transform", "translate(" + (centerx + this.canvasWide / 2.0) + "," + (centery + this.canvasHigh / 2.0) + ") " + "rotate(" + rotateAngle + ") " + "translate(-" + (centerx + this.canvasWide / 2.0) + ",-" + (centery + this.canvasHigh / 2.0) + ") ");
                rotateElement.addContent(circleElement4);
                svgElement.addContent(rotateElement);
                this.drawCrystal(bnewminx, bnewminy, bnewmaxx, bnewmaxy, color, clipPathid, svgElement);
            } else if (texturefile.equals("00001.jpg") || texturefile.equals("00001_d.jpg") || texturefile.equals("00002.jpg") || texturefile.equals("00002_d.jpg") || texturefile.equals("00003.jpg") || texturefile.equals("00003_d.jpg") || texturefile.equals("00004.jpg") || texturefile.equals("00004_d.jpg") || texturefile.equals("00005.jpg") || texturefile.equals("00005_d.jpg") || texturefile.equals("00006.jpg") || texturefile.equals("00006_d.jpg")) {
                clipPathElement.addContent(circleElement);
                rotateElement.addContent(clipPathElement);
                Element rectElement3 = new Element("rect");
                rectElement3.setAttribute("x", String.valueOf((double)((float)bnewminx) + this.canvasWide / 2.0));
                rectElement3.setAttribute("y", String.valueOf((double)((float)bnewminy) + this.canvasHigh / 2.0));
                double width2 = bnewmaxx - bnewminx;
                double height2 = bnewmaxy - bnewminy;
                rectElement3.setAttribute("width", String.valueOf((float)width2));
                rectElement3.setAttribute("height", String.valueOf((float)height2));
                rectElement3.setAttribute("rx", String.valueOf((double)((float)radius) / 2.0));
                rectElement3.setAttribute("ry", String.valueOf((double)((float)radius) / 2.0));
                if (sGradient.equals("Null")) {
                    if (texturefile.equals("00000_0.jpg")) {
                        rectElement3.setAttribute("fill", "none");
                    } else {
                        rectElement3.setAttribute("fill", Tools.ColorToHex(color));
                    }
                } else if (sGradienttype.equals("radial")) {
                    rectElement3.setAttribute("fill", "url(#" + radialGradientid + ")");
                } else {
                    rectElement3.setAttribute("fill", "url(#" + linearGradientid + ")");
                }
                rectElement3.setAttribute("stroke", Tools.ColorToHex(lineColor));
                rectElement3.setAttribute("stroke-width", (double)linesize * this.rate < 1.0 ? "1" : String.valueOf((int)((double)linesize * this.rate + 1.0)));
                rectElement3.setAttribute("clip-path", "url(#" + clipPathid + ")");
                rectElement3.setAttribute("clip-rule", "evenodd");
                rectElement3.setAttribute("preserveAspectRatio", "xMaxYMax slice");
                rotateElement.addContent(rectElement3);
                Element circleElement2 = new Element("ellipse");
                double rx2 = (endx - startx) / 2.0;
                double ry2 = (endy - starty) / 2.0;
                circleElement2.setAttribute("cx", String.valueOf((double)((float)startx) + this.canvasWide / 2.0 + (double)((float)rx2)));
                circleElement2.setAttribute("cy", String.valueOf((double)((float)starty) + this.canvasHigh / 2.0 + (double)((float)ry2)));
                circleElement2.setAttribute("rx", String.valueOf((float)rx));
                circleElement2.setAttribute("ry", String.valueOf((float)ry));
                if (sGradient.equals("Null")) {
                    if (!texturefile.equals("00000_0.jpg")) {
                        circleElement2.setAttribute("fill", "none");
                    } else {
                        circleElement2.setAttribute("fill", Tools.ColorToHex(color));
                    }
                } else if (sGradienttype.equals("radial")) {
                    circleElement2.setAttribute("fill", "url(#" + radialGradientid + ")");
                } else {
                    circleElement2.setAttribute("fill", "url(#" + linearGradientid + ")");
                }
                circleElement2.setAttribute("stroke", Tools.ColorToHex(lineColor));
                circleElement2.setAttribute("stroke-width", (double)linesize * this.rate < 1.0 ? "1" : String.valueOf((int)((double)linesize * this.rate + 1.0)));
                if (bdash) {
                    circleElement2.setAttribute("stroke-dasharray", "3");
                }
                circleElement2.setAttribute("transform", "translate(" + (centerx + this.canvasWide / 2.0) + "," + (centery + this.canvasHigh / 2.0) + ") " + "rotate(" + rotateAngle + ") " + "translate(-" + (centerx + this.canvasWide / 2.0) + ",-" + (centery + this.canvasHigh / 2.0) + ") ");
                rotateElement.addContent(circleElement2);
                svgElement.addContent(rotateElement);
                this.drawPolygonTextureLine(bnewminx, bnewminy, bnewmaxx, bnewmaxy, texturefile, Color.BLACK, shape.toString(), linesize, clipPathid, svgElement);
            } else if (!texturefile.equals("00000_0.jpg")) {
                clipPathElement.addContent(circleElement);
                rotateElement.addContent(clipPathElement);
                rotateElement.addContent(imagePathElement);
                Element circleElement1 = new Element("ellipse");
                circleElement1.setAttribute("cx", String.valueOf((double)((float)startx) + this.canvasWide / 2.0 + (double)((float)rx)));
                circleElement1.setAttribute("cy", String.valueOf((double)((float)starty) + this.canvasHigh / 2.0 + (double)((float)ry)));
                circleElement1.setAttribute("rx", String.valueOf((float)rx));
                circleElement1.setAttribute("ry", String.valueOf((float)ry));
                circleElement1.setAttribute("fill", "none");
                circleElement1.setAttribute("stroke", Tools.ColorToHex(lineColor));
                if (bdash) {
                    circleElement1.setAttribute("stroke-dasharray", "3");
                }
                circleElement1.setAttribute("stroke-width", (double)linesize * this.rate < 1.0 ? "1" : String.valueOf((int)((double)linesize * this.rate + 1.0)));
                circleElement1.setAttribute("transform", "translate(" + (centerx + this.canvasWide / 2.0) + "," + (centery + this.canvasHigh / 2.0) + ") " + "rotate(" + rotateAngle + ") " + "translate(-" + (centerx + this.canvasWide / 2.0) + ",-" + (centery + this.canvasHigh / 2.0) + ") ");
                rotateElement.addContent(circleElement1);
                svgElement.addContent(rotateElement);
            } else if (texturefile.equals("00000_0.jpg")) {
                clipPathElement.addContent(circleElement);
                rotateElement.addContent(clipPathElement);
                Element rectElement7 = new Element("rect");
                rectElement7.setAttribute("x", String.valueOf((double)((float)bnewminx) + this.canvasWide / 2.0));
                rectElement7.setAttribute("y", String.valueOf((double)((float)bnewminy) + this.canvasHigh / 2.0));
                double width7 = bnewmaxx - bnewminx;
                double height7 = bnewmaxy - bnewminy;
                rectElement7.setAttribute("width", String.valueOf((float)width7));
                rectElement7.setAttribute("height", String.valueOf((float)height7));
                rectElement7.setAttribute("rx", String.valueOf((double)((float)radius) / 2.0));
                rectElement7.setAttribute("ry", String.valueOf((double)((float)radius) / 2.0));
                if (sGradient.equals("Null")) {
                    if (!texturefile.equals("00000_0.jpg")) {
                        rectElement7.setAttribute("fill", "none");
                    } else {
                        rectElement7.setAttribute("fill", Tools.ColorToHex(color));
                    }
                } else if (sGradienttype.equals("radial")) {
                    rectElement7.setAttribute("fill", "url(#" + radialGradientid + ")");
                } else {
                    rectElement7.setAttribute("fill", "url(#" + linearGradientid + ")");
                }
                rectElement7.setAttribute("stroke", Tools.ColorToHex(lineColor));
                rectElement7.setAttribute("stroke-width", (double)linesize * this.rate < 1.0 ? "1" : String.valueOf((int)((double)linesize * this.rate + 1.0)));
                rectElement7.setAttribute("clip-path", "url(#" + clipPathid + ")");
                rectElement7.setAttribute("clip-rule", "evenodd");
                rectElement7.setAttribute("preserveAspectRatio", "xMaxYMax slice");
                rotateElement.addContent(rectElement7);
                Element circleElement4 = new Element("ellipse");
                circleElement4.setAttribute("cx", String.valueOf((double)((float)startx) + this.canvasWide / 2.0 + (double)((float)rx)));
                circleElement4.setAttribute("cy", String.valueOf((double)((float)starty) + this.canvasHigh / 2.0 + (double)((float)ry)));
                circleElement4.setAttribute("rx", String.valueOf((float)rx));
                circleElement4.setAttribute("ry", String.valueOf((float)ry));
                circleElement4.setAttribute("fill", "none");
                circleElement4.setAttribute("stroke", Tools.ColorToHex(lineColor));
                if (bdash) {
                    circleElement4.setAttribute("stroke-dasharray", "3");
                }
                circleElement4.setAttribute("stroke-width", (double)linesize * this.rate < 1.0 ? "1" : String.valueOf((int)((double)linesize * this.rate + 1.0)));
                circleElement4.setAttribute("transform", "translate(" + (centerx + this.canvasWide / 2.0) + "," + (centery + this.canvasHigh / 2.0) + ") " + "rotate(" + rotateAngle + ") " + "translate(-" + (centerx + this.canvasWide / 2.0) + ",-" + (centery + this.canvasHigh / 2.0) + ") ");
                rotateElement.addContent(circleElement4);
                svgElement.addContent(rotateElement);
            }
        } else if (shape.equals("L_ParallelLine") || shape.equals("R_ParallelLine")) {
            Element plElement = new Element("polygon");
            String d = (double)px[0] + this.canvasWide / 2.0 + "," + ((double)py[0] + this.canvasHigh / 2.0) + " ";
            d = d + ((double)px[1] + this.canvasWide / 2.0) + "," + ((double)py[1] + this.canvasHigh / 2.0) + " ";
            d = d + ((double)px[2] + this.canvasWide / 2.0) + "," + ((double)py[2] + this.canvasHigh / 2.0) + " ";
            d = d + ((double)px[3] + this.canvasWide / 2.0) + "," + ((double)py[3] + this.canvasHigh / 2.0);
            plElement.setAttribute("points", d);
            plElement.setAttribute("fill", "none");
            plElement.setAttribute("stroke", "none");
            plElement.setAttribute("stroke-width", "0");
            plElement.setAttribute("transform", "translate(" + (centerx + this.canvasWide / 2.0) + "," + (centery + this.canvasHigh / 2.0) + ") " + "rotate(" + rotateAngle + ") " + "translate(-" + (centerx + this.canvasWide / 2.0) + ",-" + (centery + this.canvasHigh / 2.0) + ") ");
            clipPathElement.addContent(plElement);
            rotateElement.addContent(clipPathElement);
            Element rectElement4 = new Element("rect");
            rectElement4.setAttribute("x", String.valueOf((double)((float)bnewminx) + this.canvasWide / 2.0));
            rectElement4.setAttribute("y", String.valueOf((double)((float)bnewminy) + this.canvasHigh / 2.0));
            double width4 = bnewmaxx - bnewminx;
            double height4 = bnewmaxy - bnewminy;
            rectElement4.setAttribute("width", String.valueOf((float)width4));
            rectElement4.setAttribute("height", String.valueOf((float)height4));
            rectElement4.setAttribute("rx", "0");
            rectElement4.setAttribute("ry", "0");
            if (sGradient.equals("Null")) {
                if (!texturefile.equals("00000_0.jpg")) {
                    rectElement4.setAttribute("fill", "none");
                } else {
                    rectElement4.setAttribute("fill", Tools.ColorToHex(color));
                }
            } else if (sGradienttype.equals("radial")) {
                rectElement4.setAttribute("fill", "url(#" + radialGradientid + ")");
            } else {
                rectElement4.setAttribute("fill", "url(#" + linearGradientid + ")");
            }
            rectElement4.setAttribute("stroke", Tools.ColorToHex(lineColor));
            rectElement4.setAttribute("stroke-width", (double)linesize * this.rate < 1.0 ? "1" : String.valueOf((int)((double)linesize * this.rate + 1.0)));
            rectElement4.setAttribute("clip-path", "url(#" + clipPathid + ")");
            rectElement4.setAttribute("clip-rule", "evenodd");
            rectElement4.setAttribute("preserveAspectRatio", "xMaxYMax slice");
            rotateElement.addContent(rectElement4);
            Element plElement5 = new Element("path");
            String d5 = "M " + ((double)px[0] + this.canvasWide / 2.0) + "," + ((double)py[0] + this.canvasHigh / 2.0);
            d5 = d5 + " L " + ((double)px[3] + this.canvasWide / 2.0) + "," + ((double)py[3] + this.canvasHigh / 2.0);
            d5 = d5 + " M " + ((double)px[1] + this.canvasWide / 2.0) + "," + ((double)py[1] + this.canvasHigh / 2.0);
            d5 = d5 + " L " + ((double)px[2] + this.canvasWide / 2.0) + "," + ((double)py[2] + this.canvasHigh / 2.0);
            plElement5.setAttribute("d", d5);
            plElement5.setAttribute("fill", "none");
            plElement5.setAttribute("stroke", Tools.ColorToHex(lineColor));
            plElement5.setAttribute("stroke-width", (double)linesize * this.rate < 1.0 ? "1" : String.valueOf((int)((double)linesize * this.rate + 1.0)));
            plElement5.setAttribute("transform", "translate(" + (centerx + this.canvasWide / 2.0) + "," + (centery + this.canvasHigh / 2.0) + ") " + "rotate(" + rotateAngle + ") " + "translate(-" + (centerx + this.canvasWide / 2.0) + ",-" + (centery + this.canvasHigh / 2.0) + ") ");
            rotateElement.addContent(plElement5);
            svgElement.addContent(rotateElement);
        } else if (shape.equals("L_ParallelCurve") || shape.equals("R_ParallelCurve")) {
            Element plElement = new Element("path");
            String d = "";
            d = "M " + ((double)px[0] + this.canvasWide / 2.0) + " " + ((double)py[0] + this.canvasHigh / 2.0) + " C " + ((double)px[4] + this.canvasWide / 2.0) + " " + ((double)py[4] + this.canvasHigh / 2.0) + " " + ((double)px[5] + this.canvasWide / 2.0) + " " + ((double)py[5] + this.canvasHigh / 2.0) + " " + ((double)px[3] + this.canvasWide / 2.0) + " " + ((double)py[3] + this.canvasHigh / 2.0);
            d = d + "L " + ((double)px[2] + this.canvasWide / 2.0) + " " + ((double)py[2] + this.canvasHigh / 2.0) + " C " + ((double)px[7] + this.canvasWide / 2.0) + " " + ((double)py[7] + this.canvasHigh / 2.0) + " " + ((double)px[6] + this.canvasWide / 2.0) + " " + ((double)py[7] + this.canvasHigh / 2.0) + " " + ((double)px[1] + this.canvasWide / 2.0) + " " + ((double)py[1] + this.canvasHigh / 2.0);
            d = d + "L " + ((double)px[0] + this.canvasWide / 2.0) + " " + ((double)py[0] + this.canvasHigh / 2.0);
            plElement.setAttribute("d", d);
            plElement.setAttribute("fill", "none");
            plElement.setAttribute("stroke", "none");
            plElement.setAttribute("stroke-width", "0");
            plElement.setAttribute("transform", "translate(" + (centerx + this.canvasWide / 2.0) + "," + (centery + this.canvasHigh / 2.0) + ") " + "rotate(" + rotateAngle + ") " + "translate(-" + (centerx + this.canvasWide / 2.0) + ",-" + (centery + this.canvasHigh / 2.0) + ") ");
            clipPathElement.addContent(plElement);
            rotateElement.addContent(clipPathElement);
            Element rectElement4 = new Element("rect");
            rectElement4.setAttribute("x", String.valueOf((double)((float)bnewminx) + this.canvasWide / 2.0));
            rectElement4.setAttribute("y", String.valueOf((double)((float)bnewminy) + this.canvasHigh / 2.0));
            double width4 = bnewmaxx - bnewminx;
            double height4 = bnewmaxy - bnewminy;
            rectElement4.setAttribute("width", String.valueOf((float)width4));
            rectElement4.setAttribute("height", String.valueOf((float)height4));
            rectElement4.setAttribute("rx", "0");
            rectElement4.setAttribute("ry", "0");
            if (sGradient.equals("Null")) {
                if (!texturefile.equals("00000_0.jpg")) {
                    rectElement4.setAttribute("fill", "none");
                } else {
                    rectElement4.setAttribute("fill", Tools.ColorToHex(color));
                }
            } else if (sGradienttype.equals("radial")) {
                rectElement4.setAttribute("fill", "url(#" + radialGradientid + ")");
            } else {
                rectElement4.setAttribute("fill", "url(#" + linearGradientid + ")");
            }
            rectElement4.setAttribute("stroke", Tools.ColorToHex(lineColor));
            rectElement4.setAttribute("stroke-width", (double)linesize * this.rate < 1.0 ? "1" : String.valueOf((int)((double)linesize * this.rate + 1.0)));
            rectElement4.setAttribute("clip-path", "url(#" + clipPathid + ")");
            rectElement4.setAttribute("clip-rule", "evenodd");
            rectElement4.setAttribute("preserveAspectRatio", "xMaxYMax slice");
            rotateElement.addContent(rectElement4);
            Element plElement5 = new Element("path");
            String d5 = "";
            d5 = "M " + ((double)px[0] + this.canvasWide / 2.0) + " " + ((double)py[0] + this.canvasHigh / 2.0) + " C " + ((double)px[4] + this.canvasWide / 2.0) + " " + ((double)py[4] + this.canvasHigh / 2.0) + " " + ((double)px[5] + this.canvasWide / 2.0) + " " + ((double)py[5] + this.canvasHigh / 2.0) + " " + ((double)px[3] + this.canvasWide / 2.0) + " " + ((double)py[3] + this.canvasHigh / 2.0);
            d5 = d5 + "M " + ((double)px[2] + this.canvasWide / 2.0) + " " + ((double)py[2] + this.canvasHigh / 2.0) + " C " + ((double)px[7] + this.canvasWide / 2.0) + " " + ((double)py[7] + this.canvasHigh / 2.0) + " " + ((double)px[6] + this.canvasWide / 2.0) + " " + ((double)py[7] + this.canvasHigh / 2.0) + " " + ((double)px[1] + this.canvasWide / 2.0) + " " + ((double)py[1] + this.canvasHigh / 2.0);
            plElement5.setAttribute("d", d5);
            plElement5.setAttribute("fill", "none");
            plElement5.setAttribute("stroke", Tools.ColorToHex(lineColor));
            plElement5.setAttribute("stroke-width", (double)linesize * this.rate < 1.0 ? "1" : String.valueOf((int)((double)linesize * this.rate + 1.0)));
            plElement5.setAttribute("transform", "translate(" + (centerx + this.canvasWide / 2.0) + "," + (centery + this.canvasHigh / 2.0) + ") " + "rotate(" + rotateAngle + ") " + "translate(-" + (centerx + this.canvasWide / 2.0) + ",-" + (centery + this.canvasHigh / 2.0) + ") ");
            rotateElement.addContent(plElement5);
            svgElement.addContent(rotateElement);
        } else if (shape.equals("RoundRectangle")) {
            Element rectElement5;
            double height2;
            double width2;
            Element rectElement = new Element("rect");
            rectElement.setAttribute("x", String.valueOf((double)((float)startx) + this.canvasWide / 2.0));
            rectElement.setAttribute("y", String.valueOf((double)((float)starty) + this.canvasHigh / 2.0));
            double width = endx - startx;
            double height = endy - starty;
            rectElement.setAttribute("width", String.valueOf((float)width));
            rectElement.setAttribute("height", String.valueOf((float)height));
            rectElement.setAttribute("rx", String.valueOf((double)((float)radius) / 2.0));
            rectElement.setAttribute("ry", String.valueOf((double)((float)radius) / 2.0));
            rectElement.setAttribute("fill", "none");
            rectElement.setAttribute("stroke", Tools.ColorToHex(lineColor));
            rectElement.setAttribute("stroke-width", (double)linesize * this.rate < 1.0 ? "1" : String.valueOf((int)((double)linesize * this.rate + 1.0)));
            rectElement.setAttribute("transform", "translate(" + (centerx + this.canvasWide / 2.0) + "," + (centery + this.canvasHigh / 2.0) + ") " + "rotate(" + rotateAngle + ") " + "translate(-" + (centerx + this.canvasWide / 2.0) + ",-" + (centery + this.canvasHigh / 2.0) + ") ");
            if (texturefile.equals("00000_1.jpg")) {
                clipPathElement.addContent(rectElement);
                rotateElement.addContent(clipPathElement);
                Element rectElement52 = new Element("rect");
                rectElement52.setAttribute("x", String.valueOf((double)((float)startx) + this.canvasWide / 2.0));
                rectElement52.setAttribute("y", String.valueOf((double)((float)starty) + this.canvasHigh / 2.0));
                rectElement52.setAttribute("width", String.valueOf((float)width));
                rectElement52.setAttribute("height", String.valueOf((float)height));
                rectElement52.setAttribute("rx", String.valueOf((double)((float)radius) / 2.0));
                rectElement52.setAttribute("ry", String.valueOf((double)((float)radius) / 2.0));
                rectElement52.setAttribute("fill", "none");
                rectElement52.setAttribute("stroke", Tools.ColorToHex(lineColor));
                if (bdash) {
                    rectElement52.setAttribute("stroke-dasharray", "3");
                }
                rectElement52.setAttribute("stroke-width", (double)linesize * this.rate < 1.0 ? "1" : String.valueOf((int)((double)linesize * this.rate + 1.0)));
                rectElement52.setAttribute("transform", "translate(" + (centerx + this.canvasWide / 2.0) + "," + (centery + this.canvasHigh / 2.0) + ") " + "rotate(" + rotateAngle + ") " + "translate(-" + (centerx + this.canvasWide / 2.0) + ",-" + (centery + this.canvasHigh / 2.0) + ") ");
                rotateElement.addContent(rectElement52);
                svgElement.addContent(rotateElement);
                this.drawCrystal(bnewminx, bnewminy, bnewmaxx, bnewmaxy, color, clipPathid, svgElement);
            } else if (texturefile.equals("00001.jpg") || texturefile.equals("00001_d.jpg") || texturefile.equals("00002.jpg") || texturefile.equals("00002_d.jpg") || texturefile.equals("00003.jpg") || texturefile.equals("00003_d.jpg") || texturefile.equals("00004.jpg") || texturefile.equals("00004_d.jpg") || texturefile.equals("00005.jpg") || texturefile.equals("00005_d.jpg") || texturefile.equals("00006.jpg") || texturefile.equals("00006_d.jpg")) {
                clipPathElement.addContent(rectElement);
                rotateElement.addContent(clipPathElement);
                Element rectElement3 = new Element("rect");
                rectElement3.setAttribute("x", String.valueOf((double)((float)bnewminx) + this.canvasWide / 2.0));
                rectElement3.setAttribute("y", String.valueOf((double)((float)bnewminy) + this.canvasHigh / 2.0));
                width2 = bnewmaxx - bnewminx;
                height2 = bnewmaxy - bnewminy;
                rectElement3.setAttribute("width", String.valueOf((float)width2));
                rectElement3.setAttribute("height", String.valueOf((float)height2));
                rectElement3.setAttribute("rx", String.valueOf((double)((float)radius) / 2.0));
                rectElement3.setAttribute("ry", String.valueOf((double)((float)radius) / 2.0));
                if (sGradient.equals("Null")) {
                    if (texturefile.equals("00000_0.jpg")) {
                        rectElement3.setAttribute("fill", "none");
                    } else {
                        rectElement3.setAttribute("fill", Tools.ColorToHex(color));
                    }
                } else if (sGradienttype.equals("radial")) {
                    rectElement3.setAttribute("fill", "url(#" + radialGradientid + ")");
                } else {
                    rectElement3.setAttribute("fill", "url(#" + linearGradientid + ")");
                }
                rectElement3.setAttribute("stroke", Tools.ColorToHex(lineColor));
                rectElement3.setAttribute("stroke-width", (double)linesize * this.rate < 1.0 ? "1" : String.valueOf((int)((double)linesize * this.rate + 1.0)));
                rectElement3.setAttribute("clip-path", "url(#" + clipPathid + ")");
                rectElement3.setAttribute("clip-rule", "evenodd");
                rectElement3.setAttribute("preserveAspectRatio", "xMaxYMax slice");
                rotateElement.addContent(rectElement3);
                rectElement5 = new Element("rect");
                rectElement5.setAttribute("x", String.valueOf((double)((float)startx) + this.canvasWide / 2.0));
                rectElement5.setAttribute("y", String.valueOf((double)((float)starty) + this.canvasHigh / 2.0));
                rectElement5.setAttribute("width", String.valueOf((float)width));
                rectElement5.setAttribute("height", String.valueOf((float)height));
                rectElement5.setAttribute("rx", String.valueOf((double)((float)radius) / 2.0));
                rectElement5.setAttribute("ry", String.valueOf((double)((float)radius) / 2.0));
                rectElement5.setAttribute("fill", "none");
                rectElement5.setAttribute("stroke", Tools.ColorToHex(lineColor));
                if (bdash) {
                    rectElement5.setAttribute("stroke-dasharray", "3");
                }
                rectElement5.setAttribute("stroke-width", (double)linesize * this.rate < 1.0 ? "1" : String.valueOf((int)((double)linesize * this.rate + 1.0)));
                rectElement5.setAttribute("transform", "translate(" + (centerx + this.canvasWide / 2.0) + "," + (centery + this.canvasHigh / 2.0) + ") " + "rotate(" + rotateAngle + ") " + "translate(-" + (centerx + this.canvasWide / 2.0) + ",-" + (centery + this.canvasHigh / 2.0) + ") ");
                rotateElement.addContent(rectElement5);
                svgElement.addContent(rotateElement);
                this.drawPolygonTextureLine(bnewminx, bnewminy, bnewmaxx, bnewmaxy, texturefile, Color.BLACK, shape.toString(), linesize, clipPathid, svgElement);
            } else if (!texturefile.equals("00000_0.jpg")) {
                clipPathElement.addContent(rectElement);
                rotateElement.addContent(clipPathElement);
                rotateElement.addContent(imagePathElement);
                Element rectElement2 = new Element("rect");
                rectElement2.setAttribute("x", String.valueOf((double)((float)startx) + this.canvasWide / 2.0));
                rectElement2.setAttribute("y", String.valueOf((double)((float)starty) + this.canvasHigh / 2.0));
                width2 = endx - startx;
                height2 = endy - starty;
                rectElement2.setAttribute("width", String.valueOf((float)width2));
                rectElement2.setAttribute("height", String.valueOf((float)height2));
                rectElement2.setAttribute("rx", String.valueOf((double)((float)radius) / 2.0));
                rectElement2.setAttribute("ry", String.valueOf((double)((float)radius) / 2.0));
                rectElement2.setAttribute("fill", "none");
                rectElement2.setAttribute("stroke", Tools.ColorToHex(lineColor));
                if (bdash) {
                    rectElement2.setAttribute("stroke-dasharray", "3");
                }
                rectElement2.setAttribute("stroke-width", (double)linesize * this.rate < 1.0 ? "1" : String.valueOf((int)((double)linesize * this.rate + 1.0)));
                rectElement2.setAttribute("transform", "translate(" + (centerx + this.canvasWide / 2.0) + "," + (centery + this.canvasHigh / 2.0) + ") " + "rotate(" + rotateAngle + ") " + "translate(-" + (centerx + this.canvasWide / 2.0) + ",-" + (centery + this.canvasHigh / 2.0) + ") ");
                rotateElement.addContent(rectElement2);
                svgElement.addContent(rotateElement);
            } else if (texturefile.equals("00000_0.jpg")) {
                clipPathElement.addContent(rectElement);
                rotateElement.addContent(clipPathElement);
                Element rectElement4 = new Element("rect");
                rectElement4.setAttribute("x", String.valueOf((double)((float)bnewminx) + this.canvasWide / 2.0));
                rectElement4.setAttribute("y", String.valueOf((double)((float)bnewminy) + this.canvasHigh / 2.0));
                double width4 = bnewmaxx - bnewminx;
                double height4 = bnewmaxy - bnewminy;
                rectElement4.setAttribute("width", String.valueOf((float)width4));
                rectElement4.setAttribute("height", String.valueOf((float)height4));
                rectElement4.setAttribute("rx", String.valueOf((double)((float)radius) / 2.0));
                rectElement4.setAttribute("ry", String.valueOf((double)((float)radius) / 2.0));
                if (sGradient.equals("Null")) {
                    if (!texturefile.equals("00000_0.jpg")) {
                        rectElement4.setAttribute("fill", "none");
                    } else {
                        rectElement4.setAttribute("fill", Tools.ColorToHex(color));
                    }
                } else if (sGradienttype.equals("radial")) {
                    rectElement4.setAttribute("fill", "url(#" + radialGradientid + ")");
                } else {
                    rectElement4.setAttribute("fill", "url(#" + linearGradientid + ")");
                }
                rectElement4.setAttribute("stroke", Tools.ColorToHex(lineColor));
                rectElement4.setAttribute("stroke-width", (double)linesize * this.rate < 1.0 ? "1" : String.valueOf((int)((double)linesize * this.rate + 1.0)));
                rectElement4.setAttribute("clip-path", "url(#" + clipPathid + ")");
                rectElement4.setAttribute("clip-rule", "evenodd");
                rectElement4.setAttribute("preserveAspectRatio", "xMaxYMax slice");
                rotateElement.addContent(rectElement4);
                rectElement5 = new Element("rect");
                rectElement5.setAttribute("x", String.valueOf((double)((float)startx) + this.canvasWide / 2.0));
                rectElement5.setAttribute("y", String.valueOf((double)((float)starty) + this.canvasHigh / 2.0));
                rectElement5.setAttribute("width", String.valueOf((float)width));
                rectElement5.setAttribute("height", String.valueOf((float)height));
                rectElement5.setAttribute("rx", String.valueOf((double)((float)radius) / 2.0));
                rectElement5.setAttribute("ry", String.valueOf((double)((float)radius) / 2.0));
                rectElement5.setAttribute("fill", "none");
                rectElement5.setAttribute("stroke", Tools.ColorToHex(lineColor));
                if (bdash) {
                    rectElement5.setAttribute("stroke-dasharray", "3");
                }
                rectElement5.setAttribute("stroke-width", (double)linesize * this.rate < 1.0 ? "1" : String.valueOf((int)((double)linesize * this.rate + 1.0)));
                rectElement5.setAttribute("transform", "translate(" + (centerx + this.canvasWide / 2.0) + "," + (centery + this.canvasHigh / 2.0) + ") " + "rotate(" + rotateAngle + ") " + "translate(-" + (centerx + this.canvasWide / 2.0) + ",-" + (centery + this.canvasHigh / 2.0) + ") ");
                rotateElement.addContent(rectElement5);
                svgElement.addContent(rotateElement);
            }
        } else if (shape.equals("Cylinder")) {
            double circleShortDiameter = 20.0;
            double llen = 10.0;
            if (com != null) {
                String[] arrPro = pr.getParameter().split(DELIMIT);
                int proteinStart = Integer.parseInt(arrPro[0]);
                int proteinEnd = Integer.parseInt(arrPro[2]);
                llen = (proteinEnd - proteinStart) / 20;
            }
            circleShortDiameter = llen <= 5.0 ? llen : 5.0;
            circleShortDiameter *= this.rate;
            ++this.svgID;
            String clipPathid2 = "SVGID_" + this.svgID + "_";
            Element clipPathElement2 = (Element)clipPathElement.clone();
            clipPathElement2.setAttribute("id", clipPathid2);
            Element circleElement = new Element("ellipse");
            double rx = (int)(circleShortDiameter / 2.0);
            double ry = (endy - starty) / 2.0;
            circleElement.setAttribute("cx", String.valueOf((double)((float)startx) + this.canvasWide / 2.0 + (double)((float)(circleShortDiameter / 2.0))));
            circleElement.setAttribute("cy", String.valueOf((double)((float)starty) + this.canvasHigh / 2.0 + (double)((float)ry)));
            circleElement.setAttribute("rx", String.valueOf((float)(circleShortDiameter / 2.0)));
            circleElement.setAttribute("ry", String.valueOf((float)ry));
            circleElement.setAttribute("fill", "none");
            circleElement.setAttribute("stroke", "none");
            circleElement.setAttribute("stroke-width", "0");
            circleElement.setAttribute("transform", "translate(" + (centerx + this.canvasWide / 2.0) + "," + (centery + this.canvasHigh / 2.0) + ") " + "rotate(" + rotateAngle + ") " + "translate(-" + (centerx + this.canvasWide / 2.0) + ",-" + (centery + this.canvasHigh / 2.0) + ") ");
            clipPathElement.addContent(circleElement);
            Element polygonElement = new Element("path");
            String d = "";
            d = "M" + ((double)((float)startx) + circleShortDiameter / 2.0 + this.canvasWide / 2.0) + " " + ((double)((float)endy) + this.canvasHigh / 2.0) + " L" + ((double)((float)endx) - circleShortDiameter / 2.0 + this.canvasWide / 2.0) + " " + ((double)((float)endy) + this.canvasHigh / 2.0) + " a" + (double)((float)circleShortDiameter) / 2.0 + " " + (double)((float)(endy - starty)) / 2.0 + "  0 1,0  " + "0,-" + (float)(endy - starty) + " " + " L" + ((double)((float)startx) + circleShortDiameter / 2.0 + this.canvasWide / 2.0) + " " + ((double)((float)starty) + this.canvasHigh / 2.0) + " L" + ((double)((float)startx) + circleShortDiameter / 2.0 + this.canvasWide / 2.0) + " " + ((double)((float)endy) + this.canvasHigh / 2.0);
            polygonElement.setAttribute("d", d);
            polygonElement.setAttribute("fill", "none");
            polygonElement.setAttribute("stroke", "none");
            polygonElement.setAttribute("stroke-width", "0");
            polygonElement.setAttribute("transform", "translate(" + (centerx + this.canvasWide / 2.0) + "," + (centery + this.canvasHigh / 2.0) + ") " + "rotate(" + rotateAngle + ") " + "translate(-" + (centerx + this.canvasWide / 2.0) + ",-" + (centery + this.canvasHigh / 2.0) + ") ");
            clipPathElement2.addContent(polygonElement);
            if (texturefile.equals("00000_1.jpg")) {
                rotateElement.addContent(clipPathElement);
                rotateElement.addContent(clipPathElement2);
                this.drawCrystal(bnewminx, bnewminy, bnewmaxx, bnewmaxy, color, clipPathid, svgElement);
                this.drawCrystal(bnewminx, bnewminy, bnewmaxx, bnewmaxy, color, clipPathid2, svgElement);
            } else if (texturefile.equals("00001.jpg") || texturefile.equals("00001_d.jpg") || texturefile.equals("00002.jpg") || texturefile.equals("00002_d.jpg") || texturefile.equals("00003.jpg") || texturefile.equals("00003_d.jpg") || texturefile.equals("00004.jpg") || texturefile.equals("00004_d.jpg") || texturefile.equals("00005.jpg") || texturefile.equals("00005_d.jpg") || texturefile.equals("00006.jpg") || texturefile.equals("00006_d.jpg")) {
                rotateElement.addContent(clipPathElement);
                rotateElement.addContent(clipPathElement2);
                Element rectElement3 = new Element("rect");
                rectElement3.setAttribute("x", String.valueOf((double)((float)bnewminx) + this.canvasWide / 2.0));
                rectElement3.setAttribute("y", String.valueOf((double)((float)bnewminy) + this.canvasHigh / 2.0));
                double width2 = bnewmaxx - bnewminx;
                double height2 = bnewmaxy - bnewminy;
                rectElement3.setAttribute("width", String.valueOf((float)width2));
                rectElement3.setAttribute("height", String.valueOf((float)height2));
                rectElement3.setAttribute("rx", String.valueOf((double)((float)radius) / 2.0));
                rectElement3.setAttribute("ry", String.valueOf((double)((float)radius) / 2.0));
                if (sGradient.equals("Null")) {
                    if (texturefile.equals("00000_0.jpg")) {
                        rectElement3.setAttribute("fill", "none");
                    } else {
                        rectElement3.setAttribute("fill", Tools.ColorToHex(color));
                    }
                } else if (sGradienttype.equals("radial")) {
                    rectElement3.setAttribute("fill", "url(#" + radialGradientid + ")");
                } else {
                    rectElement3.setAttribute("fill", "url(#" + linearGradientid + ")");
                }
                rectElement3.setAttribute("stroke", Tools.ColorToHex(lineColor));
                rectElement3.setAttribute("stroke-width", (double)linesize * this.rate < 1.0 ? "1" : String.valueOf((int)((double)linesize * this.rate + 1.0)));
                rectElement3.setAttribute("clip-path", "url(#" + clipPathid + ")");
                rectElement3.setAttribute("clip-rule", "evenodd");
                rectElement3.setAttribute("preserveAspectRatio", "xMaxYMax slice");
                rotateElement.addContent(rectElement3);
                Element rectElement33 = (Element)rectElement3.clone();
                rectElement33.setAttribute("clip-path", "url(#" + clipPathid2 + ")");
                rotateElement.addContent(rectElement33);
                this.drawPolygonTextureLine(bnewminx, bnewminy, bnewmaxx, bnewmaxy, texturefile, Color.BLACK, shape.toString(), linesize, clipPathid, svgElement);
                this.drawPolygonTextureLine(bnewminx, bnewminy, bnewmaxx, bnewmaxy, texturefile, Color.BLACK, shape.toString(), linesize, clipPathid2, svgElement);
            } else if (!texturefile.equals("00000_0.jpg")) {
                rotateElement.addContent(clipPathElement);
                rotateElement.addContent(clipPathElement2);
                rotateElement.addContent(imagePathElement);
                Element imagePathElement2 = (Element)imagePathElement.clone();
                imagePathElement2.setAttribute("clip-path", "url(#" + clipPathid2 + ")");
                rotateElement.addContent(imagePathElement2);
            } else if (texturefile.equals("00000_0.jpg")) {
                rotateElement.addContent(clipPathElement);
                rotateElement.addContent(clipPathElement2);
                Element rectElement4 = new Element("rect");
                rectElement4.setAttribute("x", String.valueOf((double)((float)bnewminx) + this.canvasWide / 2.0));
                rectElement4.setAttribute("y", String.valueOf((double)((float)bnewminy) + this.canvasHigh / 2.0));
                double width4 = bnewmaxx - bnewminx;
                double height4 = bnewmaxy - bnewminy;
                rectElement4.setAttribute("width", String.valueOf((float)width4));
                rectElement4.setAttribute("height", String.valueOf((float)height4));
                rectElement4.setAttribute("rx", String.valueOf((double)((float)radius) / 2.0));
                rectElement4.setAttribute("ry", String.valueOf((double)((float)radius) / 2.0));
                if (sGradient.equals("Null")) {
                    if (!texturefile.equals("00000_0.jpg")) {
                        rectElement4.setAttribute("fill", "none");
                    } else {
                        rectElement4.setAttribute("fill", Tools.ColorToHex(color));
                    }
                } else if (sGradienttype.equals("radial")) {
                    rectElement4.setAttribute("fill", "url(#" + radialGradientid + ")");
                } else {
                    rectElement4.setAttribute("fill", "url(#" + linearGradientid + ")");
                }
                rectElement4.setAttribute("stroke", Tools.ColorToHex(lineColor));
                rectElement4.setAttribute("stroke-width", (double)linesize * this.rate < 1.0 ? "1" : String.valueOf((int)((double)linesize * this.rate + 1.0)));
                rectElement4.setAttribute("clip-path", "url(#" + clipPathid + ")");
                rectElement4.setAttribute("clip-rule", "evenodd");
                rectElement4.setAttribute("preserveAspectRatio", "xMaxYMax slice");
                rotateElement.addContent(rectElement4);
                Element rectElement43 = (Element)rectElement4.clone();
                rectElement43.setAttribute("clip-path", "url(#" + clipPathid2 + ")");
                rotateElement.addContent(rectElement43);
            }
            Element circleElement2 = new Element("ellipse");
            circleElement2.setAttribute("cx", String.valueOf((double)((float)startx) + this.canvasWide / 2.0 + (double)((float)(circleShortDiameter / 2.0))));
            circleElement2.setAttribute("cy", String.valueOf((double)((float)starty) + this.canvasHigh / 2.0 + (double)((float)ry)));
            circleElement2.setAttribute("rx", String.valueOf((float)(circleShortDiameter / 2.0)));
            circleElement2.setAttribute("ry", String.valueOf((float)ry));
            circleElement2.setAttribute("fill", "none");
            circleElement2.setAttribute("stroke", Tools.ColorToHex(lineColor));
            circleElement2.setAttribute("stroke-width", (double)linesize * this.rate < 1.0 ? "1" : String.valueOf((int)((double)linesize * this.rate + 1.0)));
            if (bdash) {
                circleElement2.setAttribute("stroke-dasharray", "3");
            }
            circleElement2.setAttribute("transform", "translate(" + (centerx + this.canvasWide / 2.0) + "," + (centery + this.canvasHigh / 2.0) + ") " + "rotate(" + rotateAngle + ") " + "translate(-" + (centerx + this.canvasWide / 2.0) + ",-" + (centery + this.canvasHigh / 2.0) + ") ");
            rotateElement.addContent(circleElement2);
            Element polygonElement2 = new Element("path");
            String d2 = "";
            d2 = "M" + ((double)((float)startx) + circleShortDiameter / 2.0 + this.canvasWide / 2.0) + " " + ((double)((float)endy) + this.canvasHigh / 2.0) + " L" + ((double)((float)endx) - circleShortDiameter / 2.0 + this.canvasWide / 2.0) + " " + ((double)((float)endy) + this.canvasHigh / 2.0) + " a" + (double)((float)circleShortDiameter) / 2.0 + " " + (double)((float)(endy - starty)) / 2.0 + "  0 1,0  " + "0,-" + (float)(endy - starty) + " " + " L" + ((double)((float)startx) + circleShortDiameter / 2.0 + this.canvasWide / 2.0) + " " + ((double)((float)starty) + this.canvasHigh / 2.0);
            polygonElement2.setAttribute("d", d2);
            polygonElement2.setAttribute("fill", "none");
            polygonElement2.setAttribute("stroke", Tools.ColorToHex(lineColor));
            polygonElement2.setAttribute("stroke-width", (double)linesize * this.rate < 1.0 ? "1" : String.valueOf((int)((double)linesize * this.rate + 1.0)));
            if (bdash) {
                polygonElement2.setAttribute("stroke-dasharray", "3");
            }
            polygonElement2.setAttribute("transform", "translate(" + (centerx + this.canvasWide / 2.0) + "," + (centery + this.canvasHigh / 2.0) + ") " + "rotate(" + rotateAngle + ") " + "translate(-" + (centerx + this.canvasWide / 2.0) + ",-" + (centery + this.canvasHigh / 2.0) + ") ");
            rotateElement.addContent(polygonElement2);
            svgElement.addContent(rotateElement);
            this.drawPolygonTextureLine(bnewminx, bnewminy, bnewmaxx, bnewmaxy, texturefile, Color.BLACK, shape.toString(), linesize, clipPathid, svgElement);
            this.drawPolygonTextureLine(bnewminx, bnewminy, bnewmaxx, bnewmaxy, texturefile, Color.BLACK, shape.toString(), linesize, clipPathid2, svgElement);
        } else {
            Element polygonElement = new Element("polygon");
            String points = "";
            for (int i = 0; i < px.length; ++i) {
                points = points + (int)Math.round((double)px[i] + this.canvasWide / 2.0) + "," + (int)Math.round((double)py[i] + this.canvasHigh / 2.0) + " ";
            }
            polygonElement.setAttribute("points", points);
            polygonElement.setAttribute("fill", "none");
            polygonElement.setAttribute("stroke", Tools.ColorToHex(lineColor));
            polygonElement.setAttribute("stroke-width", (double)linesize * this.rate < 1.0 ? "1" : String.valueOf((int)((double)linesize * this.rate + 1.0)));
            polygonElement.setAttribute("transform", "translate(" + (centerx + this.canvasWide / 2.0) + "," + (int)Math.round(centery + this.canvasHigh / 2.0) + ") " + "rotate(" + rotateAngle + ") " + "translate(-" + (centerx + this.canvasWide / 2.0) + ",-" + (int)Math.round(centery + this.canvasHigh / 2.0) + ") ");
            if (texturefile.equals("00000_1.jpg")) {
                clipPathElement.addContent(polygonElement);
                rotateElement.addContent(clipPathElement);
            } else if (texturefile.equals("00001.jpg") || texturefile.equals("00001_d.jpg") || texturefile.equals("00002.jpg") || texturefile.equals("00002_d.jpg") || texturefile.equals("00003.jpg") || texturefile.equals("00003_d.jpg") || texturefile.equals("00004.jpg") || texturefile.equals("00004_d.jpg") || texturefile.equals("00005.jpg") || texturefile.equals("00005_d.jpg") || texturefile.equals("00006.jpg") || texturefile.equals("00006_d.jpg")) {
                clipPathElement.addContent(polygonElement);
                rotateElement.addContent(clipPathElement);
                Element rectElement3 = new Element("rect");
                rectElement3.setAttribute("x", String.valueOf((double)((float)bnewminx) + this.canvasWide / 2.0));
                rectElement3.setAttribute("y", String.valueOf((double)((float)bnewminy) + this.canvasHigh / 2.0));
                double width2 = bnewmaxx - bnewminx;
                double height2 = bnewmaxy - bnewminy;
                rectElement3.setAttribute("width", String.valueOf((float)width2));
                rectElement3.setAttribute("height", String.valueOf((float)height2));
                rectElement3.setAttribute("rx", String.valueOf((double)((float)radius) / 2.0));
                rectElement3.setAttribute("ry", String.valueOf((double)((float)radius) / 2.0));
                if (sGradient.equals("Null")) {
                    if (texturefile.equals("00000_0.jpg")) {
                        rectElement3.setAttribute("fill", "none");
                    } else {
                        rectElement3.setAttribute("fill", Tools.ColorToHex(color));
                    }
                } else if (sGradienttype.equals("radial")) {
                    rectElement3.setAttribute("fill", "url(#" + radialGradientid + ")");
                } else {
                    rectElement3.setAttribute("fill", "url(#" + linearGradientid + ")");
                }
                rectElement3.setAttribute("stroke", Tools.ColorToHex(lineColor));
                rectElement3.setAttribute("stroke-width", (double)linesize * this.rate < 1.0 ? "1" : String.valueOf((int)((double)linesize * this.rate + 1.0)));
                rectElement3.setAttribute("clip-path", "url(#" + clipPathid + ")");
                rectElement3.setAttribute("clip-rule", "evenodd");
                rectElement3.setAttribute("preserveAspectRatio", "xMaxYMax slice");
                rotateElement.addContent(rectElement3);
            } else if (!texturefile.equals("00000_0.jpg")) {
                clipPathElement.addContent(polygonElement);
                rotateElement.addContent(clipPathElement);
                rotateElement.addContent(imagePathElement);
            } else if (texturefile.equals("00000_0.jpg")) {
                clipPathElement.addContent(polygonElement);
                rotateElement.addContent(clipPathElement);
                Element rectElement4 = new Element("rect");
                rectElement4.setAttribute("x", String.valueOf((double)((float)bnewminx) + this.canvasWide / 2.0));
                rectElement4.setAttribute("y", String.valueOf((double)((float)bnewminy) + this.canvasHigh / 2.0));
                double width4 = bnewmaxx - bnewminx;
                double height4 = bnewmaxy - bnewminy;
                rectElement4.setAttribute("width", String.valueOf((float)width4));
                rectElement4.setAttribute("height", String.valueOf((float)height4));
                rectElement4.setAttribute("rx", String.valueOf((double)((float)radius) / 2.0));
                rectElement4.setAttribute("ry", String.valueOf((double)((float)radius) / 2.0));
                if (sGradient.equals("Null")) {
                    if (!texturefile.equals("00000_0.jpg")) {
                        rectElement4.setAttribute("fill", "none");
                    } else {
                        rectElement4.setAttribute("fill", Tools.ColorToHex(color));
                    }
                } else if (sGradienttype.equals("radial")) {
                    rectElement4.setAttribute("fill", "url(#" + radialGradientid + ")");
                } else {
                    rectElement4.setAttribute("fill", "url(#" + linearGradientid + ")");
                }
                rectElement4.setAttribute("stroke", Tools.ColorToHex(lineColor));
                rectElement4.setAttribute("stroke-width", (double)linesize * this.rate < 1.0 ? "1" : String.valueOf((int)((double)linesize * this.rate + 1.0)));
                rectElement4.setAttribute("clip-path", "url(#" + clipPathid + ")");
                rectElement4.setAttribute("clip-rule", "evenodd");
                rectElement4.setAttribute("preserveAspectRatio", "xMaxYMax slice");
                rotateElement.addContent(rectElement4);
            }
            svgElement.addContent(rotateElement);
            if (texturefile.equals("00000_1.jpg")) {
                this.drawCrystal(bnewminx, (int)Math.round(bnewminy - 10.0), bnewmaxx, (int)Math.round(bnewmaxy + 10.0), color, clipPathid, svgElement);
            } else if (texturefile.equals("00001.jpg") || texturefile.equals("00001_d.jpg") || texturefile.equals("00002.jpg") || texturefile.equals("00002_d.jpg") || texturefile.equals("00003.jpg") || texturefile.equals("00003_d.jpg") || texturefile.equals("00004.jpg") || texturefile.equals("00004_d.jpg") || texturefile.equals("00005.jpg") || texturefile.equals("00005_d.jpg") || texturefile.equals("00006.jpg") || texturefile.equals("00006_d.jpg")) {
                this.drawPolygonTextureLine(bnewminx, bnewminy, bnewmaxx, bnewmaxy, texturefile, Color.BLACK, shape.toString(), linesize, clipPathid, svgElement);
            }
            if (!isdrawprotein) {
                Element polygonLineElement = new Element("path");
                String ds = "";
                ds = "M" + ((double)px[0] + this.canvasWide / 2.0) + "," + (int)Math.round((double)py[0] + this.canvasHigh / 2.0) + " ";
                for (int i = 0; i < px.length; ++i) {
                    ds = ds + "L" + ((double)px[i] + this.canvasWide / 2.0) + "," + (int)Math.round((double)py[i] + this.canvasHigh / 2.0) + " ";
                }
                ds = ds + "Z";
                polygonLineElement.setAttribute("d", ds);
                polygonLineElement.setAttribute("fill", "none");
                polygonLineElement.setAttribute("stroke", Tools.ColorToHex(lineColor));
                if (bdash) {
                    polygonLineElement.setAttribute("stroke-dasharray", "3");
                }
                polygonLineElement.setAttribute("stroke-width", (double)linesize * this.rate < 1.0 ? "1" : String.valueOf((int)((double)linesize * this.rate + 1.0)));
                polygonLineElement.setAttribute("transform", "translate(" + (centerx + this.canvasWide / 2.0) + "," + (centery + this.canvasHigh / 2.0) + ") " + "rotate(" + rotateAngle + ") " + "translate(-" + (centerx + this.canvasWide / 2.0) + ",-" + (centery + this.canvasHigh / 2.0) + ") ");
                svgElement.addContent(polygonLineElement);
            }
        }
        if (com != null && com.getShapeType() == ShapeEnum.Cylinder && com.getType() == ComponentEnum.Domain) {
            String[] arrPro = pr.getParameter().split(DELIMIT);
            int proteinStart = Integer.parseInt(arrPro[0]);
            int proteinEnd = Integer.parseInt(arrPro[2]);
            int proteinHeight = Integer.parseInt(arrPro[4]);
            double llen = (proteinEnd - proteinStart) / 20;
            GradientEnum pGradientType = GradientEnum.valueOf(arrPro[6]);
            String pSelectTextureFile = arrPro[7];
            double vertical = -1 * pr.getVertical();
            double startpX = (-this.HALF_LENGTH + (double)pr.getHorizontal() + (double)proteinStart * this.LENGTH_RATE) * this.rate;
            double endpX = (-this.HALF_LENGTH + (double)pr.getHorizontal() + (double)proteinEnd * this.LENGTH_RATE) * this.rate;
            double centerpX = (endx - startx) / 2.0;
            double startpY = (vertical - this.HALF_HEIGHT) * this.rate;
            double endpY = (vertical + this.HALF_HEIGHT) * this.rate;
            int pstrokesize = Integer.valueOf(arrPro[9]);
            double circleShortDiameter = 20.0;
            circleShortDiameter = llen <= 5.0 ? llen : 5.0;
            String proteinColorLineStr = arrPro[10];
            StringTokenizer ster = new StringTokenizer(proteinColorLineStr, ",");
            Color proteinLineColor = new Color(Integer.parseInt(ster.nextToken()), Integer.parseInt(ster.nextToken()), Integer.parseInt(ster.nextToken()));
            this.drawSVGPrevCylinder(startx, circleShortDiameter *= this.rate, (int)startpX, (int)startpY, (int)endpX, (int)endpY, pSelectTextureFile, this.getGrayColor(pr.getColor()), this.getGrayColor(proteinLineColor), pGradientType.name().toString(), pstrokesize, newSVGFilePath, svgElement);
            double perCentDiam = 0.5;
            double litllerDiameter = circleShortDiameter * perCentDiam;
            double littlerCenterX = startx + circleShortDiameter / 2.0;
            double littlerCenterY = startpY + (endpY - startpY) / 2.0;
            double cx1 = littlerCenterX - litllerDiameter / 2.0;
            double cy1 = littlerCenterY - this.HALF_HEIGHT * this.rate;
            double cw1 = litllerDiameter / 2.0;
            double ch1 = this.HALF_HEIGHT * this.rate * 2.0;
            Element circleElement6 = new Element("path");
            String d6 = " M" + (startx + this.canvasWide / 2.0 + circleShortDiameter / 2.0) + " " + (littlerCenterY + ch1 / 2.0 + this.canvasHigh / 2.0) + " a" + cw1 + " " + ch1 / 2.0 + "  0 0,0  " + "0,-" + ch1;
            circleElement6.setAttribute("d", d6);
            circleElement6.setAttribute("fill", "none");
            circleElement6.setAttribute("stroke", Tools.ColorToHex(lineColor));
            circleElement6.setAttribute("stroke-width", (double)pstrokesize * this.rate < 1.0 ? "1" : String.valueOf((int)((double)pstrokesize * this.rate + 1.0)));
            svgElement.addContent(circleElement6);
            Element polygonLineElement22 = new Element("path");
            String ds22 = "";
            ds22 = "M" + (startx - (double)linesize * this.rate + this.canvasWide / 2.0) + "," + (cy1 + this.canvasHigh / 2.0) + " " + "L" + (littlerCenterX + this.canvasWide / 2.0) + "," + (cy1 + this.canvasHigh / 2.0) + " ";
            polygonLineElement22.setAttribute("d", ds22);
            polygonLineElement22.setAttribute("fill", "none");
            polygonLineElement22.setAttribute("stroke", Tools.ColorToHex(lineColor));
            polygonLineElement22.setAttribute("stroke-width", (double)pstrokesize * this.rate < 1.0 ? "1" : String.valueOf((int)((double)pstrokesize * this.rate + 1.0)));
            svgElement.addContent(polygonLineElement22);
            Element polygonLineElement23 = new Element("path");
            String ds23 = "";
            ds23 = "M" + (startx - (double)linesize * this.rate + this.canvasWide / 2.0) + "," + (cy1 + ch1 + this.canvasHigh / 2.0) + " " + "L" + (littlerCenterX + this.canvasWide / 2.0) + "," + (cy1 + ch1 + this.canvasHigh / 2.0) + " ";
            polygonLineElement23.setAttribute("d", ds23);
            polygonLineElement23.setAttribute("fill", "none");
            polygonLineElement23.setAttribute("stroke", Tools.ColorToHex(lineColor));
            polygonLineElement23.setAttribute("stroke-width", (double)pstrokesize * this.rate < 1.0 ? "1" : String.valueOf((int)((double)pstrokesize * this.rate + 1.0)));
            svgElement.addContent(polygonLineElement23);
        }
        g2d.setFont(new Font("Arial", 1, (int)((double)fontsize * this.rate)));
        if (nameDrawType.equals("Up")) {
            this.drawSVGText((int)((double)fontsize * this.rate), (float)(centerx - (double)g2d.getFontMetrics().stringWidth(text) / 2.0), (float)(bnewminy + 20.0 - 5.0 - (double)g2d.getFontMetrics().getLeading() - (double)g2d.getFontMetrics().getDescent()), textColor, text, svgElement);
        } else if (nameDrawType.equals("Center")) {
            this.drawSVGText((int)((double)fontsize * this.rate), (float)(centerx - (double)g2d.getFontMetrics().stringWidth(text) / 2.0), (float)(centery + (double)g2d.getFontMetrics().getHeight() / 4.0), textColor, text, svgElement);
        } else if (nameDrawType.equals("Down")) {
            this.drawSVGText((int)((double)fontsize * this.rate), (float)(centerx - (double)g2d.getFontMetrics().stringWidth(text) / 2.0), (float)(bnewmaxy - 20.0 + 5.0 + (double)g2d.getFontMetrics().getLeading() + (double)g2d.getFontMetrics().getAscent()), textColor, text, svgElement);
        } else if (nameDrawType.equals("Hide")) {
            // empty if block
        }
    }

    public void drawSVGPrevCylinder(double comStartX, double circleShortDiameter, int startx, int starty, int endx, int endy, String texturefile, Color color, Color lineColor, String sGradient, int linesize, String newSVGFilePath, Element svgElement) {
        Element stop2;
        double bnewminx = startx - 20;
        double bnewminy = starty - 20;
        double bnewmaxx = endx + 20;
        double bnewmaxy = endy + 20;
        double centerx = 0.0;
        double centery = 0.0;
        centerx = (double)startx + (double)(endx - startx) / 2.0;
        centery = (double)starty + (double)(endy - starty) / 2.0;
        Element rotateElement = new Element("g");
        double rotateAngle = 0.0;
        rotateElement.setAttribute("transform", "rotate(0) ");
        double radius = 10.0;
        String lgx1 = "";
        String lgy1 = "";
        String lgx2 = "";
        String lgy2 = "";
        if (sGradient.equals("Down")) {
            lgx1 = "0%";
            lgy1 = "0%";
            lgx2 = "0%";
            lgy2 = "100%";
        } else if (sGradient.equals("Left")) {
            lgx1 = "100%";
            lgy1 = "0%";
            lgx2 = "0%";
            lgy2 = "0%";
        } else if (sGradient.equals("Up")) {
            lgx1 = "0%";
            lgy1 = "100%";
            lgx2 = "0%";
            lgy2 = "0%";
        } else if (sGradient.equals("Right")) {
            lgx1 = "0%";
            lgy1 = "0%";
            lgx2 = "100%";
            lgy2 = "0%";
        } else if (sGradient.equals("Top_left_to_bottom_right")) {
            lgx1 = "0%";
            lgy1 = "0%";
            lgx2 = "100%";
            lgy2 = "100%";
        } else if (sGradient.equals("Bottom_left_to_top_right")) {
            lgx1 = "0%";
            lgy1 = "100%";
            lgx2 = "100%";
            lgy2 = "0%";
        } else if (sGradient.equals("Bottom_right_to_top_left")) {
            lgx1 = "100%";
            lgy1 = "100%";
            lgx2 = "0%";
            lgy2 = "0%";
        } else if (sGradient.equals("Top_right_to_bottom_left")) {
            lgx1 = "100%";
            lgy1 = "0%";
            lgx2 = "0%";
            lgy2 = "100%";
        } else if (sGradient.equals("Horizontal")) {
            lgx1 = "0%";
            lgy1 = "0%";
            lgx2 = "0%";
            lgy2 = "100%";
        } else if (sGradient.equals("Vertical")) {
            lgx1 = "0%";
            lgy1 = "0%";
            lgx2 = "100%";
            lgy2 = "0%";
        } else if (sGradient.equals("Horizontal")) {
            lgx1 = "0%";
            lgy1 = "0%";
            lgx2 = "0%";
            lgy2 = "100%";
        } else {
            lgx1 = "0%";
            lgy1 = "0%";
            lgx2 = "0%";
            lgy2 = "0%";
        }
        ++this.svgID;
        Element linearGradientElement = new Element("linearGradient");
        String linearGradientid = "SVGID_" + this.svgID + "_";
        linearGradientElement.setAttribute("id", linearGradientid);
        ++this.svgID;
        linearGradientElement.setAttribute("x1", lgx1);
        linearGradientElement.setAttribute("y1", lgy1);
        linearGradientElement.setAttribute("x2", lgx2);
        linearGradientElement.setAttribute("y2", lgy2);
        Element radialGradientElement = new Element("radialGradient");
        String radialGradientid = "SVGID_" + this.svgID + "_";
        radialGradientElement.setAttribute("id", radialGradientid);
        ++this.svgID;
        radialGradientElement.setAttribute("gradientUnits", "userSpaceOnUse");
        double cx = 0.0;
        double cy = 0.0;
        double r = 0.0;
        cx = (double)startx + (double)(endx - startx) / 2.0 + this.canvasWide / 2.0;
        cy = (double)starty + (double)(endy - starty) / 2.0 + this.canvasHigh / 2.0;
        r = ((double)Math.abs(endx - startx) / 2.0 + (double)Math.abs(endy - starty) / 2.0) / 2.0;
        radialGradientElement.setAttribute("cx", String.valueOf(cx));
        radialGradientElement.setAttribute("cy", String.valueOf(cy));
        radialGradientElement.setAttribute("r", String.valueOf(r));
        Element stop1 = new Element("stop"){};
        String sGradienttype = sGradient;
        if (sGradient.equals("Horizontal") || sGradient.equals("Vertical") || sGradient.equals("Horizontal")) {
            stop1.setAttribute("offset", "0%");
            stop1.setAttribute("style", "stop-color:" + Tools.ColorToHex(color));
            linearGradientElement.addContent(stop1);
            stop2 = new Element("stop");
            stop2.setAttribute("offset", "50%");
            stop2.setAttribute("style", "stop-color:#FFFFFF");
            linearGradientElement.addContent(stop2);
            Element stop3 = new Element("stop");
            stop3.setAttribute("offset", "100%");
            stop3.setAttribute("style", "stop-color:" + Tools.ColorToHex(color));
            linearGradientElement.addContent(stop3);
            svgElement.addContent(linearGradientElement);
            sGradienttype = "line";
        } else if (sGradient.equals("Center")) {
            stop1.setAttribute("offset", "0%");
            stop1.setAttribute("style", "stop-color:#FFFFFF");
            radialGradientElement.addContent(stop1);
            stop2 = new Element("stop");
            stop2.setAttribute("offset", "100%");
            stop2.setAttribute("style", "stop-color:" + Tools.ColorToHex(color));
            radialGradientElement.addContent(stop2);
            svgElement.addContent(radialGradientElement);
            sGradienttype = "radial";
        } else if (sGradient.equals("Center_to_Border")) {
            stop1.setAttribute("offset", "0%");
            stop1.setAttribute("style", "stop-color:" + Tools.ColorToHex(color));
            radialGradientElement.addContent(stop1);
            stop2 = new Element("stop");
            stop2.setAttribute("offset", "100%");
            stop2.setAttribute("style", "stop-color:#FFFFFF");
            radialGradientElement.addContent(stop2);
            svgElement.addContent(radialGradientElement);
            sGradienttype = "radial";
        } else {
            stop1.setAttribute("offset", "0%");
            stop1.setAttribute("style", "stop-color:" + Tools.ColorToHex(color));
            linearGradientElement.addContent(stop1);
            stop2 = new Element("stop");
            stop2.setAttribute("offset", "100%");
            stop2.setAttribute("style", "stop-color:#FFFFFF");
            linearGradientElement.addContent(stop2);
            svgElement.addContent(linearGradientElement);
            sGradienttype = "line";
        }
        if (!(texturefile.equals("00000_0.jpg") || texturefile.equals("00000_1.jpg") || texturefile.equals("00001.jpg") || texturefile.equals("00001_d.jpg") || texturefile.equals("00002.jpg") || texturefile.equals("00002_d.jpg") || texturefile.equals("00002.jpg") || texturefile.equals("00002_d.jpg") || texturefile.equals("00003.jpg") || texturefile.equals("00003_d.jpg") || texturefile.equals("00004.jpg") || texturefile.equals("00004_d.jpg") || texturefile.equals("00005.jpg") || texturefile.equals("00005_d.jpg") || texturefile.equals("00006.jpg") || texturefile.equals("00006_d.jpg"))) {
            this.copyTextureFile(this.SVGFilePathFull, texturefile);
        }
        Element clipPathElement = new Element("clipPath");
        String clipPathid = "SVGID_" + this.svgID + "_";
        clipPathElement.setAttribute("id", clipPathid);
        ++this.svgID;
        Element imagePathElement = new Element("image");
        imagePathElement.setAttribute("id", "SVGID_" + this.svgID + "_");
        ++this.svgID;
        imagePathElement.setAttribute("x", String.valueOf(0));
        imagePathElement.setAttribute("y", String.valueOf(0));
        imagePathElement.setAttribute("width", String.valueOf(this.canvasWide));
        imagePathElement.setAttribute("height", String.valueOf(this.canvasHigh));
        imagePathElement.setAttribute("xlink", newSVGFilePath + ".file\\" + texturefile);
        imagePathElement.setAttribute("clip-path", "url(#" + clipPathid + ")");
        imagePathElement.setAttribute("clip-rule", "evenodd");
        imagePathElement.setAttribute("preserveAspectRatio", "xMaxYMax slice");
        double perCentDiam = 0.5;
        double litllerDiameter = circleShortDiameter * perCentDiam;
        double littlerCenterX = comStartX + circleShortDiameter / 2.0;
        double littlerCenterY = (double)starty + (double)(endy - starty) / 2.0;
        double cx1 = littlerCenterX - litllerDiameter / 2.0;
        double cy1 = littlerCenterY - this.HALF_HEIGHT * this.rate;
        double cw1 = litllerDiameter / 2.0;
        double ch1 = this.HALF_HEIGHT * this.rate * 2.0;
        ++this.svgID;
        String clipPathid2 = "SVGID_" + this.svgID + "_";
        Element clipPathElement2 = (Element)clipPathElement.clone();
        clipPathElement2.setAttribute("id", clipPathid2);
        Element circleElement = new Element("ellipse");
        circleElement.setAttribute("cx", String.valueOf((double)((float)comStartX) + this.canvasWide / 2.0 + (double)((float)(circleShortDiameter / 2.0))));
        circleElement.setAttribute("cy", String.valueOf((float)(littlerCenterY + this.canvasHigh / 2.0)));
        circleElement.setAttribute("rx", String.valueOf((float)cw1));
        circleElement.setAttribute("ry", String.valueOf((double)((float)ch1) / 2.0));
        circleElement.setAttribute("fill", "none");
        circleElement.setAttribute("stroke", "none");
        circleElement.setAttribute("stroke-width", "0");
        clipPathElement.addContent(circleElement);
        Element rectElement55 = new Element("rect");
        rectElement55.setAttribute("x", String.valueOf((float)(comStartX - (double)linesize * this.rate + this.canvasWide / 2.0)));
        rectElement55.setAttribute("y", String.valueOf((float)(cy1 + this.canvasHigh / 2.0)));
        rectElement55.setAttribute("width", String.valueOf((float)(littlerCenterX - comStartX + (double)linesize * this.rate)));
        rectElement55.setAttribute("height", String.valueOf((float)ch1));
        rectElement55.setAttribute("rx", String.valueOf(0));
        rectElement55.setAttribute("ry", String.valueOf(0));
        rectElement55.setAttribute("fill", "none");
        rectElement55.setAttribute("stroke", "none");
        rectElement55.setAttribute("stroke-width", "0");
        clipPathElement2.addContent(rectElement55);
        if (texturefile.equals("00000_1.jpg")) {
            rotateElement.addContent(clipPathElement);
            rotateElement.addContent(clipPathElement2);
            this.drawCrystal(bnewminx, bnewminy, bnewmaxx, bnewmaxy, color, clipPathid, svgElement);
            this.drawCrystal(bnewminx, bnewminy, bnewmaxx, bnewmaxy, color, clipPathid2, svgElement);
        } else if (texturefile.equals("00001.jpg") || texturefile.equals("00001_d.jpg") || texturefile.equals("00002.jpg") || texturefile.equals("00002_d.jpg") || texturefile.equals("00003.jpg") || texturefile.equals("00003_d.jpg") || texturefile.equals("00004.jpg") || texturefile.equals("00004_d.jpg") || texturefile.equals("00005.jpg") || texturefile.equals("00005_d.jpg") || texturefile.equals("00006.jpg") || texturefile.equals("00006_d.jpg")) {
            rotateElement.addContent(clipPathElement);
            rotateElement.addContent(clipPathElement2);
            Element rectElement3 = new Element("rect");
            rectElement3.setAttribute("x", String.valueOf((double)((float)bnewminx) + this.canvasWide / 2.0));
            rectElement3.setAttribute("y", String.valueOf((double)((float)bnewminy) + this.canvasHigh / 2.0));
            double width2 = bnewmaxx - bnewminx;
            double height2 = bnewmaxy - bnewminy;
            rectElement3.setAttribute("width", String.valueOf((float)width2));
            rectElement3.setAttribute("height", String.valueOf((float)height2));
            rectElement3.setAttribute("rx", String.valueOf((float)radius / 2.0f));
            rectElement3.setAttribute("ry", String.valueOf((float)radius / 2.0f));
            if (sGradient.equals("Null")) {
                if (texturefile.equals("00000_0.jpg")) {
                    rectElement3.setAttribute("fill", "none");
                } else {
                    rectElement3.setAttribute("fill", Tools.ColorToHex(color));
                }
            } else if (sGradienttype.equals("radial")) {
                rectElement3.setAttribute("fill", "url(#" + radialGradientid + ")");
            } else {
                rectElement3.setAttribute("fill", "url(#" + linearGradientid + ")");
            }
            rectElement3.setAttribute("stroke", Tools.ColorToHex(lineColor));
            rectElement3.setAttribute("stroke-width", (double)linesize * this.rate < 1.0 ? "1" : String.valueOf((int)((double)linesize * this.rate + 1.0)));
            rectElement3.setAttribute("clip-path", "url(#" + clipPathid + ")");
            rectElement3.setAttribute("clip-rule", "evenodd");
            rectElement3.setAttribute("preserveAspectRatio", "xMaxYMax slice");
            rotateElement.addContent(rectElement3);
            Element rectElement33 = (Element)rectElement3.clone();
            rectElement33.setAttribute("clip-path", "url(#" + clipPathid2 + ")");
            rotateElement.addContent(rectElement33);
            this.drawPolygonTextureLine(bnewminx, bnewminy, bnewmaxx, bnewmaxy, texturefile, Color.BLACK, "Rectangle", linesize, clipPathid, svgElement);
        } else if (!texturefile.equals("00000_0.jpg")) {
            rotateElement.addContent(clipPathElement);
            rotateElement.addContent(clipPathElement2);
            rotateElement.addContent(imagePathElement);
            Element imagePathElement2 = (Element)imagePathElement.clone();
            imagePathElement2.setAttribute("clip-path", "url(#" + clipPathid2 + ")");
            rotateElement.addContent(imagePathElement2);
        } else if (texturefile.equals("00000_0.jpg")) {
            rotateElement.addContent(clipPathElement);
            rotateElement.addContent(clipPathElement2);
            Element rectElement4 = new Element("rect");
            rectElement4.setAttribute("x", String.valueOf((double)((float)bnewminx) + this.canvasWide / 2.0));
            rectElement4.setAttribute("y", String.valueOf((double)((float)bnewminy) + this.canvasHigh / 2.0));
            double width4 = bnewmaxx - bnewminx;
            double height4 = bnewmaxy - bnewminy;
            rectElement4.setAttribute("width", String.valueOf((float)width4));
            rectElement4.setAttribute("height", String.valueOf((float)height4));
            rectElement4.setAttribute("rx", String.valueOf((float)radius / 2.0f));
            rectElement4.setAttribute("ry", String.valueOf((float)radius / 2.0f));
            if (sGradient.equals("Null")) {
                if (!texturefile.equals("00000_0.jpg")) {
                    rectElement4.setAttribute("fill", "none");
                } else {
                    rectElement4.setAttribute("fill", Tools.ColorToHex(color));
                }
            } else if (sGradienttype.equals("radial")) {
                rectElement4.setAttribute("fill", "url(#" + radialGradientid + ")");
            } else {
                rectElement4.setAttribute("fill", "url(#" + linearGradientid + ")");
            }
            rectElement4.setAttribute("stroke", Tools.ColorToHex(lineColor));
            rectElement4.setAttribute("stroke-width", (double)linesize * this.rate < 1.0 ? "1" : String.valueOf((int)((double)linesize * this.rate + 1.0)));
            rectElement4.setAttribute("clip-path", "url(#" + clipPathid + ")");
            rectElement4.setAttribute("clip-rule", "evenodd");
            rectElement4.setAttribute("preserveAspectRatio", "xMaxYMax slice");
            rotateElement.addContent(rectElement4);
            Element rectElement43 = (Element)rectElement4.clone();
            rectElement43.setAttribute("clip-path", "url(#" + clipPathid2 + ")");
            rotateElement.addContent(rectElement43);
        }
        svgElement.addContent(rotateElement);
    }

    public void drawSVGNote(int vertical, int horizontal, String note, int deltaX, int deltaY, int size, String style, double angle, Color color, int linesize, Color colorline, boolean bdash, String strFont, Graphics2D g2d, Element svgElement) {
        String styleStr = "'ArialMT'";
        if (style.equals("Bold")) {
            g2d.setFont(new Font(strFont, 1, (int)((double)size * this.rate)));
            styleStr = "'Arial-BoldMT'";
        } else if (style.equals("Italic")) {
            g2d.setFont(new Font(strFont, 2, (int)((double)size * this.rate)));
            styleStr = "'Arial-ItalicMT'";
        } else if (style.equals("Plain")) {
            g2d.setFont(new Font(strFont, 0, (int)((double)size * this.rate)));
            styleStr = "'ArialMT'";
        } else if (style.equals("Bold_Italic")) {
            g2d.setFont(new Font(strFont, 3, (int)((double)size * this.rate)));
            styleStr = "'ArialNarrow-BoldItalic'";
        }
        double centralX = this.canvasWide / 2.0 + ((double)deltaX * this.LENGTH_RATE - this.HALF_LENGTH + (double)horizontal) * this.rate;
        double centralY = this.canvasHigh / 2.0 + (double)(-vertical - deltaY) * this.rate;
        if (strFont.equals("Arial")) {
            this.drawSVGText((int)((double)size * this.rate), centralX, centralY, color, styleStr, styleStr, angle, note, g2d, svgElement);
        } else {
            this.drawSVGText((int)((double)size * this.rate), centralX, centralY, color, strFont, styleStr, angle, note, g2d, svgElement);
        }
    }

    public void drawSVGSite(int vertical, int horizontal, String positionStr, int deltaX, int deltaY, int wide, int high, double angle, int size, boolean isShowPosition, Color color, String text, int fontsize, Color textColor, String nameDrawType, int linesize, Color lineColor, String texturefile, String newSVGFilePath, String shapeType, String sGradient, boolean bdash, Graphics2D g2d, Element svgElement) {
        vertical = -vertical;
        double centralX = 0.0;
        double centralY = 0.0;
        g2d.setFont(new Font("Arial", 1, (int)((double)size * this.rate)));
        StringTokenizer st = new StringTokenizer(positionStr, ";");
        int siteCount = st.countTokens();
        if (siteCount == 1) {
            int site = Integer.parseInt(st.nextToken());
            double siteX = -this.HALF_LENGTH + (double)horizontal + (double)site * this.LENGTH_RATE;
            centralX = ((double)deltaX * this.LENGTH_RATE - this.HALF_LENGTH + (double)horizontal) * this.rate;
            centralY = (double)(vertical - deltaY) * this.rate;
            if (deltaY >= 0) {
                this.drawSVGLine(siteX * this.rate, ((double)vertical - this.HALF_HEIGHT) * this.rate, siteX * this.rate, ((double)vertical - this.HALF_HEIGHT) * this.rate - (double)this.LINE_HEIGHT, false, svgElement);
                this.drawSVGLine(siteX * this.rate, ((double)vertical - this.HALF_HEIGHT) * this.rate - (double)this.LINE_HEIGHT, centralX, centralY, false, svgElement);
                if (isShowPosition) {
                    this.drawSVGText(this.positionFontSize, siteX * this.rate + 2.0, ((double)vertical - this.HALF_HEIGHT) * this.rate - (double)this.positionFontMetrics.getDescent(), String.valueOf(site), svgElement);
                }
                if (shapeType.equals("Null")) {
                    this.drawSVGText((int)((double)size * this.rate), centralX - (double)g2d.getFontMetrics().stringWidth(text) / 2.0, centralY - (double)g2d.getFontMetrics().getDescent(), textColor, text, svgElement);
                }
            } else {
                this.drawSVGLine(siteX * this.rate, ((double)vertical + this.HALF_HEIGHT) * this.rate, siteX * this.rate, ((double)vertical + this.HALF_HEIGHT) * this.rate + (double)this.LINE_HEIGHT, false, svgElement);
                this.drawSVGLine(siteX * this.rate, ((double)vertical + this.HALF_HEIGHT) * this.rate + (double)this.LINE_HEIGHT, centralX, centralY, false, svgElement);
                if (isShowPosition) {
                    this.drawSVGText(this.positionFontSize, siteX * this.rate + 2.0, ((double)vertical + this.HALF_HEIGHT) * this.rate + (double)this.positionFontMetrics.getAscent(), String.valueOf(site), svgElement);
                }
                if (shapeType.equals("Null")) {
                    this.drawSVGText((int)((double)size * this.rate), centralX - (double)g2d.getFontMetrics().stringWidth(text) / 2.0, centralY + (double)g2d.getFontMetrics().getAscent(), textColor, text, svgElement);
                }
            }
        } else if (siteCount == 2) {
            LinkedList<Integer> siteList = new LinkedList<Integer>();
            for (int i = 0; i < siteCount; ++i) {
                siteList.add(Integer.parseInt(st.nextToken()));
            }
            Collections.sort(siteList);
            int firstSite = Integer.parseInt(String.valueOf(siteList.getFirst()));
            int lastSite = Integer.parseInt(String.valueOf(siteList.getLast()));
            double firstSiteX = -this.HALF_LENGTH + (double)horizontal + (double)firstSite * this.LENGTH_RATE;
            double lastSiteX = -this.HALF_LENGTH + (double)horizontal + (double)lastSite * this.LENGTH_RATE;
            centralX = ((double)deltaX * this.LENGTH_RATE - this.HALF_LENGTH + (double)horizontal) * this.rate;
            centralY = (double)(vertical - deltaY) * this.rate;
            if (deltaY >= 0) {
                this.drawSVGLine(firstSiteX * this.rate, ((double)vertical - this.HALF_HEIGHT) * this.rate, firstSiteX * this.rate, ((double)vertical - this.HALF_HEIGHT) * this.rate - (double)this.LINE_HEIGHT, false, svgElement);
                this.drawSVGLine(lastSiteX * this.rate, ((double)vertical - this.HALF_HEIGHT) * this.rate, lastSiteX * this.rate, ((double)vertical - this.HALF_HEIGHT) * this.rate - (double)this.LINE_HEIGHT, false, svgElement);
                this.drawSVGLine(firstSiteX * this.rate, ((double)vertical - this.HALF_HEIGHT) * this.rate - (double)this.LINE_HEIGHT, centralX - (double)g2d.getFontMetrics().stringWidth(text) / 2.0, centralY, false, svgElement);
                this.drawSVGLine(lastSiteX * this.rate, ((double)vertical - this.HALF_HEIGHT) * this.rate - (double)this.LINE_HEIGHT, centralX + (double)g2d.getFontMetrics().stringWidth(text) / 2.0, centralY, false, svgElement);
                if (isShowPosition) {
                    this.drawSVGText(this.positionFontSize, firstSiteX * this.rate - 2.0 - (double)this.positionFontMetrics.stringWidth(String.valueOf(firstSite)), ((double)vertical - this.HALF_HEIGHT) * this.rate - (double)this.positionFontMetrics.getDescent(), String.valueOf(firstSite), svgElement);
                    this.drawSVGText(this.positionFontSize, lastSiteX * this.rate + 2.0, ((double)vertical - this.HALF_HEIGHT) * this.rate - (double)this.positionFontMetrics.getDescent(), String.valueOf(lastSite), svgElement);
                }
                if (shapeType.equals("Null")) {
                    this.drawSVGText((int)((double)size * this.rate), centralX - (double)g2d.getFontMetrics().stringWidth(text) / 2.0, centralY - (double)g2d.getFontMetrics().getDescent(), textColor, text, svgElement);
                }
            } else {
                this.drawSVGLine(firstSiteX * this.rate, ((double)vertical + this.HALF_HEIGHT) * this.rate, firstSiteX * this.rate, ((double)vertical + this.HALF_HEIGHT) * this.rate + (double)this.LINE_HEIGHT, false, svgElement);
                this.drawSVGLine(lastSiteX * this.rate, ((double)vertical + this.HALF_HEIGHT) * this.rate, lastSiteX * this.rate, ((double)vertical + this.HALF_HEIGHT) * this.rate + (double)this.LINE_HEIGHT, false, svgElement);
                this.drawSVGLine(firstSiteX * this.rate, ((double)vertical + this.HALF_HEIGHT) * this.rate + (double)this.LINE_HEIGHT, centralX - (double)g2d.getFontMetrics().stringWidth(text) / 2.0, centralY, false, svgElement);
                this.drawSVGLine(lastSiteX * this.rate, ((double)vertical + this.HALF_HEIGHT) * this.rate + (double)this.LINE_HEIGHT, centralX + (double)g2d.getFontMetrics().stringWidth(text) / 2.0, centralY, false, svgElement);
                if (isShowPosition) {
                    this.drawSVGText(this.positionFontSize, firstSiteX * this.rate - 2.0 - (double)this.positionFontMetrics.stringWidth(String.valueOf(firstSite)), ((double)vertical + this.HALF_HEIGHT) * this.rate + (double)this.positionFontMetrics.getAscent(), String.valueOf(firstSite), svgElement);
                    this.drawSVGText(this.positionFontSize, lastSiteX * this.rate + 2.0, ((double)vertical + this.HALF_HEIGHT) * this.rate + (double)this.positionFontMetrics.getAscent(), String.valueOf(lastSite), svgElement);
                }
                if (shapeType.equals("Null")) {
                    this.drawSVGText((int)((double)size * this.rate), centralX - (double)g2d.getFontMetrics().stringWidth(text) / 2.0, centralY + (double)g2d.getFontMetrics().getAscent(), textColor, text, svgElement);
                }
            }
        } else {
            int site;
            LinkedList<Integer> siteList = new LinkedList<Integer>();
            for (int i = 0; i < siteCount; ++i) {
                siteList.add(Integer.parseInt(st.nextToken()));
            }
            Collections.sort(siteList);
            g2d.setColor(Color.BLACK);
            centralX = ((double)deltaX * this.LENGTH_RATE - this.HALF_LENGTH + (double)horizontal) * this.rate;
            centralY = (double)(vertical - deltaY) * this.rate;
            if (deltaY >= 0) {
                Iterator iter = siteList.iterator();
                while (iter.hasNext()) {
                    site = Integer.parseInt(String.valueOf(iter.next()));
                    double siteX = -this.HALF_LENGTH + (double)horizontal + (double)site * this.LENGTH_RATE;
                    this.drawSVGLine(siteX * this.rate, ((double)vertical - this.HALF_HEIGHT) * this.rate, siteX * this.rate, ((double)vertical - this.HALF_HEIGHT) * this.rate - (double)this.LINE_HEIGHT, false, svgElement);
                    this.drawSVGLine(siteX * this.rate, ((double)vertical - this.HALF_HEIGHT) * this.rate - (double)this.LINE_HEIGHT, centralX, centralY, false, svgElement);
                    if (!isShowPosition) continue;
                    this.drawSVGText(this.positionFontSize, siteX * this.rate + 2.0, ((double)vertical - this.HALF_HEIGHT) * this.rate - (double)this.positionFontMetrics.getDescent(), String.valueOf(site), svgElement);
                }
                if (shapeType.equals("Null")) {
                    this.drawSVGText((int)((double)size * this.rate), centralX - (double)g2d.getFontMetrics().stringWidth(text) / 2.0, centralY - (double)g2d.getFontMetrics().getDescent(), textColor, text, svgElement);
                }
            } else {
                Iterator iter = siteList.iterator();
                while (iter.hasNext()) {
                    site = Integer.parseInt(String.valueOf(iter.next()));
                    double siteX = -this.HALF_LENGTH + (double)horizontal + (double)site * this.LENGTH_RATE;
                    this.drawSVGLine(siteX * this.rate, ((double)vertical + this.HALF_HEIGHT) * this.rate, siteX * this.rate, ((double)vertical + this.HALF_HEIGHT) * this.rate + (double)this.LINE_HEIGHT, false, svgElement);
                    this.drawSVGLine(siteX * this.rate, ((double)vertical + this.HALF_HEIGHT) * this.rate + (double)this.LINE_HEIGHT, centralX, centralY, false, svgElement);
                    if (!isShowPosition) continue;
                    this.drawSVGText(this.positionFontSize, siteX * this.rate + 2.0, ((double)vertical + this.HALF_HEIGHT) * this.rate + (double)this.positionFontMetrics.getAscent(), String.valueOf(site), svgElement);
                }
                if (shapeType.equals("Null")) {
                    this.drawSVGText((int)((double)size * this.rate), centralX - (double)g2d.getFontMetrics().stringWidth(text) / 2.0, centralY + (double)g2d.getFontMetrics().getAscent(), textColor, text, svgElement);
                }
            }
        }
        if (!shapeType.equals("Null")) {
            double centerx = 0.0;
            double centery = 0.0;
            double startx = 0.0;
            double starty = 0.0;
            double endx = 0.0;
            double endy = 0.0;
            double startX = 0.0;
            double startY = 0.0;
            double endX = 0.0;
            double endY = 0.0;
            centerx = deltaX;
            centery = deltaY;
            startx = centerx - (double)wide / 2.0;
            starty = centery - (double)high / 2.0;
            endx = centerx + (double)wide / 2.0;
            endy = centery + (double)high / 2.0;
            startX = (-this.HALF_LENGTH + (double)horizontal + startx * this.LENGTH_RATE) * this.rate;
            endX = (-this.HALF_LENGTH + (double)horizontal + endx * this.LENGTH_RATE) * this.rate;
            startY = ((double)vertical - centery - (double)high * this.LENGTH_RATE / 2.0) * this.rate;
            endY = ((double)vertical - centery + (double)high * this.LENGTH_RATE / 2.0) * this.rate;
            PolygonXY pgxy = new PolygonXY();
            pgxy.getPolygonXY(startX, startY, endX, endY, shapeType, angle, this.rate);
            pgxy.CacuMinMaxXY();
            this.drawSVGPolygon(null, null, startX, startY, endX, endY, pgxy.bnewminx, pgxy.bnewminy, pgxy.bnewmaxx, pgxy.bnewmaxy, pgxy.x, pgxy.y, fontsize, color, angle, sGradient, shapeType, text, fontsize, textColor, nameDrawType, linesize, lineColor, texturefile, newSVGFilePath, high, bdash, false, g2d, svgElement);
        }
    }

    private void drawSVGProtein(int vertical, int horizontal, int start, String startDrawType, int end, String endDrawType, int height, int size, Color color, int linesize, Color lineColor, String texturefile, String newSVGFilePath, String sGradient, boolean bdash, Graphics2D g2d, Element svgElement) {
        this.HALF_HEIGHT = (double)height / 2.0;
        this.positionFontSize = (int)((double)size * this.rate);
        double startX = (-this.HALF_LENGTH + (double)horizontal + (double)start * this.LENGTH_RATE) * this.rate;
        double endX = (-this.HALF_LENGTH + (double)horizontal + (double)end * this.LENGTH_RATE) * this.rate;
        double startY = ((double)(-vertical) - this.HALF_HEIGHT) * this.rate;
        double endY = ((double)(-vertical) + this.HALF_HEIGHT) * this.rate;
        PolygonXY pgxy = new PolygonXY();
        pgxy.getPolygonXY(startX, startY, endX, endY, "Rectangle", 0.0, this.rate);
        pgxy.CacuMinMaxXY();
        this.drawSVGPolygon(null, null, (int)startX, (int)startY, (int)endX, (int)endY, pgxy.bnewminx, pgxy.bnewminy, pgxy.bnewmaxx, pgxy.bnewmaxy, pgxy.x, pgxy.y, 1.0, color, 0.0, sGradient, "Rectangle", "", linesize, color, "Hide", linesize, lineColor, texturefile, newSVGFilePath, height, bdash, true, g2d, svgElement);
        g2d.setFont(new Font("Arial", 1, this.positionFontSize));
        this.positionFontMetrics = g2d.getFontMetrics();
        this.LINE_HEIGHT = this.positionFontMetrics.getHeight();
        double lineHeight = this.HALF_HEIGHT * this.rate + (double)this.LINE_HEIGHT;
        if (startDrawType.equals("Down")) {
            this.drawSVGLine(pgxy.minx, ((double)(-vertical) + this.HALF_HEIGHT) * this.rate, pgxy.minx, (double)(-vertical) * this.rate + lineHeight, linesize, lineColor, false, svgElement);
            this.drawSVGText(this.positionFontSize, (float)((double)pgxy.minx - (double)this.positionFontMetrics.stringWidth(String.valueOf(start)) / 2.0), (float)((double)(-vertical) * this.rate + lineHeight + (double)this.positionFontMetrics.getAscent()), String.valueOf(start), svgElement);
        } else if (startDrawType.equals("Up")) {
            this.drawSVGLine(pgxy.minx, ((double)(-vertical) - this.HALF_HEIGHT) * this.rate, pgxy.minx, (double)(-vertical) * this.rate - lineHeight, linesize, lineColor, false, svgElement);
            this.drawSVGText(this.positionFontSize, (float)((double)pgxy.minx - (double)this.positionFontMetrics.stringWidth(String.valueOf(start)) / 2.0), (float)((double)(-vertical) * this.rate - lineHeight - (double)this.positionFontMetrics.getDescent()), String.valueOf(start), svgElement);
        } else if (startDrawType.equals("Hide")) {
            // empty if block
        }
        if (endDrawType.equals("Down")) {
            this.drawSVGLine(pgxy.maxx, ((double)(-vertical) + this.HALF_HEIGHT) * this.rate, pgxy.maxx, (double)(-vertical) * this.rate + lineHeight, linesize, lineColor, false, svgElement);
            this.drawSVGText(this.positionFontSize, (float)((double)pgxy.maxx - (double)this.positionFontMetrics.stringWidth(String.valueOf(end)) / 2.0), (float)((double)(-vertical) * this.rate + lineHeight + (double)this.positionFontMetrics.getAscent()), String.valueOf(end), svgElement);
        } else if (endDrawType.equals("Up")) {
            this.drawSVGLine(pgxy.maxx, ((double)(-vertical) - this.HALF_HEIGHT) * this.rate, pgxy.maxx, (double)(-vertical) * this.rate - lineHeight, linesize, lineColor, false, svgElement);
            this.drawSVGText(this.positionFontSize, (float)((double)pgxy.maxx - (double)this.positionFontMetrics.stringWidth(String.valueOf(end)) / 2.0), (float)((double)(-vertical) * this.rate - lineHeight - (double)this.positionFontMetrics.getDescent()), String.valueOf(end), svgElement);
        } else if (endDrawType.equals("Hide")) {
            // empty if block
        }
    }

    private void drawSVGProteinBorderDash(int vertical, int horizontal, int height, int[] pos, Map<Integer, DomainDashConf> ddcMap, Color lineColor, int strokesize, boolean proteinbdash, Graphics2D g2d, Element svgElement) {
        this.HALF_HEIGHT = (double)height / 2.0;
        this.positionFontMetrics = g2d.getFontMetrics();
        this.LINE_HEIGHT = this.positionFontMetrics.getHeight();
        if (ddcMap.size() > 0) {
            for (int i = 0; i < pos.length && i != pos.length - 1; ++i) {
                DomainDashConf ddci = ddcMap.get(pos[i]);
                DomainDashConf ddcj = ddcMap.get(pos[i + 1]);
                if (ddci == null || ddcj == null) continue;
                double startX = (int)Math.round((-this.HALF_LENGTH + (double)horizontal + ddci.xCenterPosition * this.LENGTH_RATE) * this.rate);
                double endX = (int)Math.round((-this.HALF_LENGTH + (double)horizontal + ddcj.xCenterPosition * this.LENGTH_RATE) * this.rate);
                double startY = ((double)(-vertical) - this.HALF_HEIGHT) * this.rate;
                double endY = ((double)(-vertical) + this.HALF_HEIGHT) * this.rate;
                boolean isDash = false;
                isDash = ddci.bRDash || ddcj.bLDash;
                Element polygonLineElement22 = new Element("path");
                String ds22 = "";
                ds22 = "M" + ((double)((float)startX) + this.canvasWide / 2.0) + "," + (int)Math.round((double)((float)startY) + this.canvasHigh / 2.0) + " " + "L" + ((double)((float)endX) + this.canvasWide / 2.0) + "," + (int)Math.round((double)((float)startY) + this.canvasHigh / 2.0) + " ";
                polygonLineElement22.setAttribute("d", ds22);
                polygonLineElement22.setAttribute("fill", "none");
                polygonLineElement22.setAttribute("stroke", Tools.ColorToHex(lineColor));
                if (ddcMap.size() > 2) {
                    if (isDash) {
                        polygonLineElement22.setAttribute("stroke-dasharray", "3");
                    }
                } else if (proteinbdash) {
                    polygonLineElement22.setAttribute("stroke-dasharray", "3");
                }
                polygonLineElement22.setAttribute("stroke-width", (double)strokesize * this.rate < 1.0 ? "1" : String.valueOf((int)((double)strokesize * this.rate + 1.0)));
                svgElement.addContent(polygonLineElement22);
                Element polygonLineElement23 = new Element("path");
                String ds23 = "";
                ds23 = "M" + ((double)((float)startX) + this.canvasWide / 2.0) + "," + (int)Math.round((double)((float)endY) + this.canvasHigh / 2.0) + " " + "L" + ((double)((float)endX) + this.canvasWide / 2.0) + "," + (int)Math.round((double)((float)endY) + this.canvasHigh / 2.0) + " ";
                polygonLineElement23.setAttribute("d", ds23);
                polygonLineElement23.setAttribute("fill", "none");
                polygonLineElement23.setAttribute("stroke", Tools.ColorToHex(lineColor));
                if (ddcMap.size() > 2) {
                    if (isDash) {
                        polygonLineElement23.setAttribute("stroke-dasharray", "3");
                    }
                } else if (proteinbdash) {
                    polygonLineElement23.setAttribute("stroke-dasharray", "3");
                }
                polygonLineElement23.setAttribute("stroke-width", (double)strokesize * this.rate < 1.0 ? "1" : String.valueOf((int)((double)strokesize * this.rate + 1.0)));
                svgElement.addContent(polygonLineElement23);
                if (i == 0) {
                    Element polygonLineElement33 = new Element("path");
                    String ds33 = "";
                    ds33 = "M" + ((double)((float)startX) + this.canvasWide / 2.0) + "," + (int)Math.round((double)((float)startY) + this.canvasHigh / 2.0) + " " + "L" + ((double)((float)startX) + this.canvasWide / 2.0) + "," + (int)Math.round((double)((float)endY) + this.canvasHigh / 2.0) + " ";
                    polygonLineElement33.setAttribute("d", ds33);
                    polygonLineElement33.setAttribute("fill", "none");
                    polygonLineElement33.setAttribute("stroke", Tools.ColorToHex(lineColor));
                    if (ddcMap.size() > 2) {
                        if (isDash) {
                            polygonLineElement33.setAttribute("stroke-dasharray", "3");
                        }
                    } else if (proteinbdash) {
                        polygonLineElement33.setAttribute("stroke-dasharray", "3");
                    }
                    polygonLineElement33.setAttribute("stroke-width", (double)strokesize * this.rate < 1.0 ? "1" : String.valueOf((int)((double)strokesize * this.rate + 1.0)));
                    svgElement.addContent(polygonLineElement33);
                    if (pos.length != 2) continue;
                    Element polygonLineElement34 = new Element("path");
                    String ds34 = "";
                    ds34 = "M" + ((double)((float)endX) + this.canvasWide / 2.0) + "," + (int)Math.round((double)((float)startY) + this.canvasHigh / 2.0) + " " + "L" + ((double)((float)endX) + this.canvasWide / 2.0) + "," + (int)Math.round((double)((float)endY) + this.canvasHigh / 2.0) + " ";
                    polygonLineElement34.setAttribute("d", ds34);
                    polygonLineElement34.setAttribute("fill", "none");
                    polygonLineElement34.setAttribute("stroke", Tools.ColorToHex(lineColor));
                    if (ddcMap.size() > 2) {
                        if (isDash) {
                            polygonLineElement34.setAttribute("stroke-dasharray", "3");
                        }
                    } else if (proteinbdash) {
                        polygonLineElement34.setAttribute("stroke-dasharray", "3");
                    }
                    polygonLineElement34.setAttribute("stroke-width", (double)strokesize * this.rate < 1.0 ? "1" : String.valueOf((int)((double)strokesize * this.rate + 1.0)));
                    svgElement.addContent(polygonLineElement34);
                    continue;
                }
                if (i != pos.length - 2) continue;
                Element polygonLineElement35 = new Element("path");
                String ds35 = "";
                ds35 = "M" + ((double)((float)endX) + this.canvasWide / 2.0) + "," + (int)Math.round((double)((float)startY) + this.canvasHigh / 2.0) + " " + "L" + ((double)((float)endX) + this.canvasWide / 2.0) + "," + (int)Math.round((double)((float)endY) + this.canvasHigh / 2.0) + " ";
                polygonLineElement35.setAttribute("d", ds35);
                polygonLineElement35.setAttribute("fill", "none");
                polygonLineElement35.setAttribute("stroke", Tools.ColorToHex(lineColor));
                if (ddcMap.size() > 2) {
                    if (isDash) {
                        polygonLineElement35.setAttribute("stroke-dasharray", "3");
                    }
                } else if (proteinbdash) {
                    polygonLineElement35.setAttribute("stroke-dasharray", "3");
                }
                polygonLineElement35.setAttribute("stroke-width", (double)strokesize * this.rate < 1.0 ? "1" : String.valueOf((int)((double)strokesize * this.rate + 1.0)));
                svgElement.addContent(polygonLineElement35);
            }
        }
    }

    private void drawSVGDomain(Protein pr, Component com, int vertical, int horizontal, int start, String startDrawType, int end, String endDrawType, int iHigh, double angle, Color color, String text, String nameDrawType, int fontsize, Color textColor, int linesize, Color lineColor, String texturefile, String newSVGFilePath, String shapeType, String sGradient, boolean bdash, Graphics2D g2d, Element svgElement) {
        double endY;
        double startY;
        vertical = -vertical;
        double lineHeight = this.HALF_HEIGHT * this.rate + (double)this.LINE_HEIGHT;
        double startX = -this.HALF_LENGTH + (double)horizontal + (double)start * this.LENGTH_RATE;
        double endX = -this.HALF_LENGTH + (double)horizontal + (double)(start + (end - start)) * this.LENGTH_RATE;
        startX *= this.rate;
        endX *= this.rate;
        if (iHigh == 0) {
            startY = ((double)vertical - this.HALF_HEIGHT) * this.rate;
            endY = ((double)vertical + this.HALF_HEIGHT) * this.rate;
        } else {
            int iVhigh = (int)((double)(iHigh * 2) * this.LENGTH_RATE);
            startY = ((double)vertical - (double)iVhigh / 4.0) * this.rate;
            endY = ((double)vertical + (double)iVhigh / 4.0) * this.rate;
        }
        PolygonXY pgxy = new PolygonXY();
        pgxy.getPolygonXY(startX, startY, endX, endY, shapeType, angle, this.rate);
        pgxy.CacuMinMaxXY();
        this.drawSVGPolygon(pr, com, (int)startX, (int)startY, (int)endX, (int)endY, pgxy.bnewminx, pgxy.bnewminy, pgxy.bnewmaxx, pgxy.bnewmaxy, pgxy.x, pgxy.y, fontsize, color, (int)angle, sGradient, shapeType, text, fontsize, textColor, nameDrawType, linesize, lineColor, texturefile, newSVGFilePath, iHigh, bdash, false, g2d, svgElement);
        if (startDrawType.equals("Down")) {
            this.drawSVGLine(startX * this.rate, ((double)(-vertical) + this.HALF_HEIGHT) * this.rate, startX * this.rate, (double)(-vertical) * this.rate + lineHeight, linesize, lineColor, false, svgElement);
            this.drawSVGText(this.positionFontSize, startX * this.rate - (double)this.positionFontMetrics.stringWidth(String.valueOf(start)) / 2.0, (double)(-vertical) * this.rate + lineHeight + (double)this.positionFontMetrics.getAscent(), String.valueOf(start), svgElement);
        } else if (startDrawType.equals("Up")) {
            this.drawSVGLine(startX * this.rate, ((double)(-vertical) - this.HALF_HEIGHT) * this.rate, startX * this.rate, (double)(-vertical) * this.rate - lineHeight, linesize, lineColor, false, svgElement);
            this.drawSVGText(this.positionFontSize, startX * this.rate - (double)this.positionFontMetrics.stringWidth(String.valueOf(start)) / 2.0, (double)(-vertical) * this.rate - lineHeight - (double)this.positionFontMetrics.getDescent(), String.valueOf(start), svgElement);
        } else if (startDrawType.equals("Hide")) {
            // empty if block
        }
        if (endDrawType.equals("Down")) {
            this.drawSVGLine(endX * this.rate, ((double)(-vertical) + this.HALF_HEIGHT) * this.rate, endX * this.rate, (double)(-vertical) * this.rate + lineHeight, linesize, lineColor, false, svgElement);
            this.drawSVGText(this.positionFontSize, endX * this.rate - (double)this.positionFontMetrics.stringWidth(String.valueOf(end)) / 2.0, (double)(-vertical) * this.rate + lineHeight + (double)this.positionFontMetrics.getAscent(), String.valueOf(end), svgElement);
        } else if (endDrawType.equals("Up")) {
            this.drawSVGLine(endX * this.rate, ((double)(-vertical) - this.HALF_HEIGHT) * this.rate, endX * this.rate, (double)(-vertical) * this.rate - lineHeight, linesize, lineColor, false, svgElement);
            this.drawSVGText(this.positionFontSize, endX * this.rate - (double)this.positionFontMetrics.stringWidth(String.valueOf(end)) / 2.0, (double)(-vertical) * this.rate - lineHeight - (double)this.positionFontMetrics.getDescent(), String.valueOf(end), svgElement);
        } else if (endDrawType.equals("Hide")) {
            // empty if block
        }
    }

    private void drawSVGProteinDomain(int vertical, int horizontal, int start, String startDrawType, int end, String endDrawType, int iHigh, double angle, Color color, String text, String nameDrawType, int fontsize, Color textColor, int linesize, Color lineColor, String texturefile, String newSVGFilePath, String shapeType, String sGradient, boolean bdash, Graphics2D g2d, Element svgElement) {
        double startX = -this.HALF_LENGTH + (double)horizontal + (double)start * this.LENGTH_RATE;
        double endX = -this.HALF_LENGTH + (double)horizontal + (double)end * this.LENGTH_RATE;
        double lineHeight = this.HALF_HEIGHT * this.rate + (double)this.LINE_HEIGHT;
        Stroke stroke = g2d.getStroke();
        double startx = (int)Math.round(startX * this.rate);
        double endx = (int)Math.round(endX * this.rate);
        double starty = ((double)(-vertical) - this.HALF_HEIGHT) * this.rate;
        double endy = ((double)(-vertical) + this.HALF_HEIGHT) * this.rate;
        PolygonXY pgxy = new PolygonXY();
        pgxy.getPolygonXY(startx, starty, endx, endy, "Rectangle", 0.0, this.rate);
        pgxy.CacuMinMaxXY();
        this.drawSVGPolygon(null, null, (int)startx, (int)Math.round(starty), (int)endx, (int)Math.round(endy), pgxy.bnewminx, Math.round(pgxy.bnewminy), pgxy.bnewmaxx, Math.round(pgxy.bnewmaxy), pgxy.x, pgxy.y, fontsize, color, 0.0, sGradient, "Rectangle", text, fontsize, textColor, nameDrawType, linesize, lineColor, texturefile, newSVGFilePath, iHigh, bdash, false, g2d, svgElement);
        if (startDrawType.equals("Down")) {
            this.drawSVGLine(pgxy.minx, ((double)(-vertical) + this.HALF_HEIGHT) * this.rate, pgxy.minx, (double)(-vertical) * this.rate + lineHeight, linesize, lineColor, false, svgElement);
            this.drawSVGText(this.positionFontSize, (float)((double)pgxy.minx - (double)this.positionFontMetrics.stringWidth(String.valueOf(start)) / 2.0), (float)((double)(-vertical) * this.rate + lineHeight + (double)this.positionFontMetrics.getAscent()), String.valueOf(start), svgElement);
        } else if (startDrawType.equals("Up")) {
            this.drawSVGLine(pgxy.minx, ((double)(-vertical) - this.HALF_HEIGHT) * this.rate, pgxy.minx, (double)(-vertical) * this.rate - lineHeight, linesize, lineColor, false, svgElement);
            this.drawSVGText(this.positionFontSize, (float)((double)pgxy.minx - (double)this.positionFontMetrics.stringWidth(String.valueOf(start)) / 2.0), (float)((double)(-vertical) * this.rate - lineHeight - (double)this.positionFontMetrics.getDescent()), String.valueOf(start), svgElement);
        } else if (startDrawType.equals("Hide")) {
            // empty if block
        }
        if (endDrawType.equals("Down")) {
            this.drawSVGLine(pgxy.maxx, ((double)(-vertical) + this.HALF_HEIGHT) * this.rate, pgxy.maxx, (double)(-vertical) * this.rate + lineHeight, linesize, lineColor, false, svgElement);
            this.drawSVGText(this.positionFontSize, (float)((double)pgxy.maxx - (double)this.positionFontMetrics.stringWidth(String.valueOf(end)) / 2.0), (float)((double)(-vertical) * this.rate + lineHeight + (double)this.positionFontMetrics.getAscent()), String.valueOf(end), svgElement);
        } else if (endDrawType.equals("Up")) {
            this.drawSVGLine(pgxy.maxx, ((double)(-vertical) - this.HALF_HEIGHT) * this.rate, pgxy.maxx, (double)(-vertical) * this.rate - lineHeight, linesize, lineColor, false, svgElement);
            this.drawSVGText(this.positionFontSize, (float)((double)pgxy.maxx - (double)this.positionFontMetrics.stringWidth(String.valueOf(end)) / 2.0), (float)((double)(-vertical) * this.rate - lineHeight - (double)this.positionFontMetrics.getDescent()), String.valueOf(end), svgElement);
        } else if (endDrawType.equals("Hide")) {
            // empty if block
        }
    }

    private void drawSVGCutLine(Protein pr, Component com, int vertical, int horizontal, int start, String startDrawType, int end, String endDrawType, int iHigh, double angle, Color color, String text, String nameDrawType, int fontsize, Color textColor, int linesize, Color lineColor, String texturefile, String newSVGFilePath, String shapeType, String sGradient, boolean bdash, Graphics2D g2d, Element svgElement) {
        double endY;
        double startY;
        vertical = -vertical;
        double lineHeight = this.HALF_HEIGHT * this.rate + (double)this.LINE_HEIGHT;
        double startX = -this.HALF_LENGTH + (double)horizontal + (double)start * this.LENGTH_RATE;
        double endX = -this.HALF_LENGTH + (double)horizontal + (double)(start + (end - start)) * this.LENGTH_RATE;
        startX *= this.rate;
        endX *= this.rate;
        if (iHigh == 0) {
            startY = ((double)vertical - this.HALF_HEIGHT) * this.rate;
            endY = ((double)vertical + this.HALF_HEIGHT) * this.rate;
        } else {
            int iVhigh = (int)((double)(iHigh * 2) * this.LENGTH_RATE);
            startY = ((double)vertical - (double)iVhigh / 4.0) * this.rate;
            endY = ((double)vertical + (double)iVhigh / 4.0) * this.rate;
        }
        PolygonXY pgxy = new PolygonXY();
        pgxy.getPolygonXY(startX, startY, endX, endY, shapeType, angle, this.rate);
        pgxy.CacuMinMaxXY();
        this.drawSVGPolygon(pr, com, (int)startX, (int)startY, (int)endX, (int)endY, pgxy.bnewminx, pgxy.bnewminy, pgxy.bnewmaxx, pgxy.bnewmaxy, pgxy.x, pgxy.y, fontsize, color, (int)angle, sGradient, shapeType, text, fontsize, textColor, nameDrawType, linesize, lineColor, texturefile, newSVGFilePath, iHigh, bdash, false, g2d, svgElement);
        if (startDrawType.equals("Down")) {
            this.drawSVGLine(startX * this.rate, ((double)(-vertical) + this.HALF_HEIGHT) * this.rate, startX * this.rate, (double)(-vertical) * this.rate + lineHeight, linesize, lineColor, false, svgElement);
            this.drawSVGText(this.positionFontSize, startX * this.rate - (double)this.positionFontMetrics.stringWidth(String.valueOf(start)) / 2.0, (double)(-vertical) * this.rate + lineHeight + (double)this.positionFontMetrics.getAscent(), String.valueOf(start), svgElement);
        } else if (startDrawType.equals("Up")) {
            this.drawSVGLine(startX * this.rate, ((double)(-vertical) - this.HALF_HEIGHT) * this.rate, startX * this.rate, (double)(-vertical) * this.rate - lineHeight, linesize, lineColor, false, svgElement);
            this.drawSVGText(this.positionFontSize, startX * this.rate - (double)this.positionFontMetrics.stringWidth(String.valueOf(start)) / 2.0, (double)(-vertical) * this.rate - lineHeight - (double)this.positionFontMetrics.getDescent(), String.valueOf(start), svgElement);
        } else if (startDrawType.equals("Hide")) {
            // empty if block
        }
        if (endDrawType.equals("Down")) {
            this.drawSVGLine(endX * this.rate, ((double)(-vertical) + this.HALF_HEIGHT) * this.rate, endX * this.rate, (double)(-vertical) * this.rate + lineHeight, linesize, lineColor, false, svgElement);
            this.drawSVGText(this.positionFontSize, endX * this.rate - (double)this.positionFontMetrics.stringWidth(String.valueOf(end)) / 2.0, (double)(-vertical) * this.rate + lineHeight + (double)this.positionFontMetrics.getAscent(), String.valueOf(end), svgElement);
        } else if (endDrawType.equals("Up")) {
            this.drawSVGLine(endX * this.rate, ((double)(-vertical) - this.HALF_HEIGHT) * this.rate, endX * this.rate, (double)(-vertical) * this.rate - lineHeight, linesize, lineColor, false, svgElement);
            this.drawSVGText(this.positionFontSize, endX * this.rate - (double)this.positionFontMetrics.stringWidth(String.valueOf(end)) / 2.0, (double)(-vertical) * this.rate - lineHeight - (double)this.positionFontMetrics.getDescent(), String.valueOf(end), svgElement);
        } else if (endDrawType.equals("Hide")) {
            // empty if block
        }
    }

    private void drawSVGProteinCutLine(int vertical, int horizontal, int start, String startDrawType, int end, String endDrawType, int iHigh, double angle, Color color, String text, String nameDrawType, int fontsize, Color textColor, int linesize, Color lineColor, String texturefile, String newSVGFilePath, String shapeType, String sGradient, boolean bdash, Graphics2D g2d, Element svgElement) {
        double endy;
        double starty;
        vertical = -vertical;
        double startX = -this.HALF_LENGTH + (double)horizontal + (double)start * this.LENGTH_RATE;
        double endX = -this.HALF_LENGTH + (double)horizontal + (double)end * this.LENGTH_RATE;
        double centerX = -this.HALF_LENGTH + (double)horizontal + (double)((start + end) / 2) * this.LENGTH_RATE;
        double lineHeight = this.HALF_HEIGHT * this.rate + (double)this.LINE_HEIGHT;
        Stroke stroke = g2d.getStroke();
        double startx = startX * this.rate;
        double endx = endX * this.rate;
        if (iHigh == 0) {
            starty = ((double)vertical - this.HALF_HEIGHT) * this.rate;
            endy = ((double)vertical + this.HALF_HEIGHT) * this.rate;
        } else {
            int iVhigh = (int)((double)(iHigh * 2) * this.LENGTH_RATE);
            starty = ((double)vertical - (double)iVhigh / 4.0) * this.rate;
            endy = ((double)vertical + (double)iVhigh / 4.0) * this.rate;
        }
        double comhalf_heigh = (endy - starty) / 2.0;
        PolygonXY pgxy = new PolygonXY();
        pgxy.getPolygonXY(startx, starty, endx, endy, shapeType, 0.0, this.rate);
        pgxy.CacuMinMaxXY();
        this.drawSVGPolygon(null, null, (int)startx, (int)starty, (int)endx, (int)endy, pgxy.bnewminx, pgxy.bnewminy, pgxy.bnewmaxx, pgxy.bnewmaxy, pgxy.x, pgxy.y, fontsize, color, 0.0, sGradient, shapeType, text, fontsize, textColor, nameDrawType, linesize, lineColor, texturefile, newSVGFilePath, iHigh, bdash, false, g2d, svgElement);
        if (startDrawType.equals("Down")) {
            this.drawSVGLine(pgxy.minx, ((double)(-vertical) + this.HALF_HEIGHT) * this.rate, pgxy.minx, (double)(-vertical) * this.rate + lineHeight, linesize, lineColor, false, svgElement);
            this.drawSVGText(this.positionFontSize, (float)((double)pgxy.minx - (double)this.positionFontMetrics.stringWidth(String.valueOf(start)) / 2.0), (float)((double)(-vertical) * this.rate + lineHeight + (double)this.positionFontMetrics.getAscent()), String.valueOf(start), svgElement);
        } else if (startDrawType.equals("Up")) {
            this.drawSVGLine(pgxy.minx, ((double)(-vertical) - this.HALF_HEIGHT) * this.rate, pgxy.minx, (double)(-vertical) * this.rate - lineHeight, linesize, lineColor, false, svgElement);
            this.drawSVGText(this.positionFontSize, (float)((double)pgxy.minx - (double)this.positionFontMetrics.stringWidth(String.valueOf(start)) / 2.0), (float)((double)(-vertical) * this.rate - lineHeight - (double)this.positionFontMetrics.getDescent()), String.valueOf(start), svgElement);
        } else if (startDrawType.equals("Hide")) {
            // empty if block
        }
        if (endDrawType.equals("Down")) {
            this.drawSVGLine(pgxy.maxx, ((double)(-vertical) + this.HALF_HEIGHT) * this.rate, pgxy.maxx, (double)(-vertical) * this.rate + lineHeight, linesize, lineColor, false, svgElement);
            this.drawSVGText(this.positionFontSize, (float)((double)pgxy.maxx - (double)this.positionFontMetrics.stringWidth(String.valueOf(end)) / 2.0), (float)((double)(-vertical) * this.rate + lineHeight + (double)this.positionFontMetrics.getAscent()), String.valueOf(end), svgElement);
        } else if (endDrawType.equals("Up")) {
            this.drawSVGLine(pgxy.maxx, ((double)(-vertical) - this.HALF_HEIGHT) * this.rate, pgxy.maxx, (double)(-vertical) * this.rate - lineHeight, linesize, lineColor, false, svgElement);
            this.drawSVGText(this.positionFontSize, (float)((double)pgxy.maxx - (double)this.positionFontMetrics.stringWidth(String.valueOf(end)) / 2.0), (float)((double)(-vertical) * this.rate - lineHeight - (double)this.positionFontMetrics.getDescent()), String.valueOf(end), svgElement);
        } else if (endDrawType.equals("Hide")) {
            // empty if block
        }
    }

    public void drawCrystal(double startX, double startY, double endX, double endY, Color color, String clipid, Element svgElement) {
        int li_width = (int)(endX - startX);
        int li_height = (int)(endY - startY);
        if (li_height <= 1) {
            return;
        }
        Color bgColor = color;
        int[] li_fromcolor = new int[]{bgColor.getRed(), bgColor.getGreen(), bgColor.getBlue()};
        int[][] li_delcolors = this.getDelColors(li_fromcolor, li_height - 1);
        for (int i = 0; i < li_delcolors.length; ++i) {
            int li_r = li_fromcolor[0] + li_delcolors[i][0];
            int li_g = li_fromcolor[1] + li_delcolors[i][1];
            int li_b = li_fromcolor[2] + li_delcolors[i][2];
            if (li_r > 255) {
                li_r = 255;
            }
            if (li_g > 255) {
                li_g = 255;
            }
            if (li_b > 255) {
                li_b = 255;
            }
            Element lineElement = new Element("line");
            lineElement.setAttribute("x1", String.valueOf(startX + 1.0 + (double)((int)(this.canvasWide / 2.0))));
            lineElement.setAttribute("y1", String.valueOf((int)Math.round(startY + (double)i + (double)((int)(this.canvasHigh / 2.0)))));
            lineElement.setAttribute("x2", String.valueOf(startX + 1.0 + (double)li_width - 2.0 + (double)((int)(this.canvasWide / 2.0))));
            lineElement.setAttribute("y2", String.valueOf((int)Math.round(startY + (double)i + (double)((int)(this.canvasHigh / 2.0)))));
            lineElement.setAttribute("style", "stroke:rgb(" + li_r + "," + li_g + "," + li_b + "); stroke-width:1");
            lineElement.setAttribute("clip-path", "url(#" + clipid + ")");
            lineElement.setAttribute("clip-rule", "evenodd");
            svgElement.addContent(lineElement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyTextureFile(String newSVGFilePath, String texturefile) {
        File f = new File(newSVGFilePath + ".file");
        f.mkdir();
        File sourceFile = new File("texture/" + texturefile);
        File targetFile = new File(newSVGFilePath + ".file/" + texturefile);
        BufferedInputStream inBuff = null;
        FilterOutputStream outBuff = null;
        try {
            int len;
            inBuff = new BufferedInputStream(new FileInputStream(sourceFile));
            outBuff = new BufferedOutputStream(new FileOutputStream(targetFile));
            byte[] b = new byte[5120];
            while ((len = inBuff.read(b)) != -1) {
                ((BufferedOutputStream)outBuff).write(b, 0, len);
            }
            ((BufferedOutputStream)outBuff).flush();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                if (inBuff != null) {
                    inBuff.close();
                }
                if (outBuff != null) {
                    outBuff.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public int[][] getDelColors(int[] _fromColor, int _height) {
        int[][] delColor = new int[_height][3];
        int li_half = _height / 2;
        if (li_half == 0) {
            li_half = 1;
        }
        double li_prefix = 57.0;
        double li_d1 = 100.0 / (double)li_half;
        if (li_d1 == 0.0) {
            li_d1 = 1.0;
        }
        for (int i = li_half - 1; i >= 0; --i) {
            delColor[i][0] = (int)(li_prefix + (double)(li_half - 1 - i) * li_d1);
            delColor[i][1] = (int)(li_prefix + (double)(li_half - 1 - i) * li_d1);
            delColor[i][2] = (int)(li_prefix + (double)(li_half - 1 - i) * li_d1);
        }
        double li_d2 = 100.0 / (double)li_half * 0.5;
        if (li_d2 == 0.0) {
            li_d2 = 1.0;
        }
        for (int i = li_half; i < _height; ++i) {
            delColor[i][0] = (int)((double)(i - li_half) * li_d2);
            delColor[i][1] = (int)((double)(i - li_half) * li_d2);
            delColor[i][2] = (int)((double)(i - li_half) * li_d2);
        }
        return delColor;
    }

    public Color getGrayColor(Color origColor) {
        int iNewGray = 0;
        int iNewColor = 0;
        if (this.bGray) {
            iNewGray = (int)((double)origColor.getRed() * 0.3 + (double)origColor.getGreen() * 0.59 + (double)origColor.getBlue() * 0.11);
            iNewColor = (origColor.getAlpha() << 24) + (iNewGray << 16) + (iNewGray << 8) + iNewGray;
            Color newColor = new Color(iNewColor);
            return newColor;
        }
        return origColor;
    }

    public Document drawSVGComponentNucleotide(Graphics2D g2d) {
        String[] arr1 = this.SVGFilePathFull.split("/");
        this.SVGFilePath = arr1.length > 1 ? arr1[arr1.length - 1] : this.SVGFilePathFull;
        Document doc = new Document();
        Element svgElement = new Element("svg");
        doc.addContent(svgElement);
        svgElement.setAttribute("x", "0px");
        svgElement.setAttribute("y", "0px");
        svgElement.setAttribute("width", String.valueOf(this.canvasWide) + "px");
        svgElement.setAttribute("height", String.valueOf(this.canvasHigh) + "px");
        svgElement.setAttribute("viewBox", "0 0 " + String.valueOf(this.canvasWide) + " " + String.valueOf(this.canvasHigh));
        svgElement.setAttribute("enable-background", "new 0 0 " + String.valueOf(this.canvasWide) + " " + String.valueOf(this.canvasHigh));
        if (this.proteinList.size() > 0) {
            if (this.isLengthRate) {
                int maxLength = 1;
                for (Protein protein : this.proteinList) {
                    int end = protein.getEnd();
                    if (end <= maxLength) continue;
                    maxLength = end;
                }
                this.LENGTH_RATE = 600.0 / (double)maxLength;
            }
            for (Protein protein : this.proteinList) {
                if (!this.isLengthRate) {
                    this.LENGTH_RATE = 600.0 / (double)protein.getEnd();
                }
                int vertical = protein.getVertical();
                int horizontal = protein.getHorizontal();
                String[] arrPro = protein.getParameter().split(DELIMIT);
                int proteinStart = Integer.parseInt(arrPro[0]);
                DrawTypeEnum proteinStartDrawType = DrawTypeEnum.valueOf(arrPro[1]);
                int proteinEnd = Integer.parseInt(arrPro[2]);
                DrawTypeEnum proteinEndDrawType = DrawTypeEnum.valueOf(arrPro[3]);
                int proteinHeight = Integer.parseInt(arrPro[4]);
                int fontSize = Integer.parseInt(arrPro[5]);
                int proteinstroke = Integer.parseInt(arrPro[9]);
                GradientEnum GradientType = GradientEnum.valueOf(arrPro[6]);
                String SelectTextureFile = arrPro[7];
                boolean bbdash = Boolean.valueOf(arrPro[8]);
                String proteinColorLineStr = arrPro[10];
                StringTokenizer ster = new StringTokenizer(proteinColorLineStr, ",");
                Color proteinLineColor = new Color(Integer.parseInt(ster.nextToken()), Integer.parseInt(ster.nextToken()), Integer.parseInt(ster.nextToken()));
                this.drawSVGProtein(vertical, horizontal, proteinStart, proteinStartDrawType.name().toString(), proteinEnd, proteinEndDrawType.name().toString(), proteinHeight, fontSize, this.getGrayColor(protein.getColor()), proteinstroke, this.getGrayColor(proteinLineColor), SelectTextureFile, this.SVGFilePath, GradientType.name().toString(), false, g2d, svgElement);
                LinkedList<Component> componentList = protein.getComponentList();
                HashMap<Integer, DomainDashConf> ddcMap = new HashMap<Integer, DomainDashConf>();
                int p = 0;
                if (componentList.size() > 0) {
                    for (int k = 0; k < componentList.size(); ++k) {
                        Component component = componentList.get(k);
                        if (component.getType() != ComponentEnum.CutLine) continue;
                        DomainDashConf ddcdomain = new DomainDashConf();
                        ddcdomain.xCenterPosition = component.getX() + (component.getX2() - component.getX()) / 2.0;
                        ddcdomain.bLDash = component.bProteinLDash;
                        ddcdomain.bRDash = component.bProteinRDash;
                        ddcMap.put((int)ddcdomain.xCenterPosition, ddcdomain);
                        ++p;
                    }
                }
                DomainDashConf ddcfirst = new DomainDashConf();
                ddcfirst.xCenterPosition = proteinStart;
                ddcMap.put(proteinStart, ddcfirst);
                ++p;
                DomainDashConf ddclast = new DomainDashConf();
                ddclast.xCenterPosition = proteinEnd;
                ddcMap.put(proteinEnd, ddclast);
                int[] pos = new int[++p];
                int q = 0;
                Iterator itr = ddcMap.keySet().iterator();
                while (itr.hasNext()) {
                    int pos1;
                    pos[q] = pos1 = ((Integer)itr.next()).intValue();
                    ++q;
                }
                Arrays.sort(pos);
                this.drawSVGProteinBorderDash(vertical, horizontal, proteinHeight, pos, ddcMap, this.getGrayColor(proteinLineColor), proteinstroke, bbdash, g2d, svgElement);
                for (Component component : componentList) {
                    int strokesize;
                    String[] arr;
                    Area area = new Area();
                    if (component.getType() == ComponentEnum.Line) {
                        arr = component.getParameter().split(DELIMIT);
                        int lineWeight = Integer.parseInt(arr[0]);
                        DrawTypeEnum style = DrawTypeEnum.valueOf(arr[1]);
                        int x1 = (int)component.getX();
                        int y1 = component.getY();
                        int x2 = (int)component.getX2();
                        int y2 = component.getY2();
                        int x3 = component.getControlx1();
                        int y3 = component.getControly1();
                        int x4 = component.getControlx2();
                        int y4 = component.getControly2();
                        int startX = (int)((-this.HALF_LENGTH + (double)horizontal + (double)x1 * this.LENGTH_RATE) * this.rate);
                        int startY = (int)((double)(-vertical - y1) * this.rate);
                        int endX = (int)((-this.HALF_LENGTH + (double)horizontal + (double)x2 * this.LENGTH_RATE) * this.rate);
                        int endY = (int)((double)(-vertical - y2) * this.rate);
                        int Control1X = (int)((-this.HALF_LENGTH + (double)horizontal + (double)x3 * this.LENGTH_RATE) * this.rate);
                        int Control1Y = (int)((double)(-vertical - y3) * this.rate);
                        int Control2X = (int)((-this.HALF_LENGTH + (double)horizontal + (double)x4 * this.LENGTH_RATE) * this.rate);
                        int Control2Y = (int)((double)(-vertical - y4) * this.rate);
                        boolean bdash = component.bDash;
                        if (component.shapeType == null) {
                            component.shapeType = ShapeEnum.Straight;
                        }
                        String fname = "";
                        DrawTypeEnum nameDrawType = DrawTypeEnum.Center;
                        int size = 110;
                        Color colortext = Color.BLACK;
                        if (arr.length > 2) {
                            fname = arr[2];
                            nameDrawType = DrawTypeEnum.valueOf(arr[3]);
                            size = Integer.parseInt(arr[4]);
                            fname.trim();
                            colortext = component.getColorText();
                        } else {
                            fname = "";
                            nameDrawType = DrawTypeEnum.Center;
                            size = 10;
                        }
                        if (component.shapeType == ShapeEnum.Straight) {
                            this.drawSVGLines(startX, startY, endX, endY, lineWeight, component.getColor(), style.name().toString(), fname, nameDrawType.name().toString(), size, colortext, bdash, svgElement, g2d);
                        } else if (component.shapeType == ShapeEnum.Bezier) {
                            this.drawSVGPolyCurveTwo(startX, startY, Control1X, Control1Y, Control2X, Control2Y, endX, endY, lineWeight, component.getColor(), style.name().toString(), bdash, svgElement);
                        } else if (component.shapeType == ShapeEnum.Curve) {
                            this.drawSVGPolyCurveOne(startX, startY, Control1X, Control1Y, endX, endY, lineWeight, component.getColor(), style.name().toString(), bdash, svgElement);
                        } else if (component.shapeType == ShapeEnum.PolylineOne) {
                            this.drawSVGPolyLineOne(startX, startY, Control1X, Control1Y, endX, endY, lineWeight, component.getColor(), style.name().toString(), bdash, svgElement);
                        } else if (component.shapeType == ShapeEnum.PolylineTwo) {
                            this.drawSVGPolyLineTwo(startX, startY, Control1X, Control1Y, Control2X, Control2Y, endX, endY, lineWeight, component.getColor(), style.name().toString(), bdash, svgElement);
                        }
                    } else if (component.getType() == ComponentEnum.Bracket) {
                        arr = component.getParameter().split(DELIMIT);
                        int strokesize2 = Integer.valueOf(arr[0]);
                        this.drawSVGBracket(vertical, horizontal, (int)component.getCenterx(), (int)component.getCentery(), (int)component.getWide(), (int)component.getRotationAngle(), strokesize2, this.getGrayColor(component.getColor()), component.shapeType.name().toString(), svgElement);
                    } else if (component.getType() == ComponentEnum.Note) {
                        arr = component.getParameter().split(DELIMIT);
                        String title = arr[0];
                        int size = Integer.parseInt(arr[1]);
                        DrawTypeEnum style = DrawTypeEnum.valueOf(arr[2]);
                        double angle = component.getRotationAngle();
                        int linesize = Integer.parseInt(arr[4]);
                        Color colorline = component.getColorline();
                        Boolean bdash = component.bDash;
                        String strFont = arr.length > 5 ? arr[5] : "Arial";
                        this.drawSVGNote(vertical, horizontal, title, (int)component.getX(), component.getY(), size, style.name().toString(), angle, component.getColor(), linesize, colorline, bdash, strFont, g2d, svgElement);
                    } else if (component.getType() == ComponentEnum.Site) {
                        arr = component.getParameter().split(DELIMIT);
                        String site = arr[0];
                        String text = arr[1];
                        int deltaX = (int)component.getCenterx();
                        int deltaY = (int)component.getCentery();
                        int size = Integer.parseInt(arr[2]);
                        boolean isShowPosition = Boolean.valueOf(arr[3]);
                        int strokesize3 = Integer.valueOf(arr[4]);
                        GradientEnum GradientType1 = GradientEnum.valueOf(arr[5]);
                        String SelectTextureFile1 = arr[6];
                        this.drawSVGSite(vertical, horizontal, site, deltaX, deltaY, (int)component.getWide(), (int)component.getHigh(), component.getRotationAngle(), size, isShowPosition, this.getGrayColor(component.getColor()), text, size, this.getGrayColor(component.getColorText()), "Center", strokesize3, this.getGrayColor(component.getColorline()), SelectTextureFile1, this.SVGFilePath, component.shapeType.name().toString(), GradientType1.toString(), component.isbDash(), g2d, svgElement);
                    } else if (component.getType() == ComponentEnum.Domain) {
                        arr = component.getParameter().split(DELIMIT);
                        DrawTypeEnum startDrawType = DrawTypeEnum.valueOf(arr[0]);
                        DrawTypeEnum endDrawType = DrawTypeEnum.valueOf(arr[1]);
                        String name = arr[2];
                        DrawTypeEnum nameDrawType = DrawTypeEnum.valueOf(arr[3]);
                        int size = Integer.parseInt(arr[4]);
                        double iHigh = component.getHigh();
                        double iRotationAngle = component.getRotationAngle();
                        strokesize = Integer.valueOf(arr[5]);
                        GradientEnum GradientType1 = GradientEnum.valueOf(arr[6]);
                        String SelectTextureFile1 = arr[7];
                        this.drawSVGDomain(protein, component, vertical, horizontal, (int)component.getX(), startDrawType.name().toString(), (int)component.getX2(), endDrawType.name().toString(), (int)iHigh, iRotationAngle, this.getGrayColor(component.getColor()), name, nameDrawType.name().toString(), size, this.getGrayColor(component.getColorText()), strokesize, this.getGrayColor(component.getColorline()), SelectTextureFile1, this.SVGFilePath, component.shapeType.name().toString(), GradientType1.name().toString(), component.isbDash(), g2d, svgElement);
                    } else if (component.getType() == ComponentEnum.CutLine) {
                        arr = component.getParameter().split(DELIMIT);
                        DrawTypeEnum startDrawType = DrawTypeEnum.valueOf(arr[0]);
                        DrawTypeEnum endDrawType = DrawTypeEnum.valueOf(arr[1]);
                        String name = arr[2];
                        DrawTypeEnum nameDrawType = DrawTypeEnum.valueOf(arr[3]);
                        int size = Integer.parseInt(arr[4]);
                        double iHigh = component.getHigh();
                        double iRotationAngle = component.getRotationAngle();
                        strokesize = Integer.valueOf(arr[5]);
                        GradientEnum GradientType1 = GradientEnum.valueOf(arr[6]);
                        String SelectTextureFile1 = arr[7];
                        this.drawSVGCutLine(protein, component, vertical, horizontal, (int)component.getX(), startDrawType.name().toString(), (int)component.getX2(), endDrawType.name().toString(), (int)iHigh, iRotationAngle, this.getGrayColor(component.getColor()), name, nameDrawType.name().toString(), size, this.getGrayColor(component.getColorText()), strokesize, this.getGrayColor(component.getColorline()), SelectTextureFile1, this.SVGFilePath, component.shapeType.name().toString(), GradientType1.name().toString(), component.isbDash(), g2d, svgElement);
                    } else if (component.getType() == ComponentEnum.Polygon) {
                        arr = component.getParameter().split(DELIMIT);
                        String name = arr[0];
                        int size = Integer.parseInt(arr[2]);
                        DrawTypeEnum nameDrawType = DrawTypeEnum.valueOf(arr[1]);
                        int strokesize4 = Integer.valueOf(arr[3]);
                        GradientEnum GradientType1 = GradientEnum.valueOf(arr[4]);
                        String SelectTextureFile1 = arr[5];
                        double startx = 0.0;
                        double starty = 0.0;
                        double endx = 0.0;
                        double endy = 0.0;
                        double startX = 0.0;
                        double startY = 0.0;
                        double endX = 0.0;
                        double endY = 0.0;
                        startx = component.getCenterx() - component.getWide() / 2.0;
                        starty = component.getCentery() - component.getHigh() / 2.0;
                        endx = component.getCenterx() + component.getWide() / 2.0;
                        endy = component.getCentery() + component.getHigh() / 2.0;
                        startX = (-this.HALF_LENGTH + (double)horizontal + startx * this.LENGTH_RATE) * this.rate;
                        endX = (-this.HALF_LENGTH + (double)horizontal + endx * this.LENGTH_RATE) * this.rate;
                        startY = ((double)(-vertical) - component.getCentery() - component.getHigh() / 2.0 * this.LENGTH_RATE) * this.rate;
                        endY = ((double)(-vertical) - component.getCentery() + component.getHigh() / 2.0 * this.LENGTH_RATE) * this.rate;
                        PolygonXY pgxy = new PolygonXY();
                        double rotateAngle = component.getRotationAngle();
                        pgxy.getPolygonXY(startX, startY, endX, endY, component.getShapeType().name().toString(), rotateAngle, this.rate);
                        pgxy.CacuMinMaxXY();
                        this.drawSVGPolygon(null, null, (int)startX, (int)startY, (int)endX, (int)endY, pgxy.minx, pgxy.miny, pgxy.maxx, pgxy.maxy, pgxy.x, pgxy.y, size, this.getGrayColor(component.getColor()), (int)rotateAngle, GradientType1.name().toString(), component.getShapeType().name().toString(), name, size, this.getGrayColor(component.getColorText()), nameDrawType.name().toString(), strokesize4, this.getGrayColor(component.getColorline()), SelectTextureFile1, this.SVGFilePath, component.getHigh(), component.isbDash(), false, g2d, svgElement);
                    }
                    component.setArea(area);
                }
            }
        }
        return doc;
    }

    public Document drawSVGComponentProtein(Graphics2D g2d) {
        String[] arr1 = this.SVGFilePathFull.split("/");
        this.SVGFilePath = arr1.length > 1 ? arr1[arr1.length - 1] : this.SVGFilePathFull;
        Document doc = new Document();
        Element svgElement = new Element("svg");
        doc.addContent(svgElement);
        svgElement.setAttribute("x", "0px");
        svgElement.setAttribute("y", "0px");
        svgElement.setAttribute("width", String.valueOf(this.canvasWide) + "px");
        svgElement.setAttribute("height", String.valueOf(this.canvasHigh) + "px");
        svgElement.setAttribute("viewBox", "0 0 " + String.valueOf(this.canvasWide) + " " + String.valueOf(this.canvasHigh));
        svgElement.setAttribute("enable-background", "new 0 0 " + String.valueOf(this.canvasWide) + " " + String.valueOf(this.canvasHigh));
        if (this.proteinList.size() > 0) {
            if (this.isLengthRate) {
                int maxLength = 1;
                for (Protein protein : this.proteinList) {
                    int end = protein.getEnd();
                    if (end <= maxLength) continue;
                    maxLength = end;
                }
                this.LENGTH_RATE = 600.0 / (double)maxLength;
            }
            for (Protein protein : this.proteinList) {
                if (!this.isLengthRate) {
                    this.LENGTH_RATE = 600.0 / (double)protein.getEnd();
                }
                int vertical = protein.getVertical();
                int horizontal = protein.getHorizontal();
                String[] arrPro = protein.getParameter().split(DELIMIT);
                int proteinStart = Integer.parseInt(arrPro[0]);
                DrawTypeEnum proteinStartDrawType = DrawTypeEnum.valueOf(arrPro[1]);
                int proteinEnd = Integer.parseInt(arrPro[2]);
                DrawTypeEnum proteinEndDrawType = DrawTypeEnum.valueOf(arrPro[3]);
                int proteinHeight = Integer.parseInt(arrPro[4]);
                int fontSize = Integer.parseInt(arrPro[5]);
                GradientEnum GradientType = GradientEnum.valueOf(arrPro[6]);
                String SelectTextureFile = arrPro[7];
                boolean bbdash = false;
                int lineSize = 1;
                bbdash = Boolean.valueOf(arrPro[8]);
                lineSize = Integer.parseInt(arrPro[9]);
                String proteinColorLineStr = arrPro[10];
                StringTokenizer ster = new StringTokenizer(proteinColorLineStr, ",");
                Color proteinLineColor = new Color(Integer.parseInt(ster.nextToken()), Integer.parseInt(ster.nextToken()), Integer.parseInt(ster.nextToken()));
                this.drawSVGProtein(vertical, horizontal, proteinStart, proteinStartDrawType.name().toString(), proteinEnd, proteinEndDrawType.name().toString(), proteinHeight, fontSize, this.getGrayColor(protein.getColor()), lineSize, this.getGrayColor(proteinLineColor), SelectTextureFile, this.SVGFilePath, GradientType.name().toString(), bbdash, g2d, svgElement);
                LinkedList<Component> componentList = protein.getComponentList();
                HashMap<Integer, DomainDashConf> ddcMap = new HashMap<Integer, DomainDashConf>();
                int p = 0;
                if (componentList.size() > 0) {
                    for (int k = 0; k < componentList.size(); ++k) {
                        Component component = componentList.get(k);
                        if (component.getType() != ComponentEnum.CutLine) continue;
                        DomainDashConf ddcdomain = new DomainDashConf();
                        ddcdomain.xCenterPosition = component.getX() + (component.getX2() - component.getX()) / 2.0;
                        ddcdomain.bLDash = component.bProteinLDash;
                        ddcdomain.bRDash = component.bProteinRDash;
                        ddcMap.put((int)ddcdomain.xCenterPosition, ddcdomain);
                        ++p;
                    }
                }
                DomainDashConf ddcfirst = new DomainDashConf();
                ddcfirst.xCenterPosition = proteinStart;
                ddcMap.put(proteinStart, ddcfirst);
                ++p;
                DomainDashConf ddclast = new DomainDashConf();
                ddclast.xCenterPosition = proteinEnd;
                ddcMap.put(proteinEnd, ddclast);
                int[] pos = new int[++p];
                int q = 0;
                Iterator itr = ddcMap.keySet().iterator();
                while (itr.hasNext()) {
                    int pos1;
                    pos[q] = pos1 = ((Integer)itr.next()).intValue();
                    ++q;
                }
                Arrays.sort(pos);
                this.drawSVGProteinBorderDash(vertical, horizontal, proteinHeight, pos, ddcMap, this.getGrayColor(proteinLineColor), lineSize, bbdash, g2d, svgElement);
                for (Component component : componentList) {
                    int strokesize;
                    String[] arr;
                    if (component.getType() == ComponentEnum.Line) {
                        arr = component.getParameter().split(DELIMIT);
                        int lineWeight = Integer.parseInt(arr[0]);
                        DrawTypeEnum style = DrawTypeEnum.valueOf(arr[1]);
                        int x1 = (int)component.getX();
                        int y1 = component.getY();
                        int x2 = (int)component.getX2();
                        int y2 = component.getY2();
                        int x3 = component.getControlx1();
                        int y3 = component.getControly1();
                        int x4 = component.getControlx2();
                        int y4 = component.getControly2();
                        int startX = (int)((-this.HALF_LENGTH + (double)horizontal + (double)x1 * this.LENGTH_RATE) * this.rate);
                        int startY = (int)((double)(-vertical - y1) * this.rate);
                        int endX = (int)((-this.HALF_LENGTH + (double)horizontal + (double)x2 * this.LENGTH_RATE) * this.rate);
                        int endY = (int)((double)(-vertical - y2) * this.rate);
                        int Control1X = (int)((-this.HALF_LENGTH + (double)horizontal + (double)x3 * this.LENGTH_RATE) * this.rate);
                        int Control1Y = (int)((double)(-vertical - y3) * this.rate);
                        int Control2X = (int)((-this.HALF_LENGTH + (double)horizontal + (double)x4 * this.LENGTH_RATE) * this.rate);
                        int Control2Y = (int)((double)(-vertical - y4) * this.rate);
                        boolean bdash = component.bDash;
                        if (component.shapeType == null) {
                            component.shapeType = ShapeEnum.Straight;
                        }
                        String fname = "";
                        DrawTypeEnum nameDrawType = DrawTypeEnum.Center;
                        int size = 110;
                        Color colortext = Color.BLACK;
                        if (arr.length > 2) {
                            fname = arr[2];
                            nameDrawType = DrawTypeEnum.valueOf(arr[3]);
                            size = Integer.parseInt(arr[4]);
                            fname.trim();
                            colortext = component.getColorText();
                        } else {
                            fname = "";
                            nameDrawType = DrawTypeEnum.Center;
                            size = 10;
                        }
                        if (component.shapeType == ShapeEnum.Straight) {
                            this.drawSVGLines(startX, startY, endX, endY, lineWeight, component.getColor(), style.name().toString(), fname, nameDrawType.name().toString(), size, colortext, bdash, svgElement, g2d);
                            continue;
                        }
                        if (component.shapeType == ShapeEnum.Bezier) {
                            this.drawSVGPolyCurveTwo(startX, startY, Control1X, Control1Y, Control2X, Control2Y, endX, endY, lineWeight, component.getColor(), style.name().toString(), bdash, svgElement);
                            continue;
                        }
                        if (component.shapeType == ShapeEnum.Curve) {
                            this.drawSVGPolyCurveOne(startX, startY, Control1X, Control1Y, endX, endY, lineWeight, component.getColor(), style.name().toString(), bdash, svgElement);
                            continue;
                        }
                        if (component.shapeType == ShapeEnum.PolylineOne) {
                            this.drawSVGPolyLineOne(startX, startY, Control1X, Control1Y, endX, endY, lineWeight, component.getColor(), style.name().toString(), bdash, svgElement);
                            continue;
                        }
                        if (component.shapeType != ShapeEnum.PolylineTwo) continue;
                        this.drawSVGPolyLineTwo(startX, startY, Control1X, Control1Y, Control2X, Control2Y, endX, endY, lineWeight, component.getColor(), style.name().toString(), bdash, svgElement);
                        continue;
                    }
                    if (component.getType() == ComponentEnum.Bracket) {
                        arr = component.getParameter().split(DELIMIT);
                        int strokesize2 = Integer.valueOf(arr[0]);
                        this.drawSVGBracket(vertical, horizontal, (int)component.getCenterx(), (int)component.getCentery(), (int)component.getWide(), (int)component.getRotationAngle(), strokesize2, this.getGrayColor(component.getColor()), component.shapeType.name().toString(), svgElement);
                        continue;
                    }
                    if (component.getType() == ComponentEnum.Note) {
                        arr = component.getParameter().split(DELIMIT);
                        String title = arr[0];
                        int size = Integer.parseInt(arr[1]);
                        DrawTypeEnum style = DrawTypeEnum.valueOf(arr[2]);
                        double angle = component.getRotationAngle();
                        int linesize = Integer.parseInt(arr[4]);
                        Color colorline = component.getColorline();
                        Boolean bdash = component.bDash;
                        String strFont = arr.length > 5 ? arr[5] : "Arial";
                        this.drawSVGNote(vertical, horizontal, title, (int)component.getX(), component.getY(), size, style.name().toString(), angle, component.getColor(), linesize, colorline, bdash, strFont, g2d, svgElement);
                        continue;
                    }
                    if (component.getType() == ComponentEnum.Site) {
                        arr = component.getParameter().split(DELIMIT);
                        String site = arr[0];
                        String text = arr[1];
                        int deltaX = (int)component.getCenterx();
                        int deltaY = (int)component.getCentery();
                        int size = Integer.parseInt(arr[2]);
                        boolean isShowPosition = Boolean.valueOf(arr[3]);
                        int strokesize3 = Integer.valueOf(arr[4]);
                        GradientEnum GradientType1 = GradientEnum.valueOf(arr[5]);
                        String SelectTextureFile1 = arr[6];
                        this.drawSVGSite(vertical, horizontal, site, deltaX, deltaY, (int)component.getWide(), (int)component.getHigh(), component.getRotationAngle(), size, isShowPosition, this.getGrayColor(component.getColor()), text, size, this.getGrayColor(component.getColorText()), "Center", strokesize3, this.getGrayColor(component.getColorline()), SelectTextureFile1, this.SVGFilePath, component.shapeType.name().toString(), GradientType1.toString(), component.isbDash(), g2d, svgElement);
                        continue;
                    }
                    if (component.getType() == ComponentEnum.Domain) {
                        String SelectTextureFile1;
                        GradientEnum GradientType1;
                        arr = component.getParameter().split(DELIMIT);
                        DrawTypeEnum startDrawType = DrawTypeEnum.valueOf(arr[0]);
                        DrawTypeEnum endDrawType = DrawTypeEnum.valueOf(arr[1]);
                        String name = arr[2];
                        DrawTypeEnum nameDrawType = DrawTypeEnum.valueOf(arr[3]);
                        int size = Integer.parseInt(arr[4]);
                        strokesize = 1;
                        if (arr.length > 5) {
                            strokesize = Integer.valueOf(arr[5]);
                            GradientType1 = GradientEnum.valueOf(arr[6]);
                            SelectTextureFile1 = arr[7];
                        } else {
                            strokesize = 1;
                            SelectTextureFile1 = "00000_0.jpg";
                            GradientType1 = GradientEnum.Horizontal;
                        }
                        this.drawSVGProteinDomain(vertical, horizontal, (int)component.getX(), startDrawType.name().toString(), (int)component.getX2(), endDrawType.name().toString(), proteinHeight, 0.0, this.getGrayColor(component.getColor()), name, nameDrawType.name().toString(), size, this.getGrayColor(component.getColorText()), strokesize, this.getGrayColor(component.getColorline()), SelectTextureFile1, this.SVGFilePath, "Rectangle", GradientType1.name().toString(), component.isbDash(), g2d, svgElement);
                        continue;
                    }
                    if (component.getType() == ComponentEnum.CutLine) {
                        String SelectTextureFile1;
                        GradientEnum GradientType1;
                        arr = component.getParameter().split(DELIMIT);
                        DrawTypeEnum startDrawType = DrawTypeEnum.valueOf(arr[0]);
                        DrawTypeEnum endDrawType = DrawTypeEnum.valueOf(arr[1]);
                        String name = arr[2];
                        DrawTypeEnum nameDrawType = DrawTypeEnum.valueOf(arr[3]);
                        int size = Integer.parseInt(arr[4]);
                        strokesize = 1;
                        if (arr.length > 5) {
                            strokesize = Integer.valueOf(arr[5]);
                            GradientType1 = GradientEnum.valueOf(arr[6]);
                            SelectTextureFile1 = arr[7];
                        } else {
                            strokesize = 1;
                            SelectTextureFile1 = "00000_0.jpg";
                            GradientType1 = GradientEnum.Horizontal;
                        }
                        this.drawSVGProteinCutLine(vertical, horizontal, (int)component.getX(), startDrawType.name().toString(), (int)component.getX2(), endDrawType.name().toString(), (int)component.getHigh(), 0.0, this.getGrayColor(component.getColor()), name, nameDrawType.name().toString(), size, this.getGrayColor(component.getColorText()), strokesize, this.getGrayColor(component.getColorline()), SelectTextureFile1, this.SVGFilePath, component.shapeType.name().toString(), GradientType1.name().toString(), component.isbDash(), g2d, svgElement);
                        continue;
                    }
                    if (component.getType() != ComponentEnum.Polygon) continue;
                    arr = component.getParameter().split(DELIMIT);
                    String name = arr[0];
                    int size = Integer.parseInt(arr[2]);
                    DrawTypeEnum nameDrawType = DrawTypeEnum.valueOf(arr[1]);
                    int strokesize4 = Integer.valueOf(arr[3]);
                    GradientEnum GradientType1 = GradientEnum.valueOf(arr[4]);
                    String SelectTextureFile1 = arr[5];
                    vertical = -vertical;
                    double startx = 0.0;
                    double starty = 0.0;
                    double endx = 0.0;
                    double endy = 0.0;
                    double startX = 0.0;
                    double startY = 0.0;
                    double endX = 0.0;
                    double endY = 0.0;
                    startx = component.getCenterx() - component.getWide() / 2.0;
                    starty = component.getCentery() - component.getHigh() / 2.0;
                    endx = component.getCenterx() + component.getWide() / 2.0;
                    endy = component.getCentery() + component.getHigh() / 2.0;
                    startX = (-this.HALF_LENGTH + (double)horizontal + startx * this.LENGTH_RATE) * this.rate;
                    endX = (-this.HALF_LENGTH + (double)horizontal + endx * this.LENGTH_RATE) * this.rate;
                    startY = ((double)vertical - component.getCentery() - component.getHigh() / 2.0 * this.LENGTH_RATE) * this.rate;
                    endY = ((double)vertical - component.getCentery() + component.getHigh() / 2.0 * this.LENGTH_RATE) * this.rate;
                    PolygonXY pgxy = new PolygonXY();
                    pgxy.getPolygonXY(startX, startY, endX, endY, component.shapeType.name().toString(), component.getRotationAngle(), this.rate);
                    pgxy.CacuMinMaxXY();
                    this.drawSVGPolygon(null, null, (int)startX, (int)startY, (int)endX, (int)endY, pgxy.minx, pgxy.miny, pgxy.maxx, pgxy.maxy, pgxy.x, pgxy.y, size, this.getGrayColor(component.getColor()), (int)component.getRotationAngle(), GradientType1.name().toString(), component.getShapeType().name().toString(), name, size, this.getGrayColor(component.getColorText()), nameDrawType.name().toString(), strokesize4, this.getGrayColor(component.getColorline()), SelectTextureFile1, this.SVGFilePath, component.getHigh(), component.isbDash(), false, g2d, svgElement);
                }
            }
        }
        return doc;
    }

    public boolean reWriteSVGFile(String svgFiletemp) throws IOException {
        boolean flag = false;
        String filein = "\r\n";
        String temp = "";
        FileInputStream fis = null;
        InputStreamReader isr = null;
        BufferedReader br = null;
        FileOutputStream fos = null;
        PrintWriter pw = null;
        try {
            File file = new File(svgFiletemp);
            fis = new FileInputStream(file);
            isr = new InputStreamReader(fis);
            br = new BufferedReader(isr);
            StringBuffer buf = new StringBuffer();
            String svghead = "xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" ";
            int j = 1;
            while ((temp = br.readLine()) != null) {
                String tempnew = "";
                int isvg = temp.indexOf("<svg");
                if (isvg >= 0) {
                    tempnew = "<svg " + svghead + temp.substring(4);
                    buf = buf.append(tempnew);
                } else {
                    int iimage = temp.indexOf("<image");
                    if (iimage >= 0) {
                        int ixlink = temp.indexOf("xlink");
                        if (ixlink >= 0) {
                            tempnew = temp.substring(0, ixlink - 1) + " xlink:href" + temp.substring(ixlink + 5);
                            buf = buf.append(tempnew);
                        }
                    } else {
                        buf = buf.append(temp);
                    }
                }
                buf = buf.append(System.getProperty("line.separator"));
                ++j;
            }
            buf.append(filein);
            fos = new FileOutputStream(file);
            pw = new PrintWriter(fos);
            pw.write(buf.toString().toCharArray());
            pw.flush();
            flag = true;
        }
        catch (IOException e1) {
            throw e1;
        }
        finally {
            if (pw != null) {
                pw.close();
            }
            if (fos != null) {
                fos.close();
            }
            if (br != null) {
                br.close();
            }
            if (isr != null) {
                isr.close();
            }
            if (fis != null) {
                fis.close();
            }
        }
        return flag;
    }

    public void drawPolygonTextureLine(double bnewminx, double bnewminy, double bnewmaxx, double bnewmaxy, String LineFile, Color color, String shapeType, int strokesize, String clipPathid, Element svgElement) {
        block22: {
            int endy;
            int endx;
            int starty;
            int startx;
            int yend;
            int ystart;
            int xend;
            int xstart;
            String stroke_dasharray;
            block32: {
                int endy2;
                int endx2;
                int starty2;
                int startx2;
                block31: {
                    block30: {
                        block29: {
                            block28: {
                                block27: {
                                    double endY;
                                    double endX;
                                    double startY;
                                    double startX;
                                    block26: {
                                        block25: {
                                            block24: {
                                                block23: {
                                                    block21: {
                                                        stroke_dasharray = "";
                                                        startX = 0.0;
                                                        startY = 0.0;
                                                        endX = 0.0;
                                                        endY = 0.0;
                                                        startX = bnewminx;
                                                        startY = bnewminy;
                                                        endX = bnewmaxx;
                                                        endY = bnewmaxy;
                                                        int centerY = (int)(startY + (endY - startY) / 2.0);
                                                        int centerX = (int)(startX + (endX - startX) / 2.0);
                                                        xstart = 0;
                                                        xend = 0;
                                                        ystart = 0;
                                                        yend = 0;
                                                        int iVhigh = (int)(endY - startY);
                                                        int iType = 1;
                                                        if ((int)(endX - startX) == iVhigh) {
                                                            xstart = (int)startX;
                                                            xend = (int)startX + (int)((endX - startX) * 2.0);
                                                            ystart = centerY - iVhigh;
                                                            yend = centerY + iVhigh;
                                                            iType = 1;
                                                        } else if ((int)(endX - startX) > iVhigh) {
                                                            xstart = (int)startX;
                                                            xend = (int)startX + (int)((endX - startX) * 2.0);
                                                            ystart = (int)((double)centerY - (endX - startX));
                                                            yend = (int)((double)centerY + (endX - startX));
                                                            iType = 2;
                                                        } else if ((int)(endX - startX) < iVhigh) {
                                                            xstart = centerX - iVhigh * 3;
                                                            xend = centerX + iVhigh * 3;
                                                            ystart = centerY - iVhigh / 2;
                                                            yend = centerY + iVhigh * 3 / 2;
                                                            iType = 3;
                                                        }
                                                        if (!LineFile.equals("00001.jpg")) break block21;
                                                        int p = 0;
                                                        while (startX + (double)p < endX) {
                                                            int startx3 = (int)(startX + (double)p);
                                                            int endx3 = (int)(startX + (double)p);
                                                            int starty3 = (int)startY;
                                                            int endy3 = (int)endY;
                                                            this.drawSVGTextureLine(startx3, starty3, endx3, endy3, strokesize, color, clipPathid, stroke_dasharray, svgElement);
                                                            p += this.lineInterval;
                                                        }
                                                        int q = 0;
                                                        while (startY + (double)q < endY) {
                                                            int starty4 = (int)(startY + (double)q);
                                                            int endy4 = (int)(startY + (double)q);
                                                            int startx4 = (int)startX;
                                                            int endx4 = (int)endX;
                                                            this.drawSVGTextureLine(startx4, starty4, endx4, endy4, strokesize, color, clipPathid, stroke_dasharray, svgElement);
                                                            q += this.lineInterval;
                                                        }
                                                        break block22;
                                                    }
                                                    if (!LineFile.equals("00001_d.jpg")) break block23;
                                                    stroke_dasharray = "5,3,2";
                                                    int p = 0;
                                                    while (startX + (double)p < endX) {
                                                        int startx5 = (int)(startX + (double)p);
                                                        int endx5 = (int)(startX + (double)p);
                                                        int starty5 = (int)startY;
                                                        int endy5 = (int)endY;
                                                        this.drawSVGTextureLine(startx5, starty5, endx5, endy5, strokesize, color, clipPathid, stroke_dasharray, svgElement);
                                                        p += this.lineInterval;
                                                    }
                                                    int q = 0;
                                                    while (startY + (double)q < endY) {
                                                        int starty6 = (int)(startY + (double)q);
                                                        int endy6 = (int)(startY + (double)q);
                                                        int startx6 = (int)startX;
                                                        int endx6 = (int)endX;
                                                        this.drawSVGTextureLine(startx6, starty6, endx6, endy6, strokesize, color, clipPathid, stroke_dasharray, svgElement);
                                                        q += this.lineInterval;
                                                    }
                                                    break block22;
                                                }
                                                if (!LineFile.equals("00003.jpg")) break block24;
                                                int p = 0;
                                                while (startX + (double)p < endX) {
                                                    int startx7 = (int)(startX + (double)p);
                                                    int endx7 = (int)(startX + (double)p);
                                                    int starty7 = (int)startY;
                                                    int endy7 = (int)endY;
                                                    this.drawSVGTextureLine(startx7, starty7, endx7, endy7, strokesize, color, clipPathid, stroke_dasharray, svgElement);
                                                    p += this.lineInterval;
                                                }
                                                break block22;
                                            }
                                            if (!LineFile.equals("00003_d.jpg")) break block25;
                                            stroke_dasharray = "5,3,2";
                                            int p = 0;
                                            while (startX + (double)p < endX) {
                                                int startx8 = (int)(startX + (double)p);
                                                int endx8 = (int)(startX + (double)p);
                                                int starty8 = (int)startY;
                                                int endy8 = (int)endY;
                                                this.drawSVGTextureLine(startx8, starty8, endx8, endy8, strokesize, color, clipPathid, stroke_dasharray, svgElement);
                                                p += this.lineInterval;
                                            }
                                            break block22;
                                        }
                                        if (!LineFile.equals("00002.jpg")) break block26;
                                        int q = 0;
                                        while (startY + (double)q < endY) {
                                            int starty9 = (int)(startY + (double)q);
                                            int endy9 = (int)(startY + (double)q);
                                            int startx9 = (int)startX;
                                            int endx9 = (int)endX;
                                            this.drawSVGTextureLine(startx9, starty9, endx9, endy9, strokesize, color, clipPathid, stroke_dasharray, svgElement);
                                            q += this.lineInterval;
                                        }
                                        break block22;
                                    }
                                    if (!LineFile.equals("00002_d.jpg")) break block27;
                                    stroke_dasharray = "5,3,2";
                                    int q = 0;
                                    while (startY + (double)q < endY) {
                                        int starty10 = (int)(startY + (double)q);
                                        int endy10 = (int)(startY + (double)q);
                                        int startx10 = (int)startX;
                                        int endx10 = (int)endX;
                                        this.drawSVGTextureLine(startx10, starty10, endx10, endy10, strokesize, color, clipPathid, stroke_dasharray, svgElement);
                                        q += this.lineInterval;
                                    }
                                    break block22;
                                }
                                if (!LineFile.equals("00004.jpg")) break block28;
                                int r = xend - xstart;
                                int xendorig = xend;
                                int xstartorig = xstart;
                                xstart -= r;
                                xend += r;
                                int p = 0;
                                while (xstart + p < xendorig) {
                                    int startx11 = xstart + p;
                                    int starty11 = ystart;
                                    int endx11 = xstartorig + p;
                                    int endy11 = yend;
                                    this.drawSVGTextureLine(startx11, starty11, endx11, endy11, strokesize, color, clipPathid, stroke_dasharray, svgElement);
                                    p += this.lineInterval;
                                }
                                break block22;
                            }
                            if (!LineFile.equals("00004_d.jpg")) break block29;
                            int p = 0;
                            stroke_dasharray = "5,3,2";
                            int r = xend - xstart;
                            int xendorig = xend;
                            int xstartorig = xstart;
                            xstart -= r;
                            xend += r;
                            while (xstart + p < xendorig) {
                                int startx12 = xstart + p;
                                int starty12 = ystart;
                                int endx12 = xstartorig + p;
                                int endy12 = yend;
                                this.drawSVGTextureLine(startx12, starty12, endx12, endy12, strokesize, color, clipPathid, stroke_dasharray, svgElement);
                                p += this.lineInterval;
                            }
                            break block22;
                        }
                        if (!LineFile.equals("00005.jpg")) break block30;
                        int r = xend - xstart;
                        int xendorig = xend;
                        int xstartorig = xstart;
                        xstart -= r;
                        xend += r;
                        int p = 0;
                        while (xstart + p < xendorig) {
                            int startx13 = xstart + p;
                            int starty13 = yend;
                            int endx13 = xstartorig + p;
                            int endy13 = ystart;
                            this.drawSVGTextureLine(startx13, starty13, endx13, endy13, strokesize, color, clipPathid, stroke_dasharray, svgElement);
                            p += this.lineInterval;
                        }
                        break block22;
                    }
                    if (!LineFile.equals("00005_d.jpg")) break block31;
                    stroke_dasharray = "5,3,2";
                    int r = xend - xstart;
                    int xendorig = xend;
                    int xstartorig = xstart;
                    xstart -= r;
                    xend += r;
                    int p = 0;
                    while (xstart + p < xendorig) {
                        int startx14 = xstart + p;
                        int starty14 = yend;
                        int endx14 = xstartorig + p;
                        int endy14 = ystart;
                        this.drawSVGTextureLine(startx14, starty14, endx14, endy14, strokesize, color, clipPathid, stroke_dasharray, svgElement);
                        p += this.lineInterval;
                    }
                    break block22;
                }
                if (!LineFile.equals("00006.jpg")) break block32;
                int r = xend - xstart;
                int xendorig = xend;
                int xstartorig = xstart;
                xstart -= r;
                xend += r;
                int p = 0;
                while (xstart + p < xendorig) {
                    startx2 = xstart + p;
                    starty2 = yend;
                    endx2 = xstartorig + p;
                    endy2 = ystart;
                    this.drawSVGTextureLine(startx2, starty2, endx2, endy2, strokesize, color, clipPathid, stroke_dasharray, svgElement);
                    p += this.lineInterval;
                }
                p = 0;
                r = xend - xstart;
                xendorig = xend;
                xstartorig = xstart;
                xstart -= r;
                xend += r;
                while (xstart + p < xendorig) {
                    startx2 = xstart + p;
                    starty2 = ystart;
                    endx2 = xstartorig + p;
                    endy2 = yend;
                    this.drawSVGTextureLine(startx2, starty2, endx2, endy2, strokesize, color, clipPathid, stroke_dasharray, svgElement);
                    p += this.lineInterval;
                }
                break block22;
            }
            if (!LineFile.equals("00006_d.jpg")) break block22;
            int p = 0;
            stroke_dasharray = "5,3,2";
            int r = xend - xstart;
            int xendorig = xend;
            int xstartorig = xstart;
            xstart -= r;
            xend += r;
            while (xstart + p < xendorig) {
                startx = xstart + p;
                starty = yend;
                endx = xstartorig + p;
                endy = ystart;
                this.drawSVGTextureLine(startx, starty, endx, endy, strokesize, color, clipPathid, stroke_dasharray, svgElement);
                p += this.lineInterval;
            }
            p = 0;
            r = xend - xstart;
            xendorig = xend;
            xstartorig = xstart;
            xstart -= r;
            xend += r;
            while (xstart + p < xendorig) {
                startx = xstart + p;
                starty = ystart;
                endx = xstartorig + p;
                endy = yend;
                this.drawSVGTextureLine(startx, starty, endx, endy, strokesize, color, clipPathid, stroke_dasharray, svgElement);
                p += this.lineInterval;
            }
        }
    }
}

