/*
 * Decompiled with CFR 0.152.
 */
package gui.ibs;

import gui.Tools;
import gui.ibs.Component;
import gui.ibs.ComponentEnum;
import gui.ibs.CustomComboBoxDemo;
import gui.ibs.EditDialog;
import gui.ibs.GradientEnum;
import gui.ibs.PreviewPanel;
import gui.ibs.ResourceBundleUtil;
import gui.ibs.ShapeEnum;
import gui.ibs.Verifier;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.LinkedList;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SiteDialog
extends EditDialog {
    private Component component;
    private String DELIMIT = "#&%";
    public ShapeEnum shapeType = ShapeEnum.Circle;
    public GradientEnum gradientType;
    ResourceBundleUtil config;
    public String strNum = "";
    private JButton cancelButton;
    private JLabel colorLabel;
    private JPanel colorLine;
    private JPanel colorPanel;
    private JPanel colorText;
    private CustomComboBoxDemo comBoxGradient;
    private CustomComboBoxDemo comboBoxShape;
    private JLabel deltaXLabel;
    private JTextField deltaXTextField;
    private JLabel deltaYLabel;
    private JTextField deltaYTextField;
    private JLabel endLabel;
    private JLabel fontLabel;
    private JTextField fontTextField;
    private JTextField highTextField;
    private JCheckBox jCheckBoxBorderDash;
    private JCheckBox jCheckBoxDC;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel17;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JLabel jLabelShape;
    private JLabel jLabelTip;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JSpinner jSpinnerRotationAngle;
    private JSpinner jSpinnerStrokeSize;
    private JTextField jTextFieldID;
    private JLabel lineLabel;
    private JPanel mainPanel;
    private JButton okButton;
    private JCheckBox positionCheckBox;
    private JLabel positionLabel;
    private JTextField positionTextField;
    private JPanel previewPanel;
    private JLabel textLabel;
    private JTextField textTextField;
    private CustomComboBoxDemo texturechoose;
    private JTextField wideTextField;

    public SiteDialog(Frame parent, String title, boolean modal, ImageIcon[] images, ImageIcon[] imagesShape, ImageIcon[] imagesGradient, String fstrNum) {
        super(parent, title, modal);
        this.strNum = fstrNum;
        this.setPreferredSize(new Dimension(780, 680));
        this.config = ResourceBundleUtil.getBundle("gui.ibs.config");
        this.initComponents();
        this.setTitle(title);
        this.texturechoose.siteDialog20 = this;
        this.texturechoose.SelectTextureFile = "00000_0.jpg";
        this.texturechoose.setComImages(images, "Text");
        this.comboBoxShape.siteDialog20 = this;
        this.comboBoxShape.SelectTextureFile = "Circle";
        this.comboBoxShape.setComImages(imagesShape, "ShapeSite");
        this.comBoxGradient.siteDialog20 = this;
        this.comBoxGradient.SelectTextureFile = "Center";
        this.comBoxGradient.setComImages(imagesGradient, "Gradient");
        Color colorbk = new Color(239, 195, 38);
        this.colorPanel.setBackground(colorbk);
        String st = "Users can drag the element for absolute positioning, resize it and rotate it through the mouse.";
        this.jLabelTip.setText(st);
        this.previewDraw();
        this.positionTextField.requestFocus();
        this.enableEvents(8L);
        InputMap inputMap = this.rootPane.getInputMap(2);
        inputMap.put(KeyStroke.getKeyStroke("ESCAPE"), "ESCAPE");
        this.rootPane.getActionMap().put("ESCAPE", new AbstractAction("ESCAPE"){

            @Override
            public void actionPerformed(ActionEvent e) {
                SiteDialog.this.cancelButton.doClick();
            }
        });
        inputMap.put(KeyStroke.getKeyStroke("ENTER"), "ENTER");
        this.rootPane.getActionMap().put("ENTER", new AbstractAction("ENTER"){

            @Override
            public void actionPerformed(ActionEvent e) {
                SiteDialog.this.okButton.doClick();
            }
        });
    }

    public SiteDialog(Frame parent, String title, boolean modal, ImageIcon[] images, ImageIcon[] imagesShape, ImageIcon[] imagesGradient, int proteinlenth, String fstrNum) {
        super(parent, title, modal);
        this.strNum = fstrNum;
        this.setPreferredSize(new Dimension(780, 680));
        this.config = ResourceBundleUtil.getBundle("gui.ibs.config");
        this.initComponents();
        this.setTitle(title);
        this.texturechoose.siteDialog20 = this;
        this.texturechoose.SelectTextureFile = "00000_0.jpg";
        this.texturechoose.setComImages(images, "Text");
        this.comboBoxShape.siteDialog20 = this;
        this.comboBoxShape.SelectTextureFile = "Circle";
        this.comboBoxShape.setComImages(imagesShape, "ShapeSite");
        this.comBoxGradient.siteDialog20 = this;
        this.comBoxGradient.SelectTextureFile = "Center";
        this.comBoxGradient.setComImages(imagesGradient, "Gradient");
        this.jTextFieldID.setText(this.strNum);
        Color bc = new Color(204, 204, 204);
        this.jTextFieldID.setForeground(bc);
        String whrate = this.config.getString("SiteDialog.whrate");
        int wh = (int)Math.round((double)proteinlenth * Double.valueOf(whrate));
        this.highTextField.setText(String.valueOf(wh));
        this.wideTextField.setText(String.valueOf(wh));
        Color colorbk = new Color(239, 195, 38);
        this.colorPanel.setBackground(colorbk);
        String st = "Users can drag the element for absolute positioning, resize it and rotate it through the mouse.";
        this.jLabelTip.setText(st);
        this.previewDraw();
        this.positionTextField.requestFocus();
        this.enableEvents(8L);
        InputMap inputMap = this.rootPane.getInputMap(2);
        inputMap.put(KeyStroke.getKeyStroke("ESCAPE"), "ESCAPE");
        this.rootPane.getActionMap().put("ESCAPE", new AbstractAction("ESCAPE"){

            @Override
            public void actionPerformed(ActionEvent e) {
                SiteDialog.this.cancelButton.doClick();
            }
        });
        inputMap.put(KeyStroke.getKeyStroke("ENTER"), "ENTER");
        this.rootPane.getActionMap().put("ENTER", new AbstractAction("ENTER"){

            @Override
            public void actionPerformed(ActionEvent e) {
                SiteDialog.this.okButton.doClick();
            }
        });
    }

    @Override
    public Component getComponent() {
        return this.component;
    }

    public void changeGradient() {
        if (this.texturechoose.SelectTextureFile.equals("00000_0.jpg") || this.texturechoose.SelectTextureFile.equals("00001.jpg") || this.texturechoose.SelectTextureFile.equals("00001_d.jpg") || this.texturechoose.SelectTextureFile.equals("00002.jpg") || this.texturechoose.SelectTextureFile.equals("00002_d.jpg") || this.texturechoose.SelectTextureFile.equals("00003.jpg") || this.texturechoose.SelectTextureFile.equals("00003_d.jpg") || this.texturechoose.SelectTextureFile.equals("00004.jpg") || this.texturechoose.SelectTextureFile.equals("00004_d.jpg") || this.texturechoose.SelectTextureFile.equals("00005.jpg") || this.texturechoose.SelectTextureFile.equals("00005_d.jpg") || this.texturechoose.SelectTextureFile.equals("00006.jpg") || !this.texturechoose.SelectTextureFile.equals("00006_d.jpg")) {
            // empty if block
        }
    }

    @Override
    public void setComponent(Component component) {
        this.jCheckBoxDC.setSelected(false);
        String[] arr = component.getParameter().split(this.DELIMIT);
        this.positionTextField.setText(arr[0]);
        this.textTextField.setText(arr[1]);
        this.fontTextField.setText(arr[2]);
        this.positionCheckBox.setSelected(Boolean.valueOf(arr[3]));
        this.jCheckBoxBorderDash.setSelected(component.bDash);
        this.colorPanel.setBackground(component.getColor());
        this.colorText.setBackground(component.getColorText());
        this.colorLine.setBackground(component.getColorline());
        this.deltaXTextField.setText(String.valueOf((int)component.getCenterx()));
        this.deltaYTextField.setText(String.valueOf((int)component.getCentery()));
        this.wideTextField.setText(String.valueOf((int)component.getWide()));
        this.highTextField.setText(String.valueOf((int)component.getHigh()));
        this.jSpinnerRotationAngle.setValue((int)component.getRotationAngle());
        this.jSpinnerStrokeSize.setValue(Integer.valueOf(arr[4]));
        this.shapeType = component.getShapeType();
        this.gradientType = GradientEnum.valueOf(arr[5]);
        this.comboBoxShape.SelectTextureFile = component.getShapeType().name().toString();
        this.comboBoxShape.setComboBoxIndex();
        this.comBoxGradient.SelectTextureFile = arr[5];
        this.comBoxGradient.setComboBoxIndex();
        this.texturechoose.SelectTextureFile = arr[6];
        this.texturechoose.setComboBoxIndex();
        if (component.fid != null && !component.fid.trim().equals("") && component.fid.trim() != null) {
            this.jTextFieldID.setText(component.fid);
            this.jTextFieldID.setForeground(Color.BLACK);
        }
        this.previewDraw();
    }

    public void previewDraw() {
        String fname;
        LinkedList<Component> componentList = new LinkedList<Component>();
        String site = this.positionTextField.getText().trim();
        if (site.equals("")) {
            site = "10";
        }
        if ((fname = this.textTextField.getText()).equals("") || fname.equals(null)) {
            fname = "test";
        }
        int iWide = 0;
        int iHigh = 0;
        iWide = (int)Double.parseDouble(this.wideTextField.getText().trim());
        iHigh = (int)Double.parseDouble(this.highTextField.getText().trim());
        int iRotationAngle = (Integer)this.jSpinnerRotationAngle.getValue();
        int strokesize = (Integer)this.jSpinnerStrokeSize.getValue();
        if (this.comboBoxShape.SelectTextureFile.equals("00000_1.jpg")) {
            this.shapeType = ShapeEnum.Rectangle;
        } else {
            String strShape = this.comboBoxShape.SelectTextureFile;
            if (strShape.indexOf(".") > 0) {
                strShape = strShape.substring(0, strShape.indexOf("."));
            }
            this.shapeType = ShapeEnum.valueOf(strShape);
        }
        if (this.comBoxGradient.SelectTextureFile.equals("00000_1.jpg")) {
            this.gradientType = GradientEnum.Null;
        } else {
            String strGradient = this.comBoxGradient.SelectTextureFile;
            if (strGradient.indexOf(".") > 0) {
                strGradient = strGradient.substring(0, strGradient.indexOf("."));
            }
            this.gradientType = GradientEnum.valueOf(strGradient);
        }
        String parameter = site + this.DELIMIT + fname + this.DELIMIT + this.fontTextField.getText().trim() + this.DELIMIT + this.positionCheckBox.isSelected() + this.DELIMIT + strokesize + this.DELIMIT + this.gradientType.name().toString() + this.DELIMIT + this.texturechoose.SelectTextureFile;
        Component siteComponent = new Component(ComponentEnum.Site, Integer.parseInt(this.deltaXTextField.getText().trim()), Integer.parseInt(this.deltaYTextField.getText().trim()), parameter, this.colorText.getBackground(), this.shapeType, "site", iWide, iHigh, iRotationAngle, this.colorPanel.getBackground(), this.colorLine.getBackground(), this.jCheckBoxBorderDash.isSelected(), "id");
        componentList.add(siteComponent);
        PreviewPanel.protein.setComponentList(componentList);
        this.previewPanel.repaint();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel4 = new JLabel();
        this.previewPanel = new PreviewPanel();
        this.mainPanel = new JPanel();
        this.jPanel2 = new JPanel();
        this.positionLabel = new JLabel();
        this.positionTextField = new JTextField();
        this.lineLabel = new JLabel();
        this.positionCheckBox = new JCheckBox();
        this.jPanel7 = new JPanel();
        this.textLabel = new JLabel();
        this.textTextField = new JTextField();
        this.fontLabel = new JLabel();
        this.fontTextField = new JTextField();
        this.colorLabel = new JLabel();
        this.colorText = new JPanel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jPanel6 = new JPanel();
        this.deltaXLabel = new JLabel();
        this.deltaXTextField = new JTextField();
        this.deltaYLabel = new JLabel();
        this.deltaYTextField = new JTextField();
        this.jPanel4 = new JPanel();
        this.jLabelShape = new JLabel();
        this.comboBoxShape = new CustomComboBoxDemo();
        this.jLabel5 = new JLabel();
        this.jSpinnerRotationAngle = new JSpinner();
        this.jLabel14 = new JLabel();
        this.colorPanel = new JPanel();
        this.jCheckBoxDC = new JCheckBox();
        this.jLabel12 = new JLabel();
        this.jLabel13 = new JLabel();
        this.texturechoose = new CustomComboBoxDemo();
        this.jLabel6 = new JLabel();
        this.comBoxGradient = new CustomComboBoxDemo();
        this.endLabel = new JLabel();
        this.wideTextField = new JTextField();
        this.jLabel8 = new JLabel();
        this.highTextField = new JTextField();
        this.jPanel5 = new JPanel();
        this.jLabel7 = new JLabel();
        this.jSpinnerStrokeSize = new JSpinner();
        this.jCheckBoxBorderDash = new JCheckBox();
        this.jLabel9 = new JLabel();
        this.jLabel17 = new JLabel();
        this.colorLine = new JPanel();
        this.jLabel10 = new JLabel();
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        this.jPanel3 = new JPanel();
        this.jLabel11 = new JLabel();
        this.jTextFieldID = new JTextField();
        this.jPanel1 = new JPanel();
        this.jLabelTip = new JLabel();
        this.jLabel1.setText("jLabel1");
        this.jLabel4.setText("jLabel4");
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(700, 320));
        this.setPreferredSize(new Dimension(900, 700));
        this.setResizable(false);
        this.previewPanel.setBorder(BorderFactory.createTitledBorder(null, "Preview", 0, 0, new Font("Arial", 1, 14)));
        this.previewPanel.setMinimumSize(new Dimension(280, 440));
        this.previewPanel.setPreferredSize(new Dimension(480, 440));
        this.previewPanel.setLayout(new BorderLayout());
        this.getContentPane().add((java.awt.Component)this.previewPanel, "Center");
        this.mainPanel.setBorder(BorderFactory.createTitledBorder(null, "Option", 0, 0, new Font("Arial", 1, 14)));
        this.mainPanel.setMinimumSize(new Dimension(450, 440));
        this.mainPanel.setPreferredSize(new Dimension(600, 440));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(null, "Site (delimited with semicolons)", 0, 0, new Font("Arial", 1, 12)));
        this.jPanel2.setLayout(new GridLayout(1, 4, 10, 10));
        this.positionLabel.setFont(new Font("Arial", 1, 12));
        this.positionLabel.setHorizontalAlignment(4);
        this.positionLabel.setText("Position(s)");
        this.jPanel2.add(this.positionLabel);
        this.positionTextField.setHorizontalAlignment(0);
        this.positionTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                SiteDialog.this.positionTextFieldFocusLost(evt);
            }
        });
        this.jPanel2.add(this.positionTextField);
        this.lineLabel.setFont(new Font("Arial", 1, 12));
        this.lineLabel.setHorizontalAlignment(11);
        this.lineLabel.setText("Show Position");
        this.lineLabel.setHorizontalTextPosition(4);
        this.jPanel2.add(this.lineLabel);
        this.positionCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                SiteDialog.this.positionCheckBoxStateChanged(evt);
            }
        });
        this.jPanel2.add(this.positionCheckBox);
        this.jPanel7.setBorder(BorderFactory.createTitledBorder(null, "Text", 0, 0, new Font("Arial", 1, 12)));
        this.jPanel7.setMaximumSize(new Dimension(426, 426));
        this.jPanel7.setPreferredSize(new Dimension(404, 59));
        this.jPanel7.setLayout(new GridLayout(2, 4, 10, 10));
        this.textLabel.setFont(new Font("Arial", 1, 12));
        this.textLabel.setHorizontalAlignment(4);
        this.textLabel.setText("Name");
        this.jPanel7.add(this.textLabel);
        this.textTextField.setHorizontalAlignment(0);
        this.textTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                SiteDialog.this.textTextFieldFocusLost(evt);
            }
        });
        this.jPanel7.add(this.textTextField);
        this.fontLabel.setFont(new Font("Arial", 1, 12));
        this.fontLabel.setHorizontalAlignment(4);
        this.fontLabel.setText("Font Size");
        this.jPanel7.add(this.fontLabel);
        this.fontTextField.setHorizontalAlignment(0);
        this.fontTextField.setText("11");
        this.fontTextField.setToolTipText("");
        this.jPanel7.add(this.fontTextField);
        this.colorLabel.setFont(new Font("Arial", 1, 12));
        this.colorLabel.setHorizontalAlignment(4);
        this.colorLabel.setText("Text Color");
        this.jPanel7.add(this.colorLabel);
        this.colorText.setBackground(Color.black);
        this.colorText.setBorder(BorderFactory.createBevelBorder(0));
        this.colorText.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                SiteDialog.this.colorTextMousePressed(evt);
            }
        });
        this.jPanel7.add(this.colorText);
        this.jPanel7.add(this.jLabel2);
        this.jPanel7.add(this.jLabel3);
        this.jPanel6.setBorder(BorderFactory.createTitledBorder(null, "Location", 0, 0, new Font("Arial", 1, 12)));
        this.jPanel6.setPreferredSize(new Dimension(404, 59));
        this.jPanel6.setLayout(new GridLayout(1, 4, 10, 10));
        this.deltaXLabel.setFont(new Font("Arial", 1, 12));
        this.deltaXLabel.setHorizontalAlignment(4);
        this.deltaXLabel.setText("Central X");
        this.jPanel6.add(this.deltaXLabel);
        this.deltaXTextField.setHorizontalAlignment(0);
        this.deltaXTextField.setText("0");
        this.jPanel6.add(this.deltaXTextField);
        this.deltaYLabel.setFont(new Font("Arial", 1, 12));
        this.deltaYLabel.setHorizontalAlignment(4);
        this.deltaYLabel.setText("Central Y");
        this.jPanel6.add(this.deltaYLabel);
        this.deltaYTextField.setHorizontalAlignment(0);
        this.deltaYTextField.setText("50");
        this.jPanel6.add(this.deltaYTextField);
        this.jPanel4.setBorder(BorderFactory.createTitledBorder(null, "Style", 0, 0, new Font("Arial", 1, 12)));
        this.jPanel4.setLayout(new GridLayout(4, 4, 10, 10));
        this.jLabelShape.setFont(new Font("Arial", 1, 12));
        this.jLabelShape.setHorizontalAlignment(4);
        this.jLabelShape.setText("Shape");
        this.jLabelShape.setOpaque(true);
        this.jLabelShape.setPreferredSize(null);
        this.jPanel4.add(this.jLabelShape);
        this.jPanel4.add(this.comboBoxShape);
        this.jLabel5.setFont(new Font("Arial", 1, 12));
        this.jLabel5.setHorizontalAlignment(4);
        this.jLabel5.setText("Rotation Angle");
        this.jLabel5.setOpaque(true);
        this.jLabel5.setPreferredSize(null);
        this.jPanel4.add(this.jLabel5);
        this.jSpinnerRotationAngle.setModel(new SpinnerNumberModel(0, -360, 360, 1));
        this.jSpinnerRotationAngle.setToolTipText("rotation angle");
        this.jSpinnerRotationAngle.setMinimumSize(new Dimension(41, 10));
        this.jPanel4.add(this.jSpinnerRotationAngle);
        this.jLabel14.setFont(new Font("Arial", 1, 12));
        this.jLabel14.setHorizontalAlignment(4);
        this.jLabel14.setText("Shape Color");
        this.jLabel14.setOpaque(true);
        this.jLabel14.setPreferredSize(null);
        this.jPanel4.add(this.jLabel14);
        this.colorPanel.setBackground(Color.blue);
        this.colorPanel.setBorder(BorderFactory.createBevelBorder(0));
        this.colorPanel.setToolTipText("");
        this.colorPanel.setPreferredSize(null);
        this.colorPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                SiteDialog.this.colorPanelMousePressed(evt);
            }
        });
        this.jPanel4.add(this.colorPanel);
        this.jCheckBoxDC.setFont(new Font("Arial", 1, 12));
        this.jCheckBoxDC.setSelected(true);
        this.jCheckBoxDC.setText("Default");
        this.jCheckBoxDC.setHorizontalAlignment(2);
        this.jCheckBoxDC.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SiteDialog.this.jCheckBoxDCActionPerformed(evt);
            }
        });
        this.jPanel4.add(this.jCheckBoxDC);
        this.jLabel12.setFont(new Font("Arial", 1, 12));
        this.jLabel12.setOpaque(true);
        this.jPanel4.add(this.jLabel12);
        this.jLabel13.setFont(new Font("Arial", 1, 12));
        this.jLabel13.setHorizontalAlignment(4);
        this.jLabel13.setText("Texture");
        this.jLabel13.setOpaque(true);
        this.jLabel13.setPreferredSize(null);
        this.jPanel4.add(this.jLabel13);
        this.jPanel4.add(this.texturechoose);
        this.jLabel6.setFont(new Font("Arial", 1, 12));
        this.jLabel6.setHorizontalAlignment(4);
        this.jLabel6.setText("Gradient");
        this.jLabel6.setOpaque(true);
        this.jLabel6.setPreferredSize(null);
        this.jPanel4.add(this.jLabel6);
        this.jPanel4.add(this.comBoxGradient);
        this.endLabel.setFont(new Font("Arial", 1, 12));
        this.endLabel.setHorizontalAlignment(4);
        this.endLabel.setText("Width");
        this.endLabel.setToolTipText("");
        this.jPanel4.add(this.endLabel);
        this.wideTextField.setHorizontalAlignment(0);
        this.wideTextField.setText("20");
        this.jPanel4.add(this.wideTextField);
        this.jLabel8.setFont(new Font("Arial", 1, 12));
        this.jLabel8.setHorizontalAlignment(4);
        this.jLabel8.setText("Height");
        this.jPanel4.add(this.jLabel8);
        this.highTextField.setHorizontalAlignment(0);
        this.highTextField.setText("20");
        this.highTextField.setToolTipText("");
        this.jPanel4.add(this.highTextField);
        this.jPanel5.setBorder(BorderFactory.createTitledBorder(null, "Border", 0, 0, new Font("Arial", 1, 12)));
        this.jPanel5.setPreferredSize(new Dimension(404, 59));
        this.jPanel5.setLayout(new GridLayout(2, 4, 10, 10));
        this.jLabel7.setFont(new Font("Arial", 1, 12));
        this.jLabel7.setHorizontalAlignment(4);
        this.jLabel7.setText("Line Size");
        this.jLabel7.setOpaque(true);
        this.jLabel7.setPreferredSize(null);
        this.jPanel5.add(this.jLabel7);
        this.jSpinnerStrokeSize.setModel(new SpinnerNumberModel(1, 1, 5, 1));
        this.jPanel5.add(this.jSpinnerStrokeSize);
        this.jCheckBoxBorderDash.setFont(new Font("Arial", 1, 12));
        this.jCheckBoxBorderDash.setText("Dash");
        this.jCheckBoxBorderDash.setHorizontalAlignment(2);
        this.jPanel5.add(this.jCheckBoxBorderDash);
        this.jLabel9.setFont(new Font("Arial", 1, 12));
        this.jLabel9.setHorizontalAlignment(0);
        this.jPanel5.add(this.jLabel9);
        this.jLabel17.setFont(new Font("Arial", 1, 12));
        this.jLabel17.setHorizontalAlignment(4);
        this.jLabel17.setText("Line Color");
        this.jLabel17.setOpaque(true);
        this.jLabel17.setPreferredSize(null);
        this.jPanel5.add(this.jLabel17);
        this.colorLine.setBackground(Color.black);
        this.colorLine.setBorder(BorderFactory.createBevelBorder(0));
        this.colorLine.setToolTipText("");
        this.colorLine.setPreferredSize(null);
        this.colorLine.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                SiteDialog.this.colorLineMousePressed(evt);
            }
        });
        this.jPanel5.add(this.colorLine);
        this.jPanel5.add(this.jLabel10);
        this.cancelButton.setFont(new Font("Arial", 1, 12));
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SiteDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.okButton.setFont(new Font("Arial", 1, 12));
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SiteDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.jPanel3.setBorder(BorderFactory.createTitledBorder(null, "", 0, 0, new Font("Arial", 1, 12)));
        this.jLabel11.setFont(new Font("\u5b8b\u4f53", 1, 12));
        this.jLabel11.setHorizontalAlignment(4);
        this.jLabel11.setText("ID");
        this.jLabel11.setPreferredSize(new Dimension(50, 15));
        this.jPanel3.add(this.jLabel11);
        this.jTextFieldID.setForeground(new Color(255, 255, 255));
        this.jTextFieldID.setPreferredSize(new Dimension(250, 25));
        this.jTextFieldID.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                SiteDialog.this.jTextFieldIDFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                SiteDialog.this.jTextFieldIDFocusLost(evt);
            }
        });
        this.jTextFieldID.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                SiteDialog.this.jTextFieldIDKeyPressed(evt);
            }
        });
        this.jPanel3.add(this.jTextFieldID);
        GroupLayout mainPanelLayout = new GroupLayout(this.mainPanel);
        this.mainPanel.setLayout(mainPanelLayout);
        mainPanelLayout.setHorizontalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, mainPanelLayout.createSequentialGroup().addContainerGap().addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jPanel3, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, mainPanelLayout.createSequentialGroup().addGap(169, 169, 169).addComponent(this.cancelButton, -2, 89, -2).addGap(43, 43, 43).addComponent(this.okButton, -2, 89, -2).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.jPanel4, -1, 566, Short.MAX_VALUE).addComponent(this.jPanel6, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel7, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel2, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel5, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        mainPanelLayout.setVerticalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, mainPanelLayout.createSequentialGroup().addComponent(this.jPanel3, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 24, Short.MAX_VALUE).addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel7, -2, 84, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel6, -2, 50, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel4, -2, 200, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel5, -2, 83, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton, -2, 25, -2).addComponent(this.okButton, -2, 26, -2)).addContainerGap()));
        this.getContentPane().add((java.awt.Component)this.mainPanel, "East");
        this.jPanel1.setPreferredSize(new Dimension(700, 30));
        this.jLabelTip.setHorizontalAlignment(0);
        this.jLabelTip.setPreferredSize(new Dimension(700, 20));
        this.jPanel1.add(this.jLabelTip);
        this.getContentPane().add((java.awt.Component)this.jPanel1, "Last");
        this.pack();
    }

    public void shapeChange() {
        if (this.shapeType == ShapeEnum.RoundRectangle) {
            if (this.jCheckBoxDC.isSelected()) {
                Color colorbk = new Color(106, 156, 77);
                this.colorPanel.setBackground(colorbk);
            }
            this.texturechoose.setEnabled(true);
            this.texturechoose.petList.setEnabled(true);
            this.jSpinnerRotationAngle.setEnabled(true);
            this.colorPanel.setEnabled(true);
        } else if (this.shapeType == ShapeEnum.Rectangle) {
            if (this.jCheckBoxDC.isSelected()) {
                Color colorbk = new Color(0, 107, 0);
                this.colorPanel.setBackground(colorbk);
            }
            this.texturechoose.setEnabled(true);
            this.texturechoose.petList.setEnabled(true);
            this.jSpinnerRotationAngle.setEnabled(true);
            this.colorPanel.setEnabled(true);
        } else if (this.shapeType == ShapeEnum.Circle) {
            if (this.jCheckBoxDC.isSelected()) {
                Color colorbk = new Color(239, 195, 38);
                this.colorPanel.setBackground(colorbk);
            }
            this.texturechoose.setEnabled(true);
            this.texturechoose.petList.setEnabled(true);
            this.jSpinnerRotationAngle.setEnabled(true);
            this.colorPanel.setEnabled(true);
        } else if (this.shapeType == ShapeEnum.Triangle) {
            if (this.jCheckBoxDC.isSelected()) {
                Color colorbk = new Color(46, 61, 208);
                this.colorPanel.setBackground(colorbk);
            }
            this.texturechoose.setEnabled(true);
            this.texturechoose.petList.setEnabled(true);
            this.jSpinnerRotationAngle.setEnabled(true);
            this.colorPanel.setEnabled(true);
        } else if (this.shapeType == ShapeEnum.Rhomboid) {
            if (this.jCheckBoxDC.isSelected()) {
                Color colorbk = new Color(188, 35, 157);
                this.colorPanel.setBackground(colorbk);
            }
            this.texturechoose.setEnabled(true);
            this.texturechoose.petList.setEnabled(true);
            this.jSpinnerRotationAngle.setEnabled(true);
            this.colorPanel.setEnabled(true);
        } else if (this.shapeType == ShapeEnum.Rhombus) {
            if (this.jCheckBoxDC.isSelected()) {
                Color colorbk = new Color(178, 141, 229);
                this.colorPanel.setBackground(colorbk);
            }
            this.texturechoose.setEnabled(true);
            this.texturechoose.petList.setEnabled(true);
            this.jSpinnerRotationAngle.setEnabled(true);
        } else if (this.shapeType == ShapeEnum.Pentagon) {
            if (this.jCheckBoxDC.isSelected()) {
                Color colorbk = new Color(188, 0, 0);
                this.colorPanel.setBackground(colorbk);
            }
            this.texturechoose.setEnabled(true);
            this.texturechoose.petList.setEnabled(true);
            this.jSpinnerRotationAngle.setEnabled(true);
            this.colorPanel.setEnabled(true);
        } else if (this.shapeType == ShapeEnum.Hexagon) {
            if (this.jCheckBoxDC.isSelected()) {
                Color colorbk = new Color(67, 137, 180);
                this.colorPanel.setBackground(colorbk);
            }
            this.texturechoose.setEnabled(true);
            this.texturechoose.petList.setEnabled(true);
            this.jSpinnerRotationAngle.setEnabled(true);
            this.colorPanel.setEnabled(true);
        } else if (this.shapeType == ShapeEnum.Octagon) {
            if (this.jCheckBoxDC.isSelected()) {
                Color colorbk = new Color(224, 64, 50);
                this.colorPanel.setBackground(colorbk);
            }
            this.texturechoose.setEnabled(true);
            this.texturechoose.petList.setEnabled(true);
            this.jSpinnerRotationAngle.setEnabled(true);
            this.colorPanel.setEnabled(true);
        } else if (this.shapeType == ShapeEnum.Trapezoid) {
            if (this.jCheckBoxDC.isSelected()) {
                Color colorbk = new Color(255, 51, 255);
                this.colorPanel.setBackground(colorbk);
            }
            this.texturechoose.setEnabled(true);
            this.texturechoose.petList.setEnabled(true);
            this.jSpinnerRotationAngle.setEnabled(true);
            this.colorPanel.setEnabled(true);
        } else if (this.shapeType == ShapeEnum.Arrow) {
            if (this.jCheckBoxDC.isSelected()) {
                Color colorbk = new Color(55, 80, 161);
                this.colorPanel.setBackground(colorbk);
            }
            this.texturechoose.setEnabled(true);
            this.texturechoose.petList.setEnabled(true);
            this.jSpinnerRotationAngle.setEnabled(true);
            this.colorPanel.setEnabled(true);
        } else if (this.shapeType == ShapeEnum.DovetailArrow) {
            if (this.jCheckBoxDC.isSelected()) {
                Color colorbk = new Color(138, 131, 191);
                this.colorPanel.setBackground(colorbk);
            }
        } else if (this.shapeType == ShapeEnum.Cylinder) {
            if (this.jCheckBoxDC.isSelected()) {
                Color colorbk = new Color(255, 51, 255);
                this.colorPanel.setBackground(colorbk);
            }
            this.texturechoose.setEnabled(true);
            this.texturechoose.petList.setEnabled(true);
            this.jSpinnerRotationAngle.setValue(0);
            this.jSpinnerRotationAngle.setEnabled(false);
            this.colorPanel.setEnabled(true);
        }
        this.previewDraw();
    }

    private void positionTextFieldFocusLost(FocusEvent evt) {
        this.previewDraw();
    }

    private void positionCheckBoxStateChanged(ChangeEvent evt) {
        this.previewDraw();
    }

    private void textTextFieldFocusLost(FocusEvent evt) {
        this.previewDraw();
    }

    private void colorTextMousePressed(MouseEvent evt) {
        final JColorChooser jColorChooser = new JColorChooser();
        jColorChooser.setColor(this.colorText.getBackground());
        Tools.WindowCenter(JColorChooser.createDialog(this, "Color Choose", true, jColorChooser, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color color = jColorChooser.getColor();
                SiteDialog.this.colorText.setBackground(color);
                SiteDialog.this.previewDraw();
            }
        }, null));
    }

    private void colorPanelMousePressed(MouseEvent evt) {
        final JColorChooser jColorChooser = new JColorChooser();
        jColorChooser.setColor(this.colorPanel.getBackground());
        Tools.WindowCenter(JColorChooser.createDialog(this, "Color Choose", true, jColorChooser, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color color = jColorChooser.getColor();
                SiteDialog.this.colorPanel.setBackground(color);
                SiteDialog.this.jCheckBoxDC.setSelected(false);
                SiteDialog.this.previewDraw();
            }
        }, null));
    }

    private void colorLineMousePressed(MouseEvent evt) {
        final JColorChooser jColorChooser = new JColorChooser();
        jColorChooser.setColor(this.colorLine.getBackground());
        Tools.WindowCenter(JColorChooser.createDialog(this, "Color Choose", true, jColorChooser, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color color = jColorChooser.getColor();
                SiteDialog.this.colorLine.setBackground(color);
                SiteDialog.this.previewDraw();
            }
        }, null));
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.bModify = true;
        boolean isSiteValiable = new Verifier().isPositions(this.positionTextField);
        boolean isDeltaXValiable = new Verifier().isInteger(this.deltaXTextField);
        boolean isDeltaYValiable = new Verifier().isInteger(this.deltaYTextField);
        boolean isFontSizeValiable = new Verifier().verify(this.fontTextField);
        boolean isWideValiable = new Verifier().verify(this.wideTextField);
        boolean isHighValiable = new Verifier().verify(this.highTextField);
        StringBuffer errorSb = new StringBuffer();
        String text = this.textTextField.getText();
        if (text.trim().equals("")) {
            text = "     ";
        }
        if (!isSiteValiable) {
            errorSb.append("Position : should be one or more positive integers delimited with semicolons \n");
        }
        if (!isDeltaXValiable) {
            errorSb.append("Delta X : should be a integer \n");
        }
        if (!isDeltaYValiable) {
            errorSb.append("Delta Y : should be a integer \n");
        }
        if (!isFontSizeValiable) {
            errorSb.append("Font Size : should be a positive integer \n");
        }
        if (!isWideValiable) {
            errorSb.append("Wide  : should be a positive integer \n");
        }
        if (!isHighValiable) {
            errorSb.append("High  : should be a positive integer \n");
        }
        if (isSiteValiable && isDeltaXValiable && isDeltaYValiable && isFontSizeValiable) {
            int iWide = 0;
            int iHigh = 0;
            if (this.comboBoxShape.SelectTextureFile.equals("00000_1.jpg")) {
                this.shapeType = ShapeEnum.Rectangle;
            } else {
                String strShape = this.comboBoxShape.SelectTextureFile;
                if (strShape.indexOf(".") > 0) {
                    strShape = strShape.substring(0, strShape.indexOf("."));
                }
                this.shapeType = ShapeEnum.valueOf(strShape);
            }
            if (this.comBoxGradient.SelectTextureFile.equals("00000_1.jpg")) {
                this.gradientType = GradientEnum.Null;
            } else {
                String strGradient = this.comBoxGradient.SelectTextureFile;
                if (strGradient.indexOf(".") > 0) {
                    strGradient = strGradient.substring(0, strGradient.indexOf("."));
                }
                this.gradientType = GradientEnum.valueOf(strGradient);
            }
            iWide = Integer.parseInt(this.wideTextField.getText().trim());
            iHigh = Integer.parseInt(this.highTextField.getText().trim());
            int iRotationAngle = (Integer)this.jSpinnerRotationAngle.getValue();
            int strokesize = (Integer)this.jSpinnerStrokeSize.getValue();
            String parameter = this.positionTextField.getText().trim() + this.DELIMIT + this.textTextField.getText() + this.DELIMIT + this.fontTextField.getText().trim() + this.DELIMIT + this.positionCheckBox.isSelected() + this.DELIMIT + strokesize + this.DELIMIT + this.gradientType.name().toString() + this.DELIMIT + this.texturechoose.SelectTextureFile;
            String positionStr = this.positionTextField.getText().trim();
            StringTokenizer st = new StringTokenizer(positionStr, ";");
            int siteCount = st.countTokens();
            LinkedList<Integer> siteList = new LinkedList<Integer>();
            for (int i = 0; i < siteCount; ++i) {
                siteList.add(Integer.parseInt(st.nextToken()));
            }
            int deltax = 0;
            deltax = Integer.parseInt(this.deltaXTextField.getText().trim());
            if (deltax == 0) {
                deltax = siteCount == 1 ? (Integer)siteList.get(0) : (Integer)siteList.get(0) + ((Integer)siteList.get(siteCount - 1) - (Integer)siteList.get(0)) / 2;
            }
            String fid = "";
            fid = this.jTextFieldID.getText();
            this.component = new Component(ComponentEnum.Site, deltax, Integer.parseInt(this.deltaYTextField.getText().trim()), parameter, this.colorText.getBackground(), this.shapeType, "site", iWide, iHigh, iRotationAngle, this.colorPanel.getBackground(), this.colorLine.getBackground(), this.jCheckBoxBorderDash.isSelected(), fid);
            this.component.setIsActive(true);
            this.component.setbSelected(true);
            this.dispose();
        } else {
            JOptionPane.showConfirmDialog(this, errorSb.toString(), "Properties Error", -1, 0, null);
        }
    }

    private void jCheckBoxDCActionPerformed(ActionEvent evt) {
        this.shapeChange();
    }

    private void jTextFieldIDKeyPressed(KeyEvent evt) {
    }

    private void jTextFieldIDFocusGained(FocusEvent evt) {
    }

    private void jTextFieldIDFocusLost(FocusEvent evt) {
    }
}

