/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.api.launcher;

import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.VariableEncoding;
import com.install4j.runtime.installer.helper.versionspecific.VersionSpecificHelper;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;

public class Variables {
    private static Map compilerVariables;
    private static Map installerVariables;
    private static String applicationId;

    private Variables() {
    }

    public static String getCompilerVariable(String string) throws IOException {
        if (compilerVariables == null) {
            InstallerConfig installerConfig = InstallerConfig.getConfigFromFile(InstallerUtil.getInstallerFile("i4jparams.conf"));
            if (installerConfig == null) {
                throw new IOException("Could not read config");
            }
            compilerVariables = installerConfig.getCompilerVariables();
        }
        return (String)compilerVariables.get(string);
    }

    public static Map getInstallerVariables() throws IOException {
        Variables.ensureInstallerVariablesRead();
        return installerVariables;
    }

    public static Object getInstallerVariable(String string) throws IOException {
        Variables.ensureInstallerVariablesRead();
        return installerVariables.get(string);
    }

    public static Map loadFromPreferenceStore(boolean bl) throws IOException {
        return Variables.loadFromPreferenceStore(Variables.getApplicationId(), bl);
    }

    public static Map loadFromPreferenceStore(String string, boolean bl) throws IOException {
        return VersionSpecificHelper.loadVariablesFromPreferenceStore(string, bl);
    }

    public static void saveToPreferenceStore(Map map, boolean bl) throws IOException {
        Variables.saveToPreferenceStore(map, Variables.getApplicationId(), bl);
    }

    public static void saveToPreferenceStore(Map map, String string, boolean bl) throws IOException {
        VersionSpecificHelper.saveVariablesToPreferenceStore(map, string, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void ensureInstallerVariablesRead() throws IOException {
        if (installerVariables == null) {
            InputStream inputStream = null;
            try {
                inputStream = new BufferedInputStream(new FileInputStream(InstallerUtil.getInstallerFile("response.varfile")));
                Properties properties = new Properties();
                properties.load(inputStream);
                installerVariables = VariableEncoding.decodeVariables(properties, true);
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        }
    }

    private static String getApplicationId() throws IOException {
        if (applicationId == null) {
            applicationId = InstallerConfig.getGeneralConfigFromFile(InstallerUtil.getInstallerFile("i4jparams.conf")).getApplicationId();
        }
        return applicationId;
    }
}

