/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.desktop;

import com.install4j.api.beans.ExternalFile;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.beans.actions.SystemInstallAction;
import com.install4j.runtime.installer.InstallerVariables;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.MenuHelper;
import com.install4j.runtime.installer.helper.fileinst.FileInstaller;
import com.install4j.runtime.installer.platform.unix.UnixFileSystem;
import com.install4j.runtime.installer.platform.win32.FolderInfo;
import java.io.File;
import java.io.IOException;

public class CreateDesktopLinkAction
extends SystemInstallAction {
    private File file;
    private String name = "";
    private boolean allUsers = true;
    private ExternalFile winIconFile;
    private String arguments = "";
    private String description = "";
    private boolean macSingleBundleTarget = true;

    public File getFile() {
        return CreateDesktopLinkAction.replaceVariables(this.file);
    }

    public void setFile(File file) {
        this.file = file;
    }

    public String getName() {
        return CreateDesktopLinkAction.replaceVariables(this.name);
    }

    public void setName(String string) {
        this.name = string;
    }

    public ExternalFile getWinIconFile() {
        return this.winIconFile;
    }

    public void setWinIconFile(ExternalFile externalFile) {
        this.winIconFile = externalFile;
    }

    public String getArguments() {
        return CreateDesktopLinkAction.replaceVariables(this.arguments);
    }

    public void setArguments(String string) {
        this.arguments = string;
    }

    public String getDescription() {
        return CreateDesktopLinkAction.replaceVariables(this.description);
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public boolean isMacSingleBundleTarget() {
        return this.macSingleBundleTarget;
    }

    public void setMacSingleBundleTarget(boolean bl) {
        this.macSingleBundleTarget = bl;
    }

    public boolean isAllUsers() {
        return this.allUsers;
    }

    public void setAllUsers(boolean bl) {
        this.allUsers = bl;
    }

    public boolean install(InstallerContext installerContext) throws UserCanceledException {
        if (InstallerUtil.isWindows()) {
            return this.installWindows(installerContext);
        }
        if (InstallerUtil.isMacOS()) {
            return this.installMacos(installerContext);
        }
        return this.installUnix(installerContext);
    }

    private boolean installUnix(InstallerContext installerContext) throws UserCanceledException {
        File file = new File(System.getProperty("user.home"), "Desktop");
        if (file.exists()) {
            try {
                if (MenuHelper.installUnixDesktopFile(installerContext.getInstallationDirectory(), file, installerContext.getDestinationFile(this.getFile()), this.getName(), null, this.getArguments()) == null) {
                    Logger.getInstance().log(this, "Destination file does not exist", false);
                    return false;
                }
                return true;
            }
            catch (IOException iOException) {
                Logger.getInstance().log(iOException);
                return false;
            }
        }
        Logger.getInstance().log(this, "Desktop directory " + file + " does not exist", false);
        return false;
    }

    private boolean installMacos(InstallerContext installerContext) {
        File file;
        InstallerConfig installerConfig = InstallerConfig.getCurrentInstance();
        if (installerConfig.getMacSpecificConfig().isSingleBundle() && this.isMacSingleBundleTarget()) {
            file = installerContext.getDestinationFile(installerConfig.getMacSpecificConfig().getSingleBundleName());
        } else if (this.getFile() != null && this.getFile().getPath().trim().length() > 0) {
            file = installerContext.getDestinationFile(this.getFile());
        } else {
            return false;
        }
        if (file != null && file.exists()) {
            File file2 = new File(new File(System.getProperty("user.home"), "Desktop"), this.getName());
            try {
                UnixFileSystem.createLink(file.getAbsolutePath(), file2);
            }
            catch (IOException iOException) {
                Logger.getInstance().log(iOException);
                return false;
            }
            FileInstaller.getInstance().registerUninstallFile(file2);
            return true;
        }
        Logger.getInstance().log(this, "Destination file does not exist", false);
        return false;
    }

    private boolean installWindows(InstallerContext installerContext) throws UserCanceledException {
        File file = installerContext.getDestinationFile(this.getFile());
        if (file != null) {
            if (!file.exists()) {
                file = installerContext.getDestinationFile(this.getFile() + ".exe");
            }
            if (file.exists()) {
                boolean bl = this.allUsers;
                Object object = InstallerVariables.getVariable("sys.programGroup.allUsers");
                if (object != null && object instanceof Boolean) {
                    bl = (Boolean)object;
                }
                File file2 = FolderInfo.getSpecialFolder(1, bl);
                try {
                    MenuHelper.installWindowsMenu(new File(file2, this.getName()), file, installerContext.getExternalFile(this.winIconFile, true), this.getArguments(), this.getDescription());
                    return true;
                }
                catch (IOException iOException) {
                    Logger.getInstance().log(iOException);
                    return false;
                }
            }
            Logger.getInstance().log(this, "Destination file does not exist", false);
            return false;
        }
        Logger.getInstance().log(this, "Destination file does not exist", false);
        return false;
    }
}

