/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.desktop;

import com.install4j.api.beans.ExternalFile;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.beans.actions.SystemInstallAction;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.MenuHelper;
import com.install4j.runtime.installer.platform.win32.FolderInfo;
import java.io.File;
import java.io.IOException;

public class CreateStartMenuEntryAction
extends SystemInstallAction {
    private boolean allUsers = true;
    private String entryName = "";
    private String arguments = "";
    private String categories = "Application";
    private File file;
    private ExternalFile icon;

    public boolean install(InstallerContext installerContext) throws UserCanceledException {
        try {
            if (this.entryName.indexOf("${installer:sys.programGroupDir}") > -1 && installerContext.getVariable("sys.programGroupDir") == null) {
                return true;
            }
            if (InstallerUtil.isWindows()) {
                String string = this.getEntryName();
                File file = new File(string);
                if (!file.isAbsolute()) {
                    file = new File(FolderInfo.getSpecialFolder(3, this.isAllUsers()), string);
                }
                MenuHelper.installWindowsMenu(file, installerContext.getDestinationFile(this.getFile()), installerContext.getExternalFile(this.getIcon(), true), this.getArguments(), null);
            } else if (!InstallerUtil.isMacOS()) {
                MenuHelper.installUnixMenu(installerContext.getInstallationDirectory(), installerContext.getDestinationFile(this.getFile()), this.getEntryName(), this.getCategories(), this.getArguments());
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
        return true;
    }

    public String getArguments() {
        return CreateStartMenuEntryAction.replaceVariables(this.arguments);
    }

    public void setArguments(String string) {
        this.arguments = string;
    }

    public String getCategories() {
        return CreateStartMenuEntryAction.replaceVariables(this.categories);
    }

    public void setCategories(String string) {
        this.categories = string;
    }

    public String getEntryName() {
        return CreateStartMenuEntryAction.replaceVariables(this.entryName);
    }

    public void setEntryName(String string) {
        this.entryName = string;
    }

    public File getFile() {
        return CreateStartMenuEntryAction.replaceVariables(this.file);
    }

    public void setFile(File file) {
        this.file = file;
    }

    public ExternalFile getIcon() {
        return this.icon;
    }

    public void setIcon(ExternalFile externalFile) {
        this.icon = externalFile;
    }

    public boolean isAllUsers() {
        return this.allUsers;
    }

    public void setAllUsers(boolean bl) {
        this.allUsers = bl;
    }
}

