/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.files;

import com.install4j.api.context.Context;
import com.install4j.api.context.FileOptions;
import com.install4j.api.context.OverwriteMode;
import com.install4j.api.context.UninstallMode;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.events.InstallerEventListener;
import com.install4j.runtime.beans.actions.InstallFilesAction;
import com.install4j.runtime.beans.actions.SystemInstallOrUninstallAction;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.fileinst.FileInstaller;
import com.install4j.runtime.installer.platform.unix.UnixFileSystem;
import java.io.File;
import java.io.IOException;

public class CopyFileAction
extends SystemInstallOrUninstallAction {
    private File sourceFile;
    private File destinationFile;
    private OverwriteMode overwriteMode = OverwriteMode.ALWAYS_ASK_EXCEPT_FOR_UPDATE;
    private String mode = "644";
    private String directoryMode = "755";
    private boolean shared = false;
    private UninstallMode uninstallMode = UninstallMode.IF_CREATED;
    private boolean delay = false;
    private boolean triggerReboot = true;
    private transient boolean success = true;

    public boolean isDelay() {
        return this.delay;
    }

    public void setDelay(boolean bl) {
        this.delay = bl;
    }

    public boolean isTriggerReboot() {
        return this.triggerReboot;
    }

    public void setTriggerReboot(boolean bl) {
        this.triggerReboot = bl;
    }

    public File getSourceFile() {
        return CopyFileAction.replaceVariables(this.sourceFile);
    }

    public void setSourceFile(File file) {
        this.sourceFile = file;
    }

    public String getDirectoryMode() {
        return this.directoryMode;
    }

    public void setDirectoryMode(String string) {
        this.directoryMode = string;
    }

    public File getDestinationFile() {
        return CopyFileAction.replaceVariables(this.destinationFile);
    }

    public void setDestinationFile(File file) {
        this.destinationFile = file;
    }

    public OverwriteMode getOverwriteMode() {
        return this.overwriteMode;
    }

    public void setOverwriteMode(OverwriteMode overwriteMode) {
        this.overwriteMode = overwriteMode;
    }

    public UninstallMode getUninstallMode() {
        return this.uninstallMode;
    }

    public void setUninstallMode(UninstallMode uninstallMode) {
        this.uninstallMode = uninstallMode;
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String string) {
        this.mode = string;
    }

    public boolean isShared() {
        return this.shared;
    }

    public void setShared(boolean bl) {
        this.shared = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(Context context) throws UserCanceledException {
        File file = context.getDestinationFile(this.getSourceFile());
        if (!file.exists()) {
            return false;
        }
        File file2 = context.getDestinationFile(this.getDestinationFile());
        InstallerEventListener installerEventListener = null;
        if (this.isTriggerReboot() && this.isDelay()) {
            installerEventListener = InstallFilesAction.addRebootTriggerListener(context);
        }
        try {
            if (file.isFile() && file2.isDirectory()) {
                file2 = new File(file2, file.getName());
            }
            this.copyFile(file, file2, context);
        }
        finally {
            if (installerEventListener != null) {
                context.removeInstallerEventListener(installerEventListener);
            }
        }
        return this.success;
    }

    private void copyFile(File file, File file2, Context context) throws UserCanceledException {
        FileInstaller fileInstaller = FileInstaller.getInstance();
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            if (fileArray != null) {
                for (int i = 0; i < fileArray.length; ++i) {
                    if (context.isCancelling()) {
                        throw new UserCanceledException();
                    }
                    File file3 = fileArray[i];
                    File file4 = new File(file2, file3.getName());
                    if (file3.isDirectory()) {
                        try {
                            fileInstaller.createDirectory(file4, this.getUninstallMode());
                            file4.setLastModified(file3.lastModified());
                            if (!InstallerUtil.isWindows()) {
                                UnixFileSystem.setMode(this.getDirectoryMode(), file4);
                            }
                        }
                        catch (IOException iOException) {
                            this.success = false;
                            return;
                        }
                    }
                    this.copyFile(file3, file4, context);
                }
            }
        } else if (!fileInstaller.install(file, file2, new FileOptions(file.lastModified(), this.getMode(), this.getOverwriteMode(), this.isShared(), this.isDelay(), this.getUninstallMode()))) {
            this.success = false;
        }
    }
}

