/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.files;

import com.install4j.api.context.Context;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.beans.actions.SystemInstallOrUninstallAction;
import java.io.File;
import java.util.Date;

public class SetFiletimeAction
extends SystemInstallOrUninstallAction {
    private File file;
    private Date time = new Date();
    private long previousTime = -1L;

    public boolean execute(Context context) throws UserCanceledException {
        if (this.getFile() == null) {
            return false;
        }
        File file = context.getDestinationFile(this.getFile());
        if (!file.exists()) {
            return false;
        }
        if (this.previousTime == -1L) {
            this.previousTime = file.lastModified();
        }
        file.setLastModified(this.getTime().getTime());
        return true;
    }

    public void rollback(InstallerContext installerContext) {
        if (this.previousTime == -1L) {
            return;
        }
        if (this.getFile() == null) {
            return;
        }
        File file = installerContext.getDestinationFile(this.getFile());
        if (!file.exists()) {
            return;
        }
        file.setLastModified(this.previousTime);
    }

    public File getFile() {
        return SetFiletimeAction.replaceVariables(this.file);
    }

    public void setFile(File file) {
        this.file = file;
    }

    public Date getTime() {
        return this.time;
    }

    public void setTime(Date date) {
        this.time = date;
    }
}

