/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.files;

import com.install4j.api.Util;
import com.install4j.api.actions.AbstractInstallAction;
import com.install4j.api.context.Context;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.unix.UnixFileSystem;
import com.install4j.runtime.beans.actions.SystemInstallOrUninstallAction;
import com.install4j.runtime.installer.helper.InstallerUtil;
import java.io.File;

public class SetOwnerAction
extends SystemInstallOrUninstallAction {
    private String owner;
    private File file;
    private boolean recursive;

    public String getOwner() {
        return SetOwnerAction.replaceVariables(this.owner);
    }

    public void setOwner(String string) {
        this.owner = string;
    }

    public File getFile() {
        return SetOwnerAction.replaceVariables(this.file);
    }

    public void setFile(File file) {
        this.file = file;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public void setRecursive(boolean bl) {
        this.recursive = bl;
    }

    public boolean execute(Context context) throws UserCanceledException {
        if (InstallerUtil.isWindows()) {
            return true;
        }
        File file = context.getDestinationFile(this.getFile());
        if (file == null || !file.exists()) {
            return false;
        }
        String string = this.getOwner();
        if (string == null || string.trim().length() == 0) {
            return false;
        }
        return this.setForFile(file, string);
    }

    private boolean setForFile(File file, String string) {
        UnixFileSystem.FileInformation fileInformation = UnixFileSystem.getFileInformation(file);
        if (fileInformation != null && fileInformation.getMode() > -1) {
            this.addRollbackAction(new PerformedAction(fileInformation.getOwnerInfo(), file));
        }
        Util.logInfo(this, "Setting owner for " + file.getAbsolutePath());
        boolean bl = UnixFileSystem.setOwner(string, file);
        if (this.isRecursive() && file.isDirectory() && (fileInformation == null || !fileInformation.isLink())) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                if (this.setForFile(fileArray[i], string)) continue;
                bl = false;
            }
        }
        return bl;
    }

    private static class PerformedAction
    extends AbstractInstallAction {
        private String oldOwner;
        private File file;

        public PerformedAction(String string, File file) {
            this.oldOwner = string;
            this.file = file;
        }

        public boolean install(InstallerContext installerContext) throws UserCanceledException {
            throw new UnsupportedOperationException();
        }

        public void rollback(InstallerContext installerContext) {
            UnixFileSystem.setOwner(this.oldOwner, this.file);
        }
    }
}

