/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.misc;

import com.install4j.api.Util;
import com.install4j.api.actions.InstallAction;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.LauncherSetup;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.beans.actions.SystemInstallAction;
import com.install4j.runtime.beans.actions.files.BackupFileForRollbackAction;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.config.MacSpecificConfig;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.fileinst.FileInstaller;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public abstract class AbstractModifyVmOptionsAction
extends SystemInstallAction {
    private String launcherId = "";
    private static final String[] REPLACE_OPTION_PREFIXES = new String[]{"-Xmx", "-Xms", "-Xss", "-Xloggc:", "-Xbootclasspath:", "-Xbootclasspath/a:", "-Xbootclasspath/p:", "-verbose:", "-ea:", "-da:", "-enableassertions:", "-disableassertions:", "-agentlib:", "-agentpath:", "-javaagent:", "-splash:", "-classpath ", "-classpath/a ", "-classpath/p "};

    protected abstract String[] getAddVmOptions();

    public String getLauncherId() {
        return this.launcherId;
    }

    public void setLauncherId(String string) {
        this.launcherId = string;
    }

    public boolean install(InstallerContext installerContext) throws UserCanceledException {
        File file = null;
        LauncherSetup launcherSetup = installerContext.getLauncherById(this.launcherId);
        if (launcherSetup != null) {
            MacSpecificConfig macSpecificConfig = InstallerConfig.getCurrentInstance().getMacSpecificConfig();
            file = Util.isMacosInstaller() && macSpecificConfig.isSingleBundle() ? installerContext.getDestinationFile(macSpecificConfig.getSingleBundleName()) : installerContext.getDestinationFile(launcherSetup.getRelativeFileName());
        }
        if (file == null || !file.exists()) {
            Logger.getInstance().error(this, "launcher file " + file + " does not exist.");
            return false;
        }
        try {
            if (file.isDirectory()) {
                return this.modifyInfoPlist(file, installerContext);
            }
            return this.modifyVmOptions(file, installerContext);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            Logger.getInstance().log(iOException);
            return false;
        }
    }

    private boolean modifyVmOptions(File file, InstallerContext installerContext) throws IOException, UserCanceledException {
        Object object;
        File file2;
        String string = file.getAbsolutePath();
        if (string.endsWith(".exe")) {
            string = string.substring(0, string.length() - 4);
        }
        if (!(file2 = new File(string = string + ".vmoptions")).exists()) {
            FileInstaller.getInstance().registerUninstallFile(file2);
        } else {
            object = new BackupFileForRollbackAction(file2, false);
            ((BackupFileForRollbackAction)object).install(installerContext);
            this.addRollbackAction((InstallAction)object);
        }
        object = AbstractModifyVmOptionsAction.readVmOptions(string);
        List list = AbstractModifyVmOptionsAction.addVmOptions((List)object, new ArrayList<String>(Arrays.asList(this.getAddVmOptions())));
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(string));
        for (int i = 0; i < list.size(); ++i) {
            printWriter.println(list.get(i));
        }
        printWriter.close();
        return true;
    }

    private static List addVmOptions(List list, List list2) {
        int n;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (n = 0; n < list.size(); ++n) {
            String string = ((String)list.get(n)).trim();
            list2.remove(string);
            if (string.startsWith("-D")) {
                string = AbstractModifyVmOptionsAction.findReplaceOption(list2, AbstractModifyVmOptionsAction.getParameterPrefix(string), string);
            } else {
                for (int i = 0; i < REPLACE_OPTION_PREFIXES.length; ++i) {
                    String string2 = REPLACE_OPTION_PREFIXES[i];
                    if (!string.startsWith(string2)) continue;
                    string = AbstractModifyVmOptionsAction.findReplaceOption(list2, string2, string);
                }
            }
            arrayList.add(string);
        }
        for (n = 0; n < list2.size(); ++n) {
            arrayList.add((String)list2.get(n));
        }
        return arrayList;
    }

    private static String getParameterPrefix(String string) {
        int n = string.indexOf(61);
        if (n > -1) {
            return string.substring(0, n + 1);
        }
        return string;
    }

    private static String findReplaceOption(List list, String string, String string2) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            if (!string3.trim().startsWith(string)) continue;
            iterator.remove();
            return string3;
        }
        return string2;
    }

    private static List readVmOptions(String string) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (new File(string).exists()) {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            String string2 = bufferedReader.readLine();
            while (string2 != null) {
                arrayList.add(string2);
                string2 = bufferedReader.readLine();
            }
            bufferedReader.close();
        }
        return arrayList;
    }

    private boolean modifyInfoPlist(File file, InstallerContext installerContext) throws IOException, UserCanceledException {
        File file2 = new File(file, "/Contents/Info.plist");
        if (!file2.exists()) {
            Logger.getInstance().error(this, "Info.plist file " + file2 + " does not exist.");
            return false;
        }
        BackupFileForRollbackAction backupFileForRollbackAction = new BackupFileForRollbackAction(file2, false);
        backupFileForRollbackAction.install(installerContext);
        this.addRollbackAction(backupFileForRollbackAction);
        SplitupVMOptions splitupVMOptions = AbstractModifyVmOptionsAction.splitupVMOptions(this.getAddVmOptions());
        File file3 = new File(file2.getAbsolutePath() + ".temp");
        file3.delete();
        file2.renameTo(file3);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file3), "UTF-8"));
        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file2), "UTF-8"));
        String string = bufferedReader.readLine();
        while (string != null) {
            int n = string.indexOf("</string><!-- I4J_INSERT_VMOPTIONS -->");
            int n2 = string.indexOf("</string><!-- I4J_INSERT_CLASSPATH -->");
            if (n > -1) {
                printWriter.print(string.substring(0, n));
                if (string.charAt(n - 1) == '>') {
                    printWriter.print(" ");
                }
                printWriter.print(splitupVMOptions.rest);
                printWriter.println(string.substring(n));
            } else if (n2 > -1) {
                this.addClasspath(printWriter, string, n2, splitupVMOptions);
            } else if (string.indexOf("<!-- I4J_INSERT_PROPERTIES -->") > -1) {
                Iterator<Map.Entry<Object, Object>> iterator = splitupVMOptions.vmProperties.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<Object, Object> entry = iterator.next();
                    printWriter.println("<key>" + entry.getKey() + "</key>");
                    printWriter.println("<string>" + entry.getValue() + "</string>");
                }
                printWriter.println(string);
            } else {
                printWriter.println(string);
            }
            string = bufferedReader.readLine();
        }
        printWriter.close();
        bufferedReader.close();
        file3.delete();
        return true;
    }

    private void addClasspath(PrintWriter printWriter, String string, int n, SplitupVMOptions splitupVMOptions) throws IOException {
        int n2 = string.indexOf(".install4j/i4jruntime.jar");
        if (n2 == -1) {
            throw new IOException("could not find i4jruntime.jar in Info.plist file");
        }
        String string2 = string.substring(n2 += ".install4j/i4jruntime.jar".length(), n);
        if (string2.startsWith(File.pathSeparator)) {
            string2 = string2.substring(1);
        }
        String string3 = "";
        if (splitupVMOptions.classpathPrepend != null && splitupVMOptions.classpathPrepend.length() > 0) {
            if (!string3.endsWith(File.pathSeparator) && string3.length() > 0) {
                string3 = string3 + File.pathSeparator;
            }
            string3 = string3 + splitupVMOptions.classpathPrepend;
        }
        if (splitupVMOptions.classpath != null && splitupVMOptions.classpath.length() > 0) {
            if (!string3.endsWith(File.pathSeparator) && string3.length() > 0) {
                string3 = string3 + File.pathSeparator;
            }
            string3 = string3 + splitupVMOptions.classpath;
        } else if (string2.length() > 0) {
            if (!string3.endsWith(File.pathSeparator) && string3.length() > 0) {
                string3 = string3 + File.pathSeparator;
            }
            string3 = string3 + string2;
        }
        if (splitupVMOptions.classpathAppend != null && splitupVMOptions.classpathAppend.length() > 0) {
            if (!string3.endsWith(File.pathSeparator) && string3.length() > 0) {
                string3 = string3 + File.pathSeparator;
            }
            string3 = string3 + splitupVMOptions.classpathAppend;
        }
        printWriter.print(string.substring(0, n2));
        if (string3.length() > 0) {
            printWriter.print(File.pathSeparator);
        }
        printWriter.print(string3);
        printWriter.println(string.substring(n));
    }

    private static SplitupVMOptions splitupVMOptions(String[] stringArray) {
        SplitupVMOptions splitupVMOptions = new SplitupVMOptions();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            int n = string.indexOf(61);
            if (string.startsWith("-D") && n > -1 && string.length() > n + 1) {
                String string2 = string.substring(2, n);
                String string3 = string.substring(n + 1);
                splitupVMOptions.vmProperties.setProperty(string2, string3);
                continue;
            }
            if (string.startsWith("-classpath ")) {
                splitupVMOptions.classpath = AbstractModifyVmOptionsAction.fixPath(string.substring("-classpath ".length()));
                continue;
            }
            if (string.startsWith("-classpath/a ")) {
                splitupVMOptions.classpathAppend = AbstractModifyVmOptionsAction.fixPath(string.substring("-classpath/a ".length()));
                continue;
            }
            if (string.startsWith("-classpath/p ")) {
                splitupVMOptions.classpathPrepend = AbstractModifyVmOptionsAction.fixPath(string.substring("-classpath/p ".length()));
                continue;
            }
            if (splitupVMOptions.rest.length() > 0) {
                splitupVMOptions.rest = splitupVMOptions.rest + " ";
            }
            splitupVMOptions.rest = splitupVMOptions.rest + string;
        }
        return splitupVMOptions;
    }

    private static String fixPath(String string) {
        return string.replace('\\', File.separatorChar).replace('/', File.separatorChar).replace(':', File.pathSeparatorChar).replace(';', File.pathSeparatorChar);
    }

    private static class SplitupVMOptions {
        Properties vmProperties = new Properties();
        String classpath;
        String classpathAppend;
        String classpathPrepend;
        String rest = "";

        private SplitupVMOptions() {
        }
    }
}

