/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.registry;

import com.install4j.api.actions.AbstractInstallAction;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.beans.actions.registry.PreferenceDeleteType;
import com.install4j.runtime.beans.actions.registry.PreferencesAction;
import com.install4j.runtime.installer.helper.Logger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.prefs.BackingStoreException;
import java.util.prefs.InvalidPreferencesFormatException;
import java.util.prefs.Preferences;

public abstract class PreferencesDeleteAction
extends PreferencesAction {
    private PreferenceDeleteType preferenceDeleteType = PreferenceDeleteType.USER;

    public PreferenceDeleteType getPreferenceDeleteType() {
        return this.preferenceDeleteType;
    }

    public void setPreferenceDeleteType(PreferenceDeleteType preferenceDeleteType) {
        this.preferenceDeleteType = preferenceDeleteType;
    }

    protected boolean executePreferencesDeleter(PreferencesDeleter preferencesDeleter) {
        boolean bl = false;
        if (this.preferenceDeleteType == PreferenceDeleteType.SYSTEM || this.preferenceDeleteType == PreferenceDeleteType.SYSTEM_AND_USER) {
            bl |= this.executePreferenceDeleter(preferencesDeleter, false);
        }
        if (this.preferenceDeleteType == PreferenceDeleteType.USER || this.preferenceDeleteType == PreferenceDeleteType.SYSTEM_AND_USER) {
            bl |= this.executePreferenceDeleter(preferencesDeleter, true);
        }
        return bl;
    }

    private boolean executePreferenceDeleter(PreferencesDeleter preferencesDeleter, boolean bl) {
        try {
            Preferences preferences = this.getPackageNodeNoCreation(bl);
            if (preferences != null) {
                boolean bl2 = preferencesDeleter.deleteFromPreferences(preferences);
                preferences.flush();
                return bl2;
            }
            Logger.getInstance().log(this, "Package " + this.getPackageName() + " does not exist", false);
        }
        catch (Exception exception) {
            Logger.getInstance().log(exception);
        }
        return false;
    }

    protected void deleteNode(Preferences preferences) throws BackingStoreException {
        PerformedAction performedAction = new PerformedAction(preferences);
        preferences.removeNode();
        this.addRollbackAction(performedAction);
    }

    protected boolean deleteKey(Preferences preferences, String string) throws BackingStoreException {
        String[] stringArray = preferences.keys();
        if (stringArray == null || !Arrays.asList(stringArray).contains(string)) {
            Logger.getInstance().log(this, "Key " + string + " does not exist", false);
            return false;
        }
        PerformedAction performedAction = new PerformedAction(preferences, string);
        preferences.remove(string);
        this.addRollbackAction(performedAction);
        return true;
    }

    private static class PerformedAction
    extends AbstractInstallAction {
        private Preferences packageNode;
        private String key;
        private String oldValue;
        private byte[] exportedTree;

        public PerformedAction(Preferences preferences, String string) {
            this.packageNode = preferences;
            this.key = string;
            this.oldValue = preferences.get(string, null);
        }

        public PerformedAction(Preferences preferences) throws BackingStoreException {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                preferences.exportSubtree(byteArrayOutputStream);
                this.exportedTree = byteArrayOutputStream.toByteArray();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }

        public void rollback(InstallerContext installerContext) {
            if (this.packageNode != null && this.oldValue != null) {
                Preferences preferences = PreferencesAction.getPackageNode(this.packageNode.isUserNode(), this.packageNode.absolutePath());
                preferences.put(this.key, this.oldValue);
                try {
                    preferences.flush();
                }
                catch (BackingStoreException backingStoreException) {
                    Logger.getInstance().log(backingStoreException);
                }
            }
            if (this.exportedTree != null) {
                try {
                    Preferences.importPreferences(new ByteArrayInputStream(this.exportedTree));
                }
                catch (IOException iOException) {
                    Logger.getInstance().log(iOException);
                }
                catch (InvalidPreferencesFormatException invalidPreferencesFormatException) {
                    Logger.getInstance().log(invalidPreferencesFormatException);
                }
            }
        }

        public boolean install(InstallerContext installerContext) throws UserCanceledException {
            throw new UnsupportedOperationException();
        }
    }

    protected static interface PreferencesDeleter {
        public boolean deleteFromPreferences(Preferences var1) throws BackingStoreException;
    }
}

