/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.registry;

import com.install4j.api.actions.AbstractInstallAction;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.beans.actions.registry.PreferenceWriteType;
import com.install4j.runtime.beans.actions.registry.PreferencesAction;
import com.install4j.runtime.installer.helper.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

public abstract class PreferencesWriteAction
extends PreferencesAction {
    private PreferenceWriteType preferenceWriteType = PreferenceWriteType.USER;

    public PreferenceWriteType getPreferenceWriteType() {
        return this.preferenceWriteType;
    }

    public void setPreferenceWriteType(PreferenceWriteType preferenceWriteType) {
        this.preferenceWriteType = preferenceWriteType;
    }

    protected void writeValue(Preferences preferences, String string, String string2) {
        String string3 = preferences.get(string, null);
        preferences.put(string, string2);
        this.addRollbackAction(new PerformedAction(preferences, string, string3));
    }

    protected boolean executePreferencesWriter(PreferencesWriter preferencesWriter) {
        Preferences preferences = this.getPackageNode(this.preferenceWriteType == PreferenceWriteType.USER);
        boolean bl = false;
        try {
            bl = preferencesWriter.writeToPreferences(preferences);
            preferences.flush();
        }
        catch (BackingStoreException backingStoreException) {
            Logger.getInstance().log(backingStoreException);
            if (this.preferenceWriteType == PreferenceWriteType.SYSTEM_FALLBACK) {
                preferences = this.getPackageNode(true);
                try {
                    bl = preferencesWriter.writeToPreferences(preferences);
                    preferences.flush();
                }
                catch (BackingStoreException backingStoreException2) {
                    Logger.getInstance().log(backingStoreException2);
                    return false;
                }
            }
            return false;
        }
        return bl;
    }

    private static class PerformedAction
    extends AbstractInstallAction {
        private Preferences packageNode;
        private String key;
        private String oldValue;

        public PerformedAction(Preferences preferences, String string, String string2) {
            this.packageNode = preferences;
            this.key = string;
            this.oldValue = string2;
        }

        public void rollback(InstallerContext installerContext) {
            Preferences preferences = PreferencesAction.getPackageNode(this.packageNode.isUserNode(), this.packageNode.absolutePath());
            if (this.oldValue == null) {
                preferences.remove(this.key);
            } else {
                preferences.put(this.key, this.oldValue);
                Logger.getInstance().info(this, "put '" + this.oldValue + "' in '" + this.key + "'.");
            }
            try {
                preferences.flush();
                Logger.getInstance().info(this, "flushed " + preferences.absolutePath());
            }
            catch (BackingStoreException backingStoreException) {
                Logger.getInstance().log(backingStoreException);
            }
        }

        public boolean install(InstallerContext installerContext) throws UserCanceledException {
            throw new UnsupportedOperationException();
        }
    }

    protected static interface PreferencesWriter {
        public boolean writeToPreferences(Preferences var1) throws BackingStoreException;
    }
}

