/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.xml;

import com.install4j.api.beans.PropertyLoggingInterceptor;
import com.install4j.api.beans.ReplacementMode;
import com.install4j.api.context.Context;
import com.install4j.runtime.beans.actions.xml.AbstractModifyXmlFileAction;
import com.install4j.runtime.beans.actions.xml.ApacheXPathNodeListProvider;
import com.install4j.runtime.beans.actions.xml.NodeListProvider;
import com.install4j.runtime.installer.helper.Logger;
import java.io.File;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XPathReplaceAction
extends AbstractModifyXmlFileAction
implements PropertyLoggingInterceptor {
    private String xpathExpression;
    private String regex = ".*";
    private String replacement;
    private boolean replaceAll = false;
    private boolean quoteVariables = true;
    private boolean logReplacement = true;

    public String getXpathExpression() {
        return XPathReplaceAction.replaceVariables(this.xpathExpression);
    }

    public void setXpathExpression(String string) {
        this.xpathExpression = string;
    }

    public String getRegex() {
        return XPathReplaceAction.replaceVariables(this.regex, this.quoteVariables ? ReplacementMode.REGEXP_MATCH : ReplacementMode.PLAIN);
    }

    public void setRegex(String string) {
        this.regex = string;
    }

    public String getReplacement() {
        return XPathReplaceAction.replaceVariables(this.replacement, this.quoteVariables ? ReplacementMode.REGEXP_REPLACEMENT : ReplacementMode.PLAIN);
    }

    public void setReplacement(String string) {
        this.replacement = string;
    }

    public boolean isReplaceAll() {
        return this.replaceAll;
    }

    public void setReplaceAll(boolean bl) {
        this.replaceAll = bl;
    }

    public boolean isQuoteVariables() {
        return this.quoteVariables;
    }

    public void setQuoteVariables(boolean bl) {
        this.quoteVariables = bl;
    }

    public boolean isLogReplacement() {
        return this.logReplacement;
    }

    public void setLogReplacement(boolean bl) {
        this.logReplacement = bl;
    }

    public Object getLogValueForProperty(String string, Object object) {
        return this.maybeFilterLogReplacement(string, "replacement", object, this.logReplacement);
    }

    protected boolean modifyFile(File file, Context context) throws IOException {
        try {
            Document document = this.parseFile(file);
            NodeListProvider nodeListProvider = this.getNodeListProvider();
            if (nodeListProvider == null) {
                return false;
            }
            NodeList nodeList = nodeListProvider.getNodeList(document, this.getXpathExpression());
            if (nodeList == null) {
                return false;
            }
            if (nodeList.getLength() == 0) {
                Logger.getInstance().log(this, "No nodes found for XPath " + this.getXpathExpression(), false);
                return false;
            }
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                String string = node.getNodeValue();
                if (string == null) {
                    return false;
                }
                string = this.isReplaceAll() ? string.replaceAll(this.getRegex(), this.getReplacement()) : string.replaceFirst(this.getRegex(), this.getReplacement());
                node.setNodeValue(string);
            }
            this.writeFile(file, document);
            return true;
        }
        catch (SAXException sAXException) {
            Logger.getInstance().log(sAXException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            Logger.getInstance().log(parserConfigurationException);
        }
        catch (TransformerException transformerException) {
            Logger.getInstance().log(transformerException);
        }
        return false;
    }

    private NodeListProvider getNodeListProvider() {
        if (System.getProperty("java.version").startsWith("1.4")) {
            try {
                return new ApacheXPathNodeListProvider();
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                Logger.getInstance().log(noClassDefFoundError);
                return null;
            }
        }
        try {
            return (NodeListProvider)Class.forName("com.install4j.runtime.beans.actions.xml.JaxpXPathNodeListProvider").newInstance();
        }
        catch (InstantiationException instantiationException) {
            Logger.getInstance().log(instantiationException);
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            Logger.getInstance().log(illegalAccessException);
            return null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            Logger.getInstance().log(classNotFoundException);
            return null;
        }
    }
}

