/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.screens;

import com.install4j.api.beans.ScriptProperty;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.screens.Console;
import com.install4j.runtime.beans.screens.DescriptionScreen;
import com.install4j.runtime.beans.screens.components.InstallationDirectorySelector;
import com.install4j.runtime.beans.screens.installationcomponents.InstallationComponentTree;
import com.install4j.runtime.installer.config.ComponentConfig;
import com.install4j.runtime.installer.config.ComponentFolderConfig;
import com.install4j.runtime.installer.config.ComponentNodeConfig;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.helper.InstallerUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class ComponentsScreen
extends DescriptionScreen {
    private boolean showInstallationDirectoryChooser = false;
    private InstallationDirectorySelector installationDirectorySelector;
    private InstallationComponentTree tree;
    private JScrollPane scpTree;
    private String defaultConsoleSelection;
    private Map indexToComponentNodeConfig = new HashMap();
    private Set mandatoryComponents = new HashSet();

    public ComponentsScreen() {
        this.installationDirectorySelector = new InstallationDirectorySelector(this);
        this.installationDirectorySelector.setCompact(true);
        this.setBoldDescription(true);
    }

    public boolean isShowInstallationDirectoryChooser() {
        return this.showInstallationDirectoryChooser;
    }

    public void setShowInstallationDirectoryChooser(boolean bl) {
        this.showInstallationDirectoryChooser = bl;
    }

    public boolean isShowRequiredDiskSpace() {
        return this.installationDirectorySelector.isShowRequiredDiskSpace();
    }

    public void setShowRequiredDiskSpace(boolean bl) {
        this.installationDirectorySelector.setShowRequiredDiskSpace(bl);
    }

    public boolean isShowFreeDiskSpace() {
        return this.installationDirectorySelector.isShowFreeDiskSpace();
    }

    public void setShowFreeDiskSpace(boolean bl) {
        this.installationDirectorySelector.setShowFreeDiskSpace(bl);
    }

    public boolean isCheckFreeSpace() {
        return this.installationDirectorySelector.isCheckFreeSpace();
    }

    public void setCheckFreeSpace(boolean bl) {
        this.installationDirectorySelector.setCheckFreeSpace(bl);
    }

    public boolean isSuggestAppDir() {
        return this.installationDirectorySelector.isSuggestAppDir();
    }

    public void setSuggestAppDir(boolean bl) {
        this.installationDirectorySelector.setSuggestAppDir(bl);
    }

    public boolean isExistingDirWarning() {
        return this.installationDirectorySelector.isExistingDirWarning();
    }

    public void setExistingDirWarning(boolean bl) {
        this.installationDirectorySelector.setExistingDirWarning(bl);
    }

    public boolean isValidateApplicationId() {
        return this.installationDirectorySelector.isValidateApplicationId();
    }

    public void setValidateApplicationId(boolean bl) {
        this.installationDirectorySelector.setValidateApplicationId(bl);
    }

    public boolean isAllowSpacesOnUnix() {
        return this.installationDirectorySelector.isAllowSpacesOnUnix();
    }

    public void setAllowSpacesOnUnix(boolean bl) {
        this.installationDirectorySelector.setAllowSpacesOnUnix(bl);
    }

    public boolean isAllowNewFolderCreation() {
        return this.installationDirectorySelector.isAllowNewFolderCreation();
    }

    public void setAllowNewFolderCreation(boolean bl) {
        this.installationDirectorySelector.setAllowNewFolderCreation(bl);
    }

    public boolean isManualEntryAllowed() {
        return this.installationDirectorySelector.isManualEntryAllowed();
    }

    public void setManualEntryAllowed(boolean bl) {
        this.installationDirectorySelector.setManualEntryAllowed(bl);
    }

    public ScriptProperty getValidationScript() {
        return this.installationDirectorySelector.getValidationScript();
    }

    public void setValidationScript(ScriptProperty scriptProperty) {
        this.installationDirectorySelector.setValidationScript(scriptProperty);
    }

    public void setInstallerContext(InstallerContext installerContext) {
        super.setInstallerContext(installerContext);
        if (this.showInstallationDirectoryChooser) {
            this.installationDirectorySelector.setContext(installerContext);
        }
    }

    public boolean isHidden() {
        return InstallerConfig.getCurrentInstance().getComponents().size() == 0 || this.getContext().getBooleanVariable("sys.preventComponentCustomization");
    }

    public String getTitle() {
        return this.getMessage("WizardSelectComponents");
    }

    public String getSubTitle() {
        return this.getMessage("SelectComponentsDesc");
    }

    public void willActivate() {
        super.willActivate();
        if (this.showInstallationDirectoryChooser) {
            this.installationDirectorySelector.update();
        }
    }

    public void activated() {
        super.activated();
        this.tree.updateAllNodes();
        this.tree.checkFolders();
    }

    protected boolean checkCompleted() {
        return super.checkCompleted() && (!this.showInstallationDirectoryChooser || this.installationDirectorySelector.checkCompleted());
    }

    public boolean handleUnattended() {
        return !this.showInstallationDirectoryChooser || this.installationDirectorySelector.handleUnattended();
    }

    public boolean handleConsole(Console console) throws UserCanceledException {
        if (!super.handleConsole(console)) {
            return false;
        }
        if (this.showInstallationDirectoryChooser && !this.installationDirectorySelector.handleConsole(console)) {
            return false;
        }
        this.defaultConsoleSelection = null;
        console.println(this.getMessage("SelectComponentsDesc"));
        ComponentFolderConfig componentFolderConfig = InstallerConfig.getCurrentInstance().getComponentRoot();
        this.printFolder(console, componentFolderConfig, 1, "");
        while (true) {
            String string = console.askString(this.getMessage("ConsoleMultipleSelectionLabel"), this.defaultConsoleSelection);
            HashSet hashSet = new HashSet();
            try {
                StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken().trim();
                    int n = Integer.parseInt(string2);
                    Object v = this.indexToComponentNodeConfig.get(new Integer(n));
                    if (v == null) {
                        throw new NumberFormatException("not available");
                    }
                    hashSet.add(v);
                }
                hashSet.addAll(this.mandatoryComponents);
                componentFolderConfig.setSelected(false);
                this.updateTree(hashSet, componentFolderConfig);
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                continue;
            }
            break;
        }
    }

    private void updateTree(Set set, ComponentFolderConfig componentFolderConfig) {
        for (int i = 0; i < componentFolderConfig.getComponents().size(); ++i) {
            ComponentNodeConfig componentNodeConfig;
            componentNodeConfig.setSelected(set.contains(componentNodeConfig = (ComponentNodeConfig)componentFolderConfig.getComponents().get(i)) || componentFolderConfig.isIncluded());
            if (!(componentNodeConfig instanceof ComponentFolderConfig)) continue;
            this.updateTree(set, (ComponentFolderConfig)componentNodeConfig);
        }
    }

    private int printFolder(Console console, ComponentFolderConfig componentFolderConfig, int n, String string) {
        for (int i = 0; i < componentFolderConfig.getComponents().size(); ++i) {
            ComponentNodeConfig componentNodeConfig = (ComponentNodeConfig)componentFolderConfig.getComponents().get(i);
            n = this.printNode(n, componentNodeConfig, console, string);
            if (!(componentNodeConfig instanceof ComponentFolderConfig)) continue;
            n = this.printFolder(console, (ComponentFolderConfig)componentNodeConfig, n, string + "      ");
        }
        return n;
    }

    private int printNode(int n, ComponentNodeConfig componentNodeConfig, Console console, String string) {
        boolean bl;
        boolean bl2 = bl = componentNodeConfig instanceof ComponentConfig && !((ComponentConfig)componentNodeConfig).isChangeable();
        if (!bl || componentNodeConfig.isSelected()) {
            console.println(string + (bl ? "*" : String.valueOf(n)) + ": " + componentNodeConfig.getName());
            if (componentNodeConfig instanceof ComponentFolderConfig) {
                componentNodeConfig.setSelected(false);
            }
            if (bl) {
                this.mandatoryComponents.add(componentNodeConfig);
            } else {
                if (componentNodeConfig.isSelected()) {
                    this.defaultConsoleSelection = this.defaultConsoleSelection == null ? "" : this.defaultConsoleSelection + ",";
                    this.defaultConsoleSelection = this.defaultConsoleSelection + n;
                }
                this.indexToComponentNodeConfig.put(new Integer(n++), componentNodeConfig);
            }
        }
        return n;
    }

    protected void addScreenContent(JPanel jPanel, GridBagConstraints gridBagConstraints) {
        this.addDisplayTextArea(MessageFormat.format(this.getMessage("SelectComponentsLabel2"), this.getApplicationName()), jPanel, gridBagConstraints);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        jPanel.add((Component)this.scpTree, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weighty = 0.0;
        if (this.showInstallationDirectoryChooser) {
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.anchor = InstallerUtil.isAtLeastJava16() ? 512 : 18;
            gridBagConstraints.insets.right = 5;
            jPanel.add((Component)new JLabel(this.getMessage("ReadyMemoDir")), gridBagConstraints);
            gridBagConstraints.insets.right = 0;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 1.0;
            jPanel.add((Component)this.installationDirectorySelector, gridBagConstraints);
        }
    }

    protected int getMaxGridWidth() {
        return 2;
    }

    protected void setupControls() {
        super.setupControls();
        this.tree = new InstallationComponentTree(this);
        this.scpTree = new JScrollPane(this.tree);
        if (this.showInstallationDirectoryChooser) {
            this.installationDirectorySelector.createComponent();
        }
    }

    public void nodeToggled() {
        if (this.showInstallationDirectoryChooser) {
            this.installationDirectorySelector.update();
        }
    }
}

