/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.screens;

import com.install4j.api.Util;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.screens.Console;
import com.install4j.runtime.beans.screens.CustomizableScreen;
import com.install4j.runtime.installer.frontend.components.ProgramGroupSelector;
import java.awt.Component;
import java.awt.GridBagConstraints;
import javax.swing.JPanel;

public class CustomizableProgramGroupScreen
extends CustomizableScreen {
    private String variableName = "";
    private String initialProgramGroup = "";
    private boolean allUsers = false;
    private String infoText = "";
    private ProgramGroupSelector programGroupSelector;
    private boolean initialized;

    public String getVariableName() {
        return this.variableName;
    }

    public void setVariableName(String string) {
        this.variableName = string;
    }

    public String getInitialProgramGroup() {
        return CustomizableProgramGroupScreen.replaceVariables(this.initialProgramGroup);
    }

    public void setInitialProgramGroup(String string) {
        this.initialProgramGroup = string;
    }

    public boolean isAllUsers() {
        return this.allUsers;
    }

    public void setAllUsers(boolean bl) {
        this.allUsers = bl;
    }

    public String getInfoText() {
        return CustomizableProgramGroupScreen.replaceVariables(this.infoText);
    }

    public void setInfoText(String string) {
        this.infoText = string;
    }

    public boolean isHidden() {
        return !Util.isWindowsInstaller();
    }

    protected void setupControls() {
        super.setupControls();
        this.initProgramGroupSelector();
    }

    private void initProgramGroupSelector() {
        if (this.programGroupSelector == null) {
            this.programGroupSelector = new ProgramGroupSelector(this.allUsers, this.getContext().getWizardContext());
        }
    }

    public boolean handleUnattended() {
        this.initProgramGroupSelector();
        this.setVariable(this.getSelectedProgramGroupName());
        return true;
    }

    private String getUsedInitialProgramGroup() {
        Object object = this.getContext().getVariable(this.getVariableName());
        if (object != null && object instanceof String) {
            return (String)object;
        }
        return this.getInitialProgramGroup();
    }

    public boolean handleConsole(Console console) throws UserCanceledException {
        if (!super.handleConsole(console)) {
            return false;
        }
        this.setVariable(console.askString(null, this.getUsedInitialProgramGroup()));
        return true;
    }

    public void willActivate() {
        super.willActivate();
        this.initializeProgramGroupSelector();
    }

    public boolean next() {
        this.setVariable(this.getSelectedProgramGroupName());
        return super.next();
    }

    protected boolean checkCompleted() {
        return this.programGroupSelector.checkSelectedProgramGroup();
    }

    private void setVariable(String string) {
        this.getContext().setVariable(this.getVariableName(), string);
        this.getContext().registerResponseFileVariable(this.getVariableName());
    }

    private void initializeProgramGroupSelector() {
        if (!this.initialized) {
            this.programGroupSelector.setInitialProgramGroupName(this.getUsedInitialProgramGroup());
            this.initialized = true;
        }
    }

    private String getSelectedProgramGroupName() {
        this.initializeProgramGroupSelector();
        return this.programGroupSelector.getSelectedProgramGroup();
    }

    protected void addScreenContent(JPanel jPanel, GridBagConstraints gridBagConstraints) {
        super.addScreenContent(jPanel, gridBagConstraints);
        this.addDisplayTextArea(this.getInfoText(), jPanel, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        jPanel.add((Component)this.programGroupSelector, gridBagConstraints);
        ++gridBagConstraints.gridy;
    }
}

