/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.screens;

import com.install4j.api.beans.ExternalFile;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.screens.Console;
import com.install4j.runtime.beans.screens.SystemScreen;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.util.HtmlTextPane;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;

public abstract class InfoScreen
extends SystemScreen {
    private HtmlTextPane htmlTextPane;
    private JScrollPane scpInfo;
    private String displayedText = "";
    private ExternalFile displayedTextFile = null;
    private String actualText;
    private boolean allRead = false;

    protected abstract String getHeaderText();

    protected abstract String getConsoleText();

    protected abstract boolean handleConsoleQuestion(Console var1) throws UserCanceledException;

    public String getDisplayedText() {
        return InfoScreen.replaceVariables(this.displayedText);
    }

    public void setDisplayedText(String string) {
        this.displayedText = string;
    }

    public ExternalFile getDisplayedTextFile() {
        return this.displayedTextFile;
    }

    public void setDisplayedTextFile(ExternalFile externalFile) {
        this.displayedTextFile = externalFile;
    }

    public String getActualText() {
        return this.actualText;
    }

    public void willActivate() {
        super.willActivate();
        this.updateText();
    }

    public boolean isAllRead() {
        return this.allRead;
    }

    protected void setupControls() {
        super.setupControls();
        this.htmlTextPane = new HtmlTextPane();
        this.scpInfo = new JScrollPane(this.htmlTextPane);
        this.scpInfo.getViewport().setBackground(Color.white);
    }

    protected void setupEventHandlers() {
        super.setupEventHandlers();
        this.scpInfo.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                InfoScreen.this.checkAllRead();
            }
        });
    }

    private void checkAllRead() {
        JScrollBar jScrollBar = this.scpInfo.getVerticalScrollBar();
        if (jScrollBar.getValue() + jScrollBar.getModel().getExtent() == jScrollBar.getMaximum()) {
            this.allRead = true;
        }
    }

    public boolean handleConsole(Console console) throws UserCanceledException {
        if (!super.handleConsole(console)) {
            return false;
        }
        String string = this.getOrLoadText();
        console.println(this.getConsoleText());
        console.println();
        console.more(string);
        console.println();
        this.actualText = string;
        return this.handleConsoleQuestion(console);
    }

    private void updateText() {
        String string = this.getOrLoadText();
        if (!string.equals(this.actualText)) {
            this.actualText = string;
            this.htmlTextPane.updateText(this.actualText);
            this.allRead = false;
            this.checkAllRead();
        }
    }

    private String getOrLoadText() {
        String string;
        if (this.getDisplayedText().trim().length() > 0) {
            string = this.getDisplayedText();
        } else {
            string = InfoScreen.replaceVariables(InstallerUtil.loadFile(this.getContext().getExternalFile(this.getDisplayedTextFile(), false), this.getContext().getLanguageId()));
            if (string == null) {
                string = "";
            }
        }
        return string;
    }

    protected void addScreenContent(JPanel jPanel, GridBagConstraints gridBagConstraints) {
        String string = this.getHeaderText();
        if (string.length() > 0) {
            this.addDisplayTextArea(string, jPanel, gridBagConstraints);
        }
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets.bottom = 10;
        jPanel.add((Component)this.scpInfo, gridBagConstraints);
        ++gridBagConstraints.gridy;
    }
}

