/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer;

import com.exe4j.runtime.util.ResourceHelper;
import com.install4j.api.Util;
import com.install4j.runtime.installer.Installer;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.controller.Controller;
import com.install4j.runtime.installer.controller.ScreenExecutor;
import com.install4j.runtime.installer.helper.ClasspathModificator;
import com.install4j.runtime.installer.helper.InstallerUtil;
import java.io.File;
import java.io.IOException;

public class Application {
    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            System.err.println("Please provide the application id as first argument");
            System.exit(1);
        }
        try {
            InstallerConfig.setCurrentApplicationId(stringArray[0]);
            String[] stringArray2 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray2, 0, stringArray.length - 1);
            ScreenExecutor screenExecutor = Installer.getScreenExecutor(stringArray2);
            InstallerConfig installerConfig = InstallerConfig.getCurrentInstance();
            File file = new File(ResourceHelper.getRuntimeDir(), "..");
            if (Util.isMacOS() && installerConfig.getMacSpecificConfig().isSingleBundle()) {
                file = new File(file, "../../../..");
            }
            try {
                file = file.getCanonicalFile();
            }
            catch (IOException iOException) {
                file = file.getAbsoluteFile();
            }
            installerConfig.setInstallationDirectory(file);
            ClasspathModificator.addCustomJarsToClasspath(screenExecutor.getContext());
            new Controller(screenExecutor).start();
        }
        catch (Throwable throwable) {
            InstallerUtil.reportException(throwable);
            System.exit(1);
        }
    }
}

