/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.config;

import com.install4j.api.beans.Bean;
import com.install4j.api.beans.ReplacementMode;
import com.install4j.runtime.installer.InstallerVariables;
import com.install4j.runtime.installer.config.AbstractConfig;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.xmldecode.XMLDecoder;
import java.util.Iterator;
import java.util.Map;
import nanoxml.XMLElement;

public abstract class AbstractBeanConfig
extends AbstractConfig {
    private static final String ELEMENT_STRING = "string";
    protected String id;
    private XMLElement javaElement;
    private String conditionClassName = "";
    private boolean rollbackBarrier = false;

    public String getId() {
        return this.id;
    }

    public String getConditionClassName() {
        return this.conditionClassName;
    }

    public boolean isRollbackBarrier() {
        return this.rollbackBarrier;
    }

    public abstract boolean isInstantiated();

    protected Bean instantiateBean(boolean bl) {
        this.replaceRuntimeVariables(this.javaElement);
        XMLDecoder xMLDecoder = new XMLDecoder(this.javaElement);
        try {
            return (Bean)xMLDecoder.readObject();
        }
        catch (Throwable throwable) {
            if (!bl) {
                Logger.getInstance().error(null, "Exception during instantiation of bean ID " + this.id);
                InstallerUtil.reportException(throwable);
                System.exit(1);
            }
            return null;
        }
    }

    private void replaceRuntimeVariables(XMLElement xMLElement) {
        if (xMLElement.getName().equals(ELEMENT_STRING)) {
            String string = InstallerVariables.replaceVariables(xMLElement.getContent(), ReplacementMode.I18N_ONLY);
            xMLElement.setContent(string);
        } else {
            Iterator iterator = xMLElement.getChildren().iterator();
            while (iterator.hasNext()) {
                XMLElement xMLElement2 = (XMLElement)iterator.next();
                this.replaceRuntimeVariables(xMLElement2);
            }
        }
    }

    protected void read(XMLElement xMLElement) {
        this.id = AbstractBeanConfig.readAttribute(xMLElement, "id", this.id);
        this.rollbackBarrier = AbstractBeanConfig.readAttribute(xMLElement, "rollbackBarrier", this.rollbackBarrier);
        this.conditionClassName = AbstractBeanConfig.readAttribute(xMLElement, "conditionClass", this.conditionClassName);
        this.javaElement = this.findChild(xMLElement, "java");
    }

    public void addAllTo(Map map) {
        map.put(this.getId(), this);
    }
}

