/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.config;

import com.install4j.runtime.installer.InstallerVariables;
import com.install4j.runtime.installer.config.AbstractConfig;
import java.util.Iterator;
import java.util.WeakHashMap;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import nanoxml.XMLElement;

public abstract class ComponentNodeConfig
extends AbstractConfig {
    private ComponentNodeConfig parent;
    private String id = "";
    private String name = "";
    private boolean selected = true;
    private String description = "";
    private boolean displayDescription;
    private WeakHashMap listeners = new WeakHashMap();

    protected ComponentNodeConfig(ComponentNodeConfig componentNodeConfig) {
        this.parent = componentNodeConfig;
        this.displayDescription = this.getDefaultDisplayDescriptionValue();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }

    public String getName() {
        return InstallerVariables.replaceVariables(this.name);
    }

    public void setName(String string) {
        this.name = string;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean bl) {
        this.selected = bl;
        this.notifyListeners();
    }

    public String getDescription() {
        return InstallerVariables.replaceVariables(this.description);
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public boolean isDisplayDescription() {
        return this.displayDescription;
    }

    public void setDisplayDescription(boolean bl) {
        this.displayDescription = bl;
    }

    public boolean isIncluded() {
        return this.isSelected() || this.parent != null && this.parent.isIncluded();
    }

    protected boolean getDefaultDisplayDescriptionValue() {
        return false;
    }

    protected void read(XMLElement xMLElement) {
        this.name = ComponentNodeConfig.readAttribute(xMLElement, "name", this.name);
        this.id = ComponentNodeConfig.readAttribute(xMLElement, "id", this.name);
        this.selected = ComponentNodeConfig.readAttribute(xMLElement, "selected", this.selected);
        this.displayDescription = ComponentNodeConfig.readAttribute(xMLElement, "displayDescription", this.displayDescription);
        Iterator iterator = xMLElement.getChildren().iterator();
        while (iterator.hasNext()) {
            XMLElement xMLElement2 = (XMLElement)iterator.next();
            String string = xMLElement2.getName();
            if (!string.equals("description")) continue;
            this.description = xMLElement2.getContent();
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listeners.put(changeListener, null);
    }

    protected void notifyListeners() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        Iterator iterator = this.listeners.keySet().iterator();
        while (iterator.hasNext()) {
            ChangeListener changeListener = (ChangeListener)iterator.next();
            if (changeListener == null) continue;
            changeListener.stateChanged(changeEvent);
        }
    }
}

