/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.config;

import com.install4j.runtime.beans.groups.Group;
import com.install4j.runtime.installer.config.AbstractBeanConfig;
import com.install4j.runtime.installer.config.ActionBeanConfig;
import com.install4j.runtime.installer.config.FormComponentBeanConfig;
import com.install4j.runtime.installer.config.LinkActionBeanConfig;
import com.install4j.runtime.installer.config.LinkGroupBeanConfig;
import com.install4j.runtime.installer.config.LinkScreenBeanConfig;
import com.install4j.runtime.installer.config.ScreenBeanConfig;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import nanoxml.XMLElement;

public class GroupBeanConfig
extends AbstractBeanConfig {
    private Group instance;
    private List beanConfigs;
    private boolean screenGroup;

    public GroupBeanConfig(boolean bl) {
        this.screenGroup = bl;
    }

    public Group getOrInstantiateGroup(boolean bl) {
        if (this.instance == null) {
            this.instance = (Group)this.instantiateBean(bl);
        }
        return this.instance;
    }

    public List getBeanConfigs() {
        return this.beanConfigs;
    }

    public boolean isInstantiated() {
        return this.instance != null;
    }

    protected void read(XMLElement xMLElement) {
        super.read(xMLElement);
        this.readBeanConfigs(xMLElement);
    }

    private void readBeanConfigs(XMLElement xMLElement) {
        LinkedList<ActionBeanConfig> linkedList = new LinkedList<ActionBeanConfig>();
        XMLElement xMLElement2 = this.findChild(xMLElement, "beans");
        if (xMLElement2 != null) {
            Iterator iterator = xMLElement2.getChildren().iterator();
            while (iterator.hasNext()) {
                AbstractBeanConfig abstractBeanConfig;
                XMLElement xMLElement3 = (XMLElement)iterator.next();
                String string = xMLElement3.getName();
                if (string.equalsIgnoreCase("action")) {
                    abstractBeanConfig = new ActionBeanConfig();
                } else if (string.equalsIgnoreCase("screen")) {
                    abstractBeanConfig = new ScreenBeanConfig();
                } else if (string.equalsIgnoreCase("link")) {
                    abstractBeanConfig = GroupBeanConfig.readAttribute(xMLElement3, "group", false) ? new LinkGroupBeanConfig(this.screenGroup) : (this.screenGroup ? new LinkScreenBeanConfig() : new LinkActionBeanConfig());
                } else if (string.equalsIgnoreCase("formComponent")) {
                    abstractBeanConfig = new FormComponentBeanConfig();
                } else {
                    if (!string.equalsIgnoreCase("group")) continue;
                    abstractBeanConfig = new GroupBeanConfig(this.screenGroup);
                }
                ((AbstractBeanConfig)abstractBeanConfig).read(xMLElement3);
                linkedList.add((ActionBeanConfig)abstractBeanConfig);
            }
        }
        this.beanConfigs = Collections.unmodifiableList(linkedList);
    }

    public void addAllTo(Map map) {
        super.addAllTo(map);
        Iterator iterator = this.beanConfigs.iterator();
        while (iterator.hasNext()) {
            ((AbstractBeanConfig)iterator.next()).addAllTo(map);
        }
    }
}

