/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.config.update;

import com.install4j.api.update.UpdateDescriptorEntry;
import com.install4j.runtime.installer.config.AbstractConfig;
import com.install4j.runtime.util.VersionCheck;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.Iterator;
import nanoxml.XMLElement;

public class UpdateDescriptorEntryImpl
extends AbstractConfig
implements UpdateDescriptorEntry {
    public static final String ELEMENT_ENTRY = "entry";
    public static final String ELEMENT_COMMENT = "comment";
    public static final String ATTRIBUTE_TARGET_MEDIA_FILE_ID = "targetMediaFileId";
    public static final String ATTRIBUTE_UPDATABLE_VERSION_MIN = "updatableVersionMin";
    public static final String ATTRIBUTE_UPDATABLE_VERSION_MAX = "updatableVersionMax";
    public static final String ATTRIBUTE_FILE_NAME = "fileName";
    public static final String ATTRIBUTE_NEW_VERSION = "newVersion";
    public static final String ATTRIBUTE_NEW_MEDIA_FILE_ID = "newMediaFileId";
    public static final String ATTRIBUTE_FILE_SIZE = "fileSize";
    public static final String ATTRIBUTE_BUNDLED_JRE = "bundledJre";
    public static final String ATTRIBUTE_ARCHIVE = "archive";
    private static final DecimalFormat DEFAULT_TRUNCATED_FORMAT = new DecimalFormat("#0.0");
    private String targetMediaFileId = "";
    private String updatableVersionMin = "";
    private String updatableVersionMax = "";
    private String fileName = "";
    private String newVersion = "";
    private String newMediaFileId = "";
    private long fileSize = -1L;
    private String bundledJre = "";
    private String comment = "";
    private boolean archive = false;
    private XMLElement element;
    private URL url;

    public UpdateDescriptorEntryImpl() {
    }

    public UpdateDescriptorEntryImpl(String string, String string2, String string3, long l, String string4, boolean bl) {
        this.targetMediaFileId = string;
        this.fileName = string2;
        this.newVersion = string3;
        this.fileSize = l;
        this.bundledJre = string4;
        this.newMediaFileId = string;
        this.archive = bl;
    }

    protected void read(XMLElement xMLElement) {
        this.element = xMLElement;
        this.targetMediaFileId = UpdateDescriptorEntryImpl.readAttribute(xMLElement, ATTRIBUTE_TARGET_MEDIA_FILE_ID, this.targetMediaFileId);
        this.updatableVersionMin = UpdateDescriptorEntryImpl.readAttribute(xMLElement, ATTRIBUTE_UPDATABLE_VERSION_MIN, this.updatableVersionMin);
        this.updatableVersionMax = UpdateDescriptorEntryImpl.readAttribute(xMLElement, ATTRIBUTE_UPDATABLE_VERSION_MAX, this.updatableVersionMax);
        this.fileName = UpdateDescriptorEntryImpl.readAttribute(xMLElement, ATTRIBUTE_FILE_NAME, this.fileName);
        this.newVersion = UpdateDescriptorEntryImpl.readAttribute(xMLElement, ATTRIBUTE_NEW_VERSION, this.newVersion);
        this.newMediaFileId = UpdateDescriptorEntryImpl.readAttribute(xMLElement, ATTRIBUTE_NEW_MEDIA_FILE_ID, this.newMediaFileId);
        this.fileSize = UpdateDescriptorEntryImpl.readAttribute(xMLElement, ATTRIBUTE_FILE_SIZE, this.fileSize);
        this.bundledJre = UpdateDescriptorEntryImpl.readAttribute(xMLElement, ATTRIBUTE_BUNDLED_JRE, this.bundledJre);
        this.archive = UpdateDescriptorEntryImpl.readAttribute(xMLElement, ATTRIBUTE_ARCHIVE, this.archive);
        Iterator iterator = xMLElement.getChildren().iterator();
        while (iterator.hasNext()) {
            XMLElement xMLElement2 = (XMLElement)iterator.next();
            if (!ELEMENT_COMMENT.equals(xMLElement2.getName())) continue;
            this.comment = xMLElement2.getContent().trim();
            break;
        }
    }

    public void setURL(URL uRL) {
        this.url = uRL;
    }

    public URL getURL() {
        return this.url;
    }

    public boolean isArchive() {
        return this.archive;
    }

    public String getAdditionalAttribute(String string, String string2) {
        return UpdateDescriptorEntryImpl.readAttribute(this.element, string, string2);
    }

    public String getTargetMediaFileId() {
        return this.targetMediaFileId;
    }

    public void setTargetMediaFileId(String string) {
        this.targetMediaFileId = string;
    }

    public String getUpdatableVersionMin() {
        return this.updatableVersionMin;
    }

    public void setUpdatableVersionMin(String string) {
        this.updatableVersionMin = string;
    }

    public String getUpdatableVersionMax() {
        return this.updatableVersionMax;
    }

    public void setUpdatableVersionMax(String string) {
        this.updatableVersionMax = string;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    public String getNewVersion() {
        return this.newVersion;
    }

    public void setNewVersion(String string) {
        this.newVersion = string;
    }

    public String getNewMediaFileId() {
        return this.newMediaFileId;
    }

    public void setNewMediaFileId(String string) {
        this.newMediaFileId = string;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public String getFileSizeVerbose() {
        if (this.fileSize / 1024L / 1024L > 0L) {
            return DEFAULT_TRUNCATED_FORMAT.format(1.0 * (double)this.fileSize / 1024.0 / 1024.0) + " MB";
        }
        return String.valueOf(this.fileSize / 1024L) + " KB";
    }

    public void setFileSize(long l) {
        this.fileSize = l;
    }

    public String getBundledJre() {
        return this.bundledJre;
    }

    public void setBundledJre(String string) {
        this.bundledJre = string;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String string) {
        this.comment = string;
    }

    public String toString() {
        return "UpdateDescriptorEntry [target: " + this.targetMediaFileId + ", file: " + this.getFileName() + "]";
    }

    public boolean checkVersionCompatible(String string) {
        String string2 = this.updatableVersionMin.trim();
        if (string2.length() > 0 && !VersionCheck.checkCompatible(string2, string)) {
            return false;
        }
        String string3 = this.updatableVersionMax.trim();
        if (string3.length() > 0 && !VersionCheck.checkCompatible(string, string3)) {
            return false;
        }
        return !string.equals(this.newVersion) && VersionCheck.checkCompatible(string, this.newVersion);
    }
}

